/*
Navicat MySQL Data Transfer

Source Server         : localhost_3306
Source Server Version : 50553
Source Host           : localhost:3306
Source Database       : siruiadmin

Target Server Type    : MYSQL
Target Server Version : 50553
File Encoding         : 65001

Date: 2020-03-11 22:33:18
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `sr_ad`
-- ----------------------------
DROP TABLE IF EXISTS `sr_ad`;
CREATE TABLE `sr_ad` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '广告表主键ID',
  `title` varchar(255) DEFAULT NULL COMMENT '广告标题',
  `place` tinyint(1) NOT NULL DEFAULT '0' COMMENT '对应position',
  `is_active` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否有效【0:无效;1:有效;】',
  `ctime` int(11) DEFAULT NULL COMMENT '创建时间',
  `mtime` int(11) DEFAULT NULL COMMENT '更新时间',
  `display_order` smallint(2) NOT NULL DEFAULT '0' COMMENT '排序值',
  `display_type` tinyint(1) unsigned DEFAULT '1' COMMENT '广告类型【1:HTML;2:代码;3:轮播;】',
  `content` text COMMENT '广告位内容',
  `is_del` tinyint(1) DEFAULT '0',
  `del_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='广告位表';

-- ----------------------------
-- Records of sr_ad
-- ----------------------------

-- ----------------------------
-- Table structure for `sr_attach`
-- ----------------------------
DROP TABLE IF EXISTS `sr_attach`;
CREATE TABLE `sr_attach` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '附件表主键ID',
  `module` char(15) DEFAULT 'attach' COMMENT '应用名称',
  `attach_type` varchar(20) NOT NULL COMMENT '标识,用于分类等',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '附件上传用户，关联用户表（sr_user）主键UID',
  `ctime` int(11) NOT NULL COMMENT '上传时间',
  `name` varchar(255) DEFAULT NULL COMMENT '附件名称',
  `type` varchar(255) DEFAULT NULL COMMENT '附件格式',
  `size` varchar(20) DEFAULT NULL COMMENT '附件大小',
  `extension` varchar(20) DEFAULT NULL COMMENT '附件扩展名',
  `hash` varchar(32) DEFAULT NULL COMMENT '附件哈希值',
  `save_path` varchar(255) DEFAULT NULL COMMENT '保存路径',
  `save_name` varchar(255) DEFAULT NULL COMMENT '保存名称',
  `save_domain` tinyint(3) DEFAULT '0' COMMENT '附件保存的域ID（用于拆分附件存储到不同的服务器）',
  `from` tinyint(3) NOT NULL COMMENT '来源类型【0:网站;1:手机网页版;2:android;3:iphone;】',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '标记删除【0:没删除;1:已删除】',
  `del_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `userId` (`uid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 COMMENT='附件表';

-- ----------------------------
-- Records of sr_attach
-- ----------------------------
INSERT INTO `sr_attach` VALUES ('49', 'admin', 'site_logo', '1', '1583916781', '微信图片_20191108154942.jpg', 'image/jpeg', '206970', 'jpg', 'c03bc4e0a320be3d2ec77fce743c5b51', '2020/03/11', '5e68a6eceb42b.jpg', '0', '0', '0', '0');
INSERT INTO `sr_attach` VALUES ('50', 'admin', 'wx_qrcode', '1', '1583917222', '1575515880(1).jpg', 'image/jpeg', '10210', 'jpg', '29e0a7de7f6287b138e679731763fba1', '2020/03/11', '5e68a8a6b4a37.jpg', '0', '0', '0', '0');
INSERT INTO `sr_attach` VALUES ('51', 'admin', 'topic_cover', '1', '1583925914', '1575515880(1).jpg', 'image/jpeg', '10210', 'jpg', '29e0a7de7f6287b138e679731763fba1', '2020/03/11', '5e68ca9a5618f.jpg', '0', '0', '0', '0');

-- ----------------------------
-- Table structure for `sr_config_data`
-- ----------------------------
DROP TABLE IF EXISTS `sr_config_data`;
CREATE TABLE `sr_config_data` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '系统配置数据表主键ID',
  `list` char(50) DEFAULT 'default' COMMENT '列表名',
  `key` char(100) DEFAULT 'default' COMMENT '键名',
  `value` text COMMENT '键值',
  `mtime` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `list_key` (`list`,`key`) USING BTREE,
  KEY `list_id` (`list`,`id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=26827 DEFAULT CHARSET=utf8 COMMENT='系统配置表';

-- ----------------------------
-- Records of sr_config_data
-- ----------------------------
INSERT INTO `sr_config_data` VALUES ('26826', 'admin_sysconfig', 'site', 'a:14:{s:8:\"web_open\";i:0;s:9:\"site_name\";s:12:\"思睿软件\";s:13:\"site_keywords\";s:0:\"\";s:11:\"site_slogan\";s:0:\"\";s:16:\"site_home_slogan\";s:0:\"\";s:16:\"site_description\";s:0:\"\";s:14:\"site_copyright\";s:0:\"\";s:9:\"site_logo\";i:0;s:16:\"site_logo_mobile\";i:0;s:9:\"wx_qrcode\";i:50;s:7:\"site_qq\";s:0:\"\";s:10:\"site_phone\";s:0:\"\";s:19:\"site_analytics_open\";i:0;s:19:\"site_analytics_code\";s:0:\"\";}', '2020-03-11 19:42:41');
INSERT INTO `sr_config_data` VALUES ('26821', 'admin_sysconfig', 'attach', 'a:3:{s:15:\"attach_max_size\";d:20;s:22:\"attach_allow_extension\";s:29:\"jpg,png,bmp,cert,key,perm,rar\";s:11:\"real_delete\";N;}', '2020-03-11 16:44:35');
INSERT INTO `sr_config_data` VALUES ('26822', 'admin_sysconfig', 'attachimage', 'a:2:{s:15:\"attach_max_size\";d:2;s:22:\"attach_allow_extension\";s:15:\"jpg,png,bmp,gif\";}', '2020-03-11 16:44:52');

-- ----------------------------
-- Table structure for `sr_goods_category`
-- ----------------------------
DROP TABLE IF EXISTS `sr_goods_category`;
CREATE TABLE `sr_goods_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品分类表主键ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '分类名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `icon` int(11) DEFAULT NULL COMMENT '一、二级分类封面',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='商品分类表';

-- ----------------------------
-- Records of sr_goods_category
-- ----------------------------
INSERT INTO `sr_goods_category` VALUES ('1', '0', '哈哈哈', '0', '0');

-- ----------------------------
-- Table structure for `sr_logs`
-- ----------------------------
DROP TABLE IF EXISTS `sr_logs`;
CREATE TABLE `sr_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `uname` varchar(255) NOT NULL,
  `module` varchar(255) NOT NULL,
  `controller` varchar(255) NOT NULL,
  `action` varchar(255) NOT NULL,
  `info` varchar(255) DEFAULT NULL,
  `type` tinyint(1) DEFAULT '0' COMMENT '0:前端 1:后台',
  `ip` varchar(100) DEFAULT NULL,
  `ctime` int(11) NOT NULL,
  `is_del` tinyint(1) DEFAULT '0',
  `del_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE,
  KEY `uname` (`uname`(250)) USING BTREE,
  KEY `type` (`type`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=308 DEFAULT CHARSET=utf8mb4 COMMENT='操作日志';

-- ----------------------------
-- Records of sr_logs
-- ----------------------------
INSERT INTO `sr_logs` VALUES ('1', '1', 'admin', 'admin', 'Common', 'dologin', '登录', '1', '127.0.0.1', '1580970582', '0', '0');
INSERT INTO `sr_logs` VALUES ('2', '1', 'admin', 'admin', 'Common', 'dologin', '登录', '1', '127.0.0.1', '1580970754', '0', '0');
INSERT INTO `sr_logs` VALUES ('3', '1', 'admin', 'admin', 'Common', 'dologin', '登录', '1', '127.0.0.1', '1580970769', '0', '0');
INSERT INTO `sr_logs` VALUES ('4', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580971529', '0', '0');
INSERT INTO `sr_logs` VALUES ('5', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580971543', '0', '0');
INSERT INTO `sr_logs` VALUES ('6', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580971633', '0', '0');
INSERT INTO `sr_logs` VALUES ('7', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580971676', '0', '0');
INSERT INTO `sr_logs` VALUES ('8', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580976874', '0', '0');
INSERT INTO `sr_logs` VALUES ('9', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580977050', '0', '0');
INSERT INTO `sr_logs` VALUES ('10', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580977104', '0', '0');
INSERT INTO `sr_logs` VALUES ('11', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580977248', '0', '0');
INSERT INTO `sr_logs` VALUES ('12', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580978621', '0', '0');
INSERT INTO `sr_logs` VALUES ('13', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580978640', '0', '0');
INSERT INTO `sr_logs` VALUES ('14', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580978649', '0', '0');
INSERT INTO `sr_logs` VALUES ('15', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580989054', '0', '0');
INSERT INTO `sr_logs` VALUES ('16', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580991448', '0', '0');
INSERT INTO `sr_logs` VALUES ('17', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580994892', '0', '0');
INSERT INTO `sr_logs` VALUES ('18', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580995009', '0', '0');
INSERT INTO `sr_logs` VALUES ('19', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580995060', '0', '0');
INSERT INTO `sr_logs` VALUES ('20', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580995091', '0', '0');
INSERT INTO `sr_logs` VALUES ('21', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580995298', '0', '0');
INSERT INTO `sr_logs` VALUES ('22', '1', 'admin', 'admin', 'Common', 'login', '登录成功', '1', '127.0.0.1', '1580995305', '0', '0');
INSERT INTO `sr_logs` VALUES ('23', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580995493', '0', '0');
INSERT INTO `sr_logs` VALUES ('24', '1', 'admin', 'admin', 'Index', 'index', '登录成功', '1', '127.0.0.1', '1580995505', '0', '0');
INSERT INTO `sr_logs` VALUES ('25', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1580995528', '0', '0');
INSERT INTO `sr_logs` VALUES ('26', '1', 'admin', 'admin', 'Common', 'login', '登录成功', '1', '127.0.0.1', '1581036487', '0', '0');
INSERT INTO `sr_logs` VALUES ('27', '1', 'admin', 'admin', 'Index', 'index', '登录成功', '1', '127.0.0.1', '1581068334', '0', '0');
INSERT INTO `sr_logs` VALUES ('28', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581084326', '0', '0');
INSERT INTO `sr_logs` VALUES ('29', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:74', '1', '127.0.0.1', '1581085411', '0', '0');
INSERT INTO `sr_logs` VALUES ('30', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581085600', '0', '0');
INSERT INTO `sr_logs` VALUES ('31', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:76', '1', '127.0.0.1', '1581085706', '0', '0');
INSERT INTO `sr_logs` VALUES ('32', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:76', '1', '127.0.0.1', '1581085768', '0', '0');
INSERT INTO `sr_logs` VALUES ('33', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:76', '1', '127.0.0.1', '1581086040', '0', '0');
INSERT INTO `sr_logs` VALUES ('34', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:76', '1', '127.0.0.1', '1581086087', '0', '0');
INSERT INTO `sr_logs` VALUES ('35', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581086117', '0', '0');
INSERT INTO `sr_logs` VALUES ('36', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581086315', '0', '0');
INSERT INTO `sr_logs` VALUES ('37', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:78', '1', '127.0.0.1', '1581086478', '0', '0');
INSERT INTO `sr_logs` VALUES ('38', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581086484', '0', '0');
INSERT INTO `sr_logs` VALUES ('39', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581086534', '0', '0');
INSERT INTO `sr_logs` VALUES ('40', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:75', '1', '127.0.0.1', '1581087866', '0', '0');
INSERT INTO `sr_logs` VALUES ('41', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:80', '1', '127.0.0.1', '1581087878', '0', '0');
INSERT INTO `sr_logs` VALUES ('42', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:79', '1', '127.0.0.1', '1581087884', '0', '0');
INSERT INTO `sr_logs` VALUES ('43', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:81', '1', '127.0.0.1', '1581087887', '0', '0');
INSERT INTO `sr_logs` VALUES ('44', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:77', '1', '127.0.0.1', '1581087941', '0', '0');
INSERT INTO `sr_logs` VALUES ('45', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:76', '1', '127.0.0.1', '1581087944', '0', '0');
INSERT INTO `sr_logs` VALUES ('46', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:39', '1', '127.0.0.1', '1581088761', '0', '0');
INSERT INTO `sr_logs` VALUES ('47', '1', 'admin', 'admin', 'Index', 'index', '登录成功', '1', '127.0.0.1', '1581126684', '0', '0');
INSERT INTO `sr_logs` VALUES ('48', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:30', '1', '127.0.0.1', '1581127580', '0', '0');
INSERT INTO `sr_logs` VALUES ('49', '1', 'admin', 'admin', 'Usergroup', 'publish', '添加用户组,id:24', '1', '127.0.0.1', '1581143564', '0', '0');
INSERT INTO `sr_logs` VALUES ('50', '1', 'admin', 'admin', 'Usergroup', 'publish', '编辑用户组,id:24', '1', '127.0.0.1', '1581143753', '0', '0');
INSERT INTO `sr_logs` VALUES ('51', '1', 'admin', 'admin', 'Usergroup', 'publish', '编辑用户组,id:24', '1', '127.0.0.1', '1581143760', '0', '0');
INSERT INTO `sr_logs` VALUES ('52', '1', 'admin', 'admin', 'Usergroup', 'delete', '删除用户组,id:24', '1', '127.0.0.1', '1581143767', '0', '0');
INSERT INTO `sr_logs` VALUES ('53', '1', 'admin', 'admin', 'Usergroup', 'delete', '删除用户组,id:23', '1', '127.0.0.1', '1581143998', '0', '0');
INSERT INTO `sr_logs` VALUES ('54', '1', 'admin', 'admin', 'Usergroup', 'delete', '删除用户组,id:22', '1', '127.0.0.1', '1581144003', '0', '0');
INSERT INTO `sr_logs` VALUES ('55', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:42', '1', '127.0.0.1', '1581156992', '0', '0');
INSERT INTO `sr_logs` VALUES ('56', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581157916', '0', '0');
INSERT INTO `sr_logs` VALUES ('57', '1', 'admin', 'admin', 'Uservip', 'publish', '编辑会员等级,id:1', '1', '127.0.0.1', '1581158525', '0', '0');
INSERT INTO `sr_logs` VALUES ('58', '1', 'admin', 'admin', 'Uservip', 'publish', '添加会员等级,id:0', '1', '127.0.0.1', '1581162838', '0', '0');
INSERT INTO `sr_logs` VALUES ('59', '1', 'admin', 'admin', 'Uservip', 'delete', '删除会员等级,id:4', '1', '127.0.0.1', '1581162892', '0', '0');
INSERT INTO `sr_logs` VALUES ('60', '1', 'admin', 'admin', 'Uservip', 'delete', '删除会员等级,id:4', '1', '127.0.0.1', '1581162933', '0', '0');
INSERT INTO `sr_logs` VALUES ('61', '1', 'admin', 'admin', 'Uservip', 'delete', '删除会员等级,id:2', '1', '127.0.0.1', '1581162987', '0', '0');
INSERT INTO `sr_logs` VALUES ('62', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:44', '1', '127.0.0.1', '1581163439', '0', '0');
INSERT INTO `sr_logs` VALUES ('63', '1', 'admin', 'admin', 'Uservip', 'publish', '编辑会员等级,id:3', '1', '127.0.0.1', '1581164205', '0', '0');
INSERT INTO `sr_logs` VALUES ('64', '1', 'admin', 'admin', 'Teachervip', 'publish', '编辑讲师头衔,id:3', '1', '127.0.0.1', '1581164256', '0', '0');
INSERT INTO `sr_logs` VALUES ('65', '1', 'admin', 'admin', 'Teachervip', 'publish', '添加讲师头衔,id:0', '1', '127.0.0.1', '1581164271', '0', '0');
INSERT INTO `sr_logs` VALUES ('66', '1', 'admin', 'admin', 'Teachervip', 'delete', '删除讲师头衔,id:4', '1', '127.0.0.1', '1581164276', '0', '0');
INSERT INTO `sr_logs` VALUES ('67', '1', 'admin', 'admin', 'Usergroup', 'publish', '添加用户组,id:1', '1', '127.0.0.1', '1581164558', '0', '0');
INSERT INTO `sr_logs` VALUES ('68', '1', 'admin', 'admin', 'Sysconfig', 'register', '注册设置', '1', '127.0.0.1', '1581168094', '0', '0');
INSERT INTO `sr_logs` VALUES ('69', '1', 'admin', 'admin', 'Sysconfig', 'register', '注册设置', '1', '127.0.0.1', '1581168555', '0', '0');
INSERT INTO `sr_logs` VALUES ('70', '1', 'admin', 'admin', 'Sysconfig', 'register', '注册设置', '1', '127.0.0.1', '1581168807', '0', '0');
INSERT INTO `sr_logs` VALUES ('71', '1', 'admin', 'admin', 'Sysconfig', 'register', '注册设置', '1', '127.0.0.1', '1581168820', '0', '0');
INSERT INTO `sr_logs` VALUES ('72', '1', 'admin', 'admin', 'Sysconfig', 'commentswitch', '注册设置', '1', '127.0.0.1', '1581169502', '0', '0');
INSERT INTO `sr_logs` VALUES ('73', '1', 'admin', 'admin', 'Sysconfig', 'site', '站点配置修改', '1', '127.0.0.1', '1581171018', '0', '0');
INSERT INTO `sr_logs` VALUES ('74', '1', 'admin', 'admin', 'Sysconfig', 'site', '站点配置修改', '1', '127.0.0.1', '1581171060', '0', '0');
INSERT INTO `sr_logs` VALUES ('75', '1', 'admin', 'admin', 'Sysconfig', 'site', '站点配置修改', '1', '127.0.0.1', '1581171086', '0', '0');
INSERT INTO `sr_logs` VALUES ('76', '1', 'admin', 'admin', 'Sysconfig', 'site', '站点配置修改', '1', '127.0.0.1', '1581171136', '0', '0');
INSERT INTO `sr_logs` VALUES ('77', '1', 'admin', 'admin', 'Sysconfig', 'sms', '短信基本设置', '1', '127.0.0.1', '1581173583', '0', '0');
INSERT INTO `sr_logs` VALUES ('78', '1', 'admin', 'admin', 'Sysconfig', 'alisms', '阿里云短信接口设置', '1', '127.0.0.1', '1581173623', '0', '0');
INSERT INTO `sr_logs` VALUES ('79', '1', 'admin', 'admin', 'Sysconfig', 'alisms', '阿里云短信接口设置', '1', '127.0.0.1', '1581173661', '0', '0');
INSERT INTO `sr_logs` VALUES ('80', '1', 'admin', 'admin', 'Sysconfig', 'alisms', '阿里云短信接口设置', '1', '127.0.0.1', '1581174457', '0', '0');
INSERT INTO `sr_logs` VALUES ('81', '1', 'admin', 'admin', 'Sysconfig', 'wxpublic', '微信公众号设置', '1', '127.0.0.1', '1581174466', '0', '0');
INSERT INTO `sr_logs` VALUES ('82', '1', 'admin', 'admin', 'Sysconfig', 'wxprogram', '微信小程序设置', '1', '127.0.0.1', '1581174510', '0', '0');
INSERT INTO `sr_logs` VALUES ('83', '1', 'admin', 'admin', 'Sysconfig', 'wxprogram', '微信小程序设置', '1', '127.0.0.1', '1581174661', '0', '0');
INSERT INTO `sr_logs` VALUES ('84', '1', 'admin', 'admin', 'Sysconfig', 'wxprogram', '微信小程序设置', '1', '127.0.0.1', '1581174732', '0', '0');
INSERT INTO `sr_logs` VALUES ('85', '1', 'admin', 'admin', 'Sysconfig', 'wxprogram', '微信小程序设置', '1', '127.0.0.1', '1581174759', '0', '0');
INSERT INTO `sr_logs` VALUES ('86', '1', 'admin', 'admin', 'Sysconfig', 'wxprogram', '微信小程序设置', '1', '127.0.0.1', '1581174856', '0', '0');
INSERT INTO `sr_logs` VALUES ('87', '1', 'admin', 'admin', 'Sysconfig', 'wxpublic', '微信公众号设置', '1', '127.0.0.1', '1581174869', '0', '0');
INSERT INTO `sr_logs` VALUES ('88', '1', 'admin', 'admin', 'Sysconfig', 'attach', '上传基本设置', '1', '127.0.0.1', '1581175312', '0', '0');
INSERT INTO `sr_logs` VALUES ('89', '1', 'admin', 'admin', 'Sysconfig', 'attachimage', '上传图片设置', '1', '127.0.0.1', '1581175320', '0', '0');
INSERT INTO `sr_logs` VALUES ('90', '1', 'admin', 'admin', 'Sysconfig', 'marketconfig', '营销数据开关设置', '1', '127.0.0.1', '1581175668', '0', '0');
INSERT INTO `sr_logs` VALUES ('91', '1', 'admin', 'admin', 'Sysconfig', 'marketconfig', '营销数据开关设置', '1', '127.0.0.1', '1581175674', '0', '0');
INSERT INTO `sr_logs` VALUES ('92', '1', 'admin', 'admin', 'Sysconfig', 'marketconfig', '营销数据开关设置', '1', '127.0.0.1', '1581175677', '0', '0');
INSERT INTO `sr_logs` VALUES ('93', '1', 'admin', 'admin', 'Sysconfig', 'audit', '敏感词编辑', '1', '127.0.0.1', '1581176254', '0', '0');
INSERT INTO `sr_logs` VALUES ('94', '1', 'admin', 'admin', 'Sysconfig', 'audit', '敏感词编辑', '1', '127.0.0.1', '1581176266', '0', '0');
INSERT INTO `sr_logs` VALUES ('95', '1', 'admin', 'admin', 'Common', 'login', '登录成功', '1', '127.0.0.1', '1581212183', '0', '0');
INSERT INTO `sr_logs` VALUES ('96', '1', 'admin', 'admin', 'Store', 'basic', '存储基本设置', '1', '127.0.0.1', '1581214156', '0', '0');
INSERT INTO `sr_logs` VALUES ('97', '1', 'admin', 'admin', 'Store', 'qiniuyun', '七牛云设置', '1', '127.0.0.1', '1581214161', '0', '0');
INSERT INTO `sr_logs` VALUES ('98', '1', 'admin', 'admin', 'Store', 'qiniuyun', '七牛云设置', '1', '127.0.0.1', '1581214168', '0', '0');
INSERT INTO `sr_logs` VALUES ('99', '1', 'admin', 'admin', 'Store', 'basic', '存储基本设置', '1', '127.0.0.1', '1581214178', '0', '0');
INSERT INTO `sr_logs` VALUES ('100', '1', 'admin', 'admin', 'Live', 'basic', '直播基本设置', '1', '127.0.0.1', '1581215073', '0', '0');
INSERT INTO `sr_logs` VALUES ('101', '1', 'admin', 'admin', 'Live', 'basic', '直播基本设置', '1', '127.0.0.1', '1581215076', '0', '0');
INSERT INTO `sr_logs` VALUES ('102', '1', 'admin', 'admin', 'Live', 'cc', 'CC直播设置', '1', '127.0.0.1', '1581215088', '0', '0');
INSERT INTO `sr_logs` VALUES ('103', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581216324', '0', '0');
INSERT INTO `sr_logs` VALUES ('104', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581216370', '0', '0');
INSERT INTO `sr_logs` VALUES ('105', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:74', '1', '127.0.0.1', '1581216388', '0', '0');
INSERT INTO `sr_logs` VALUES ('106', '1', 'admin', 'admin', 'Uservip', 'publish', '添加会员等级,id:0', '1', '127.0.0.1', '1581228408', '0', '0');
INSERT INTO `sr_logs` VALUES ('107', '1', 'admin', 'admin', 'Uservip', 'delete', '删除会员等级,id:5', '1', '127.0.0.1', '1581228414', '0', '0');
INSERT INTO `sr_logs` VALUES ('108', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1581229050', '0', '0');
INSERT INTO `sr_logs` VALUES ('109', '1', 'admin', 'admin', 'Nav', 'publish', '添加首页导航,id:1', '1', '127.0.0.1', '1581233636', '0', '0');
INSERT INTO `sr_logs` VALUES ('110', '1', 'admin', 'admin', 'Nav', 'publish', '编辑首页导航,id:74', '1', '127.0.0.1', '1581233990', '0', '0');
INSERT INTO `sr_logs` VALUES ('111', '1', 'admin', 'admin', 'Nav', 'publish', '添加首页导航,id:1', '1', '127.0.0.1', '1581234048', '0', '0');
INSERT INTO `sr_logs` VALUES ('112', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:17', '1', '127.0.0.1', '1581240237', '0', '0');
INSERT INTO `sr_logs` VALUES ('113', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:17', '1', '127.0.0.1', '1581240253', '0', '0');
INSERT INTO `sr_logs` VALUES ('114', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:17', '1', '127.0.0.1', '1581240455', '0', '0');
INSERT INTO `sr_logs` VALUES ('115', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:18', '1', '127.0.0.1', '1581240478', '0', '0');
INSERT INTO `sr_logs` VALUES ('116', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:19', '1', '127.0.0.1', '1581240495', '0', '0');
INSERT INTO `sr_logs` VALUES ('117', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:20', '1', '127.0.0.1', '1581240505', '0', '0');
INSERT INTO `sr_logs` VALUES ('118', '1', 'admin', 'admin', 'Pay', 'basic', '支付基本设置', '1', '127.0.0.1', '1581241516', '0', '0');
INSERT INTO `sr_logs` VALUES ('119', '1', 'admin', 'admin', 'Pay', 'basic', '支付基本设置', '1', '127.0.0.1', '1581241955', '0', '0');
INSERT INTO `sr_logs` VALUES ('120', '1', 'admin', 'admin', 'Pay', 'basic', '支付基本设置', '1', '127.0.0.1', '1581241987', '0', '0');
INSERT INTO `sr_logs` VALUES ('121', '1', 'admin', 'admin', 'Pay', 'ali', '支付宝设置', '1', '127.0.0.1', '1581242246', '0', '0');
INSERT INTO `sr_logs` VALUES ('122', '1', 'admin', 'admin', 'Pay', 'refund', '退款设置', '1', '127.0.0.1', '1581243779', '0', '0');
INSERT INTO `sr_logs` VALUES ('123', '1', 'admin', 'admin', 'Pay', 'weixin', '微信支付设置', '1', '127.0.0.1', '1581247936', '0', '0');
INSERT INTO `sr_logs` VALUES ('124', '1', 'admin', 'admin', 'Pay', 'weixin', '微信支付设置', '1', '127.0.0.1', '1581248167', '0', '0');
INSERT INTO `sr_logs` VALUES ('125', '1', 'admin', 'admin', 'Pay', 'weixin', '微信支付设置', '1', '127.0.0.1', '1581248310', '0', '0');
INSERT INTO `sr_logs` VALUES ('126', '1', 'admin', 'admin', 'Pay', 'weixin', '微信支付设置', '1', '127.0.0.1', '1581248536', '0', '0');
INSERT INTO `sr_logs` VALUES ('127', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581249138', '0', '0');
INSERT INTO `sr_logs` VALUES ('128', '1', 'admin', 'admin', 'Sysconfig', 'thirdlogin', '第三方登录', '1', '127.0.0.1', '1581250204', '0', '0');
INSERT INTO `sr_logs` VALUES ('129', '1', 'admin', 'admin', 'Sysconfig', 'thirdlogin', '第三方登录', '1', '127.0.0.1', '1581250269', '0', '0');
INSERT INTO `sr_logs` VALUES ('130', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:25', '1', '127.0.0.1', '1581251719', '0', '0');
INSERT INTO `sr_logs` VALUES ('131', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:31', '1', '127.0.0.1', '1581251741', '0', '0');
INSERT INTO `sr_logs` VALUES ('132', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:31', '1', '127.0.0.1', '1581251811', '0', '0');
INSERT INTO `sr_logs` VALUES ('136', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:57', '1', '127.0.0.1', '1581260337', '0', '0');
INSERT INTO `sr_logs` VALUES ('135', '1', 'admin', 'admin', 'Logs', 'delete', '删除日志成功', '1', '127.0.0.1', '1581255609', '0', '0');
INSERT INTO `sr_logs` VALUES ('137', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:58', '1', '127.0.0.1', '1581260351', '0', '0');
INSERT INTO `sr_logs` VALUES ('138', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:59', '1', '127.0.0.1', '1581260366', '0', '0');
INSERT INTO `sr_logs` VALUES ('139', '1', 'admin', 'admin', 'Teachervip', 'publish', '编辑讲师头衔,id:1', '1', '127.0.0.1', '1581260499', '0', '0');
INSERT INTO `sr_logs` VALUES ('140', '1', 'admin', 'admin', 'Examsmodule', 'publish', '添加考试板块', '1', '127.0.0.1', '1581260545', '0', '0');
INSERT INTO `sr_logs` VALUES ('141', '1', 'admin', 'admin', 'Examsmodule', 'delete', '删除考试模块', '1', '127.0.0.1', '1581260576', '0', '0');
INSERT INTO `sr_logs` VALUES ('142', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1581306778', '0', '0');
INSERT INTO `sr_logs` VALUES ('143', '1', 'admin', 'admin', 'Examsmodule', 'publish', '添加考试板块', '1', '127.0.0.1', '1581306814', '0', '0');
INSERT INTO `sr_logs` VALUES ('144', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1581399303', '0', '0');
INSERT INTO `sr_logs` VALUES ('145', '1', 'admin', 'admin', 'Examsmodule', 'publish', '添加考试板块', '1', '127.0.0.1', '1581402392', '0', '0');
INSERT INTO `sr_logs` VALUES ('146', '1', 'admin', 'admin', 'Examspoint', 'publish', '编辑知识点', '1', '127.0.0.1', '1581403775', '0', '0');
INSERT INTO `sr_logs` VALUES ('147', '1', 'admin', 'admin', 'Examspoint', 'publish', '编辑知识点', '1', '127.0.0.1', '1581403799', '0', '0');
INSERT INTO `sr_logs` VALUES ('148', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:33', '1', '127.0.0.1', '1581410413', '0', '0');
INSERT INTO `sr_logs` VALUES ('149', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:33', '1', '127.0.0.1', '1581410424', '0', '0');
INSERT INTO `sr_logs` VALUES ('150', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581410459', '0', '0');
INSERT INTO `sr_logs` VALUES ('151', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581410571', '0', '0');
INSERT INTO `sr_logs` VALUES ('152', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581410659', '0', '0');
INSERT INTO `sr_logs` VALUES ('153', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581410692', '0', '0');
INSERT INTO `sr_logs` VALUES ('154', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581410723', '0', '0');
INSERT INTO `sr_logs` VALUES ('155', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581410757', '0', '0');
INSERT INTO `sr_logs` VALUES ('156', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581410780', '0', '0');
INSERT INTO `sr_logs` VALUES ('157', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:82', '1', '127.0.0.1', '1581412052', '0', '0');
INSERT INTO `sr_logs` VALUES ('158', '1', 'admin', 'admin', 'Category', 'publish', '删除类别编辑currency_category', '1', '127.0.0.1', '1581412891', '0', '0');
INSERT INTO `sr_logs` VALUES ('159', '1', 'admin', 'admin', 'Category', 'publish', '删除类别编辑currency_category', '1', '127.0.0.1', '1581412899', '0', '0');
INSERT INTO `sr_logs` VALUES ('160', '1', 'admin', 'admin', 'Category', 'publish', '删除类别编辑currency_category', '1', '127.0.0.1', '1581412935', '0', '0');
INSERT INTO `sr_logs` VALUES ('161', '1', 'admin', 'admin', 'Category', 'publish', '删除类别新增currency_category', '1', '127.0.0.1', '1581413144', '0', '0');
INSERT INTO `sr_logs` VALUES ('162', '1', 'admin', 'admin', 'Category', 'publish', '删除类别新增topic_category', '1', '127.0.0.1', '1581414188', '0', '0');
INSERT INTO `sr_logs` VALUES ('163', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581417598', '0', '0');
INSERT INTO `sr_logs` VALUES ('164', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:84', '1', '127.0.0.1', '1581417674', '0', '0');
INSERT INTO `sr_logs` VALUES ('165', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:8', '1', '127.0.0.1', '1581418092', '0', '0');
INSERT INTO `sr_logs` VALUES ('166', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:8', '1', '127.0.0.1', '1581418136', '0', '0');
INSERT INTO `sr_logs` VALUES ('167', '1', 'admin', 'admin', 'News', 'publish', '编辑资讯', '1', '127.0.0.1', '1581418185', '0', '0');
INSERT INTO `sr_logs` VALUES ('168', '1', 'admin', 'admin', 'News', 'publish', '编辑资讯', '1', '127.0.0.1', '1581418197', '0', '0');
INSERT INTO `sr_logs` VALUES ('169', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:8', '1', '127.0.0.1', '1581418221', '0', '0');
INSERT INTO `sr_logs` VALUES ('170', '1', 'admin', 'admin', 'News', 'delete', '删除资讯', '1', '127.0.0.1', '1581418544', '0', '0');
INSERT INTO `sr_logs` VALUES ('171', '1', 'admin', 'admin', 'News', 'deletemul', '批量删除资讯', '1', '127.0.0.1', '1581419022', '0', '0');
INSERT INTO `sr_logs` VALUES ('172', '1', 'admin', 'admin', 'News', 'deletemul', '批量删除资讯', '1', '127.0.0.1', '1581421056', '0', '0');
INSERT INTO `sr_logs` VALUES ('173', '1', 'admin', 'admin', 'Single', 'publish', '发布资讯', '1', '127.0.0.1', '1581422358', '0', '0');
INSERT INTO `sr_logs` VALUES ('174', '1', 'admin', 'admin', 'Single', 'publish', '编辑资讯', '1', '127.0.0.1', '1581422369', '0', '0');
INSERT INTO `sr_logs` VALUES ('175', '1', 'admin', 'admin', 'Single', 'delete', '删除单页', '1', '127.0.0.1', '1581422378', '0', '0');
INSERT INTO `sr_logs` VALUES ('176', '1', 'admin', 'admin', 'News', 'publish', '编辑资讯', '1', '127.0.0.1', '1581422441', '0', '0');
INSERT INTO `sr_logs` VALUES ('177', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:49', '1', '127.0.0.1', '1581430057', '0', '0');
INSERT INTO `sr_logs` VALUES ('178', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:53', '1', '127.0.0.1', '1581431862', '0', '0');
INSERT INTO `sr_logs` VALUES ('179', '1', 'admin', 'admin', 'Single', 'delete', '删除单页', '1', '127.0.0.1', '1581432012', '0', '0');
INSERT INTO `sr_logs` VALUES ('180', '1', 'admin', 'admin', 'Phonecode', 'delete', '删除反馈', '1', '127.0.0.1', '1581432697', '0', '0');
INSERT INTO `sr_logs` VALUES ('181', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1581472757', '0', '0');
INSERT INTO `sr_logs` VALUES ('182', '1', 'admin', 'admin', 'Adv', 'delete', '删除广告', '1', '127.0.0.1', '1581472915', '0', '0');
INSERT INTO `sr_logs` VALUES ('183', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:46', '1', '127.0.0.1', '1581474203', '0', '0');
INSERT INTO `sr_logs` VALUES ('184', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:46', '1', '127.0.0.1', '1581474263', '0', '0');
INSERT INTO `sr_logs` VALUES ('185', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:46', '1', '127.0.0.1', '1581474943', '0', '0');
INSERT INTO `sr_logs` VALUES ('186', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:46', '1', '127.0.0.1', '1581474956', '0', '0');
INSERT INTO `sr_logs` VALUES ('187', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581475675', '0', '0');
INSERT INTO `sr_logs` VALUES ('188', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581475829', '0', '0');
INSERT INTO `sr_logs` VALUES ('189', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581475901', '0', '0');
INSERT INTO `sr_logs` VALUES ('190', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581475986', '0', '0');
INSERT INTO `sr_logs` VALUES ('191', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:88', '1', '127.0.0.1', '1581475997', '0', '0');
INSERT INTO `sr_logs` VALUES ('192', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581476064', '0', '0');
INSERT INTO `sr_logs` VALUES ('193', '1', 'admin', 'admin', 'Menu', 'publish', '菜单添加成功,id:1', '1', '127.0.0.1', '1581476114', '0', '0');
INSERT INTO `sr_logs` VALUES ('194', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:36', '1', '127.0.0.1', '1581476212', '0', '0');
INSERT INTO `sr_logs` VALUES ('195', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:86', '1', '127.0.0.1', '1581476222', '0', '0');
INSERT INTO `sr_logs` VALUES ('196', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:87', '1', '127.0.0.1', '1581476235', '0', '0');
INSERT INTO `sr_logs` VALUES ('197', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:88', '1', '127.0.0.1', '1581476245', '0', '0');
INSERT INTO `sr_logs` VALUES ('198', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:89', '1', '127.0.0.1', '1581476254', '0', '0');
INSERT INTO `sr_logs` VALUES ('199', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:90', '1', '127.0.0.1', '1581476260', '0', '0');
INSERT INTO `sr_logs` VALUES ('200', '1', 'admin', 'admin', 'Videodata', 'delete', '删除课件库', '1', '127.0.0.1', '1581483260', '0', '0');
INSERT INTO `sr_logs` VALUES ('201', '1', 'admin', 'admin', 'Videodata', 'publishurl', '编辑链接课件库43', '1', '127.0.0.1', '1581485369', '0', '0');
INSERT INTO `sr_logs` VALUES ('202', '1', 'admin', 'admin', 'Videodata', 'publishurl', '添加链接课件库1', '1', '127.0.0.1', '1581485486', '0', '0');
INSERT INTO `sr_logs` VALUES ('203', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1581686707', '0', '0');
INSERT INTO `sr_logs` VALUES ('204', '1', 'admin', 'admin', 'Common', 'dologin', '登录成功', '1', '127.0.0.1', '1583906835', '0', '0');
INSERT INTO `sr_logs` VALUES ('205', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:7', '1', '127.0.0.1', '1583909218', '0', '0');
INSERT INTO `sr_logs` VALUES ('206', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:9', '1', '127.0.0.1', '1583909223', '0', '0');
INSERT INTO `sr_logs` VALUES ('207', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:10', '1', '127.0.0.1', '1583909227', '0', '0');
INSERT INTO `sr_logs` VALUES ('208', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:11', '1', '127.0.0.1', '1583909230', '0', '0');
INSERT INTO `sr_logs` VALUES ('209', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:12', '1', '127.0.0.1', '1583909234', '0', '0');
INSERT INTO `sr_logs` VALUES ('210', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:16', '1', '127.0.0.1', '1583909243', '0', '0');
INSERT INTO `sr_logs` VALUES ('211', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:74', '1', '127.0.0.1', '1583909248', '0', '0');
INSERT INTO `sr_logs` VALUES ('212', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:75', '1', '127.0.0.1', '1583909252', '0', '0');
INSERT INTO `sr_logs` VALUES ('213', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:76', '1', '127.0.0.1', '1583909256', '0', '0');
INSERT INTO `sr_logs` VALUES ('214', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:21', '1', '127.0.0.1', '1583909261', '0', '0');
INSERT INTO `sr_logs` VALUES ('215', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:22', '1', '127.0.0.1', '1583909264', '0', '0');
INSERT INTO `sr_logs` VALUES ('216', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:23', '1', '127.0.0.1', '1583909266', '0', '0');
INSERT INTO `sr_logs` VALUES ('217', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:4', '1', '127.0.0.1', '1583909269', '0', '0');
INSERT INTO `sr_logs` VALUES ('218', '1', 'admin', 'admin', 'Menu', 'publish', '菜单编辑成功,id:29', '1', '127.0.0.1', '1583909303', '0', '0');
INSERT INTO `sr_logs` VALUES ('219', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:31', '1', '127.0.0.1', '1583909310', '0', '0');
INSERT INTO `sr_logs` VALUES ('220', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:24', '1', '127.0.0.1', '1583909312', '0', '0');
INSERT INTO `sr_logs` VALUES ('221', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:73', '1', '127.0.0.1', '1583909322', '0', '0');
INSERT INTO `sr_logs` VALUES ('222', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:72', '1', '127.0.0.1', '1583909325', '0', '0');
INSERT INTO `sr_logs` VALUES ('223', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:71', '1', '127.0.0.1', '1583909328', '0', '0');
INSERT INTO `sr_logs` VALUES ('224', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:70', '1', '127.0.0.1', '1583909331', '0', '0');
INSERT INTO `sr_logs` VALUES ('225', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:69', '1', '127.0.0.1', '1583909334', '0', '0');
INSERT INTO `sr_logs` VALUES ('226', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:68', '1', '127.0.0.1', '1583909337', '0', '0');
INSERT INTO `sr_logs` VALUES ('227', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:67', '1', '127.0.0.1', '1583909340', '0', '0');
INSERT INTO `sr_logs` VALUES ('228', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:66', '1', '127.0.0.1', '1583909344', '0', '0');
INSERT INTO `sr_logs` VALUES ('229', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:65', '1', '127.0.0.1', '1583909347', '0', '0');
INSERT INTO `sr_logs` VALUES ('230', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:85', '1', '127.0.0.1', '1583909353', '0', '0');
INSERT INTO `sr_logs` VALUES ('231', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:64', '1', '127.0.0.1', '1583909357', '0', '0');
INSERT INTO `sr_logs` VALUES ('232', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:63', '1', '127.0.0.1', '1583909360', '0', '0');
INSERT INTO `sr_logs` VALUES ('233', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:62', '1', '127.0.0.1', '1583909365', '0', '0');
INSERT INTO `sr_logs` VALUES ('234', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:61', '1', '127.0.0.1', '1583909367', '0', '0');
INSERT INTO `sr_logs` VALUES ('235', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:60', '1', '127.0.0.1', '1583909370', '0', '0');
INSERT INTO `sr_logs` VALUES ('236', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:59', '1', '127.0.0.1', '1583909373', '0', '0');
INSERT INTO `sr_logs` VALUES ('237', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:58', '1', '127.0.0.1', '1583909377', '0', '0');
INSERT INTO `sr_logs` VALUES ('238', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:57', '1', '127.0.0.1', '1583909380', '0', '0');
INSERT INTO `sr_logs` VALUES ('239', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:56', '1', '127.0.0.1', '1583909382', '0', '0');
INSERT INTO `sr_logs` VALUES ('240', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:90', '1', '127.0.0.1', '1583909388', '0', '0');
INSERT INTO `sr_logs` VALUES ('241', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:89', '1', '127.0.0.1', '1583909391', '0', '0');
INSERT INTO `sr_logs` VALUES ('242', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:88', '1', '127.0.0.1', '1583909394', '0', '0');
INSERT INTO `sr_logs` VALUES ('243', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:87', '1', '127.0.0.1', '1583909396', '0', '0');
INSERT INTO `sr_logs` VALUES ('244', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:86', '1', '127.0.0.1', '1583909399', '0', '0');
INSERT INTO `sr_logs` VALUES ('245', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:36', '1', '127.0.0.1', '1583909402', '0', '0');
INSERT INTO `sr_logs` VALUES ('246', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:35', '1', '127.0.0.1', '1583909404', '0', '0');
INSERT INTO `sr_logs` VALUES ('247', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:32', '1', '127.0.0.1', '1583909407', '0', '0');
INSERT INTO `sr_logs` VALUES ('248', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:27', '1', '127.0.0.1', '1583909410', '0', '0');
INSERT INTO `sr_logs` VALUES ('249', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:28', '1', '127.0.0.1', '1583909415', '0', '0');
INSERT INTO `sr_logs` VALUES ('250', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:43', '1', '127.0.0.1', '1583909421', '0', '0');
INSERT INTO `sr_logs` VALUES ('251', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:44', '1', '127.0.0.1', '1583909424', '0', '0');
INSERT INTO `sr_logs` VALUES ('252', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:77', '1', '127.0.0.1', '1583909434', '0', '0');
INSERT INTO `sr_logs` VALUES ('253', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:78', '1', '127.0.0.1', '1583909437', '0', '0');
INSERT INTO `sr_logs` VALUES ('254', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:79', '1', '127.0.0.1', '1583909440', '0', '0');
INSERT INTO `sr_logs` VALUES ('255', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:80', '1', '127.0.0.1', '1583909443', '0', '0');
INSERT INTO `sr_logs` VALUES ('256', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:81', '1', '127.0.0.1', '1583909447', '0', '0');
INSERT INTO `sr_logs` VALUES ('257', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:50', '1', '127.0.0.1', '1583909453', '0', '0');
INSERT INTO `sr_logs` VALUES ('258', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:51', '1', '127.0.0.1', '1583909457', '0', '0');
INSERT INTO `sr_logs` VALUES ('259', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:52', '1', '127.0.0.1', '1583909461', '0', '0');
INSERT INTO `sr_logs` VALUES ('260', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:38', '1', '127.0.0.1', '1583909469', '0', '0');
INSERT INTO `sr_logs` VALUES ('261', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:37', '1', '127.0.0.1', '1583909472', '0', '0');
INSERT INTO `sr_logs` VALUES ('262', '1', 'admin', 'admin', 'Sysconfig', 'site', '站点配置修改', '1', '127.0.0.1', '1583910528', '0', '0');
INSERT INTO `sr_logs` VALUES ('263', '1', 'admin', 'admin', 'Menu', 'delete', '删除菜单,id:53', '1', '127.0.0.1', '1583910709', '0', '0');
INSERT INTO `sr_logs` VALUES ('264', '1', 'admin', 'admin', 'Menu', 'edit', '修改了后台菜单,id:39', '1', '127.0.0.1', '1583914379', '0', '0');
INSERT INTO `sr_logs` VALUES ('265', '1', 'admin', 'admin', 'Menu', 'edit', '修改了后台菜单,id:39', '1', '127.0.0.1', '1583914400', '0', '0');
INSERT INTO `sr_logs` VALUES ('266', '1', 'admin', 'admin', 'Menu', 'add', '菜单添加成功,id:1', '1', '127.0.0.1', '1583915079', '0', '0');
INSERT INTO `sr_logs` VALUES ('267', '1', 'admin', 'admin', 'Menu', 'add', '菜单添加成功,id:1', '1', '127.0.0.1', '1583915144', '0', '0');
INSERT INTO `sr_logs` VALUES ('268', '1', 'admin', 'admin', 'Sysconfig', 'attach', '上传基本设置', '1', '127.0.0.1', '1583916275', '0', '0');
INSERT INTO `sr_logs` VALUES ('269', '1', 'admin', 'admin', 'Sysconfig', 'attachimage', '上传图片设置', '1', '127.0.0.1', '1583916292', '0', '0');
INSERT INTO `sr_logs` VALUES ('270', '1', 'admin', 'admin', 'Menu', 'edit', '修改了后台菜单,id:14', '1', '127.0.0.1', '1583916311', '0', '0');
INSERT INTO `sr_logs` VALUES ('271', '1', 'admin', 'admin', 'Menu', 'del', '删除菜单,id:15', '1', '127.0.0.1', '1583916330', '0', '0');
INSERT INTO `sr_logs` VALUES ('272', '1', 'admin', 'admin', 'Menu', 'add', '菜单添加成功,id:1', '1', '127.0.0.1', '1583916364', '0', '0');
INSERT INTO `sr_logs` VALUES ('273', '1', 'admin', 'admin', 'Menu', 'edit', '修改了后台菜单,id:40', '1', '127.0.0.1', '1583916375', '0', '0');
INSERT INTO `sr_logs` VALUES ('274', '1', 'admin', 'admin', 'Menu', 'del', '删除菜单,id:20', '1', '127.0.0.1', '1583916415', '0', '0');
INSERT INTO `sr_logs` VALUES ('275', '1', 'admin', 'admin', 'Menu', 'del', '删除菜单,id:19', '1', '127.0.0.1', '1583916419', '0', '0');
INSERT INTO `sr_logs` VALUES ('276', '1', 'admin', 'admin', 'Menu', 'del', '删除菜单,id:18', '1', '127.0.0.1', '1583916422', '0', '0');
INSERT INTO `sr_logs` VALUES ('277', '1', 'admin', 'admin', 'Menu', 'del', '删除菜单,id:17', '1', '127.0.0.1', '1583916424', '0', '0');
INSERT INTO `sr_logs` VALUES ('278', '1', 'admin', 'admin', 'Menu', 'del', '删除菜单,id:3', '1', '127.0.0.1', '1583916428', '0', '0');
INSERT INTO `sr_logs` VALUES ('279', '1', 'admin', 'admin', 'Menu', 'edit', '修改了后台菜单,id:13', '1', '127.0.0.1', '1583916443', '0', '0');
INSERT INTO `sr_logs` VALUES ('280', '1', 'admin', 'admin', 'Menu', 'edit', '修改了后台菜单,id:5', '1', '127.0.0.1', '1583916457', '0', '0');
INSERT INTO `sr_logs` VALUES ('281', '1', 'admin', 'admin', 'Menu', 'edit', '修改了后台菜单,id:6', '1', '127.0.0.1', '1583916467', '0', '0');
INSERT INTO `sr_logs` VALUES ('282', '1', 'admin', 'admin', 'Menu', 'edit', '修改了后台菜单,id:14', '1', '127.0.0.1', '1583916478', '0', '0');
INSERT INTO `sr_logs` VALUES ('283', '1', 'admin', 'admin', 'Menu', 'del', '删除菜单,id:2', '1', '127.0.0.1', '1583916484', '0', '0');
INSERT INTO `sr_logs` VALUES ('284', '1', 'admin', 'admin', 'Menu', 'edit', '修改了后台菜单,id:13', '1', '127.0.0.1', '1583916507', '0', '0');
INSERT INTO `sr_logs` VALUES ('285', '1', 'admin', 'admin', 'Sysconfig', 'site', '站点配置修改', '1', '127.0.0.1', '1583917226', '0', '0');
INSERT INTO `sr_logs` VALUES ('286', '1', 'admin', 'admin', 'Menu', 'del', '删除菜单,id:47', '1', '127.0.0.1', '1583917877', '0', '0');
INSERT INTO `sr_logs` VALUES ('287', '1', 'admin', 'admin', 'Menu', 'del', '删除菜单,id:48', '1', '127.0.0.1', '1583917880', '0', '0');
INSERT INTO `sr_logs` VALUES ('288', '1', 'admin', 'admin', 'Menu', 'add', '菜单添加成功,id:1', '1', '127.0.0.1', '1583917999', '0', '0');
INSERT INTO `sr_logs` VALUES ('289', '1', 'admin', 'admin', 'Menu', 'add', '菜单添加成功,id:1', '1', '127.0.0.1', '1583918029', '0', '0');
INSERT INTO `sr_logs` VALUES ('290', '1', 'admin', 'admin', 'Menu', 'add', '菜单添加成功,id:1', '1', '127.0.0.1', '1583918065', '0', '0');
INSERT INTO `sr_logs` VALUES ('291', '1', 'admin', 'admin', 'Menu', 'add', '菜单添加成功,id:1', '1', '127.0.0.1', '1583918094', '0', '0');
INSERT INTO `sr_logs` VALUES ('292', '1', 'admin', 'admin', 'Menu', 'edit', '修改了后台菜单,id:33', '1', '127.0.0.1', '1583918381', '0', '0');
INSERT INTO `sr_logs` VALUES ('293', '1', 'admin', 'admin', 'Category', 'publish', '删除类别新增topic_category', '1', '127.0.0.1', '1583918555', '0', '0');
INSERT INTO `sr_logs` VALUES ('294', '1', 'admin', 'admin', 'Category', 'publish', '删除类别新增topic_category', '1', '127.0.0.1', '1583918564', '0', '0');
INSERT INTO `sr_logs` VALUES ('295', '1', 'admin', 'admin', 'Category', 'delete', '删除类别topic_category', '1', '127.0.0.1', '1583918581', '0', '0');
INSERT INTO `sr_logs` VALUES ('296', '1', 'admin', 'admin', 'Category', 'publish', '删除类别新增goods_category', '1', '127.0.0.1', '1583922989', '0', '0');
INSERT INTO `sr_logs` VALUES ('297', '1', 'admin', 'admin', 'Menu', 'del', '删除菜单,id:54', '1', '127.0.0.1', '1583923031', '0', '0');
INSERT INTO `sr_logs` VALUES ('298', '1', 'admin', 'admin', 'Logs', 'deletebeforday', '删除30天前日志成功', '1', '127.0.0.1', '1583923920', '0', '0');
INSERT INTO `sr_logs` VALUES ('299', '1', 'admin', 'admin', 'Menu', 'edit', '修改了后台菜单,id:45', '1', '127.0.0.1', '1583924093', '0', '0');
INSERT INTO `sr_logs` VALUES ('300', '1', 'admin', 'admin', 'Menu', 'edit', '修改了后台菜单,id:46', '1', '127.0.0.1', '1583924110', '0', '0');
INSERT INTO `sr_logs` VALUES ('301', '1', 'admin', 'admin', 'News', 'publish', '发布资讯', '1', '127.0.0.1', '1583925520', '0', '0');
INSERT INTO `sr_logs` VALUES ('302', '1', 'admin', 'admin', 'News', 'publish', '发布资讯', '1', '127.0.0.1', '1583925928', '0', '0');
INSERT INTO `sr_logs` VALUES ('303', '1', 'admin', 'admin', 'News', 'publish', '编辑资讯', '1', '127.0.0.1', '1583926150', '0', '0');
INSERT INTO `sr_logs` VALUES ('304', '1', 'admin', 'admin', 'Sysconfig', 'site', '站点配置修改', '1', '127.0.0.1', '1583926936', '0', '0');
INSERT INTO `sr_logs` VALUES ('305', '1', 'admin', 'admin', 'Sysconfig', 'site', '站点配置修改', '1', '127.0.0.1', '1583926947', '0', '0');
INSERT INTO `sr_logs` VALUES ('306', '1', 'admin', 'admin', 'Sysconfig', 'site', '站点配置修改', '1', '127.0.0.1', '1583926961', '0', '0');
INSERT INTO `sr_logs` VALUES ('307', '1', 'admin', 'admin', 'Usergroup', 'publish', '添加用户组,id:2', '1', '127.0.0.1', '1583937037', '0', '0');

-- ----------------------------
-- Table structure for `sr_menu`
-- ----------------------------
DROP TABLE IF EXISTS `sr_menu`;
CREATE TABLE `sr_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文档ID',
  `module` varchar(20) DEFAULT NULL,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `title` varchar(50) DEFAULT NULL COMMENT '标题',
  `url` varchar(255) DEFAULT NULL COMMENT '链接地址',
  `icon` varchar(64) DEFAULT NULL,
  `sort_order` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序（同级有效）',
  `type` varchar(5) DEFAULT '0' COMMENT '''nav'':导航  ''auth'' 权限',
  `is_del` tinyint(2) NOT NULL DEFAULT '0' COMMENT '1:删除',
  `is_open` tinyint(1) DEFAULT '0',
  `is_display` tinyint(1) DEFAULT '1' COMMENT '1显示在左侧菜单2只作为节点',
  `del_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8 COMMENT='后台菜单';

-- ----------------------------
-- Records of sr_menu
-- ----------------------------
INSERT INTO `sr_menu` VALUES ('1', 'admin', '0', '系统管理', null, null, '0', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('2', 'admin', '1', '系统配置', null, null, '0', 'nav', '1', '0', '1', '1583916484');
INSERT INTO `sr_menu` VALUES ('3', 'admin', '1', '支付配置', null, null, '1', 'nav', '1', '0', '1', '1583916428');
INSERT INTO `sr_menu` VALUES ('5', 'admin', '1', '菜单管理', 'admin/menu/index', '', '0', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('6', 'admin', '1', '站点设置', 'admin/sysconfig/site', '', '0', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('13', 'admin', '1', '上传设置', 'admin/sysconfig/attach', '', '0', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('14', 'admin', '1', '上传图片管理', 'admin/sysconfig/attchimage', '', '0', 'auth', '0', '0', '0', '0');
INSERT INTO `sr_menu` VALUES ('15', 'admin', '2', '敏感词设置', 'admin/sysconfig/audit', null, '0', 'nav', '1', '0', '1', '1583916330');
INSERT INTO `sr_menu` VALUES ('17', 'admin', '3', '基本设置', 'admin/pay/basic', null, '0', 'nav', '1', '0', '1', '1583916424');
INSERT INTO `sr_menu` VALUES ('18', 'admin', '3', '支付宝', 'admin/pay/ali', null, '1', 'nav', '1', '0', '1', '1583916421');
INSERT INTO `sr_menu` VALUES ('19', 'admin', '3', '微信支付', 'admin/pay/weixin', null, '2', 'nav', '1', '0', '1', '1583916418');
INSERT INTO `sr_menu` VALUES ('20', 'admin', '3', '退款设置', 'admin/pay/refund', null, '3', 'nav', '1', '0', '1', '1583916415');
INSERT INTO `sr_menu` VALUES ('26', 'admin', '0', '内容管理', '', null, '3', 'auth', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('29', 'admin', '26', '操作日志', 'admin/logs/index', null, '0', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('33', 'admin', '26', '分类管理', '', '', '1', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('39', '', '0', '用户和管理员', '', '', '2', 'nav', '0', '0', '0', '0');
INSERT INTO `sr_menu` VALUES ('40', 'admin', '39', '用户管理', 'admin/user/index', '', '0', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('41', '', '39', '用户组', 'admin/usergroup/index', null, '0', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('42', '', '39', '用户等级', 'admin/uservip/index', null, '0', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('45', 'admin', '26', '咨讯管理', 'admin/news/index', '', '0', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('46', 'admin', '45', '添加咨讯', 'admin/news/publish', '', '3', 'auth', '0', '0', '0', '0');
INSERT INTO `sr_menu` VALUES ('47', 'admin', '26', '单页管理', 'admin/single/index', null, '5', 'nav', '1', '0', '1', '1583917877');
INSERT INTO `sr_menu` VALUES ('48', 'admin', '26', '发布单页', 'admin/single/publish', null, '6', 'nav', '1', '0', '0', '1583917880');
INSERT INTO `sr_menu` VALUES ('53', 'admin', '26', '手机验证管理', 'admin/phonecode/index', null, '11', 'nav', '1', '0', '1', '1583910709');
INSERT INTO `sr_menu` VALUES ('54', 'admin', '26', '附件管理', 'admin/attach/index', null, '12', 'nav', '1', '0', '1', '1583923031');
INSERT INTO `sr_menu` VALUES ('55', 'admin', '26', '广告管理', 'admin/adv/index', null, '13', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('82', 'admin', '33', '新闻分类', 'admin/category/topic', null, '0', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('83', 'admin', '33', '商品分类', 'admin/category/goods', null, '0', 'nav', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('91', 'admin', '41', '添加|编辑', 'admin/usergroup/publish', '', '0', 'auth', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('92', 'admin', '41', '删除', 'admin/usergroup/delete', '', '0', 'auth', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('93', 'admin', '42', '增加|编辑', 'admin/uservip/publish', '', '0', 'auth', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('94', 'admin', '42', '删除', 'admin/uservip/delete', '', '0', 'auth', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('95', 'admin', '40', '增加|编辑', 'admin/user/add', '', '0', 'auth', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('96', 'admin', '33', '发布|编辑', 'admin/category/publish', '', '0', 'auth', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('97', 'admin', '29', '删除', 'admin/logs/delete', '', '0', 'auth', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('98', 'admin', '29', '删除30天前', 'admin/logs/deletebeforday', '', '0', 'auth', '0', '0', '1', '0');
INSERT INTO `sr_menu` VALUES ('99', 'admin', '33', '删除', 'admin/category/delete', '', '0', 'auth', '0', '0', '1', '0');

-- ----------------------------
-- Table structure for `sr_single`
-- ----------------------------
DROP TABLE IF EXISTS `sr_single`;
CREATE TABLE `sr_single` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '单页面表主键ID',
  `title` varchar(90) DEFAULT NULL COMMENT '单页标题',
  `key` varchar(255) DEFAULT NULL COMMENT '唯一标识',
  `text` text COMMENT '单页内容',
  `is_del` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否删除【1:是;0:否;】',
  `del_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key` (`key`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8 COMMENT='单页面表';

-- ----------------------------
-- Records of sr_single
-- ----------------------------
INSERT INTO `sr_single` VALUES ('1', '联系平台', 'contact', '<p class=\"MsoNormal\" style=\"margin-left:21.0pt;text-indent:-21.0pt;\"><span style=\"font-size: 14px;\">&nbsp;联系方式</span></p><p class=\"MsoNormal\" style=\"margin-left:21.0pt;text-indent:-21.0pt;\"><span style=\"font-size: 14px;\">\r\n	&nbsp;外地老师签约平台</span></p><p class=\"MsoNormal\" style=\"margin-left:21.0pt;text-indent:-21.0pt;\"><span style=\"font-size: 14px;\">\r\n	&nbsp;签约平台的条件</span></p><p class=\"MsoNormal\" style=\"margin-left:21.0pt;text-indent:-21.0pt;\"><span style=\"line-height: 1.5; font-size: 14px;\">1）联系平台有哪些方式？</span></p><p class=\"MsoNormal\"><span style=\"font-size: 14px;\">\r\n		目前机构开通名师热线、微信、QQ、微博等联系方式；	</span></p><p class=\"MsoNormal\"><span style=\"line-height: 1.5; font-size: 14px;\">2）外地老师可否签约平台？</span></p><p class=\"MsoNormal\"><span style=\"font-size: 14px;\">\r\n		可以通过在线的方式进行资料审核，审核通过后可进行网上授课等相关操作；	</span></p><p class=\"MsoNormal\"><span style=\"line-height: 1.5; font-size: 14px;\">3）签约平台需要具备哪些条件？</span></p><p class=\"MsoNormal\" style=\"margin-left:0cm;text-indent:0cm;\"><br/></p><p class=\"MsoNormal\"><span style=\"font-size: 14px;\">\r\n		① 教师资格证书	</span></p><p class=\"MsoNormal\"><span style=\"font-size: 14px;\">\r\n		② 高学历证书	</span></p><p class=\"MsoNormal\"><span style=\"font-size: 14px;\">\r\n		③ 专业证书	</span></p><p class=\"MsoNormal\"><span style=\"font-size: 14px;\">\r\n		④ 认证名师</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('2', '平台保障', 'serivce', '<p><span style=\"font-size: 14px;\">平台保障<br/>例如：</span></p><p><span style=\"font-size: 14px;\">&nbsp;实名认证</span></p><p><span style=\"font-size: 14px;\">&nbsp;。。。。</span></p><p><span style=\"font-size: 14px;\">。。。。</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('3', '平台流程', 'verify', '1.1	平台流程<br />\r\n	个人用户<br />\r\n	机构（名师）用户<br />\r\n	第二级页面展示<br />\r\n1.1.1	个人用户<br />\r\n注册流程<br />\r\na流程图展示<br />\r\n学生使用指南（如图1.1.1）<br />\r\n搜索老师<br />\r\n在跟我学平台搜索出适合自己的老师。<br />\r\n购买课时<br />\r\n选择适合自己的科目和上课方式，购买老师课时后，可获得老师联系方式，与老师确认上课时间。<br />\r\n约课上课<br />\r\n和老师确认上课时间后，在系统内向老师发起约课。老师确认约课后，双方按时上课。<br />\r\n支付课酬<br />\r\n上课结束后，在系统内确认上课并支付本次课程课酬。如超过24小时不确认，系统将自动确认并将课酬支付给老师。<br />\r\n评价老师<br />\r\n确认上课后，就本节课老师的表现点“赞”，整个课时订单结束后给予老师详细的评价。<br />\r\n（图1.1.1）&nbsp;<br />\r\n1.1.2	机构（名师）用户<br />\r\n签约入驻<br />\r\na流程图展示<br />\r\n机构（老师）操作指南（如图1.1.2）<br />\r\n入驻平台<br />\r\n完善个人信息至100%，并设置要教授的课时套餐。等到个人信息通过审核后，你就可以被学生搜索到了。<br />\r\n查看订单<br />\r\n老师在第一时间获知学生的信息以及购买的课程。<br />\r\n约课上课<br />\r\n老师在系统内接到学生约课请求，确认约课后，提前备课，在约定时间上课。<br />\r\n收到课酬<br />\r\n上课完成，学生在系统中确认上课后，课酬将划转到老师的资金中心。如果学生忘记确认，课酬将在上课结束后24小时自动划转。<br />\r\n评价学生<br />\r\n课时订单结束后，对学生的表现做出评价。<br />\r\n<img width=\"554\" height=\"478\" src=\"file://C:/Users/ADMINI~1/AppData/Local/Temp/msohtmlclip1/01/clip_image002.gif\" alt=\"1\" /><br />\r\n1.1.3	第二级页面展示<br />\r\n展示（注：平面制作，根据平台实际设计）<br />\r\nA平台流程<br />\r\n（1）个人用户<br />\r\n	搜索老师<br />\r\n	购买课时<br />\r\n	约课上课<br />\r\n	课酬支付<br />\r\n	评价老师<br />\r\na搜索老师<br />\r\n在跟我学平台搜索出适合自己的老师。<br />\r\nb购买课时<br />\r\n选择适合自己的科目和上课方式，购买老师课时后，可获得老师联系方式，与老师确认上课时间。<br />\r\nc约课上课<br />\r\n和老师确认上课时间后，在系统内向老师发起约课。老师确认约课后，双方按时上课。<br />\r\nd支付课酬<br />\r\n上课结束后，在系统内确认上课并支付本次课程课酬。如超过24小时不确认，系统将自动确认并将课酬支付给老师。<br />\r\ne评价老师<br />\r\n确认上课后，就本节课老师的表现点“赞”，整个课时订单结束后给予老师详细的评价。<br />\r\n（2）机构（老师）<br />\r\n	入驻平台<br />\r\n	查询订单<br />\r\n	约课上课<br />\r\n	收到课酬<br />\r\n	评价学生<br />\r\na入驻平台<br />\r\n完善个人信息至100%，并设置要教授的课时套餐。等到个人信息通过审核后，你就可以被学生搜索到了。<br />\r\n<br />\r\n<br />\r\nb查看订单<br />\r\n老师在第一时间获知学生的信息以及购买的课程。<br />\r\n<br />\r\n<br />\r\nc约课上课<br />\r\n老师在系统内接到学生约课请求，确认约课后，提前备课，在约定时间上课。<br />\r\n<br />\r\n<br />\r\nd收到课酬<br />\r\n上课完成，学生在系统中确认上课后，课酬将划转到老师的资金中心。如果学生忘记确认，课酬将在上课结束后24小时自动划转。<br />\r\n<br />\r\n<br />\r\ne评价学生<br />\r\n课时订单结束后，对学生的表现做出评价。<br />\r\n（3）平台支付（例，图1.3）<br />\r\n	支付宝<br />\r\n	微信支付<br />\r\n	快捷支付<br />\r\n	网上银行<br />\r\n	信用卡<br />\r\n	助学贷款<br />\r\n（图1.3）<br />\r\n&nbsp;<br />\r\nB上课方式<br />\r\n（1）线上<br />\r\n	实时互动<br />\r\n	不限地域<br />\r\n	优惠活动<br />\r\na现场教学<br />\r\n与老师面对面互动，学习氛围浓厚，注意力更易集中，效果更有保障<br />\r\n<br />\r\n<br />\r\nb地点自选<br />\r\n双方可协商上课地点，选择老师上门，学生上门，或第三方提供的场地<br />\r\nc设施齐备<br />\r\n线下上课更适合钢琴、舞蹈等需要专业设施和场地的学习需求<br />\r\n（2）线下<br />\r\n	现场教学<br />\r\n	自选地点<br />\r\n	上课设备<br />\r\na即时互动<br />\r\n通过跟我学在线教学工具在线上课，能够共享PPT等课程文档，利用IM工具即时沟通，随时解决课程问题<br />\r\nb不限地域<br />\r\n名师不在本地？不用担心，可选择你喜欢的名师远程上课；名师在本地？帮你节省上课途中的往返时间<br />\r\nc价格优惠<br />\r\n在线授课的价格通常会比线下授课价格便宜，选择在线上课，帮你节省更多学习开支<br />\r\n<br />\r\n<br />\r\nC平台保障<br />\r\n	丰富课程<br />\r\n	课程保障<br />\r\n	名师保障<br />\r\n	支付保障<br />\r\n	实时沟通<br />\r\n	随时退<br />\r\n（1）丰富课程<br />\r\n托福雅思或读研 &nbsp; UI画画和数理&nbsp;<br />\r\n精品名师任你选 &nbsp; 名师跟我学帮你找<br />\r\n（2）认证机构的课程保障<br />\r\n带有认证标记的机构经过跟我学官方认证，其课程是该类目下的优质课程。<br />\r\n认证机构的课程将提供更标准和优质的服务，如试学、课件可下载、配套习题练习、作业批改等，学生可在该机构获得完整学习计划和优秀老师指导。<br />\r\n（3）名师保障<br />\r\n学历身份要审核 &nbsp;教学资质零瑕疵&nbsp;<br />\r\n真实专业评价好 &nbsp;服务保障质量优<br />\r\n（4）支付保障<br />\r\n拥有“支付保障”标识的课程可以放心购买！<br />\r\n支付保障是跟我学为保障学员付费安全的官方服务，学员通过平台所支付的款项由跟我学保管，只有在课程结束后，款项才会划至机构账户，因此，学员可以通过跟我学放心购买课程。<br />\r\n（5）实时沟通<br />\r\n跟我学平台提供在线即时通讯工具，直接<br />\r\n联系老师，让沟通随时、随地、随心<br />\r\n（6）课程退款服务保障说明：<br />\r\n依据课程对应的退款方式进行退款，每种退款方式说明如下：<br />\r\n“课前随时退”“课后随时退”<br />\r\n退款条件：用户未进行过任务且未到课程开始时间。随到随学课程选择“课前随时退”不支持退款，试听课已开始课程不支持退款，用户申请退款金额为全额退款；<br />\r\nD常见问题<br />\r\n(1)不同的上课方式价格一样吗？<br />\r\n课程价格由老师统一设置，不同的上课方式一般来说价格会有差异。老师可能会把上课途中产生的费用计算在内，因此老师上门，协商地点的价格可能会高于学生上门，在线授课的方式。<br />\r\n(2)下单购买课时，支付完成后如何上课？<br />\r\n在跟我学下单购买了课时之后，需要通过平台向老师发起约课，我们会将你希望上课的时间，时长等信息通知给老师，也可以致电老师沟通细节，老师确认后，你就可以按照和老师约定的时间地点进行上课了。<br />\r\n(3)我是老师，入驻后怎么才能搜索到我？<br />\r\n为了保证平台上的学生能够全面了解要选择的老师，我们平台规定老师必须信息完善并且通过审核才能被搜索到。<br />\r\n(4)接到学生的约课后我该怎么办？<br />\r\n你可以根据学生预约的时间、上课方式、备注等信息确认自己能否上课，可以的话确认约课。如果你想要进一步确保约课成功，可以致电学生沟通细节，下载我们的APP能更及时的获取并处理学生的约课信息。等<br />\r\n1.2	名师签约<br />\r\n	联系平台<br />\r\n	后台审核<br />\r\n	签约成功<br />\r\n1.2.1	联系平台<br />\r\n	联系方式<br />\r\n	外地老师签约平台<br />\r\n	签约平台的条件<br />\r\n1）联系平台有哪些方式？<br />\r\n目前机构开通名师热线、微信、QQ、微博等联系方式；<br />\r\n<br />\r\n<br />\r\n2）外地老师可否签约平台？<br />\r\n可以通过在线的方式进行资料审核，审核通过后可进行网上授课等相关操作；<br />\r\n<br />\r\n<br />\r\n3）签约平台需要具备哪些条件？<br />\r\n① 教师资格证书<br />\r\n② 高学历证书<br />\r\n③ 专业证书<br />\r\n④ 认证名师<br />\r\n1.2.2	后台审核<br />\r\n	第一步，提交资料<br />\r\n	第二步，后台审核<br />\r\n	第三步，审核通过<br />\r\nA提交资料<br />\r\n1）需要提交哪些资料<br />\r\n相关资格证书（教师资格证书、高学历证书、专业证书、认证名师），个人资料；<br />\r\n2）提交方式<br />\r\n联系机构，开通系统邮箱，机构平台均可提交审核；<br />\r\n3）资料提交的有效期<br />\r\n申请入驻审核，提交资料需在3个工作日内提交，逾期需重新开通审核；<br />\r\n<br />\r\n<br />\r\nB后台审核<br />\r\n1）审核流程<br />\r\n联系平台——开通审核——提交资料——后台审核——审核通过——签约入驻<br />\r\n2）结果反馈<br />\r\n1、审核结果2个工作日反馈<br />\r\n2、采用网站反馈、电话通知、短信提醒、邮件等进行反馈<br />\r\n<br />\r\n<br />\r\nC审核通过<br />\r\n1）开通账户<br />\r\n审核通过后即可开通个人账户，进行授课相关操作，根据系统引导即可完成操作；<br />\r\n<br />\r\n<br />\r\n2）个人设置<br />\r\n开通账户，进入个人即可进行个人相关设置，平台课程、发布博文、资料简介、照片等<br />\r\n1.2.3	签约成功<br />\r\n	发布课程<br />\r\n	招生推广<br />\r\nA发布课程<br />\r\n签约成功即成为跟我学老师，可以进行课程发布等相关操作，课程助手为辅助工具；<br />\r\n<br />\r\n<br />\r\nB招生推广<br />\r\n平台支持个人老师推广招生，可使用平台提供的相关推广工具，付费操作可直接联系平台市场推广人员；<br />\r\n<br />\r\n<br />', '1', '1581432012');
INSERT INTO `sr_single` VALUES ('4', '支付协议', 'buy', '<p><span style=\"font-size: 14px;\">支付协议xxxxxxxxxxxxxxxxxxxxxx</span></p><h1 style=\"vertical-align: baseline;\"></h1>', '0', null);
INSERT INTO `sr_single` VALUES ('5', '学生注册协议', 'reg', '<p><span style=\"font-size: 14px;\">学生注册协议&nbsp;</span></p><p>1:xxxxxxxxxxxxx<br/></p><p>2:xxxxxxxxxxxx</p><p>.........................</p><p>操作成功默认同意此协议</p>', '0', null);
INSERT INTO `sr_single` VALUES ('6', '测试导航', 'test01', '<p>这是一个测试导航</p>', '1', null);
INSERT INTO `sr_single` VALUES ('7', '绑卡验证协议', '1', '<p><span style=\"font-size: 14px;\">《绑卡验证服务协议》</span></p><p style=\"white-space: normal;\">1:xxxxxxxxxxxxx<br/></p><p style=\"white-space: normal;\">2:xxxxxxxxxxxx</p><p style=\"white-space: normal;\">.........................</p><p style=\"white-space: normal;\">操作成功默认同意此协议</p><p><span style=\"font-size: 14px;\"><br/></span><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('8', '会员服务协议', 'vip', '<p style=\"white-space: normal;\"><br/></p><p style=\"white-space: normal;\">1:xxxxxxxxxxxxx<br/></p><p style=\"white-space: normal;\">2:xxxxxxxxxxxx</p><p style=\"white-space: normal;\">.........................</p><p style=\"white-space: normal;\">操作成功默认同意此协议</p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('9', '机构第一步', '3', '<p><span style=\"font-size: 14px;\">第一步，注册个人账号，登录个人中心，申请入驻</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('10', '第二步', '4', '<p style=\"white-space: normal;\"><span style=\"font-size: 14px;\">第二步，签订入驻协议，点击同意按钮即可，选择我已阅读并同意此协议，下一步</span></p><p style=\"white-space: normal;\"><br/></p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('11', '第三步', '5', '<p style=\"white-space: normal;\"><span style=\"font-size: 14px;\">第三步，资料提交，提供身份认证、相关经营资质等提交审核</span></p><p style=\"white-space: normal;\"><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('12', '第四步', '6', '<p><span style=\"font-size: 14px;\">第四步，后台审核，审核结果2个工作日反馈。</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('13', '第五步', '7', '<p><span style=\"font-size: 14px;\">第五步，审核通过，成功入驻</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('14', '注册第一步', '8', '<p><span style=\"font-size: 14px;\">第一步：登录网站 ，点击页面顶端“注册新用户”按钮，即进入填写注册信息页面。</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('15', '注册第二步', '9', '<p><span style=\"font-size: 14px;\">第二步：进入注册页面，填写相关信息。（合作网站账户注册，点击进去授权即可）</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('16', '后台审核', '10', '<p style=\"margin-left: 28px;white-space: normal\">l&nbsp; 第一步，提交资料</p><p style=\"margin-left: 28px;white-space: normal\">l&nbsp; 第二步，后台审核</p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 第三步，审核通过</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">A提交资料</span></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><span style=\"font-size: 14px\">1）需要提交哪些资料</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">相关资格证书（教师资格证书、高学历证书、专业证书、认证名师），个人资料；</span></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><span style=\"font-size: 14px\">2）提交方式</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">联系机构，开通系统邮箱，机构平台均可提交审核；</span></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><span style=\"font-size: 14px\">3）资料提交的有效期</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">申请入驻审核，提交资料需在3个工作日内提交，逾期需重新开通审核；</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">&nbsp;</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">B后台审核</span></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><span style=\"font-size: 14px\">1）审核流程</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">联系平台——开通审核——提交资料——后台审核——审核通过——签约入驻</span></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><span style=\"font-size: 14px\">2）结果反馈</span></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><span style=\"font-size: 14px\">1、审核结果2个工作日反馈</span></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><span style=\"font-size: 14px\">2、采用网站反馈、电话通知、短信提醒、邮件等进行反馈</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">&nbsp;</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">C审核通过</span></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><span style=\"font-size: 14px\">1）开通账户</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">审核通过后即可开通个人账户，进行授课相关操作，根据系统引导即可完成操作；</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">&nbsp;</span></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><span style=\"font-size: 14px\">2）个人设置</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">开通账户，进入个人即可进行个人相关设置，平台课程、发布博文、资料简介、照片等</span></p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('17', '签约成功', '11', '<p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 发布课程</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 招生推广</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">A发布课程</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">签约成功即成为跟我学老师，可以进行课程发布等相关操作，课程助手为辅助工具；</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">&nbsp;</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">B招生推广</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">平台支持个人老师推广招生，可使用平台提供的相关推广工具，付费操作可直接联系平台市场推广人员；</span></p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('18', '个人用户', '12', '<p style=\"white-space: normal\">注册及使用流程<br/></p><p style=\"white-space: normal\"><br/></p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('19', '机构(名师)用户', '13', '<p style=\"white-space: normal\">xxxxxxxxxxxxxx</p><p style=\"white-space: normal\">xxxxxxxxxxxxxxxxxxxxxxxxx</p><p style=\"white-space: normal\"><br/></p><p><strong><br/></strong></p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('20', '第二级页面展示', '14', '<p style=\"white-space: normal\"><strong>A</strong><strong>平台流程</strong></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><span style=\"font-size: 14px\">（1）个人用户</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 搜索老师</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 购买课时</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 约课上课</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 课酬支付</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 评价老师</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">a搜索老师</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">搜索出适合自己的老师。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">&nbsp;</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">b购买课时</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">选择适合自己的科目和上课方式，购买老师课时后，可获得老师联系方式，与老师确认上课时间。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">&nbsp;</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">c约课上课</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">和老师确认上课时间后，在系统内向老师发起约课。老师确认约课后，双方按时上课。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">&nbsp;</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">d支付课酬</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">上课结束后，在系统内确认上课并支付本次课程课酬。如超过24小时不确认，系统将自动确认并将课酬支付给老师。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">&nbsp;</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">e评价老师</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">确认上课后，就本节课老师的表现点“赞”，整个课时订单结束后给予老师详细的评价。</span></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><span style=\"font-size: 14px\">（2）机构（老师）</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 入驻平台</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 查询订单</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 约课上课</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 收到课酬</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 评价学生</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">a入驻平台</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">完善个人信息至100%，并设置要教授的课时套餐。等到个人信息通过审核后，你就可以被学生搜索到了。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">&nbsp;</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">b查看订单</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">老师在第一时间获知学生的信息以及购买的课程。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">&nbsp;</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">c约课上课</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">老师在系统内接到学生约课请求，确认约课后，提前备课，在约定时间上课。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">&nbsp;</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">d收到课酬</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">上课完成，学生在系统中确认上课后，课酬将划转到老师的资金中心。如果学生忘记确认，课酬将在上课结束后24小时自动划转。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">&nbsp;</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">e评价学生</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">课时订单结束后，对学生的表现做出评价。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">（3）平台支付（例，图1.3）</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 支付宝</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 微信支付</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 快捷支付</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 网上银行</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 信用卡</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 助学贷款</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\"><strong>（图</strong><strong>1.3</strong><strong>）</strong></span></p><p style=\"white-space: normal\"><br/></p><p style=\"white-space: normal\"><br/></p><p style=\"white-space: normal\"><strong><strong>B</strong><strong>上课方式</strong></strong></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><span style=\"font-size: 14px\">（1）线上</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 实时互动</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 不限地域</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 优惠活动</span></p><p style=\"text-indent: 0;white-space: normal;vertical-align: baseline\"><span style=\"font-size: 14px\">a现场教学</span></p><p style=\"text-indent: 0;white-space: normal;vertical-align: baseline\"><span style=\"font-size: 14px\"><br/></span></p><p style=\"text-indent: 0;white-space: normal;vertical-align: baseline\"><span style=\"text-indent: 0;font-size: 14px\">与老师面对面互动，学习氛围浓厚，注意力更易集中，效果更有保障 &nbsp;</span></p><p style=\"white-space: normal;vertical-align: baseline\"><span style=\"text-indent: 0;font-size: 14px\">b地点自选</span></p><p style=\"white-space: normal;vertical-align: baseline\"><span style=\"text-indent: 0;font-size: 14px\"><br/></span></p><p style=\"text-indent: 0;white-space: normal;vertical-align: baseline\"><span style=\"font-size: 14px\">双方可协商上课地点，选择老师上门，学生上门，或第三方提供的场地</span></p><p style=\"text-indent: 0;white-space: normal;vertical-align: baseline;background: white\"><span style=\"font-size: 14px\">c设施齐备</span></p><p style=\"text-indent: 0;white-space: normal;vertical-align: baseline;background: white\"><span style=\"font-size: 14px\"><br/></span></p><p style=\"white-space: normal;background: white;vertical-align: baseline\"><span style=\"font-size: 14px\">线下上课更适合钢琴、舞蹈等需要专业设施和场地的学习需求</span></p><p style=\"text-indent: 0;white-space: normal;background: white;vertical-align: baseline\"><span style=\"font-size: 14px\">（2）线下</span></p><p style=\"margin-left: 28px;white-space: normal;background: white;vertical-align: baseline\"><span style=\"font-size: 14px\">l&nbsp; 现场教学</span></p><p style=\"margin-left: 28px;white-space: normal;background: white;vertical-align: baseline\"><span style=\"font-size: 14px\">l&nbsp; 自选地点</span></p><p style=\"margin-left: 28px;white-space: normal;background: white;vertical-align: baseline\"><span style=\"font-size: 14px\">l&nbsp; 上课设备</span></p><p style=\"text-indent: 0;white-space: normal;vertical-align: baseline;background: white\"><span style=\"font-size: 14px\">a即时互动</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\"><br/></span></p><p style=\"text-indent: 0;white-space: normal;vertical-align: baseline;background: white\"><span style=\"font-size: 14px\">b不限地域</span></p><p style=\"white-space: normal;background: white;vertical-align: baseline\"><span style=\"font-size: 14px\">名师不在本地？不用担心，可选择你喜欢的名师远程上课；名师在本地？帮你节省上课途中的往返时间</span></p><p style=\"white-space: normal;background: white;vertical-align: baseline\"><span style=\"font-size: 14px\"><br/></span></p><p style=\"text-indent: 0;white-space: normal;vertical-align: baseline;background: white\"><span style=\"font-size: 14px\">c价格优惠</span></p><p style=\"white-space: normal;background: white;vertical-align: baseline\"><span style=\"font-size: 14px\">在线授课的价格通常会比线下授课价格便宜，选择在线上课，帮你节省更多学习开支</span></p><p style=\"white-space: normal;background: white;vertical-align: baseline\"><br/></p><h3 style=\"white-space: normal\"><span style=\"font-size: 16px\">C平台保障</span></h3><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 丰富课程</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 课程保障</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 名师保障</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 支付保障</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 实时沟通</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 随时退</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">（1）丰富课程</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">托福雅思或读研 &nbsp; UI画画和数理&nbsp;<br/>精品名师任你选 &nbsp; 名师跟我学帮你找</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">（2）认证机构的课程保障</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">平台认证，其课程是该类目下的优质课程。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">认证机构的课程将提供更标准和优质的服务，如试学、课件可下载、配套习题练习、作业批改等，学生可在该机构获得完整学习计划和优秀老师指导。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">（3）名师保障</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">学历身份要审核&nbsp; 教学资质零瑕疵&nbsp;<br/>真实专业评价好 &nbsp;服务保障质量优</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">（4）支付保障</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">拥有“支付保障”标识的课程可以放心购买！</span></p><p style=\"white-space: normal\">支付都暂时托管于平台</p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">（5）实时沟通</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">联系老师，让沟通随时、随地、随心</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">（6）课程退款服务保障说明：</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">依据课程对应的退款方式进行退款，每种退款方式说明如下：</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">“课前随时退”“课后随时退”</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">退款条件：用户未进行过任务且未到课程开始时间。随到随学课程选择“课前随时退”不支持退款，试听课已开始课程不支持退款，用户申请退款金额为全额退款；</span></p><h3 style=\"white-space: normal\"><span style=\"font-size: 16px\">D常见问题</span></h3><p style=\"white-space: normal\"><span style=\"font-size: 14px\">(1)不同的上课方式价格一样吗？</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">课程价格由老师统一设置，不同的上课方式一般来说价格会有差异。老师可能会把上课途中产生的费用计算在内，因此老师上门，协商地点的价格可能会高于学生上门，在线授课的方式。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">(2)下单购买课时，支付完成后如何上课？</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">下单购买了课时之后，需要通过平台向老师发起约课，我们会将你希望上课的时间，时长等信息通知给老师，也可以致电老师沟通细节，老师确认后，你就可以按照和老师约定的时间地点进行上课了。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">(3)我是老师，入驻后怎么才能搜索到我？</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">为了保证平台上的学生能够全面了解要选择的老师，我们平台规定老师必须信息完善并且通过审核才能被搜索到。</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">(4)接到学生的约课后我该怎么办？</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">你可以根据学生预约的时间、上课方式、备注等信息确认自己能否上课，可以的话确认约课。如果你想要进一步确保约课成功，可以致电学生沟通细节，下载我们的APP能更及时的获取并处理学生的约课信息。等</span><br/></p><p><span style=\"font-size: 14px\"><br/></span></p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('21', '机构入驻协议', 'verify', '<p><span style=\"font-size: 14px;\">入驻协议：</span><br/><span style=\"font-size: 14px;\">xxxxxxxxxxxxxxxxxxxxxxxxxxxx</span></p><p><span style=\"font-size: 14px;\">操作成功,即时生效</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('22', '合作专区', '16', '<p><span style=\"font-size: 14px;\">合作专区</span><br/><span style=\"font-size: 14px;\">&nbsp; &nbsp; 网校招聘</span><br/><span style=\"font-size: 14px;\">邮箱:.................</span><br/><span style=\"font-size: 14px;\">网盟合作</span><br/><span style=\"font-size: 14px;\">邮箱：................</span><br/><span style=\"font-size: 14px;\">媒体合作</span><br/><span style=\"font-size: 14px;\">**老师</span><br/><span style=\"font-size: 14px;\">邮箱：................</span><br/><span style=\"font-size: 14px;\">活动合作</span><br/><span style=\"font-size: 14px;\">&nbsp; &nbsp; **老师</span><br/><span style=\"font-size: 14px;\">邮箱：................</span><br/><span style=\"font-size: 14px;\">课程合作</span><br/><span style=\"font-size: 14px;\">**老师</span><br/><span style=\"font-size: 14px;\">邮箱：.................</span><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('23', '机构帮助', '17', '<p style=\"white-space: normal\"><strong>机构入驻</strong></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 电脑端下载直播软件</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 机构如何入驻</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 机构修改变更</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 平台展示</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 老师添加</span></p><p style=\"white-space: normal\"><strong>①</strong><strong>&nbsp;</strong><strong>机构如何入驻</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">进入网站首页、点击右上方机构平台按钮</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">机构注册——提交资料——入驻审核——审核通过——签订入驻协议，入驻成功</span></p><p style=\"white-space: normal\"><strong>②</strong><strong>&nbsp;</strong><strong>平台目前支持哪些用户入驻</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">(1) 有营业执照的机构→营业执照标有教育、培训、咨询类机构用户入驻<br/>(2) 没有营业执照的机构→。需要提供可证明的教育资质证书，例如办学许可证等。</span></p><p style=\"white-space: normal\"><strong>③</strong><strong>&nbsp;</strong><strong>修改变更</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">在机构首页的设置里，支持修改个人注册信息和机构的展示信息。</span></p><p style=\"white-space: normal\"><strong>④</strong><strong>&nbsp;</strong><strong>平台展示</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">机构需完善基本信息（机构Logo、简介、视频、资源、个性化标签）。以上是机构展示必要条件；如缺失，需进入平台机构主页进行设置、添加。</span></p><p style=\"white-space: normal\"><strong>⑤</strong><strong>&nbsp;</strong><strong>老师添加</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">机构和老师沟通后老师同意加入您的机构，在后台点击“添加老师”，填写老师的真实姓名和电话进行添加，添加完后，上课登录即可。</span></p><p style=\"white-space: normal\"><strong>A</strong><strong>网校装修</strong></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 添加图片</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 自定义素材</span></p><p style=\"white-space: normal\"><strong></strong><strong>自定义区素材添加？</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">自定义区支持图片、文字、链接等多种多媒体展现形式，展示在焦点图下面，更好地突出机构特色。</span></p><p style=\"white-space: normal\"><strong></strong><strong>怎么做课程促销？</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">机构可以创建优惠券、给学员发送优惠券的功能，以此来举办优惠促销活动</span></p><p style=\"white-space: normal\"><strong></strong><strong>如何设置机构优惠券？</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">机构可自定义优惠券的面值、张数、有效期等使用条件</span></p><p style=\"margin-left: 0;text-indent: 0;white-space: normal\"><strong>1）</strong><strong>教学管理</strong></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 添加课程</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 老师添加</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 机构排课</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 联系方式</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 教学效果</span></p><p style=\"margin-left: 28px;white-space: normal\"><span style=\"font-size: 14px\">l&nbsp; 老师解约</span></p><p style=\"white-space: normal\"><strong>A</strong><strong>添加课程</strong></p><p style=\"white-space: normal\"><strong>①</strong><strong>&nbsp;</strong><strong>怎么添加课程？</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">点击添加课程，可以选择添加相应机构的老师的班课，然后进入老师后台中的“课程设置”开设班课。</span></p><p style=\"white-space: normal\"><strong>②</strong><strong>&nbsp;</strong><strong>添加老师？</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">在后台点击“添加老师”，填写老师的真实姓名和电话进行添加，被添加老师手机会收到一个登陆密码，老师需在30天内登录网站激活。如果老师已经入驻，可以发送邀请，老师可以在7日内接受机构邀请，成为机构老师。</span></p><p style=\"white-space: normal\"><strong>③</strong><strong>&nbsp;</strong><strong>一天可以添加多少名老师？</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">系统现在设置，机构后台每天最多可以添加10名老师。</span></p><p style=\"white-space: normal\"><strong>C</strong><strong>机构排课</strong></p><p style=\"white-space: normal\"><strong>④</strong><strong>&nbsp;</strong><strong>查看本机构老师的排课？</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">我们为机构提供课表服务，本机构所有老师的课程在课表里一览无余，方便查询。</span></p><p style=\"white-space: normal\"><strong>联系方式</strong></p><p style=\"white-space: normal\"><strong>⑤</strong><strong>&nbsp;</strong><strong>学员联系方式？</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">在后台可以直接查看学生联系方式，在线和学生取得联系。</span></p><p style=\"white-space: normal\"><strong>教学效果</strong></p><p style=\"white-space: normal\"><strong>⑥</strong><strong>&nbsp;</strong><strong>老师教学效果？</strong></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">在后台可以查看学生对老师的教学评价，得到教学质量的真实反馈。</span></p><p style=\"white-space: normal\"><strong>老师解约</strong></p><p style=\"white-space: normal\">⑦老师解约？</p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">经与老师就解约事宜协商一致后，可以在机构后台进行解约操作。</span></p><p><span style=\"font-size: 14px\"><br/></span></p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('24', '机构入驻协议', '18', '<p style=\"white-space: normal\"><span style=\"font-size: 14px\">Eduline机构入驻协议：<br/>欢迎加入Eduline！Eduline网站由成都赛新科技有限公司负责运营，专注于创新型学习服务，致力于打造全方位学习资源交易服务平台，<br/>机构在入驻Eduline之前请您仔细阅读本注册协议，在您点击“同意”按钮后，本协议即构成对双方有约束力的法律文件。<br/>一、定义<br/>机构是指合法成立并具有法人主体资格的企业或个人。<br/>二、合作方式及入驻流程说明<br/>1、机构通过注册并提交入驻Eduline平台网校申请，平台审核通过后，机构即刻拥有专属网校，机构可在网校展示其品牌logo、完善基本信息、相关简介、课程模块、照片、教学资源等内容。机构可将其自有讲师及机构资源运营到专属网校。机构通过给机构提供优秀师资、优质课程和良好的服务等各种方式，维护专属网校，创造更多的线上交易额。Eduline通过网络和地面推广积极提升机构的业界知名度、为机构创造更大的价值。Eduline为机构网校提供技术服务。<br/>2、机构入驻应对应下列流程：<br/>注册--资料提交--审核--签约进入Eduline机构平台<br/>三、双方权利义务及法律责任<br/>1、机构应对自身提交及上传Eduline的资料信息的真实性、合法性、有效性承担相应法律责任。<br/>2、机构需在征得讲师本人同意的前提下将讲师运营至Eduline平台，并负责审核注册讲师相关资质的真实性与合法性。机构审核讲师的资质文件包括但不限于身份证、讲师证、学历证等。机构应为注册讲师拍摄自我介绍视频和授课演示视频。<br/>3、机构应核准注册讲师的教学水平达到同行业中等及中等以上的教学水准。<br/>4、机构应加强对注册讲师的管理，敦促注册讲师严格遵守Eduline“网站条款“的约定，合法使用Eduline的服务。机构及注册讲师均不得利用Eduline平台发布虚假信息、侵权信息及其他违法信息，不得利用Eduline的服务从事违法活动。<br/>5、机构应敦促注册讲师及时维护其个人主页的活跃度，并跟踪确认其提供的资料真实、准确、完整、合法有效，提供资料如有变动的，应及时更新其资料。如果机构提供的资料不合法、不真实、不准确、不详尽的，机构需承担因此引起的相应责任及后果，并且Eduline保留终止机构使用Eduline各项服务的权利；<br/>6、机构及注册讲师有责任妥善保管自己的帐号及密码，Eduline也应采取适当的技术措施，共同维护机构和注册讲师帐号的安全性。<br/>7、Eduline有权受理学员对机构注册讲师投诉事件，机构应积极协助并妥善处理。<br/>8、Eduline有权保留并合理使用机构及其讲师注册及上传的所有信息。<br/>9、Eduline谨慎使用机构的所有信息，非依法律规定及机构许可，不得向任何第三方透露机构信息。Eduline对相关信息采用专业加密存储与传输方式，保障机构个人信息的安全。<br/>10、机构上传Eduline的任何内容如涉嫌侵犯第三方合法权益的，Eduline有权采取删除、屏蔽或断开链接等技术措施，机构须独立承担因侵权所产生法律责任。<br/>四、知识产权说明<br/>1、机构在Eduline发布书稿、课件等信息或作品的，机构应独立享有相关著作权。如受到第三方的投诉或举报，机构应独立承担相关法律责任。<br/>2、Eduline提供的网络服务中包含的任何文本、图片、图形、音频和/或视频资料均受版权、商标和/或其它财产所有权法律的保护, 未经相关权利人同意, 上述资料均不得在任何媒体直接或间接发布、播放、出于播放或发布目的而改写或再发行, 或者被用于其他任何商业目的。<br/>3、机构未经Eduline书面许可不得擅自使用、不得以任何形式和理由对Eduline文字及图形标识的任何部分进行使用、复制、修改、传播或与其他产品捆绑使用，不得以任何可能引起消<br/>费者混淆的方式或任何诋毁或诽谤Eduline的方式用于任何商品或服务上。<br/>4、机构按照本协议第三条第2项要求为注册讲师拍摄的视频，相关著作权归Eduline所有，机构除上传Eduline之外，非经Eduline书面许可，不得用作任何其他用途。<br/>5、软件使用：机构需要下载Eduline提供的手机/pad软件并安装后方得以从客户端使用Eduline所提供的服务。Eduline在此授予机构免费的、不可转让的、非独占的全球性个人许可，允许机构使用由Eduline提供的、包含在服务中的软件。但是，机构不得复制、修改、发布、出售或出租Eduline的服务软件或所含软件的任何部分，也不得进行反向工程或试图提取该软件的源代码。<br/>五、免责条款<br/>基于包括但不限于下列Eduline不可控制的原因或并非Eduline的过错所造成的损失，机构及注册讲师应自行承担或向有关责任方追偿：<br/>1、不可抗力事件导致的服务中断；<br/>2、由于受到计算机病毒、木马或其他恶意程序、黑客攻击的破坏等不可抗拒因素可能引起的信息丢失、泄漏等风险；<br/>3、机构的电脑软件、系统、硬件和通信线路出现故障或自身操作不当；<br/>4、由于网络信号不稳定等原因所引起的登录失败、资料同步不完整、页面打开速度慢等；<br/>5、机构发布的内容被他人转发、复制等传播可能带来的风险和责任；<br/>6、其他Eduline无法控制的原因；<br/>7、如因系统维护或升级而需要暂停网络服务，Eduline将事先在网站发布通知。<br/>六、法律适用与争议解决<br/>1、本协议的履行与解释均适用中华人民共和国法律。<br/>2、Eduline与机构之间应以友好协商方式解决协议履行过程中产生的争议与纠纷，协商无效时，应提交当地法院通过诉讼解决。<br/>七、本协议条款的修改权与可分性<br/>1、为更好地提供服务并符合相关监管政策，本公司有权在必要时单方修改或变更本服务协议之内容，并将通过本公司网站公布最新的服务协议，无需另行单独通知。<br/>2、本协议条款中任何一条被视为无效或因任何理由不可执行，不影响任何其余条款的有效性和可执行性。<br/>八、通知方式<br/>Eduline将采用在网站上发布通知公告或其他有效方式与机构进行联系。机构同意用网站发布通知方式接收所有协议、通知、披露和其他信息。<br/>九、协议生效<br/>本协议从机构点击同意开始，即时生效。</span></p><p><span style=\"font-size: 14px\"><br/></span></p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('25', '讲师入驻协议', '19', '<p style=\"white-space: normal;\"><span style=\"font-size: 14px\">入驻协议：</span></p><p style=\"white-space: normal;\"><span style=\"font-size: 14px\">XXXXxxxxxx<br/></span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('26', '讲师帮助', '20', '<p style=\"white-space: normal\">xxxxxxxxxxxxxxx<br/></p><p><span style=\"font-size: 14px\"><br/></span></p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('27', '关于我们', '21', '<p style=\"white-space: normal\"><br/></p><p style=\"white-space: normal;vertical-align: middle;color: rgb(102, 102, 102);font-family: &#39;microsoft yahei&#39;;background-color: rgb(255, 255, 255);text-align: center\"><span style=\"font-size: 14px\"></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; font-size: 14px; color: rgb(68, 68, 68);\">合肥市思睿源信息技术有限公司(前身思睿软件)成立于2011年。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; font-size: 14px; color: rgb(68, 68, 68);\">2014开始打造代运管理系统,为UU代运,JSD等提供长期稳定的服务. 产品构成 PC + APP.</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; font-size: 14px; color: rgb(68, 68, 68);\"><a href=\"http://dy10.siruisoft.cn/\" target=\"_blank\" style=\"border: 0px; color: rgb(69, 69, 69); text-decoration-line: none;\">在线试用</a></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; font-size: 14px; color: rgb(68, 68, 68);\">2018开始从开源基础上打造在线云教育系统,可为企业快速部署在线教育平台.</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; font-size: 14px; color: rgb(68, 68, 68);\">产品构成: pc + 小程序 + APP&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; font-size: 14px; color: rgb(68, 68, 68);\"><br/></p><p style=\"white-space: normal;vertical-align: middle;color: rgb(102, 102, 102);font-family: &#39;microsoft yahei&#39;;background-color: rgb(255, 255, 255);text-align: center\"><span style=\"font-size: 14px\"></span><br/></p><p style=\"white-space: normal;vertical-align: middle;color: rgb(102, 102, 102);font-family: &#39;microsoft yahei&#39;;background-color: rgb(255, 255, 255)\"><br/></p><p style=\"white-space: normal\"><br/></p><p style=\"white-space: normal;text-align: center\"><br/></p><p style=\"white-space: normal;text-align: center\"><br/></p><p style=\"white-space: normal\"><br/></p><p style=\"white-space: normal\"><br/></p><p style=\"white-space: normal;vertical-align: middle;color: rgb(102, 102, 102);font-family: &#39;microsoft yahei&#39;;background-color: rgb(255, 255, 255)\"><span style=\"font-size: 14px\"><br/></span><br/></p><p style=\"white-space: normal\"><br/></p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('28', '平台保障', '22', '<p><span style=\"font-size: 14px;\">平台保障</span><br/><span style=\"font-size: 14px;\">xxxxxxxxxxxxxxxxxxxx</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('29', '平台流程', '23', '<p><span style=\"font-size: 14px;\">平台流程</span><br/><span style=\"font-size: 14px;\">l &nbsp;个人用户</span><br/><span style=\"font-size: 14px;\">l &nbsp;机构（名师）用户</span><br/><span style=\"font-size: 14px;\">l &nbsp;第二级页面展示</span><br/><span style=\"font-size: 14px;\">个人用户</span><br/><span style=\"font-size: 14px;\">学生使用指南</span><br/><span style=\"font-size: 14px;\">搜索讲师或机构</span><br/><span style=\"font-size: 14px;\">在平台搜索出适合自己的讲师。</span><br/><span style=\"font-size: 14px;\">购买课时</span><br/><span style=\"font-size: 14px;\">选择适合自己的科目和上课方式，购买讲师课时后，可获得讲师联系方式，与讲师确认上课时间。</span><br/><span style=\"font-size: 14px;\">约课上课</span><br/><span style=\"font-size: 14px;\">和讲师确认上课时间后，在系统内向讲师发起约课。讲师确认约课后，双方按时上课。</span><br/><span style=\"font-size: 14px;\">支付课酬</span><br/><span style=\"font-size: 14px;\">上课结束后，在系统内确认上课并支付本次课程课酬。如超过24小时不确认，系统将自动确认并将课酬支付给讲师。</span><br/><span style=\"font-size: 14px;\">评价讲师</span><br/><span style=\"font-size: 14px;\">确认上课后，就本节课讲师的表现点“赞”，整个课时订单结束后给予讲师详细的评价。</span><br/><span style=\"font-size: 14px;\">机构（名师）用户</span><br/><span style=\"font-size: 14px;\">签约入驻</span><br/><span style=\"font-size: 14px;\">入驻平台</span><br/><span style=\"font-size: 14px;\">完善个人信息至100%，等到个人信息通过审核后，你就可以被学生搜索到了。</span><br/><span style=\"font-size: 14px;\">查看订单</span><br/><span style=\"font-size: 14px;\">讲师在第一时间获知学生的信息以及购买的课程。</span><br/><span style=\"font-size: 14px;\">约课上课</span><br/><span style=\"font-size: 14px;\">讲师在系统内接到学生约课请求，确认约课后，提前备课，在约定时间上课。</span><br/><span style=\"font-size: 14px;\">收到课酬</span><br/><span style=\"font-size: 14px;\">上课完成，学生在系统中确认上课后，课酬将划转到讲师的资金中心。如果学生忘记确认，课酬将在上课结束后24小时自动划转。</span><br/><span style=\"font-size: 14px;\">评价学生</span><br/><span style=\"font-size: 14px;\">课时订单结束后，对学生的表现做出评价。</span><br/><span style=\"font-size: 14px;\">A平台流程</span><br/><span style=\"font-size: 14px;\">（1）个人用户</span><br/><span style=\"font-size: 14px;\">l &nbsp;搜索讲师</span><br/><span style=\"font-size: 14px;\">l &nbsp;购买课时</span><br/><span style=\"font-size: 14px;\">l &nbsp;约课上课</span><br/><span style=\"font-size: 14px;\">l &nbsp;课酬支付</span><br/><span style=\"font-size: 14px;\">l &nbsp;评价讲师</span><br/><span style=\"font-size: 14px;\">a搜索讲师</span><br/><span style=\"font-size: 14px;\">在平台搜索出适合自己的讲师。</span><br/><span style=\"font-size: 14px;\">b购买课时</span><br/><span style=\"font-size: 14px;\">选择适合自己的科目和上课方式，购买讲师课时后，与讲师确认上课时间。</span><br/><span style=\"font-size: 14px;\">c约课上课</span><br/><span style=\"font-size: 14px;\">和讲师确认上课时间后，在系统内向讲师发起约课。讲师确认约课后，双方按时上课。</span><br/><span style=\"font-size: 14px;\">d支付课酬</span><br/><span style=\"font-size: 14px;\">上课结束后，在系统内确认上课并支付本次课程课酬。如超过24小时不确认，系统将自动确认并将课酬支付给讲师。</span><br/><span style=\"font-size: 14px;\">e评价讲师</span><br/><span style=\"font-size: 14px;\">确认上课后，就本节课讲师的表现点“赞”，整个课时订单结束后给予讲师详细的评价。</span><br/><span style=\"font-size: 14px;\">（2）机构（讲师）</span><br/><span style=\"font-size: 14px;\">l &nbsp;入驻平台</span><br/><span style=\"font-size: 14px;\">l &nbsp;查询订单</span><br/><span style=\"font-size: 14px;\">l &nbsp;约课上课</span><br/><span style=\"font-size: 14px;\">l &nbsp;收到课酬</span><br/><span style=\"font-size: 14px;\">l &nbsp;评价学生</span><br/><span style=\"font-size: 14px;\">a入驻平台</span><br/><span style=\"font-size: 14px;\">完善个人信息至100%，等到个人信息通过审核后，你就可以被学生搜索到了。</span><br/><span style=\"font-size: 14px;\">b查看订单</span><br/><span style=\"font-size: 14px;\">讲师在第一时间获知学生的信息以及购买的课程。</span><br/><span style=\"font-size: 14px;\">c约课上课</span><br/><span style=\"font-size: 14px;\">讲师在系统内接到学生约课请求，确认约课后，提前备课，在约定时间上课。</span><br/><span style=\"font-size: 14px;\">d收到课酬</span><br/><span style=\"font-size: 14px;\">上课完成，学生在系统中确认上课后，课酬将划转到讲师的资金中心。如果学生忘记确认，课酬将在上课结束后24小时自动划转。</span><br/><span style=\"font-size: 14px;\">（3）平台支付</span><br/><span style=\"font-size: 14px;\">l &nbsp;支付宝</span><br/><span style=\"font-size: 14px;\">l &nbsp;微信支付</span><br/><span style=\"font-size: 14px;\">l &nbsp;快捷支付</span><br/><span style=\"font-size: 14px;\">l &nbsp;网上银行</span><br/><span style=\"font-size: 14px;\">l &nbsp;信用卡</span><br/><span style=\"font-size: 14px;\">B上课方式</span><br/><span style=\"font-size: 14px;\">（1）线上</span><br/><span style=\"font-size: 14px;\">l &nbsp;实时互动</span><br/><span style=\"font-size: 14px;\">l &nbsp;不限地域</span><br/><span style=\"font-size: 14px;\">l &nbsp;优惠活动</span><br/><span style=\"font-size: 14px;\">A线下现场公开课</span><br/><span style=\"font-size: 14px;\">与讲师面对面互动，学习氛围浓厚，注意力更易集中，效果更有保障</span><br/><span style=\"font-size: 14px;\">c设施齐备</span><br/><span style=\"font-size: 14px;\">线下上课更适合钢琴、舞蹈等需要专业设施和场地的学习需求</span><br/><span style=\"font-size: 14px;\">（2）线下</span><br/><span style=\"font-size: 14px;\">l &nbsp;现场教学</span><br/><span style=\"font-size: 14px;\">l &nbsp;自选地点</span><br/><span style=\"font-size: 14px;\">l &nbsp;上课设备</span><br/><span style=\"font-size: 14px;\">通过在线直播教学工具在线上课，能够共享PPT等课程文档，利用IM工具即时沟通，随时解决课程问题</span><br/><span style=\"font-size: 14px;\">b不限地域</span><br/><span style=\"font-size: 14px;\">名师不在本地？不用担心，可选择你喜欢的名师远程上课；名师在本地？帮你节省上课途中的往返时间</span><br/><span style=\"font-size: 14px;\">c价格优惠</span><br/><span style=\"font-size: 14px;\">在线授课的价格通常会比线下授课价格便宜，选择在线上课，帮你节省更多学习开支</span><br/><span style=\"font-size: 14px;\">C平台保障</span><br/><span style=\"font-size: 14px;\">l &nbsp;丰富课程</span><br/><span style=\"font-size: 14px;\">l &nbsp;课程保障</span><br/><span style=\"font-size: 14px;\">l &nbsp;名师保障</span><br/><span style=\"font-size: 14px;\">l &nbsp;支付保障</span><br/><span style=\"font-size: 14px;\">l &nbsp;实时沟通</span><br/><span style=\"font-size: 14px;\">l &nbsp;随时退</span><br/><span style=\"font-size: 14px;\">（1）丰富课程</span><br/><span style=\"font-size: 14px;\">精品名师任你选 &nbsp; 名师机构帮你找</span><br/><span style=\"font-size: 14px;\">（2）认证机构的课程保障</span><br/><span style=\"font-size: 14px;\">带有认证标记的机构经过官方认证，其课程是该类目下的优质课程。</span><br/><span style=\"font-size: 14px;\">认证机构的课程将提供更标准和优质的服务，如试学、课件可下载、配套习题练习、作业批改等，学生可在该机构获得完整学习计划和优秀讲师指导。</span><br/><span style=\"font-size: 14px;\">（3）名师保障</span><br/><span style=\"font-size: 14px;\">学历身份要审核 &nbsp;教学资质零瑕疵&nbsp;</span><br/><span style=\"font-size: 14px;\">真实专业评价好 &nbsp;服务保障质量优</span><br/><span style=\"font-size: 14px;\">（4）支付保障</span><br/><span style=\"font-size: 14px;\">拥有“支付保障”标识的课程可以放心购买！</span><br/><span style=\"font-size: 14px;\">支付保障是为保障学员付费安全的官方服务，学员通过平台所支付的款项由保管，只有在课程结束后，款项才会划至机构账户，因此，学员可以通过放心购买课程。</span><br/><span style=\"font-size: 14px;\">（5）实时沟通</span><br/><span style=\"font-size: 14px;\">联系讲师，让沟通随时、随地、随心</span><br/><span style=\"font-size: 14px;\">名师签约</span><br/><span style=\"font-size: 14px;\">l &nbsp;联系机构</span><br/><span style=\"font-size: 14px;\">l &nbsp;后台审核</span><br/><span style=\"font-size: 14px;\">l &nbsp;签约成功</span><br/><span style=\"font-size: 14px;\">联系平台</span><br/><span style=\"font-size: 14px;\">l &nbsp;联系方式</span><br/><span style=\"font-size: 14px;\">l &nbsp;外地讲师签约平台机构</span><br/><span style=\"font-size: 14px;\">l &nbsp;签约平台机构的条件</span><br/><span style=\"font-size: 14px;\">1）联系平台有哪些方式？</span><br/><span style=\"font-size: 14px;\">目前机构开通名师热线、微信、QQ、微博等联系方式；</span><br/><span style=\"font-size: 14px;\">2）外地讲师可否签约机构平台？</span><br/><span style=\"font-size: 14px;\">可以通过在线的方式进行资料审核，审核通过后可进行网上授课等相关操作；</span><br/><span style=\"font-size: 14px;\">3）签约平台需要具备哪些条件？</span><br/><span style=\"font-size: 14px;\">① 教师资格证书</span><br/><span style=\"font-size: 14px;\">② 高学历证书</span><br/><span style=\"font-size: 14px;\">③ 专业证书</span><br/><span style=\"font-size: 14px;\">④ 认证名师</span><br/><span style=\"font-size: 14px;\">后台审核</span><br/><span style=\"font-size: 14px;\">l &nbsp;第一步，提交资料</span><br/><span style=\"font-size: 14px;\">l &nbsp;第二步，后台审核</span><br/><span style=\"font-size: 14px;\">l &nbsp;第三步，审核通过</span><br/><span style=\"font-size: 14px;\">A提交资料</span><br/><span style=\"font-size: 14px;\">1）需要提交哪些资料</span><br/><span style=\"font-size: 14px;\">相关资格证书（教师资格证书、高学历证书、专业证书、认证名师），个人资料；</span><br/><span style=\"font-size: 14px;\">2）提交方式</span><br/><span style=\"font-size: 14px;\">联系机构，开通系统邮箱，机构平台均可提交审核；</span><br/><span style=\"font-size: 14px;\">3）资料提交的有效期</span><br/><span style=\"font-size: 14px;\">申请入驻审核，提交资料需在3个工作日内提交，逾期需重新开通审核；</span><br/><span style=\"font-size: 14px;\">B后台审核</span><br/><span style=\"font-size: 14px;\">1）审核流程</span><br/><span style=\"font-size: 14px;\">联系平台——开通审核——提交资料——后台审核——审核通过——签约入驻</span><br/><span style=\"font-size: 14px;\">2）结果反馈</span><br/><span style=\"font-size: 14px;\">1、审核结果2个工作日反馈</span><br/><span style=\"font-size: 14px;\">2、采用网站反馈、电话通知、短信提醒、邮件等进行反馈</span><br/><span style=\"font-size: 14px;\">C审核通过</span><br/><span style=\"font-size: 14px;\">1）开通账户</span><br/><span style=\"font-size: 14px;\">审核通过后即可开通个人账户，进行授课相关操作，根据系统引导即可完成操作；</span><br/><span style=\"font-size: 14px;\">2）个人设置</span><br/><span style=\"font-size: 14px;\">开通账户，进入个人即可进行个人相关设置，平台课程、发布博文、资料简介、照片等</span><br/><span style=\"font-size: 14px;\">签约成功</span><br/><span style=\"font-size: 14px;\">l &nbsp;发布课程</span><br/><span style=\"font-size: 14px;\">l &nbsp;招生推广</span><br/><span style=\"font-size: 14px;\">A发布课程</span><br/><span style=\"font-size: 14px;\">签约成功即成为讲师，可以进行课程发布等相关操作，课程助手为辅助工具；</span><br/><span style=\"font-size: 14px;\">B招生推广</span><br/><span style=\"font-size: 14px;\">平台支持机构或讲师推广招生，可使用平台提供的相关推广工具，付费操作可直接联系平台市场推广人员；</span><br/><span style=\"font-size: 14px;\">分销机制：</span><br/><span style=\"font-size: 14px;\">分销机制办法是以分销管理办法为基准，结合分销具体业务流程而制定，其核心宗旨是通过有效的分销机制，让讲师，用户，平台三方受益，在分销合作体系中营造快速有效的高品质点播和直播课的传播，让学生能听到更优质的内容，更精品的课程，充分发挥代理课程机构的竞争意识和管理能力，引导机构进行规范授课，良好运作，维持好平台管理机制秩序，并且通过分销体系使得机构，讲师，平台达到互赢，提高客户满意度，增强公司企业核心的竞争力。</span><br/><span style=\"font-size: 14px;\">分销体系的考核制度的原则以公开、公平、公正为基础，以发展用户质量为中心，用户至上为原则，通过机构代理在运营课程过程过程中，能更好的分享精品点播课程精品直播课程，给学生提供最优质的讲师，最优质的内容，从而让学生能学到更好的课程，塑造学生价值观，让用户学为所用。</span><br/><span style=\"font-size: 14px;\">由平台制定并根据平台相关管理制度制度具体要求，完成对机构，讲师各项考核指标的考核工作，并将考核结果上报审定后作为机构，讲师所获酬金分配依据</span><br/><span style=\"font-size: 14px;\">为了保证平台的正常运作，保证各方利益的合理分配，平台特制定，4，4,2,分账机制，由平台，机构，讲师组成，平台%20，机构%40，讲师%40，机构讲师通过分享课程还可以得到相应的分成，促进课程销售，提供一站式分享流程，快捷方便满足学员的需求，让学生能享受到高品质精品课程。</span><br/><span style=\"font-size: 14px;\">分享方式</span><br/><span style=\"font-size: 14px;\">通过：微信，邮箱，短信都可以分享给用户</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('30', '侵权投诉', '24', '<p><span style=\"font-size: 14px;\">xxxxxxxxxxxxxxxx</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('31', '视频拍摄', '25', '<p><span style=\"font-size: 14px;\">xxxxxxxx<br/><br/></span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('32', '平台网站条款服务协议', '26', '<p>xxxxxxxxxxxxxxxxxxxxxx</p>', '0', null);
INSERT INTO `sr_single` VALUES ('33', '用户服务协议', '27', '<p>xxxxxxxxxxxxxxxxx</p>', '0', null);
INSERT INTO `sr_single` VALUES ('34', '学生帮助', '28', '<p>xxxxxxxxxxxxxxxxxxxxx</p>', '0', null);
INSERT INTO `sr_single` VALUES ('35', '意见反馈', '29', '<p style=\"white-space: normal\"><span style=\"font-size: 14px\">填写联系方式</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">13866774248</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\">qq:1443185877 363359328</span></p><p style=\"white-space: normal\"><span style=\"font-size: 14px\"><br/></span></p><p><span style=\"font-size: 14px\"><br/></span></p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('36', '学生注册协议', '30', '<p>xxxxxxxxxxxxxxxx</p><p>xxxxxxxxxxxxxxx</p>', '0', null);
INSERT INTO `sr_single` VALUES ('37', '退款协议', 'refund', '<p style=\"white-space: normal\"><span style=\"font-size: 14px\">xxxxxxxxxxxxxxxxxxxx&nbsp;</span></p><p><span style=\"font-size: 14px\"><br/></span></p><p><br/></p>', '0', null);
INSERT INTO `sr_single` VALUES ('38', '平台直播流程', '32', '<p><span style=\"font-size: 14px;\">平台直播流程</span><br/><span style=\"font-size: 14px;\">1、老师要先进行账号注册，注册步骤如下：</span><br/><span style=\"font-size: 14px;\">l &nbsp;联系平台</span><br/><span style=\"font-size: 14px;\">l &nbsp;后台审核</span><br/><span style=\"font-size: 14px;\">l &nbsp;签约成功</span><br/><span style=\"font-size: 14px;\">联系平台</span><br/><span style=\"font-size: 14px;\">l &nbsp;联系方式</span><br/><span style=\"font-size: 14px;\">l &nbsp;外地老师签约平台</span><br/><span style=\"font-size: 14px;\">l &nbsp;签约平台的条件</span><br/><span style=\"font-size: 14px;\">1）联系平台有哪些方式？</span><br/><span style=\"font-size: 14px;\">目前机构开通名师热线、微信、QQ、微博等联系方式；</span><br/><span style=\"font-size: 14px;\">&nbsp;</span><br/><span style=\"font-size: 14px;\">2）外地老师可否签约平台？</span><br/><span style=\"font-size: 14px;\">可以通过在线的方式进行资料审核，审核通过后可进行网上授课等相关操作；</span><br/><span style=\"font-size: 14px;\">&nbsp;</span><br/><span style=\"font-size: 14px;\">3）签约平台需要具备哪些条件？</span><br/><span style=\"font-size: 14px;\">① 教师资格证书</span><br/><span style=\"font-size: 14px;\">② 高学历证书</span><br/><span style=\"font-size: 14px;\">③ 专业证书</span><br/><span style=\"font-size: 14px;\">④ 认证名师</span><br/><span style=\"font-size: 14px;\">后台审核</span><br/><span style=\"font-size: 14px;\">l &nbsp;第一步，提交资料</span><br/><span style=\"font-size: 14px;\">l &nbsp;第二步，后台审核</span><br/><span style=\"font-size: 14px;\">l &nbsp;第三步，审核通过</span><br/><span style=\"font-size: 14px;\">A提交资料</span><br/><span style=\"font-size: 14px;\">1）需要提交哪些资料</span><br/><span style=\"font-size: 14px;\">相关资格证书（教师资格证书、高学历证书、专业证书、认证名师），个人资料；</span><br/><span style=\"font-size: 14px;\">2）提交方式</span><br/><span style=\"font-size: 14px;\">联系机构，开通系统邮箱，机构平台均可提交审核；</span><br/><span style=\"font-size: 14px;\">3）资料提交的有效期</span><br/><span style=\"font-size: 14px;\">申请入驻审核，提交资料需在3个工作日内提交，逾期需重新开通审核；</span><br/><span style=\"font-size: 14px;\">&nbsp;</span><br/><span style=\"font-size: 14px;\">B后台审核</span><br/><span style=\"font-size: 14px;\">1）审核流程</span><br/><span style=\"font-size: 14px;\">联系平台——开通审核——提交资料——后台审核——审核通过——签约入驻</span><br/><span style=\"font-size: 14px;\">2）结果反馈</span><br/><span style=\"font-size: 14px;\">1、审核结果2个工作日反馈</span><br/><span style=\"font-size: 14px;\">2、采用网站反馈、电话通知、短信提醒、邮件等进行反馈</span><br/><span style=\"font-size: 14px;\">&nbsp;</span><br/><span style=\"font-size: 14px;\">C审核通过</span><br/><span style=\"font-size: 14px;\">1）开通账户</span><br/><span style=\"font-size: 14px;\">审核通过后即可开通个人账户，进行授课相关操作，根据系统引导即可完成操作；</span><br/><span style=\"font-size: 14px;\">&nbsp;</span><br/><span style=\"font-size: 14px;\">2）个人设置</span><br/><span style=\"font-size: 14px;\">开通账户，进入个人即可进行个人相关设置，平台课程、发布博文、资料简介、照片等</span><br/><span style=\"font-size: 14px;\">签约成功</span><br/><span style=\"font-size: 14px;\">l &nbsp;发布课程</span><br/><span style=\"font-size: 14px;\">l &nbsp;招生推广</span><br/><span style=\"font-size: 14px;\">A发布课程</span><br/><span style=\"font-size: 14px;\">签约成功即成为平台老师，可以进行课程发布等相关操作，课程助手为辅助工具；</span><br/><span style=\"font-size: 14px;\">&nbsp;</span><br/><span style=\"font-size: 14px;\">B招生推广</span><br/><span style=\"font-size: 14px;\">平台支持个人老师推广招生，可使用平台提供的相关推广工具，付费操作可直接联系平台市场推广人员；</span><br/><span style=\"font-size: 14px;\">2、直播</span><br/><span style=\"font-size: 14px;\">教师直播前需准备一些硬件设施包括电脑、麦克风、耳机等，注册成功后点击教师直播进入直播页面就可以在线与学生进行互动交流。</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('39', '注册第三步', '33', '<p><span style=\"font-size: 14px;\">第三步：点击【同意协议并注册】即完成注册！</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('40', '注册第四步', '34', '<p><span style=\"font-size: 14px;\">第四步：注册成功，登录个人中心。</span></p>', '0', null);
INSERT INTO `sr_single` VALUES ('41', '123131', '123123', '<p>12313123123</p>', '1', null);
INSERT INTO `sr_single` VALUES ('43', '34343', '232', '<p>2342</p>', '1', null);
INSERT INTO `sr_single` VALUES ('44', '测试一下', 'csyixia', '<p>asdfasdf</p>', '1', null);
INSERT INTO `sr_single` VALUES ('45', 'asdf', 'dddd', '<p>	&nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p><p>阿斯顿发斯蒂芬</p>', '1', '1581422378');

-- ----------------------------
-- Table structure for `sr_topic`
-- ----------------------------
DROP TABLE IF EXISTS `sr_topic`;
CREATE TABLE `sr_topic` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '资讯表主键ID',
  `category_id` int(11) NOT NULL COMMENT '资讯分类ID，关联资讯分类表（sr_zy_topic_category）主键ID',
  `fullcategorypath` varchar(30) DEFAULT NULL,
  `title` varchar(90) NOT NULL COMMENT '资讯标题',
  `desc` varchar(255) DEFAULT NULL COMMENT '摘要',
  `text` text NOT NULL COMMENT '资讯内容',
  `cover` int(11) NOT NULL COMMENT '附件id，关联附件表（sr_attach）主键ID',
  `ctime` char(20) NOT NULL COMMENT '资讯发布时间',
  `readcount` int(11) NOT NULL DEFAULT '0' COMMENT 'l浏览统计',
  `from` varchar(255) NOT NULL DEFAULT '' COMMENT '资讯来源  来源为空为未知 ',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否删除【1:是;0:否;】',
  `del_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dateline` (`ctime`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COMMENT='资讯表';

-- ----------------------------
-- Records of sr_topic
-- ----------------------------
INSERT INTO `sr_topic` VALUES ('10', '439', '439', 'asdfasf', null, '<p>asdfasdfasdf</p>', '51', '1583926150', '0', 'asdf', '0', null);

-- ----------------------------
-- Table structure for `sr_topic_category`
-- ----------------------------
DROP TABLE IF EXISTS `sr_topic_category`;
CREATE TABLE `sr_topic_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '分类名称',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `icon` int(11) DEFAULT '0' COMMENT '移动端使用',
  `mobile_display` tinyint(3) NOT NULL DEFAULT '0' COMMENT '是否推荐到h5/app首页',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=441 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of sr_topic_category
-- ----------------------------
INSERT INTO `sr_topic_category` VALUES ('439', '0', 'd', '1', '0', '0');

-- ----------------------------
-- Table structure for `sr_user`
-- ----------------------------
DROP TABLE IF EXISTS `sr_user`;
CREATE TABLE `sr_user` (
  `uid` int(11) NOT NULL AUTO_INCREMENT COMMENT '用户表主键UID',
  `uname` varchar(255) DEFAULT NULL COMMENT '登录名【emial、phone、uname】',
  `password` varchar(255) DEFAULT NULL COMMENT '用户密码的md5摘要',
  `login_salt` char(5) DEFAULT NULL COMMENT '10000 到 99999之间的随机数，加密密码时使用',
  `phone` varchar(16) DEFAULT NULL COMMENT '手机号',
  `sex` tinyint(1) NOT NULL DEFAULT '0' COMMENT '性别 1：男、2：女',
  `is_audit` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否通过审核：0-未通过，1-已通过',
  `ctime` int(11) DEFAULT NULL COMMENT '注册时间',
  `reg_ip` varchar(64) DEFAULT '127.0.0.1' COMMENT '注册注IP',
  `province` mediumint(6) NOT NULL DEFAULT '0' COMMENT '省ID、关联sr_area表',
  `city` int(5) NOT NULL DEFAULT '0' COMMENT '城市ID，关联sr_area表',
  `area` int(5) NOT NULL DEFAULT '0' COMMENT '地区ID，关联sr_area表',
  `is_del` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否禁用，0不禁用，1：禁用',
  `intro` varchar(255) DEFAULT NULL COMMENT '户用简介',
  `last_login_time` int(11) DEFAULT '0' COMMENT '户用最后一次登录时间',
  `invite_code` varchar(120) DEFAULT NULL COMMENT '邀请注册码',
  `login_num` int(11) NOT NULL DEFAULT '0' COMMENT '登录次数',
  `parent_relation` varchar(255) DEFAULT NULL COMMENT '存放上级关系,3级关系',
  `locktime` int(11) DEFAULT '0' COMMENT '锁定时间',
  `del_time` int(11) DEFAULT '0',
  `token` varchar(255) DEFAULT NULL COMMENT 'api 登录token',
  `token_expire` int(11) DEFAULT '0' COMMENT 'token失效时间 当前+ 3600秒',
  PRIMARY KEY (`uid`),
  KEY `login` (`uname`) USING BTREE,
  KEY `count` (`is_audit`,`is_del`) USING BTREE,
  KEY `statis_reg` (`ctime`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='用户表';

-- ----------------------------
-- Records of sr_user
-- ----------------------------
INSERT INTO `sr_user` VALUES ('1', 'admin', 'd46b5dd007cca4ad3ee2a521dd26dcb3', '11111', '', '2', '1', '1563764277', '127.0.0.1', '110000', '110100', '110108', '0', '', '1583906835', '78cbe7', '2', null, '0', '0', null, null);

-- ----------------------------
-- Table structure for `sr_user_group`
-- ----------------------------
DROP TABLE IF EXISTS `sr_user_group`;
CREATE TABLE `sr_user_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '用户组表主键ID  -1保留给超级管理员',
  `pid` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '父级ID 作废',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '用户角色名称',
  `ctime` int(11) DEFAULT NULL COMMENT '创建时间',
  `type` tinyint(3) NOT NULL DEFAULT '0' COMMENT '角色类型【0:普通角色;1:特殊角色;】 作废',
  `rule_list` text COMMENT '权限集',
  `is_del` tinyint(1) DEFAULT '0',
  `del_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='用户组表';

-- ----------------------------
-- Records of sr_user_group
-- ----------------------------
INSERT INTO `sr_user_group` VALUES ('-1', '0', '超级管理员', '1495007618', '0', '', '0', '0');
INSERT INTO `sr_user_group` VALUES ('2', '0', '测试一下', '1583937037', '0', '1,5,6', '0', '0');

-- ----------------------------
-- Table structure for `sr_user_group_link`
-- ----------------------------
DROP TABLE IF EXISTS `sr_user_group_link`;
CREATE TABLE `sr_user_group_link` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '用户用户组关联表主键ID',
  `uid` int(10) NOT NULL COMMENT '户用UID，关联用户表（sr_user）主键UID',
  `user_group_id` int(10) NOT NULL COMMENT '户用组ID，关联用户组表（sr_user_group）主键ID',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE,
  KEY `user_group_id` (`user_group_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='用户用户组关联表';

-- ----------------------------
-- Records of sr_user_group_link
-- ----------------------------
INSERT INTO `sr_user_group_link` VALUES ('1', '1', '-1');

-- ----------------------------
-- Table structure for `sr_user_vip`
-- ----------------------------
DROP TABLE IF EXISTS `sr_user_vip`;
CREATE TABLE `sr_user_vip` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'VIP等级表主键ID',
  `title` char(32) NOT NULL DEFAULT '1' COMMENT 'VIP等级名称',
  `month_fee` float(10,2) DEFAULT NULL COMMENT '单价/月',
  `year_fee` float(10,2) DEFAULT NULL COMMENT '单价/年',
  `sort` int(10) DEFAULT '1' COMMENT '排序(值越大越靠前，等级越高)',
  `cover` int(11) unsigned DEFAULT '0' COMMENT '图标',
  `ctime` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `is_del` tinyint(2) DEFAULT '0' COMMENT '是否删除【1:是;0:否;】',
  `del_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`title`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='VIP等级表';

-- ----------------------------
-- Records of sr_user_vip
-- ----------------------------
INSERT INTO `sr_user_vip` VALUES ('1', 'VIP1', '200.00', '2000.00', '1', '1', '1581158525', '0', '0');
INSERT INTO `sr_user_vip` VALUES ('2', 'VIP2', '500.00', '5000.00', '2', '0', '1574768436', '0', '0');
INSERT INTO `sr_user_vip` VALUES ('5', 'da', '2.00', '333.00', '3', '0', '1581228408', '1', '0');
