<?php
namespace siruisoft\admin\controller;

use siruisoft\common\controller\Base;
use think\Db;
use siruisoft\admin\service\Admin;

/**
 * @Author: 思睿软件
 * @Date:   2019-12-30 11:59:03
 * @Last Modified by:   Administrator
 * @Last Modified time: 2020-03-11 19:35:05
 * 需要鉴权方法全部继承AdminBase
 */

class AdminBase extends Base
{
  

    protected $access_actions=['admin/common/login','admin/common/upload','admin/common/welcome'];  
   
    protected $menus=[];

    protected $menuTops=[];


    function initialize(){
        parent::initialize();
        if (!Admin::checkLogin()) {
            $this->redirect('admin/common/login');
        }
        $this->admin = session('admin');
        $this->assign('uname',session('admin')['uname']);

        //鉴权
        if (!$this->checkAuth() || empty($this->menus)) {
            return "<div>您没有此操作权限</div>";
        }
    }


    
    /**
     * [checkAuth 鉴权]
     * @Author   思睿软件<363359328@qq.com>
     * @DateTime 2020-01-03T16:30:40+0800
     * @return   [array]                   [description]
     */
    protected function checkAuth()
    {    
         //白名单uri 直接通过
        if(in_array($this->uri, $this->access_actions)){
            return  1;
        }


        $group = Db::name('user_group_link')
                    ->alias('L')
                    ->join('user_group G','L.user_group_id=G.id','left')
                    ->field('L.user_group_id,G.rule_list')
                    ->where([['L.uid','=',session('admin')['uid']],['G.is_del','=',0]])
                    ->find();

        if(empty($group)){
            return 0;
        }

        //超级管理员给予所有权限
        if(-1==$group['user_group_id']){
            $this->menus = model('menu')->getAllMenus();
            $this->menuTops = model('menu')->getTops();
            return 1;
        }

        //如果用户允许多个角色 此处要改写
        $this->menus =  model('menu')->getMenusByIds($rule_list); 
        $this->menuTops = model('menu')->getTops();

       

        //鉴权
        $rule_list=$group['rule_list'];
        if(empty($rule_list)){
            return 0;
        }
       
        foreach ($this->menus as $key => $value) {
            if(stripos($value['url'],$this->uri)!==false){
                return 1;
            }
        }
        
        return 0;
	}



    function log_record($info){
        log_record(session('admin')['uid'],session('admin')['uname'],$info);
        return 1;
    }


    


    


}