<?php

/**
 * @Author: 思睿软件
 * @Date:   2020-01-28 13:20:59
 * @Last Modified by:   Administrator
 * @Last Modified time: 2020-03-11 16:09:12
 * @version: 1.0
 * 广告管理
 */
namespace siruisoft\admin\controller;

use think\Db;

class Adv extends Adminbase
{
	protected  $_places=[];

    function initialize(){
        parent::initialize();
        $this->_places = config('adv.position');
        $this->assign('places',$this->_places);
    }

	function index(){
		$condition[] =['is_del','=',0];
		$query=[];
        $rows = Db::name('ad')
                    ->where($condition)
                    ->paginate(config('paginate.pagesize'),false,['query'=>$query]);
        $this->assign('rows',$rows);
        return $this->fetch();
	}


	/**
     * @Author   思睿软件
     * @DateTime 2020-01-28
     * @version  1.0
     * @return   [type]     [description]
     * 软删除 is_del=1
     */
	function delete(){
		if($this->request->isAjax()) {
            $id = $this->request->has('id') ? $this->request->param('id', 0, 'intval') : 0;
            try{
            	if(\siruisoft\common\service\Model::is_truedelete('adv')){
            		model('adv')->where('id',$id)->delete();
            	}else{
            		model('adv')->where('id',$id)->update(['is_del'=>1,'del_time'=>time()]);
            	}
                $this->log_record('删除广告');
                return json(['error'=>0,'msg'=>'删除成功']);
            }catch(Exception $e){
            	return json(['error'=>1,'msg'=>'删除失败']);
            }
        }
	}


	function publish(){
        if($this->request->isPost()){
            $title = input('param.title/s');
            $place = input('param.place/d');
            $display_type = input('param.display_type/d');
            if(empty($title) || $place<=0){
                return json(['error'=>1,'msg'=>'标题必须填写']);
            }
            if($place<=0){
                return json(['error'=>1,'msg'=>'请选择正确的位置']);
            }
            if($display_type!=1 && $display_type!=2 && $display_type!=3){
                return json(['error'=>1,'msg'=>'请选择正确的类型']);
            }
            //当前位置广告是否存在
            if(model('Adv')->where([['place','=',$place],['is_del','=',0]])->count()>0){
                return json(['error'=>1,'msg'=>'当前位置广告已存在']);
            }
            if(1==$display_type){
                $content = input('param.html_content/s');
            }elseif (2==$display_type) {
                $content = input('param.code_content/s');
            }elseif (3==$display_type) {
                $banner = input('param.banner/a');
                $bannerurl = input('param.bannerurl/a');
                $banner_title = input('param.banner_title/a');
                $content =[];
                foreach ($banner as $key => $value) {
                    if($value<=0) continue;
                    $url = empty($bannerurl[$key])? 'javascript:;' : $bannerurl[$key];
                    $content[]= ['banner'=>$value,'bannerurl'=>$url,'banner_title'=>$banner_title[$key]];
                }
                $content = serialize($content);
            }
            try {
                $data['title'] = $title;
                $data['place'] = $place;
                $data['ctime'] = time();
                $data['mtime'] = $data['ctime'];
                $data['content'] = $content;
                $data['display_type'] = $display_type;
                model('Adv')->insert($data);
                return json(['error'=>0,'msg'=>'操作成功']);
            } catch (Exception $e) {
                return json(['error'=>1,'msg'=>'操作失败']);
            }
        }
        return $this->fetch();
    }


    function edit(){
        $id = input('param.id/d');
        if($id<=0){
            return $this->error('非法操作');
        }
        if($this->request->isPost()){
            $title = input('param.title/s');
            $place = input('param.place/d');
            $display_type = input('param.display_type/d');
            if(empty($title) || $place<=0){
                return json(['error'=>1,'msg'=>'标题必须填写']);
            }
            if($place<=0){
                return json(['error'=>1,'msg'=>'请选择正确的位置']);
            }
            if($display_type!=1 && $display_type!=2 && $display_type!=3){
                return json(['error'=>1,'msg'=>'类型错误']);
            }
            //当前位置广告是否存在
            if(model('Adv')->where([['place','=',$place],['is_del','=',0],['id','<>',$id]])->count()>0){
                return json(['error'=>1,'msg'=>'你选择的位置广告已存在']);
            }
            if(1==$display_type){
                $content = input('param.html_content/s');
            }elseif (2==$display_type) {
                $content = input('param.code_content/s');
            }elseif (3==$display_type) {
                $banner = input('param.banner/a');
                $bannerurl = input('param.bannerurl/a');
                $banner_title = input('param.banner_title/a');
                $content =[];
                foreach ($banner as $key => $value) {
                    if($value<=0) continue;
                    $url = empty($bannerurl[$key])? 'javascript:;' : $bannerurl[$key];
                    $content[]= ['banner'=>$value,'bannerurl'=>$url,'banner_title'=>$banner_title[$key]];
                }
                $content = serialize($content);
            }
            try {
                $data['title'] = $title;
                $data['place'] = $place;
                $data['mtime'] = time();
                $data['content'] = $content;
                model('Adv')->where('id',$id)->update($data);
                return json(['error'=>0,'msg'=>'操作成功']);
            } catch (Exception $e) {
            	return json(['error'=>1,'msg'=>'操作失败']);
            }
        }
        $row = model('Adv')->where('id',$id)->find();
        $this->assign('row',$row);
        return $this->fetch();
    }




    function removebanner(){
        $id = input('param.id/d');
        $attach_id = input('param.attach_id/d');
        if($id<=0 || $attach_id<=0){
            return json(['error'=>1,'msg'=>'非法操作']);
        }
        $row = model('Adv')->where('id',$id)->find();
        if(empty($row) || $row['display_type']!=3){
            return json(['error'=>1,'msg'=>'非法操作,非图片类型广告']);
        }
        if(empty($row['content'])){
            return json(['error'=>1,'msg'=>'非法操作,内容为空']);
        }
        $banners = unserialize($row['content']);
        foreach ($banners as $key => $value) {
            if($attach_id==$value['banner']){
                unset($banners[$key]);
                break;
            }
        }
        $content = serialize($banners);
        try {
            model('Adv')->where('id',$id)->update(['content'=>$content]);
            return json(['error'=>0,'msg'=>'操作成功']);
        } catch (Exception $e) {
            return json(['error'=>1,'msg'=>'操作失败']);
        }

    }
}