<?php
namespace siruisoft\admin\controller;

/**
 * 要求数据表同构 统一管理
 */
class Category extends Adminbase
{

    //数据表
    protected  $_table_map=[
                    'topic'   => 'topic_category',
                    'goods'   => 'goods_category',
               ];

    //允许多级 0表示允许 1表示不允许
    protected $_all_mul_levels=[         
            'topic'   => 0,
            'goods'   => 1,
    ];

    function initialize(){
        parent::initialize();
        $this->assign('tips',$this->_tips);
    }

    /**
     * [index 课程,考试分类]
     * @Author   思睿软件<363359328@qq.com>
     * @DateTime 2020-01-08T17:28:24+0800
     * @return   [type]                   [description]
     * 数据表: sr_currency_category
     */
    public function index()
    {
        $type ='index';
        $this->assign('mullevels',$this->_all_mul_levels[$type]); //允许多级
        $rows = model('category')->setType($type)->categoryList();
        $this->assign('rows',$rows);
        $this->assign('type',$type);
        return $this->fetch();
    }


    /**
     * [package 套餐分类]
     * @Author   思睿软件<363359328@qq.com>
     * @DateTime 2020-01-08T17:29:20+0800
     * @return   [type]                   [description]
     * 数据表: sr_package_category
     */
    function package(){
        $type ='package';
        $this->assign('mullevels',$this->_all_mul_levels[$type]); 
        $rows = model('category')->setType($type)->categoryList();
        $this->assign('rows',$rows);
        $this->assign('type',$type);
        return $this->fetch();
    }


    //文库 数据表: sr_doc_category
    function library(){
        $type ='library';
        $this->assign('mullevels',$this->_all_mul_levels[$type]); 
        $rows = model('category')->setType($type)->categoryList();
        $this->assign('rows',$rows);
        $this->assign('type',$type);
        return $this->fetch();
    }

    //教师分类 数据表: sr_teacher_category
    function teacher(){
        $type ='teacher';
        $this->assign('mullevels',$this->_all_mul_levels[$type]); 
        $rows = model('category')->setType($type)->categoryList();
        $this->assign('rows',$rows);
        $this->assign('type',$type);
        return $this->fetch();
    }

    //机构分类 数据表: sr_school_category
    function school(){
        $type ='school';
        $this->assign('mullevels',$this->_all_mul_levels[$type]); 
        $rows = model('category')->setType($type)->categoryList();
        $this->assign('rows',$rows);
        $this->assign('type',$type);
        return $this->fetch();
    }


    //资讯 数据表: sr_topic_category
    function topic(){
        $type ='topic';
        $this->assign('mullevels',$this->_all_mul_levels[$type]); 
        $rows = model('category')->setType($type)->categoryList();
        $this->assign('rows',$rows);
        $this->assign('type',$type);
        return $this->fetch();
    }


    //问答分类 sr_wenda_category
    function wenda(){
        $type ='wenda';
        $this->assign('mullevels',$this->_all_mul_levels[$type]); 
        $rows = model('category')->setType($type)->categoryList();
        $this->assign('rows',$rows);
        $this->assign('type',$type);
        return $this->fetch();
    }


    //商品分类
    function goods(){
        $type ='goods';
        $this->assign('mullevels',$this->_all_mul_levels[$type]); 
        $rows = model('category')->setType($type)->categoryList();
        $this->assign('rows',$rows);
        $this->assign('type',$type);
        return $this->fetch();
    }



    function delete(){
        if($this->request->post()){
            $type = input('param.type/s');
            if(empty($type) || !array_key_exists($type, $this->_table_map)){
                return json(['error'=>1,'msg'=>'非法操作']);
            }
            $id = input('param.id/d');
            if($id<=0){
                return json(['error'=>1,'msg'=>'非法操作']);
            }
            try {
                $ret =model('category')->setType($type)->delById($id);
                if(0==$ret['error']){
                    $this->log_record('删除类别'.$this->_table_map[$type]);
                }
                return json($ret);
            } catch (Exception $e) {
                return json(['error'=>1,'msg'=>'操作失败']);
            }
        }
    }

    /**
     * [publish 添加]
     * @Author   思睿软件<363359328@qq.com>
     * @DateTime 2020-01-09T12:59:47+0800
     * @return   [type]                   [description]
     */
    function publish(){
        $type = input('param.type/s');
        $pid =  intval(input('param.pid/d'));  
        $id = intval(input('param.id/d'));  //存在为编辑

        if(empty($type) || !array_key_exists($type,$this->_table_map)){
            return json(['error'=>1,'msg'=>'非法操作']);   
        }

        if($this->request->isPost()){
            $title = trim(input('param.title/s'));
            if(empty($title)){
                return json(['error'=>1,'msg'=>'标题不能为空']);   
            }
            $data['pid'] = $pid;
            $data['title'] = $title;
            //课程和考试类别
            if('index'== $type){
                $data['mobile_display'] = intval(input('param.mobile_display/d'));
                $data['icon'] = intval(input('param.icon/d'));
            }else if('goods'==$type){
                $data['icon'] = intval(input('param.icon/d'));
            }
            $data['sort'] = intval(input('param.sort/d'));
            $rs = model('category')->setType($type)->publish($data,$id);
            if(0==$rs['error']){
                $log = $id>0? '编辑':'新增';
                $this->log_record('删除类别'.$log.$this->_table_map[$type]);
                return json(['error'=>0,'msg'=>'操作成功']);
            }
            return json(['error'=>1,'msg'=>$rs['msg']]); 
        }
        if($id>0){
            $rs = model('category')->setType($type)->getById($id);
            $this->assign('row',$rs['data']);
        }else{
            $this->assign('row',[]);
        }
        $this->assign('id',$id);
        $this->assign('pid',$pid);
        $categorys = model('category')->setType($type)->categoryList();
        $this->assign('categorys',$categorys);
        $this->assign('type',$type);
        $this->assign('mullevels',$this->_all_mul_levels[$type]); 
        return $this->fetch();
    
    }




    function orders(){
        if($this->request->isPost()) {
            $type = input('param.type');
            $post = $this->request->post();
            foreach ($post['id'] as $k => $val) {
                db($this->_table_map[$type])->where('id',$val)->update(['sort'=>$post['sort'][$k]]);
            }
            return $this->success('操作成功','admin/category/'.$type);
        }
    }


}
