<?php
namespace siruisoft\admin\controller;

use siruisoft\common\controller\Base;
use \util\File;
use siruisoft\admin\service\Admin;

class Common  extends Base
{
	function initialize(){
        parent::initialize();
    }


    function login(){
    	if (Admin::checkLogin()) {
            $this->redirect('admin/index/index');
        }
        return $this->fetch();
    }

    function dologin(){
        if(request()->isPost()){
            // $verifyimg = input('param.verifyimg/s'); 
            // if(empty($verifyimg) || !captcha_check($verifyimg,1) ){
            //     return $this->error('验证码错误');
            // }
            
            $login_name = trim(input('param.login_name/s'));
            $password =  trim(input('param.password/s'));
            if (empty($login_name) || empty($password)) {
                $this->error = "帐号或密码不能为空";
                return false;
            }
            $rs = Admin::login($login_name,$password);
            $online = input('param.online/d');
            if(1==$online){
                $expire = 24*7*3600;
                cookie('admin_online',1,$expire);
                cookie('login_name',$login_name,$expire);
            }

            if (0==$rs['error']) {
                return $this->success("登录成功",url('admin/index/index'));
            } else {
                return $this->error($rs['msg']);
            }
        }
    }


    //手动退出登录
    public function logout()
    {
        Admin::logout();
        $this->success('注销成功！', url("admin/common/login"));
        
    }


    /**
     * 图片上传方法
     * @return [type] [description]
     */
    public function upload($atype,$save=1)
    {
        if($this->request->file('file')){
            $file = $this->request->file('file');
        }else{
            $res['error']=1;
            $res['msg']='没有上传文件';
            return json($res);
        }

        $file_info = $file->getInfo();
        $system_default = model('Xdata')->get('admin_sysconfig:attach');
        // 载入默认规则
        $options                = array();
        $options['custom_path'] = date('Y/m/d'); // 应用定义的上传目录规则：'Y/md/H/'
        $options['save_path']   = DIR_UPLOAD . DS . $options['custom_path'];
        //获取配置文件
        $image_default    = model('Xdata')->get('admin_sysconfig:attachimage');
        if(empty($image_default)){
            $res['error']=1;
            $res['msg']='请先配置图片上传';
            return json($res);
        }
        $options['max_size']    =  floatval($image_default['attach_max_size']) * 1024 * 1024; // 单位: 兆
        $options['allow_ext']   =  $image_default['attach_allow_extension']; 
        $options['auto_thumb']             = $image_default['auto_thumb'];
        $info = $file->validate(['size'=>$options['max_size'],'ext'=>$options['allow_ext']])->rule('uniqid')->move($options['save_path']);
        if($info) {
            $res['error'] = 0;
            $res['src'] = DS.'public'.DS.'uploads'.DS.$options['custom_path'].DS.$info->getSaveName();
            if($save){
                $data=[];
                $data['module']      = $this->module;
                $data['attach_type'] = $atype;
                $data['uid']         =  session('admin')['uid'];
                $data['ctime']       =  time();
                $data['name']        = $file_info['name'];
                $data['type']        = $file_info['type'];
                $data['size']        = $info->getSize();
                $data['extension']   = strtolower($info->getExtension());
                $data['hash']        = $info->md5();
                $data['save_path']   = $options['custom_path'];
                $data['save_name']   = $info->getSaveName();
                $res['id'] = model('Attach')->insertGetId($data);
            }
            return json($res);
        } else {
            return json(['error'=>1,'msg'=>'上传失败'.$file->getError()]);
        }
    }



    /**
     * 上传除了图片之外的附件 目录 res
     * @return [type] [description]
     */
    public function uploadattach($atype,$save=1)
    {
        if($this->request->file('file')){
            $file = $this->request->file('file');
        }else{
            $res['error']=1;
            $res['msg']='没有上传文件';
            return json($res);
        }

        $file_info = $file->getInfo();

        $system_default = model('Xdata')->get('admin_sysconfig:attach');
    
        // 载入默认规则
        $options                = array();
        $options['custom_path'] = 'res'; // 应用定义的上传目录规则：'Y/md/H/'
        $options['save_path']   = DIR_UPLOAD . DS . $options['custom_path'];
        $options['max_size']    =  floatval($system_default['attach_max_size']) * 1024 * 1024; // 单位: 兆
        $options['allow_ext']   =  $system_default['attach_allow_extension']; 
        $info = $file->validate(['size'=>$options['max_size'],'ext'=>$options['allow_ext']])->rule('uniqid')->move($options['save_path']);
        if($info) {
            $res['error'] = 0;
            $res['src'] = DS.'uploads'.DS.$atype.DS.$info->getSaveName();
            if($save){
                $data=[];
                $data['module']      = $this->module;
                $data['attach_type'] = $atype;
                $data['uid']         =  session('admin')['uid'];
                $data['ctime']       =  time();
                $data['name']        = $file_info['name'];
                $data['type']        = $file_info['type'];
                $data['size']        = $info->getSize();
                $data['extension']   = strtolower($info->getExtension());
                $data['hash']        = $info->md5();
                $data['save_path']   = $options['custom_path'];
                $data['save_name']   = $info->getSaveName();
                $res['id'] = model('Attach')->insertGetId($data);
            }
            return json($res);
        } else {
            // 上传失败获取错误信息
            return json(['error'=>1,'msg'=>'上传失败'.$file->getError()]);
        }
    }

}