<?php
namespace siruisoft\admin\controller;

use think\facade\Cache;

class Index extends Adminbase
{


    function initialize(){
        parent::initialize();
    }

    //后台首页
    public function index()
    {
        //print_r($this->menus);
        $top_id = input('param.top_id/d');
        if(0==$top_id){
            $top_id = $this->menuTops[0]['id'];
        }
        $index_top = $top_id;
        $this->assign('top_id',$top_id);
        $menuLefts = $this->getMenuLefts($top_id);
        $this->assign('menuLefts',$menuLefts);
        $this->assign('menuTops',$this->menuTops);
        
        $this->assign('admin',session('admin'));
        return $this->fetch();
    }



    function welcome(){
    	return $this->fetch();
    }



    //缓存更新
    public function clearcache()
    {
        $type = $this->request->request("type");
        if(empty($type)){
        	$type ='all';
        }
        switch ($type) {
            case 'data' || 'all':
                \util\File::del_dir(ROOT_PATH . 'runtime' . DS . 'cache');
                Cache::clear();
                if ($type == 'content') {
                    break;
                }

            case 'template' || 'all':
                \util\File::del_dir(ROOT_PATH . 'runtime' . DS . 'temp');
                if ($type == 'template') {
                    break;
                }
        }
        return $this->success('缓存清理完毕',url('admin/index/index'));
    }


    /**
     * [getMenuLefts 根据top获取左侧菜单]
     * @Author   思睿软件
     * @DateTime 2020-02-06T21:38:49+0800
     * @Version  1.0
     * @return   [type]                   [description]
     */
    protected function getMenuLefts($top_id){
        $menus = $this->dispalyMenu($this->menus);
        $rows = model('menu')->listToTree($menus,'id','pid','children',$top_id);
        return $rows;
    }


    /**
     * 删除不在左侧显示的menu
     * @Author   思睿软件<363359328@qq.com>
     * @DateTime 2020-01-07T09:53:29+0800
     * @return   [type]                   [description]
     */
    protected function  dispalyMenu($menus){
        $ret=[];
        foreach ($menus as $key => $value) {
           if('nav'==$value['type']){
                $ret[]= $value;
           }
        }
        return $ret;
    }

}
