<?php
namespace siruisoft\admin\controller;

use siruisoft\common\model\Regular;
use think\Db;

class Logs extends Adminbase
{

	function index(){
		$condition[] = ['L.is_del','=',0];

		$start = input('param.start/s');
		if(Regular::check($start,'date')){
			$condition[]=['L.ctime','>=',strtotime($start)];
			$this->assign('start',$start);
		}

		$end = input('param.end/s');
		if(Regular::check($end,'date')){
			$condition[]=['L.ctime','>=',strtotime($end)];
			$this->assign('end',$end);
		}

		$keywords = input('param.keywords/s');
		if($keywords){
			$condition[]=['L.info','like',"%$keywords%"];
			$this->assign('keywords',$keywords);
		}
		
        $rows = Db::name('logs')
        		->alias('L')
                ->where($condition)
                ->order('ctime DESC')
                ->paginate(10,false,['query'=>$this->request->param()]);
        $this->assign('rows',$rows);
        $this->assign('types',model('Logs')->types);
        return $this->fetch();
	}

    
    //日志物理删除
	function delete(){
		if($this->request->isPost()) {
            $ids = input('param.ids/a');
            if(!is_array($ids) || empty($ids)){
                return json(['error'=>1,'msg'=>'非法操作']);
            }
            try {
                model('logs')->where('id','in',$ids)->delete();
                $this->log_record('删除日志成功');
                return json(['error'=>0,'msg'=>'操作成功']);
            } catch (Exception $e) {
                return json(['error'=>1,'msg'=>'操作失败']);
            }
        }
	}



	function deletebeforday(){
		 if($this->request->isPost()) {
            $days = input('param.days/d');
            if($days<=0){
            	return json(['error'=>1,'msg'=>'非法操作']);
            }
            try {
                model('logs')->cleanLogs($days);
                $this->log_record("删除{$days}天前日志成功");
                return json(['error'=>0,'msg'=>'操作成功']);
            } catch (Exception $e) {
                return json(['error'=>1,'msg'=>'操作失败']);
            }
        }
	}
}