<?php
namespace siruisoft\admin\controller;
/**
 * @Author: 思睿软件
 * @Date:   2020-01-06 16:33:02
 * @Last Modified by:   Administrator
 * @Last Modified time: 2020-03-11 16:03:01
 * 后台菜单管理
 * 菜单集合 --->group--->user
 */

class Menu extends Adminbase
{


    function initialize(){
        parent::initialize();
    }


    function index(){
        //解决冲突
        $model = model('menu');
        $menus = $model->where('is_del',0)->order('sort_order ASC')->field("id,pid,title as name")->select()->toArray();
        $list = $model->listToTree($menus);
        $this->assign('list',json_encode($list,JSON_UNESCAPED_UNICODE));
        return $this->fetch();
    }


    public function add(){
        if(request()->isPost()){
            $param=input('post.');
            if(!trim($param['title'])){
                return json(['error'=>1,'msg'=>'标题不能为空']);
            }
            $condition[]= ['is_del','=',0];
            $condition[]= ['pid','=',intval($param['pid'])];
            $condition[]= ['title','=',trim($param['title'])];
            if(model('menu')->where($condition)->count()>0){
                return json(['error'=>1,'msg'=>'类别已经存在']);
            }
            unset($param['id']);
            try {
                $id=model('menu')->allowField(true)->save($param);
                $this->log_record('菜单添加成功,id:'.$id);
                model('menu')->clearcache();
                return json(['error'=>0,'msg'=>'操作成功']);
            } catch (Exception $e) {
                return json(['error'=>1,'msg'=>'操作失败']);  
            }
        }
        $model = model('menu');
        $this->assign('menus', $model->menuList($model->getAllMenus()));
        $this->assign('pid', input('param.pid/d'));
        $this->assign('action', url('Menu/add'));
        return $this->fetch('edit');
    }



    function edit(){
        $id = input('param.id/d');
        if($id<=0){
            exit('error');
        }
        if(request()->isPost()){
            $param=input('post.');
            if(!trim($param['title'])){
                return json(['error'=>1,'msg'=>'标题不能为空']);
            }
            $condition[]= ['is_del','=',0];
            $condition[]= ['id','<>',$id];
            $condition[]= ['pid','=',intval($param['pid'])];
            $condition[]= ['title','=',trim($param['title'])];
            if(model('menu')->where($condition)->count()>0){
                return json(['error'=>1,'msg'=>'类别已经存在']);
            }
            unset($param['id']);
            try {
                model('menu')->allowField(true)->save($param,['id'=>$id]);
                $this->log_record('修改了后台菜单,id:'.$id);
                model('menu')->clearcache();
                return json(['error'=>0,'msg'=>'编辑成功']);
            } catch (Exception $e) {
                return json(['error'=>1,'msg'=>'操作失败']);  
            }
        }
        $model = model('menu');
        $this->assign('menus', $model->menuList($model->getAllMenus()));
        $this->assign('row',model('menu')->find($id));
        $this->assign('action', url('Menu/edit'));
        return $this->fetch('edit');
    }





    function del(){
        if($this->request->isAjax()) {
            $id = $this->request->has('id') ? $this->request->param('id', 0, 'intval') : 0;
            if(model('menu')->where([['pid','=',$id],['is_del','=',0]])->count()>0){
                return $this->error('有子菜单,不允许删除');
                return json(['error'=>1,'msg'=>'有子菜单,不允许删除']);  
            }
            try{
               model('menu')->where('id',$id)->update(['is_del'=>1,'del_time'=>time()]);
                $this->log_record('删除菜单,id:'.$id);
                model('menu')->clearcache();
                return json(['error'=>0,'msg'=>'删除成功']);
            }catch(Exception $e){
                return json(['error'=>1,'msg'=>'操作失败']);  
            }
        }
    }




}