<?php
namespace siruisoft\admin\controller;

use think\Db;
/**
 * 资讯管理
 */
class News extends Adminbase
{



	function index(){
		$condition[] =['is_del','=',0];
        $query =[];

		$start = input('param.start/s');
		if(\siruisoft\common\model\Regular::check($start,'date')){
			$condition[]=['ctime','>=',strtotime($start)];
            $query['start'] = $start;
		}

		$end = input('param.end/s');
		if(\siruisoft\common\model\Regular::check($end,'date')){
			$condition[]=['ctime','>=',strtotime($end)];
            $query['end'] = $end;

		}
        //此处最好使用mysql5.7.20以上版本 直接使用全文检索 此处为了提高速度只查标题
		$keywords = input('param.keywords/s');
		if($keywords){
			$condition[]=['title','like',"%$keywords%"];
            $query['keywords'] = urlencode($keywords);
			
		}
        $rows = Db::name('topic')
                    ->where($condition)
                    ->paginate(config('paginate.pagesize'),false,['query'=>$quyery])
                    ->each(function($item,$key){
                        $item['fullcategoryname'] = model('Category')
                                                        ->setTable('topic_category')
                                                        ->getFullNameByFullPath($item['fullcategorypath']);
                        return $item;
                    });
        $this->assign('rows',$rows);
        $this->assign('search_url',url('admin/news/index'));
        return $this->fetch();
	}

	function publish(){
		$id = $this->request->has('id') ? $this->request->param('id', 0, 'intval') : 0;
        if($this->request->isPost()) {
            $post = $this->request->post();
            $post['title'] = trim($post['title']);


            $fullcategory = trim(input('param.topic_level_hidden/s'));
            $category_arr = array_filter(explode(',', $fullcategory));
            if(empty($category_arr)){
                return json(['error'=>1,'msg'=>'类别非法']);
            }
            $post['category_id'] = $category_arr[count($category_arr)-1];
            if(model('Category')->setTable('topic_category')->hasChilds($post['category_id'])>0){
                return json(['error'=>1,'msg'=>'此类别还有下级类别,请选择最后一级类别']);
            }

            $validate = validate('news');
            if(!$validate->check($post)){
            	return json(['error'=>1,'msg'=>$validate->getError()]);
            }
            $post['fullcategorypath'] =  $fullcategory;
            try {
            	$post['ctime'] = time();
            	if($id>0){
            		model('Topic')->allowField(true)->save($post,['id'=>$id]);
            		$this->log_record('编辑资讯');
            	}else{
            		model('Topic')->allowField(true)->save($post);
            		$this->log_record('发布资讯');
            	}
            	return json(['error'=>0,'msg'=>'操作成功']);
            } catch (Exception $e) {
            	return json(['error'=>1,'msg'=>'操作失败']);  
            }

        }
        $row =[];
        if($id>0){
        	$row = model('Topic')->where('id',$id)->find()->toArray();
            $default = trim($row['fullcategorypath'],',');
        }
		$categorys = model('Category')->setTable('topic_category')->getAllCategorys();
		$this->assign('categorys',$categorys);
		$this->assign('row',$row);
        $this->assign('default',$default);
		return $this->fetch();
	}


	function delete(){
		if($this->request->isAjax()) {
            $id = $this->request->has('id') ? $this->request->param('id', 0, 'intval') : 0;
            try{
                model('Topic')->where('id',$id)->update(['is_del'=>1,'del_time'=>time()]);
                $this->log_record('删除资讯');
                return json(['error'=>0,'msg'=>'操作成功']);
            }catch(Exception $e){
                return json(['error'=>1,'msg'=>'操作失败']);
            }
        }
	}


	function deletemul(){
		if($this->request->isPost()) {
			$ids = input('param.ids/a');
			if(count($ids)==0){
				return json(['error'=>1,'msg'=>'非法操作']);
			}
            try{
                model('Topic')->where([['id','in',$ids]])->update(['is_del'=>1,'del_time'=>time()]);
                $this->log_record('批量删除资讯');
                return json(['error'=>0,'msg'=>'操作成功']);
            }catch(Exception $e){
                return json(['error'=>1,'msg'=>'操作失败']);
            }
        }
	}
}