<?php

/**
 * @Author: 思睿软件
 * @Date:   2020-01-28 13:20:59
 * @Last Modified by:   Administrator
 * @Last Modified time: 2020-03-11 16:09:12
 * @version: 1.0
 * 私信管理
 */
namespace siruisoft\admin\controller;

use think\Db;

class Phonecode extends Adminbase
{

	function index(){
		$condition[]=['is_del','=',0];
		$keywords = input('param.keywords/s');
		$query =[];
		if($keywords){
			$condition[]=['phone','like',"%$keywords%"];
			$query['keywords'] = urlencode($keywords);
			$this->assign('keywords',$keywords);
		}

        $rows = Db::name('phone_code')
                ->where($condition)
                ->paginate(config('paginate.pagesize'),false,['query'=>$query]);
        $this->assign('rows',$rows);
        return $this->fetch();
	}



	function delete(){
		if($this->request->isAjax()) {
            $id = $this->request->has('id') ? $this->request->param('id', 0, 'intval') : 0;
            try{
            	if(\siruisoft\common\service\Model::is_truedelete('PhoneCode')){
            		model('PhoneCode')->where('id',$id)->delete();
            	}else{
            		model('PhoneCode')->where('id',$id)->update(['is_del'=>1,'del_time'=>time()]);
            	}
                $this->log_record('删除反馈');
                return json(['error'=>0,'msg'=>'删除成功']);
            }catch(Exception $e){
            	return json(['error'=>1,'msg'=>'删除失败']);
            }
        }
	}


    function deletemul(){
        if($this->request->isAjax()) {
            $ids = input('param.ids/a');
            if(count($ids)==0){
                return json(['error'=>1,'msg'=>'非法']);
            }
            try{
                if(\siruisoft\common\service\Model::is_truedelete('PhoneCode')){
                    model('PhoneCode')->where([['id','in',$ids]])->delete();
                }else{
                    model('PhoneCode')->where([['id','in',$ids]])->update(['is_del'=>1,'del_time'=>time()]);
                }
                $this->log_record('删除验证码');
                return json(['error'=>0,'msg'=>'删除成功']);
            }catch(Exception $e){
                return json(['error'=>1,'msg'=>'删除失败']);
            }
        }
    }

    function contact(){
        if($this->request->isAjax()) {
            $id = $this->request->has('id') ? $this->request->param('id', 0, 'intval') : 0;
            try{
                model('PhoneCode')->where('id',$id)->setInc('contact_num',1);
                return json(['error'=>0,'msg'=>'操作成功']);
            }catch(Exception $e){
                return json(['error'=>1,'msg'=>'操作失败']);
            }
        }
    }

}