<?php

/**
 * @Author: 思睿软件
 * @Date:   2020-01-12 14:32:47
 * @Last Modified by:   Administrator
 * @Last Modified time: 2020-03-11 22:26:06
 * 用户管理
 */
namespace siruisoft\admin\controller;

use \think\Db;

class User extends Adminbase
{

	function initialize(){
        parent::initialize();
    }

    /**
     * [index 用户列表]
     * @Author   思睿软件<363359328@qq.com>
     * @DateTime 2020-01-14T08:59:24+0800
     * @return   [type]                   [description]
     */
    function index(){
        $condition[] =['U.is_del','=',0];
        $rows = Db::name('user')
                ->alias('U')
                ->where($condition)
                ->paginate(15,false,['query'=>request()->param()])
                ->each(function($item,$key){
                    $link =  model('UserGroupLink')->getByUid($item['uid']);
                    if(abs($link['user_group_id'])>0){
                        $user_group=model('UserGroup')->getById($link['user_group_id']);
                        $group_name = $user_group['name'];
                    }else{
                        $group_name = '一般会员';
                    }
                    $item['group_name'] = $group_name ;
                    return $item;
                });
        $this->assign('rows',$rows);
        return $this->fetch();
    }


    function add(){
        if(request()->isPost()){
            $post = input('param.');
            $validate=validate('User');
            $result = $validate->check($post);
            if($result!==true){
                return ['error'=>1,'msg'=>$validate->getError()];
            }
            $post['login_salt'] = mt_rand(10000,99999);
            $post['password'] = password($post['password'],$post['login_salt']);
            $post['ctime'] = time();
            $post['is_audit']=1;
            $post['is_active']=1;
            Db::startTrans();
            try {
                //插入用户
                $uid=model('User')->allowField(true)->save($post);
                if(abs($post['user_group_id'])>0){
                    model('UserGroupLink')->insert(['uid'=>$uid,'user_group_id'=>$post['user_group_id']]);
                }
                Db::commit();
                return ['error'=>0,'msg'=>'操作成功'];
            } catch (Exception $e) {
                Db::rollback();
                return ['error'=>1,'msg'=>'操作失败'];
            }
        }
        $this->assign('groups',model('UserGroup')->getAll());
        $this->assign('action',url('User/add'));
        return $this->fetch('publish');
    }


    function edit(){
        $uid = input('param.uid/d');
        $row = model('User')->find($uid);
        if(request()->isPost()){
            $post = input('param.');
            $validate=validate('User');
            $result = $validate->scene('edit')->check($post);            
            if($result!==true){
                return ['error'=>1,'msg'=>$validate->getError()];
            }
            if($post['password']){
                $post['password'] = password($post['password'],$row['login_salt']);
            }
            Db::startTrans();
            try {
                //插入用户
                model('User')->allowField(true)->save($post,['uid'=>$uid]);
                //清除所有
                model('UserGroupLink')->where('uid',$uid)->delete();
                if(abs($post['user_group_id'])>0){
                    model('UserGroupLink')->insert(['uid'=>$uid,'user_group_id'=>$post['user_group_id']]);
                }
                Db::commit();
                return ['error'=>0,'msg'=>'操作成功'];
            } catch (Exception $e) {
                Db::rollback();
                return ['error'=>1,'msg'=>'操作失败'];
            }
        }
        $this->assign('user_group_id',model('UserGroupLink')->where('uid',$uid)->value('user_group_id'));
        $this->assign('groups',model('UserGroup')->getAll());
        $this->assign('action',url('User/edit'));
        $this->assign('row',$row);
        return $this->fetch('publish');
    }



    function delete(){
        if($this->request->isAjax()) {
            $id = $this->request->has('id') ? $this->request->param('id', 0, 'intval') : 0;
            try{

                model('User')->where('id',$id)->update(['is_del'=>1,'del_time'=>time()]);
                $this->log_record('删除用户');
                return json(['error'=>0,'msg'=>'操作成功']);
            }catch(Exception $e){
                return json(['error'=>1,'msg'=>'操作失败']);
            }
        }
    }
    

}