<?php
namespace siruisoft\admin\controller;

use \think\Db;


/**
 * @Author: 思睿软件
 * @Date:   2020-01-12 14:47:08
 * @Last Modified by:   Administrator
 * @Last Modified time: 2020-03-11 16:09:13
 * 用户组管理
 */

class Usergroup extends Adminbase
{	

	function initialize(){
        parent::initialize();
    }



    function index(){
    	$rows = model('UserGroup')->order('id asc')->select();
    	$this->assign('rows',$rows);
    	return $this->fetch();
    }



    function publish(){
    	$id = $this->request->has('id') ? $this->request->param('id', 0, 'intval') : 0;
    	if($this->request->isPost()){
            $rules = input('param.rules/a');
            $rule_list = model('menu')->levelMenuIds($rules);
            
            $name = trim(input('param.name/s'));
            if(empty($name)){
                return json(['error'=>1,'msg'=>'名称必须填写']);
            }
            if(!is_array($rule_list) || count($rule_list)==0){
                return json(['error'=>1,'msg'=>'必须选择权限']);
            }
            $condition[]=['name','=',$name];
            if($id>0){
                 $condition[]=['id','<>',$id];
            }
            if(model('UserGroup')->where($condition)->count()>0){
                return json(['error'=>1,'msg'=>'用户组已经存在']);
            }
            try {
                $data['name'] = $name;
                $data['rule_list'] = implode(',', $rule_list);
                $data['ctime'] = time();
                if($id>0){
                    model('UserGroup')->where('id',$id)->update($data);
                    $this->log_record('编辑用户组,id:'.$id);
                }else{
                    $id = model('UserGroup')->insertGetId($data);
                    $this->log_record('添加用户组,id:'.$id);
                }
                return json(['error'=>0,'msg'=>'操作成功']);
            } catch (Exception $e) {
                return json(['error'=>1,'msg'=>'操作失败']);
            }
    	}
    	if($id>0){
    		$row = model('UserGroup')->where('id',$id)->find();
    		$row['rule_list'] = explode(',',$row['rule_list']);
    	}
    	$this->assign('row',$row);
    	return $this->fetch();
    }

    //获取权限菜单
    function getallrules(){
        $user_group_id = input('param.user_group_id/d');
        $rule_array =[];
        if($user_group_id>0){ //获取rulisst
            $rule_list = model('UserGroup')->where('id',$user_group_id)->value('rule_list');
            $rule_array = explode(',',$rule_list);
        }
        $menus = model('menu')->where('is_del',0)->order('sort_order ASC')->select();
        $menus = model('menu')->levelMenusLayui($menus,$rule_array);
        exit(json_encode($menus,JSON_UNESCAPED_UNICODE));
    }



    function delete(){
        if($this->request->isAjax()) {
            $id = $this->request->has('id') ? $this->request->param('id', 0, 'intval') : 0;
            try{
                model('UserGroup')->where('id',$id)->update(['is_del'=>1,'del_time'=>time()]);
                $this->log_record('删除用户组,id:'.$id);
                return json(['error'=>0,'msg'=>'操作成功']);  
            }catch(Exception $e){
                return json(['error'=>1,'msg'=>'操作失败']);  
            }
        }
    }

}