<?php
namespace siruisoft\admin\controller;

use \think\Db;


/**
 * @Author: 思睿软件
 * @Date:   2020-01-12 14:47:08
 * @Last Modified by:   Administrator
 * @Last Modified time: 2020-03-11 16:09:13
 * 用户组管理
 */

class Uservip extends Adminbase
{	

	function initialize(){
        parent::initialize();
    }



    function index(){
    	$rows = model('UserVip')->getAll();
    	$this->assign('rows',$rows);
    	return $this->fetch();
    }



    function publish(){
    	$id = $this->request->has('id') ? $this->request->param('id', 0, 'intval') : 0;
        if($this->request->isPost()) {
            $post = $this->request->post();

            $post['title'] = trim($post['title']);
            $validate = validate('base');
            if(!$validate->check($post)){
                return json(['error'=>1,'msg'=>$validate->getError()]);   
            }
            $condition[]=['title','=',$post['title']];
            
            $condition[]=['is_del','=',0];
            if($id>0){
                $condition[]=['id','<>',$id];
            }
            //判断是否存在
            if(model('UserVip')->where($condition)->count()>0){
                return json(['error'=>1,'msg'=>'名称已经存在']);   
            }
            $post['ctime'] = time();
            try {
                if($id>0){
                    model('UserVip')->allowField(true)->save($post,['id'=>$id]);
                    $this->log_record('编辑会员等级,id:'.$id);
                }else{
                    model('UserVip')->allowField(true)->save($post);
                    $this->log_record('添加会员等级,id:'.$id);
                }
                model('UserVip')->clearcache();
                return json(['error'=>0,'msg'=>'操作成功']); 
            } catch (Exception $e) {
                return json(['error'=>1,'msg'=>'操作失败']);
            }
        }
        $row = ['sort'=>model('UserVip')->getMaxLevel()+1];
        if($id>0){
            $row = model('UserVip')->where('id',$id)->find();
        }
        $this->assign('row',$row);
        return $this->fetch();
    }

    



    function delete(){
        if($this->request->isAjax()) {
            $id = $this->request->has('id') ? $this->request->param('id', 0, 'intval') : 0;
            try{
                model('UserVip')->where('id',$id)->update(['is_del'=>1,'del_time'=>time()]);
                $this->log_record('删除会员等级,id:'.$id);
                model('UserVip')->clearcache();
                return json(['error'=>0,'msg'=>'操作成功']);
            }catch(Exception $e){
                return json(['error'=>1,'msg'=>'操作失败']);
            }
        }
    }

}