<?php

/**
 * @Author: 思睿软件
 * @Date:   2020-01-03 16:53:01
 * @Last Modified by:   Administrator
 * @Last Modified time: 2020-03-11 15:29:49
 * 说明: 
 * tree 有两种 
 *  1:数组无嵌套  父亲---孩子---孙子----父亲---...顺序存放
 *     使用场景  后台菜单管理
 *  2: 数组有嵌套  每个节点构造child属性存放孩子  依次类推
 *     使用场景  多级菜单等
 * 
 */
namespace siruisoft\common\model;

use siruisoft\common\model\ModelBase;

use \think\Db;


/**
* 
*/
class Menu extends ModelBase
{

	protected $name = 'menu';
	protected $ctag = 'menu';
	
    //获取所有菜单
	function  getAllMenus(){
		$ckey = 'all_menus';
		$rows = tag_cache($this->ctag,$ckey);
		if($rows) return $rows;
		$rows = $this->where('is_del',0)->order('sort_order ASC')->select();
		if($rows){
			$rows = $rows->toArray();
			tag_cache($this->ctag,$ckey,$rows);
		}
		return $rows;
	}


	

    /**
     * [getMenusByIds 获取多个]
     * @Author   思睿软件<363359328@qq.com>
     * @DateTime 2020-01-03T17:05:33+0800
     * @param    [array或string]             $ids [description]
     * @return   [type]                        [description]
     */
	function getMenusByIds($ids){
		if(!is_array($ids)) $ids = array_unique(array_filter(explode(',',$ids)));
		if(empty($ids)) return [];
		$all = $this->getAllMenus();
		$rets=[];
		foreach ($all as $key => $value) {
			if(in_array($value['id'],$ids)){
				$rets[] = $value;
			}
		}
		return $rets;
	}


    /**
     * [levelMenus zTree 等使用]
     * @Author   思睿软件<363359328@qq.com>
     * @DateTime 2020-01-03T17:56:30+0800
     * @param    [type]                   $menus [description]
     * @return   [type]                          [description]
     */
	function listToTree($array,$pk = 'id', $pid = 'pid',$child = 'children', $root = 0){
		$tree = $packData = [];
        foreach ($array as $data) {
            $packData[$data[$pk]] = $data;
        }
        foreach ($packData as $key =>$val) {
            if ($val[$pid] == $root) {//代表根节点
              $tree[] = & $packData[$key];
            } else {
              //找到其父类
              $packData[$val[$pid]][$child][] = & $packData[$key];
            }
        }
        return $tree;
	}

	/**
	 * layui tree 专用 权限管理 改造输出 id name parent_id children 
	 * @Author   思睿软件<363359328@qq.com>
	 * @DateTime 2020-01-13T09:22:12+0800
	 * @param    [type]                   $array [description]
	 *           checkids                  选中的id
	 * @return   [type]                          [description]
	 */
	function levelMenusLayui($array,$checkids=[],$pk = 'id', $pid = 'parent_id',$child = 'children', $root = 0){
		$tree = $packData = [];
        foreach ($array as $data) {
        	$row =[];
        	$row['id'] = $data['id'];
        	$row['parent_id'] = $data['pid'];
        	$row['title'] = $data['title'];
        	$row['spread'] =false;
        	$row['checked'] = in_array($data['id'],$checkids)? true: false;
            $packData[$data[$pk]] = $row;
        }
        foreach ($packData as $key =>$val) {
            if ($val[$pid] == $root) {  
              $tree[] = & $packData[$key];
            } else {
              $packData[$val[$pid]][$child][] = & $packData[$key];
            }
        }
        return $tree;
	}

    
    /**
     * 后台菜单列表, 形式父亲-->孩子--->父亲-->孩子....
     * @Author   思睿软件<363359328@qq.com>
     * @DateTime 2020-01-06T16:44:33+0800
     * @param    [type]                   $menus  [description]
     * @param    integer                  $id    [description]
     * @param    integer                  $level [description]
     * @return   [type]                          [description]
     */
	public function menuList($menus,$id=0,$level=0){
		
		static $rets = array();
		foreach ($menus as $value) {
			if ($value['pid']==$id) {
				$value['level'] = $level+1;
				if($level>0){
					$value['prefix'] = str_repeat('&emsp;&emsp;',$value['level']).'└ ';
				}else{
					$value['prefix'] ='';
				}
				$rets[] = $value;
				$this->menulist($menus,$value['id'],$value['level']);
			}
		}
		return $rets;
	}

	//根据层级关系获取所有id
	function levelMenuIds($menus){
		if(empty($menus)) return [];
		static  $ids =[];
		foreach ($menus as $key => $value) {
			$ids[]= $value['id'];
			if($value['children']){
				$this->levelMenuIds($value['children']);
			}
		}
		return array_unique(array_filter($ids));
	}





	function  getTops(){
		$allmenus = $this->getAllMenus();
		if(empty($allmenus)) return [];
		$ret=[];
		foreach ($allmenus as $key => $value) {
			if($value['pid']==0) $ret[]= $value;
		}
		return $ret;
	}


	
}