<?php

/**
 * @Author: 思睿软件
 * @Date:   2020-01-03 17:34:41
 * @Last Modified by:   Administrator
 * @Last Modified time: 2020-03-11 14:03:34
 * 后台使用
 */
namespace siruisoft\admin\service;

class Admin{
	
	/**
	 * [checkLogin 检查登录]
	 * @Author   思睿软件<363359328@qq.com>
	 * @DateTime 2020-01-06T14:31:05+0800
	 * @return   int 1:已经登录 0 没有登录
	 */
	static function checkLogin(){
		$admin = session('admin');
		if($admin && $admin['uid']>0){
			return 1;
		}
		//判读是否记住密码
		if(1==cookie('admin_online')){
			$login_name = cookie('login_name');
			if(empty($login_name)){
				cookie('admin_online',null);
				return 0;
			}
			$row = model('User')->getByName($login_name);
			try {
				model('User')->where('uid',$row['uid'])->update(['last_login_time'=>time()]);
		        log_record($row['uid'],$row['uname'],'登录成功');    
		        session('admin',$row);
		        return 1;
			} catch (Exception $e) {
				return 0;
			}
		}
	    return 0;
	}


	static function logout(){
		cookie('admin_online',null);
        cookie('login_name',null);
		session('admin',null);
	}

    
    /**
     * [login 登录]
     * @Author   思睿软件<363359328@qq.com>
     * @DateTime 2020-01-06T14:31:29+0800
     * @param    string $name [description]
     * @return   ['error'=>1|0,'msg'=>'',data=>[]]
     * 登录逻辑:
     * 检查---->写日志--->写session-->登录成功
     */
	static function login($name,$password){
		$row=model('user')->getByName($name);
		if(empty($row)){
			return ['error'=>1,'msg'=>'用户不存在'];
		}
        if (password($password,$row['login_salt']) != $row['password']){
            return ['error'=>1,'msg'=>'密码错误'];         
        }
		//记录日志并修改登录时间
		try {
			model('User')->where('uid',$row['uid'])->update(['last_login_time'=>time()]);
	        log_record($row['uid'],$row['uname'],'登录成功');
	        unset($row['password'],$row['login_salt']);      
	        session('admin',$row);
	        return ['error'=>0,'msg'=>'登录成功'];
		} catch (Exception $e) {
			return ['error'=>1,'msg'=>'操作失败'];
		}
		
	}


		

		
		


	
	
}
?>