<?php 
namespace siruisoft\admin\validate;

use think\Validate;
/**
 * 验证类 user
 */
class User extends Validate
{

	protected $rule = [
        'uname'  =>  'require|unique:user',
        'phone'  =>  'require|mobile|unique:user',
        'password' =>'require',
       
    ];

    protected $message = [
        'uname.require'  => '用户名必须填写',
        'uname.unique'   => '用户名已经存在',
        'phone.require'  => '手机号码必须填写',
        'phone.unique'   => '手机号已经存在',
        'phone.mobile'   => '手机号格式错误',
        'password.require'   => '密码必须填写',
    ];


    protected $scene = [
        'edit'  =>  ['uname'=>'require|unique:user','phone'  =>  'require|mobile|unique:user'],
    ];


}