<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 流年 <liu21st@gmail.com>
// +----------------------------------------------------------------------

// 应用公共文件
error_reporting(E_ALL &  ~E_NOTICE);



function password($pass,$salt){
	return md5(md5($pass) . $salt);
}


/**
 * 大小转换
 * @Author   思睿软件
 * @DateTime 2020-02-06T10:46:57+0800
 * @Version  1.0
 * @param    [type]                   $size [description]
 * @param    integer                  $dec  [description]
 * @return   [type]                         [description]
 */
function byte_format($size, $dec = 2)
{
    $a   = array("B", "KB", "MB", "GB", "TB", "PB");
    $pos = 0;
    while ($size >= 1024) {
        $size /= 1024;
        $pos++;
    }
    return round($size, $dec) . " " . $a[$pos];
}


//小数转百分比
function num_to_percent($n)
{	
	return (round($n,2)*100)."%";
}



//系统日志 1:后台 0:前台
function log_record($uid,$uname,$info,$type=1){
	$data['uid'] = $uid;
	$data['uname'] = $uname;
	$data['module'] = request()->module();
	$data['controller']=request()->controller();
	$data['action']=request()->action();
	$data['info'] = $info;
	$data['type'] = $type;
	$data['ip'] = request()->ip();
	$data['ctime'] = time();
	return model('logs')->save($data);
	
}


//获取基本配置
function load_config($key='site',$list='admin_sysconfig'){
	$row= model('Xdata')->get($list.':'.$key);
	return $row;
}


//二维数组拼装成一位数组
function get_sub_by_key($source, $key = "", $condition = "")
{
    if(!is_array($source)) return false;
    $result = [];
    foreach ($source as $temp_array) {
        if (is_object($temp_array)) {
            $temp_array = (array) $temp_array;
        }
        if (("" != $condition && $temp_array[$condition[0]] == $condition[1]) || "" == $condition) {
            $result[] = ("" == $key) ? $temp_array : isset($temp_array[$key]) ? $temp_array[$key] : "";
        }
    }
    return $result;  
}



function get_domain(){
  return request()->domain();
}


//获取图片
function get_url($id)
{
    if(!is_numeric($id) || $id<=0){
       return DS.config('app.no_pic');
    }
    $row = \think\Db::name("attach")->where(['id' => $id])->find();
    if($row && $row['save_name']) {
        return DS.'public'.DS.'uploads'.DS.$row['save_path'].DS.$row['save_name'];
    }
    return DS.config('app.no_pic');
}

//通过id获取缩略图
function get_thumb($id,$width,$height){
    $filename = get_url($id);
    return resize($filename,$width,$height);
}

/**
 * 自动生成新尺寸 的图片
 * @param string $filename 文件名
 * @param int $width 新图片宽度
 * @param int $height 新图片高度(如果没有填写高度，把高度等比例缩小)
 */
function resize($filename, $width, $height=null) {
  if(empty($filename)){
    return;
  }      
  if (!is_file(ROOT_PATH.$filename)) {
      return;
  }
  //如果没有填写高度，把高度等比例缩小
  if($height==null){      
    $info = getimagesize(ROOT_PATH . $filename);      
    if($width>$info[0]){//如果缩小后宽度尺寸大于原图尺寸，使用原图尺寸
      $width=$info[0];
      $height=$info[1];
    }elseif($width<$info[0]){
      $height=floor($info[1]*($width/$info[0]));
    }elseif($width==$info[0]){
      return  $filename;
    }       
  }
  $old_image = $filename;
  //处理filename
  $filename = trim($filename);
  $filename = (0===strpos($filename,'/public/'))? str_replace('/public/','', $filename):$filename;
  $filename = (0===strpos($filename,'/upload/'))? str_replace('/uploads/','', $filename):$filename;
  $extension = pathinfo($filename, PATHINFO_EXTENSION);
  $new_image = 'cache/' . mb_substr($filename, 0, mb_strrpos($filename, '.')) . '-' . $width . 'x' . $height . '.' . $extension;
  if (!is_file(DIR_UPLOAD . $new_image)) {
    $directories = dirname($new_image);
    if (!is_dir(DIR_UPLOAD . $directories)) {
      @mkdir(DIR_UPLOAD . $directories, 0777,true);
    }
    list($width_orig, $height_orig) = getimagesize(ROOT_PATH . $old_image);
    if ($width_orig != $width || $height_orig != $height) {
      $image = new \siruisoft\Image(ROOT_PATH . $old_image);
      $image->resize($width, $height);
      $image->save(DIR_UPLOAD . $new_image);
    } else {  //不需要缩略
      copy(ROOT_PATH . $old_image, DIR_UPLOAD . $new_image);
    }
  }     
  return '/public/uploads/' . $new_image;      
}

//获取非图片附件
function get_attach($id){
    if(!is_numeric($id) || $id<=0) return '';
    $row = \think\Db::name("attach")->where(['id' => $id])->find();
    if($row && $row['save_name']) {
        return DS.'public'.DS.'uploads'.DS.$row['save_path'].DS.$row['save_name'];
    }
}


/* 
  查找  
  根据key 查找一条
*/
function get_one_by_item($array,$item,$value){
  if(!is_array($array) || empty($array) || empty($item)) return array();
  foreach ($array as $_key => $_value) {
      if($_value[$item]==$value) return $_value;
  }
  return array();
}




/* 
  查找  
  根据key 查找多条
*/
function get_all_by_item($array,$item,$value){
  if(!is_array($array) || empty($array) || empty($item)) return array();
  $ret=array();
  foreach ($array as $_value) {
      if($_value[$item]==$value){
        $ret[]=$_value;
      }
  }
  return $ret;
}