<?php
/**
 * @Author: 思睿软件
 * @Date:   2019-12-30 11:59:03
 * @Last Modified by:   Administrator
 * @Last Modified time: 2020-03-11 19:35:16
 * 基础controller
 */
namespace siruisoft\common\controller;

use think\Controller;
use think\Db;

class Base extends Controller
{
    
    protected $module;  
    protected $cotroller;
    protected $action;
    protected $uri;
    protected $site;      //站点信息
    protected $version;
    //白名单 无需鉴权uri
    protected $access_actions=[];  

    protected $user;   //公用

    function initialize(){
        parent::initialize();
        $this->module = request()->module();
        $this->controller = request()->controller();
        $this->action = request()->action();
        $this->uri = strtolower($this->module.DS.$this->controller.DS.$this->action);
        $this->version = config('version');
        $this->init_site();
    }

    
    /**
     * [initSite description]
     * @Author   思睿软件<363359328@qq.com>
     * @DateTime 2019-12-31T09:26:13+0800
     * @return   [type]                   [description]
     * 初始化站点 一些必要的配置
     * 后端只需要 站点配置信息
     */
    protected function init_site(){
        $this->site = load_config();
        $this->assign('site', $this->site);
        $this->assign('version',$this->version);
        
    }



    /**
     * 图片上传方法 前端专用
     * @return [type] [description]
     */
    public function upload($atype,$save=1)
    {
        if(empty(session('user')) || session('user')['uid']<=0){
            return json(['code'=>1,'msg'=>'请先登录']);
        }
        if($this->request->file('file')){
            $file = $this->request->file('file');
        }else{
            $res['code']=1;
            $res['msg']='没有上传文件';
            return json($res);
        }

        $file_info = $file->getInfo();
 

        $system_default = load_config('attach','admin_sysconfig');
    
        // 载入默认规则
        $options                = array();
        $options['custom_path'] = date('Y/m/d'); // 应用定义的上传目录规则：'Y/md/H/'
        $options['save_path']   = UPLOAD_PATH . DS . $options['custom_path'];
        $options['save_name']   = ''; //指定保存的附件名.默认系统自动生成
        $options['save_to_db']  = true;

        //获取配置文件
        $image_default    = load_config('attachimage','admin_sysconfig');
        if(empty($image_default)){
            $res['code']=1;
            $res['msg']='请先配置图片上传';
            return json($res);
        }
        $options['max_size']    =  floatval($image_default['attach_max_size']) * 1024 * 1024; // 单位: 兆
        $options['allow_ext']   =  $image_default['attach_allow_extension']; 
        $options['auto_thumb']             = $image_default['auto_thumb'];
        $info = $file->validate(['size'=>$options['max_size'],'ext'=>$options['allow_ext']])->rule('uniqid')->move($options['save_path']);
        if($info) {
            $res['code'] = 2;
            $res['src'] = DS.'uploads'.DS.$options['custom_path'].DS.$info->getSaveName();
            if($save){
                $data=[];
                $data['app_name']   = $this->_app;
                $data['attach_type'] = $atype;
                $data['uid']         =  session('user')['uid'];
                $data['ctime']     =  time();
                $data['name']      = $file_info['name'];
                $data['type']      = $file_info['type'];
                $data['size']      = $info->getSize();
                $data['extension'] = strtolower($info->getExtension());
                $data['hash']      = $info->md5();
                $data['save_path'] = $options['custom_path'];
                $data['save_name'] = $info->getSaveName();
                $res['id'] = Db::name('attach')->insertGetId($data);
            }
            return json($res);
        } else {
            // 上传失败获取错误信息
            return $this->error('上传失败：'.$file->getError());
        }
    }




    //用于单表插入操作
    public function single_table_insert($table_name,$user_action)
    {         
        $data=input('post.');           
        $result = $this->validate($data,$table_name);           
        if($result!==true){
            return array('error'=>$result);
        }
        try {
            $r=Db::name($table_name)->insert($data);
            $this->log_record($info);
            return ['error'=>0,'msg'=>'新增成功'];
        } catch (Exception $e) {
            return ['error'=>1,'msg'=>'新增失败'];
        }
    }

    
    //用于单表更新操作
    public function single_table_update($table_name,$info)
    {   
        $data=input('post.');           
        $result = $this->validate($data,$table_name);           
        if($result!==true){
            return array('error'=>$result);
        }
        try {
            $r=Db::name($table_name)->update($data);
            $this->log_record($info);
            return ['error'=>0,'msg'=>'更新成功'];
        } catch (Exception $e) {
            return ['error'=>1,'msg'=>'更新失败'];
        }                
    }










}