<?php
namespace siruisoft\common\model;
/**
 * 自定义数据验证模型
 * @Author   stonexu<qq:1443185877>
 * @DateTime 2019-07-20
 * validate的改写,只保留了检查
 * 调用方法  Regular::check($pram,'phone');
 */
class Regular
{
    /**
     * 正则表达式定义
     * @Author   stonexu<qq:1443185877>
     * @DateTime 2019-07-20
     * @param    [type]                         $type [description]
     * @return   [type]                               [description]
     */
    public static function get($type)
    {
        $type = lcfirst($type);
        switch ($type) {
            case 'phone':
                // 获取手机正则
                $result = '/^1[3|4|5|6|7|8|9]\d{9}$/';
                break;
            case 'date':
                $result = '/^\d{4}\-\d{1,2}\-\d{1,2}$/';
                break;
            case 'alpha':
                // 只允许字母
                $result = '/^[A-Za-z]+$/';
                break;
            case 'alphaNum':
                // 只允许字母和数字
                $result = '/^[A-Za-z0-9]+$/';
                break;
            case 'alphaDash':
                // 只允许字母、数字和下划线 破折号
                $result = '/^[A-Za-z0-9\-\_]+$/';
                break;
            case 'chs':
                // 只允许汉字
                $result = '/^[\x{4e00}-\x{9fa5}]+$/u';
                break;
            case 'chsAlpha':
                // 只允许汉字、字母
                $result = '/^[\x{4e00}-\x{9fa5}a-zA-Z]+$/u';
                break;
            case 'chsAlphaNum':
                // 只允许汉字、字母和数字
                $result = '/^[\x{4e00}-\x{9fa5}a-zA-Z0-9]+$/u';
                break;
            case 'chsDash':
                // 只允许汉字、字母、数字和下划线_及破折号-
                $result = '/^[\x{4e00}-\x{9fa5}a-zA-Z0-9\_\-]+$/u';
                break;
            case 'ip':
                // 是否为IP地址
                $result = '/^((?:(?:25[0-5]|2[0-4]\d|((1\d{2})|([1-9]?\d)))\.){3}(?:25[0-5]|2[0-4]\d|((1\d{2})|([1 -9]?\d))))$/';
                break;
            case 'url':
                // 是否为一个URL地址
                $result = '/\b(?:(?:https?|ftp):\/\/|www\.)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i';
                break;
            case 'number':
                $result = '/\d+/';
                break;
            case 'email':
                // 是否为邮箱地址
                $result = '/([\w\-\.]+\@[\w\-\.]+\.[\w\-\.]+)/'; // /^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/
                break;
        }

        return $result;
    }



    static function check($value,$type){
        $rule = self::get($type);
        if(empty($rule)) return false;
        return preg_match($rule,$value);
    }



}
