<?php
namespace siruisoft\common\model;

use siruisoft\common\model\ModelBase;
/**
 * @Author: 思睿软件
 * @Date:   2020-01-06 14:07:14
 * @Last Modified by:   Administrator
 * @Last Modified time: 2020-03-11 21:08:49
 * 用户模型
 */
class User extends ModelBase
{

	protected $name = 'user';

	protected $ctag = 'user';

	//如果使用默认验证器 主键如果不是id,必须声明pk
	protected $pk  ='uid';
	
    /**
     * [localLogin ]
     * @Author   思睿软件<363359328@qq.com>
     * @DateTime 2020-01-06T14:08:46+0800
     * @param    [type]                   $name     [description]
     * @param    [type]                   $password [description]
     * @return   [type]                             [description]
     */
	function  getByName($uname){
		if(empty($uname)){
			return [];
		}
		$condition[] = ['is_del','=',0];
		$condition[] = ['uname|phone','=',$uname];
		$row = $this->where($condition)->find();
		return $row;
	}


	function  getById($id){
		$condition[] = ['is_del','=',0];
		$condition[] = ['uid','=',$uid];
		$row = $this->where($condition)->find();
		return $row;
	}

   
	function getByIds($uids){
		if(!is_array($uids)) $uids = explode(',', $uids);
		$condition[] = ['is_del','=',0];
		$condition[] = ['uid','in',$uids];
		$rows = $this->where($condition)->select();
		return $rows;
	}


	//token 校验
	function getByToken($token){
		if(empty($token)) return '';
		$condition[] = ['is_del','=',0];
		$condition[] = ['token','=',trim($token)];
		$condition[] = ['token_expire','<',time()];
		$row = $this->where($condition)->find();
		return (array)$row;
	}









}
