<?php
namespace siruisoft\common\model;

use siruisoft\common\model\ModelBase;

/**
 * 用户组模型 - 数据对象模型
 * @author stonexu <363359328@qq.com>
 * @version 1.0
 */
class UserGroup extends ModelBase
{

    protected $name = 'user_group';
	protected $ctag = 'user_group';


	function getAll(){
		$ckey = 'user_group';
		$rows = tag_cache($this->ctag,$ckey);
		if($rows) return $rows;
		$rows = $this->where('is_del',0)->order('id ASC')->select();
		if($rows){
			$rows = $rows->toArray();
			tag_cache($this->ctag,$ckey,$rows);
		}
		return $rows;
	}


	function getById($id){
        $ckey ='group_'.$id;
        $row = tag_cache($this->ctag,$ckey);
        if(empty($row)){
            $row = $this->where('id',$id)->find();
            if($row){
                tag_cache($this->ctag,$ckey,$row);
            }
        }
        return $row;
    }

}
