<?php
namespace siruisoft\common\model;

use siruisoft\common\model\ModelBase;

/**
 * 用户组关联模型 - 数据对象模型
 * @author stonexu <363359328@qq.com>
 * @version sr1.0
 */
class UserGroupLink extends ModelBase
{

    

    protected $name = 'user_group_link';

    protected $ctag = 'user_group_link';
    

  
    /**
     * 获取用户的用户组信息
     * @param array $uids 用户UID数组
     * @return array 用户的用户组信息
     */
    public function getUserGroup($uids)
    {
        $uids = !is_array($uids) ? explode(',', $uids) : $uids;
        $uids = array_unique(array_filter($uids));
        if (!$uids) return false;

        $return = array();
        foreach ($uids as $uid) {
            $return[$uid] = tag_cache($this->ctag,'user_group_' . $uid);
            if ($return[$uid] == false) {
                $map['uid']   = $uid;
                $group         = $this->where($map)->find();
                $return[$uid] = $group['user_group_id'];
                tag_cache($this->ctag,'user_group_' . $uid, $return[$uid]);
            }
        }

        return $return;
    }


    function getByUid($uid){
        $ckey ='user_group_'.$uid;
        $row = tag_cache($this->ctag,$ckey);
        if(empty($row)){
            $row = $this->where('uid',$uid)->find();
            if($row){
                tag_cache($this->ctag,'user_group_' . $uid,$row);
            }
        }
        return $row;
    }


}
