<?php
namespace siruisoft\common\model;

use siruisoft\common\model\ModelBase;

/**
 *  system_data 操作
 */
class Xdata extends ModelBase
{
    protected $name = 'config_data';
    protected $ctag = 'config_data';

    protected $list_name = 'admin_sysconfig';            // 默认列表名

    //键值白名单，主要用于获取和设置配置文件某个
    protected $whiteList = array('site' => '');

    protected $prefix='';


    function initialize(){
        parent::initialize();
        $this->prefix = config('database.prefix');
    }


    public function lput($listName = '', $listData = array())
    {
        // 初始化list_name
        $listName = $this->_strip_key($listName);
        $result   = false;
        // 格式化数据
        if (is_array($listData)) {
            $insert_sql .= " REPLACE INTO `".$this->prefix.$this->name."` (`list`,`key`,`value`,`mtime`) VALUES ";
            foreach ($listData as $key => $data) {
                $insert_sql .= " ('$listName','$key','" . serialize($data) . "','" . date('Y-m-d H:i:s') . "') ,";
            }
            $insert_sql = rtrim($insert_sql, ',');
            // 插入数据列表
            $result = $this->execute($insert_sql);
        }
        $cache_id = '_xdata_lget_' . $listName;
        tag_cache($this->ctag,$cache_id,null);
        return $result;
    }


    /**
     * 读取参数列表
     * @param string $list_name 参数列表list
     * @param boolean $nostatic 是否不使用静态缓存，默认为false
     * @return array 参数列表
     */
    public function lget($list_name = '', $nostatic = false)
    {
        $list_name = $this->_strip_key($list_name);
        static $_res = array();
        if (isset($_res[$list_name]) && !$nostatic) {
            return $_res[$list_name];
        }

        $cache_id = '_xdata_lget_' . $list_name;
        $data = tag_cache($this->ctag,$cache_id);
        if (empty($data)) {
            $data          = array();
            $map[] =['list','=',$list_name];
            $result        = $this->order('id ASC')->where($map)->select();
            if ($result) {
                foreach ($result as $v) {
                    $data[$v['key']] = unserialize($v['value']);
                }
            }
            tag_cache($this->ctag,$cache_id,$data);
        }
        $_res[$list_name] = $data;
        return $_res[$list_name];
    }



    public function put($key, $value = '', $replace = true)
    {
        $key  = $this->_strip_key($key);
        $keys = explode(':', $key);
        $data = addslashes(serialize($value));

        if ($replace) {
            $insert_sql = "REPLACE INTO ".$this->prefix.$this->name;
        } else {
            $insert_sql = "INSERT INTO  ".$this->prefix.$this->name;
        }
        $insert_sql .= "(`list`,`key`,`value`,`mtime`) VALUES ('$keys[0]','$keys[1]','$data','" . date('Y-m-d H:i:s') . "')";

        $result = $this->execute($insert_sql);
        $cache_id = '_xdata_lget_' . $keys[0];
       
        tag_cache($this->ctag,$cache_id,null);

        return $result;
    }



    public function get($key)
    {
        $key  = $this->_strip_key($key);
        $keys = explode(':', $key);
        static $_res = array();
        if (isset($_res[$key])) {
            return $_res[$key];
        }
        $list = $this->lget($keys[0]);
        return $list ? $list[$keys[1]] : [];
    }


    public function getConfig($key, $systemKey, $systemList = 'admin_sysconfig')
    {
        if (empty($systemKey)) {
            return false;
        }
        $_key = $systemList . ':' . $systemKey;
        $data = $this->get($_key);

        return $data[$key];
    }

    /**
     * 存储单个数据，将原来的save修改为saveKey
     * @param string $key 要存储的参数list:key
     * @param string $value 要存储的参数的值
     * @return boolean 是否存储成功
     */
    public function saveKey($key, $value = '')
    {
        $result = $this->put($key, $value, true);

        return $result;
    }

    /**
     * 批量读取数据，非必要
     * @param string $listName 参数列表list
     * @param array|object $keys 参数键key
     * @return array 通过list与key批量获取的数据
     */
    public function getAll($listName, $keys)
    {
        // 用于获取list下所有数据
        if ($key) {
            $keysArray    = $this->_parse_keys($keys);
            $map[]= ['key','in',$keysArray];
        }
        $map[]= ['list','=',$listName];
        $result        = $this->where($map)->select();

        if (!$result) {
            return false;
        } else {
            foreach ($result as $v) {
                $datas[$v['list']][$v['key']] = unserialize($v['value']);
            }
        }
        return $datas;
    }

    /**
     * 解析过滤输入
     * @param string|object|array $input 输入的数据
     * @return array 解析过滤后的输入数据
     */
    protected function _parse_keys($input = '')
    {
        $output = '';
        if (is_array($input) || is_object($input)) {
            foreach ($input as $v) {
                $output[] = $this->_strip_key($v);
            }
        } else if (is_string($input)) {
            $output[] = $this->_strip_key($input);
        } else {
            // 异常处理
        }

        return $output;
    }

    /**
     * 过滤key值
     * @param string $key 只允许格式，数字字母下划线，list:key不允许出现html代码和这些符号 ' " & * % ^ $ ? ->
     * @return string 过滤后的key值
     */
    protected function _strip_key($key = '')
    {
        if ($key == '') {
            return $this->list_name;
        } else {
            return preg_replace('/([^0-9a-zA-Z\_\:\/\*])/', '', $key);
        }
    }

}
