<?php
/**
 *  自定义助手函数
 */
use think\facade\Cache;
use think\exception\ClassNotFoundException;

if (!function_exists('sirui_model')) {
    /**
     * siruisoft model 助手函数
     */
    function sirui_model($module_name,$controller_name)
    {
    	$class = '\\siruisoft\\'.$module_name.'\\model\\' . ucwords($controller_name);	
        
		if (class_exists($class)) {
               return new $class();
        } else {
                throw new ClassNotFoundException('class not exists:' . $class, $class);
        }
    }
}


if (!function_exists('sirui_service')) {
    /**
     * siruisoft service助手函数
     */
    function sirui_service($module_name,$service_name)
    {
    	$class = '\\siruisoft\\'.$module_name.'\\service\\' . ucwords($service_name);	
        
		if (class_exists($class)) {
               return new $class();
        } else {
                throw new ClassNotFoundException('class not exists:' . $class, $class);
        }
    }
}


if (!function_exists('sirui_service')) {
    /**
     * siruisoft service助手函数
     */
    function sirui_service($module_name,$service_name)
    {
        $class = '\\siruisoft\\'.$module_name.'\\service\\' . ucwords($service_name);   
        
        if (class_exists($class)) {
               return new $class();
        } else {
                throw new ClassNotFoundException('class not exists:' . $class, $class);
        }
    }
}






if (!function_exists('tag_cache')) {
    /**
     * 缓存设置,带标签 时间都为0 永久
     * @param mixed     $tag 标签名称
     * tag_cache('tag',null) 删除tag下所有
     * tag_cache('tag','key') 获取 tagkey
     * tag_cache('tag','key',null) 删除tag下key
     * tag_cache('tag','key','val')设置key
     */
    function tag_cache($tag,$key,$val='',$expire=0){
        if(empty($tag)){
            exit('tag不能为空');
        }
        if(is_null($key)){
            Cache::clear($tag);
            return 1;
        }
        if(''===$val){
            return Cache::tag($tag)->get($key);
        }
        if(is_null($val)){
            Cache::tag($tag)->rm($key);
            return 1;
        }
        Cache::tag($tag)->set($key,$val,$expire);
        return 1;
    }
}

?>