<?php
namespace siruisoft\widget\controller;
/**
 * @Author: 思睿软件
 * @Date:   2020-01-11 15:18:23
 * @Last Modified by:   xjx
 * @Last Modified time: 2020-01-12 09:48:46
 * 多级联动widget
 */

use think\Controller;
use think\Db;

class Categorylevel extends Controller
{
	

	function index($table,$id,$default='',$class=''){
		$this->assign('table',$table);
		$this->assign('id',$id);   //字段名称
		$this->assign('default',$default);
		$this->assign('class',$class);
		return $this->fetch('widget@categorylevel/index');
	}


	 /**
     * 获取所有的顶级分类
     */
    public function getParentLevelAll()
    {
        //预先取第一级分类
        $map[]=['pid','=',0];
        $table = input('param.table/s');
        $_parentLevelAll = model('category')->setTable($table)->getSonCategorys(0);
        $parentLevelAll = array();
        foreach ((array)$_parentLevelAll as &$v) {
            $v['title']                         = \util\Str::substr($v['title'],0, 15);
            $parentLevelAll[$v['id']] = $v;
        }
        unset($v);
        exit(json_encode($parentLevelAll ? $parentLevelAll : [],JSON_UNESCAPED_UNICODE));
    }

    /**
     * 获取所有的子集
     * @param integer type 分类类型 1:课程分类，2:点播分类
     * @param integer pid 父级ID
     */
    public function getChildrenAll($pid)
    {
        $pid = intval($pid) ? intval($pid) : intval(input('param.pid/d'));
        $table = trim(input('param.table/s'));
        $_parentLevelAll =  model('category')->setTable($table)->getSonCategorys($pid);
        $parentLevelAll = array();
        foreach ((array)$_parentLevelAll as &$v) {
            $v['title']                         = \util\Str::substr($v['title'],0, 15);
            $parentLevelAll[$v['id']] = $v;
        }
        unset($v);
        exit(json_encode($parentLevelAll ? $parentLevelAll : [],JSON_UNESCAPED_UNICODE));
    }



}