CREATE TABLE IF NOT EXISTS `kmd_wh_asset` (
  `itemid` int(10) NOT NULL AUTO_INCREMENT COMMENT '应用id',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户关联id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '应用名称',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '应用类型 sms短信 redpacket红包 ',
  `status` int(1) NOT NULL DEFAULT '0' COMMENT '0,1',
  `introduce` varchar(300) NOT NULL DEFAULT '' COMMENT '应用简介',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '内部备注，仅后端可看',
  `list_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序，越大越靠前',
  `begin_time` int(10) NOT NULL DEFAULT '0' COMMENT '开通时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '到期时间',
  `created_at` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updated_at` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`itemid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='智慧助手-资产表';

-- ----------------------------
-- Records of kmd_wh_asset
-- ----------------------------

-- ----------------------------
-- Table structure for kmd_wh_setting
-- ----------------------------
CREATE TABLE IF NOT EXISTS `kmd_wh_setting` (
  `itemid` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `item` varchar(30) NOT NULL DEFAULT '' COMMENT '项目',
  `item_key` varchar(100) NOT NULL DEFAULT '',
  `item_value` text NOT NULL,
  PRIMARY KEY (`itemid`),
  KEY `item` (`item`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='设置表';

-- ----------------------------
-- Records of kmd_wh_setting
-- ----------------------------

-- ----------------------------
-- Table structure for kmd_wh_task
-- ----------------------------
CREATE TABLE IF NOT EXISTS `kmd_wh_task` (
  `itemid` int(10) NOT NULL AUTO_INCREMENT COMMENT '应用id',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户关联id',
  `asset_id` int(10) NOT NULL DEFAULT '0' COMMENT '关联资产ID',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '名称',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '类型',
  `status` varchar(255) NOT NULL DEFAULT '' COMMENT '任务状态',
  `introduce` varchar(300) NOT NULL DEFAULT '' COMMENT '应用简介',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '内部备注，仅后端可看',
  `list_order` int(10) NOT NULL DEFAULT '0',
  `begin_time` int(10) NOT NULL DEFAULT '0' COMMENT '任务计划开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '任务计划结束时间',
  `created_at` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updated_at` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`itemid`)
) ENGINE=MyISAM AUTO_INCREMENT=101 DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `kmd_wh_user` (
  `itemid` int(10) NOT NULL AUTO_INCREMENT COMMENT '应用id',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户关联id',
  `is_admin` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否是管理员',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '应用名称',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '类型',
  `status` varchar(255) NOT NULL DEFAULT '' COMMENT '状态',
  `introduce` varchar(300) NOT NULL DEFAULT '' COMMENT '简介',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '内部备注，仅后端可看',
  `list_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序，越大越靠前',
  `begin_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '到期时间',
  `created_at` int(10) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `updated_at` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`itemid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

