<?php

	namespace app\admin\controller;
	use cmf\controller\AdminBaseController;
	use think\Db;
	class ProjectController extends AdminBaseController {

		//模糊查询作品
		public function get_project_txt(){
			$shuju = $this->request->param();
			$txt = empty($shuju['txt']) ? '' : $shuju['txt'];
			if ($txt) {
				$condition = "(a.title like '%$txt%') or (b.user_login like '%$txt%') or (b.user_nickname like '%$txt%') or (b.user_email like '%$txt%')";
				$list = Db::name('project')->alias('a')->join('__USER__ b','a.uid = b.id')->where($condition)->field('title')->order('update_time desc')->limit(10)->select();
			} else {
				$list = array();
			}
			$data = array('status'=>1,'lists'=>$list);
			return json($data);
		}

		//作品列表
		public function index(){
			$shuju = $this->request->param();
			if (!empty($shuju['is_ajax'])) {
				$field = empty($shuju['field']) ? '' : $shuju['field']; //排序字段名
				$order = empty($shuju['order']) ? '' : $shuju['order']; //排序方式
				$limit = empty($shuju['limit']) ? '' : $shuju['limit']; //每页条数
				$limit = $limit > 150 ? 150 : $limit;
				$condition = "a.id > 0";

				$sousuo = empty($shuju['sousuo']) ? '' : $shuju['sousuo'];
				$status = empty($shuju['status']) ? '' : $shuju['status'];

				
				if ($sousuo) {
					$condition .= " and ((a.post_title like '%$sousuo%') or (b.user_login like '%$sousuo%') or (b.user_nickname like '%$sousuo%') or (b.user_email like '%$sousuo%'))";
				}
				if ($field && $order) {
					$zdpx = "a.".$field." ".$order;
				} else {
					$zdpx = "a.id DESC";
				}
				$list = Db::name('project')->alias('a')->join('__USER__ b','a.uid = b.id')->where($condition)->field('a.*,b.user_login,b.avatar,b.user_nickname,b.mobile,b.user_email')->order($zdpx)->paginate($limit)->toArray();
				foreach ($list['data'] as $key => $value) {
					
					$list['data'][$key]['yhtx'] = $value['avatar'] ? '<img src="'.cmf_get_image_url($value['avatar']).'" style="width:33px;height:33px;border-radius:50%;">' : "——";
					$list['data'][$key]['create_time'] = $value['create_time'] ? date('Y-m-d H:i:s',$value['create_time']) : "——";
					$list['data'][$key]['update_time'] = $value['update_time'] ? date('Y-m-d H:i:s',$value['update_time']) : "——";
				}
				$return_data = array(
					'code'=>0,
					'count'=>$list['total'],
					'data'=>$list['data']
				);
				return json($return_data);
			} else {
				$this->assign('dhxz',3);
				$this->assign('title','作品列表');
				return $this->fetch();
			}
		}
		//修改资料
		public function projectedit(){
			$id = input('id');
			$data = db('project_post')->find($id);
			$this->assign('data',$data);
			return $this->fetch();
		}
		public function editupdate(){
			$data=input('post.');
			if(request()->isPost()){
				$base=[
					'id'=>input('id'),
					'post_title'=>input('post_title'),
					'post_status'=>input('switch')?1:0,
					'post_excerpt'=>input('post_excerpt'),
					'mode'=>input('mode'),
					'operation_manual'=>input('operation_manual')
				];
				if(db('project_post')->update($base)){
					return 2;//修改成功
				}else{
					return 1;//修改失败
				}
			}
		}
		//作品设置
		public function shezhi(){
			$shuju = $this->request->param();
			if ($this->request->isPost()) {
				$id = empty($shuju['id']) ? '' : $shuju['id'];
				if ($id) {
					$data_project['comment_status'] = empty($shuju['comment_status']) ? 0 : 1;
					$data_project['is_top'] = empty($shuju['is_top']) ? 0 : 1;
					$data_project['recommended'] = empty($shuju['recommended']) ? 0 : 1;
					$isok = Db::name('project_post')->where(array('id'=>$id))->update($data_project);
					if ($isok) {
						$data = array('status'=>1,'info'=>'设置成功');
					} else {
						$data = array('status'=>0,'info'=>'设置失败！');
					}
					return json($data);
				} else {
					$data = array('status'=>0,'info'=>'未找到作品！');
				}
				return json($data);
			} else {
				$project = Db::name('project_post')->where(array('id'=>$shuju['id']))->field('id,comment_status,is_top,recommended')->find();
				$this->assign('project',$project);
				return $this->fetch();
			}
		}

		//查看作品
		public function neirong(){
			return $this->fetch();
		}

		//审核作品
		public function shenhe(){
			$shuju = $this->request->param();
			if ($this->request->isPost()) {
				$id = empty($shuju['id']) ? '' : $shuju['id'];
				if ($id) {
					if (empty($shuju['status'])) {
						$data = array('status'=>0,'info'=>'请选择审核意见！');
					} else {
						$status = Db::name('project_post')->where(array('id'=>$id))->value('status');
						if ($status == 3) {
							if ($shuju['status'] == 1 || $shuju['status'] == 2) {
								$isok = Db::name('project_post')->where(array('id'=>$id))->setField('status',$shuju['status']);
								if ($isok) {
									$admin_user_info = session('admin_user_info');
									$data_shenhe['project_id'] = $id;
									$data_shenhe['user_id'] = $admin_user_info['id'];
									$data_shenhe['status'] = $shuju['status'];
									$data_shenhe['remark'] = $shuju['remark'];
									$data_shenhe['examine_time'] = time();
									Db::name('project_shenhe')->insert($data_shenhe);
									$data = array('status'=>1,'info'=>'审核成功');
								} else {
									$data = array('status'=>0,'info'=>'审核失败！');
								}
							} else {
								$data = array('status'=>0,'info'=>'请选择审核意见！');
							}
						} else {
							$data = array('status'=>0,'info'=>'作品已审核！');
						}
					}
				} else {
					$data = array('status'=>0,'info'=>'未找到作品！');
				}
				return json($data);
			} else {
				return $this->fetch();
			}
		}

		//审核日志
		public function rizhi(){
			$shuju = $this->request->param();
			$id = empty($shuju['id']) ? '' : $shuju['id'];
			$this->assign('id',$id);
			if (!empty($shuju['is_ajax'])) {
				if ($id) {
					$limit = empty($shuju['limit']) ? '' : $shuju['limit']; //每页条数
					$limit = $limit > 150 ? 150 : $limit;
					$condition = "a.project_id = ".$id;
					$list = Db::name('project_shenhe')->alias('a')->join('__PROJECT_POST__ b','a.project_id = b.id')->join('__USER__ c','a.user_id = c.id')->where($condition)->field('a.*,b.post_title,c.user_login,c.avatar,c.user_nickname,c.mobile,c.user_email')->order('a.examine_time desc')->paginate($limit)->toArray();
					foreach ($list['data'] as $key => $value) {
						switch ($value['status']) {
							case 1:
								$shzt = "已通过";
								break;
							case 2:
								$shzt = "已驳回";
								break;
							case 3:
								$shzt = "待审核";
								break;
							default:
								$shzt = "——";
								break;
						}
						$list['data'][$key]['shzt'] = $shzt;
						$list['data'][$key]['mobile'] = $value['mobile'] ? $value['mobile'] : "——";
						$list['data'][$key]['yhtx'] = $value['avatar'] ? '<img src="'.cmf_get_image_url($value['avatar']).'" style="width:33px;height:33px;border-radius:50%;">' : "——";
						$list['data'][$key]['examine_time'] = $value['examine_time'] ? date('Y-m-d H:i:s',$value['examine_time']) : "——";
					}
				} else {
					$list = array();
					$list['total'] = "";
					$list['data'] = "";
				}
				$return_data = array(
					'code'=>0,
					'count'=>$list['total'],
					'data'=>$list['data']
				);
				return json($return_data);
			} else {
				return $this->fetch();
			}
		}

		//删除作品
		public function delproject(){
			$shuju = $this->request->param();
			$id = empty($shuju['id']) ? '' : $shuju['id'];
			if ($id) {
				$delsj = Db::name('project_post')->where(array('id'=>$id))->value('delete_time');
				if ($delsj > 0) {
					$data = array('status'=>0,'info'=>'作品已删除！');
				} else {
					$isok = Db::name('project_post')->where(array('id'=>$id))->setField('delete_time',time());
					if ($isok) {
						$data = array('status'=>1,'info'=>'删除成功');
					} else {
						$data = array('status'=>0,'info'=>'删除失败！');
					}
				}
			} else {
				$data = array('status'=>0,'info'=>'未找到作品！');
			}
			return json($data);
		}

		//还原作品
		public function hyproject(){
			$shuju = $this->request->param();
			$id = empty($shuju['id']) ? '' : $shuju['id'];
			if ($id) {
				$delsj = Db::name('project_post')->where(array('id'=>$id))->value('delete_time');
				if ($delsj > 0) {
					$isok = Db::name('project_post')->where(array('id'=>$id))->setField('delete_time',0);
					if ($isok) {
						$data = array('status'=>1,'info'=>'还原成功');
					} else {
						$data = array('status'=>0,'info'=>'还原失败！');
					}
				} else {
					$data = array('status'=>0,'info'=>'作品未删除！');
				}
			} else {
				$data = array('status'=>0,'info'=>'未找到作品！');
			}
			return json($data);
		}

	}