<?php

	namespace app\admin\controller;
	use cmf\controller\AdminBaseController;
	use think\Db;
	class UserController extends AdminBaseController {

		//模糊查询用户
		public function get_user_txt(){
			$shuju = $this->request->param();
			$txt = empty($shuju['txt']) ? '' : $shuju['txt'];
			if ($txt) {
				$condition = "(user_login like '%$txt%') or (user_nickname like '%$txt%') or (user_name like '%$txt%') or (user_email like '%$txt%') or (user_url like '%$txt%') or (signature like '%$txt%')";
				$list = Db::name('user')->where($condition)->limit(10)->field('user_nickname')->order('last_login_time desc')->select();
			} else {
				$list = array();
			}
			$data = array('status'=>1,'lists'=>$list);
			return json($data);
		}

		//用户列表
		public function index(){
			$shuju = $this->request->param();
			if (!empty($shuju['is_ajax'])) {
				$field = empty($shuju['field']) ? '' : $shuju['field']; //排序字段名
				$order = empty($shuju['order']) ? '' : $shuju['order']; //排序方式
				$limit = empty($shuju['limit']) ? '' : $shuju['limit']; //每页条数
				$limit = $limit > 150 ? 150 : $limit;
				$condition = "id > 0";
				$sousuo = empty($shuju['sousuo']) ? '' : $shuju['sousuo'];
				$status = empty($shuju['status']) ? '' : $shuju['status'];
				$shijian1 = empty($shuju['shijian1']) ? '' : $shuju['shijian1'];
				$shijian2 = empty($shuju['shijian2']) ? '' : $shuju['shijian2'];
				if ($status) {
					$status = $status-1;
					$condition .= " and user_status = ".$status;
				}
				if ($shijian1) {
					$time_s1 = explode(' - ',$shijian1);
					$time_s11 = strtotime($time_s1[0]);
					$time_s12 = strtotime($time_s1[1])+86400;
					$condition .= " and create_time>=".$time_s11." and create_time<".$time_s12;
				}
				if ($shijian2) {
					$time_s2 = explode(' - ',$shijian2);
					$time_s21 = strtotime($time_s2[0]);
					$time_s22 = strtotime($time_s2[1])+86400;
					$condition .= " and last_login_time>=".$time_s21." and last_login_time<".$time_s22;
				}
				if ($sousuo) {
					$condition .= " and ((user_login like '%$sousuo%') or (user_nickname like '%$sousuo%') or (user_name like '%$sousuo%') or (user_email like '%$sousuo%') or (user_url like '%$sousuo%') or (signature like '%$sousuo%'))";
				}
				if ($field && $order) {
					$zdpx = $field." ".$order;
				} else {
					$zdpx = "id DESC";
				}
				$list = Db::name('user')->where($condition)->order($zdpx)->paginate($limit)->toArray();
				foreach ($list['data'] as $key => $value) {
					switch ($value['user_type']) {
						case 1:
							$yhlx = "admin";
							break;
						case 2:
							$yhlx = "会员";
							break;
						default:
							$yhlx = "——";
							break;
					}
					switch ($value['user_status']) {
						case 0:
							$yhzt = "禁用";
							break;
						case 1:
							$yhzt = "正常";
							break;
						case 2:
							$yhzt = "未验证";
							break;
						default:
							$yhzt = "——";
							break;
					}
					switch ($value['sex']) {
						case 0:
							$yhxb = "保密";
							break;
						case 1:
							$yhxb = "男";
							break;
						case 2:
							$yhxb = "女";
							break;
						default:
							$yhxb = "——";
							break;
					}
					$list['data'][$key]['yhlx'] = $yhlx;
					$list['data'][$key]['yhzt'] = $yhzt;
					$list['data'][$key]['yhxb'] = $yhxb;
					$list['data'][$key]['user_name'] = $value['user_name'] ? $value['user_name'] : "——";
					$list['data'][$key]['mobile'] = $value['mobile'] ? $value['mobile'] : "——";
					$list['data'][$key]['user_url'] = $value['user_url'] ? $value['user_url'] : "——";
					$list['data'][$key]['wechat'] = $value['wechat'] ? $value['wechat'] : "——";
					$list['data'][$key]['signature'] = $value['signature'] ? $value['signature'] : "——";
					$list['data'][$key]['user_activation_key'] = $value['user_activation_key'] ? $value['user_activation_key'] : "——";
					$list['data'][$key]['yhtx'] = $value['avatar'] ? '<img src="'.cmf_get_image_url($value['avatar']).'" style="width:33px;height:33px;border-radius:50%;">' : "——";
					$list['data'][$key]['birthday'] = $value['birthday'] ? date('Y-m-d H:i:s',$value['birthday']) : "——";
					$list['data'][$key]['create_time'] = $value['create_time'] ? date('Y-m-d H:i:s',$value['create_time']) : "——";
					$list['data'][$key]['last_login_time'] = $value['last_login_time'] ? date('Y-m-d H:i:s',$value['last_login_time']) : "——";
				}
				$return_data = array(
					'code'=>0,
					'count'=>$list['total'],
					'data'=>$list['data']
				);
				return json($return_data);
			} else {
				$this->assign('dhxz',2);
				$this->assign('title','用户列表');
				return $this->fetch();
			}
		}


		//启用用户
		public function startuser(){
			$shuju = $this->request->param();
			$id = empty($shuju['id']) ? '' : $shuju['id'];
			if ($id) {
				$status = Db::name('user')->where(array('id'=>$id))->value('user_status');
				if ($status == 0) {
					$isok = Db::name('user')->where(array('id'=>$id))->setField('user_status',1);
					if ($isok) {
						$data = array('status'=>1,'info'=>'已启用');
					} else {
						$data = array('status'=>0,'info'=>'启用失败！');
					}
				} else {
					$data = array('status'=>0,'info'=>'用户未验证或未启用！');
				}
			} else {
				$data = array('status'=>0,'info'=>'未找到用户！');
			}
			return json($data);
		}

		//停用用户
		public function stopuser(){
			$shuju = $this->request->param();
			$id = empty($shuju['id']) ? '' : $shuju['id'];
			if ($id) {
				$status = Db::name('user')->where(array('id'=>$id))->value('user_status');
				if ($status == 1) {
					$isok = Db::name('user')->where(array('id'=>$id))->setField('user_status',0);
					if ($isok) {
						$data = array('status'=>1,'info'=>'已停用');
					} else {
						$data = array('status'=>0,'info'=>'停用失败！');
					}
				} else {
					$data = array('status'=>0,'info'=>'用户未验证或未禁用！');
				}
			} else {
				$data = array('status'=>0,'info'=>'未找到用户！');
			}
			return json($data);
		}
		public function reset(){

			$data=input('post.');
			if(request()->isPost()){
				if($data['password']!=$data['repassword']){
					return 1; //两次密码不一致
				}else{
					$base=[
						'id'=>input('id'),
						'user_pass'=>cmf_password(input('password'))
					];
					if(db('user')->update($base)){
				        return 3; //修改成功
				      }else{
				       	return 2; //修改失败
				      }
				}
			}

			return $this->fetch();
		}
		public function add(){
			$data=input('post.');
			$time=time();
			$phone=input('phone');
			
			if(request()->isPost()){
					if(preg_match("/^1[345789]\d{9}$/", $phone)){
						$base=[
						'user_login'    =>input('username'),
						'mobile'        =>input('phone'),
						'user_pass'     =>cmf_password(input('password')),
						'user_nickname' =>input('nickname'),
						'user_type'     =>input('type'),
						'create_time' 	=>$time
					];
					if(db('user')->insert($base)){
						return 2; //添加成功
					}else{
						return 1; //添加失败
					}
				}else{
					return 3;
				}
				
			}
			return $this->fetch();
		}
		public function edit(){
			$id =input('id');
            $phone = input('phone');
            if(request()->isPost()){
                if(preg_match("/^1[34578]\d{9}$/", $phone)){
                    $base=[
                        'user_login'    =>input('username'),
                        'mobile'        =>input('phone'),
                        'user_nickname' =>input('nickname'),
                        'user_type'     =>input('type')
                    ];
                    if(db('user')->where(['id'=>$id])->update($base)){
                        return 2; //修改成功
                    }else{
                        return 1; //修改失败
                    }
                }else{
                    return 3;
                }
                
            }
			$vo=db('user')->find($id);
			$this->assign('vo',$vo);
			return $this->fetch();
		}
		
	}