<?php


namespace app\app\controller;


use app\model\Chapter;
use app\model\User;
use app\model\UserBuy;
use app\model\UserFinance;
use app\model\UserOrder;
use app\service\FinanceService;
use think\facade\Cache;
use think\Request;

class Finance extends BaseAuth
{
    protected $financeService;
    protected function initialize()
    {
        parent::initialize(); // TODO: Change the autogenerated stub
        $this->financeService = new FinanceService();

    }

    public function getBalance(){
        $balance = cache('balance:' . $this->uid); //当前用户余额
        if (!$balance) {
            $balance = $this->financeService->getBalance();
            cache('balance:' . $this->uid, $balance, '', 'pay');
        }

        $result = [
            'success' => 1,
            'balance' => $balance
        ];
        return json($result);
    }

    public function getCharges(){
        $charges = $this->financeService->getUserChargeHistory();
        return json(['success' => 1, 'charges' => $charges]);
    }

    public function getSpendings(){
        $spendings = $this->financeService->getUserSpendingHistory();
        return json(['success' => 1, 'spendings' => $spendings]);
    }

    //处理充值
    public function charge(Request $request)
    {
        $money = $request->post('money'); //用户充值金额
        $pay_type = $request->post('pay_type'); //充值渠道
        $order = new UserOrder();
        $order->user_id = $this->uid;
        $order->money = $money;
        $order->status = 0; //未完成订单
        $order->pay_type = 0;
        $order->expire_time = time() + 86400; //订单失效时间往后推一天
        $res = $order->save();
        if ($res) {
            $this->util->submit('xwx_order_' . $order->id, $money, $pay_type); //调用功能类，进行充值处理
        }
        return json(['success' => 1, 'msg' => '调用充值接口']);
    }

    public function buychapter(){
        $id = input('chapter_id');
        $chapter = Chapter::with(['photos' => function ($query) {
            $query->order('pic_order');
        }], 'book')->cache('chapter:' . $id, 600, 'redis')->find($id);
        $price = $chapter->book->money; //获得单章价格
        $redis = new_redis();
        if (!$redis->exists($this->redis_prefix . ':user_buy_lock:'.$this->uid)) { //如果没上锁，则该用户可以进行购买操作
            $balance = $this->financeService->getBalance(); //这里不查询缓存，直接查数据库更准确
            if ($price > $balance) { //如果价格高于用户余额，则不能购买
                return ['success' => 0, 'msg' => '余额不足'];
            } else {
                $userFinance = new UserFinance();
                $userFinance->user_id = $this->uid;
                $userFinance->money = $price;
                $userFinance->usage = 3;
                $userFinance->summary = '购买章节';
                $userFinance->save();

                $userBuy = new UserBuy();
                $userBuy->user_id = $this->uid;
                $userBuy->chapter_id = $id;
                $userBuy->book_id = $chapter->book_id;
                $userBuy->money = $price;
                $userBuy->summary = '购买章节';
                $userBuy->save();
            }
            $redis->set($this->redis_prefix . ':user_buy_lock:'.$this->uid, 1, 5);
            Cache::clear('pay'); //删除缓存
            return ['success' => 1, 'msg' => '购买成功，等待跳转'];
        } else {
            return ['success' => 0, 'msg' => '同账号非法操作'];
        }
    }

    public function vip(Request $request){
        $user = User::get($this->uid);
        $redis = new_redis();
        if (!$redis->exists($this->redis_prefix . ':user_buy_lock:'.$this->uid)) { //如果没上锁，则该用户可以进行购买操作
            $balance = $this->financeService->getBalance(); //这里不查询缓存，直接查数据库更准确
            $arr = config('payment.vip'); //拿到vip配置数组
            $month = (int)$request->param('month'); //拿到用户选择的vip
            foreach ($arr as $key => $value) {
                if ((int)$value['month'] == $month) {
                    if ((int)$value['price'] > $balance) { //如果vip价格大于用户余额
                        return ['success' => 0, 'msg' => '余额不足，请先充值'];
                    } else { //处理购买vip的订单
                        $finance = new UserFinance();
                        $finance->user_id = $this->uid;
                        $finance->money = (int)$value['price'];
                        $finance->usage = 2;
                        $finance->summary = '购买vip';
                        $finance->save();

                        $user->level = 1; //vip用户
                        if ($user->vip_expire_time < time()) { //说明vip已经过期
                            $user->vip_expire_time = time() + $month * 30 * 24 * 60 * 60;
                        } else { //vip没过期，则在现有vip时间上增加
                            $user->vip_expire_time = $user->vip_expire_time + $month * 30 * 24 * 60 * 60;
                        }
                        $user->isupdate(true)->save();
                        session('xwx_vip_expire_time',$user->vip_expire_time); //更新session
                        Cache::clear('pay'); //删除缓存
                        return ['success' => 1, 'msg' => '购买成功'];
                    }
                }
            }
            $redis->set($this->redis_prefix . ':user_buy_lock:'.$this->uid, 1, 5);
            return ['success' => 0, 'msg' => '请选择正确的选项']; //以防用户篡改页面的提交值
        } else {
            return ['success' => 0, 'msg' => '同账号非法操作'];
        }
    }
}