<?php

namespace app\index\controller;

use think\Controller;

class Login extends Controller {

    public function _initialize() {
        parent::_initialize(); // TODO: Change the autogenerated stub
        $config = config('config');
        if ($config['switch'] == 2) {
            $this->error($config['switchcontent']);
            exit;
        }
    }

    /*
     * 登录
     */

    public function index() {
        return $this->fetch();
    }

    /*
     * 注册
     */

    public function reg() {
        return $this->fetch();
    }

    /*
     * 登录验证
     */

    public function logchek() {
        $data = input('post.');
        $user_model = model('User');
        $user = $user_model->SetLogin($data['mobile'], $data['password']);
        if ($user) {
            $this->success('登录成功', url('index/index'));
        } else {
            $this->error('手机号未注册或密码不正确');
        }
    }

    /*
     * 注册验证
     */

    public function regdata() {
        $data = input('post.');
        $user_model = model('User');
        if (!session('source')) {
            $source = 0;
        } else {
            $source = session('source');
        }
        $reg = $user_model->SetReg($data['mobile'], $data['password'], $data['recode'], $source);
        if (!$reg) {
            $this->error('手机号已存在或验证码错误过期!');
        }
        $this->success('注册成功', url('login/index'));
    }

    /*
     * 注册验证推广
     */

    public function regdatas() {
        $appi = config('tuiguang');

        $data = input('post.');
        $user_model = model('User');
        if (!session('source')) {
            $source = 0;
        } else {
            $source = session('source');
        }
        $reg = $user_model->SetReg($data['mobile'], $data['password'], $data['recode'], $source);
        if (!$reg) {
            $this->error('手机号已存在或验证码错误过期!!');
        }

        $this->success('注册成功', $appi['and']);
    }

    /*
     * 注册/找回密码短信发送
     */

    public function smscode() {
        $smstid = input('get.tip');
        $user_model = model('User');
        if (!$user_model->incmobile(input('get.mobile'))) {
            $this->error('手机号已存在');
        }
        $sms_model = model('Smscode');
        $data = $sms_model->sendsms(input('get.mobile'), $smstid);
        if (!$data) {
            $this->error('发送失败');
        }
        $this->success('发送成功');
    }

    /*
     * 注册/找回密码短信发送
     */

    public function smscodes() {
        $smstid = input('get.tip');
        $user_model = model('User');
        if ($user_model->incmobile(input('get.mobile'))) {
            $this->error('手机号不存在');
        }
        $sms_model = model('Smscode');
        $data = $sms_model->sendsms(input('get.mobile'), $smstid);
        if (!$data) {
            $this->error('发送失败');
        }
        $this->success('发送成功');
    }

    /*
     * 找回密码
     */

    public function findpass() {

        return $this->fetch();
    }

    /*
     * 找回密码验证
     */

    public function isfind() {
        $user_model = model('User');
        if (!$user_model->SetFind(input('mobile'), input('pass'), input('recode'))) {
            $this->error('手机号不存在或验证码错误过期');
        }
        $this->success('修改成功');
    }

    /*
     * 推广页
     */

    public function register() {
        if (input('get.source')) {
            $data = db('source')->where('id', input('get.source'))->find();
            if (!$data) {
                $this->error('渠道错误，暂时无法注册');
            }
            session('source', input('get.source'));
        } else {
            $this->error('渠道错误，暂时无法注册');
        }

        db('getdata')->where('id', 1)->setInc('getip');
        return $this->fetch();
    }

    /*
     * 验证手机号是否存在
     */

    public function getmobile() {
        $data = model('User')->incmobile(input('mobile'));
        if ($data) {
            return true;
        } else {
            return false;
        }
    }

    /*
     * 前台退出登录
     */

    public function lout() {
        session('id', null);
        $this->success('安全退出', url('login/index'));
    }

}
