<?php 
/*
	template name: 投稿
	description: template for mobantu.com Monkey theme 
*/

get_header();
$options = get_option('monkey-options'); 
if(is_user_logged_in()){
	global $current_user; 
	get_currentuserinfo();
	$uid = $current_user->ID;
	$error = 0;
	if($_POST['action'] == 1){
		$title   =  $wpdb->escape($_POST['post_title']);
        $cat     =  $wpdb->escape($_POST['post_cat']);
        $content =  $wpdb->escape($_POST['post_content']);
		
		$last_post = $wpdb->get_var("SELECT post_date FROM $wpdb->posts WHERE post_author=".$uid." AND post_type = 'post' ORDER BY post_date DESC LIMIT 1");

        if ( time() - strtotime($last_post) < 120 ){
			$error = 1;
			$msg = '两次提交文章时间间隔太短，请稍候再来';  
        }
		
        elseif ( empty($title) || mb_strlen($title) > 50 ) {
            $error = 1;
			$msg = '标题不能为空，且小于50个字符';  
			
        }

        elseif ( empty($content) || mb_strlen($content) > 10000 || mb_strlen($content) < 50 ) {
			$error = 1;
			$msg = '文章内容不能为空，且介于50-10000字之间';  
			
        }
		else{
		
			$in_data = array(
				'post_title'   => $title,
				'post_author'  => $uid,
				'post_content' => $content,
				'post_status' => 'pending',
				'post_category' => array($cat)
			);
			
			$in_id = wp_insert_post( $in_data );
			
			if (!$in_id) { 
				$error = 1;
				$msg = '投稿失败，请稍后再试';  
			}else{
				$msg = '投稿成功，请等待审核';  
				wp_mail(get_bloginfo('admin_email'), '站长，有新投稿：'.$title, $content);
			}
		}
		
	}

}
?>
<link rel="stylesheet" href="<?php bloginfo("template_url")?>/static/css/user.css">
<div class="content main-content-wrap ng-scope">
  <div class="user-center-wrapper ng-scope">
    <div class="container">
      <div class="create-company-wrap">
      	<header class="create-company-header">
        	<h1 class="form-title text-center"><?php the_title();?></h1>
            <p> <?php echo $options['tougao'];?></p>
        </header>
        <div class="create-company-form">
          <form class="form-horizontal" role="form" name="createForm" method="post">
            <div class="form-group">
              <label class="label-control"><span class="required">* </span>标题</label>
              <div class="col col-5 ng-scope">
                <input type="text" name="post_title" tabindex="-1" class="form-control ui-select-search ng-pristine ng-untouched ng-valid ng-hide" required="" placeholder="请填写标题" value="" <?php if(!is_user_logged_in()) echo 'disabled="disabled"';?>>
              </div>
            </div>
            <?php if(is_user_logged_in()){ ?>
            <div class="form-group">
              <label class="label-control"><span class="required">* </span>分类</label>
              <div class="col col-2">
                <?php 
				$categorys = get_terms( 'category', array('hide_empty' => false, 'parent' => '0','child_of'=> 0, 'meta_query'=>array(array('key'=>'tougao','value'=>'1')) ) );
				if ( ! empty( $categorys ) && ! is_wp_error( $categorys ) ){
					echo '<select name="post_cat" id="post_cat" class="postform">';
					foreach ( $categorys as $term ) {
						echo '<option class="level-0" value="'.$term->term_id.'">'.$term->name.'</option>';
					}
					echo '</select>';
				}
				?>
              </div>
            </div>
            <?php }?>
            <div class="form-group">
              <label class="label-control"><span class="required">* </span>正文</label>
              <div class="col col-5">
                <textarea name="post_content" class="form-control texarea-brief ng-pristine ng-untouched ng-scope ng-invalid ng-invalid-required" id="post_content" cols="30" rows="15" required="" placeholder="请填写正文" <?php if(!is_user_logged_in()) echo 'disabled="disabled"';?>></textarea>
              </div>
            </div>
            <div class="form-group btn-panel ng-scope">
              <div class="col col-offset-1">
                <input type="hidden" name="action" value="1">
                <?php if(is_user_logged_in()){ ?><button type="submit" class="btn btn-primary apply-btn">提交稿件</button><?php }else{?>
                	请先 <a href="javascript:;" class="user-login login-link">登录</a> 后投稿！
                <?php }?>
                <div class="create-tips" style=" <?php if($error == 1) echo 'color:red'; else echo 'color:green';?>"><?php echo $msg;?></div>
              </div>
            </div>
          </form>
        </div>
        
      </div>
    </div>
  </div>
</div>
<?php get_footer();?>
