<?php
!function_exists('readover') && exit('Forbidden');

function debatesort_cache(){
	global $db;
	$dedb = $replydb = array();
	$query = $db->query("SELECT uid,author,posts FROM pw_debateinfo ORDER BY posts DESC LIMIT 10");
	while ($rt = $db->fetch_array($query)) {
		$dedb[] = $rt;
	}
	$query = $db->query("SELECT uid,author,replys FROM pw_debateinfo WHERE replys>0 ORDER BY replys DESC LIMIT 10");
	while ($rt = $db->fetch_array($query)) {
		$replydb[] = $rt;
	}
	$db->free_result($query);
	writeover(D_P.'data/bbscache/debatesort_cache.php',"<?php\r\n\$dedb=".vvar_export($dedb).";\r\n\$replydb=".vvar_export($replydb).";\r\n?>");
}
function debateindex_cache(){
	$newdebatedb = $hotdebatedb = array();
	if (!is_array(($newdebatedb = dtsarray('dateline')))) {
		$newdebatedb = array();
	}
	if (!is_array(($hotdebatedb = dtsarray('views')))) {
		$hotdebatedb = array();
	}
	writeover(D_P.'data/bbscache/debateindex_cache.php',"<?php\r\n\$newdebatedb=".vvar_export($newdebatedb).";\r\n\$hotdebatedb=".vvar_export($hotdebatedb).";\r\n?>");
}
function dtsarray($orderby,$limit=10,$sortid=null){
	global $db,$debateclassdb;
	$configdb = array();
	$where = '>0';
	if ((int)$sortid > 0) $where = "='$sortid'";
	$query = $db->query("SELECT did,title,author,authorid,dateline,content,digest,obvote,revote,views,sortid,obtitle,retitle FROM pw_debatethreads WHERE sortid$where AND isvisible=1 ORDER BY $orderby DESC LIMIT $limit");
	while($rt = $db->fetch_array($query)){
		$rt['dateline']   = get_date($rt['dateline'],'Y-m-d');
		$rt['content']	  = substrs($rt['content'],232);
		$summvote		  = $rt['obvote'] + $rt['revote'];
		$rt['obimgwidth'] = floor(80*$rt['obvote']/($summvote+1));
		$rt['reimgwidth'] = floor(80*$rt['revote']/($summvote+1));
		$rt['sortid']	  = $debateclassdb[$rt['sortid']];
		$rt['obtitle']	  = substrs($rt['obtitle'],34);
		$rt['retitle']	  = substrs($rt['retitle'],34);
		$configdb[] = $rt;
	}
	$db->free_result($query);
	return $configdb;
}
function vvar_export($input,$f = 1,$t = null){
	$output = '';
	if(is_array($input)){
		$output .= "array(\r\n";
		foreach($input as $key => $value){
			$output .= $t."\t".vvar_export($key,$f,$t."\t").' => '.vvar_export($value,$f,$t."\t");
			$output .= ",\r\n";
		}
		$output .= $t.')';
	} elseif(is_string($input)){
		$output .= $f ? "'".str_replace(array("\\","'"),array("\\\\","\'"),$input)."'" : "'$input'";
	} elseif(is_int($input) || is_double($input)){
		$output .= "'".(string)$input."'";
	} elseif(is_bool($input)){
		$output .= $input ? 'true' : 'false';
	} else{
		$output .= 'NULL';
	}
	return $output;
}
?>