<?php
!function_exists('readover') && exit('Forbidden');

function ImgWaterMark($source,$w_pos=0,$w_img='',$w_text='',$w_font=5,$w_color='#FF0000',$w_pct,$w_quality){
	global $imgdir;
	$sourcedb = $waterdb = array();
	if (!($sourcedb = GetImgInfo($source))) {
		return false;
	}
	$ifWaterImage = 1;
	if (!($waterdb = GetImgInfo("$imgdir/water/$w_img"))) {
		if (!$w_text) return false;
		$ifWaterImage = 0;
		$temp = imagettfbbox(ceil($w_font*2.5),0,'./cour.ttf',$w_text);//ȡʹ TrueType ıķΧ
		$waterdb['width'] = $temp[2] - $temp[6];
		$waterdb['height'] = $temp[3] - $temp[7];
		unset($temp);
	}
	if ($w_pos == 0) {
		$wX = rand(0,($sourcedb['width'] - $waterdb['width']));
		$wY = rand(0,($sourcedb['height'] - $waterdb['height']));
	} elseif ($w_pos == 1) {
		$wX = $wY = 5;
	} elseif ($w_pos == 2) {
		$wX = ($sourcedb['width'] - $waterdb['width']) / 2;
		$wY = 0;
	} elseif ($w_pos == 3) {
		$wX = $sourcedb['width'] - $waterdb['width'];
		$wY = 0;
	} elseif ($w_pos == 4) {
		$wX = 0;
		$wY = $sourcedb['height'] - $waterdb['height'];
	} elseif ($w_pos == 5) {
		$wX = ($sourcedb['width'] - $waterdb['width']) / 2;
		$wY = $sourcedb['height'] - $waterdb['height'];
	} elseif ($w_pos == 6) {
		$wX = $sourcedb['width'] - $waterdb['width'];
		$wY = $sourcedb['height'] - $waterdb['height'];
	} else {
		$wX = ($sourcedb['width'] - $waterdb['width'])/2;
		$wY = ($sourcedb['height'] - $waterdb['height'])/2;
	}
	imagealphablending($sourcedb['source'],true);
	if ($ifWaterImage) {
		imagecopymerge($sourcedb['source'],$waterdb['source'],$wX,$wY,0,0,$waterdb['width'],$waterdb['height'],$w_pct);
	} else {
		if (strlen($w_color)!=7) return false;
		$R = hexdec(substr($w_color,1,2));
		$G = hexdec(substr($w_color,3,2));
		$B = hexdec(substr($w_color,5));
		imagestring($sourcedb['source'],$w_font,$wX,$wY,$w_text,imagecolorallocate($sourcedb['source'],$R,$G,$B));
	}
//	P_unlink($source);
	MakeImage($sourcedb['type'],$sourcedb['source'],$source,$w_quality);
	isset($waterdb['source']) && imagedestroy($waterdb['source']);
	imagedestroy($sourcedb['source']);
}
function MakeThumb($srcFile,&$dstFile,$dstW,$dstH,$cenTer = null,$sameFile = null){
	if (!$dstW && $dstH) {
		$dstW = $dstH;
	} elseif (!$dstH && $dstW) {
		$dstH = $dstW;
	} elseif (!$dstH && !$dstW) {
		return false;
	}
	$minitemp = GetThumbInfo($srcFile,$dstW,$dstH,$cenTer);
	list($imagecreate,$imagecopyre) = GetImagecreate($minitemp['type']);
	if ((empty($sameFile) && $dstFile === $srcFile) || empty($minitemp) || !$imagecreate) return false;
	!empty($sameFile) && $dstFile = $srcFile;
	$imgwidth  = $minitemp['width'];
	$imgheight = $minitemp['height'];
	$srcX = $srcY = 0;
	if (!empty($cenTer)) {
		if ($imgwidth < $imgheight) {
			$srcY = round(($imgheight - $imgwidth)/2);
			$imgheight = $imgwidth;
		} else {
			$srcX = round(($imgwidth - $imgheight)/2);
			$imgwidth = $imgheight;
		}
	}
	$dstX = $dstY = 0;
	$thumb = $imagecreate($minitemp['dstW'],$minitemp['dstH']);
	$imagecopyre($thumb,$minitemp['source'],$dstX,$dstY,$srcX,$srcY,$minitemp['dstW'],$minitemp['dstH'],$imgwidth,$imgheight);
	MakeImage($minitemp['type'],$thumb,$dstFile);
	imagedestroy($thumb);
	return array($minitemp['dstW'],$minitemp['dstH']);
}
function GetThumbInfo($srcFile,$dstW,$dstH,$cenTer = null){
	$imgdata = array();
	$imgdata = GetImgInfo($srcFile);
	if (empty($imgdata) || ($imgdata['width']<=$dstW && $imgdata['height']<=$dstH)) return false;
	if (($imgdata['width']/$dstW) < ($imgdata['height']/$dstH)) {
		if (!empty($cenTer)) {
			$imgdata['dstW'] = $imgdata['dstH'] = $dstH;
		} else {
			$imgdata['dstW'] = round($dstH/$imgdata['height']*$imgdata['width']);
			$imgdata['dstH'] = $dstH;
		}
	} else {
		if (!empty($cenTer)) {
			$imgdata['dstW'] = $imgdata['dstH'] = $dstW;
		} else {
			$imgdata['dstW'] = $dstW;
			$imgdata['dstH'] = round($dstW/$imgdata['width']*$imgdata['height']);
		}
	}
	return $imgdata;
}
function GetImgInfo($srcFile){
	$imgdata = array();
	$imgdata = GetImgSize($srcFile);
	if (!empty($imgdata) && function_exists('imagecreatefrom'.$imgdata['type'])) {
		$imagecreatefromtype = 'imagecreatefrom'.$imgdata['type'];
	} else {
		$imagecreatefromtype = '';
	}
	if (empty($imgdata) || !$imagecreatefromtype) return false;
	$imgdata['source']	  = $imagecreatefromtype($srcFile);
	!$imgdata['width'] && $imgdata['width'] = imagesx($imgdata['source']);
	!$imgdata['height'] && $imgdata['height'] = imagesy($imgdata['source']);
	return $imgdata;
}
function MakeImage($type,$image,$filename,$quality='75'){
	if (!function_exists('image'.$type)) {
		return false;
	}
	$makeimage = 'image'.$type;
	if ($type == 'jpeg') {
		$makeimage($image,$filename,$quality);
	} else {
		$makeimage($image,$filename);
	}
}
function GetImgSize($srcFile,$srcExt = null){
	empty($srcExt) && $srcExt = strtolower(substr(strrchr($srcFile,'.'),1));
	$srcdata = array();
	if (function_exists('read_exif_data') && in_array($srcExt,array('jpg','jpeg','jpe','jfif'))) {
		$datatemp = @read_exif_data($srcFile);
		$srcdata['width'] = $datatemp['COMPUTED']['Width'];
		$srcdata['height'] = $datatemp['COMPUTED']['Height'];
		$srcdata['type'] = 2;
		unset($datatemp);
	}
	!$srcdata['width'] && list($srcdata['width'],$srcdata['height'],$srcdata['type']) = @getimagesize($srcFile);
	$srcdata['type'] = CheckImagetype($srcdata['type']);
	if (empty($srcdata) || !$srcdata['type']) {
		return false;
	}
	return $srcdata;
}
function CheckImagetype($imagetype){
	if ($imagetype==1) {
		$type = 'gif';
	} elseif ($imagetype==2) {
		$type = 'jpeg';
	} elseif ($imagetype==3) {
		$type = 'png';
	} else {
		return false;
	}
	return $type;
}
function GetImagecreate($imagetype){
	if ($imagetype != 'gif' && function_exists('imagecreatetruecolor') && function_exists('imagecopyresampled')) {
		return array('imagecreatetruecolor','imagecopyresampled');
	} elseif (function_exists('imagecreate') && function_exists('imagecopyresized')) {
		return array('imagecreate','imagecopyresized');
	} else {
		return array();
	}
}
?>