<?php
/**
 * Copyright (c) 2003-07  PHPWind.net. All rights reserved.
 * 
 * @filename: makethumb.php
 * @author: Noizy (noizyfeng@gmail.com)
 * @modify: Fri Feb 02 20:33:44 CST 2007
 */
!function_exists('readover') && exit('Forbidden');

function MakeThumb($srcFile,$dstFile,$dstW,$dstH,$cenTer = null,$sameFile = null){
	if (!$dstW && $dstH) {
		$dstW = $dstH;
	} elseif (!$dstH && $dstW) {
		$dstH = $dstW;
	} elseif (!$dstH && !$dstW) {
		return false;
	}
	$minitemp = GetImgInfo($srcFile,$dstW,$dstH,$cenTer);
	list($imagecreate,$imagecopyre) = GetImagecreate($minitemp['type']);
	if ((empty($sameFile) && $dstFile === $srcFile) || empty($minitemp) || !$imagecreate) return false;
	!empty($sameFile) && $dstFile = $srcFile;
	$imgwidth  = $minitemp['srcW'];
	$imgheight = $minitemp['srcH'];
	$srcX = $srcY = 0;
	if (!empty($cenTer)) {
		if ($imgwidth < $imgheight) {
			$srcY = round(($imgheight - $imgwidth)/2);
			$imgheight = $imgwidth;
		} else {
			$srcX = round(($imgwidth - $imgheight)/2);
			$imgwidth = $imgheight;
		}
	}
	$dstX = $dstY = 0;
	$thumb = $imagecreate($minitemp['dstW'],$minitemp['dstH']);
	$imagecopyre($thumb,$minitemp['source'],$dstX,$dstY,$srcX,$srcY,$minitemp['dstW'],$minitemp['dstH'],$imgwidth,$imgheight);
	$minitemp['makeimage']($thumb,$dstFile);
	imagedestroy($thumb);
	return array($minitemp['dstW'],$minitemp['dstH']);
}
function GetImgInfo($srcFile,$dstW,$dstH,$cenTer = null){
	$iext = strtolower(substr(strrchr($srcFile,'.'),1));
	$data = $imgdata = array();
	$imgdata = GetImgSize($srcFile);
	$type = $imagecreatefromtype = $imagetype = '';
	if (!empty($imgdata)) {
		$type = CheckImagetype($imgdata['type']);
		$imagecreatefromtype = function_exists('imagecreatefrom'.$type) ? 'imagecreatefrom'.$type : '';
		$imagetype = function_exists('image'.$type) ? 'image'.$type : '';
	}
	if (empty($imgdata) || !$type || !$imagecreatefromtype || !$imagetype) return false;
	$imgdata['source']	  = $imagecreatefromtype($srcFile);
	$imgdata['makeimage'] = $imagetype;
	$imgdata['srcW'] = $imgdata['width'];
	$imgdata['srcH'] = $imgdata['height'];
	unset($imgdata['width'],$imgdata['height']);
	if (!$imgdata['srcW'] || !$imgdata['srcH']) {
		$imgdata['srcW'] = imagesx($imgdata['source']);
		$imgdata['srcH'] = imagesy($imgdata['source']);
	}
	if ($imgdata['srcW']<=$dstW && $imgdata['srcH']<=$dstH) return false;
	if (($imgdata['srcW']/$dstW) < ($imgdata['srcH']/$dstH)) {
		if (!empty($cenTer)) {
			$imgdata['dstW'] = $imgdata['dstH'] = $dstH;
		} else {
			$imgdata['dstW'] = round($dstH/$imgdata['srcH']*$imgdata['srcW']);
			$imgdata['dstH'] = $dstH;
		}
	} else {
		if (!empty($cenTer)) {
			$imgdata['dstW'] = $imgdata['dstH'] = $dstW;
		} else {
			$imgdata['dstW'] = $dstW;
			$imgdata['dstH'] = round($dstW/$imgdata['srcW']*$imgdata['srcH']);
		}
	}
	return $imgdata;
}
function CheckImagetype($imagetype){
	if ($imagetype==1) {
		$type = 'gif';
	} elseif ($imagetype==2) {
		$type = 'jpeg';
	} elseif ($imagetype==3) {
		$type = 'png';
	} else {
		return false;
	}
	return $type;
}
function GetImagecreate($imagetype){
	if ($imagetype != 1 && function_exists('imagecreatetruecolor') && function_exists('imagecopyresampled')) {
		return array('imagecreatetruecolor','imagecopyresampled');
	} elseif (function_exists('imagecreate') && function_exists('imagecopyresized')) {
		return array('imagecreate','imagecopyresized');
	} else {
		return array();
	}
}
function GetImgSize($srcFile,$srcExt = null){
	empty($srcExt) && $srcExt = strtolower(substr(strrchr($srcFile,'.'),1));
	$srcdata = array();
	if (function_exists('read_exif_data') && ($srcExt=='jpg' || $srcExt=='jpeg' || $srcExt=='jpe' || $srcExt=='jfif')) {
		$datatemp = @read_exif_data($srcFile);
		$srcdata['width'] = $datatemp['COMPUTED']['Width'];
		$srcdata['height'] = $datatemp['COMPUTED']['Height'];
		$srcdata['type'] = 2;
		unset($datatemp);
	}
	!$srcdata['width'] && list($srcdata['width'],$srcdata['height'],$srcdata['type']) = getimagesize($srcFile);
	empty($srcdata) && $srcdata = false;
	return $srcdata;
}
?>