DROP TABLE IF EXISTS p8_ad;
CREATE TABLE p8_ad (
  id mediumint(7) NOT NULL auto_increment,
  keywords varchar(50) NOT NULL default '',
  name varchar(100) NOT NULL default '',
  type varchar(30) NOT NULL default '0',
  isclose tinyint(1) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  adcode text NOT NULL,
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  money mediumint(6) NOT NULL default '0',
  moneycard mediumint(6) NOT NULL default '0',
  ifsale tinyint(1) NOT NULL default '0',
  autoyz tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_ad_user;
CREATE TABLE p8_ad_user (
  u_id mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  u_uid mediumint(7) NOT NULL default '0',
  u_username varchar(30) NOT NULL default '',
  u_day smallint(4) NOT NULL default '0',
  u_begintime int(10) NOT NULL default '0',
  u_endtime int(10) NOT NULL default '0',
  u_hits mediumint(7) NOT NULL default '0',
  u_yz tinyint(1) NOT NULL default '0',
  u_code text NOT NULL,
  u_money mediumint(7) NOT NULL default '0',
  u_moneycard mediumint(7) NOT NULL default '0',
  u_posttime int(10) NOT NULL default '0',
  PRIMARY KEY  (u_id),
  KEY u_endtime (u_endtime)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_alonepage;
CREATE TABLE p8_alonepage (
  id mediumint(5) NOT NULL auto_increment,
  fid mediumint(5) NOT NULL default '0',
  name varchar(100) NOT NULL default '',
  title varchar(100) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  tpl_head varchar(50) NOT NULL default '',
  tpl_main varchar(50) NOT NULL default '',
  tpl_foot varchar(50) NOT NULL default '',
  filename varchar(100) default NULL,
  filepath varchar(30) NOT NULL default '',
  descrip text NOT NULL,
  keywords varchar(255) NOT NULL default '',
  content text NOT NULL,
  hits int(7) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_area;
CREATE TABLE p8_area (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_article;
CREATE TABLE p8_article (
  aid mediumint(7) unsigned NOT NULL auto_increment,
  title varchar(150) NOT NULL default '',
  smalltitle varchar(100) NOT NULL default '',
  fid mediumint(7) unsigned NOT NULL default '0',
  mid mediumint(5) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  special_id mediumint(7) NOT NULL default '0',
  bak_id mediumint(7) NOT NULL default '0',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  pages smallint(4) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  author varchar(30) NOT NULL default '',
  copyfrom varchar(100) NOT NULL default '',
  copyfromurl varchar(150) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  titleicon smallint(3) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '0',
  ispic tinyint(1) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  template varchar(255) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  buyuser text NOT NULL,
  passwd varchar(32) NOT NULL default '',
  allowdown varchar(150) NOT NULL default '',
  allowview varchar(150) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  description text NOT NULL,
  lastview int(10) NOT NULL default '0',
  digg_num mediumint(7) NOT NULL default '0',
  digg_time int(10) NOT NULL default '0',
  PRIMARY KEY  (aid),
  KEY fid (fid),
  KEY hits (hits,yz,fid,ispic),
  KEY lastview (yz,lastview,fid,ispic),
  KEY list (list,yz,fid,ispic),
  KEY ispic (ispic),
  KEY uid (uid),
  KEY levels (levels),
  KEY digg_num (digg_num),
  KEY digg_time (digg_time)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_article_content_1;
CREATE TABLE p8_article_content_1 (
  id mediumint(7) NOT NULL auto_increment,
  aid mediumint(7) NOT NULL default '0',
  rid mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  my_about mediumtext NOT NULL,
  my_price varchar(15) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY fid (fid),
  KEY uid (uid),
  KEY aid (aid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_article_module;
CREATE TABLE p8_article_module (
  id smallint(4) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  list smallint(4) NOT NULL default '0',
  allowpost varchar(255) NOT NULL default '',
  style varchar(30) NOT NULL default '',
  template varchar(255) NOT NULL default '',
  config mediumtext NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_bak;
CREATE TABLE p8_bak (
  bak_id mediumint(4) NOT NULL auto_increment,
  bak_dir varchar(255) NOT NULL default '',
  bak_txt mediumtext NOT NULL,
  PRIMARY KEY  (bak_id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_area;
CREATE TABLE p8_blog_area (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_class;
CREATE TABLE p8_blog_class (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_comments;
CREATE TABLE p8_blog_comments (
  cid mediumint(7) unsigned NOT NULL auto_increment,
  cuid int(7) NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  id mediumint(7) unsigned NOT NULL default '0',
  fid mediumint(7) unsigned NOT NULL default '0',
  uid mediumint(7) unsigned NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  content text NOT NULL,
  ip varchar(15) NOT NULL default '',
  icon tinyint(3) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  reply text NOT NULL,
  PRIMARY KEY  (cid),
  KEY type (type)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_config;
CREATE TABLE p8_blog_config (
  uid int(7) NOT NULL default '0',
  catid tinyint(2) NOT NULL default '0',
  provinceid mediumint(5) NOT NULL default '0',
  province varchar(30) NOT NULL default '',
  cityid mediumint(5) NOT NULL default '0',
  city varchar(30) NOT NULL default '',
  webname varchar(50) NOT NULL default '',
  domain varchar(50) NOT NULL default '',
  isopen tinyint(1) NOT NULL default '1',
  module text NOT NULL,
  layout tinyint(3) NOT NULL default '0',
  webwidth varchar(15) NOT NULL default '',
  rollmsg text NOT NULL,
  intro text NOT NULL,
  logo varchar(150) NOT NULL default '',
  navigation text NOT NULL,
  slogan varchar(50) NOT NULL default '',
  css text NOT NULL,
  diycss text NOT NULL,
  style varchar(15) NOT NULL default '',
  flash smallint(4) NOT NULL default '0',
  module_rows text NOT NULL,
  module_order text NOT NULL,
  module_desc text NOT NULL,
  module_tag text NOT NULL,
  file_module text NOT NULL,
  module_name text NOT NULL,
  module_view text NOT NULL,
  copyright varchar(255) NOT NULL default '',
  comment_type tinyint(1) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  lastview int(10) NOT NULL default '0',
  iscom tinyint(1) NOT NULL default '0',
  levels int(10) NOT NULL default '0',
  content_leng mediumint(5) NOT NULL default '0',
  visitor text NOT NULL,
  comments mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (uid),
  KEY webname (webname),
  KEY province (province,city),
  KEY hits (hits),
  KEY lastview (lastview),
  KEY iscom (iscom,levels),
  KEY cityid (cityid),
  KEY provinceid (provinceid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_friend;
CREATE TABLE p8_blog_friend (
  id mediumint(7) NOT NULL auto_increment,
  cuid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime mediumint(10) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY cuid (cuid),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_friendlink;
CREATE TABLE p8_blog_friendlink (
  id mediumint(7) NOT NULL auto_increment,
  uid mediumint(7) NOT NULL default '0',
  name varchar(30) NOT NULL default '',
  url varchar(150) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip varchar(255) NOT NULL default '',
  list int(10) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_guestbook;
CREATE TABLE p8_blog_guestbook (
  id int(7) NOT NULL auto_increment,
  cuid mediumint(7) NOT NULL default '0',
  ico tinyint(2) NOT NULL default '0',
  email varchar(50) NOT NULL default '',
  oicq varchar(11) default NULL,
  weburl varchar(150) NOT NULL default '',
  blogurl varchar(150) NOT NULL default '',
  uid int(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  ip varchar(15) NOT NULL default '',
  content text NOT NULL,
  yz tinyint(1) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_log_album;
CREATE TABLE p8_blog_log_album (
  id mediumint(7) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_log_article;
CREATE TABLE p8_blog_log_article (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(150) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  ispic tinyint(1) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  download text NOT NULL,
  content text NOT NULL,
  config text NOT NULL,
  lastview int(10) NOT NULL default '0',
  viewtype tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY uid (uid),
  KEY fid (fid,list),
  KEY yz (yz),
  KEY lastview (lastview),
  KEY hits (hits),
  KEY list (list,uid),
  KEY levels (levels)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_log_sort;
CREATE TABLE p8_blog_log_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  maxperpage tinyint(3) NOT NULL default '0',
  logo varchar(150) NOT NULL default '',
  passwd varchar(32) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  index_show tinyint(1) NOT NULL default '1',
  config text NOT NULL,
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_music_album;
CREATE TABLE p8_blog_music_album (
  id mediumint(7) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_music_song;
CREATE TABLE p8_blog_music_song (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(50) NOT NULL default '',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) default NULL,
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  ispic tinyint(1) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  songurl varchar(150) NOT NULL default '',
  content text NOT NULL,
  singer varchar(50) NOT NULL default '',
  config text NOT NULL,
  lastview int(10) NOT NULL default '0',
  viewtype tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY singer (singer),
  KEY yz (yz),
  KEY lastview (lastview,fid),
  KEY posttime (posttime,fid),
  KEY levels (levels,levelstime,fid),
  KEY title (title),
  KEY fid (fid),
  KEY hits (hits,fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_music_sort;
CREATE TABLE p8_blog_music_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  maxperpage tinyint(3) NOT NULL default '0',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  passwd varchar(32) NOT NULL default '',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_mv_album;
CREATE TABLE p8_blog_mv_album (
  id mediumint(7) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_mv_sort;
CREATE TABLE p8_blog_mv_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  index_show tinyint(1) NOT NULL default '0',
  list_html varchar(255) NOT NULL default '',
  bencandy_html varchar(255) NOT NULL default '',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_mv_video;
CREATE TABLE p8_blog_mv_video (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) default NULL,
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  author varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  ispic tinyint(1) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  buyuser text NOT NULL,
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  content text NOT NULL,
  videourl text NOT NULL,
  isflv tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  lastview int(10) NOT NULL default '0',
  forbidshow tinyint(1) NOT NULL default '0',
  playtype enum('auto','avi','rm','swf','flv','mp3') NOT NULL default 'auto',
  viewtype tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY yz (yz),
  KEY fid (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_photo_album;
CREATE TABLE p8_blog_photo_album (
  id mediumint(7) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_photo_pic;
CREATE TABLE p8_blog_photo_pic (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  content text NOT NULL,
  photo text,
  lastview int(10) NOT NULL default '0',
  config text NOT NULL,
  forbidshow tinyint(1) NOT NULL default '0',
  author varchar(30) NOT NULL default '',
  viewtype tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY uid (uid),
  KEY fid (fid,list),
  KEY yz (yz),
  KEY lastview (lastview),
  KEY hits (hits),
  KEY list (list,uid),
  KEY levels (levels,levelstime)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_photo_sort;
CREATE TABLE p8_blog_photo_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  index_show tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_blog_setting;
CREATE TABLE p8_blog_setting (
  c_key varchar(50) NOT NULL default '',
  c_value text NOT NULL,
  c_descrip text NOT NULL,
  PRIMARY KEY  (c_key)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_channel;
CREATE TABLE p8_channel (
  id smallint(4) NOT NULL auto_increment,
  type tinyint(2) NOT NULL default '0',
  sort smallint(4) NOT NULL default '0',
  name varchar(30) NOT NULL default '',
  path varchar(30) NOT NULL default '',
  phpname varchar(255) NOT NULL default '',
  htmlname varchar(255) NOT NULL default '',
  fids varchar(255) NOT NULL default '',
  showfid varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(255) NOT NULL default '',
  main_tpl varchar(255) NOT NULL default '',
  foot_tpl varchar(255) NOT NULL default '',
  url varchar(150) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  admin varchar(150) NOT NULL default '',
  list int(10) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_collection;
CREATE TABLE p8_collection (
  id mediumint(7) NOT NULL auto_increment,
  aid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_comment;
CREATE TABLE p8_comment (
  cid mediumint(7) unsigned NOT NULL auto_increment,
  aid mediumint(7) unsigned NOT NULL default '0',
  fid mediumint(7) unsigned NOT NULL default '0',
  uid mediumint(7) unsigned NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  content text NOT NULL,
  ip varchar(15) NOT NULL default '',
  icon tinyint(3) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (cid),
  KEY aid (aid),
  KEY fid (fid),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_config;
CREATE TABLE p8_config (
  c_key varchar(50) NOT NULL default '',
  c_value text NOT NULL,
  c_descrip text NOT NULL,
  PRIMARY KEY  (c_key)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_copyfrom;
CREATE TABLE p8_copyfrom (
  id mediumint(5) NOT NULL auto_increment,
  name varchar(40) NOT NULL default '',
  list int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY keywords (name)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_count_site;
CREATE TABLE p8_count_site (
  fid mediumint(7) NOT NULL auto_increment,
  fup mediumint(7) NOT NULL default '0',
  name varchar(100) NOT NULL default '',
  list mediumint(5) NOT NULL default '0',
  ifclose tinyint(1) NOT NULL default '0',
  count_num mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_count_stat;
CREATE TABLE p8_count_stat (
  id mediumint(7) NOT NULL auto_increment,
  fid mediumint(7) NOT NULL default '0',
  year mediumint(4) NOT NULL default '0',
  month tinyint(2) NOT NULL default '0',
  week tinyint(2) NOT NULL default '0',
  day smallint(3) NOT NULL default '0',
  hour tinyint(2) NOT NULL default '0',
  pv mediumint(7) NOT NULL default '0',
  uv mediumint(7) NOT NULL default '0',
  ip mediumint(7) NOT NULL default '0',
  windows_type text NOT NULL,
  ie_type text NOT NULL,
  windows_lang text NOT NULL,
  screen_size text NOT NULL,
  from_domain text NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_count_user;
CREATE TABLE p8_count_user (
  id int(10) NOT NULL auto_increment,
  fid mediumint(7) NOT NULL default '0',
  time_day tinyint(2) NOT NULL default '0',
  username varchar(32) NOT NULL default '',
  lasttime int(10) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  ip_address varchar(50) NOT NULL default '',
  fromurl varchar(255) NOT NULL default '',
  weburl varchar(150) NOT NULL default '',
  lasturl varchar(150) NOT NULL default '',
  windows_type varchar(30) NOT NULL default '',
  ie_type varchar(30) NOT NULL default '',
  windows_lang varchar(30) NOT NULL default '',
  screen_size varchar(30) NOT NULL default '',
  hits mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY username (username),
  KEY time_day (time_day,ip)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_down_comments;
CREATE TABLE p8_down_comments (
  cid mediumint(7) unsigned NOT NULL auto_increment,
  cuid int(7) NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  id mediumint(7) unsigned NOT NULL default '0',
  fid mediumint(7) unsigned NOT NULL default '0',
  uid mediumint(7) unsigned NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  content text NOT NULL,
  ip varchar(15) NOT NULL default '',
  icon tinyint(3) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (cid),
  KEY type (type)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_down_config;
CREATE TABLE p8_down_config (
  c_key varchar(50) NOT NULL default '',
  c_value text NOT NULL,
  c_descrip text NOT NULL,
  PRIMARY KEY  (c_key)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_down_gather_rule;
CREATE TABLE p8_down_gather_rule (
  id mediumint(7) NOT NULL auto_increment,
  type varchar(15) NOT NULL default '0',
  fixsystem varchar(30) NOT NULL default '',
  filetype varchar(50) NOT NULL default '',
  webname varchar(150) NOT NULL default '',
  listurl varchar(150) NOT NULL default '',
  firstpage varchar(150) NOT NULL default '',
  page_begin int(10) NOT NULL default '0',
  page_end int(10) NOT NULL default '0',
  page_step int(10) NOT NULL default '0',
  title_minleng smallint(5) NOT NULL default '0',
  listmoreurl text NOT NULL,
  link_include_word text NOT NULL,
  link_noinclude_word text NOT NULL,
  link_replace_word text NOT NULL,
  title_replace_word text NOT NULL,
  list_begin_code text NOT NULL,
  list_end_code text NOT NULL,
  list_begin_preg text NOT NULL,
  list_end_preg text NOT NULL,
  gatherthesame tinyint(1) NOT NULL default '0',
  show_begin_preg text NOT NULL,
  show_end_preg text NOT NULL,
  show_endfile_preg text NOT NULL,
  show_begin_code text NOT NULL,
  show_end_code text NOT NULL,
  show_replace_word text NOT NULL,
  show_morepage varchar(100) NOT NULL default '',
  show_firstpage varchar(100) NOT NULL default '',
  show_spe2page tinyint(1) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  copypic tinyint(1) NOT NULL default '0',
  sort smallint(4) NOT NULL default '0',
  file_type varchar(50) NOT NULL default '',
  file_minleng mediumint(6) NOT NULL default '0',
  file_minsize int(9) NOT NULL default '0',
  file_includeword text NOT NULL,
  file_noincludeword text NOT NULL,
  file_explode text NOT NULL,
  file_picwidth int(8) NOT NULL default '0',
  file_star_string varchar(150) NOT NULL default '',
  title_rule text NOT NULL,
  content_rule text NOT NULL,
  title_morepage_rull text NOT NULL,
  content_morepage_rull text NOT NULL,
  charset_type tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_down_software;
CREATE TABLE p8_down_software (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  ispic tinyint(1) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  buyuser text NOT NULL,
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  download text NOT NULL,
  description text NOT NULL,
  content text NOT NULL,
  author varchar(30) NOT NULL default '',
  downloadurl text NOT NULL,
  softsize varchar(20) NOT NULL default '',
  softversion varchar(50) NOT NULL default '',
  copyfrom varchar(150) NOT NULL default '',
  copyfromurl varchar(150) NOT NULL default '',
  softlanguage varchar(50) NOT NULL default '',
  copyright varchar(50) NOT NULL default '',
  operatingsystem varchar(150) NOT NULL default '',
  demourl varchar(150) NOT NULL default '',
  loadnum mediumint(7) NOT NULL default '0',
  forbidguestdown tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  lastview int(10) NOT NULL default '0',
  ishack tinyint(1) NOT NULL default '0',
  downtype tinyint(1) NOT NULL default '0',
  downtime int(10) NOT NULL default '0',
  weekdown int(7) NOT NULL default '0',
  updatetime int(10) NOT NULL default '0',
  daydown mediumint(4) NOT NULL default '0',
  monthdown mediumint(4) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY fid (fid),
  KEY levels (levels),
  KEY hits (hits,yz,fid,levels),
  KEY list (list,yz,fid,levels),
  KEY lastview (yz,lastview,fid,levels),
  KEY uid (uid,list)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_down_sort;
CREATE TABLE p8_down_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  index_show tinyint(1) NOT NULL default '0',
  list_html varchar(255) NOT NULL default '',
  bencandy_html varchar(255) NOT NULL default '',
  PRIMARY KEY  (fid),
  KEY fup (fup),
  KEY index_show (index_show,list)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_ad;
CREATE TABLE p8_fenlei_ad (
  id mediumint(7) NOT NULL auto_increment,
  keywords varchar(50) NOT NULL default '',
  name varchar(100) NOT NULL default '',
  type varchar(30) NOT NULL default '0',
  isclose tinyint(1) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  adcode text NOT NULL,
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_adminwork;
CREATE TABLE p8_fenlei_adminwork (
  aid mediumint(7) NOT NULL auto_increment,
  type varchar(30) NOT NULL default '',
  id mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  ifpm tinyint(1) NOT NULL default '0',
  fen smallint(4) NOT NULL default '0',
  reason text NOT NULL,
  posttime int(10) NOT NULL default '0',
  PRIMARY KEY  (aid),
  KEY type (type),
  KEY id (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_area;
CREATE TABLE p8_fenlei_area (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  dirname varchar(150) NOT NULL default '',
  hits mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_buyad;
CREATE TABLE p8_fenlei_buyad (
  aid mediumint(7) NOT NULL auto_increment,
  sortid mediumint(7) NOT NULL default '0',
  cityid mediumint(7) NOT NULL default '0',
  id mediumint(7) NOT NULL default '0',
  mid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (aid),
  KEY sortid (sortid,money,endtime,cityid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_city;
CREATE TABLE p8_fenlei_city (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  dirname varchar(150) NOT NULL default '',
  hits mediumint(7) NOT NULL default '0',
  letter varchar(5) NOT NULL default '',
  domain varchar(150) NOT NULL default '',
  PRIMARY KEY  (fid),
  KEY fup (fup),
  KEY letter (letter),
  KEY list (list)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_collection;
CREATE TABLE p8_fenlei_collection (
  cid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  PRIMARY KEY  (cid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_comments;
CREATE TABLE p8_fenlei_comments (
  cid mediumint(7) unsigned NOT NULL auto_increment,
  cuid int(7) NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  id mediumint(7) unsigned NOT NULL default '0',
  fid mediumint(7) unsigned NOT NULL default '0',
  uid mediumint(7) unsigned NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  content text NOT NULL,
  ip varchar(15) NOT NULL default '',
  icon tinyint(3) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (cid),
  KEY type (type)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_config;
CREATE TABLE p8_fenlei_config (
  c_key varchar(50) NOT NULL default '',
  c_value text NOT NULL,
  c_descrip text NOT NULL,
  PRIMARY KEY  (c_key)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content;
CREATE TABLE p8_fenlei_content (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  mid smallint(4) NOT NULL default '0',
  spid mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  fid_bak1 mediumint(7) NOT NULL default '0',
  fid_bak2 mediumint(7) NOT NULL default '0',
  fid_bak3 mediumint(7) NOT NULL default '0',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list varchar(10) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  ispic tinyint(1) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  config text NOT NULL,
  lastview int(10) NOT NULL default '0',
  city_id mediumint(7) NOT NULL default '0',
  zone_id mediumint(7) NOT NULL default '0',
  street_id mediumint(7) NOT NULL default '0',
  editpwd varchar(32) NOT NULL default '',
  showday mediumint(4) NOT NULL default '0',
  visit_log text NOT NULL,
  visit_num mediumint(7) unsigned NOT NULL default '0',
  telephone varchar(30) NOT NULL default '',
  mobphone varchar(12) NOT NULL default '',
  email varchar(50) NOT NULL default '',
  oicq varchar(11) NOT NULL default '',
  msn varchar(50) NOT NULL default '',
  maps varchar(50) NOT NULL default '',
  replytime varchar(10) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY fid (fid),
  KEY ispic (ispic),
  KEY city_id (city_id),
  KEY zone_id (zone_id),
  KEY street_id (street_id),
  KEY hits (hits,edittime,yz,fid),
  KEY lastview (lastview,edittime,yz,fid),
  KEY list (list,endtime,yz,fid,city_id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_1;
CREATE TABLE p8_fenlei_content_1 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  h_rooms int(1) NOT NULL default '0',
  b_money varchar(20) NOT NULL default '',
  h_height varchar(20) NOT NULL default '',
  h_zs int(1) NOT NULL default '0',
  h_bus varchar(50) NOT NULL default '',
  h_have varchar(100) NOT NULL default '',
  h_owner varchar(50) NOT NULL default '',
  h_address varchar(150) NOT NULL default '',
  h_paytype mediumtext NOT NULL,
  h_acreage varchar(10) NOT NULL default '',
  h_username varchar(20) NOT NULL default '',
  h_tel varchar(20) NOT NULL default '',
  h_email varchar(50) NOT NULL default '',
  h_qq varchar(50) NOT NULL default '',
  my_mantype int(2) NOT NULL default '0',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_10;
CREATE TABLE p8_fenlei_content_10 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  h_owner mediumtext NOT NULL,
  h_area mediumtext NOT NULL,
  h_address mediumtext NOT NULL,
  h_zs mediumtext NOT NULL,
  h_acreage mediumtext NOT NULL,
  b_money mediumtext NOT NULL,
  h_paytype mediumtext NOT NULL,
  h_height mediumtext NOT NULL,
  h_manager mediumtext NOT NULL,
  h_kong varchar(16) NOT NULL default '',
  h_lift mediumtext NOT NULL,
  h_guanqiang mediumtext NOT NULL,
  h_bus varchar(10) NOT NULL default '',
  h_baoan varchar(12) NOT NULL default '',
  h_username varchar(12) NOT NULL default '',
  h_tel mediumtext NOT NULL,
  h_email varchar(50) NOT NULL default '',
  h_qq mediumtext NOT NULL,
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_11;
CREATE TABLE p8_fenlei_content_11 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  c_address varchar(100) NOT NULL default '',
  c_tel varchar(20) NOT NULL default '',
  my_fen int(6) NOT NULL default '0',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_2;
CREATE TABLE p8_fenlei_content_2 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  m_sex int(1) NOT NULL default '0',
  m_age int(3) NOT NULL default '0',
  m_money int(1) NOT NULL default '0',
  m_star int(2) NOT NULL default '0',
  m_mar int(1) NOT NULL default '0',
  m_height varchar(12) NOT NULL default '',
  m_work varchar(30) NOT NULL default '',
  m_province varchar(18) NOT NULL default '',
  m_intersing varchar(50) NOT NULL default '',
  m_school int(1) NOT NULL default '0',
  m_tel varchar(20) NOT NULL default '',
  m_email varchar(40) NOT NULL default '',
  m_qq varchar(50) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_3;
CREATE TABLE p8_fenlei_content_3 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  t_shopname varchar(50) NOT NULL default '',
  t_hownew int(2) NOT NULL default '0',
  t_buytime varchar(20) NOT NULL default '',
  t_buytype varchar(12) NOT NULL default '',
  t_money varchar(20) NOT NULL default '',
  t_username varchar(12) NOT NULL default '',
  t_tel varchar(20) NOT NULL default '',
  t_email varchar(50) NOT NULL default '',
  t_qq varchar(50) NOT NULL default '',
  my_ifsell varchar(4) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid),
  KEY my_ifsell (my_ifsell)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_4;
CREATE TABLE p8_fenlei_content_4 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  q_job varchar(40) NOT NULL default '',
  q_truename varchar(10) NOT NULL default '',
  q_sex int(1) NOT NULL default '0',
  q_born varchar(20) NOT NULL default '',
  q_mar int(1) NOT NULL default '0',
  q_mzu varchar(10) NOT NULL default '',
  q_height varchar(5) NOT NULL default '',
  q_weight varchar(6) NOT NULL default '',
  q_school int(2) NOT NULL default '0',
  q_province varchar(12) NOT NULL default '',
  q_computer varchar(4) NOT NULL default '',
  q_levevschool varchar(30) NOT NULL default '',
  q_speciality varchar(40) NOT NULL default '',
  q_city varchar(20) NOT NULL default '',
  q_lang varchar(8) NOT NULL default '',
  q_workyear varchar(6) NOT NULL default '',
  q_workstar varchar(20) NOT NULL default '',
  q_workwhere varchar(20) NOT NULL default '',
  q_wantwork varchar(30) NOT NULL default '',
  q_money varchar(20) NOT NULL default '',
  q_worktimestar varchar(4) NOT NULL default '',
  q_strong varchar(50) NOT NULL default '',
  q_tel varchar(20) NOT NULL default '',
  q_mail varchar(50) NOT NULL default '',
  q_qq varchar(20) NOT NULL default '',
  q_address varchar(100) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_5;
CREATE TABLE p8_fenlei_content_5 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  z_job varchar(40) NOT NULL default '',
  z_companyname varchar(30) NOT NULL default '',
  z_num int(3) NOT NULL default '0',
  z_workwhere varchar(20) NOT NULL default '',
  z_zhushu varchar(8) NOT NULL default '',
  z_wage int(2) NOT NULL default '0',
  z_workyear int(3) NOT NULL default '0',
  z_schoolage varchar(12) NOT NULL default '',
  z_lang varchar(12) NOT NULL default '',
  z_computerlevel varchar(8) NOT NULL default '',
  z_sex int(1) NOT NULL default '0',
  z_zuanye varchar(20) NOT NULL default '',
  z_age varchar(20) NOT NULL default '',
  z_height varchar(20) NOT NULL default '',
  z_weight varchar(20) NOT NULL default '',
  z_health varchar(50) NOT NULL default '',
  z_other mediumtext NOT NULL,
  z_username varchar(12) NOT NULL default '',
  z_tel varchar(20) NOT NULL default '',
  z_email varchar(50) NOT NULL default '',
  z_qq varchar(20) NOT NULL default '',
  z_address varchar(100) NOT NULL default '',
  z_postcode varchar(6) NOT NULL default '',
  z_fax varchar(12) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_8;
CREATE TABLE p8_fenlei_content_8 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  h_rooms int(1) NOT NULL default '0',
  b_money varchar(20) NOT NULL default '',
  h_height varchar(20) NOT NULL default '',
  h_zs int(1) NOT NULL default '0',
  h_bus varchar(50) NOT NULL default '',
  h_have varchar(100) NOT NULL default '',
  h_owner varchar(50) NOT NULL default '',
  h_address varchar(150) NOT NULL default '',
  h_paytype mediumtext NOT NULL,
  h_acreage varchar(10) NOT NULL default '',
  h_username varchar(20) NOT NULL default '',
  h_tel varchar(20) NOT NULL default '',
  h_email varchar(50) NOT NULL default '',
  h_qq varchar(50) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_content_9;
CREATE TABLE p8_fenlei_content_9 (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  content mediumtext NOT NULL,
  h_owner varchar(30) NOT NULL default '',
  h_address varchar(100) NOT NULL default '',
  h_zs char(1) NOT NULL default '',
  h_acreage varchar(20) NOT NULL default '',
  b_money varchar(20) NOT NULL default '',
  h_paytype int(1) NOT NULL default '0',
  h_height varchar(30) NOT NULL default '',
  h_manager varchar(10) NOT NULL default '',
  h_kong int(1) NOT NULL default '0',
  h_lift varchar(8) NOT NULL default '',
  h_guanqiang char(1) NOT NULL default '',
  h_bus int(1) NOT NULL default '0',
  h_username varchar(12) NOT NULL default '',
  h_tel varchar(20) NOT NULL default '',
  h_email varchar(50) NOT NULL default '',
  h_qq varchar(50) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_gather_rule;
CREATE TABLE p8_fenlei_gather_rule (
  id mediumint(7) NOT NULL auto_increment,
  type varchar(15) NOT NULL default '0',
  fixsystem varchar(30) NOT NULL default '',
  filetype varchar(50) NOT NULL default '',
  webname varchar(150) NOT NULL default '',
  listurl varchar(150) NOT NULL default '',
  firstpage varchar(150) NOT NULL default '',
  page_begin int(10) NOT NULL default '0',
  page_end int(10) NOT NULL default '0',
  page_step int(10) NOT NULL default '0',
  title_minleng smallint(5) NOT NULL default '0',
  listmoreurl text NOT NULL,
  link_include_word text NOT NULL,
  link_noinclude_word text NOT NULL,
  link_replace_word text NOT NULL,
  title_replace_word text NOT NULL,
  list_begin_code text NOT NULL,
  list_end_code text NOT NULL,
  list_begin_preg text NOT NULL,
  list_end_preg text NOT NULL,
  gatherthesame tinyint(1) NOT NULL default '0',
  show_begin_preg text NOT NULL,
  show_end_preg text NOT NULL,
  show_endfile_preg text NOT NULL,
  show_begin_code text NOT NULL,
  show_end_code text NOT NULL,
  show_replace_word text NOT NULL,
  show_morepage varchar(100) NOT NULL default '',
  show_firstpage varchar(100) NOT NULL default '',
  show_spe2page tinyint(1) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  copypic tinyint(1) NOT NULL default '0',
  sort smallint(4) NOT NULL default '0',
  file_type varchar(50) NOT NULL default '',
  file_minleng mediumint(6) NOT NULL default '0',
  file_minsize int(9) NOT NULL default '0',
  file_includeword text NOT NULL,
  file_noincludeword text NOT NULL,
  file_explode text NOT NULL,
  file_picwidth int(8) NOT NULL default '0',
  file_star_string varchar(150) NOT NULL default '',
  title_rule text NOT NULL,
  content_rule text NOT NULL,
  title_morepage_rull text NOT NULL,
  content_morepage_rull text NOT NULL,
  charset_type tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_module;
CREATE TABLE p8_fenlei_module (
  id smallint(4) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  list smallint(4) NOT NULL default '0',
  style varchar(50) NOT NULL default '',
  config mediumtext NOT NULL,
  config2 text NOT NULL,
  comment_type tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_report;
CREATE TABLE p8_fenlei_report (
  rid mediumint(7) NOT NULL auto_increment,
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  onlineip varchar(15) NOT NULL default '',
  type tinyint(2) NOT NULL default '0',
  content text NOT NULL,
  iftrue tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (rid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_sellad;
CREATE TABLE p8_fenlei_sellad (
  id mediumint(7) NOT NULL auto_increment,
  name varchar(100) NOT NULL default '',
  isclose tinyint(1) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  price mediumint(5) NOT NULL default '0',
  day mediumint(4) NOT NULL default '0',
  adnum smallint(3) NOT NULL default '0',
  wordnum smallint(3) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_sellad_user;
CREATE TABLE p8_fenlei_sellad_user (
  ad_id mediumint(7) NOT NULL auto_increment,
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  money mediumint(6) NOT NULL default '0',
  id mediumint(7) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '1',
  adlink varchar(200) NOT NULL default '',
  adword varchar(255) NOT NULL default '',
  hits mediumint(7) NOT NULL default '0',
  cityid mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (ad_id),
  KEY id (id,endtime,money,yz,cityid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_sort;
CREATE TABLE p8_fenlei_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  mid smallint(4) NOT NULL default '0',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config mediumtext NOT NULL,
  index_show tinyint(1) NOT NULL default '0',
  sortnum smallint(4) NOT NULL default '0',
  contents mediumint(4) NOT NULL default '0',
  article_fid mediumint(7) NOT NULL default '0',
  photo_fid mediumint(7) NOT NULL default '0',
  bbs_fid mediumint(7) NOT NULL default '0',
  postmoney mediumint(5) NOT NULL default '0',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_street;
CREATE TABLE p8_fenlei_street (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  dirname varchar(150) NOT NULL default '',
  hits mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_fenlei_zone;
CREATE TABLE p8_fenlei_zone (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  dirname varchar(150) NOT NULL default '',
  hits mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_flash_comments;
CREATE TABLE p8_flash_comments (
  cid mediumint(7) unsigned NOT NULL auto_increment,
  cuid int(7) NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  id mediumint(7) unsigned NOT NULL default '0',
  fid mediumint(7) unsigned NOT NULL default '0',
  uid mediumint(7) unsigned NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  content text NOT NULL,
  ip varchar(15) NOT NULL default '',
  icon tinyint(3) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (cid),
  KEY type (type)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_flash_config;
CREATE TABLE p8_flash_config (
  c_key varchar(50) NOT NULL default '',
  c_value text NOT NULL,
  c_descrip text NOT NULL,
  PRIMARY KEY  (c_key)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_flash_gather_rule;
CREATE TABLE p8_flash_gather_rule (
  id mediumint(7) NOT NULL auto_increment,
  type varchar(15) NOT NULL default '0',
  fixsystem varchar(30) NOT NULL default '',
  filetype varchar(50) NOT NULL default '',
  webname varchar(150) NOT NULL default '',
  listurl varchar(150) NOT NULL default '',
  firstpage varchar(150) NOT NULL default '',
  page_begin int(10) NOT NULL default '0',
  page_end int(10) NOT NULL default '0',
  page_step int(10) NOT NULL default '0',
  title_minleng smallint(5) NOT NULL default '0',
  listmoreurl text NOT NULL,
  link_include_word text NOT NULL,
  link_noinclude_word text NOT NULL,
  link_replace_word text NOT NULL,
  title_replace_word text NOT NULL,
  list_begin_code text NOT NULL,
  list_end_code text NOT NULL,
  list_begin_preg text NOT NULL,
  list_end_preg text NOT NULL,
  gatherthesame tinyint(1) NOT NULL default '0',
  show_begin_preg text NOT NULL,
  show_end_preg text NOT NULL,
  show_endfile_preg text NOT NULL,
  show_begin_code text NOT NULL,
  show_end_code text NOT NULL,
  show_replace_word text NOT NULL,
  show_morepage varchar(100) NOT NULL default '',
  show_firstpage varchar(100) NOT NULL default '',
  show_spe2page tinyint(1) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  copypic tinyint(1) NOT NULL default '0',
  sort smallint(4) NOT NULL default '0',
  file_type varchar(50) NOT NULL default '',
  file_minleng mediumint(6) NOT NULL default '0',
  file_minsize int(9) NOT NULL default '0',
  file_includeword text NOT NULL,
  file_noincludeword text NOT NULL,
  file_explode text NOT NULL,
  file_picwidth int(8) NOT NULL default '0',
  file_star_string varchar(150) NOT NULL default '',
  title_rule text NOT NULL,
  content_rule text NOT NULL,
  title_morepage_rull text NOT NULL,
  content_morepage_rull text NOT NULL,
  charset_type tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_flash_sort;
CREATE TABLE p8_flash_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  maxperpage tinyint(3) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  index_show tinyint(1) NOT NULL default '0',
  list_html varchar(255) NOT NULL default '',
  bencandy_html varchar(255) NOT NULL default '',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_flash_swf;
CREATE TABLE p8_flash_swf (
  id mediumint(7) NOT NULL auto_increment,
  fid mediumint(7) NOT NULL default '0',
  title varchar(100) NOT NULL default '',
  fname varchar(50) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  ispic tinyint(1) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  buyuser text NOT NULL,
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  flashsize varchar(10) NOT NULL default '',
  flashurl varchar(150) NOT NULL default '',
  content text NOT NULL,
  author varchar(39) NOT NULL default '',
  config text NOT NULL,
  lastview int(10) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY fid (fid),
  KEY levels (levels),
  KEY hits (hits,yz,fid,levels),
  KEY list (list,yz,fid,levels),
  KEY lastview (yz,lastview,fid,levels),
  KEY uid (uid,list)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_form_content;
CREATE TABLE p8_form_content (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  mid smallint(4) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list varchar(10) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  yz tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY hits (hits,yz),
  KEY list (list,yz)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_form_content_1;
CREATE TABLE p8_form_content_1 (
  id mediumint(7) unsigned NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  my_truename varchar(20) NOT NULL default '',
  my_sex varchar(4) NOT NULL default '',
  my_qq int(10) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_form_content_3;
CREATE TABLE p8_form_content_3 (
  id mediumint(7) NOT NULL auto_increment,
  uid mediumint(7) NOT NULL default '0',
  content varchar(50) NOT NULL default '',
  my_758 varchar(6) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_form_module;
CREATE TABLE p8_form_module (
  id smallint(4) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  list smallint(4) NOT NULL default '0',
  style varchar(50) NOT NULL default '',
  config mediumtext NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_friendlink;
CREATE TABLE p8_friendlink (
  id mediumint(5) NOT NULL auto_increment,
  fid int(7) NOT NULL default '0',
  name varchar(30) NOT NULL default '',
  url varchar(150) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip varchar(255) NOT NULL default '',
  list int(10) NOT NULL default '0',
  ifhide tinyint(1) NOT NULL default '0',
  iswordlink tinyint(1) default NULL,
  hits tinyint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  uid int(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  yz tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_friendlink_sort;
CREATE TABLE p8_friendlink_sort (
  fid mediumint(7) NOT NULL auto_increment,
  name varchar(30) NOT NULL default '',
  list int(10) NOT NULL default '0',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_gather_rule;
CREATE TABLE p8_gather_rule (
  id mediumint(7) NOT NULL auto_increment,
  fid mediumint(7) NOT NULL default '0',
  type varchar(15) NOT NULL default '0',
  fixsystem varchar(30) NOT NULL default '',
  filetype varchar(50) NOT NULL default '',
  webname varchar(150) NOT NULL default '',
  listurl varchar(150) NOT NULL default '',
  firstpage varchar(150) NOT NULL default '',
  page_begin int(10) NOT NULL default '0',
  page_end int(10) NOT NULL default '0',
  page_step int(10) NOT NULL default '0',
  title_minleng smallint(5) NOT NULL default '0',
  listmoreurl text NOT NULL,
  link_include_word text NOT NULL,
  link_noinclude_word text NOT NULL,
  link_replace_word text NOT NULL,
  title_replace_word text NOT NULL,
  list_begin_code text NOT NULL,
  list_end_code text NOT NULL,
  list_begin_preg text NOT NULL,
  list_end_preg text NOT NULL,
  gatherthesame tinyint(1) NOT NULL default '0',
  show_begin_preg text NOT NULL,
  show_end_preg text NOT NULL,
  show_endfile_preg text NOT NULL,
  show_begin_code text NOT NULL,
  show_end_code text NOT NULL,
  show_replace_word text NOT NULL,
  show_morepage varchar(100) NOT NULL default '',
  show_firstpage varchar(100) NOT NULL default '',
  show_spe2page tinyint(1) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  copypic tinyint(1) NOT NULL default '0',
  sort smallint(4) NOT NULL default '0',
  file_type varchar(50) NOT NULL default '',
  file_minleng mediumint(6) NOT NULL default '0',
  file_minsize int(9) NOT NULL default '0',
  file_includeword text NOT NULL,
  file_noincludeword text NOT NULL,
  file_explode text NOT NULL,
  file_picwidth int(8) NOT NULL default '0',
  file_star_string varchar(150) NOT NULL default '',
  title_rule text NOT NULL,
  content_rule text NOT NULL,
  title_morepage_rull text NOT NULL,
  content_morepage_rull text NOT NULL,
  charset_type tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_gather_sort;
CREATE TABLE p8_gather_sort (
  fid mediumint(6) NOT NULL auto_increment,
  name varchar(80) NOT NULL default '',
  fup mediumint(6) NOT NULL default '0',
  class smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  list mediumint(5) NOT NULL default '0',
  allowpost varchar(255) NOT NULL default '',
  sons smallint(4) NOT NULL default '0',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group;
CREATE TABLE p8_group (
  gid smallint(4) NOT NULL auto_increment,
  gptype tinyint(1) NOT NULL default '0',
  grouptitle varchar(50) NOT NULL default '',
  levelnum mediumint(7) NOT NULL default '0',
  totalspace int(10) NOT NULL default '0',
  allowsearch tinyint(1) NOT NULL default '0',
  powerdb text NOT NULL,
  allowadmin tinyint(1) NOT NULL default '0',
  allowadmindb text,
  PRIMARY KEY  (gid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_area;
CREATE TABLE p8_group_area (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_class;
CREATE TABLE p8_group_class (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  allowpost varchar(100) NOT NULL default '',
  admin varchar(100) NOT NULL default '',
  config text NOT NULL,
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_comments;
CREATE TABLE p8_group_comments (
  cid mediumint(7) unsigned NOT NULL auto_increment,
  cuid int(7) NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  id mediumint(7) unsigned NOT NULL default '0',
  fid mediumint(7) unsigned NOT NULL default '0',
  uid mediumint(7) unsigned NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  content text NOT NULL,
  ip varchar(15) NOT NULL default '',
  icon tinyint(3) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (cid),
  KEY type (type)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_config;
CREATE TABLE p8_group_config (
  c_key varchar(50) NOT NULL default '',
  c_value text NOT NULL,
  c_descrip text NOT NULL,
  PRIMARY KEY  (c_key)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_forum_reply;
CREATE TABLE p8_group_forum_reply (
  rid mediumint(7) NOT NULL auto_increment,
  topic tinyint(1) NOT NULL default '0',
  tid mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  uid int(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  ip varchar(15) NOT NULL default '',
  content mediumtext NOT NULL,
  PRIMARY KEY  (rid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_forum_topic;
CREATE TABLE p8_group_forum_topic (
  tid mediumint(7) NOT NULL auto_increment,
  title varchar(150) NOT NULL default '',
  fid mediumint(7) NOT NULL default '0',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  replies mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  titlecolor varchar(15) NOT NULL default '',
  PRIMARY KEY  (tid),
  KEY uid (uid),
  KEY fid (fid),
  KEY hits (hits),
  KEY list (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_friendlink;
CREATE TABLE p8_group_friendlink (
  id mediumint(7) NOT NULL auto_increment,
  uid mediumint(7) NOT NULL default '0',
  name varchar(30) NOT NULL default '',
  url varchar(150) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip varchar(255) NOT NULL default '',
  list int(10) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_group;
CREATE TABLE p8_group_group (
  uid int(7) NOT NULL auto_increment,
  creator varchar(30) NOT NULL default '',
  creatorid mediumint(7) NOT NULL default '0',
  catid tinyint(2) NOT NULL default '0',
  createtime int(10) NOT NULL default '0',
  provinceid mediumint(5) NOT NULL default '0',
  province varchar(30) NOT NULL default '',
  cityid mediumint(5) NOT NULL default '0',
  city varchar(30) NOT NULL default '',
  webname varchar(50) NOT NULL default '',
  domain varchar(50) NOT NULL default '',
  isopen tinyint(1) NOT NULL default '1',
  module text NOT NULL,
  layout tinyint(3) NOT NULL default '0',
  webwidth varchar(15) NOT NULL default '',
  rollmsg text NOT NULL,
  intro text NOT NULL,
  logo varchar(150) NOT NULL default '',
  navigation text NOT NULL,
  slogan varchar(50) NOT NULL default '',
  css text NOT NULL,
  diycss text NOT NULL,
  style varchar(15) NOT NULL default '',
  flash smallint(4) NOT NULL default '0',
  module_rows text NOT NULL,
  module_order text NOT NULL,
  module_desc text NOT NULL,
  module_tag text NOT NULL,
  file_module text NOT NULL,
  module_name text NOT NULL,
  module_view text NOT NULL,
  copyright varchar(255) NOT NULL default '',
  comment_type tinyint(1) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  lastview int(10) NOT NULL default '0',
  iscom tinyint(1) NOT NULL default '0',
  comtime int(10) NOT NULL default '0',
  levels int(10) NOT NULL default '0',
  content_leng mediumint(5) NOT NULL default '0',
  visitor text NOT NULL,
  comments mediumint(7) unsigned NOT NULL default '0',
  money mediumint(7) unsigned NOT NULL default '0',
  joinmoney mediumint(6) NOT NULL default '0',
  jointype tinyint(1) NOT NULL default '0',
  allowviewphoto tinyint(1) NOT NULL default '0',
  allowviewbbs tinyint(1) NOT NULL default '0',
  allowviewmember tinyint(1) NOT NULL default '0',
  usrnum mediumint(5) NOT NULL default '0',
  bbstopic mediumint(6) unsigned NOT NULL default '0',
  bbsreply mediumint(6) unsigned NOT NULL default '0',
  photonum mediumint(5) NOT NULL default '0',
  PRIMARY KEY  (uid),
  KEY webname (webname),
  KEY province (province,city),
  KEY hits (hits),
  KEY lastview (lastview),
  KEY iscom (iscom,levels),
  KEY provinceid (provinceid),
  KEY cityid (cityid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_member;
CREATE TABLE p8_group_member (
  id int(7) NOT NULL auto_increment,
  uid int(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  fid int(7) NOT NULL default '0',
  gid tinyint(2) NOT NULL default '0',
  jointime int(10) NOT NULL default '0',
  offermoney mediumint(5) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY fid (fid,uid),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_photo_album;
CREATE TABLE p8_group_photo_album (
  id mediumint(7) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_photo_pic;
CREATE TABLE p8_group_photo_pic (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  unite_id int(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  content text NOT NULL,
  photo text,
  lastview int(10) NOT NULL default '0',
  config text NOT NULL,
  forbidshow tinyint(1) NOT NULL default '0',
  author varchar(30) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY uid (uid),
  KEY fid (fid,list),
  KEY yz (yz),
  KEY lastview (lastview),
  KEY hits (hits),
  KEY list (list,uid),
  KEY levels (levels,levelstime)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_photo_sort;
CREATE TABLE p8_group_photo_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  index_show tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_group_record;
CREATE TABLE p8_group_record (
  id int(7) NOT NULL auto_increment,
  type tinyint(1) NOT NULL default '0',
  unite_id mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  admin varchar(30) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  reason text NOT NULL,
  money mediumint(5) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY unite_id (unite_id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_guestbook;
CREATE TABLE p8_guestbook (
  id int(7) NOT NULL auto_increment,
  fid mediumint(7) NOT NULL default '0',
  ico tinyint(2) NOT NULL default '0',
  email varchar(50) NOT NULL default '',
  oicq varchar(11) default NULL,
  weburl varchar(150) NOT NULL default '',
  blogurl varchar(150) NOT NULL default '',
  uid int(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  ip varchar(15) NOT NULL default '',
  content text NOT NULL,
  yz tinyint(1) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  reply text NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_hack;
CREATE TABLE p8_hack (
  keywords varchar(30) NOT NULL default '',
  name varchar(30) NOT NULL default '',
  isclose tinyint(1) NOT NULL default '0',
  author varchar(30) NOT NULL default '',
  config text NOT NULL,
  htmlcode text NOT NULL,
  hackfile text NOT NULL,
  hacksqltable text NOT NULL,
  adminurl varchar(150) NOT NULL default '',
  about text NOT NULL,
  UNIQUE KEY keywords (keywords)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_keyword;
CREATE TABLE p8_keyword (
  id mediumint(5) NOT NULL auto_increment,
  keywords varchar(30) NOT NULL default '',
  list int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  ifhide tinyint(1) NOT NULL default '0',
  url varchar(150) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY keywords (keywords)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_label;
CREATE TABLE p8_label (
  lid int(10) NOT NULL auto_increment,
  name varchar(100) NOT NULL default '',
  ch smallint(4) NOT NULL default '0',
  chtype tinyint(2) NOT NULL default '0',
  tag varchar(30) NOT NULL default '',
  type varchar(30) NOT NULL default '',
  typesystem tinyint(1) NOT NULL default '0',
  code text NOT NULL,
  divcode text,
  hide tinyint(1) NOT NULL default '0',
  js_time int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  pagetype tinyint(2) NOT NULL default '0',
  module tinyint(2) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  if_js tinyint(1) NOT NULL default '0',
  style varchar(40) NOT NULL default '',
  PRIMARY KEY  (lid),
  KEY ch (ch,pagetype,module,fid,tag),
  KEY style (style)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_limitword;
CREATE TABLE p8_limitword (
  id int(5) NOT NULL auto_increment,
  oldword varchar(50) NOT NULL default '',
  newword varchar(50) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_memberdata;
CREATE TABLE p8_memberdata (
  uid mediumint(7) unsigned NOT NULL default '0',
  question varchar(32) NOT NULL default '',
  groupid smallint(4) NOT NULL default '0',
  groups varchar(255) NOT NULL default '',
  yz tinyint(1) NOT NULL default '0',
  newpm tinyint(1) NOT NULL default '0',
  medals varchar(255) NOT NULL default '',
  money mediumint(7) NOT NULL default '0',
  totalspace int(10) NOT NULL default '0',
  usespace int(10) NOT NULL default '0',
  oltime int(10) NOT NULL default '0',
  lastvist int(10) NOT NULL default '0',
  lastip varchar(15) NOT NULL default '',
  regdate int(10) NOT NULL default '0',
  regip varchar(15) NOT NULL default '',
  sex tinyint(1) NOT NULL default '0',
  bday date NOT NULL default '0000-00-00',
  icon varchar(150) NOT NULL default '',
  introduce text NOT NULL,
  hits int(7) NOT NULL default '0',
  lastview int(10) NOT NULL default '0',
  oicq varchar(11) NOT NULL default '',
  msn varchar(50) NOT NULL default '',
  homepage varchar(150) NOT NULL default '',
  email varchar(50) NOT NULL default '',
  province varchar(20) NOT NULL default '',
  city varchar(20) NOT NULL default '',
  address varchar(255) NOT NULL default '',
  postalcode varchar(6) NOT NULL default '',
  mobphone varchar(12) NOT NULL default '',
  telephone varchar(25) NOT NULL default '',
  idcard varchar(20) NOT NULL default '',
  truename varchar(20) NOT NULL default '',
  config text NOT NULL,
  moneycard mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (uid),
  KEY groups (groups),
  KEY province (province,city)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_members;
CREATE TABLE p8_members (
  uid mediumint(7) unsigned NOT NULL auto_increment,
  username varchar(30) NOT NULL default '',
  password varchar(32) NOT NULL default '',
  PRIMARY KEY  (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_menu;
CREATE TABLE p8_menu (
  id mediumint(5) NOT NULL auto_increment,
  fid mediumint(5) NOT NULL default '0',
  name varchar(80) NOT NULL default '',
  linkurl varchar(150) NOT NULL default '',
  color varchar(15) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  moduleid tinyint(2) NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  hide tinyint(1) NOT NULL default '0',
  list smallint(4) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_module;
CREATE TABLE p8_module (
  id mediumint(5) NOT NULL auto_increment,
  type tinyint(1) NOT NULL default '0',
  name varchar(30) NOT NULL default '',
  pre varchar(20) NOT NULL default '',
  dirname varchar(30) NOT NULL default '',
  domain varchar(100) NOT NULL default '',
  admindir varchar(20) NOT NULL default '',
  unite_admin tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  list mediumint(5) NOT NULL default '0',
  admingroup varchar(150) NOT NULL default '',
  adminmember text NOT NULL,
  unite_member tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_moneycard;
CREATE TABLE p8_moneycard (
  id mediumint(7) NOT NULL auto_increment,
  passwd varchar(32) NOT NULL default '',
  moneyrmb int(7) NOT NULL default '0',
  moneycard int(7) NOT NULL default '0',
  ifsell tinyint(1) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(32) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_mv_comments;
CREATE TABLE p8_mv_comments (
  cid mediumint(7) unsigned NOT NULL auto_increment,
  cuid int(7) NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  id mediumint(7) unsigned NOT NULL default '0',
  fid mediumint(7) unsigned NOT NULL default '0',
  uid mediumint(7) unsigned NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  content text NOT NULL,
  ip varchar(15) NOT NULL default '',
  icon tinyint(3) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (cid),
  KEY type (type)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_mv_config;
CREATE TABLE p8_mv_config (
  c_key varchar(50) NOT NULL default '',
  c_value text NOT NULL,
  c_descrip text NOT NULL,
  PRIMARY KEY  (c_key)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_mv_gather_rule;
CREATE TABLE p8_mv_gather_rule (
  id mediumint(7) NOT NULL auto_increment,
  type varchar(15) NOT NULL default '0',
  fixsystem varchar(30) NOT NULL default '',
  filetype varchar(50) NOT NULL default '',
  webname varchar(150) NOT NULL default '',
  listurl varchar(150) NOT NULL default '',
  firstpage varchar(150) NOT NULL default '',
  page_begin int(10) NOT NULL default '0',
  page_end int(10) NOT NULL default '0',
  page_step int(10) NOT NULL default '0',
  title_minleng smallint(5) NOT NULL default '0',
  listmoreurl text NOT NULL,
  link_include_word text NOT NULL,
  link_noinclude_word text NOT NULL,
  link_replace_word text NOT NULL,
  title_replace_word text NOT NULL,
  list_begin_code text NOT NULL,
  list_end_code text NOT NULL,
  list_begin_preg text NOT NULL,
  list_end_preg text NOT NULL,
  gatherthesame tinyint(1) NOT NULL default '0',
  show_begin_preg text NOT NULL,
  show_end_preg text NOT NULL,
  show_endfile_preg text NOT NULL,
  show_begin_code text NOT NULL,
  show_end_code text NOT NULL,
  show_replace_word text NOT NULL,
  show_morepage varchar(100) NOT NULL default '',
  show_firstpage varchar(100) NOT NULL default '',
  show_spe2page tinyint(1) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  copypic tinyint(1) NOT NULL default '0',
  sort smallint(4) NOT NULL default '0',
  file_type varchar(50) NOT NULL default '',
  file_minleng mediumint(6) NOT NULL default '0',
  file_minsize int(9) NOT NULL default '0',
  file_includeword text NOT NULL,
  file_noincludeword text NOT NULL,
  file_explode text NOT NULL,
  file_picwidth int(8) NOT NULL default '0',
  file_star_string varchar(150) NOT NULL default '',
  title_rule text NOT NULL,
  content_rule text NOT NULL,
  title_morepage_rull text NOT NULL,
  content_morepage_rull text NOT NULL,
  charset_type tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_mv_sort;
CREATE TABLE p8_mv_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  index_show tinyint(1) NOT NULL default '0',
  list_html varchar(255) NOT NULL default '',
  bencandy_html varchar(255) NOT NULL default '',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_mv_video;
CREATE TABLE p8_mv_video (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) default NULL,
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  author varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  ispic tinyint(1) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  buyuser text NOT NULL,
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  content text NOT NULL,
  videourl text NOT NULL,
  isflv tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  lastview int(10) NOT NULL default '0',
  forbidshow tinyint(1) NOT NULL default '0',
  playtype enum('auto','avi','rm','swf','flv','mp3') NOT NULL default 'auto',
  PRIMARY KEY  (id),
  KEY yz (yz),
  KEY fid (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_ad;
CREATE TABLE p8_news_ad (
  id mediumint(7) NOT NULL auto_increment,
  keywords varchar(50) NOT NULL default '',
  name varchar(100) NOT NULL default '',
  type varchar(30) NOT NULL default '0',
  isclose tinyint(1) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  adcode text NOT NULL,
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_adminwork;
CREATE TABLE p8_news_adminwork (
  aid mediumint(7) NOT NULL auto_increment,
  type varchar(30) NOT NULL default '',
  id mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  ifpm tinyint(1) NOT NULL default '0',
  fen smallint(4) NOT NULL default '0',
  reason text NOT NULL,
  posttime int(10) NOT NULL default '0',
  PRIMARY KEY  (aid),
  KEY type (type),
  KEY id (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_area;
CREATE TABLE p8_news_area (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_comments;
CREATE TABLE p8_news_comments (
  cid mediumint(7) unsigned NOT NULL auto_increment,
  cuid int(7) NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  id mediumint(7) unsigned NOT NULL default '0',
  fid mediumint(7) unsigned NOT NULL default '0',
  uid mediumint(7) unsigned NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  content text NOT NULL,
  ip varchar(15) NOT NULL default '',
  icon tinyint(3) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  agree mediumint(7) NOT NULL default '0',
  disagree mediumint(7) NOT NULL default '0',
  agrees text NOT NULL,
  disagrees text NOT NULL,
  PRIMARY KEY  (cid),
  KEY type (type)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_config;
CREATE TABLE p8_news_config (
  c_key varchar(50) NOT NULL default '',
  c_value text NOT NULL,
  c_descrip text NOT NULL,
  PRIMARY KEY  (c_key)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_content;
CREATE TABLE p8_news_content (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(150) NOT NULL default '',
  smalltitle varchar(100) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  mid smallint(4) NOT NULL default '0',
  spid mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  cityid mediumint(7) NOT NULL default '0',
  city varchar(30) NOT NULL default '',
  provinceid mediumint(7) NOT NULL default '0',
  province varchar(30) NOT NULL default '',
  fid_bak1 mediumint(7) NOT NULL default '0',
  fid_bak2 mediumint(7) NOT NULL default '0',
  fid_bak3 mediumint(7) NOT NULL default '0',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  pages mediumint(5) unsigned NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list varchar(10) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  author varchar(50) NOT NULL default '',
  copyfrom varchar(70) NOT NULL default '',
  copyfromurl varchar(150) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  ispic tinyint(1) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  allowview varchar(150) NOT NULL default '',
  allowdown varchar(150) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  template varchar(250) NOT NULL default '',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  buyuser text NOT NULL,
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  config text NOT NULL,
  lastview int(10) NOT NULL default '0',
  description text NOT NULL,
  bak_id mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY ispic (ispic),
  KEY fid_bak1 (fid_bak1),
  KEY mid (mid),
  KEY fid (fid,spid),
  KEY hits (hits,yz,fid,mid,spid),
  KEY list (list,yz,fid,mid,spid),
  KEY lastview (lastview,yz,fid,mid,spid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_content_1;
CREATE TABLE p8_news_content_1 (
  rid mediumint(7) NOT NULL auto_increment,
  subhead varchar(150) NOT NULL default '',
  id mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  topic tinyint(1) NOT NULL default '0',
  content mediumtext NOT NULL,
  PRIMARY KEY  (rid),
  KEY fid (fid),
  KEY id (id),
  KEY uid (uid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_gather_rule;
CREATE TABLE p8_news_gather_rule (
  id mediumint(7) NOT NULL auto_increment,
  type varchar(15) NOT NULL default '0',
  fixsystem varchar(30) NOT NULL default '',
  filetype varchar(50) NOT NULL default '',
  webname varchar(150) NOT NULL default '',
  listurl varchar(150) NOT NULL default '',
  firstpage varchar(150) NOT NULL default '',
  page_begin int(10) NOT NULL default '0',
  page_end int(10) NOT NULL default '0',
  page_step int(10) NOT NULL default '0',
  title_minleng smallint(5) NOT NULL default '0',
  listmoreurl text NOT NULL,
  link_include_word text NOT NULL,
  link_noinclude_word text NOT NULL,
  link_replace_word text NOT NULL,
  title_replace_word text NOT NULL,
  list_begin_code text NOT NULL,
  list_end_code text NOT NULL,
  list_begin_preg text NOT NULL,
  list_end_preg text NOT NULL,
  gatherthesame tinyint(1) NOT NULL default '0',
  show_begin_preg text NOT NULL,
  show_end_preg text NOT NULL,
  show_endfile_preg text NOT NULL,
  show_begin_code text NOT NULL,
  show_end_code text NOT NULL,
  show_replace_word text NOT NULL,
  show_morepage varchar(100) NOT NULL default '',
  show_firstpage varchar(100) NOT NULL default '',
  show_spe2page tinyint(1) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  copypic tinyint(1) NOT NULL default '0',
  sort smallint(4) NOT NULL default '0',
  file_type varchar(50) NOT NULL default '',
  file_minleng mediumint(6) NOT NULL default '0',
  file_minsize int(9) NOT NULL default '0',
  file_includeword text NOT NULL,
  file_noincludeword text NOT NULL,
  file_explode text NOT NULL,
  file_picwidth int(8) NOT NULL default '0',
  file_star_string varchar(150) NOT NULL default '',
  title_rule text NOT NULL,
  content_rule text NOT NULL,
  title_morepage_rull text NOT NULL,
  content_morepage_rull text NOT NULL,
  charset_type tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_layout;
CREATE TABLE p8_news_layout (
  id int(8) NOT NULL auto_increment,
  fid mediumint(8) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  name varchar(80) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  about text NOT NULL,
  ifcode tinyint(1) NOT NULL default '0',
  code text NOT NULL,
  fids varchar(255) NOT NULL default '',
  rows char(3) NOT NULL default '',
  leng char(3) NOT NULL default '',
  position tinyint(1) NOT NULL default '0',
  toptype char(1) NOT NULL default '',
  topt_leng smallint(4) NOT NULL default '0',
  topc_leng smallint(4) NOT NULL default '0',
  queue char(1) NOT NULL default '',
  orderby tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_menu;
CREATE TABLE p8_news_menu (
  id mediumint(5) NOT NULL auto_increment,
  fid mediumint(5) NOT NULL default '0',
  name varchar(80) NOT NULL default '',
  linkurl varchar(150) NOT NULL default '',
  color varchar(15) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  moduleid tinyint(2) NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  hide tinyint(1) NOT NULL default '0',
  list smallint(4) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_module;
CREATE TABLE p8_news_module (
  id smallint(4) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  list smallint(4) NOT NULL default '0',
  style varchar(30) NOT NULL default '',
  template varchar(255) NOT NULL default '',
  config mediumtext NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_sort;
CREATE TABLE p8_news_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  mid smallint(4) NOT NULL default '0',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config mediumtext NOT NULL,
  index_show tinyint(1) NOT NULL default '0',
  sortnum smallint(4) NOT NULL default '0',
  contents mediumint(7) NOT NULL default '0',
  article_fid mediumint(7) NOT NULL default '0',
  photo_fid mediumint(7) NOT NULL default '0',
  bbs_fid mediumint(7) NOT NULL default '0',
  list_html varchar(255) NOT NULL default '',
  bencandy_html varchar(255) NOT NULL default '',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_special;
CREATE TABLE p8_news_special (
  aid mediumint(7) NOT NULL auto_increment,
  fid mediumint(7) NOT NULL default '0',
  id mediumint(7) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  PRIMARY KEY  (aid),
  KEY fid (fid),
  KEY id (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_news_spsort;
CREATE TABLE p8_news_spsort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_olpay;
CREATE TABLE p8_olpay (
  id mediumint(7) NOT NULL auto_increment,
  numcode varchar(32) NOT NULL default '',
  money mediumint(5) NOT NULL default '0',
  ifpay tinyint(1) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(32) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_photo_album;
CREATE TABLE p8_photo_album (
  id mediumint(7) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_photo_comments;
CREATE TABLE p8_photo_comments (
  cid mediumint(7) unsigned NOT NULL auto_increment,
  cuid int(7) NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  id mediumint(7) unsigned NOT NULL default '0',
  fid mediumint(7) unsigned NOT NULL default '0',
  uid mediumint(7) unsigned NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  content text NOT NULL,
  ip varchar(15) NOT NULL default '',
  icon tinyint(3) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (cid),
  KEY type (type)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_photo_config;
CREATE TABLE p8_photo_config (
  c_key varchar(50) NOT NULL default '',
  c_value text NOT NULL,
  c_descrip text NOT NULL,
  PRIMARY KEY  (c_key)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_photo_gather_rule;
CREATE TABLE p8_photo_gather_rule (
  id mediumint(7) NOT NULL auto_increment,
  type varchar(15) NOT NULL default '0',
  fixsystem varchar(30) NOT NULL default '',
  filetype varchar(50) NOT NULL default '',
  webname varchar(150) NOT NULL default '',
  listurl varchar(150) NOT NULL default '',
  firstpage varchar(150) NOT NULL default '',
  page_begin int(10) NOT NULL default '0',
  page_end int(10) NOT NULL default '0',
  page_step int(10) NOT NULL default '0',
  title_minleng smallint(5) NOT NULL default '0',
  listmoreurl text NOT NULL,
  link_include_word text NOT NULL,
  link_noinclude_word text NOT NULL,
  link_replace_word text NOT NULL,
  title_replace_word text NOT NULL,
  list_begin_code text NOT NULL,
  list_end_code text NOT NULL,
  list_begin_preg text NOT NULL,
  list_end_preg text NOT NULL,
  gatherthesame tinyint(1) NOT NULL default '0',
  show_begin_preg text NOT NULL,
  show_end_preg text NOT NULL,
  show_endfile_preg text NOT NULL,
  show_begin_code text NOT NULL,
  show_end_code text NOT NULL,
  show_replace_word text NOT NULL,
  show_morepage varchar(100) NOT NULL default '',
  show_firstpage varchar(100) NOT NULL default '',
  show_spe2page tinyint(1) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  copypic tinyint(1) NOT NULL default '0',
  sort smallint(4) NOT NULL default '0',
  file_type varchar(50) NOT NULL default '',
  file_minleng mediumint(6) NOT NULL default '0',
  file_minsize int(9) NOT NULL default '0',
  file_includeword text NOT NULL,
  file_noincludeword text NOT NULL,
  file_explode text NOT NULL,
  file_picwidth int(8) NOT NULL default '0',
  file_star_string varchar(150) NOT NULL default '',
  title_rule text NOT NULL,
  content_rule text NOT NULL,
  title_morepage_rull text NOT NULL,
  content_morepage_rull text NOT NULL,
  charset_type tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_photo_pic;
CREATE TABLE p8_photo_pic (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  buyuser text NOT NULL,
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  content text NOT NULL,
  photo text,
  lastview int(10) NOT NULL default '0',
  config text NOT NULL,
  forbidshow tinyint(1) NOT NULL default '0',
  author varchar(30) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY uid (uid,list),
  KEY fid (fid),
  KEY levels (levels),
  KEY hits (hits,yz,fid,levels),
  KEY list (list,yz,fid,levels),
  KEY lastview (lastview,yz,fid,levels)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_photo_sort;
CREATE TABLE p8_photo_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  index_show tinyint(1) NOT NULL default '0',
  list_html varchar(255) NOT NULL default '',
  bencandy_html varchar(255) NOT NULL default '',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_pm;
CREATE TABLE p8_pm (
  mid int(10) unsigned NOT NULL auto_increment,
  touid mediumint(8) unsigned NOT NULL default '0',
  togroups varchar(80) NOT NULL default '',
  fromuid mediumint(8) unsigned NOT NULL default '0',
  username varchar(15) NOT NULL default '',
  type enum('rebox','sebox','public') NOT NULL default 'rebox',
  ifnew tinyint(1) NOT NULL default '0',
  title varchar(130) NOT NULL default '',
  mdate int(10) unsigned NOT NULL default '0',
  content text NOT NULL,
  PRIMARY KEY  (mid),
  KEY touid (touid),
  KEY fromuid (fromuid),
  KEY type (type)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_reply;
CREATE TABLE p8_reply (
  rid mediumint(7) NOT NULL auto_increment,
  subhead varchar(150) NOT NULL default '',
  postdate int(10) NOT NULL default '0',
  aid mediumint(7) NOT NULL default '0',
  fid mediumint(7) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  topic tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '1',
  download text NOT NULL,
  content mediumtext NOT NULL,
  orderid mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (rid),
  KEY aid (aid),
  KEY topic (topic)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_report;
CREATE TABLE p8_report (
  id mediumint(7) NOT NULL auto_increment,
  aid mediumint(7) NOT NULL default '0',
  type varchar(50) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  name varchar(30) NOT NULL default '',
  content text NOT NULL,
  posttime int(10) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  yz tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_sellad;
CREATE TABLE p8_sellad (
  id mediumint(7) NOT NULL auto_increment,
  name varchar(100) NOT NULL default '',
  isclose tinyint(1) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  price mediumint(5) NOT NULL default '0',
  day mediumint(4) NOT NULL default '0',
  adnum smallint(3) NOT NULL default '0',
  wordnum smallint(3) NOT NULL default '0',
  autoyz tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_sellad_user;
CREATE TABLE p8_sellad_user (
  ad_id mediumint(7) NOT NULL auto_increment,
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  money mediumint(6) NOT NULL default '0',
  id mediumint(7) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '1',
  adlink varchar(200) NOT NULL default '',
  adword varchar(255) NOT NULL default '',
  hits mediumint(7) NOT NULL default '0',
  color varchar(20) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (ad_id),
  KEY id (id,endtime,money,yz)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_shop_comments;
CREATE TABLE p8_shop_comments (
  cid mediumint(7) unsigned NOT NULL auto_increment,
  cuid int(7) NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  id mediumint(7) unsigned NOT NULL default '0',
  fid mediumint(7) unsigned NOT NULL default '0',
  uid mediumint(7) unsigned NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  content text NOT NULL,
  ip varchar(15) NOT NULL default '',
  icon tinyint(3) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (cid),
  KEY type (type)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_shop_config;
CREATE TABLE p8_shop_config (
  c_key varchar(50) NOT NULL default '',
  c_value text NOT NULL,
  c_descrip text NOT NULL,
  PRIMARY KEY  (c_key)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_shop_news_article;
CREATE TABLE p8_shop_news_article (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list varchar(10) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  ispic tinyint(1) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  content text NOT NULL,
  config text NOT NULL,
  lastview int(10) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY fid (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_shop_news_sort;
CREATE TABLE p8_shop_news_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  index_show tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_shop_olpay;
CREATE TABLE p8_shop_olpay (
  id mediumint(7) NOT NULL auto_increment,
  orderid mediumint(7) NOT NULL default '0',
  numcode varchar(32) NOT NULL default '',
  money varchar(15) NOT NULL default '0',
  ifpay tinyint(1) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(32) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_shop_orderproduct;
CREATE TABLE p8_shop_orderproduct (
  pid int(7) NOT NULL auto_increment,
  title varchar(50) NOT NULL default '',
  orderid mediumint(7) default NULL,
  shopid mediumint(7) NOT NULL default '0',
  shopuid mediumint(7) NOT NULL default '0',
  ifsend tinyint(1) NOT NULL default '0',
  amount mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (pid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_shop_orderuser;
CREATE TABLE p8_shop_orderuser (
  id int(7) NOT NULL auto_increment,
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  truename varchar(30) NOT NULL default '',
  sex varchar(10) NOT NULL default '',
  telphone varchar(20) NOT NULL default '',
  mobphone varchar(12) NOT NULL default '',
  email varchar(30) NOT NULL default '',
  oicq varchar(11) NOT NULL default '',
  postalcode varchar(6) NOT NULL default '',
  sendtype varchar(50) NOT NULL default '',
  paytype varchar(50) NOT NULL default '',
  olpaytype varchar(25) NOT NULL default '',
  address varchar(255) NOT NULL default '',
  othersay text NOT NULL,
  posttime int(10) NOT NULL default '0',
  ifsend tinyint(1) NOT NULL default '0',
  totalmoney varchar(15) NOT NULL default '',
  ifpay tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_shop_product;
CREATE TABLE p8_shop_product (
  id mediumint(7) NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  albumid mediumint(7) NOT NULL default '0',
  albumname varchar(50) NOT NULL default '',
  fid mediumint(7) NOT NULL default '0',
  fname varchar(50) NOT NULL default '',
  info tinyint(2) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  comments mediumint(7) NOT NULL default '0',
  posttime int(10) NOT NULL default '0',
  list varchar(10) NOT NULL default '',
  uid mediumint(7) NOT NULL default '0',
  username varchar(30) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  fonttype tinyint(1) NOT NULL default '0',
  picurl varchar(150) NOT NULL default '',
  ispic tinyint(1) NOT NULL default '0',
  yz tinyint(1) NOT NULL default '0',
  yzer varchar(30) NOT NULL default '',
  yztime int(10) NOT NULL default '0',
  levels tinyint(2) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  keywords varchar(100) NOT NULL default '',
  jumpurl varchar(150) NOT NULL default '',
  iframeurl varchar(150) NOT NULL default '',
  style varchar(15) NOT NULL default '',
  head_tpl varchar(150) NOT NULL default '',
  main_tpl varchar(150) NOT NULL default '',
  foot_tpl varchar(100) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  ishtml tinyint(1) NOT NULL default '0',
  ip varchar(15) NOT NULL default '',
  lastfid mediumint(7) NOT NULL default '0',
  money mediumint(7) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  editer varchar(30) NOT NULL default '',
  edittime int(10) NOT NULL default '0',
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  content text NOT NULL,
  nowprice varchar(15) NOT NULL default '',
  martprice varchar(15) NOT NULL default '',
  contact_tel varchar(15) NOT NULL default '',
  contact_man varchar(15) NOT NULL default '',
  shoptype varchar(30) NOT NULL default '',
  amount mediumint(7) NOT NULL default '0',
  config text NOT NULL,
  lastview int(10) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY fid (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_shop_sort;
CREATE TABLE p8_shop_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  index_show tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_sort;
CREATE TABLE p8_sort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  fmid mediumint(5) NOT NULL default '0',
  name varchar(50) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  list_html varchar(255) NOT NULL default '',
  bencandy_html varchar(255) NOT NULL default '',
  PRIMARY KEY  (fid),
  KEY fup (fup),
  KEY fmid (fmid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_special;
CREATE TABLE p8_special (
  id mediumint(7) NOT NULL auto_increment,
  fid mediumint(7) NOT NULL default '0',
  title varchar(150) NOT NULL default '',
  titlecolor varchar(15) NOT NULL default '',
  keywords varchar(100) NOT NULL default '',
  style varchar(25) NOT NULL default '',
  template varchar(255) NOT NULL default '',
  picurl varchar(150) NOT NULL default '',
  content mediumtext NOT NULL,
  aids text NOT NULL,
  tids text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  target tinyint(1) NOT NULL default '0',
  uid mediumint(7) NOT NULL default '0',
  username varchar(50) NOT NULL default '',
  posttime int(10) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  hits mediumint(7) NOT NULL default '0',
  lastview int(10) NOT NULL default '0',
  levels tinyint(1) NOT NULL default '0',
  levelstime int(10) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY fid (fid)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_spsort;
CREATE TABLE p8_spsort (
  fid mediumint(7) unsigned NOT NULL auto_increment,
  fup mediumint(7) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  class smallint(4) NOT NULL default '0',
  sons smallint(4) NOT NULL default '0',
  type tinyint(1) NOT NULL default '0',
  admin varchar(100) NOT NULL default '',
  list int(10) NOT NULL default '0',
  listorder tinyint(2) NOT NULL default '0',
  passwd varchar(32) NOT NULL default '',
  logo varchar(150) NOT NULL default '',
  descrip text NOT NULL,
  style varchar(50) NOT NULL default '',
  template text NOT NULL,
  jumpurl varchar(150) NOT NULL default '',
  maxperpage tinyint(3) NOT NULL default '0',
  metakeywords varchar(255) NOT NULL default '',
  metadescription varchar(255) NOT NULL default '',
  allowcomment tinyint(1) NOT NULL default '0',
  allowpost varchar(150) NOT NULL default '',
  allowviewtitle varchar(150) NOT NULL default '',
  allowviewcontent varchar(150) NOT NULL default '',
  allowdownload varchar(150) NOT NULL default '',
  forbidshow tinyint(1) NOT NULL default '0',
  config text NOT NULL,
  PRIMARY KEY  (fid),
  KEY fup (fup)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_template;
CREATE TABLE p8_template (
  id mediumint(5) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  type smallint(4) NOT NULL default '0',
  filepath varchar(100) NOT NULL default '',
  descrip text NOT NULL,
  list int(10) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_vote;
CREATE TABLE p8_vote (
  id int(7) NOT NULL auto_increment,
  cid int(7) NOT NULL default '0',
  title varchar(50) NOT NULL default '',
  votenum int(7) NOT NULL default '0',
  list int(10) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;


DROP TABLE IF EXISTS p8_vote_config;
CREATE TABLE p8_vote_config (
  cid int(7) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  about text NOT NULL,
  type tinyint(4) NOT NULL default '0',
  limittime int(10) NOT NULL default '0',
  limitip tinyint(1) NOT NULL default '0',
  ip text NOT NULL,
  posttime int(10) NOT NULL default '0',
  user text NOT NULL,
  begintime int(10) NOT NULL default '0',
  endtime int(10) NOT NULL default '0',
  forbidguestvote tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (cid)
) TYPE=MyISAM;


INSERT INTO `p8_ad` VALUES ('1','article_list','бҳ','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:748:\"<a href=\"http://www.ibioo.com\" target=_blank><font color=#ff0000>̹--߻վ!</font> </a><br /><a href=\"http://www.51solo.net\" target=_blank>Żҿʼ </a><br /><a href=\"www.china-highway.com\" target=_blank>·߾йٹ· </a><br /><a href=\"http://www.nenbei.com\" target=_blank><font color=#ff0000>۱ۺӭĵ </font></a><br /><a href=\"http://www.liuv.net\" target=_blank><font color=#ff0000>ˮ</font></a> <br /><a href=\"http://www.fming.net\" target=_blank>ԭ ѧӰĴƽ̨ </a><br /><a href=\"http://www.netchinatown.com/\" target=_blank>ʱƳ-⻪˾Ӣ԰ </a><br /><a href=\"http://frp.ok586.cn\" target=_blank>Ϻȴרҵ. </a>\";}','0','0','0','0','0','5','0','1');
INSERT INTO `p8_ad` VALUES ('10','article_content','еĹ','pic','1','0','0','a:8:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:50:\"http://demo2.php168.com/article/images/ad/adv2.jpg\";s:7:\"linkurl\";s:22:\"http://www.php168.com/\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";s:5:\"width\";s:3:\"215\";s:6:\"height\";s:3:\"105\";s:9:\"pictarget\";s:5:\"blank\";}','0','0','0','0','0','5','1','1');
INSERT INTO `p8_ad` VALUES ('2','article_show','ҳ','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:492:\"<a href=\"http://www.czin.cn/\" target=_blank>ߡ˵ϼ԰</a> <br /><a href=\"http://mmm.pudou.com/\" target=_blank>ܾʣ˶</a> <br /><a href=\"http://www.jneg.com.cn/\" target=_blank>ذҽܼ԰</a> <br /><a href=\"http://www.jxsrjys.com.cn/\" target=_blank>ѧо԰ </a><br /><a href=\"http://www.skyxy.cn/\" target=_blank><font color=#ff0000>ͼͼվļ԰ </font></a><br /><a href=\"http://www.fajiao.net/\" target=_blank>.Net </a><br />\";}','0','0','0','0','0','5','0','1');
INSERT INTO `p8_ad` VALUES ('11','digg_list','а߹','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:776:\"<a href=\"http://www.ibioo.com/\" target=_blank><font color=#ff0000>̹--߻վ!</font> </a><br /><a href=\"http://www.51solo.net/\" target=_blank>Żҿʼ </a><br /><a href=\"http://1.com/45/admin/www.china-highway.com\" target=_blank>·߾йٹ· </a><br /><a href=\"http://www.nenbei.com/\" target=_blank><font color=#ff0000>۱ۺӭĵ </font></a><br /><a href=\"http://www.liuv.net/\" target=_blank><font color=#ff0000>ˮ</font></a> <br /><a href=\"http://www.fming.net/\" target=_blank>ԭ ѧӰĴƽ̨ </a><br /><a href=\"http://www.netchinatown.com/\" target=_blank>ʱƳ-⻪˾Ӣ԰ </a><br /><a href=\"http://frp.ok586.cn/\" target=_blank>Ϻȴרҵ. </a>\";}','0','0','0','0','0','5','0','1');
INSERT INTO `p8_ad` VALUES ('12','head_banner','ͷͼƬ','pic','0','0','0','a:8:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:10:\"headad.gif\";s:7:\"linkurl\";s:22:\"http://www.php168.com/\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";s:5:\"width\";s:3:\"734\";s:6:\"height\";s:2:\"60\";s:9:\"pictarget\";s:5:\"blank\";}','0','0','0','2','0','8','1','1');
INSERT INTO `p8_alonepage` VALUES ('3','0','˾Ƹ','','1165564700','0','','','','','','fdsa.htm','','','dfs','ǹ˾Ƹ','11','0');
INSERT INTO `p8_alonepage` VALUES ('5','0','˾ϵַ','','1173756661','0','','','','','','1165564715.htm','','','','<P>ǹ˾ַ</P>\r\n<P>ϵʽ:MSN:master@cms168.com QQ121727818 绰0771-7808771 棺0771-7828022 ϵ:۾</P>','8','0');
INSERT INTO `p8_alonepage` VALUES ('4','0','˾','','1165564515','0','','','','','','abc/abc.htm','','','','ǹ˾','4','0');
INSERT INTO `p8_alonepage` VALUES ('6','0','','','1182835584','0','','','','','','test/1173750212.htm','','','','<TABLE cellSpacing=4 cellPadding=4 width=\"100%\" border=0>\r\n<TBODY>\r\n<TR>\r\n<TD width=\"20%\"><A href=\"http://www.mmcbbs.com/\" target=_blank>ݼݼ̳</A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.liuv.net/\" target=_blank>ˮ</A></TD>\r\n<TD width=\"20%\"><A href=\"http://pic.goodod.com/\" target=_blank>ŷֻͼƬ</A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.tianyakezhan.com/\" target=_blank>Ŀջ</A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.czin.cn/\" target=_blank></A></TD></TR>\r\n<TR>\r\n<TD width=\"20%\"><A href=\"http://www.jneg.com.cn/\" target=_blank>ܼ԰</A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.wyrj.com/\" target=_blank>˼</A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.nenbei.com/\" target=_blank>۱</A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.photosbar.com/\" target=_blank>ͼ</A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.ok586.cn/\" target=_blank></A></TD></TR>\r\n<TR>\r\n<TD width=\"20%\"><A href=\"http://www.51solo.net/\" target=_blank>Ұ</A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.toopd.com/\" target=_blank></A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.qiqig.com/\" target=_blank></A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.jxsrjys.com.cn/\" target=_blank>Ľ</A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.unok.net/\" target=_blank></A></TD></TR>\r\n<TR>\r\n<TD width=\"20%\"><A href=\"http://mmm.pudou.com/\" target=_blank>˶й</A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.itzhan.com/\" target=_blank>IT</A></TD>\r\n<TD width=\"20%\"><A href=\"http://www.hkwtv.com/\" target=_blank></A></TD>\r\n<TD width=\"20%\">&nbsp;</TD>\r\n<TD width=\"20%\">&nbsp;</TD></TR></TBODY></TABLE>','24','0');
INSERT INTO `p8_area` VALUES ('1','0','','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('2','0','Ϻ','1','19','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('3','0','','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('4','0','','1','40','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('5','0','ӱʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('6','0','ɽʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('7','0','ɹ','1','12','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('8','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('9','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('10','0','ʡ','1','13','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('11','0','ʡ','1','13','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('12','0','㽭ʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('13','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('14','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('15','0','ʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('16','0','ɽʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('17','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('18','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('19','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('20','0','㶫ʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('21','0','׳','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('22','0','ʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('23','0','Ĵʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('24','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('25','0','ʡ','1','16','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('26','0','','1','7','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('27','0','ʡ','1','10','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('28','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('29','0','ຣʡ','1','8','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('30','0','Ļ','1','5','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('31','0','½ά','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('32','0','̨ʡ','1','25','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('33','0','ر','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('34','0','ر','1','5','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('35','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('36','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('37','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('38','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('39','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('40','1','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('41','1','ʯɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('42','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('43','1','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('44','1','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('45','1','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('46','1','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('47','1','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('48','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('49','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('50','1','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('51','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('52','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('53','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('54','2','¬','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('55','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('56','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('57','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('58','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('59','2','բ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('60','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('61','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('62','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('63','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('64','2','ζ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('65','2','ֶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('66','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('67','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('68','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('69','2','ϻ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('70','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('71','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('72','3','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('73','3','Ӷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('74','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('75','3','Ͽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('76','3','ӱ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('77','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('78','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('79','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('80','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('81','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('82','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('83','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('84','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('85','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('86','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('87','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('88','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('89','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('90','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('91','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('92','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('93','4','ɿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('94','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('95','4','ɳƺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('96','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('97','4','ϰ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('98','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('99','4','ʢ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('100','4','˫','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('101','4','山','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('102','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('103','4','ǭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('104','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('105','4','뽭','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('106','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('107','4','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('108','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('109','4','ٲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('110','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('111','4','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('112','4','ǿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('113','4','ᶼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('114','4','潭','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('115','4','¡','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('116','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('117','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('118','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('119','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('120','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('121','4','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('122','4','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('123','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('124','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('125','4','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('126','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('127','4','ϴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('128','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('129','4','ϴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('130','5','ʯׯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('131','5','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('132','5','ػʵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('133','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('134','5','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('135','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('136','5','żҿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('137','5','е','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('138','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('139','5','ȷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('140','5','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('141','6','̫ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('142','6','ͬ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('143','6','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('144','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('145','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('146','6','˷','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('147','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('148','6','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('149','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('150','6','ٷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('151','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('152','7','ͺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('153','7','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('154','7','ں','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('155','7','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('156','7','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('157','7','˹','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('158','7','ױ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('159','7','׶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('160','7','첼','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('161','7','˰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('162','7','ֹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('163','7','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('164','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('165','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('166','8','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('167','8','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('168','8','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('169','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('170','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('171','8','Ӫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('172','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('173','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('174','8','̽','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('175','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('176','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('177','8','«','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('178','9','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('179','9','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('180','9','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('181','9','Դ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('182','9','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('183','9','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('184','9','ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('185','9','׳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('186','9','ӱ߳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('187','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('188','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('189','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('190','10','׸','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('191','10','˫Ѽɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('192','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('193','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('194','10','ľ˹','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('195','10','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('196','10','ĵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('197','10','ں','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('198','10','绯','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('199','10','˰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('200','11','Ͼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('201','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('202','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('203','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('204','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('205','11','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('206','11','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('207','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('208','11','γ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('209','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('210','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('211','11','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('212','11','Ǩ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('213','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('214','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('215','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('216','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('217','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('218','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('219','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('220','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('221','12','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('222','12','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('223','12','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('224','13','Ϸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('225','13','ߺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('226','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('227','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('228','13','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('229','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('230','13','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('231','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('232','13','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('233','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('234','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('235','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('236','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('237','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('238','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('239','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('240','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('241','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('242','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('243','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('244','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('245','14','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('246','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('247','14','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('248','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('249','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('250','15','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('251','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('252','15','Ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('253','15','Ž','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('254','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('255','15','ӥ̶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('256','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('257','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('258','15','˴','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('259','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('260','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('261','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('262','16','ൺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('263','16','Ͳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('264','16','ׯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('265','16','Ӫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('266','16','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('267','16','Ϋ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('268','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('269','16','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('270','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('271','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('272','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('273','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('274','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('275','16','ĳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('276','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('277','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('278','17','֣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('279','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('280','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('281','17','ƽɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('282','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('283','17','ױ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('284','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('285','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('286','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('287','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('288','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('289','17','Ͽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('290','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('291','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('292','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('293','17','ܿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('294','17','פ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('295','18','人','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('296','18','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('297','18','ʮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('298','18','˲','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('299','18','差','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('300','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('301','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('302','18','Т','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('303','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('304','18','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('305','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('306','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('307','18','ʩ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('308','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('309','18','Ǳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('310','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('311','18','ũ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('312','19','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('313','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('314','19','̶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('315','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('316','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('317','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('318','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('319','19','żҽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('320','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('321','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('322','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('323','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('324','19','¦','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('325','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('326','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('327','20','ع','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('328','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('329','20','麣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('330','20','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('331','20','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('332','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('333','20','տ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('334','20','ï','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('335','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('336','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('337','20','÷','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('338','20','β','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('339','20','Դ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('340','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('341','20','Զ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('342','20','ݸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('343','20','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('344','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('345','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('346','20','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('347','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('348','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('349','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('350','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('351','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('352','21','Ǹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('353','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('354','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('355','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('356','21','ɫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('357','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('358','21','ӳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('359','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('360','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('361','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('362','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('363','22','ָɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('364','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('365','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('366','22','Ĳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('367','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('368','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('369','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('370','22','Ͳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('371','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('372','22','ٸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('373','22','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('374','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('375','22','ֶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('376','22','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('377','22','ͤ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('378','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('379','22','ɳȺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('380','22','ɳȺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('381','22','ɳȺĵ亣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('382','23','ɶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('383','23','Թ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('384','23','֦','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('385','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('386','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('387','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('388','23','Ԫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('389','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('390','23','ڽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('391','23','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('392','23','ϳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('393','23','üɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('394','23','˱','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('395','23','㰲','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('396','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('397','23','Ű','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('398','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('399','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('400','23','ӲǼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('401','23','β','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('402','23','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('403','24','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('404','24','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('405','24','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('406','24','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('407','24','ͭʵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('408','24','ǭϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('409','24','Ͻڵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('410','24','ǭ嶱','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('411','24','ǭϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('412','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('413','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('414','25','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('415','25','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('416','25','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('417','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('418','25','˼é','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('419','25','ٲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('420','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('421','25','ӹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('422','25','ɽ׳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('423','25','˫ɴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('424','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('425','25','º徰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('426','25','ŭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('427','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('428','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('429','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('430','26','ɽϵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('431','26','տ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('432','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('433','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('434','26','֥','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('435','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('436','27','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('437','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('438','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('439','27','μ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('440','27','Ӱ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('441','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('442','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('443','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('444','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('445','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('446','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('447','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('448','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('449','28','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('450','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('451','28','Ҵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('452','28','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('453','28','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('454','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('455','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('456','28','¤','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('457','28','Ļ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('458','28','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('459','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('460','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('461','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('462','29','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('463','29','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('464','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('465','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('466','29','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('467','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('468','30','ʯɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('469','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('470','30','ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('471','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('472','31','³ľ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('473','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('474','31','³','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('475','31','ܵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('476','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('477','31','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('478','31','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('479','31','յ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('480','31','տ¶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('481','31','ʲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('482','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('483','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('484','31','ǵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('485','31','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('486','31','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('487','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('488','31','ͼľ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('489','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('490','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('491','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('492','32','¡','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('493','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('494','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('495','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('496','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('497','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('498','32','԰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('499','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('500','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('501','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('502','32','û','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('503','32','Ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('504','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('505','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('506','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('507','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('508','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('509','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('510','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('511','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('512','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('513','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('514','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('515','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('516','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('517','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('518','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('519','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('520','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('521','33','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('522','33','ƴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('523','33','ͼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('524','33','뵺','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('525','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('526','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('527','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('528','33','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('529','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('530','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('531','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('532','33','Ԫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('533','34','л','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('534','34','ʥ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('535','34','д','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('536','34','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_area` VALUES ('537','34','з˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_article` VALUES ('41','ʲӳ(ͼ)','','2','0','','0','0','0','3','1','0','1218533826','1218533826','1','php168','','','','','0','0','http://i0.sinaimg.cn/dy/c/2008-08-12/0592701b575cbf0c4dae6e16a70ea937.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534439','0','0','','1218591857','0','0');
INSERT INTO `p8_article` VALUES ('42','йٳԱ̬ ͸ֲ','','2','0','','0','0','0','4','1','0','1218533727','1218533727','1','php168','','','','','0','0','http://i0.sinaimg.cn/dy/c/2008-08-12/U1832P1T1D16101220F21DT20080812091521.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534424','0','0','','1218536694','0','0');
INSERT INTO `p8_article` VALUES ('43','ίĻʽƬΪ¼','','2','0','','0','0','0','2','1','0','1218533631','1218533631','1','php168','','','','','0','0','','0','2','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534393','0','0');
INSERT INTO `p8_article` VALUES ('44','ھԾĸݹˮ','','2','0','','0','0','0','2','1','0','1218533533','1218533533','1','php168','','','','','0','0','http://i2.sinaimg.cn/dy/c/2008-08-12/a92a4061c09f36456b937fe12a0fa44c.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534383','0','0','','1218534387','0','0');
INSERT INTO `p8_article` VALUES ('45','ѶйŮѡžɽ32ǿ','','2','0','','0','0','0','1','1','0','1218533435','1218533435','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534351','0','0');
INSERT INTO `p8_article` VALUES ('46','˿ĻʽʸϳŵϤ','','2','0','','0','0','0','1','1','0','1218533336','1218533336','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534344','0','0');
INSERT INTO `p8_article` VALUES ('47','ʲ֮гƾԤ','','2','0','','0','0','0','2','1','0','1218533237','1218533237','1','php168','','','','','0','0','http://i1.sinaimg.cn/dy/c/2008-08-12/U1832P1T1D16102045F23DT20080812092439.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534336','0','0','','1218536647','0','0');
INSERT INTO `p8_article` VALUES ('48','¥ϮϮ߼˸лй','','2','0','','0','0','0','1','1','0','1218533140','1218533140','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534310','0','0');
INSERT INTO `p8_article` VALUES ('49','·͸緢ųйŮԵ(ͼ)','','2','0','','0','0','0','3','1','0','1218533041','1218533041','1','php168','','','','','0','0','http://i1.sinaimg.cn/dy/c/2008-08-12/U2598P1T1D16103197F21DT20080812093226.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534301','0','0','','1218534303','0','0');
INSERT INTO `p8_article` VALUES ('50','׹ 游ë󶫳ΪӢ','','2','0','','0','0','0','2','1','0','1218532944','1218532944','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218536742','0','0');
INSERT INTO `p8_article` VALUES ('51','Ϲ鳤Ѵﵽɫ˳ŵ','','2','0','','0','0','0','1','1','0','1218532854','1218532854','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534259','0','0');
INSERT INTO `p8_article` VALUES ('52','οͱ:ʹݳйǰȫ','','2','0','','0','0','0','1','1','0','1218532758','1218532758','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534256','0','0');
INSERT INTO `p8_article` VALUES ('53','15йнGDPǰ20','','2','0','','0','0','0','1','1','0','1218532659','1218532659','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534250','0','0');
INSERT INTO `p8_article` VALUES ('54','׼ ͻشЭְ','','2','0','','0','0','0','2','1','0','1218532560','1218532560','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534247','0','0');
INSERT INTO `p8_article` VALUES ('55','쵼ʢޱ˻','','2','0','','0','0','0','2','1','0','1218532461','1218532461','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534244','0','0');
INSERT INTO `p8_article` VALUES ('56','Ҫİƥˣһ11Ҫ','','2','0','','0','0','0','3','1','0','1218532363','1218532363','1','php168','','','','','0','0','http://i0.sinaimg.cn/dy/c/2008-08-12/849aa8b6036b9edabf5ae6f9546d73c9.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534231','0','0','','1218534232','1','1218534238');
INSERT INTO `p8_article` VALUES ('57','ٳ͸ֲ','','2','0','','0','0','0','1','1','0','1218532264','1218532264','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534144','0','0');
INSERT INTO `p8_article` VALUES ('58','ҪƼݰ⽻ʢ','','2','0','','0','0','0','3','1','0','1218532166','1218532166','1','php168','','','','','0','0','http://i1.sinaimg.cn/dy/c/2008-08-11/U1832P1T1D16099425F23DT20080812084313.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534199','0','0','','1218534200','0','0');
INSERT INTO `p8_article` VALUES ('59','08㲩ģרҽ뾺','','2','0','','0','0','0','4','1','0','1218532067','1218532067','1','php168','','','','','0','0','http://i2.sinaimg.cn/dy/c/2008-08-11/U2004P1T1D16099116F21DT20080811173511.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534118','0','0','','1218534484','0','0');
INSERT INTO `p8_article` VALUES ('60','̨干Ϊ̨141','','2','0','','0','0','0','5','1','0','1218531968','1218531968','1','php168','','','','','0','0','http://i2.sinaimg.cn/dy/c/2008-08-12/U1832P1T1D16104356F21DT20080812140006.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534088','0','0','','1218535110','0','0');
INSERT INTO `p8_article` VALUES ('61','ǿǰ10 ÿ1','','4','0','','0','0','0','1','1','0','1218534405','1218534405','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218535103','0','0');
INSERT INTO `p8_article` VALUES ('62','ɱɷΧʱʸɱ(ͼ)','','4','0','','0','0','0','1','1','0','1218534306','1218534306','1','php168','','','','','0','0','http://i1.sinaimg.cn/dy/s/2008-08-12/U2415P1T1D16100442F21DT20080812040134.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218535078','0','0','','1218534854','0','0');
INSERT INTO `p8_article` VALUES ('63','˲ԸŮӲ120Գ²','','4','0','','0','0','0','1','1','0','1218534207','1218534207','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534850','0','0');
INSERT INTO `p8_article` VALUES ('64','ݱӴ蹫˾̾','','4','0','','0','0','0','1','1','0','1218534108','1218534108','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534844','0','0');
INSERT INTO `p8_article` VALUES ('65','˻гԱͻ','','4','0','','0','0','0','2','1','0','1218534009','1218534009','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534840','0','0');
INSERT INTO `p8_article` VALUES ('66','СϾͷ¶3ٷ','','4','0','','0','0','0','1','1','0','1218533910','1218533910','1','php168','','','','','0','0','http://i3.sinaimg.cn/dy/s/2008-08-12/U2418P1T1D16100410F23DT20080812074515.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534829','0','0','','1218534681','0','0');
INSERT INTO `p8_article` VALUES ('67','ðŮԼŮǿ','','4','0','','0','0','0','1','1','0','1218533812','1218533812','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534675','0','0');
INSERT INTO `p8_article` VALUES ('68','ϰ֧жϰ忴(ͼ)','','4','0','','0','0','0','2','1','0','1218533713','1218533713','1','php168','','','','','0','0','http://i1.sinaimg.cn/dy/s/2008-08-12/U2036P1T1D16102794F1395DT20080812083052.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534671','0','0','','1218534834','0','0');
INSERT INTO `p8_article` VALUES ('69','ŮӲŹ侮ʯɷ','','4','0','','0','0','0','1','1','0','1218533614','1218533614','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534644','0','0');
INSERT INTO `p8_article` VALUES ('70','Ϊɱͬһ','','4','0','','0','0','0','1','1','0','1218533514','1218533514','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534641','0','0');
INSERT INTO `p8_article` VALUES ('71','Ůͯײȹ ҽԺΪƬ','','4','0','','0','0','0','1','1','0','1218533415','1218533415','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534638','0','0');
INSERT INTO `p8_article` VALUES ('72','нʻ ˾Ϯ','','4','0','','0','0','0','1','1','0','1218533317','1218533317','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534634','0','0');
INSERT INTO `p8_article` VALUES ('73','Ϊ2000Ԫοʽ','','4','0','','0','0','0','1','1','0','1218533218','1218533218','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534632','0','0');
INSERT INTO `p8_article` VALUES ('74','6ͽǹΧ½˽ҳ','','4','0','','0','0','0','1','1','0','1218533118','1218533118','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534628','0','0');
INSERT INTO `p8_article` VALUES ('75','Ϻ ̨','','4','0','','0','0','0','1','1','0','1218533020','1218533020','1','php168','','','','','0','0','http://i0.sinaimg.cn/dy/s/2008-08-12/U2494P1T1D16099949F21DT20080812025507.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534623','0','0','','1218534597','0','0');
INSERT INTO `p8_article` VALUES ('76','ǧ̰ɱֶ','','4','0','','0','0','0','1','1','0','1218532922','1218532922','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534593','0','0');
INSERT INTO `p8_article` VALUES ('77','Ů','','4','0','','0','0','0','1','1','0','1218532823','1218532823','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534590','0','0');
INSERT INTO `p8_article` VALUES ('78','˫ֲ̥ͣײǽŰ(ͼ)','','4','0','','0','0','0','2','1','0','1218532724','1218532724','1','php168','','','','','0','0','http://i0.sinaimg.cn/dy/s/p/2008-08-12/U2418P1T1D16103818F1395DT20080812111144.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218534580','0','0','','1218534584','0','0');
INSERT INTO `p8_article` VALUES ('79','г̤ͻȻŮ˿ˤվ̨','','4','0','','0','0','0','1','1','0','1218532626','1218532626','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534549','0','0');
INSERT INTO `p8_article` VALUES ('80','4⼮ԱСĦͧ͵麣ץ','','4','0','','0','0','0','1','1','0','1218532527','1218532527','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218534539','0','0');
INSERT INTO `p8_article` VALUES ('155','ϼΪ渴Ĺ޳뾵(ͼ)','','3','0','','0','0','0','2','1','0','1218535825','1218535825','1','php168','','','','','0','0','http://i1.sinaimg.cn/ent/s/h/2008-08-12/U2520P28T3D2134241F326DT20080812080523.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536487','0','0','','1218537692','0','0');
INSERT INTO `p8_article` VALUES ('156','밮÷ ˽(ͼ)','','3','0','','0','0','0','3','1','0','1218535726','1218535726','1','php168','','','','','0','0','http://i1.sinaimg.cn/ent/s/m/2008-08-12/U2398P28T3D2134731F326DT20080812161400.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536478','0','0','','1218537689','0','0');
INSERT INTO `p8_article` VALUES ('157','ҽ֤ʵгɹ 밮Ȯͬ˯(ͼ)','','3','0','','0','0','0','3','1','0','1218535627','1218535627','1','php168','','','','','0','0','http://i2.sinaimg.cn/ent/s/h/2008-08-12/U2520P28T3D2134242F326DT20080812080945.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536464','0','0','','1218537683','0','0');
INSERT INTO `p8_article` VALUES ('158','ʮȫʯͷ Ŀ3000Ʊ','','3','0','','0','0','0','2','1','0','1218535529','1218535529','1','php168','','','','','0','0','http://i3.sinaimg.cn/ent/m/c/2008-08-12/U1584P28T3D2134405F326DT20080812110608.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536455','0','0','','1218537677','0','0');
INSERT INTO `p8_article` VALUES ('159','־ٰ조ͻ Ҹ(ͼ)','','3','0','','0','0','0','2','2','0','1218535430','1218535430','1','php168','','','','','0','0','http://i3.sinaimg.cn/ent/s/h/p/2008-08-12/U2519P28T3D2134195F326DT20080812062629.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536442','0','0','','1218537662','0','0');
INSERT INTO `p8_article` VALUES ('160','ҿĻʽǰ׹̨ ԶAԱ(ͼ)','','3','0','','0','0','0','2','1','0','1218535232','1218535232','1','php168','','','','','0','0','http://i0.sinaimg.cn/ent/s/m/p/2008-08-11/U2398P28T3D2134010F326DT20080811175920.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536423','0','0','','1218536640','0','0');
INSERT INTO `p8_article` VALUES ('161','ͼֻȫ¹Ƭ','','3','0','','0','0','0','1','1','0','1218535133','1218535133','1','php168','','','','','0','0','http://i2.sinaimg.cn/ent/s/h/p/2008-08-12/U2519P28T3D2134206F326DT20080812064117.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536411','0','0','','1218536211','0','0');
INSERT INTO `p8_article` VALUES ('162','ɷڷ籩(ͼ)','','3','0','','0','0','0','1','1','0','1218535034','1218535034','1','php168','','','','','0','0','http://i2.sinaimg.cn/ent/s/m/2008-08-12/U2398P28T3D2134389F326DT20080812105307.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536397','0','0','','1218536576','0','0');
INSERT INTO `p8_article` VALUES ('163','ΰʹ(ͼ)','','3','0','','0','0','0','1','1','0','1218534936','1218534936','1','php168','','','','','0','0','http://i3.sinaimg.cn/ent/s/h/p/2008-08-12/U2519P28T3D2134194F326DT20080812054036.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536389','0','0','','1218536627','0','0');
INSERT INTO `p8_article` VALUES ('164','غ3ͷ ԽԽ(ͼ)','','3','0','','0','0','0','1','1','0','1218534837','1218534837','1','php168','','','','','0','0','http://i0.sinaimg.cn/ent/s/m/2008-08-12/U2398P28T3D2134687F326DT20080812150856.JPG','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536373','0','0','','1218536631','0','0');
INSERT INTO `p8_article` VALUES ('165','ͼдµ Ƿһ','','3','0','','0','0','0','3','1','0','1218534737','1218534737','1','php168','','','','','0','0','http://i0.sinaimg.cn/ent/y/p/2008-08-12/U1326P28T3D2134227F326DT20080812073549.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218537208','0','0','','1218537233','1','1218537232');
INSERT INTO `p8_article` VALUES ('166','ΪŮԻŮͨ(ͼ)','','3','0','','0','0','0','3','1','0','1218534638','1218534638','1','php168','','','','','0','0','http://i1.sinaimg.cn/ent/s/h/2008-08-12/U2520P28T3D2134256F326DT20080812084251.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536346','0','0','','1218537243','1','1218537242');
INSERT INTO `p8_article` VALUES ('167','ͼŶ 诰ӰʦչЦ','','3','0','','0','0','0','2','1','0','1218534540','1218534540','1','php168','','','','','0','0','http://i2.sinaimg.cn/ent/s/m/p/2008-08-12/U1343P28T3D2134533F326DT20080812125140.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536335','0','0','','1218537277','1','1218537274');
INSERT INTO `p8_article` VALUES ('168','質ɳ Ļ(ͼ)','','3','0','','0','0','0','1','1','0','1218534441','1218534441','1','php168','','','','','0','0','','0','2','','0','0','0','','','','','','0','','0','0','','','','','','0','0','0','','1218536244','0','0');
INSERT INTO `p8_article` VALUES ('169','ĳܿذ½ѧ ־','','3','0','','0','0','0','2','1','0','1218534243','1218534243','1','php168','','','','','0','0','','0','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536573','0','0','','1218536561','0','0');
INSERT INTO `p8_article` VALUES ('170','СӦɶűĵ(ͼ)','','3','0','','0','0','0','2','1','0','1218534143','1218534143','1','php168','','','','','0','0','http://i2.sinaimg.cn/ent/s/h/2008-08-12/U2231P28T3D2134467F326DT20080812113405.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536285','0','0','','1218536288','0','0');
INSERT INTO `p8_article` VALUES ('153','200繺 ӹɨƽۻ(ͼ)','','3','0','','0','0','0','1','1','0','1218536023','1218536023','1','php168','','','','','0','0','http://i0.sinaimg.cn/ent/s/h/2008-08-12/U2520P28T3D2134362F326DT20080812104327.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536521','0','0','','1218536136','0','0');
INSERT INTO `p8_article` VALUES ('154','ޱ״θףܿź(ͼ)','','3','0','','0','0','0','1','1','0','1218535924','1218535924','1','php168','','','','','0','0','http://i1.sinaimg.cn/ent/s/m/2008-08-12/U2519P28T3D2134191F326DT20080812052640.jpg','1','1','','0','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1218536500','0','0','','1218536145','0','0');
INSERT INTO `p8_article_module` VALUES ('1','Ʒģ','0','','','','a:3:{s:8:\"field_db\";a:2:{s:8:\"my_about\";a:13:{s:5:\"title\";s:8:\"Ʒ\";s:10:\"field_name\";s:8:\"my_about\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:8:\"my_price\";a:13:{s:5:\"title\";s:8:\"Ʒۼ\";s:10:\"field_name\";s:8:\"my_price\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}s:9:\"is_upfile\";a:0:{}}');
INSERT INTO `p8_blog_area` VALUES ('1','0','','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('2','0','Ϻ','1','19','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('3','0','','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('4','0','','1','40','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('5','0','ӱʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('6','0','ɽʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('7','0','ɹ','1','12','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('8','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('9','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('10','0','ʡ','1','13','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('11','0','ʡ','1','13','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('12','0','㽭ʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('13','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('14','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('15','0','ʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('16','0','ɽʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('17','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('18','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('19','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('20','0','㶫ʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('21','0','׳','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('22','0','ʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('23','0','Ĵʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('24','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('25','0','ʡ','1','16','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('26','0','','1','7','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('27','0','ʡ','1','10','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('28','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('29','0','ຣʡ','1','8','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('30','0','Ļ','1','5','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('31','0','½ά','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('32','0','̨ʡ','1','25','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('33','0','ر','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('34','0','ر','1','5','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('35','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('36','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('37','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('38','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('39','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('40','1','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('41','1','ʯɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('42','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('43','1','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('44','1','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('45','1','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('46','1','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('47','1','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('48','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('49','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('50','1','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('51','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('52','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('53','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('54','2','¬','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('55','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('56','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('57','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('58','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('59','2','բ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('60','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('61','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('62','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('63','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('64','2','ζ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('65','2','ֶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('66','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('67','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('68','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('69','2','ϻ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('70','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('71','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('72','3','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('73','3','Ӷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('74','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('75','3','Ͽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('76','3','ӱ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('77','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('78','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('79','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('80','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('81','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('82','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('83','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('84','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('85','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('86','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('87','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('88','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('89','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('90','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('91','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('92','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('93','4','ɿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('94','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('95','4','ɳƺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('96','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('97','4','ϰ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('98','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('99','4','ʢ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('100','4','˫','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('101','4','山','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('102','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('103','4','ǭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('104','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('105','4','뽭','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('106','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('107','4','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('108','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('109','4','ٲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('110','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('111','4','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('112','4','ǿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('113','4','ᶼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('114','4','潭','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('115','4','¡','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('116','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('117','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('118','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('119','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('120','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('121','4','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('122','4','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('123','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('124','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('125','4','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('126','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('127','4','ϴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('128','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('129','4','ϴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('130','5','ʯׯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('131','5','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('132','5','ػʵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('133','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('134','5','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('135','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('136','5','żҿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('137','5','е','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('138','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('139','5','ȷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('140','5','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('141','6','̫ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('142','6','ͬ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('143','6','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('144','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('145','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('146','6','˷','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('147','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('148','6','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('149','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('150','6','ٷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('151','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('152','7','ͺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('153','7','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('154','7','ں','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('155','7','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('156','7','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('157','7','˹','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('158','7','ױ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('159','7','׶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('160','7','첼','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('161','7','˰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('162','7','ֹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('163','7','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('164','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('165','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('166','8','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('167','8','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('168','8','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('169','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('170','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('171','8','Ӫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('172','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('173','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('174','8','̽','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('175','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('176','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('177','8','«','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('178','9','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('179','9','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('180','9','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('181','9','Դ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('182','9','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('183','9','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('184','9','ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('185','9','׳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('186','9','ӱ߳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('187','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('188','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('189','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('190','10','׸','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('191','10','˫Ѽɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('192','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('193','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('194','10','ľ˹','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('195','10','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('196','10','ĵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('197','10','ں','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('198','10','绯','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('199','10','˰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('200','11','Ͼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('201','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('202','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('203','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('204','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('205','11','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('206','11','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('207','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('208','11','γ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('209','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('210','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('211','11','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('212','11','Ǩ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('213','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('214','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('215','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('216','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('217','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('218','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('219','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('220','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('221','12','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('222','12','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('223','12','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('224','13','Ϸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('225','13','ߺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('226','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('227','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('228','13','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('229','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('230','13','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('231','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('232','13','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('233','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('234','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('235','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('236','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('237','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('238','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('239','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('240','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('241','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('242','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('243','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('244','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('245','14','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('246','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('247','14','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('248','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('249','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('250','15','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('251','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('252','15','Ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('253','15','Ž','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('254','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('255','15','ӥ̶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('256','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('257','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('258','15','˴','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('259','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('260','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('261','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('262','16','ൺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('263','16','Ͳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('264','16','ׯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('265','16','Ӫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('266','16','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('267','16','Ϋ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('268','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('269','16','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('270','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('271','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('272','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('273','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('274','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('275','16','ĳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('276','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('277','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('278','17','֣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('279','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('280','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('281','17','ƽɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('282','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('283','17','ױ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('284','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('285','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('286','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('287','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('288','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('289','17','Ͽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('290','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('291','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('292','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('293','17','ܿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('294','17','פ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('295','18','人','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('296','18','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('297','18','ʮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('298','18','˲','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('299','18','差','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('300','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('301','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('302','18','Т','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('303','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('304','18','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('305','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('306','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('307','18','ʩ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('308','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('309','18','Ǳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('310','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('311','18','ũ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('312','19','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('313','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('314','19','̶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('315','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('316','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('317','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('318','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('319','19','żҽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('320','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('321','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('322','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('323','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('324','19','¦','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('325','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('326','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('327','20','ع','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('328','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('329','20','麣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('330','20','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('331','20','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('332','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('333','20','տ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('334','20','ï','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('335','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('336','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('337','20','÷','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('338','20','β','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('339','20','Դ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('340','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('341','20','Զ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('342','20','ݸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('343','20','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('344','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('345','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('346','20','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('347','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('348','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('349','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('350','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('351','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('352','21','Ǹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('353','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('354','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('355','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('356','21','ɫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('357','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('358','21','ӳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('359','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('360','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('361','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('362','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('363','22','ָɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('364','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('365','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('366','22','Ĳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('367','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('368','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('369','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('370','22','Ͳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('371','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('372','22','ٸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('373','22','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('374','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('375','22','ֶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('376','22','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('377','22','ͤ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('378','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('379','22','ɳȺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('380','22','ɳȺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('381','22','ɳȺĵ亣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('382','23','ɶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('383','23','Թ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('384','23','֦','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('385','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('386','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('387','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('388','23','Ԫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('389','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('390','23','ڽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('391','23','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('392','23','ϳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('393','23','üɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('394','23','˱','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('395','23','㰲','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('396','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('397','23','Ű','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('398','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('399','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('400','23','ӲǼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('401','23','β','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('402','23','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('403','24','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('404','24','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('405','24','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('406','24','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('407','24','ͭʵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('408','24','ǭϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('409','24','Ͻڵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('410','24','ǭ嶱','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('411','24','ǭϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('412','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('413','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('414','25','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('415','25','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('416','25','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('417','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('418','25','˼é','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('419','25','ٲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('420','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('421','25','ӹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('422','25','ɽ׳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('423','25','˫ɴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('424','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('425','25','º徰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('426','25','ŭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('427','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('428','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('429','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('430','26','ɽϵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('431','26','տ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('432','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('433','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('434','26','֥','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('435','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('436','27','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('437','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('438','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('439','27','μ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('440','27','Ӱ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('441','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('442','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('443','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('444','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('445','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('446','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('447','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('448','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('449','28','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('450','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('451','28','Ҵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('452','28','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('453','28','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('454','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('455','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('456','28','¤','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('457','28','Ļ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('458','28','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('459','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('460','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('461','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('462','29','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('463','29','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('464','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('465','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('466','29','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('467','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('468','30','ʯɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('469','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('470','30','ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('471','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('472','31','³ľ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('473','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('474','31','³','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('475','31','ܵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('476','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('477','31','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('478','31','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('479','31','յ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('480','31','տ¶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('481','31','ʲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('482','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('483','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('484','31','ǵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('485','31','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('486','31','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('487','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('488','31','ͼľ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('489','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('490','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('491','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('492','32','¡','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('493','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('494','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('495','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('496','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('497','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('498','32','԰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('499','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('500','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('501','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('502','32','û','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('503','32','Ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('504','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('505','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('506','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('507','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('508','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('509','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('510','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('511','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('512','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('513','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('514','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('515','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('516','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('517','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('518','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('519','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('520','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('521','33','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('522','33','ƴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('523','33','ͼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('524','33','뵺','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('525','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('526','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('527','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('528','33','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('529','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('530','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('531','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('532','33','Ԫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('533','34','л','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('534','34','ʥ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('535','34','д','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('536','34','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_area` VALUES ('537','34','з˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_blog_class` VALUES ('1','0','','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','');
INSERT INTO `p8_blog_class` VALUES ('2','0','ѧ','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','');
INSERT INTO `p8_blog_class` VALUES ('3','0','Ƽ','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','');
INSERT INTO `p8_blog_class` VALUES ('4','0','','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','');
INSERT INTO `p8_blog_config` VALUES ('1','0','1','','35','','php168','','1','intro,friendlink,visitor|photo,log|rollmsg,photo_sort,log_sort','2','','ӭҷҵĲͣ','ƺ:php168\nOICQ:***\n:***\nԱ:***','vlog/0/1/1_20080814150845_WgYR6.jpg','ҳ	index.php		\r\nҵ־	listlog		\r\nҵͼƬ	listphoto		\r\nҵ	listmusic		\r\nҵƵ	listvideo		\r\nÿ	guestbook		','','','','22','0','','','','','','','','','1','55','1218722975','1','1218699006','0','','0');
INSERT INTO `p8_blog_log_article` VALUES ('1','ȫܶ ɱйλ˫','0','','0','','0','1','0','1218698595','1218698595','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p align=center><img src=\"http://img1.qq.com/2008/pics/12301/12301443.jpg\" border=0 /><br /><font size=2>ðȫܽƣɾȫ</font></p>\r\n<p align=center><font color=#ff0000 size=2><strong><a href=\"http://2008.qq.com/match/1445/index.shtml?p=3\" target=_blank>&nbsp;</a></strong></font>ѶѶ <!--keyword--><a href=\"http://post.soso.com/sobar.q?op=enterbar&amp;ch=&amp;kw=&amp;bne=%25CB%25AE%25C1%25A2%25B7%25BD&amp;bn=%B1%B1%BE%A9&amp;proto=4\" target=_blank><font color=#808040><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->ʱ81411ʱ<!--keyword--><a href=\"http://2008.qq.com/opub/1/match.shtml?daxiang=GA\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->ȫܾڹݽУվֽȫ<a href=\"http://2008.qq.com/athlete/3539/index.shtml\" target=_blank><font color=blue><u></u></font></a>ƾ94.575սʤж֣ԽķӺĶùھζȫܹھڵõڴѾõ<!--keyword--><a href=\"http://post.soso.com/sobar.q?op=enterbar&amp;bn=&amp;pid=bar.w.spt.news\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->ȫܹھ ֵעǣҲǱ챱˻һöƵй˶Ա⣬ڴ庽ƽ91.975ֵõƣͭƱԷĿŵõĵ÷91.925</p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ȫܾΪ4飬Ԥǰķڵһ飬ִα١˫ܡܡȫǰ⽫ڵһо </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">һֱձλѡָ֮ڴ庽ƽɲֱõ15.115.825֡¹ճ׽ղҲλ6.5Ѷȼֵõ15.625֡ϳȶǵڶ类۳0.1Ƚź֮Ķȱõ15.25֡<a href=\"http://2008.qq.com/athlete/3543/index.shtml\" target=_blank><font color=blue><u>һ</u></font></a>ڵڶ鰰Ϊһֶûгеϣеֻõ13.75֡һֽ󣬷ѡŵһڴ庽ƽ15.825ڵڶȫѡ10λ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ڶֱϳڴ庽ƽʧֻõ13.275˳ȫ<!--keyword--><a href=\"http://2008.qq.com/medals/\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->ᡣյİƺûзſϸڶַգסˣ˳ף14.375֡ϳƯ³ףõ15. 275֡һʼɡʱַʧ󣬲Ⱥܴ󣬰ڶܵλõ15.10һڵԳķӵõ16.65֡ڶֽ͸ܷͬʱ30.525ڵߡ30.0018λһ10λ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ֱյɺܸɾ·ǰת180˿õ15.025ֹ֡λڶ֣ܳ·F顰ֱ720˿7.5ĵѶȼֵõ16.625ĳ߷֮֡ʧǰ㣬·ǰִʧ󣬲ˤڵأֻõ13.85֡һһ󲽣õ15.90ֽ֡󣬺ѡ̩46.325еһ47.15λԾӵڶ һ46.30Ҳġ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ֱɡת900Ѷȼֵ6.6Ķʱһ󲽲ȳ磬õ15.975ѶȼֵΪ7.0ġڣԭ1080̬޿ޣλúܲõ16.55֡ʧֻõ15.30֡һ˫ĿϷӳˮƽõ14.95ֽ֡63.70Ծӵһѡ̩62.075еڶ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ֱһϳ׶иɻȫ׼λշұ۶޷죬ֻ·һõ16.10֡ڶĻ𷢻Ҳǳ˳շܸߣ15.70֡˫Ϸˮƽõ15.275֡һǰɷǳã·ǰ֪⣬ػʧȥû·ֱ£ֽ79.80ָ߾ӵһ̩77.3ڵڶ76.65ڵ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"><font face=Verdana>֣һ׶гһͣ٣۳0.3õ15.05ȽԼڴ庽ƽϳѶȷж׶磬·ûпסõ15.40֡¹ǿϳشʧֻõ15.40ܷ֡91.375</font>õһ˳˱ܷ94.575ж֣ն˱˻ȫܵĹھ籭ȫܱҲʵͰ˻Ĵᡣ⣬ƾȫܵĽƣҲǱ˻ͬʱйһˡ ڶ </p>','','1218698595','0');
INSERT INTO `p8_blog_log_article` VALUES ('2','ˮոʧ ؿջ˫װ','0','','0','','0','1','0','1218698663','1218698663','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p align=center><img src=\"http://img1.qq.com/2008/pics/12280/12280303.jpg\" border=0 /></p>\r\n<style>\r\n#Pread {padding:10px;width:450px;color:#404040;border:#FFD395 solid 1px;text-align:left;} \r\n#Pread td{line-height:24px;}\r\n#Pread .una {border-left:0px ;border-right:0px0}\r\n#Pread .una a{ text-decoration:underline}\r\n#Pread .una a:hover{ text-decoration:none}\r\n#Pread a{color:#000; text-decoration:none}\r\n.STYLE1 {color: #FF0000}\r\n</style>\r\n\r\n<p style=\"TEXT-INDENT: 2em\">ѶѶ <!--keyword--><a href=\"http://post.soso.com/sobar.q?op=enterbar&amp;ch=&amp;kw=&amp;bne=%25CB%25AE%25C1%25A2%25B7%25BD&amp;bn=%B1%B1%BE%A9&amp;proto=4\" target=_blank><font color=#808040><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->ʱ813գ3˫˰չᣬй<a href=\"http://2008.qq.com/athlete/3978/index.shtml\" target=_blank><font color=blue><u></u></font></a><a href=\"http://2008.qq.com/athlete/3981/index.shtml\" target=_blank><font color=blue><u>ؿ</u></font></a>ӳɫ469.08ĳɼѹȺۣö˫˰<!--keyword--><a href=\"http://2008.qq.com/medals/\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->ȡ<!--keyword--><a href=\"http://2008.qq.com/opub/1/match.shtml?daxiang=DV\" target=_blank><font color=blue><u><!--/keyword-->ˮ<!--keyword--></u></font></a><!--/keyword-->֮ӵĵĽͬʱйڱ<!--keyword--><a href=\"http://post.soso.com/sobar.q?op=enterbar&amp;bn=&amp;pid=bar.w.spt.news\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->϶õĵ16öơ˹ڶͿɿƷ421.98ֻܷ<!--keyword--><a href=\"http://2008.qq.com/medals/\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->ڿ ɳ/п׸޷415.05ֻü </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">˫װ䡱йؿ7ĲѾСģйˮӶͷžڶЯ16 СѿɿƷĿչͬйˮӵһе˹ٺͶͬһٴӵСͯĵ˹ 23꣬ϴѾ37ˣ¹ϿͶ-ɭ񡢰ĴŦ˹ء޲ѷʵʵͬ СؿһֱȶشҲʧ󡣵ŵ˻ϣͬĿ/Ҳ㹻ʵ۹  ɾǸָıһС </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ÿѡֹ6ֱΪ2涨Լ4ѡһֹ涨ıİ˶ѡѶϵΪ2.0˹Ͻ ڶͿɿƷϵĸǳ201Bɵ쳣õ54.60֣й/ؿǳ201BУ ˮ쳣ͬˮƵʮֵ߰塢ˮɵʮᣬõ57.60֡˹ٺͶ ѹǳͬˮϵ൱Ĭ覴ֻͬе㲻㣬ˮˮЧƵĲ õ53.40 ֽ/ؿ57.60λаףڶͿɿƷеڶ˹ٺе </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ڶֶ˹ϽڶͿɿƷϵĶΪ301Bڰ-壩׶ɵ뻮һõ52.20֣/ؿ ǳ101Bǰڰ-壩ĶУ׶ɵʮֵĸߣ˴ˮϵ޷죬д55.80֣ ô˹ٺڰ-Ķˮʱˮ洹ֱˮԴ׶ɵĲõ 49.80ֹ֣/ؿ113.40ּ̾ףڶ106.80еڶ˹ٺԵ˹ٺӵ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ڶͿɿƷѡ405Bڷܰ-壩Ѷϵ3.0׶ɵ쳣ɫͬ̿һ õ80.10֣/ؿһѡΪ107Bǰܰ-壩ѶϵΪ3.1ǳĸߣֱˮˮС õ83.70ֵĸ߷֣˹ٺѡ405Bڷܰ-壩ĶѶϵΪ3.0ʮƯӯˮд 77.40ֽ֣/ؿ197.10ƣڶͿɿƷ186.90еڶ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ֶ˹ڶͿɿƷ5154Bǰܰת-壩Ѷϵ3.4׶ϵʮĬ׶ һɣõ79.56֣/ؿѡͬĶ׶ɵʮֳɫյõ89.76ĸ߷֣˹ٺ ѡ107Bǰܰ-壩Ķ˷ӵʮֵһ㣬õ71.61ֽ֣/ؿ286.86ָ߾ӵһѾ ڶ20֮࣬ڶͿɿƷ266.46еڶ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ֶ˹ڶͿɿƷѶϵΪ3.4407CϳϸСʧ÷ֻ67.32֣/ؿѡ407Cڷ ܰ-ϥĶѶϵΪ3.4˷ʮȶ ˮˮƵҲʮֺãͬҲ覴ãյõ87.72֣ܳ 374.58ָ߳ڶн40֡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">һֶ˹ڶͿɿƷѡ5353BĶ൱ĬֻˮʱˮЧ㣬õ89.25ĸ߷֣ܷȡ 421.98֣/ؿһͬ5353BǵĶɵ൱ɫи94.50ָ֣ܷߴ469.08ֻȡյĹھն˹ڶͿɿƷ421.98ֻܷƣڿ ɳ/п׸޷415.05ֻü</p>','','1218698663','0');
INSERT INTO `p8_blog_log_article` VALUES ('3','ӱΪй15 ʵŮ25ǹ','0','','0','','0','1','0','1218698695','1218698695','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p style=\"TEXT-INDENT: 2em\">ѶѶ<!--keyword--><a href=\"http://post.soso.com/sobar.q?op=enterbar&amp;ch=&amp;kw=&amp;bne=%25CB%25AE%25C1%25A2%25B7%25BD&amp;bn=%B1%B1%BE%A9&amp;proto=4\" target=_blank><font color=#808040><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->ʱ813գ2008걱<!--keyword--><a href=\"http://post.soso.com/sobar.q?op=enterbar&amp;bn=&amp;pid=bar.w.spt.news\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword--><!--keyword--><a href=\"http://2008.qq.com/opub/1/match.shtml?daxiang=SH\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->ĿڱݽСڸոսŮ25ǹУй<a href=\"http://2008.qq.com/athlete/3615/index.shtml\" target=_blank><font color=blue><u>ӱ</u></font></a>£ʸ5ľ޴£ƾžĳɫӣܳɼ793.4ĳɼ¶<!--keyword--><a href=\"http://2008.qq.com/medals/\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->ʸңңȵɹѡֹ¸792.2ĳɼ<!--keyword--><a href=\"http://2008.qq.com/medals/\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->¹ѡɺհǶ789.2ժ<!--keyword--><a href=\"http://2008.qq.com/medals/\" target=_blank><font color=blue><u><!--/keyword-->ͭ<!--keyword--></u></font></a><!--/keyword-->һλйС<a href=\"http://2008.qq.com/athlete/5968/index.shtml\" target=_blank><font color=blue><u>ѷ꼪</u></font></a>787.9ĳɼеģδܵ콱̨ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">Ů25ǹйĴͳĿ1984˻ᵽ2004ŵ˻ᣬйһڸĿӮ12ĲսеͿ׶ԤУйλѡֳӱͷѷ꼪ֱ585582ĳɼе͵λ˳ɹѡֹ¸590ƽ˻ʸ¼ĳɼԤһ¹ѡɺհǶɼΪ587 </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ݰ˻ƣŮ25ǹÿ5ȡơʸй¸ƾ޴йλѡֳƵϣǺܴ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">һӱķӷǳȶǹȫ10֮ϣ52.5ĺóɼҲɺհǶ˵ڶλСѷ꼪Ҳֳɫͬ52.4ĳɼλʸһĹ¸ƾž޴ס </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ڶ飬óĳӱͷһн߳ɼջ53.1ĺóɼ󣬳ӱȹ˵ڶλãѾ͹¸ĲС1.6Сѷ꼪һֱҲȶ51.3ġ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">飬ӱǹ9.9ĳɼƾźֵĳɫӣӱ52.5ĺóɼһλɹѡֹ¸ܵǹеϵӰ죬һֽ10ĳɼֹڶλӱ1.9ѷ꼪ģĵ¹ѡɺհǶ1.8 </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">һ飬ӱܱǶסѹ50.3ĳɼ793.4¶ơɹѡֹ¸͵¹ѡɺհǶֱƺͭƣɼֱΪ792.2789.2һλйСѷ꼪787.9ĳɼеģδܵ콱̨(С) </p>','','1218698695','0');
INSERT INTO `p8_blog_log_article` VALUES ('4','йŮӴʷ ѹժ׽','0','','0','','0','1','0','1218698740','1218698740','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p align=center><img src=\"http://img1.qq.com/2008/pics/12276/12276261.jpg\" border=0 /><br /><font size=2>йŮŶʷӵ</font></p>\r\n<p align=center><img src=\"http://img1.qq.com/2008/pics/12276/12276299.jpg\" border=0 /><br /><font size=2>йСʤ</font></p>\r\n<p style=\"TEXT-INDENT: 2em\">ѶѶ <!--keyword--><a href=\"http://post.soso.com/sobar.q?op=enterbar&amp;ch=&amp;kw=&amp;bne=%25CB%25AE%25C1%25A2%25B7%25BD&amp;bn=%B1%B1%BE%A9&amp;proto=4\" target=_blank><font color=#808040><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->ʱ8131030<!--keyword--><a href=\"http://2008.qq.com/opub/1/match.shtml?daxiang=GA\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->Ůžսվּҵƴػ֮ۺйŮٶ<font face=Verdana>188.900ֵܷ</font>ʵʷͻȡ<!--keyword--><a href=\"http://2008.qq.com/medals/\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->öҲŮ<!--keyword--><a href=\"http://post.soso.com/sobar.q?op=enterbar&amp;bn=&amp;pid=bar.w.spt.news\" target=_blank><font color=blue><u><!--/keyword--><!--keyword--></u></font></a><!--/keyword-->ʷȡõöơȡƣھȡͭơ</p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">йӵһɳ<a href=\"http://2008.qq.com/athlete/8141/index.shtml\" target=_blank><font color=blue><u></u></font></a><a href=\"http://2008.qq.com/athlete/3533/index.shtml\" target=_blank><font color=blue><u>̷</u></font></a><a href=\"http://2008.qq.com/athlete/8144/index.shtml\" target=_blank><font color=blue><u></u></font></a>սȳڿתǳضһСõ15.10̷֡ϳ̬൱վס6.5Ѷȶõ16.00֡ѶȼֵΪ5.8Ķиɻ˶ضһվסõ15.25֡ϳ˹¡ФĪɲֱõ15.2016.0015.675֡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ϣѡֶ˹ɣ˹ѶȼֵΪGĳѿշֻزǺȣ6.4Ѷȼֵõ15.275һֽй46.35ڵ 46.875λеڶߵ͸ܵĶ˹46.95λеһ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ڶֱߵ͸ܡȳ÷÷ɷǳ·վסõ15.725֡ФɲǺܺãмСϸûпƺãֻõ15.35֡ɺܺãϺܶϸڶܺã·Ҳվסˣõ16.90֡ </p>\r\n<p style=\"TEXT-INDENT: 2em\">йӦս<a href=\"http://2008.qq.com/athlete/5887/index.shtml\" target=_blank><font color=blue><u>Դ</u></font></a>ϳסѹж׼ȷλתӿշˮֻ·һС覲褣õ15.975֡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ճ׼ת嶯ѶתӷɵĿνиɻȫ׶ݣ·һվס7.7Ѷȼֵõ16.80ĸ߷֡<a href=\"http://2008.qq.com/athlete/8139/index.shtml\" target=_blank><font color=blue><u>ο</u></font></a>ѹɵĿνԽԤʧĻܶҲ˳ɣֻһתһСʧ·΢еźǰһ7.7Ѷȼֵõ16.85֡ڶֽй95.975ڵһ94.85λеڶ˹91.85λе </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ֱƽľɳ̷ơա<a href=\"http://2008.qq.com/athlete/5890/index.shtml\" target=_blank><font color=blue><u>ɺɺ</u></font></a>ս̷ϳһѶȿշӣźеϵеʣදɵиɻõ15.15֡ϳûܵʧӰ죬շܸɾֻһûɣ·վסõ15.925֡ɺɺϳĸɵļӷǳƯڶѶҲɣĶƽأһƽľŮʵİȻȻ¶·һվס7.1Ѷȼֵõ16.05ĸ߷֡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ĪῪΪϷеһ±۳0.8Ҳûӣ·վסˣõ15.10֡ϳйоأõ15.975֡ϳФɼȫľ϶·720ֻضһ²õ16.175ĸ߷ֽ֡й143.10ڵһ142.10λж </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"><font face=Verdana>һֱ١ȳĪڶշʧ󣬱ؿɷֵ֣۷ֵʧֱ۳0.1ֻõ14.125֡ڶ赸ϵ޷죬ĸѶҲɷǳãǵ磬ٶܵλֻǽǰһõ15.20֡ФշҲ˽磬ҲѶȣɲȵֻõ15.10֡</font></p>\r\n<p style=\"TEXT-INDENT: 2em\"><font face=Verdana><font face=Verdana>ϳ¶ŵı飬ѶEշغȣ赸Ƥɰܺܺˣõ15.150֡йֻһ֮ңˡԴϳšĸͷշضȵ赸黶죬Ѿ˴ţõ15.20֡ƾǰͿ̷Ƶˣ̷ϳšƺӡѶȿշأֻһϼѶȣ÷15.45֡188.45ֵܷ֣йӹھöҲŮ</font></font>ʷϵöơ </p>','','1218698740','0');
INSERT INTO `p8_blog_log_article` VALUES ('5','ܼ̺죺˶ԱҪƽ ͲҪ̫顱','0','','0','','0','1','0','1218698841','1218698841','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p style=\"TEXT-INDENT: 2em\">ˮ˹ڣܶڵԵЩ߹ͷˣڲд֮źйˮܼ̺ʾѾϵĳ棬ԱдںҲҪҪȹƽϢҲˣڴ֮󣬻йڲͣغܼ̺͡ʾ̫ңһ˶Ա̬׸̨꣬ԼʱͲ̫רġ⣬̫Ļ˫˱˵ںˣûа취ϣ׳ʧ󡣡 <br /><br /></p>\r\n<p style=\"TEXT-INDENT: 2em\">ܼ̺˵μӡ˱ʱѾգȥҲƶӦĶԲߡöԱȹС˺ٿʼŮ˫̨УɽХź/ǾһֱסȹڵĻƽ </p>\r\n<p style=\"TEXT-INDENT: 2em\">Ѿˮ4˫ĿУйӰ˽ƣܼ̺Цơﳤ˵һ˫˱ܶ϶һǿһһ̫һ£Ƶġܼ̺˵ȫÿĿֵˮƽܸߣֶ࣬ױȣڰ˻Ļ£ٳ̫ҪˡепᣬҪԱôӲ̵׼ </p>\r\n<p style=\"TEXT-INDENT: 2em\">15գջŮ˫ƵĹϼսŮ3Ԥ</p>','','1218698842','0');
INSERT INTO `p8_blog_log_article` VALUES ('6','Ԫ','0','','0','','0','1','0','1218698910','1218698910','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p style=\"TEXT-INDENT: 2em\">ˡ˫ǷȣעΪ˻Ľ֮һ821գ轫μ110ʱйٶΪ֮ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">Ϊ̳ܵ˫ŹﾶϣۼһĻᣬȻᱻҵ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">20071029գйƽ(02318.HK,601318.SH)ιʹʽϣ˺յʽΪ˫ĿȽ˶ۡ1Ԫ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"><strong>21;ñ С ʵϰ ¼ </strong></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ʵϣ޼۵ģرӢۣ1ԪıҲֻǴƽףԸѡ˴ʽйƽܾｨһʾ<br /><br /></p>\r\n<p style=\"TEXT-INDENT: 2em\">δֱΪһ˫Ͷ۵йҵܹΪ߷յľ˶ԱṩıƷֻ̫٣812գ豣ƽյһλ֪ʿʾ;۵ȱʹ޷ĳЩⲿλĳոʡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"><strong>Ͷһ˫ȡ </strong></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">˫ȷŬѰһר˫ȵıϷйƽƷܾʢ˵ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ݽǰý屨2006꣬ȽﾶϣŵʧƲסֱӳܵܡ飬ʹĽﺣƽ˸һ˫Ͷ˺յ뷨 </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">֪ʿ͸¶2007ϰ꣬ﺣƽڹĹܾﾶ˶ģͿʼĹΪ˫Ѱұ̡аµģܾϵͳרҵվ͹˾徭͡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">֮ǰ徭ƽǣߣǩ骡ʹıҲֱҵǲˡʢ˵Լ200756·ݣ˫㿪ʼӴѯۡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ζǣΪͷ徭ͣǴѯ۵Ķ󣬲ƽյҵţšԴˣһλµӪʿ˵ⲻ֣Ҷ֪ζҵֵ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">һʼǾѾűǡ͡ģǮ򡣡ʢʾ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ʱ౱˻ῪĻһʱ䣬վͷΧ˶Ա֮ġȦءսݱ֮ʣƾؽΪӪҦΪ̼׷ص㡣ڲú20079£йƽںҵľй(02628.HK,601628.SH)ǩҦΪˣ˱˫۰ǰӪս </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ʱڳĽӴѯۺ󣬰վͷҪйƽ¾ӪҵĶרҵӹ˾´ƶҪ󣬵רҵӹ˾ĺ˱˰Ƶ˫ȱϼƻȴ衣 </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"><strong>ԡףԸ͵ </strong></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ʱʱϡŹֵⲿλյĺⱣгͬй־򱣼ᱨ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ڹϱշչг۱ʲôıֻ㹫˾ĳҪɣйļߣĽǶȻһЩһλָҵıվͽʿ߼ߣ˫ȱգΪ׼ĶüҲͨݡйҵгͼܻʱ֧(ⲿλ)Ĵ¡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ǣڲļִ֮йƽֻ˶ΣеıղƷУΪѡһ˺յı׼ͬ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">߲Ĺڱսͨõպͬ֫ؽڻȫɥʧμΪȫСɻձ100%߸ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ﺣƽǰıֱŴʽߵõ㡣20071029գｨһֽСע1Ԫ޴200710200810£Ϊʱ1ꡣ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ԡףԸ壬ͨڲŵйƽƷƽչԪĵı </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ǢͶһ˫ȡԵݣйٽҦչ͹ƺһ£йƽԹʹķʽǩıͬʱΪйﾶӵıպ飬ʹƽֵӪԾаһ֡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">1бѹȥ룬ܲǰΪȺȺⲻʵŦԼȱϯ˶״̬ĵģպͬ֮ġ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"><strong>ѵйҵ </strong></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ͬҦ500Ԫյй٣߶ҵɡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ߴ1Ԫձйսʮֺġµƽյһλ֪ʿ߼ߣƽ֮ǰҲΪǰڵݳֽʾǳбıձĶֻм£ʱҲݳǰļѣű֣޸һꡣ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">λʿ˵Ԫձչ˾Խͨڲֱߴ1ڱıҪרŽٱˡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ƽҵΪɣܾ֪űٱϸڣ֪űıڲĻϣ˳ٷֺͬͬһϵиٱơ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ôߵıٱڽѯʱҲĶ࣬˫໥ʼͨػؽ߰˸غϡٰµƽʿ˵һպ˱ԭ򣬱ıóһˣҪǿΪ˶Աԡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">⣬ֺĸ֣߱αķʣٱˡб߶ͬעĺ⡣⣬ҲǡǡΪǰרȲƵⲿλ޷еĸء </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ƽ֪ʿ˵ıܹ֮ⲿλıԭǴʷ۵ĹУѾͷЩⲿλĳոʡ֮£йҵȱĻۡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">籣ҵ1568׶ʼҽºóױ߹400̣վݻѾʮ걸йıҵ80ֻв30ľӪʷ̵ʷʹһдĿհд </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ĿǰйվݵʵרȲգ򱣼ϱʱ˵һдϴһѶȣң20%ϷٱĴڣҲʹù˾ȱݵóȻƽ֪ʿ˵ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ջͨձҵܵĿǣƽδ͸¶űľ۸ֻǱʾղƷص㣬űۼͬﾶԱձˡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">1Ԫͬգйﾶӵ100˶ԱҲյÿ100ԪձǰƲչ˾Ϲǧ֮һĶˮƽ֮٣սΪеأڳﾶۼ1Ԫյļ۸ԼΪʮԪ</p><!--link-->','','1218698910','0');
INSERT INTO `p8_blog_log_article` VALUES ('7','2009Ӵбվ ','0','','0','','0','1','0','1218698983','1218698983','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p style=\"TEXT-INDENT: 2em\">6λ뾺ĵݶơСѣǳˡġ⣬<a href=\"http://datalib.ent.qq.com/star/1441/index.shtml\" target=_blank>Աɽ</a>пܺ<a href=\"http://datalib.ent.qq.com/star/1218/index.shtml\" target=_blank>ΰ</a>֡ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\" align=center><img alt=image src=\"http://www.dfdaily.com/node2/node33/node226/images/00070139.jpg\" /></p>\r\n<p style=\"TEXT-INDENT: 2em\" align=center>˻ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">磬<a href=\"http://ent.qq.com/tv/\" target=_blank></a>̨2009괺ܵбᣬ<a href=\"http://datalib.ent.qq.com/star/1528/index.shtml\" target=_blank></a><a href=\"http://datalib.ent.qq.com/star/2615/index.shtml\" target=_blank></a>ῡɭ6λݲμ˾ꡣ6λȻԴⲻͬ׷״ơھ߾Ͷ귽УĻʽϼλԱҲΪһԱСѣǳˡġλݾϡ2009⣬ԱɽľҲʾԱɽ2009ܻǺͷΰ֡Ŀǰ̨бί6λݵͶ귽˳ۣбѡĿǰ鶨֮С </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"><strong>СƷ </strong></p>\r\n<p style=\"TEXT-INDENT: 2em\"><strong></strong></p>\r\n<p style=\"TEXT-INDENT: 2em\"><strong>Ըչʾ</strong> </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ߴڲϤ2009˻裬2008걱˻ݡ͸¶2009ϻֺü԰ΪĵСƷԽѡֺͱĿΪеĽͨγΪѡ֣еĽΪ˻͵ͨڣڵб깤ոչӹԱʾջʲôСƷѡȷ˰˻⣬2009пֵĻڣϼλݶԴ˻ڵöȽƣͨչʾҲǹֺؽ </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\" align=center><img alt=image src=\"http://www.dfdaily.com/node2/node33/node226/images/00070137.jpg\" /></p>\r\n<p style=\"TEXT-INDENT: 2em\" align=center>Աɽ </p><!--link-->\r\n<p align=center><strong><a href=\"http://ent.qq.com/tv/\" target=_blank>&nbsp;</a></strong></p><!--/link-->\r\n<p style=\"TEXT-INDENT: 2em\"><strong></strong></p>\r\n<p style=\"TEXT-INDENT: 2em\"><strong>ɱڵ</strong> </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\"><strong>ԱɽͲμ</strong> </p>\r\n<p style=\"TEXT-INDENT: 2em\"></p>\r\n<p style=\"TEXT-INDENT: 2em\">ӹԱ͸¶ڰ˻ῪĻʽһ質עŮɣҲ2009ΪֵġġλݵͶ귽ʱ֣˽ĿĻڡ⣬ܹעԱɽҲѾμӡ2009ߴԱɽľ˸ߴϤԱɽӴᣬ϶μӡڱʲôݣߴʾȷΨһ͸¶пϴΰٴκ </p><!--link-->\r\n<style type=text/css>\r\n<!--\r\n#tv .unnamed1 {\r\n	border: 1px solid #0000FF;\r\n}\r\n#tv a{color:#000000;text-decoration:none;}\r\n#tv a:hover{color:#F00;text-decoration:underline;}\r\n\r\n#tv a.style2{color: #F56304;text-decoration:none;}\r\n#tv a.style2:hover{color: #F56304;text-decoration:underline;}\r\n.style2 {color: #FF0000}\r\n.style3 {color: #000000}\r\n\r\n\r\n-->\r\n</style>','','1218698983','0');
INSERT INTO `p8_blog_log_article` VALUES ('8','һҪһҪйġᡱ','0','','0','','0','2','0','1218700264','1218700264','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p>&nbsp;<wbr>&nbsp;<wbr>&nbsp;<wbr>&nbsp;<wbr> <a href=\"http://vblog.hunantv.com/p126_ODMwMDE=.html\" target=_blank>Ĳд</a>⼸йԱȽϹĵһ⣬ѾôĹ¶ӵıˡѾúܳˣѵҪҡʬɣ</p>\r\n<p>&nbsp;<wbr>&nbsp;<wbr>&nbsp;<wbr>&nbsp;<wbr> ǣйѾ֮ʣȻͦڡѡһˣʲôͨ쳹صıܰйħס</p>\r\n<p>&nbsp;<wbr>&nbsp;<wbr>&nbsp;<wbr>&nbsp;<wbr> ˾ǳйų˻ῪĻʽĻʽλָ֮һǡҸҰŴ˸λӦȥй򡱡</p>\r\n<p>&nbsp;<wbr>&nbsp;<wbr>&nbsp;<wbr> <a href=\"http://vblog.hunantv.com/p126_ODMwMDE=.html\" target=_blank>йƶ˽̸</a>Ŀʱ򣬻ײ</p>\r\n<p>&nbsp;<wbr>&nbsp;<wbr>&nbsp;<wbr> ǽĿƵַ<a href=\"http://vblog.hunantv.com/p126_ODMwMDE=.html\">http://vblog.hunantv.com/p126_ODMwMDE=.html</a></p>\r\n<p>&nbsp;<wbr>&nbsp;<wbr>&nbsp;<wbr> P.S.һһдֱָǡ˵׻й뿪ʲôǣ㲻Ǹ˵</p>\r\n<p>&nbsp;<wbr>&nbsp;<wbr> Ҵۺһشġ֮˵</p>\r\n<p>&nbsp;<wbr>&nbsp;<wbr> йӣҲֻһɳԡըԽԽζϧٳĳҲǳģҲϲ˹磡</p>\r\n<p>&nbsp;<wbr>&nbsp;<wbr> ҵȷǸ˵ģ׿ʻҮǸˢǽڵġҲǸġǸֲῴֵġ뿪һܾ߱ˣúܺãôôעأôȥأ</p>\r\n<p>&nbsp;<wbr></p>','','1218722975','0');
INSERT INTO `p8_blog_log_article` VALUES ('9','ʹ ԶҪ͹һŹھ','0','','0','','0','1','0','1218700367','1218700367','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p>Ǿϻʧеáǰž޴ѹ׽ʧܵĶĵˮͬˣʤ߿ĵˮҲǶһй</p>\r\n<p>5ǰĿĵһöƺ󣬶ڵͬδܴﵽԤڳɼ̷ѩϽһͬ˾޴顣ԶҪй˶ԱʵҲԶҪһʤ͹ھġ14գ̷ѩйŮ彣ѾԼļʵĵһԾ</p>\r\n<p>Ȼ⼸ԼѸٶЧĵʹԼʧܺİûڽ320Ĳǹ˱չԼǿʵ</p>\r\n<p>ֻǿһıҲһּᶨġھġһַķʽ˻ع顣ʵʸУǰ䷢Ӳرɫ9997˺͹Ѹһظо589ĳɼƽ˰˻ĸĿԤ¼ҪǣҪְ˹3ࡣ</p>\r\n<p>һǹ8.7öȥҪص4ǰԵĸޣѾǰĶʵϣһڵһǹͶȣھҲӹŰ˿³˹ݿ˵Ŀ³˹ٵİݶջǹ˹̹Ķ֮䲻ͣתΨһľǶڵڶڵڶǹѸٰԼӱıԵ˻ԼԹھ׷9ǹûһǹ9.8ڹؼ8ʱ10.8</p>\r\n<p>ȥ󼸷ĴݲȣҲһѾںĶֻ񡣿³˹ڴλʱ7ǹ9.0ţ׷Ŀ-˹9.59.6һӽ˰ݶմ8.7ƶûšȫˣǺεȵţ</p>\r\n<p>˵ǶԿȵĸеΥƥһľ񣬶൱ҪõѡʵһԶ֣ŮӲǹ֮ҡһ죬ĿϵѾѸ߳5ǰںѵӰ϶ԼһԽ<a class=akey href=\"http://2008.sina.com.cn/\" target=_blank>˻</a>ûдǱ־ԵЦݡ˽ºͶСƺҲںͶԼ׶ټ</p>','','1218700367','0');
INSERT INTO `p8_blog_log_article` VALUES ('10','йʱ16ٶӾ ӸһǷ','0','','0','','0','1','0','1218700427','1218700427','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p>ʱ2008814,<a class=akey href=\"http://2008.sina.com.cn/\" target=_blank>˻</a>ӾˮСڽеŮ200׵ӾϣйѡӸ20418ĳɼýƲ¼йӾڱ˻ĵһƣҲйڱ˻ϻõĵ18ơ </p>\r\n<p>ӸöǷйӾ1992Ǯ100׵Ӿ֮ʱ16ٴλõӾĿơҲǼϽ˻ᣬŮѩ֮йջĵһöӾơ</p>\r\n<p>ˮӾУĴǡŷѡԼձѡƵƵƼ¼֮ʱΪյӾ̳ǿ˻ĶйӾӽջƺͭƣʼպͽԼ¼ԵڣӾĵգ20СӸΪйӾʵ˽ͻƣ⣬һλ90СӸƣĳɼҲԭ¼</p>\r\n<p>2000꿪ʼйӾ䵽͹ȡϤ˻ûջһöƣŵ˻ҲֻѩͻʵõһöƣһڱˮȻĿǰΪֹһöƣյĿöơӸʱ16ٶӾƣ˲ͻƣ(ȼ</p><!-- ģ飺 end --><!--  end -->','','1218700428','0');
INSERT INTO `p8_blog_log_article` VALUES ('11','Ӹ辪޻&quot;&quot; Ϊ˵ֽй͸ö','0','','0','','0','1','0','1218700455','1218700455','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p>ʱ2008814,<a class=akey href=\"http://2008.sina.com.cn/\" target=_blank>˻</a>ӾˮСڽеŮ200׵ӾϣйѡӸ20418ĳɼýƲ¼һйѡֽ20472ȡƣͬ¼</p>\r\n<p>ϲ˲䣬йӾ˵ͷһʯء¾Ծˮصʱ̣ҲûӸͽλСվӾ̳۷塣Ĵǿ˽翨-ϯҮǡ˺ձӼ200׹˼ǣй˫¼ǰߺ˼顣</p>\r\n<p>йӾϴվڵӾƸߵǡ5𻨡еǮ죬ڰǮ100׵Ӿƣ16Ӹͽͻƿơ׺ݡһ89꣬һ91꣬90󡱵ӣȫ˹ڡԱС⡱ıʲôħ͵أ</p>\r\n<p>˵ϿûŷѡûŷѡֱãӾӾЩԼ򵥵Ӿϣڶ̾ϣͻƿνϼѣة𢡢Ѿǳһ֣ڰȻ޷վ콱̨йӾ˹ھϣֻ100ԵׯӾ50Ե⡢־Ӿʣµ4ö200100Ǯŵ100ܵѩͽӸ200</p>\r\n<p>ѿѶȵӾ͵ӾйӾͻƵķйﾶУ硱һڼҪܸߵ110Уվ˰˻ߵ콱̨ͬͻƣкʵʵѡ<a class=akey href=\"http://sports.2008.sina.com.cn/others/pingpang.shtml\" target=_blank>ƹ</a>ëˮ<a class=akey href=\"http://2008.sina.com.cn/sports/gym/\" target=_blank></a>ǵĴͳĿһšɡİ壬׷ϵƣǲܵÿ죬ĸһǵҲǵ</p>\r\n<p>ӸͻƣΪй<a class=akey href=\"http://sports.2008.sina.com.cn/\" target=_blank></a>ָһĵ·Ȼ˷򣬱˰ǻᵽİɡ</p>\r\n<p>(.L) </p><!-- ģ飺 end --><!--  end -->','','1218700455','0');
INSERT INTO `p8_blog_log_article` VALUES ('12','ƽˮ ¼Ƶԭ','0','','0','','0','1','0','1218700520','1218700520','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p>»籱813յ ˮǡħǿڿഫ<a class=akey href=\"http://2008.sina.com.cn/\" target=_blank>˻</a>Ӿ̹룬16()δ12¼ǡˮ𣿺ܶϲԭڿ͹أӾءӾ£Ψģ˵--˶Ա</p>\r\n<p>һӾˮԽԽ</p>\r\n<p>ˮƵƼ¼ʲôܡ˵Ӿرˣ˱ʾˮ˵ʱ׼Ӿصȴﵽ3ףκһ˻Ӿض1ס</p>\r\n<p>ݹӾԱӾصĹ涨Ӿس50ףΪ21(8)25(10)2׺3֮䶼Ϊϸӽϡ˹˵Ӿ涨ˣӾȲ3׾СˮԽˮŶʱԽС˶ԱٶȾԽ졣 ˹ĻûֻСˮˮ3ף2003Ӿ2004ŵ˻ᡢ2007īӾȶıҲˡ</p>\r\n<p>Ӿ÷¡һ߽ˮԤԣᵮ¼ƯӾȻΪƼ¼ƽġţ⽫ʷٶİӾݡ ձ˵ڡݡӾĸоر廹Ǻˮ֮ϸж൱λһɳ͸о԰ƺѽǰˮζ </p>\r\n<p>ȷڶѡˮҲʢ¼ʵڲˮԵʡ</p>\r\n<p>Ƥǹؼ</p>\r\n<p>2008꣬ƺÿ¼LZRġٱΡӾϵһϰڰ¿LZRƤĴʵȻӦǡƤġСֵܡ</p>\r\n<p>2002815յ2008810գƶ˹68δ400׸˻Ӿ¼ֻβǴӾ¡Ӿ¼һֱڷչ´1908Ϳʼˣûʲôʵģ㿴ЩƬͻ֪˻ῪĻǰϦĴӾɭⲻȤ</p>\r\n<p>йӾµۣⲻǵһΣҲһΡ2000Ϥ˻ʱİĴӾպĶһϮɫӾװòأӾϵİͻȥ·㡣˺ֲ˵ڶƤ</p>\r\n<p>ΪרҵӾƷƵĴˣѾڱ˻ջ5ķƶ˹˵εø졣Ȼû֮ǰҲڴ¼</p>\r\n<p>ĴǶɭ˵ѹעӾϣͻ˶ԱֵĹע </p>\r\n<p>µӾѡ޸˵ˣӾ¾ɫӾӽӾһ</p>\r\n<p>ء˶Աͻƺʹ</p>\r\n<p>¼˶Աˡһεİ˻ᣬļѵͱΪһ̡˭᲻أóԼ״̬أŮ200ӾƵѡ˵</p>\r\n<p>Ϊѡ֣ΪйӾѡʵְ˻άͻƵıС̹ԣڵ飬ֳգּԿ˷ܣȡúóɼ</p>\r\n<p>ʵЩؼڵӾѵͻƺʹ¡ǰйӾܽһֱǿ¼Ƶƣǿȡѵİǹؼʾͬձˡʽѵֶεġᴿ֤ÿܵѵУһıбǿѵ仰ģǿȵ˶Ҫﵽһأģࡢǿȹܻۻ˶ԱﲻǿĿġ </p><!-- ģ飺 end --><!--  end -->','','1218700520','0');
INSERT INTO `p8_blog_log_article` VALUES ('13','йսȡʤؼۤ Ҧ','0','','0','','0','1','0','1218700615','1218700615','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p>˱Ӯϣйı֮ýԶйۡȷڱ˻ǰУйȻʧܸգֶԣˮƽӣԸеʮ⡣йѾܣСǻǰˣô밲ıһı</p>\r\n<p>ƱƴӮ</p>\r\n<p>СսգйڵBУй밲һܵףʤǰ¹ϣһʤһС</p>\r\n<p>հ˻Сǰ4߽8ǿĹйҪʣµ¹ϣıȡʤܳߡ</p>\r\n<p>ϲ<a class=akey href=\"http://nba.sports.sina.com.cn/star/Yao-Ming.shtml\" target=_blank>Ҧ</a>ָ</p>\r\n<p>ȻܶȦʿΪҦָֻ߳ɹڰ˻ϣҦѾ㹻¡</p>\r\n<p>ǰӵıпԿҦNBAߴĶԿУʱռϷ硣</p>\r\n<p>Ҧûֻ119ļݸĴڣóͻƱɬޱȡ־޴Ա޷ȡģҦ³ȱϵй߱ѡ</p>\r\n<p>֮ͻ</p>\r\n<p>ͨԶܹҦòйӵĽҪȱͻʹйӵĽδʧ߱ϡ</p>\r\n<p>ּлҦֵɽ4Ѽ䲻ϴݣȴӲĵ졣ӵʤΪ׶εıʵ߹֡21ֵ³ϡѶϵ˹أйߵĿռ䣬ҲΪȡ˴ϢĻᡣ</p>\r\n<p>ȡʤؼۤ Ҧ</p>\r\n<p>ҦۤйΨһһܿһ֮ˡǰıۤ»⣬һָУһȾɱɹۤйҵҦ֮ڶеð취</p>\r\n<p>ȻıҦҲһֵ⣬ҪҦ෸棬Ҫڹ˵ѹԱ<a class=akey href=\"http://nba.sports.sina.com.cn/star/Yi-Jianlian.shtml\" target=_blank>׽</a>ҦҪİ֣̫סҪһ¶ʱ״̬ </p><!-- ģ飺 end --><!--  end -->','','1218700615','0');
INSERT INTO `p8_blog_log_article` VALUES ('14','йŮϧܲȫ ʧСһȴܱܰͶ','0','','0','','0','2','0','1218700712','1218700712','1','php168','','0','','0','1','','0','0','0','','','0','1','127.0.0.1','0','','','0','0','0','','<p>йŮСӮ䲻2-3ڹŰŮš̰ŰͶĶʵԽֻҪȶˮƽŰͶӼпȫʤսAһй֮սϧйӻСһĿԴ󽵵͡</p>\r\n<p>ݱα涨Сڶӽͨǩķ֮һĶ֡й֮սʹйŮСһΪӰйӾAڶݻǵݽ븴ѾôҪԭĿĵߴΡƽԻʤҪҲӦѹŮŹ˵δǺ£жСһİйŮںװߵˮƽ</p>\r\n<p><a href=\"http://2008.sina.com.cn/cn/vb/2008-08-11/1442187096.shtml\" target=_blank><font color=#ff0000><strong>ѣֳڸж</strong></font></a><br /></p>\r\n<p>ĿǰСһпйķ֮һĳǩлܿͶ˹ǿݹ涨ֻСڶ͵ǩѾʤڱбֳ˼BһߡȻͬΪʤİǿǿԻδչݸİʤڶ֡</p>\r\n<p>˹ŮǱαбʧӣȻĪŵ޵ĻعԼĴֵĶøöǰͰǿǿԻвҰ˴۾ΪǸöšʵսöӵļȷʵ״̬ǼĪ޺޵״̬˹͵ֵĶʵʤһսάǽֱӾBĹĿǰ״̬άǻܶ˹Ҳ</p>\r\n<p>ŮźͶ˹ŮŷֱλBһ͵ģԵAͷйŮŽķ֮һгɹ֧ܿӡӸСеıBаʵǿ֧ӵĽرá</p>\r\n<p>̭һʤҪӵٳӣйκһ֧齻ֶûбʤİաǵйˣ˹ϸ߶ԣܹάǣйŮŽǿһ¡ </p>\r\n<p>(߼</p><!-- ģ飺 end --><!--  end -->','','1218700731','0');
INSERT INTO `p8_blog_log_sort` VALUES ('1','0','','1','0','0','','0','0','0','','','','','','','1','','','','','0','1','');
INSERT INTO `p8_blog_log_sort` VALUES ('2','0','','1','0','0','','0','0','0','','','','','','','1','','','','','0','1','');
INSERT INTO `p8_blog_log_sort` VALUES ('3','0','','1','0','0','','0','0','0','','','','','','','1','','','','','0','1','');
INSERT INTO `p8_blog_log_sort` VALUES ('4','0','ý','1','0','0','','0','0','0','','','','','','','1','','','','','0','1','');
INSERT INTO `p8_blog_log_sort` VALUES ('5','0','ų','1','0','0','','0','0','0','','','','','','','1','','','','','0','1','');
INSERT INTO `p8_blog_log_sort` VALUES ('6','0','ѧ','1','0','0','','0','0','0','','','','','','','1','','','','','0','1','');
INSERT INTO `p8_blog_log_sort` VALUES ('7','0','ѧ԰','1','0','0','','0','0','0','','','','','','','1','','','','','0','1','');
INSERT INTO `p8_blog_log_sort` VALUES ('8','0','ѧ','1','0','0','','0','0','0','','','','','','','1','','','','','0','1','');
INSERT INTO `p8_blog_log_sort` VALUES ('9','0','Ѷ','1','0','0','','0','0','0','','','','','','','1','','','','','0','1','');
INSERT INTO `p8_blog_music_sort` VALUES ('1','0','','1','0','0','','0','0','0','','','','N;','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;}','');
INSERT INTO `p8_blog_music_sort` VALUES ('2','0','ŵ','1','0','0','','0','0','0','','','','','','1','','','','','0','','');
INSERT INTO `p8_blog_mv_sort` VALUES ('1','0','Ƶ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','','');
INSERT INTO `p8_blog_mv_sort` VALUES ('2','0','Ƶ','1','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;}','0','','');
INSERT INTO `p8_blog_photo_pic` VALUES ('1','»','0','','0','','0','1','0','1218698155','1218698155','1','php168','','0','http://6778.com/wan.ben/hrmm/2chl/06.jpg','1','','0','1','1218699179','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://6778.com/wan.ben/hrmm/2chl/06.jpg','1218698155','','0','','0');
INSERT INTO `p8_blog_photo_pic` VALUES ('2','ԁ','0','','0','','0','2','0','1218698191','1218698191','1','php168','','0','http://6778.com/wan.ben/hrmm/4lyq/02.jpg','1','','0','1','1218699179','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://6778.com/wan.ben/hrmm/4lyq/02.jpg','1218701158','','0','','0');
INSERT INTO `p8_blog_photo_pic` VALUES ('3','','0','','0','','0','1','0','1218698276','1218698276','1','php168','','0','http://6778.com/wan.ben/m2/lxr/11.JPG','0','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://6778.com/wan.ben/m2/lxr/11.JPG','1218698277','','0','','0');
INSERT INTO `p8_blog_photo_pic` VALUES ('4','','0','','0','','0','1','0','1218698413','1218698413','1','php168','','0','http://6778.com/wan.ben/hrmm/38zzy/04.jpg','0','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://6778.com/wan.ben/hrmm/38zzy/04.jpg','1218698414','','0','','0');
INSERT INTO `p8_blog_photo_pic` VALUES ('5','','0','','0','','0','1','0','1218698481','1218698481','1','php168','','0','http://6778.com/wan.ben/hrmm/5ljy/11.jpg','1','php168','1218699039','0','1218699178','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://6778.com/wan.ben/hrmm/5ljy/11.jpg','1218698481','','0','','0');
INSERT INTO `p8_blog_photo_pic` VALUES ('6','±ϼ','0','','0','','0','2','0','1218698522','1218698522','1','php168','','0','http://6778.com/wan.ben/hrmm/37wbx/24.jpg','1','php168','1218699038','0','1218699177','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://6778.com/wan.ben/hrmm/37wbx/24.jpg','1218699852','','0','','0');
INSERT INTO `p8_blog_photo_pic` VALUES ('7','ս','0','','0','','0','1','0','1218700065','1218700065','1','php168','','0','http://i3.sinaimg.cn/blog/1/2008/0306/U2725P503T1D169F1DT20080814092950.jpg','0','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://i3.sinaimg.cn/blog/1/2008/0306/U2725P503T1D169F1DT20080814092950.jpg','1218700066','','0','','0');
INSERT INTO `p8_blog_photo_pic` VALUES ('8','','0','','0','','0','1','0','1218700113','1218700113','1','php168','','0','http://i3.sinaimg.cn/photo/news/2008/0814/aoyun/0814_04.jpg','0','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://i3.sinaimg.cn/photo/news/2008/0814/aoyun/0814_04.jpg','1218700114','','0','','0');
INSERT INTO `p8_blog_photo_sort` VALUES ('1','0','ͨ','1','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;}','0');
INSERT INTO `p8_blog_photo_sort` VALUES ('2','0','','1','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;}','0');
INSERT INTO `p8_blog_photo_sort` VALUES ('3','0','仳','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_blog_photo_sort` VALUES ('4','0','Ȼ羰','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_blog_photo_sort` VALUES ('5','0','ż','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_blog_photo_sort` VALUES ('6','0','ɸЦ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_blog_photo_sort` VALUES ('7','0','ʵ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_blog_photo_sort` VALUES ('8','0','ɫ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_blog_photo_sort` VALUES ('9','0','ҵ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_blog_setting` VALUES ('blogAlbumNum','','');
INSERT INTO `p8_blog_setting` VALUES ('BlogGuestBookYzImg','0','');
INSERT INTO `p8_blog_setting` VALUES ('forbidBlogDomain','admin\r\nbbs','');
INSERT INTO `p8_blog_setting` VALUES ('module_id','7','');
INSERT INTO `p8_blog_setting` VALUES ('module_pre','blog_','');
INSERT INTO `p8_blog_setting` VALUES ('Blog_rollmsg','         Ϣ\r\n    ,ÿûӵһƯĸ˲ϵͳ,ӭע,Լļ԰.','');
INSERT INTO `p8_blog_setting` VALUES ('Blog_style','35cn','');
INSERT INTO `p8_blog_setting` VALUES ('blogDomain','','');
INSERT INTO `p8_blog_setting` VALUES ('group_UpVideo','3,4','');
INSERT INTO `p8_blog_setting` VALUES ('group_UpMusic','3,4','');
INSERT INTO `p8_blog_setting` VALUES ('group_UpPhoto','3,4','');
INSERT INTO `p8_blog_setting` VALUES ('AllowUseBlogUser','','');
INSERT INTO `p8_blog_setting` VALUES ('forbidGroupUseBlog','2','');
INSERT INTO `p8_blog_setting` VALUES ('CreateBlogMoney','','');
INSERT INTO `p8_blog_setting` VALUES ('StopCreateBlog','0','');
INSERT INTO `p8_blog_setting` VALUES ('showBlogToolbar','1','');
INSERT INTO `p8_blog_setting` VALUES ('getBlogAuto','0','');
INSERT INTO `p8_blog_setting` VALUES ('close_blog','0','');
INSERT INTO `p8_blog_setting` VALUES ('blogWebName','Ƶ','');
INSERT INTO `p8_blog_setting` VALUES ('BlogCommentYzImg','0','');
INSERT INTO `p8_channel` VALUES ('1','0','0','վҳ','./','index.php','index.htm','4,2,3','','','','','','','','','','0','a:5:{s:4:\"line\";s:1:\"3\";s:4:\"rows\";s:1:\"8\";s:4:\"leng\";s:2:\"34\";s:5:\"order\";s:4:\"list\";s:8:\"fid_list\";N;}');
INSERT INTO `p8_comment` VALUES ('1','4','2','0','','1218533623','ggggggggggggsdfdgfd','127.0.0.1','0','1');
INSERT INTO `p8_config` VALUES ('yzImgComment','0','');
INSERT INTO `p8_config` VALUES ('flashtime','0','');
INSERT INTO `p8_config` VALUES ('showNoPassComment','0','');
INSERT INTO `p8_config` VALUES ('allowGuestCommentPass','1','');
INSERT INTO `p8_config` VALUES ('forbidComment','0','');
INSERT INTO `p8_config` VALUES ('showCommentRows','8','');
INSERT INTO `p8_config` VALUES ('passport_url','http://5.com/bbs','');
INSERT INTO `p8_config` VALUES ('bencandy_filename','html/{$fid}/{$dirid}/{$id}/{$page}.htm','');
INSERT INTO `p8_config` VALUES ('yzImgAdminLogin','0','');
INSERT INTO `p8_config` VALUES ('showComment','1','');
INSERT INTO `p8_config` VALUES ('yzImgContribute','0','');
INSERT INTO `p8_config` VALUES ('groupPassContribute','3','');
INSERT INTO `p8_config` VALUES ('waterimg','images/default/water.gif','');
INSERT INTO `p8_config` VALUES ('forbidRegName','','');
INSERT INTO `p8_config` VALUES ('yzImgReg','0','');
INSERT INTO `p8_config` VALUES ('forbidRegIp','','');
INSERT INTO `p8_config` VALUES ('yzImgGuestBook','0','');
INSERT INTO `p8_config` VALUES ('MaxOnlineUser','1000','');
INSERT INTO `p8_config` VALUES ('groupPassShopYz','3,4','');
INSERT INTO `p8_config` VALUES ('groupPassPassGuestBook','3','');
INSERT INTO `p8_config` VALUES ('ifOpenGuestBook','1','');
INSERT INTO `p8_config` VALUES ('viewNoPassGuestBook','1','');
INSERT INTO `p8_config` VALUES ('Listsortnameline','2','');
INSERT INTO `p8_config` VALUES ('GuestBookNum','8','');
INSERT INTO `p8_config` VALUES ('ContributeFid','2','');
INSERT INTO `p8_config` VALUES ('list_filename','html/{$fid}/{$page}.htm','');
INSERT INTO `p8_config` VALUES ('groupPassLogYz','3,4','');
INSERT INTO `p8_config` VALUES ('waterpos','9','');
INSERT INTO `p8_config` VALUES ('forbidReg','1','');
INSERT INTO `p8_config` VALUES ('waterAlpha','80','');
INSERT INTO `p8_config` VALUES ('limitRegTime','','');
INSERT INTO `p8_config` VALUES ('deleteArticleMoney','-1','');
INSERT INTO `p8_config` VALUES ('postArticleMoney','1','');
INSERT INTO `p8_config` VALUES ('list_filename2','list.php?fid-{$fid}-page-{$page}.htm','');
INSERT INTO `p8_config` VALUES ('regmoney','','');
INSERT INTO `p8_config` VALUES ('passport_TogetherLogin','0','');
INSERT INTO `p8_config` VALUES ('comArticleMoney','3','');
INSERT INTO `p8_config` VALUES ('hideFid','','');
INSERT INTO `p8_config` VALUES ('guide_word','վҳ|./|0||1\r\nҪͶ|/member/post.php?job=postnew|0||2\r\nÿ|guestbook.php|0||3\r\n|search.php|0||4\r\n|alonepage.php?id=6|0||5\r\n|digg.php|0||6','');
INSERT INTO `p8_config` VALUES ('_Notice','29weSgiaHR0cDovL3d3dy5waHAxNjguY29tL05vdGljZS8/dXJsPSR3ZWJkYlt3d3dfdXJsXSIsUEhQMTY4X1BBVEguImNhY2hlL05vdGljZS5waHAiKTs=','');
INSERT INTO `p8_config` VALUES ('passport_path','pw','');
INSERT INTO `p8_config` VALUES ('is_waterimg','0','');
INSERT INTO `p8_config` VALUES ('if_gdimg','1','');
INSERT INTO `p8_config` VALUES ('JsListRows','5','');
INSERT INTO `p8_config` VALUES ('RegYz','1','');
INSERT INTO `p8_config` VALUES ('cookieDomain','','');
INSERT INTO `p8_config` VALUES ('bokecc_id','','');
INSERT INTO `p8_config` VALUES ('miibeian_gov_cn','ICP05047353','');
INSERT INTO `p8_config` VALUES ('ListSonRows','9','');
INSERT INTO `p8_config` VALUES ('JsListLeng','38','');
INSERT INTO `p8_config` VALUES ('ListSonline','3','');
INSERT INTO `p8_config` VALUES ('ListSonLeng','36','');
INSERT INTO `p8_config` VALUES ('hotArticleNum','100','');
INSERT INTO `p8_config` VALUES ('newArticleTime','24','');
INSERT INTO `p8_config` VALUES ('copyright','ϵʽ:MSN:master@cms168.com :176402848@qq.com QQ3735252964661400 绰020-28319635 棺020-28319635','');
INSERT INTO `p8_config` VALUES ('headGuid','|photo|/photo/\r\nѶ|news|/news/\r\nƵ|movie|/movie/\r\n|download|/download/\r\n|fenlei|/fenlei/\r\n̳|shop|/shop/\r\n|flash|/flash/\r\n|blog|/blog/\r\nȦ|group|/group/','');
INSERT INTO `p8_config` VALUES ('weburl','/','');
INSERT INTO `p8_config` VALUES ('passport_type','','');
INSERT INTO `p8_config` VALUES ('passport_pre','pw_','');
INSERT INTO `p8_config` VALUES ('MailType','smtp','');
INSERT INTO `p8_config` VALUES ('MailServer','smtp.qq.com','');
INSERT INTO `p8_config` VALUES ('MailPort','25','');
INSERT INTO `p8_config` VALUES ('MailId','test@qq.com','');
INSERT INTO `p8_config` VALUES ('MailPw','12345','');
INSERT INTO `p8_config` VALUES ('Money2card','0','');
INSERT INTO `p8_config` VALUES ('tenpay_id','','');
INSERT INTO `p8_config` VALUES ('tenpay_key','','');
INSERT INTO `p8_config` VALUES ('alipay_id','','');
INSERT INTO `p8_config` VALUES ('pay99_id','','');
INSERT INTO `p8_config` VALUES ('pay99_key','','');
INSERT INTO `p8_config` VALUES ('alipay_scale','10','');
INSERT INTO `p8_config` VALUES ('MoneyRatio','100','');
INSERT INTO `p8_config` VALUES ('mymd5','ODmXO0Gafc','');
INSERT INTO `p8_config` VALUES ('DefaultIndexHtml','0','');
INSERT INTO `p8_config` VALUES ('bencandy_filename2','bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm','');
INSERT INTO `p8_config` VALUES ('allowMemberCommentPass','1','');
INSERT INTO `p8_config` VALUES ('allowGuestComment','1','');
INSERT INTO `p8_config` VALUES ('ListLeng','50','');
INSERT INTO `p8_config` VALUES ('listPicRows','5','');
INSERT INTO `p8_config` VALUES ('showsortlogo','0','');
INSERT INTO `p8_config` VALUES ('AvoidGatherPre','','');
INSERT INTO `p8_config` VALUES ('AvoidCopy','0','');
INSERT INTO `p8_config` VALUES ('AvoidGather','0','');
INSERT INTO `p8_config` VALUES ('AvoidSave','0','');
INSERT INTO `p8_config` VALUES ('AvoidGatherString','','');
INSERT INTO `p8_config` VALUES ('ListShowIcon','0','');
INSERT INTO `p8_config` VALUES ('adminPostEditType','html','');
INSERT INTO `p8_config` VALUES ('autoGetSmallPic','1','');
INSERT INTO `p8_config` VALUES ('article_show_step','0','');
INSERT INTO `p8_config` VALUES ('viewNoPassArticle','0','');
INSERT INTO `p8_config` VALUES ('ifContribute','1','');
INSERT INTO `p8_config` VALUES ('allowGuestSearch','0','');
INSERT INTO `p8_config` VALUES ('ForceDel','0','');
INSERT INTO `p8_config` VALUES ('ForbidShowPhpPage','0','');
INSERT INTO `p8_config` VALUES ('kill_badword','0','');
INSERT INTO `p8_config` VALUES ('close_count','0','');
INSERT INTO `p8_config` VALUES ('KeepTodayCount','0','');
INSERT INTO `p8_config` VALUES ('ForbidCountDomain','','');
INSERT INTO `p8_config` VALUES ('ifShowKeyword','0','');
INSERT INTO `p8_config` VALUES ('ShowKeywordColor','#F70968','');
INSERT INTO `p8_config` VALUES ('forbid_show_bug','1','');
INSERT INTO `p8_config` VALUES ('mirror','','');
INSERT INTO `p8_config` VALUES ('upfileMaxSize','','');
INSERT INTO `p8_config` VALUES ('upfileType','.rar .txt .jpg .gif .bmp .png .zip .mp3 .wma .wmv .mpeg .mpg .rm .ram .htm .doc .swf .avi .flv .sql .doc .ppt .xls .chm .pdf','');
INSERT INTO `p8_config` VALUES ('updir','upload_files','');
INSERT INTO `p8_config` VALUES ('totalSpace','100','');
INSERT INTO `p8_config` VALUES ('time','0','');
INSERT INTO `p8_config` VALUES ('NewsMakeHtml','0','');
INSERT INTO `p8_config` VALUES ('MakeIndexHtmlTime','0','');
INSERT INTO `p8_config` VALUES ('admin_url','admin','');
INSERT INTO `p8_config` VALUES ('www_url','http://5.com','');
INSERT INTO `p8_config` VALUES ('style','35cn','');
INSERT INTO `p8_config` VALUES ('close_why','վά,\r\nͣ.','');
INSERT INTO `p8_config` VALUES ('web_open','1','');
INSERT INTO `p8_config` VALUES ('MoneyDW','','');
INSERT INTO `p8_config` VALUES ('MoneyName','վ','');
INSERT INTO `p8_config` VALUES ('UseMoneyType','cms','');
INSERT INTO `p8_config` VALUES ('metakeywords','php168 news bbs board php mysql forums','');
INSERT INTO `p8_config` VALUES ('description','վϵͳ','');
INSERT INTO `p8_config` VALUES ('webmail','admin@admin.com','');
INSERT INTO `p8_config` VALUES ('webname','PHP168վϵͳ','');
INSERT INTO `p8_copyfrom` VALUES ('1','','1','0');
INSERT INTO `p8_copyfrom` VALUES ('2','Ѻ','0','0');
INSERT INTO `p8_count_site` VALUES ('1','0','վͳ','0','0','0');
INSERT INTO `p8_count_stat` VALUES ('1','1','2008','8','33','12','0','325','1','1','','','','','');
INSERT INTO `p8_count_stat` VALUES ('2','1','2008','8','33','13','0','25','2','2','','','','','');
INSERT INTO `p8_count_stat` VALUES ('3','1','2008','8','33','14','0','105','1','1','','','','','');
INSERT INTO `p8_count_stat` VALUES ('4','1','2008','8','33','15','0','82','1','1','','','','','');
INSERT INTO `p8_count_user` VALUES ('5','1','15','php168','1218778165','127.0.0.1','','','http://5.com/','http://5.com/','Windows XP','IE 6.0','zh-cn','1280*800','82');
INSERT INTO `p8_down_config` VALUES ('module_id','9','');
INSERT INTO `p8_down_config` VALUES ('Down_list_filename2','list.php?fid-{$fid}-page-{$page}.htm','');
INSERT INTO `p8_down_config` VALUES ('Down_bencandy_filename2','bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm','');
INSERT INTO `p8_down_config` VALUES ('Down_NewsMakeHtml','0','');
INSERT INTO `p8_down_config` VALUES ('guide_word1','ҳ|./\r\n|search.php\r\n|member/?main=post.php?job=postnew\r\nվҳ|/','');
INSERT INTO `p8_down_config` VALUES ('Down_rollpic','','');
INSERT INTO `p8_down_config` VALUES ('guide_word2','빤|list.php?fid=103\r\nͼ|list.php?fid=116\r\nϷ|list.php?fid=59\r\nϵͳ|list.php?fid=104\r\nɷ|list.php?fid=159\r\nҽҩ|list.php?fid=80\r\n|list.php?fid=18\r\nƵת|list.php?fid=35\r\n|list.php?fid=21\r\nݱ|list.php?fid=96\r\nļ|list.php?fid=5\r\nѹѹ |list.php?fid=14','');
INSERT INTO `p8_down_config` VALUES ('guide_word3','繲|list.php?fid=66\r\nʼȺ|list.php?fid=77\r\nع|list.php?fid=70\r\n|list.php?fid=71\r\nԶ̼|list.php?fid=100\r\n|list.php?fid=87\r\n|list.php?fid=49\r\nĶ|list.php?fid=125\r\nת|list.php?fid=130\r\nɱ|list.php?fid=189\r\nƱ|list.php?fid=33\r\nƱ֤ȯ|list.php?fid=95\r\nѧϰ|list.php?fid=76','');
INSERT INTO `p8_down_config` VALUES ('Down_bencandy_filename','html/{$fid}/{$dirid}/{$id}/{$page}.htm','');
INSERT INTO `p8_down_config` VALUES ('Down_list_filename','html/{$fid}/{$page}.htm','');
INSERT INTO `p8_down_config` VALUES ('group_UpSoft','3,4,8,9','');
INSERT INTO `p8_down_config` VALUES ('FlashGet_ID','','');
INSERT INTO `p8_down_config` VALUES ('XunLei_ID','','');
INSERT INTO `p8_down_config` VALUES ('module_pre','down_','');
INSERT INTO `p8_down_config` VALUES ('memberPost','1','');
INSERT INTO `p8_down_config` VALUES ('postPassYz','3,4,8,9','');
INSERT INTO `p8_down_config` VALUES ('Down_style','35cn','');
INSERT INTO `p8_down_config` VALUES ('Down_listleng','40','');
INSERT INTO `p8_down_config` VALUES ('Down_statetime','5','');
INSERT INTO `p8_down_config` VALUES ('Down_listRow','8','');
INSERT INTO `p8_down_config` VALUES ('Down_indexleng','36','');
INSERT INTO `p8_down_config` VALUES ('Down_closeWhy','վά,ͣ','');
INSERT INTO `p8_down_config` VALUES ('Down_indexrows','8','');
INSERT INTO `p8_down_config` VALUES ('Down_webOpen','1','');
INSERT INTO `p8_down_config` VALUES ('Down_url','','');
INSERT INTO `p8_down_config` VALUES ('Down_metakeywords',' ƽ ɫ','');
INSERT INTO `p8_down_config` VALUES ('Down_webname','Ƶ','');
INSERT INTO `p8_down_config` VALUES ('Down_type','Down_local,XunLei','');
INSERT INTO `p8_down_gather_rule` VALUES ('1','article','article','','վ -> ý - ý岥','http://www.skycn.com/sort/sort2060100_indate_DESC_[page].html','','1','3','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\"<tr><th>Ƽȼ</th><td>\",\"<tr><th>ش</th><td>168</td></tr><tr><th>Ƽȼ</th><td>\",$htmlcode);','','','','','','','','0','1185286909','1185286950','0','0','','0','0','','','','0','','bsp;<a href=\"{url=NO\"}\"><strong>{title=NO<}</strong></a>&nb','<tr><th>С</th><td>{softsize=NO\'\"<>}</td></tr><tr><th>ԣ</th><td>{softlanguage=NO\'\"<>}</td>{*}<tr><th>Ӧƽ̨</th><td>{operatingsystem=NO\'\"<>}</td></tr>{*}<tr><th>ʱ䣺</th><td>{posttime=NO\'\"<>}</td></tr><tr><th>ش</th><td>{loadnum=NO\'\"<>}</td></tr>{*}<div>&nbsp;&nbsp;{content=*}</div>{*}<img src=\"../images/pic_down.gif\" width=\"14\" height=\"14\"></td><td><a href=\"{downloadurl=NO\'\"<>}\" target=\"_blank\">','','','0');
INSERT INTO `p8_down_gather_rule` VALUES ('2','article','article','','վ -> ý - Ƶ','http://www.skycn.com/sort/sort2060300_indate_DESC_[page].html','','1','3','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\"<tr><th>Ƽȼ</th><td>\",\"<tr><th>ش</th><td>168</td></tr><tr><th>Ƽȼ</th><td>\",$htmlcode);','','','','','','','','0','1185286909','1185286950','0','0','','0','0','','','','0','','bsp;<a href=\"{url=NO\"}\"><strong>{title=NO<}</strong></a>&nb','<tr><th>С</th><td>{softsize=NO\'\"<>}</td></tr><tr><th>ԣ</th><td>{softlanguage=NO\'\"<>}</td>{*}<tr><th>Ӧƽ̨</th><td>{operatingsystem=NO\'\"<>}</td></tr>{*}<tr><th>ʱ䣺</th><td>{posttime=NO\'\"<>}</td></tr><tr><th>ش</th><td>{loadnum=NO\'\"<>}</td></tr>{*}<div>&nbsp;&nbsp;{content=*}</div>{*}<img src=\"../images/pic_down.gif\" width=\"14\" height=\"14\"></td><td><a href=\"{downloadurl=NO\'\"<>}\" target=\"_blank\">','','','0');
INSERT INTO `p8_down_gather_rule` VALUES ('3','article','article','','ɫ -> ϵͳ -> ̹','http://www.xdowns.com/soft/6/7/Soft_007_[page].html','http://www.xdowns.com/soft/6/7/index.html','1','3','1','0','','','<','','','','','','','0','','','<img src=\"/skin/xdowns/icon_downloadserver.gif\" border=0> <a href=\"{downloadurl=NO\'\"<>}\"  target=\"_blank\">','','','','','','0','1185367013','1185367246','0','0','','0','0','','','','0','','<li class=\"softname\"><a href=\'{url=NO\'}\' title=\'{title=NO\'}\' class=showtopic>{*}</a></li>','<div class=\"co5l\">\r\n<ul>\r\n<li>С{softsize=NO\'\"<>}</li>\r\n<li>ͣ{*}</li>\r\n<li>л{operatingsystem=NO\'\"<>}</li>\r\n<li>ԣ{softlanguage=NO\'\"<>} </li>\r\n<li>{*}</li>\r\n<li>ʱ䣺{posttime=NO\'\"<>} </li>{*}<div class=\"co_content6\">{content=*}</div></div>\r\n<!--}end:-->{*}<a href=\"{pageurl=NO\'\"<>}\"  target=\"_blank\"><img src=\"/skin/xdowns/download.gif\" border=0 alt=\"','','','0');
INSERT INTO `p8_down_gather_rule` VALUES ('4','article','article','','ɫ ->  Ӧ -> ','http://www.xdowns.com/soft/4/49/Soft_049_[page].html','http://www.xdowns.com/soft/4/49/index.html','1','3','1','0','','','<','','','','','','','0','','','<img src=\"/skin/xdowns/icon_downloadserver.gif\" border=0> <a href=\"{downloadurl=NO\'\"<>}\"  target=\"_blank\">','','','','','','0','1185367013','1185367246','0','0','','0','0','','','','0','','<li class=\"softname\"><a href=\'{url=NO\'}\' title=\'{title=NO\'}\' class=showtopic>{*}</a></li>','<div class=\"co5l\">\r\n<ul>\r\n<li>С{softsize=NO\'\"<>}</li>\r\n<li>ͣ{*}</li>\r\n<li>л{operatingsystem=NO\'\"<>}</li>\r\n<li>ԣ{softlanguage=NO\'\"<>} </li>\r\n<li>{*}</li>\r\n<li>ʱ䣺{posttime=NO\'\"<>} </li>{*}<div class=\"co_content6\">{content=*}</div></div>\r\n<!--}end:-->{*}<a href=\"{pageurl=NO\'\"<>}\"  target=\"_blank\"><img src=\"/skin/xdowns/download.gif\" border=0 alt=\"','','','0');
INSERT INTO `p8_down_gather_rule` VALUES ('5','article','article','','йվվ>> PHPԴ >> ̳','http://down.chinaz.com/L/44_Lastuptime_Desc_[page].asp','','1','3','1','0','','','<','','','','','','','0','','','','','','','','','0','1185372119','1185372233','0','0','','0','0','','','','0','','<tr bgcolor=\"#FFFFFF\"> \r\n          <td width=\"420\"> <a href=\"{url=NO\"}\"><b>{title=NO<}</b></a></td>\r\n          <td align=\"center\" nowrap>','<tr>\r\n              <td align=\"center\" width=\"70\" height=\"20\">л</td>\r\n              <td width=\"240\" height=\"20\">{operatingsystem=NO\'\"<>}</td>\r\n            </tr>{*}<tr>\r\n              <td align=\"center\" width=\"70\" height=\"20\">Ȩʽ</td>\r\n              <td width=\"240\" height=\"20\">{copyright=NO\'\"<>}</td>\r\n            </tr>{*}<td align=\"center\" width=\"70\" height=\"20\">С</td>\r\n              <td width=\"240\" height=\"20\">{softsize=NO\'\"<>} \r\n\r\n<form name=\"testtime\" style=\"display:inline\">{*}<td align=\"center\" width=\"70\" height=\"20\">ʱ䣺</td>\r\n              <td width=\"240\" height=\"20\">{posttime=NO\'\"<>}</td>\r\n            </tr>\r\n\r\n{*}\r\n<a href=../Downvip.asp><img src=../images/d/vip.gif border=0></a>\r\n <a href=\'{downloadurl=NO\'\"<>}\' target=\'_blank\' >\r\n{*}\r\n<font style=\"line-height:160%\">{content=*}</font><br>','','','0');
INSERT INTO `p8_down_gather_rule` VALUES ('6','article','article','','йվվ>> PHPԴ >> ̳','http://down.chinaz.com/L/43_Lastuptime_Desc_[page].asp','','1','3','1','0','','','<','','','','','','','0','','','','','','','','','0','1185372119','1185372233','0','0','','0','0','','','','0','','<tr bgcolor=\"#FFFFFF\"> \r\n          <td width=\"420\"> <a href=\"{url=NO\"}\"><b>{title=NO<}</b></a></td>\r\n          <td align=\"center\" nowrap>','<tr>\r\n              <td align=\"center\" width=\"70\" height=\"20\">л</td>\r\n              <td width=\"240\" height=\"20\">{operatingsystem=NO\'\"<>}</td>\r\n            </tr>{*}<tr>\r\n              <td align=\"center\" width=\"70\" height=\"20\">Ȩʽ</td>\r\n              <td width=\"240\" height=\"20\">{copyright=NO\'\"<>}</td>\r\n            </tr>{*}<td align=\"center\" width=\"70\" height=\"20\">С</td>\r\n              <td width=\"240\" height=\"20\">{softsize=NO\'\"<>} \r\n\r\n<form name=\"testtime\" style=\"display:inline\">{*}<td align=\"center\" width=\"70\" height=\"20\">ʱ䣺</td>\r\n              <td width=\"240\" height=\"20\">{posttime=NO\'\"<>}</td>\r\n            </tr>\r\n\r\n{*}\r\n<a href=../Downvip.asp><img src=../images/d/vip.gif border=0></a>\r\n <a href=\'{downloadurl=NO\'\"<>}\' target=\'_blank\' >\r\n{*}\r\n<font style=\"line-height:160%\">{content=*}</font><br>','','','0');
INSERT INTO `p8_down_software` VALUES ('1','վϵͳv5.0ʽ','4','վ','0','','0','1','0','1218709700','1218709700','1','php168','','0','','0','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','','<table class=about_p8 cellSpacing=0 cellPadding=0 width=\"98%\" align=center border=0>\r\n<tbody>\r\n<tr>\r\n<td class=about_p8_td1>Զ</td></tr>\r\n<tr>\r\n<td class=about_p8_td2>Աں̨ɴָıȵȡÿԱԶֶûд</td></tr></tbody></table>\r\n<table class=about_p8 cellSpacing=0 cellPadding=0 width=\"98%\" align=center border=0>\r\n<tbody>\r\n<tr>\r\n<td class=about_p8_td1>Զģ͹</td></tr>\r\n<tr>\r\n<td class=about_p8_td2>¹ܣѾ㲻淢չĻ2008վϵͳԶģ͹Ӧ˶ɫڣÿĿԷģ͵ݣƷ⡢ϢϢƸϢȵȣЩģͶǿɴġͿʹĳĿ÷ḻʣǵˡ</td></tr></tbody></table>\r\n<table class=about_p8 cellSpacing=0 cellPadding=0 width=\"98%\" align=center border=0>\r\n<tbody>\r\n<tr>\r\n<td class=about_p8_td1>ļ</td></tr>\r\n<tr>\r\n<td class=about_p8_td2>ÿԱɴԼļҲר⣬ԱԹԱָɫר⡣ÿƪ¿Թڶר⡣ͳֵķѵĻ뻥ԡ</td></tr></tbody></table>\r\n<table class=about_p8 cellSpacing=0 cellPadding=0 width=\"98%\" align=center border=0>\r\n<tbody>\r\n<tr>\r\n<td class=about_p8_td1>ϵͳ۹湦</td></tr>\r\n<tr>\r\n<td class=about_p8_td2>ϵͳǶԭϵͳĹǿûԼ棬ѵǵ㿨㿨ҪֵģͿΪվʵִӪ۹ӵĹܣûûֹλѵĻԽԽǰͿԺܺõûѻ׬ȡ֡</td></tr></tbody></table>\r\n<div id=about_p8>\r\n<table class=about_p8 cellSpacing=0 cellPadding=0 width=\"98%\" align=center border=0>\r\n<tbody>\r\n<tr>\r\n<td class=about_p8_td1>,¾ٱ,ղؼ,Ƽ</td></tr>\r\n<tr>\r\n<td class=about_p8_td2>ղؼзûղԼȤ£͡ٱƼڻԵĹܣԱЭԱѡɾõ¡</td></tr></tbody></table>\r\n<table class=about_p8 cellSpacing=0 cellPadding=0 width=\"98%\" align=center border=0>\r\n<tbody>\r\n<tr>\r\n<td class=about_p8_td1>û빦</td></tr>\r\n<tr>\r\n<td class=about_p8_td2>ӲԷ࣬һû룬ͬʱɿЩҳʾԿĳǿΪַʽʾ</td></tr></tbody></table>\r\n<table class=about_p8 cellSpacing=0 cellPadding=0 width=\"98%\" align=center border=0>\r\n<tbody>\r\n<tr>\r\n<td class=about_p8_td1>ԶͶƱ</td></tr>\r\n<tr>\r\n<td class=about_p8_td2>ɴͶƱÿͶƱԶѡÿͶƱѡӦһͶƱťһƱʾô룬ͶƱťƱʾ뵽õͶƱҳ棬ʵַǳͼβïͶƱרҳ档</td></tr></tbody></table>\r\n<table class=about_p8 cellSpacing=0 cellPadding=0 width=\"98%\" align=center border=0>\r\n<tbody>\r\n<tr>\r\n<td class=about_p8_td1>ʼȺ,ϢȺ</td></tr>\r\n<tr>\r\n<td class=about_p8_td2>ʼȺҪһ䣬һ㽨QQ䣬ú󣬼ɸվԱȺʼϢܿʵ̳ĶϢͨѹܡ</td></tr></tbody></table>\r\n<table class=about_p8 cellSpacing=0 cellPadding=0 width=\"98%\" align=center border=0>\r\n<tbody>\r\n<tr>\r\n<td class=about_p8_td1>ܾ̬ҳ</td></tr>\r\n<tr>\r\n<td class=about_p8_td2>ûʱԶҳбҳ̬ҳûɾʱԶɾû޸ʱԶ޸ģԱˣɾ޸ģƶöȵȲʱҲԶӦĴ</td></tr></tbody></table>\r\n<table class=about_p8 cellSpacing=0 cellPadding=0 width=\"98%\" align=center border=0>\r\n<tbody>\r\n<tr>\r\n<td class=about_p8_td1>ûġ̨һĽ</td></tr>\r\n<tr>\r\n<td class=about_p8_td2>ǰ̨ų̂ڽԻ涼˺ܴĸĽΪԺܵûװƵ˺ܴı</td></tr></tbody></table>\r\n<table class=about_p8 cellSpacing=0 cellPadding=0 width=\"98%\" align=center border=0>\r\n<tbody>\r\n<tr>\r\n<td class=about_p8_td1>ǰ̨¹ܽһǿ</td></tr>\r\n<tr>\r\n<td class=about_p8_td2>ǰ̨ɿοԱֻʹĳЩѡǷԷҳǷշѵȵȣһԱǰ̨ҳ£ҲͿԺܷʵС˵عܡվ˺ܴչԡͬʱɿЩûҪ֤룬ȵ</td></tr></tbody></table>\r\n<table class=about_p8 cellSpacing=0 cellPadding=0 width=\"98%\" align=center border=0>\r\n<tbody>\r\n<tr>\r\n<td class=about_p8_td1>ϸڵ빦ǿ</td></tr>\r\n<tr>\r\n<td class=about_p8_td2>ӹؼֹԶɼҳûȨ޽˸ϸĻ֡Դַ⡢ʾҳǩܵĽһơҳӴӡСлȵ</td></tr></tbody></table></div>','','http://down2.php168.com/v2008.zip','6.83MB','','','','','Ѱ','Linux/9x/NT/2000/2003/XP/PHP','','0','0','','1218709702','0','0','0','0','1218709555','0','0');
INSERT INTO `p8_down_software` VALUES ('2','ϵͳ','4','վ','0','','0','0','0','1218709823','1218709823','1','php168','','0','','0','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','','<p><font color=#ff0000><b>A.ΪʲôҪϵͳ?</b></font><br />1.ͬʱװ,ÿƵװһ,ͿԴļݿѹ<br />2.Է,ÿƵһFTP,Ƶ,ʺϴŻվҪ<br />3.ƵࡢҪƵȨ޵ĻȵȣҪ<br /><font color=#ff0000><b>B.ɫ</b></font><br />1.԰װ<br />2.ֲ֧ɼ<br />3.ɾ̬ҳ<br />4.Ŀ޼<br />5.ֱ֧ǩ䷽<br />6.֧ԶӻɾֶΣԸϵͳ<br /><font size=+0><b>̫,һһ˵,</b></font><br /></p>','','http://down2.php168.com/module/wnarticle.rar','1.14MB','','','','','Ѱ','Linux/NT/2000/2003/XP/PHP','','0','0','','0','0','0','0','0','1218709749','0','0');
INSERT INTO `p8_down_software` VALUES ('3','Ϣϵͳ','4','վ','0','','0','0','0','1218709890','1218709890','1','php168','','0','','0','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','','<table cellSpacing=0 cellPadding=0 width=\"100%\" border=0>\r\n<tbody>\r\n<tr>\r\n<td align=middle width=\"4%\"></td>\r\n<td vAlign=top align=left width=\"96%\">\r\n<table cellSpacing=0 cellPadding=0 width=\"100%\" border=0>\r\n<tbody>\r\n<tr>\r\n<td id=introduce align=left><font color=#ff0000><b>A.</b></font><br />1.֧޼࣬ⴴģ飬ר⡢ࡢĿĿ䷽ݷḻĴͷϢŻվ<br />2ϢͼƬϴܣԱϴͼƬҲֱӵԶͼƬ<br />3ȫʽϢϵͳûҪעԱɷϢ񷢲ϢĻԡ<br />4.Զ·Ϣ費Ҫˣɶδ˵Ϣûɶ·ϢǷԶͨ˻Ƽ<br />5.AJAXʵˢ۹ܣ۷Ϣˢҳʡûʱ䡣<br />6аĿ¼ּܣֻҪĿ¼ҳ𼶵ͿԼϢĿ¼޷ּ<br />7ϢʱȺ˳򣬰·ϢͳƳγ[Ϣ]Ŀ<br />8ϢܣϢĵߵϢͳƳγ[Ϣ]Ŀ<br />9Զ¼ÿϢķʴ<br />10Ա̨ԶԷϢ޸Ļɾȱ༭ܡ<br />11ŻҳȵԶ壬֧α̬˱¼Ļʡ<br />12.֧ҳɾ̬ṩٶȡ<br />13.۹ܣ֧ۣԶϢǷԶͨˡ<br />14..Ϣʵǰ׹,ǰĻ,ǰĳϢǰ,׵Ļ,ʵֳ׵ĳϢ棬ȻҲǰ,<br />15..վϵͳͼϵͳƵϵͳϵͳϵͳ̳ϵͳϵͳFLASHϵͳ޺ϣͨǩܿɵκѾϵͳݡ<br />16..ıǩԶ幦,ֻҪhtmlģ$label[abc]ıǩ,ں̨κβģݡ<br />17.ִ֧Ϳӻֱ༭ʽ뷽ʽȽϼ,ʡݿռ䡣<br />18.ɹرջ򿪷ŷϢϵͳ,Ϣرԭ˵<br />19.ĻĿáĿںֱ̨ãҪ޸ģ档<br />20.ֺ̨֧дվƣվַ<br /><font color=#ff0000><b>B.ƵĻԱ</b></font><br />ԱԷΪͬĻԱ飬ԸͬĻԱ鶨岻ͬȨޡ磺ͨԱ顢VIPԱ顣<br />ɶĳЩϢָֻû鿪ţǸû鲻ɼ磺ûϵϢοͿš<br />ɶעἴɷϢܷͼƬɶδעԱϢǷҪԱˡ<br />δעûϢܶԸϢ޸ĺɾ<br />3.ûԱӵжû.Ϊǰ̨ĹչºܴĽӿڡ<br />ԱɷΪȼĹԱ磺ĿԱרԱ<br /><font color=#ff0000><b>C.չǿĸ߼</b></font><br />1.ֶԶ幦ܣԸݲͬ͵Ϣ岻ֶͬΡ<br />2.ģԶ幦ܣԸݲͬ͵ķඨ岻ͬģ顣<br />3.רԶ壺ɸݲͬ岻ͬķϢ<br />4.ǩԶ幦ܣ䷽ƣʹǲҲܿƳ۴󷽵ķ<br />5.Զ棺ԶκһֶΪ֧͡ģϢ㡢׼ȷȫվϢ㡢׼ȷ<br />6.ְ֧һ<br /><font size=+0><b>̫,һһ˵,</b></font><br /></td></tr></tbody></table></td></tr></tbody></table>','','http://down2.php168.com/module/wnfenlei.rar','739KB','','','','','Ѱ','Linux/2000/2003/XP/PHP','','0','0','','0','0','0','0','0','1218709828','0','0');
INSERT INTO `p8_down_software` VALUES ('4','ͼƬϵͳ','4','վ','0','','0','0','0','1218709957','1218709957','1','php168','','0','','0','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','','<p><font color=#ff0000><b>A </b></font><br />1.֧޼࣬ⴴࡢĿĿ䷽ݷḻĴͼվ<br />2.ҳбҳҳֱ֧ǩ,ֻҪhtmlģ$label[abc]ıǩ,ں̨κͼģݡ<br />3.֧ͼɶͼΪͼͼ<br />4.֧ϴʹURLַַʽƬ<br />5.δ˵ͼƬûͼƬǷԶͨ˻Ƽ<br />6.ͼƬٴȷϹܣԱĲ.<br />7.AJAXʵˢ۹ܣͼƬˢҳʡûʱ䡣<br />8.ͼƬʵǰ׹,ǰĻ,ǰĳͼƬǰ,׵Ļ,ʵֳ׵ĳͼƬ棬ȻҲǰ,<br />9.վϵͳFLASHϵͳƵϵͳϵͳϵͳ̳ϵͳϵͳϢϵͳ޺ϣͨǩܿɵκѾϵͳݡ<br />10.ûȨ޹ܣָĳЩûſԿͼƬĹܣĳЩû鲻ͼƬ<br />11.ǰ̨ԱܣʹҵҪĻԱϡ<br />12.ͼƬܣʹҵҪͼƬ<br /><font color=#ff0000><b>B.Իĺ̨ƶ</b></font><br />1.ùرպͿͼ,ͼرԭ<br />2.ҳʾãĿõƬںֱ̨ãҪ޸ģ档<br />3.̨ǩñǩҪõݻձǩá<br />4.ͼƬԶ⣬ֻҪͼƬĿ¼վĿ¼upload_filesߣͿһύͼƬĿ.<br />5.۹ܣǷ֤ͨ<br />6.ɼӡɾ롢ɼ<br />7.̬ҳбҳҳɾ̬ɾ̬ҳ<br />8.ɸݾǾˡˣͼƬֱؼֽͼƬݹ<br />9.ͼƬƼȡƼ<br />10.ԻĻԱǰ̨ͼƬԱҪ鷳ĵ½ֱ̨ǰ̨ͿԷɾͼƬ޸ͼƬݡ<br />11.̨ҳȵؼʣȵؼ¼ǳؼġ<br /><font color=#ff0000><b>C.ɫ</b></font><br />1.ͼƬɼܣһ˲Ϳ԰վͼƬɼԼվϡϵͳԴ˶ɼ<br />2.еͼƬ⹦ܣ㲻ҪһһŵķͼƬֻҪһύͿ԰ͼƬɷ<br />3.ıǩɴɫͼվ<br />4.֧α̬α̬¼ʡ<br />5.Զ徲̬ҳĿ¼ʵÿĿԶԾ̬ҳĿ¼.߸ԡ<br /><font size=+0><b>̫,һһ˵,</b></font><br /></p>','','http://down2.php168.com/module/photo.rar','431KB','','','','','Ѱ','PHP/2003/2000/NT/9x/Linux','','0','0','','0','0','0','0','0','1218709892','0','0');
INSERT INTO `p8_down_software` VALUES ('5','Ƶϵͳ','4','վ','0','','0','0','0','1218710077','1218710077','1','php168','','0','','0','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','','<p><font color=#ff0000><b>A </b></font><br />1.֧޼࣬ⴴࡢĿĿ䷽ݷḻĴƵվ<br />2.ҳбҳҳֱ֧ǩ,ֻҪhtmlģ$label[abc]ıǩ,ں̨κƵģݡ<br />3.ͬʱɶƵˡöƼ<br />4.֧ϴʹURLַַʽƵ<br />5.ֶ֧Ƶʽaviwmvrmswfflvmp3wma<br />6.δ˵ƵûƵǷԶͨ˻Ƽ<br />7.ƵٴȷϹܣԱĲ<br />8.AJAXʵˢ۹ܣƵˢҳʡûʱ䡣<br />9.Ƶʵǰ׹,ǰĻ,ǰĳһƵǰ,׵Ļ,ʵֳ׵ĳһƵ棬ȻҲǰ,<br />10.վϵͳͼϵͳFLASHϵͳϵͳϵͳ̳ϵͳϵͳϢϵͳ޺ϣͨǩܿɵκѾϵͳݡ<br />11.ûȨ޹ܣָĳЩûſƵĹܣĳЩû鲻Ƶ<br />12.ǰ̨ԱܣʹҵҪĻԱϡ<br />13.ƵܣʹҵҪƵ<br /><font color=#ff0000><b>B.Իĺ̨ƶ</b></font><br />1.ùرպͿƵ,Ƶرԭ<br />2.ĻĿáĿںֱ̨ãҪ޸ģ档<br />3.̨ǩñǩҪõݻձǩá<br />4.۹ܣǷ֤ͨ<br />5.ɼӡɾ롢ɼ<br />6.̬ҳбҳҳɾ̬ɾ̬ҳ<br />7.ɸݾǾˡˣͼƬֱؼֽͼƬݹ<br />8.ƵƼȡƼ<br />9.̨ҳȵؼʣȵؼ¼ǳؼġվơ<br /><font color=#ff0000><b>C.ɫ</b></font><br />1.Ƶɼܣһ˲Ϳ԰վƵɼԼվϡϵͳԴ˶ɼ<br />2.еƵܣ㲻ҪһһķƵһԷƵ<br />3.ıǩɴɫƵվ<br />4.֧α̬α̬¼ʡ<br />5.Զ徲̬ҳĿ¼ʵÿĿԶԾ̬ҳĿ¼.߸ԡ<br /><font size=+0><b>̫,һһ˵,</b></font><br /></p>','','http://down2.php168.com/module/mv.rar','400KB','','','','','Ѱ','Linux/9x/NT/2000/2003/XP/PHP','','0','0','','0','0','0','0','0','1218709959','0','0');
INSERT INTO `p8_down_software` VALUES ('6','ϵͳ','4','վ','0','','0','1','0','1218710201','1218710201','1','php168','','0','','0','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','','<table cellSpacing=0 cellPadding=0 width=\"100%\" border=0>\r\n<tbody>\r\n<tr>\r\n<td align=middle width=\"4%\"></td>\r\n<td vAlign=top align=left width=\"96%\">\r\n<table cellSpacing=0 cellPadding=0 width=\"100%\" border=0>\r\n<tbody>\r\n<tr>\r\n<td id=introduce align=left>\r\n<p><font color=#ff0000><b>A </b></font><br />1.־ᡢۡԡ˼顢һĸҳϵͳöĶʡ<br />2.֧޼࣬ⴴࡢĿĿ䷽ݷḻĴͲŻվ<br />3.ҳֱ֧ǩ,ֻҪhtmlģ$label[abc]ıǩ,ں̨κβģݡ<br />4.ǳǿȨ,ָĳЩûʹò͹ܡ<br />5.־ѡ뷽ʽӻʽ뷽ʽȽϼ,ʡݿռ䡣<br />6.δ˵־ƬǷû־ƬǷԶͨ˻Ƽ<br />7.AJAXʵˢ۹ܣ־ˢҳʡûʱ䡣<br />8.־Ƭʵǰ׹,ǰĻ,ǰĳƪ־Ƭǰ,׵Ļ,ʵᵽĳƪ־Ƭ棬ȻҲǰ,<br />9.վϵͳFLASHϵͳƵϵͳͼϵͳϵͳ̳ϵͳϵͳϢϵͳ޺ϣͨǩܿɵκѾϵͳݡ<br />10.־ͼƬܣʹҵҪ־ͼƬ<br />11.ͳƷʼ¼ģ鹦ܣοͻǻԱʹĲ,ᱻ¼,ԱɵôģǷڸ˲ҳʾ.<br /><font color=#ff0000><b>B.Իĺ̨ƶ</b></font><br />1.ùرպͿŲ<br />2.ûԱעԶֶ͡<br />3.ǰ̨ǷʾҳToolbar()<br />4.ɽֹĳһûʹò͹ܡ<br />5.ûãɱĳЩû롣wwwbbsmusicȵ<br />6.޸ķģֱں̨Ϳǰ̨ʾ<br />7.ɸݾǾˡˣ־Ƭֱؼֽ־Ƭݹ<br />8.ԱƼȡƼ<br />9.ԻĻԱǰ̨ܣԱҪ鷳ĵ½ֱ̨ǰ̨ͿԹøҳ<br /><font color=#ff0000><b>C.ɫ</b></font><br />1.ԵṦܣ֧ϴʹURLַַʽƬľʱ̶Ϊ㡣<br />2.ѶܣֻҪӵһͷַ֧ͿĻԱɫĸ<br />3.ԱģԶ幦ܣԱøҳĳЩģʾĳЩʾ<br />4.һĻԱԶ幦ܣ֧չԱʲôϾʲôϡ<br />5.ɫķģ飬ϵͳṩ˶׸ɫķģ档Աͨ߼޸DIYԵķ<br />6.ʱСԻķģ顢Զ幦ܡûͨصģ鸡ܣ϶ģ鵽ͬĵطﵽԻĲЧ<br />7.ӻĲֹܣлģ϶ʱЧ󷽱ҴԻҳ֡<br />8.ҳͷ˵Զ壬޸ĵ˵ɾӵ˵<br /><font size=+0><b>̫,һһ˵,</b></font><br /></p></td></tr></tbody></table></td></tr></tbody></table>','','http://down2.php168.com/module/blog.rar','3.13MB','','','','','Ѱ','Linux/2000/2003/NT/9x/PHP','','0','0','','1218722980','0','0','0','0','1218710093','0','0');
INSERT INTO `p8_down_software` VALUES ('7','̳ϵͳ','4','վ','0','','0','0','0','1218710290','1218710290','1','php168','','0','','0','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','','<table cellSpacing=0 cellPadding=0 width=\"100%\" border=0>\r\n<tbody>\r\n<tr>\r\n<td align=middle width=\"4%\"></td>\r\n<td vAlign=top align=left width=\"96%\">\r\n<table cellSpacing=0 cellPadding=0 width=\"100%\" border=0>\r\n<tbody>\r\n<tr>\r\n<td id=introduce align=left>\r\n<p><font color=#ff0000><b>A </b></font><br />1.۶ۡԡƷ顢һ̳ϵͳɰһ<br />2.֧޼࣬ⴴࡢĿĿ䷽ݷḻĴ͹վ<br />3.ҳֱ֧ǩ,ֻҪhtmlģ$label[abc]ıǩ,ں̨κģݡ<br />4.ǳǿȨ,ָĳЩûܷƷ<br />5.Ʒѡ뷽ʽӻʽ뷽ʽȽϼ,ʡݿռ䡣<br />6.δ˵ƷǷûƷǷԶͨ˻Ƽ<br />7.AJAXʵˢ۹ܣƷˢҳʡûʱ䡣<br />8.Ʒʵǰ׹,ǰĻ,ǰĳƷǰ,׵Ļ,ʵֳĳƪƷ棬ȻҲǰ,<br />9.վϵͳFLASHϵͳƵϵͳͼϵͳϵͳϵͳϵͳϢϵͳ޺ϣͨǩܿɵκѾϵͳݡ<br />10.ƷܣʹҵҪƷ<br />11.˿Ͷѯܣ˿ͿԸ¶ʱõĶŲѯ״̬<br />12.֧ҳɾ̬߷ٶȡ<br /><font color=#ff0000><b>B.Իĺ̨ƶ</b></font><br />1.ùرպͿ̳ϵͳ,̳ǹرԭ<br />2.ԻĿáĿںֱ̨ãҪ޸ģ档<br />3.̨ǩñǩҪõݻձǩá<br />4.Ʒ۹ܣǷ֤ͨ<br />5.ɾ鿴˿ϵʽͷʽ֧ʽƷȷϷ<br />6.ɸݾǾˡˣƷֱƷûIDܡ߿ҵҪƷ<br />7.ƷƼȡƼ<br />8.̨ҳȵؼʣȵؼ¼ǳؼġ<br /><font color=#ff0000><b>C.ɫ</b></font><br />1.ã˿͹ףվ<br />2.ʺ϶οPHP+mysqlȫܸߣȶ<br />3.ıǩܣ䷽ƣʹǲҲܿƳ۴󷽵ķ<br />4.ǿܣƷơ̻ʽù˿ͿݵҵҪƷʡʱ䡣<br /><font size=+0><b>̫,һһ˵,</b></font><br /></p></td></tr></tbody></table></td></tr></tbody></table>','','http://down2.php168.com/module/shop.rar','281KB','','','','','Ѱ','Linux/NT/9x/2000/2003/XP/PHP','','0','0','','0','0','0','0','0','1218710213','0','0');
INSERT INTO `p8_down_software` VALUES ('8','ϵͳ','8','ϵͳ','0','','0','0','0','1218710430','1218710430','1','php168','','0','','0','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','','<p><font color=#ff0000><b>A </b></font><br />1.֧޼࣬ⴴࡢĿĿ䷽ݷḻĴվ<br />2.Զ·費Ҫˣɶδ˵ûɶ·ǷԶͨ˻Ƽ<br />3.AJAXʵˢ۹ܣˢҳʡûʱ䡣<br />4аĿ¼ּܣֻҪĿ¼ҳ𼶵ͿԼĿ¼޷ּ<br />5ɸʱȺ˳򣬰·ͳƳγ[]Ŀ<br />6ĵߵͳƳγ[]Ŀ<br />7Զ¼ش<br />8ͼƬϴܣϴͼƬҲֱӵԶͼƬ<br />9Ա̨Զ޸Ļɾȱ༭ܡ<br />10ŻҳȵԶ壬Ҫ޸ķҪ.htaccessģ֧־Ϳα̬˱¼Ļʡ<br />11.֧ȫվԶĿɾ̬ܣҾ̬ʽ趨<br />12.۹ܣ֧ۣԶϢǷԶͨˡ<br />13..ʵǰ׹,ǰĻ,ǰĳһǰ,׵Ļ,ʵֳ׵ĳһ棬ȻҲǰ,<br />14..վϵͳͼϵͳƵϵͳϵͳϢϵͳ̳ϵͳϵͳFLASHϵͳ޺ϣͨǩܿɵκѾϵͳݡ<br />15..ıǩԶ幦,ֻҪhtmlģ$label[abc]ıǩ,ں̨κģݡ<br />\r\n<p><font color=#ff0000><b>B.Իĺ̨ƶ</b></font><br />1.ԻĿáĿںֱ̨ãҪ޸ģ档<br />2.̨ǩñǩҪõݻձǩá<br />3.۹ܣǷ֤ͨ<br />4.̬ҳбҳҳɾ̬ɾ̬ҳ<br />5.ɸݾǾˡˣֱؼֽ<br />6.ƼȡƼ<br />7.̨дվơվַҳȵؼʣȵؼ¼ǳؼġ<br />\r\n<p><font color=#ff0000><b>C.ɫ</b></font><br />1.ǩԶ幦ܣ䷽ƣʹǲҲܿƳ۴󷽵ķ<br />2.еҪ޸ķãҪ.htaccessģ֧־α̬<br />3.Զ徲̬ҳĿ¼ʵÿĿԶԾ̬ҳĿ¼.߸ԡ<br />4.ֶ֧߳أϴҲԶ̵ַ<br />5.JS÷ʽκҳá<br />6.ְ֧һ<br />\r\n<p><font size=+0><b>̫,һһ˵,</b></font><br /></p>','','http://down2.php168.com/module/download.rar','216KB','','','','','Ѱ','Linux/NT/2000/2003/XP/9x/PHP','','0','0','','0','0','0','0','0','1218710305','0','0');
INSERT INTO `p8_down_software` VALUES ('9','FLASHϵͳ','4','վ','0','','0','0','0','1218710600','1218710600','1','php168','','0','','0','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','','<p><font color=#ff0000><b>A </b></font><br />1.֧޼࣬ⴴࡢĿĿ䷽ݷḻĴFLASHվ<br />2.ҳбҳҳֱ֧ǩ,ֻҪhtmlģ$label[abc]ıǩ,ں̨κFLASHģݡ<br />3.֧FLASHͬʱɶFLASHˡöƼ<br />4.֧ϴʹURLַַʽFLASH<br />5.δ˵FLASHûFLASHǷԶͨ˻Ƽ<br />6.FLASHٴȷϹܣԱĲ.<br />7.AJAXʵˢ۹ܣFLASHˢҳʡûʱ䡣<br />8.FLASHʵǰ׹,ǰĻ,ǰĳFLASHǰ,׵Ļ,ʵֳ׵ĳFLASH棬ȻҲǰ,<br />9.վϵͳͼϵͳƵϵͳϵͳϵͳ̳ϵͳϵͳϢϵͳ޺ϣͨǩܿɵκѾϵͳݡ<br />10.ûȨ޹ܣָĳЩûſFLASHĹܣĳЩû鲻FLASH<br />11.ǰ̨ԱܣʹҵҪĻԱϡ<br />12.FLASHܣʹҵҪFLASH<br /><font color=#ff0000><b>B.Իĺ̨ƶ</b></font><br />1.ùرպͿFLASH,FLASHرԭ<br />2.ĻĿáĿںֱ̨ãҪ޸ģ档<br />3.̨ǩñǩҪõݻձǩá<br />4.۹ܣǷ֤ͨ<br />5.ɼӡɾ롢ɼ<br />6.̬ҳбҳҳɾ̬ɾ̬ҳ<br />7.ɸݾǾˡˣFLASHֱؼֽFLASHݼ<br />8.FLASHƼȡƼ<br />9.̨ҳȵؼʣȵؼ¼ǳؼġ<br /><font color=#ff0000><b>C.ɫ</b></font><br />1.FLASHɼܣһ˲Ϳ԰վFLASHɼԼվϡϵͳԴ˶ɼ<br />2.еFLASHܣ㲻ҪһһŵķFLASHһԷFLASH<br />3.ıǩɴɫFLASHվ<br />4.֧α̬α̬¼ʡ<br />5.Զ徲̬ҳĿ¼ʵÿĿԶԾ̬ҳĿ¼.߸ԡ<br /><font size=+0><b>̫,һһ˵,</b></font><br /></p>','','http://down2.php168.com/module/flash.rar','485KB','','','','','Ѱ','Linux/9x/2000/2003/XP/PHP','','0','0','','0','0','0','0','0','1218710442','0','0');
INSERT INTO `p8_down_software` VALUES ('10','Ȧϵͳ','4','վ','0','','0','2','0','1218710795','1218710795','1','php168','','0','','0','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','','','','http://down2.php168.com/module/group.rar','','','','','','Ѱ','Linux/NT/2000/2003/XP','','1','0','','1218711504','0','0','1218710804','1','1218710604','1','1');
INSERT INTO `p8_down_sort` VALUES ('1','0','','1','2','1','','0','0','','','','','','','0','','','1','','','','','0','','0','','');
INSERT INTO `p8_down_sort` VALUES ('3','1','','2','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','1','','');
INSERT INTO `p8_down_sort` VALUES ('4','1','վ','2','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','1','','');
INSERT INTO `p8_down_sort` VALUES ('6','0','ϵͳ','1','2','1','','0','0','','','','','','','0','','','1','','','','','0','','0','','');
INSERT INTO `p8_down_sort` VALUES ('7','6','̹','2','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','1','','');
INSERT INTO `p8_down_sort` VALUES ('8','6','ϵͳ','2','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_fenlei_ad` VALUES ('1','info_show','ҳ','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:17:\",ӭ\";}','0','0','0','0');
INSERT INTO `p8_fenlei_ad` VALUES ('2','info_list','бҳ','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:10:\"\";}','0','0','0','0');
INSERT INTO `p8_fenlei_area` VALUES ('1','0','ֱϽ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('6','0','','1','3','0','','0','0','','','','','','','0','','','0','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('7','0','','1','3','1','','0','0','','','','','N;','','0','','','0','','','','','0','b:0;','LiaoNing','0');
INSERT INTO `p8_fenlei_area` VALUES ('8','0','','1','5','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('9','0','е','1','4','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('10','0','ϵ','1','3','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('11','0','','1','5','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('12','0','ϵ','1','3','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('13','0','۰̨','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('17','6','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('18','6','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('19','6','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('20','7','ӱ','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('21','7','ɽ','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('22','7','ɹ','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('23','8','ɽ','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('24','8','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('25','8','㽭','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('26','8','','2','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','b:0;','AnHui','0');
INSERT INTO `p8_fenlei_area` VALUES ('27','8','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('28','9','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('29','9','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('30','9','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('31','9','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('32','10','㶫','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('33','10','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('34','10','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('35','11','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('36','11','½','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('37','11','ຣ','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('38','11','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('39','11','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('41','12','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('42','12','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_area` VALUES ('43','12','','2','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_city` VALUES ('1','1','','0','0','0','','20','0','','','','','','','0','','','0','','','','','0','','BeiJing','0','','');
INSERT INTO `p8_fenlei_city` VALUES ('2','1','Ϻ','0','0','0','','19','0','','','','','','','0','','','0','','','','','0','','ShangHai','0','','');
INSERT INTO `p8_fenlei_city` VALUES ('3','1','','0','0','0','','18','0','','','','','','','0','','','1','','','','','0','','','0','T','');
INSERT INTO `p8_fenlei_city` VALUES ('4','1','','0','0','0','','17','0','','','','','','','0','','','1','','','','','0','','','0','Z','');
INSERT INTO `p8_fenlei_city` VALUES ('5','13','̨','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','T','');
INSERT INTO `p8_fenlei_city` VALUES ('6','13','','0','0','0','','0','0','','','','','','','0','','','0','','','','','0','','XiangGang','0','X','');
INSERT INTO `p8_fenlei_city` VALUES ('7','13','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','A','');
INSERT INTO `p8_fenlei_city` VALUES ('8','17','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','S','');
INSERT INTO `p8_fenlei_city` VALUES ('9','17','','0','0','0','','11','0','','','','','','','0','','','1','','','','','0','','','0','D','');
INSERT INTO `p8_fenlei_city` VALUES ('10','18','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','C','');
INSERT INTO `p8_fenlei_city` VALUES ('11','19','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','H','');
INSERT INTO `p8_fenlei_city` VALUES ('12','20','ʯׯ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','S','');
INSERT INTO `p8_fenlei_city` VALUES ('13','21','̫ԭ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','T','');
INSERT INTO `p8_fenlei_city` VALUES ('14','22','ͺ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','H','');
INSERT INTO `p8_fenlei_city` VALUES ('15','23','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','J','');
INSERT INTO `p8_fenlei_city` VALUES ('16','23','ൺ','0','0','0','','10','0','','','','','','','0','','','1','','','','','0','','','0','Q','');
INSERT INTO `p8_fenlei_city` VALUES ('17','24','Ͼ','0','0','0','','9','0','','','','','','','0','','','1','','','','','0','','','0','N','');
INSERT INTO `p8_fenlei_city` VALUES ('18','24','','0','0','0','','8','0','','','','','','','0','','','1','','','','','0','','','0','S','');
INSERT INTO `p8_fenlei_city` VALUES ('19','25','','0','0','0','','13','0','','','','','','','0','','','1','','','','','0','','','0','H','');
INSERT INTO `p8_fenlei_city` VALUES ('20','26','Ϸ','0','0','0','','7','0','','','','','','','0','','','1','','','','','0','','','0','H','');
INSERT INTO `p8_fenlei_city` VALUES ('21','27','','0','0','0','','6','0','','','','','','','0','','','1','','','','','0','','','0','F','');
INSERT INTO `p8_fenlei_city` VALUES ('22','27','','0','0','0','','5','0','','','','','','','0','','','1','','','','','0','','','0','X','');
INSERT INTO `p8_fenlei_city` VALUES ('23','28','人','0','0','0','','4','0','','','','','','','0','','','1','','','','','0','','','0','W','');
INSERT INTO `p8_fenlei_city` VALUES ('24','29','ɳ','0','0','0','','14','0','','','','','','','0','','','1','','','','','0','','','0','C','');
INSERT INTO `p8_fenlei_city` VALUES ('25','30','ϲ','0','0','0','','3','0','','','','','','','0','','','1','','','','','0','','','0','N','');
INSERT INTO `p8_fenlei_city` VALUES ('26','31','֣','0','0','0','','2','0','','','','','','','0','','','1','','','','','0','','','0','Z','');
INSERT INTO `p8_fenlei_city` VALUES ('27','32','','0','0','0','','16','0','','','','','','','0','','','1','','','','','0','','','0','G','');
INSERT INTO `p8_fenlei_city` VALUES ('28','32','','0','0','0','','15','0','','','','','','','0','','','1','','','','','0','','','0','S','');
INSERT INTO `p8_fenlei_city` VALUES ('29','33','','0','0','0','','1','0','','','','','','','0','','','1','','','','','0','','','0','N','');
INSERT INTO `p8_fenlei_city` VALUES ('30','34','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','H','');
INSERT INTO `p8_fenlei_city` VALUES ('31','35','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','Y','');
INSERT INTO `p8_fenlei_city` VALUES ('32','36','³ľ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','W','');
INSERT INTO `p8_fenlei_city` VALUES ('33','37','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','X','');
INSERT INTO `p8_fenlei_city` VALUES ('34','38','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','X','');
INSERT INTO `p8_fenlei_city` VALUES ('35','39','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','L','');
INSERT INTO `p8_fenlei_city` VALUES ('36','40','ɶ','0','0','0','','12','0','','','','','','','0','','','1','','','','','0','','','0','C','');
INSERT INTO `p8_fenlei_city` VALUES ('37','41','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','K','');
INSERT INTO `p8_fenlei_city` VALUES ('38','42','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','G','');
INSERT INTO `p8_fenlei_city` VALUES ('39','43','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0','L','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_bencandy_filename2','bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_list_filename2','list.php?fid-{$fid}-page-{$page}.htm','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_bencandy_filename','','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoListLeng','40','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_guide_word1','ҳ|./\r\nѷ|pub.php\r\nҷϢ|myinfo.php\r\n|search.php\r\nվͼ|area.php\r\nȫϢ|area.php?city_id=a\r\nվҳ|/','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_list_filename','','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_NewsMakeHtml','0','');
INSERT INTO `p8_fenlei_config` VALUES ('ForbidPostMember','','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_forbidOutPost','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Force_Choose_City','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_TopNum','5','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_TopDay','2','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_guide_word2','ȫ|index.php?city_id=a\r\n|#\r\nϺ|#\r\n|#\r\n|#\r\n|#\r\n|#\r\nϾ|#\r\n|#\r\nϷ|#\r\n|#\r\n|#\r\n|#\r\nɶ|#\r\nɳ|#\r\nϲ|#\r\n人|#\r\n|#','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_MemberPostRepeat','0','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoIndexRow','10','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoIndexShow','20','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoSortShow','10','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoBigsortShow','15','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoShowTime','20','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_rollpic','Ʒһ|images/default/shop1.jpg|#\r\nƷ|images/default/shop2.jpg|#\r\nƷ|images/default/shop3.jpg|#','');
INSERT INTO `p8_fenlei_config` VALUES ('AdInfoListRow','10','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_feedbackID','111111','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_MakeIndexHtmlTime','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Fenlei_guide_word1','ҳ|./\r\nѷ|pub.php\r\nȫ|allcity.php\r\n|search.php\r\n|admin.php?job=sort\r\nԱ|member/','');
INSERT INTO `p8_fenlei_config` VALUES ('CollectArticleNum','23','');
INSERT INTO `p8_fenlei_config` VALUES ('PostInfoMoney','2','');
INSERT INTO `p8_fenlei_config` VALUES ('InfoIndexLeng','26','');
INSERT INTO `p8_fenlei_config` VALUES ('InfoIndexRow','8','');
INSERT INTO `p8_fenlei_config` VALUES ('ErrSortMoney','13','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_DelKeyword','\r\n','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_PostMaxLeng','100000','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_PostMaxNum','20','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_RepeatPostNum','3','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_postCkMob','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_postCkIp','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_YzKeyword','԰\r\n','');
INSERT INTO `p8_fenlei_config` VALUES ('DelOtherCommentMoney','12','');
INSERT INTO `p8_fenlei_config` VALUES ('otherCardMoney','11','');
INSERT INTO `p8_fenlei_config` VALUES ('permitMoney','10','');
INSERT INTO `p8_fenlei_config` VALUES ('IDcardMoney','9','');
INSERT INTO `p8_fenlei_config` VALUES ('EmailYzMoney','8','');
INSERT INTO `p8_fenlei_config` VALUES ('ReportMoney','7','');
INSERT INTO `p8_fenlei_config` VALUES ('GoodCommentMoney','6','');
INSERT INTO `p8_fenlei_config` VALUES ('PublicizeRegMoney','5','');
INSERT INTO `p8_fenlei_config` VALUES ('ALLInfoMoney','4','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_loginTime','16','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_loginMoney','3','');
INSERT INTO `p8_fenlei_config` VALUES ('InfoListLeng','30','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_regmoney','1','');
INSERT INTO `p8_fenlei_config` VALUES ('illInfoMoney','14','');
INSERT INTO `p8_fenlei_config` VALUES ('DelReportMoney','15','');
INSERT INTO `p8_fenlei_config` VALUES ('InfoListRow','10','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_style','35cn','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_GuestPostRepeat','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_MemberDayPostNum','3','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_GuestDayPostNum','3','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_ClosePostWhy','ϴʱ,ͣ޸Ϣ','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_ClosePost','1','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_UseEndtime','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_TopMoney','3','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_TopColor','#F70968','');
INSERT INTO `p8_fenlei_config` VALUES ('Jump_allcity','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Jump_fromarea','1','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_Searchkeyword','0','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_allowGuesSearch','1','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_closeWhy','վά,ͣ','');
INSERT INTO `p8_fenlei_config` VALUES ('module_id','4','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_areaname','ȫ','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_webOpen','1','');
INSERT INTO `p8_fenlei_config` VALUES ('module_pre','fenlei_','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_webname','ϢƵ','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_weburl','','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_webadmin','','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_metakeywords','Ϣ   ҳ','');
INSERT INTO `p8_fenlei_config` VALUES ('ForbidPostIp','','');
INSERT INTO `p8_fenlei_config` VALUES ('GroupPassYz','','');
INSERT INTO `p8_fenlei_config` VALUES ('GroupPostInfo','','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_GroupCommentYzImg','','');
INSERT INTO `p8_fenlei_config` VALUES ('Info_GroupPostYzImg','','');
INSERT INTO `p8_fenlei_content` VALUES ('1','Ứ԰-ס','0','','1','0','4','˳','0','0','0','0','7','0','1210496999','1210496999','0','','','0','','0','1','','0','0','0','Ứ԰-ס','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218272999','','1218619503','10','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('2','Թɻ,ͶʺóϢ,','0','','2','0','17','Ȥ','0','0','0','0','4','0','1210497044','1210497044','1','admin','','0','','0','1','','0','0','0','  ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218273044','','1210506996','1','3','9','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('3','һһ','0','','1','0','4','˳','0','0','0','0','2','0','1210497624','1210497624','0','','','0','','0','1','','0','0','0','һһ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218273624','','1218609703','17','26','50','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('4','԰¥,װ,г׼ Ϣ','0','','8','0','8','˳','0','0','0','0','2','0','1210499488','1210499488','2','hui','','0','','0','1','','0','0','0','԰¥,װ,г׼ Ϣ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218275488','','1218618213','34','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('5','ݱ̹԰,ܰ','0','','8','0','8','˳','0','0','0','0','2','0','1210499671','1210499671','2','hui','','0','','0','1','','0','0','0','ݱ̹԰,ܰ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218275671','','1210501226','27','12','3','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('6','԰','0','','1','0','4','˳','0','0','0','0','9','0','1210500297','1210500297','2','hui','','0','http://pic.58.com//Images/temp/small/2008-05-11/F2008051102044988850325.JPG','1','1','','0','0','0','԰','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218276297','','1218774646','27','11','1','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('7','ȫװ޵Ķһķ(н) Ϣ','0','','8','0','8','˳','0','0','0','0','5','0','1210500861','1210500861','3','ahui','','0','http://pic.58.com//Images/temp/small/2008-05-09/F2008050901480516987108.JPG','1','1','','0','0','0','ȫװ޵Ķһķ(н) Ϣ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218276861','','1218611392','13','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('8','԰һ2000Ԫ','0','','9','0','12','д¥/̳','0','0','0','0','3','0','1210501195','1210501195','3','ahui','','0','http://pic.58.com//Images/temp/small/2008-05-09/F2008050902593659143308.jpg','1','1','','0','0','0','԰һ2000Ԫ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218277195','','1218606008','27','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('9','300װд¥ Ϣ','0','','9','0','12','д¥/̳','0','0','0','0','1','0','1210501412','1210501412','3','ahui','','0','','0','1','','0','0','0','300װд¥ Ϣ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218277412','','1210501413','27','11','1','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('10','·СŻݳ(̩·)','0','','9','0','12','д¥/̳','0','0','0','0','3','1','1210501804','1210501804','4','a_hui','','0','','0','1','','0','0','0','·СŻݳ(̩·)','','','','','','','0','0','121.32.83.106','0','0','','','0','0','0','','1218601233','27','0','0','','0','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('11','ȫװ޵һһķ(н) Ϣ','0','','8','0','8','˳','0','0','0','0','2','0','1210502024','1210502024','4','a_hui','','0','http://pic.58.com//Images/temp/small/2008-05-10/F2008051010103045044744.JPG','1','1','','0','0','0','ȫװ޵һһķ(н) Ϣ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218278024','','1218603635','30','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('12','Թɻ,ͶʺóϢ,','0','','2','0','17','Ȥ','0','0','0','0','3','0','1210502267','1210502267','4','a_hui','','0','','0','1','','0','0','0','Թɻ,ͶʺóϢ,','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218278267','','1218610303','35','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('13','һ㶫ϲWOWŮ Ϣ','0','','2','0','17','Ȥ','0','0','0','0','3','0','1210502713','1210502713','5','ah0','','0','','0','1','','0','0','0','һ㶫ϲWOWŮ Ϣ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218278713','','1218619002','37','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('14','ûϲӾ`?','0','','2','0','17','Ȥ','0','0','0','0','2','0','1210502877','1210502877','5','ah0','','0','http://pic.58.com//Images/temp/small/2008-05-08/F2008050807122331045789.jpg','1','1','','0','0','0','ûϲӾ`?','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218278877','','1218602812','25','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('15','ҸŮ, ĵ','0','','2','0','18','Ů','0','0','0','0','5','0','1210503021','1210503021','5','ah0','','0','','0','1','','0','0','0','ҸŮ, ĵ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218279021','','1218612914','31','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('16','Ů..','0','','2','0','18','Ů','0','0','0','0','3','0','1210503455','1210503455','6','ah1','','0','','0','1','','0','0','0','Ů..','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1213095455','','1210503611','12','0','0','','30','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('17','19-22ŮŮѡ','0','','2','0','18','Ů','0','0','0','0','1','0','1210503567','1210503567','6','ah1','','0','','0','1','','0','0','0','19-22ŮŮѡ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218279567','','1210503568','37','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('18','','0','','2','0','19','','0','0','0','0','1','0','1210503813','1210503813','6','ah1','','0','','0','1','','0','0','0','','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218279813','','1210503815','35','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('19','ϣҵİҵһ Ϣ','0','','2','0','19','','0','0','0','0','1','0','1210504041','1210504041','7','ah2','','0','','0','1','','0','0','0','ϣҵİҵһ Ϣ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218280041','','1210504042','35','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('20','Ѱ.. Ϣ','0','','2','0','19','','0','0','0','0','5','0','1210504178','1210504178','7','ah2','','0','http://pic.58.com//Images/temp/small/2008-03-29/F2008032912555384489053.jpg','1','1','','0','0','0','Ѱ.. Ϣ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218280178','','1218612862','35','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('21','߼õıʼǱ','0','','3','0','26','/','0','0','0','0','3','0','1210504839','1210504839','7','ah2','','0','','0','1','','0','0','0','߼õıʼǱ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218280839','','1218599343','17','26','50','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('22','õ399ʾ150 Ϣ','0','','3','0','26','/','0','0','0','0','1','0','1210505091','1210505091','8','ah3','','0','','0','1','','0','0','0','õ399ʾ150 Ϣ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218281091','','1210505092','17','26','50','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('23','ȫձԭװ,200Ԫ (̼)','0','','3','0','26','/','0','0','0','0','1','0','1210505369','1210505369','8','ah3','','0','','0','1','','0','0','0','ȫձԭװ,200Ԫ (̼)','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218281369','','1210505370','38','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('24','õԼʾ','0','','3','0','26','/','0','0','0','0','1','0','1210505826','1210505826','8','ah3','','0','','0','1','','0','0','0','õԼʾ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218281826','','1210505827','14','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('25',' GPSմ P660','0','','3','0','28','Ʒ','0','0','0','0','8','0','1210506437','1210506437','9','ah4','','0','','0','1','','0','0','0',' GPSմ P660','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218282437','','1218615085','32','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('27','ȫ廪Ϲ17ƽ350 (̼)','0','','3','0','28','Ʒ','0','0','0','0','2','0','1210506683','1210506683','9','ah4','','0','','0','1','','0','0','0','ȫ廪Ϲ17ƽ350 (̼)','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218282683','','1210506854','37','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('29','ǵ߼վɻ! Ϣ','0','','3','0','31','õ','0','0','0','0','1','0','1210507073','1210507073','10','ah5','','0','','0','1','','0','0','0','ǵ߼վɻ! Ϣ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218283073','','1210507074','27','11','1','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('30','ͼ۳۶ּ˽ҵյ(б) Ϣ','0','','3','0','31','õ','0','0','0','0','1','0','1210507160','1210507160','10','ah5','','0','','0','1','','0','0','0','ͼ۳۶ּ˽ҵյ(б) Ϣ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218283160','','1210507162','15','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('32','Ӧ,Ƭ,Ͳ426','0','','3','0','31','õ','0','0','0','0','2','0','1210507307','1210507307','10','ah5','','0','','0','1','','0','0','0','Ӧ,Ƭ,Ͳ426','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218283307','','1210507312','27','11','2','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('36',' ,רҵ(ѧ) רҵְ','0','','4','0','43','ְ','0','0','0','0','1','0','1210508110','1210508110','11','ah6','','0','','0','1','','0','0','0',' ,רҵ(ѧ) רҵְ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218284110','','1210508111','27','11','2','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('37','񳵴˾ְ','0','','4','0','43','ְ','0','0','0','0','2','0','1210508414','1210508414','11','ah6','','0','','0','1','','0','0','0','񳵴˾ְ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218284414','','1210509131','27','11','2','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('38','Լ','0','','4','0','43','ְ','0','0','0','0','1','0','1210509337','1210509337','11','ah6','','0','','0','1','','0','0','0','Լ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218285337','','1210509340','15','0','0','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('39','Ѱʵϰ','0','','4','0','44','ʵϰ/ְ','0','0','0','0','4','1','1210509865','1210509865','12','ah7','','0','','0','1','','0','0','0','Ѱʵϰ','','','','','','','0','0','121.32.83.106','0','0','','','0','0','0','','1218605988','27','12','4','','0','','0','','','','','','','');
INSERT INTO `p8_fenlei_content` VALUES ('40','Ƹְʵϰͼ༭','0','','4','0','44','ʵϰ/ְ','0','0','0','0','3','0','1210510180','1210510180','12','ah7','','0','','0','1','','0','0','0','Ƹְʵϰͼ༭','','','','','','','0','0','121.32.83.106','0','0','','','0','0','1218286180','','1218618955','27','12','4','','90','','0','','','','','','','');
INSERT INTO `p8_fenlei_content_1` VALUES ('1','1','4','0','Ϣ⡢ݡQQ/MSNгֵ绰ֻ,н顣н顣 \n\nվͳ\n','2','1800Ԫ/','2','2','184 190','ˮ/ߵ/','Ứ԰-ס','Ứ԰','1','80O','','13826199842','ritadew2006@hotmail.com','485126398','2');
INSERT INTO `p8_fenlei_content_1` VALUES ('2','3','4','0','С,,.мҾ,ҵȫ.λԽ.¥ʱԼ--С\n\n\nϢ⡢ݡQQ/MSNгֵ绰ֻ,н顣н顣 \n','1','2500Ԫ/','6','2','280','ˮ/ߵ/ӻ/ˮ/','С','','1','55','С','15914428167','lijinlian12@163.com','814914252','2');
INSERT INTO `p8_fenlei_content_1` VALUES ('3','6','4','2','Сʵ÷λڰԪ,ٽԪں͹վ,ͨ,дͳ׳,г,ѧУ,,Ьǵȵ.һ,ҵ֮.','1','1000Ԫ/','','2','551','ˮ/','԰','','1','65','԰','13642640582','www.123456@cn.com','','2');
INSERT INTO `p8_fenlei_content_10` VALUES ('1','136','14','0',':38000Ԫ&nbsp;&nbsp;<BR><BR><BR>λɽ·㳡,42ƽ,4Ŵ,С֮,ٽ,ҵλԽ,˿ڶ,洦д,ȶԴ,豸ʩȫ,չռϴ,Żת,ͶҵĪ.ɵ豸תã,ת÷,ʵ3.8.<BR><BR>ϵ:С<BR>绰:13710919607<BR>ַ:ɽ·㳡T10ײ9<BR>','ɽ·㳡T10ײ9','','ɽ·㳡,','','42M2','','ֽ','20/4','5','','','','','','wujavei','13710919607','javei@21cn.com','919607');
INSERT INTO `p8_fenlei_content_10` VALUES ('2','142','14','0','<DIV class=c_nr>:2200Ԫ&nbsp;&nbsp;<BR>λڻҿϴгһרҵתãͣأ㣬ӪҵУԴȶ֤룬ַѣ򣨺Ԫѹ𣩣ÿ£Ԫӭǰʵؿ</DIV>','רҵ','','ҿϴгһרҵ','','ͣأ','','ֽ','20/4','10RMB','','','','','','','13660899405','ahui21@163.com','99405');
INSERT INTO `p8_fenlei_content_10` VALUES ('3','143','14','0','<DIV class=c_nr>:35000Ԫ&nbsp;&nbsp;<BR>λڱ·¥,λü,ԭת,̸!</DIV>','·¥','','·¥','','200','','ֽ','0','12RMB','','','','','','WWW.jacytu','020-33606870','jacytu@sina.com','6870');
INSERT INTO `p8_fenlei_content_11` VALUES ('499','999','41','0','ʢճ()\r\n \r\n \r\n    		ʢճǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','޴Ʒ','020-20085196','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('500','1000','41','0','ϵԹ()\r\n \r\n \r\n    		ϵԹǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','خʯڶ·','020-67684603','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('501','1001','41','0','й()\r\n \r\n \r\n    		йǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','⾭ó3¥','020-94705231','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('502','1002','41','0','ݸ߿Ƶӹ˾()\r\n \r\n \r\n    		ݸ߿Ƶӹ˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ˮ·188ݸ߿ƴ','020-68541158','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('503','1003','41','0','ҵι˾()\r\n \r\n \r\n    		ҵι˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ƽ´壶','020-68502240','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('504','1004','41','0','԰()\r\n \r\n \r\n    		԰ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ӱ·Ź㳡2505','020-25151913','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('505','1005','41','0','ݷɸӿƼ޹˾()\r\n \r\n \r\n    		ݷɸӿƼ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·472Ż11¥','020-23212763','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('506','1006','41','0','˼ҼҾ()\r\n \r\n \r\n    		˼ҼҾǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ֺ·156԰1','020-53348225','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('507','1007','41','0','ϴˢˢƼ޹˾()\r\n \r\n \r\n    		ϴˢˢƼ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','йݴ345ȴ','020-50367587','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('508','1008','41','0','㶫㲥()\r\n \r\n \r\n    		㶫㲥ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·686ţ棩','020-94302439','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('509','1009','41','0','Ӱ()\r\n \r\n \r\n    		ӰǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','Խɽ·193Űٻ㳡12¥(԰վ)','020-78905842','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('510','1010','41','0','Ӱ()\r\n \r\n \r\n    		ӰǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','зخӴ廨԰8֮2','020-54768673','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('511','1011','41','0','Ļ()\r\n \r\n \r\n    		ĻǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ݻ·118-122','020-61348565','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('512','1012','41','0','ǿǼ꣨·ܵ꣩()\r\n \r\n \r\n    		ǿǼ꣨·ܵ꣩ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','жɽ·','020-63816611','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('513','1013','41','0','ǿǼ꣨ɽܵ꣩()\r\n \r\n \r\n    		ǿǼ꣨ɽܵ꣩ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','жɽ·','020-37653175','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('514','1014','41','0','Ҭ־Ƽ()\r\n \r\n \r\n    		Ҭ־ƼǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','к·68','020-38380380','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('515','1015','41','0','ׯ()()\r\n \r\n \r\n    		ׯ()ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','кϴ217֮','020-69223270','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('516','1016','41','0','ʳ()\r\n \r\n \r\n    		ʳǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ݺ·13֮1011','020-99451445','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('517','1017','41','0','()\r\n \r\n \r\n    		ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','Խ̸·Ϻ75A','020-77124410','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('518','1018','41','0','ǿǼ꣨Խ꣩()\r\n \r\n \r\n    		ǿǼ꣨Խ꣩ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ԽԽ·133','020-63871923','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('739','1239','41','0','д˰޹˾()\r\n \r\n \r\n    		д˰޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','кϴ229°12B','020-97296661','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('740','1240','41','0','ӣִ()\r\n \r\n \r\n    		ӣִǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','й԰·Ƕ¥','020-37763296','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('741','1241','41','0','()\r\n \r\n \r\n    		ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ݿ','020-46003078','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('742','1242','41','0','д޹˾()\r\n \r\n \r\n    		д޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ʯ˸ڹҵ','020-43427538','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('743','1243','41','0','лֵ()\r\n \r\n \r\n    		лֵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ӱ','020-97530524','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('744','1244','41','0','ݺ豸޹˾()\r\n \r\n \r\n    		ݺ豸޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɽ995ҵ3H1','020-10232611','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('745','1245','41','0','ģƷ޹˾()\r\n \r\n \r\n    		ģƷ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','оӪ10','020-88943560','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('746','1246','41','0','϶ӿƼ޹˾()\r\n \r\n \r\n    		϶ӿƼ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','к','020-24932863','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('747','1247','41','0','ݲƼ޹˾()\r\n \r\n \r\n    		ݲƼ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','й㶫кҵϽ̻԰B1501C','020-72545882','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('748','1248','41','0','ӡˢͲ޸()\r\n \r\n \r\n    		ӡˢͲ޸ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','зخʯǰ','020-27608467','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('749','1249','41','0','ؿƼ()\r\n \r\n \r\n    		ؿƼǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ݴݾ԰','020-89392731','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('750','1250','41','0','Ӣ̩ι˾()\r\n \r\n \r\n    		Ӣ̩ι˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ݽϴ151ҵ㳡¥D44','020-24194712','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('751','1251','41','0','Ӣ˾      bbnnnnnnnnn()\r\n \r\n \r\n    		Ӣ˾      bbnnnnnnnnnǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','1','020-80908213','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('752','1252','41','0','ۼʵ޹˾()\r\n \r\n \r\n    		ۼʵ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','аƱ·','020-56570290','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('753','1253','41','0','ͨ()\r\n \r\n \r\n    		ͨǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','㶫ʡкڴ147263','020-15129479','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('754','1254','41','0','շ޹˾()\r\n \r\n \r\n    		շ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','Ҵ55źǴA2602-2702','020-29780141','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('755','1255','41','0','ݸְͨģͳ()\r\n \r\n \r\n    		ݸְͨģͳǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','к̶ҵ','020-28477405','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('756','1256','41','0','ӱ⳵˾()\r\n \r\n \r\n    		ӱ⳵˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ӱ68917¥C4','020-64805918','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1068','1568','41','0','׷ƷƷ()\r\n \r\n \r\n    		׷ƷƷǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','㶫ʡܸ','020-32716882','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1069','1569','41','0','̨ɽϰ´()\r\n \r\n \r\n    		̨ɽϰ´ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','齭³㳡2905','020-38529123','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1070','1570','41','0','̨()\r\n \r\n \r\n    		̨ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ʡѧУ','020-66127839','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1169','1669','41','0','տƼ޹˾()\r\n \r\n \r\n    		տƼ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','лҴ207ź԰A1105','020-41630088','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1170','1670','41','0','귢ó޹˾()\r\n \r\n \r\n    		귢ó޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','㶫ʡֶ','020-40088906','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1242','1742','41','0','Ӥ޹˾()\r\n \r\n \r\n    		Ӥ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ڶ·361','020-83014894','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1243','1743','41','0','㶫ѵ()\r\n \r\n \r\n    		㶫ѵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','㶫ݴ2198','020-49568303','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1244','1744','41','0','԰ѵ()\r\n \r\n \r\n    		԰ѵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','','020-90904232','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1245','1745','41','0','ѯ()\r\n \r\n \r\n    		ѯǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','¸·','020-22145168','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1246','1746','41','0','ӢѧУ()\r\n \r\n \r\n    		ӢѧУǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','','020-25925553','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1247','1747','41','0','ְ()\r\n \r\n \r\n    		ְǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','人','020-22893787','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1248','1748','41','0','ʢ-·ѵ()\r\n \r\n \r\n    		ʢ-·ѵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ݻж·417Ŷ㳡9¥','020-27069331','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1249','1749','41','0','Ÿ߼ѧ()\r\n \r\n \r\n    		Ÿ߼ѧǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','кӸ','020-69398403','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1250','1750','41','0','ǹѵ()\r\n \r\n \r\n    		ǹѵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·','020-63260703','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1251','1751','41','0','sinaѵ()\r\n \r\n \r\n    		sinaѵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','к','020-25243012','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1252','1752','41','0','ӯƸͶʹ޹˾()\r\n \r\n \r\n    		ӯƸͶʹ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·490ɷ23¥','020-33598314','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1273','1773','222','0','ɭ޹˾()\r\n \r\n \r\n    		ɭ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ˮϴ幤ҵA','020-41835251','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1274','1774','222','0','пøƷ޹˾()\r\n \r\n \r\n    		пøƷ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','&#183;','020-76614828','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1275','1775','222','0','Ұֲ()\r\n \r\n \r\n    		ҰֲǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','&#183;ɽǹ㳡','020-81930891','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1276','1776','222','0','ӻͬ޹˾()\r\n \r\n \r\n    		ӻͬ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ӻóǱ22','020-74176768','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1277','1777','222','0','˶Ʒ޹˾()\r\n \r\n \r\n    		˶Ʒ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳ˷9','020-21958935','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1278','1778','222','0','ҰƷ޹˾ɳֳ()\r\n \r\n \r\n    		ҰƷ޹˾ɳֳǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳ齭·54','020-43117046','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1279','1779','222','0','خɳ˴ܽƷ޹˾()\r\n \r\n \r\n    		خɳ˴ܽƷ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳҵ','020-34301289','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1280','1780','222','0','ɳ˶Ʒ޹˾()\r\n \r\n \r\n    		ɳ˶Ʒ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳ˷','020-25834246','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1281','1781','222','0','خɳƷ()\r\n \r\n \r\n    		خɳƷǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳӴ幤ҵԾ·Ʒ','020-47258185','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1282','1782','222','0','ӯ߶Ʒ޹˾()\r\n \r\n \r\n    		ӯ߶Ʒ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳɳ','020-95053665','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1283','1783','222','0','ɳüƷ޹˾()\r\n \r\n \r\n    		ɳüƷ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳӹҵ','020-16909438','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1284','1784','222','0','̩ܽƷ޹˾()\r\n \r\n \r\n    		̩ܽƷ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳݿ6','020-45954688','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1285','1785','222','0','˶Ʒ޹˾()\r\n \r\n \r\n    		˶Ʒ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','&#183;ɳҵ8','020-67512570','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1286','1786','222','0','ҰƷ޹˾ɳֳ()\r\n \r\n \r\n    		ҰƷ޹˾ɳֳǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳ','020-41282433','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1287','1787','222','0','خɳʤƤƷ޹˾()\r\n \r\n \r\n    		خɳʤƤƷ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳ','020-76499215','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1288','1788','222','0','خɳ߶˶Ʒ޹˾()\r\n \r\n \r\n    		خɳ߶˶Ʒ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳ','020-42115573','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1289','1789','222','0','̩ܽƷ޹˾()\r\n \r\n \r\n    		̩ܽƷ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳ޹','020-69698986','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1290','1790','222','0','޹˾()\r\n \r\n \r\n    		޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','»ɽڴ','020-36499137','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1291','1791','222','0','л()\r\n \r\n \r\n    		лǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','»԰7Źл','020-10641488','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1292','1792','222','0','лƷ޹˾()\r\n \r\n \r\n    		лƷ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','»½ȫ·','020-74283789','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1301','1801','224','0','()\r\n \r\n \r\n    		ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·ǧ10','020-44196631','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1302','1802','224','0','˾ֲ()\r\n \r\n \r\n    		˾ֲǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ӱ·886','020-72100302','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1303','1803','224','0','㶫()\r\n \r\n \r\n    		㶫ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɽ·85','020-19576784','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1304','1804','224','0','()\r\n \r\n \r\n    		ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·37','020-69820708','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1305','1805','224','0','㶫()\r\n \r\n \r\n    		㶫ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·118-122','020-35856559','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1306','1806','224','0','ǰ()\r\n \r\n \r\n    		ǰǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ũ·4-6ŶɽB1¥','020-25658296','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1307','1807','224','0','ͥ()\r\n \r\n \r\n    		ͥǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɽ·33л㳡6¥','020-78746823','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1308','1808','224','0','»()\r\n \r\n \r\n    		»ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ũ·422¥','020-12794648','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1309','1809','224','0','ܻ()\r\n \r\n \r\n    		ܻǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɽ·33л㳡6¥','020-75115157','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1310','1810','224','0','Ʒ()\r\n \r\n \r\n    		ƷǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·118','020-16863994','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1311','1811','224','0','ͼ()\r\n \r\n \r\n    		ͼǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·208ӳǹ㳡5¥','020-90465146','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1312','1812','224','0','()\r\n \r\n \r\n    		ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·228ѹ㳡3¥','020-68144695','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1313','1813','224','0','()\r\n \r\n \r\n    		ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·208ӳǹ㳡5¥','020-61662222','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1314','1814','224','0','()\r\n \r\n \r\n    		ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','Ը´','020-83481972','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1315','1815','224','0','껪()\r\n \r\n \r\n    		껪ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɽ³ǻ·','020-41209309','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1316','1816','224','0','µ()\r\n \r\n \r\n    		µǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ĵ·Ķֻۺ¥','020-13966408','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1317','1817','224','0','ѧ()\r\n \r\n \r\n    		ѧǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·123Źݹ4¥8','020-50163631','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1318','1818','224','0','깺ĵ()\r\n \r\n \r\n    		깺ĵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·123ŹݹA12','020-43312110','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1319','1819','224','0','궫Ե()\r\n \r\n \r\n    		궫ԵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','Դ·','020-70937001','-3');
INSERT INTO `p8_fenlei_content_11` VALUES ('1320','1820','224','0','ص()\r\n \r\n \r\n    		صǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·123Źݹ5¥A32','020-34828762','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1602','2102','41','0','݊W˹豸()\r\n \r\n \r\n    		݊W˹豸ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','Ǹ39','020-67481757','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1603','2103','41','0','ݰ˹豸()\r\n \r\n \r\n    		ݰ˹豸ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ʯ򣬽Ĺҵ԰','020-42825921','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1604','2104','41','0','˳ɡ()\r\n \r\n \r\n    		˳ɡǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·.ʮ·12֮6','020-60573307','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1605','2105','41','0','ŷܵӿƼ޹˾()\r\n \r\n \r\n    		ŷܵӿƼ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','лɳڹҵ25','020-38652349','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1606','2106','41','0','ƹƷ˾()\r\n \r\n \r\n    		ƹƷ˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','㶫','020-95399319','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1607','2107','41','0','ó׹˾()\r\n \r\n \r\n    		ó׹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','й԰·81ŸƵ¥','020-12526436','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1608','2108','41','0','ֱ()\r\n \r\n \r\n    		ֱǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','','020-11020247','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1609','2109','41','0','̳()\r\n \r\n \r\n    		̳ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','а̽ƽɳ','020-91665544','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1610','2110','41','0','й鱦()\r\n \r\n \r\n    		й鱦ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','','020-95409220','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1611','2111','41','0','ݶƤ޹˾()\r\n \r\n \r\n    		ݶƤ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','Ԫ1233Ϫ¥','020-69211578','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1612','2112','41','0','ƿʦֲ()\r\n \r\n \r\n    		ƿʦֲǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','佻·','020-29617720','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1613','2113','41','0','Ʒ޹˾()\r\n \r\n \r\n    		Ʒ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','кҵ·ҵ32','020-45401760','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1614','2114','41','0','֡̿ר()\r\n \r\n \r\n    		֡̿רǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','һ¥¥','020-56498967','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1615','2115','41','0','ݺðҵ޹˾()\r\n \r\n \r\n    		ݺðҵ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','㶫ʡ嶫ʶɳҵ','020-92577016','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1616','2116','41','0','еԴ()\r\n \r\n \r\n    		еԴǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','','020-60012423','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1617','2117','41','0','ݺԵ()\r\n \r\n \r\n    		ݺԵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','а','020-48756776','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1618','2118','41','0','Ļ޹˾()\r\n \r\n \r\n    		Ļ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·77ײ','020-46223328','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1619','2119','41','0','ż()\r\n \r\n \r\n    		żǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','а','020-77271647','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1620','2120','41','0','굤йŮƷһƷ()\r\n \r\n \r\n    		굤йŮƷһƷǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','','020-34102224','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1621','2121','41','0','ݷ|ƷƷ|иԷ()\r\n \r\n \r\n    		ݷ|ƷƷ|иԷǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','.       www.elecreal.com','020-87289159','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1627','2127','249','0','ľͰӲ޹˾()\r\n \r\n \r\n    		ľͰӲ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','к¸·535ųڴ¥128','020-64904118','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1628','2128','249','0','()\r\n \r\n \r\n    		ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','齭԰','020-16938017','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1629','2129','249','0','ʤն()\r\n \r\n \r\n    		ʤնǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','԰ǰ·','020-63275595','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1630','2130','249','0','ľͰܵ()\r\n \r\n \r\n    		ľͰܵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','¸·42(ڴö)','020-17273287','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1631','2131','249','0','&׹԰()\r\n \r\n \r\n    		&׹԰ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','԰·161¥(Ӱ)','020-21388613','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1632','2132','249','0','Ȫʳ()\r\n \r\n \r\n    		ȪʳǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','϶·1Ŷ','020-60139544','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1633','2133','249','0','Ŀ͵()\r\n \r\n \r\n    		Ŀ͵ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','гŶ','020-55193913','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1634','2134','249','0','()\r\n \r\n \r\n    		ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ӹ԰г','020-53359927','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1635','2135','249','0','ŷҼ޵()\r\n \r\n \r\n    		ŷҼ޵ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·','020-30101291','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1636','2136','249','0','ټҼ()\r\n \r\n \r\n    		ټҼǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·555B1','020-46015089','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1637','2137','249','0','ʳ֮͵()\r\n \r\n \r\n    		ʳ֮͵ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɽ·߻A32','020-74299808','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1638','2138','249','0','Ҭ˼ϼ()\r\n \r\n \r\n    		Ҭ˼ϼǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·111','020-15950949','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1639','2139','249','0','˿͵()\r\n \r\n \r\n    		˿͵ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·318','020-60049630','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1640','2140','249','0','ʳ֮Դ()\r\n \r\n \r\n    		ʳ֮ԴǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·','020-91264389','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1641','2141','249','0','ÿӱ()\r\n \r\n \r\n    		ÿӱǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ӱ·427Զײ107','020-16449927','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1642','2142','249','0','˳͵()\r\n \r\n \r\n    		˳͵ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ǰ·԰10֮','020-30761229','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1643','2143','249','0','ÿʱÿ̿Ƽ԰()\r\n \r\n \r\n    		ÿʱÿ̿Ƽ԰ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·18ײ','020-87981696','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1644','2144','249','0','¡()\r\n \r\n \r\n    		¡ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·71','020-33543232','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1645','2145','249','0','ŷҼ۶غ͵()\r\n \r\n \r\n    		ŷҼ۶غ͵ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','غ·','020-30422168','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('1646','2146','249','0','ֿͲ()\r\n \r\n \r\n    		ֿͲǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','վǰ·վҵȽ22','020-15442445','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2179','2679','285','0','ɿƷܵ()\r\n \r\n \r\n    		ɿƷܵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·һʿȳ108-109','020-93909276','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2180','2680','285','0','ŵ()\r\n \r\n \r\n    		ŵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ƹʻվ¥һ¥','020-62847235','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2181','2681','285','0','ɽС()\r\n \r\n \r\n    		ɽСǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ͼB1¥','020-58983518','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2182','2682','285','0','Peoples Cakes & Coffee()\r\n \r\n \r\n    		Peoples Cakes & CoffeeǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·17102','020-11355607','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2183','2683','285','0','򿧷Խ()\r\n \r\n \r\n    		򿧷ԽǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','Խ·134101(ֶ)','020-91084629','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2184','2684','285','0','Peoples Cakes & CoffeeԽ()\r\n \r\n \r\n    		Peoples Cakes & CoffeeԽǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','Խ·98֮3','020-42787004','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2185','2685','285','0','DHT Cafeӵ()\r\n \r\n \r\n    		DHT CafeӵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·208ӳǶ¥K269A','020-50270651','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2186','2686','285','0','7()\r\n \r\n \r\n    		7ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','һ·С7','020-50759356','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2187','2687','285','0','ֿȵ()\r\n \r\n \r\n    		ֿȵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ӱ··313ϣײ','020-88063600','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2188','2688','285','0','ŵ()\r\n \r\n \r\n    		ŵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ӱ·28ʱ㳡C4¥','020-88658326','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2189','2689','285','0','̴()\r\n \r\n \r\n    		̴ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·㱦㳡3¥14','020-33400717','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2190','2690','285','0','()\r\n \r\n \r\n    		ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','22102','020-40221932','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2191','2691','285','0','ȤῧȻ()\r\n \r\n \r\n    		ȤῧȻǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·19104','020-59713987','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2192','2692','285','0','372 Cafe()\r\n \r\n \r\n    		372 CafeǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·ɫ԰6','020-78547968','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2193','2693','285','0','ȳ()\r\n \r\n \r\n    		ȳǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ƻ¥1㶫','020-74149562','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2194','2694','285','0','¿ȹ()\r\n \r\n \r\n    		¿ȹǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·21','020-78340322','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2195','2695','285','0','ǰͿ˶ǳǵ()\r\n \r\n \r\n    		ǰͿ˶ǳǵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɽ·219Ŷǳ','020-62800447','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2196','2696','285','0','ȵ()\r\n \r\n \r\n    		ȵǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɽ11101','020-70911607','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2197','2697','285','0','ǰͿ()\r\n \r\n \r\n    		ǰͿǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·йƵײS125','020-52055873','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2198','2698','285','0','꿧()\r\n \r\n \r\n    		꿧ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','·194㳡3¥','020-91993002','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2199','2699','41','0','бʳ޹˾()\r\n \r\n \r\n    		бʳ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','йݴ911923','020-16104757','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2200','2700','41','0','ô(ɳ)()\r\n \r\n \r\n    		ô(ɳ)ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','ɳϽ1Ű¥','020-62658101','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2201','2701','41','0','гҵ޹˾()\r\n \r\n \r\n    		гҵ޹˾ǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','Ԫڶ8','020-43025429','0');
INSERT INTO `p8_fenlei_content_11` VALUES ('2202','2702','41','0','ӿţ()\r\n \r\n \r\n    		ӿţǾҹֵܾӰ׼Ӱ[2002]474ţ׼ҵʽɵȫԵӰԺ߹˾ֱĻýšϺĻչ޹˾Ӣ۵ӰͶ޹˾Ͷʹɣעʽ5,000','аʯ·','020-98738932','0');
INSERT INTO `p8_fenlei_content_2` VALUES ('1','2','17','1','Ȥ,,ڻ,,Ͷ\n\n\n\n\n.ڽҵ(Ʊͱ)бȽо,м׼׸Чĳ,ӭѧϰƱʵս,ԹɻѲԸĵıҵĹ\n','1','23','3','1','4','43','','ʡ',',,ڻ,,Ͷ','6','13144424365','cio780001@yahoo.com.cn','54365436543');
INSERT INTO `p8_fenlei_content_2` VALUES ('2','12','17','4','ҵԱ\n䣺30\nȤ,,ڻ,,Ͷ\n\n\n\n\n.ڽҵ(Ʊͱ)бȽо,м׼׸Чĳ,ӭѧϰƱʵս,ԹɻѲԸĵıҵĹ\n\n','1','30','3','1','4','183','','','','1','13144424365','cio780001@yahoo.com.cn','43785409');
INSERT INTO `p8_fenlei_content_2` VALUES ('3','13','17','5','ҸŮһ~~˹㶫÷,QQ****','1','28','3','1','1','185','','㶫ʡ','','4','','316825529@163.com','85656429');
INSERT INTO `p8_fenlei_content_2` VALUES ('4','14','17','5','˸` ϣʶһЩ` Ͼʱһ` \nQQ **** ','3','25','3','1','1','195','','','','5','','xiezaifeng111@163.com','28812680');
INSERT INTO `p8_fenlei_content_2` VALUES ('5','15','18','5','˴רѧò,һλڹݻݸŮ,1824,Ů,ϵı,лл.гļQQ4695 33203 ٴ˵,.','3','24','3','1','4','175','','','','5','','wnmei205@***.com','469533203');
INSERT INTO `p8_fenlei_content_2` VALUES ('6','16','18','6','Ĺ.ԼҵŮʿΪ..','1','0','1','1','1','192','','','','4','','','823291565');
INSERT INTO `p8_fenlei_content_2` VALUES ('7','17','18','6','ˡŮΪŮ,ʵ,,\n178','1','24','3','1','1','178','','','','7','','','52220000');
INSERT INTO `p8_fenlei_content_2` VALUES ('8','18','19','6','ԭ û̫ʱӴ ͨ58ͬʶԵ ','2','21','1','1','4','163','','','','6','13798166984','145d4fds@163.com','');
INSERT INTO `p8_fenlei_content_2` VALUES ('9','19','19','7','22,㶫,ڹݴ۹,ɰ,ΪƽʱȽæ,ȦС,δҺʵ,Ҫ,ڹȶ,,,ĵغ,25~30֮,170,޲Ⱥ,ٶ!ǳ!!','2','22','1','1','4','155','','','','4','','121851754@qq.com','121851754');
INSERT INTO `p8_fenlei_content_2` VALUES ('10','20','19','7','ҵԱŮ\n䣺22\n㶫\nѧ\n\n\n\n\nʶ...22-25....172ϸ...㿩.....!!5һҪϸ...߿Ѹ..^_^..!!ϣȵͬø!! ʶԼQ¿....ϣӸ...ӹʱ..5עԭ..һɲͨ..л!!\n:http://www.mytianhe.com/spaceindex.php?show_topic.5.html\n','3','22','3','1','4','162','','','','6','','','');
INSERT INTO `p8_fenlei_content_2` VALUES ('14','40','17','1','ע˵:','3','0','1','1','4','','','','','1','','','');
INSERT INTO `p8_fenlei_content_3` VALUES ('1','21','26','7','߼õıʼǱԡҺʾӭѯ\n\n','ʼǱ','5','','','','','13570284349','hwl19841983@sina.com','724670212','');
INSERT INTO `p8_fenlei_content_3` VALUES ('2','22','26','8','Ϊ뻻ʼǱ,Ƿм̨˾õĵԿתų̈,ǱĿ,ǶӲҲȽϤ,ƽıǳáȻм̨ɹѡ,ǶԼõ,Ƕ·յά޹װ,Կɿ⼸̨òһ,ԸԼҪѡһ׵ԵԼ۸:\n\n\n\nԤװWindows XPϵͳ,õǹʶԳҡԵķIBM˾ԭװ,ںõ,ϸ,ʵ,Ҫзǳȶ,ʺڰ칫á۸ȶԶ,ҲЩװԿԱġIBMԭװɫ,Եúܺĸְ,ñͨĵء\n\nCPU933,ڴ512M,Ӳ10G,Կ䡢Դꡢȫ\n\n˳شһһλѵ:õҪƳҵĲƷ,ܸܺ,ӦѧϰӰ֡BTɵҪ,ҽʡ硣תõļ۸˵,Ҳ,Ҫ̨Լõ,ûκ,ǳȶͿɿ,·Щյװ,Ҳά޹װ,ǾԿԷĵ,üͻ۵ԡʹ,ȶ,βԡǿĳЩ,ֻҪӦĲ۾ͿˡʲôֱӲҵ绰ϵ,֮ǰѸ,ûظ\n\n۸:399\nʾһ:תü۸150:15ʾ:ۺС,߳\nʾ:תü۸150:15ϲʾ:ۺС,а˳\nʾ:תü۸250:17ϲƽʾ:ų\n\n','̨ʽ','3','','','399Ԫ','','','haoshare@***.com','33927203','');
INSERT INTO `p8_fenlei_content_3` VALUES ('3','23','26','8','ȫձԭװ,200Ԫ,,ϸͼƬǵվ鿴ʵ --ŵԿƼ http://www.cx020.net--ӭѯ,ͻ ԭװձʿͨС ʿͨСձ2004ǰǳеĵԿʽ۾ʱۣƷǳɣǼСĳʱ䷴ԼͻѹʹõϢܽľ飬ɢȹܡȶܺͲٶȷǳĳɫǶЩʽģҪͬѧѡλҵ˾ȵȿͻƼ ʿͨСųȶܺͷӦٶȡиѧϰ/ͼ/칫/ҳ/QQ/Ӱ/ϷVCDMP3ȶǳ޷䣬ʱۿʹò۾Сɣ븴ӣԼռԼԴʮʺѧѧϰ/칫//ѧ///ϢѯȴʹóϣʹЧԶԶǵ ԭװʿͨ845С4USB2.0ӿڣ֧PXEʹDDRڴ档ʿͨһ֤ܺȶԣƽպ ã42.0GDDR256Mڴ棬40GӲ\n\n','̨ʽ','3','','','200','','82552592','','','');
INSERT INTO `p8_fenlei_content_3` VALUES ('4','24','26','8',' ԤװWindows XPϵͳ,õǹʶԳҡԵķIBM˾ԭװ,ںõ,ϸ,ʵ,Ҫзǳȶ,ʺڰ칫á۸ȶԶ,ҲЩװԿԱġIBMԭװɫ,Եúܺĸְ,ñͨĵء CPU933,ڴ512M,Ӳ10G,Կ䡢Դꡢȫ õķǳȶɿ,ӦͨѧϰӰ֡BT,ҽʡ,ʺ칫,ȶԶԲЩװԺƷƵĵԿԱġ ǿĳЩ,ֻҪӦĲ۾Ϳˡ ۸:399 ʾһ:550Sʾ:150\n\n','̨ʽ','3','','潻','','','','','33927203','');
INSERT INTO `p8_fenlei_content_3` VALUES ('5','25','28','9','ʥͨѶ̳,һԾӪֻͨѶΪ, \n\nһ,ͨʼ첿,Ͽɵ˰羭Ӫ \n\n̳вƷɲֱȨ۾Ӫ̳в \n\nƷɽȫƱ񡣱̳һּ:һ, \n\nһ,ŵһ!ӭѯϵ ½ٷַ: \n\nstsmm.com QQ:961 219189 138--235--359-67ǽ߳Ϊ!!!ʥͨѶȫ \n\nԱ,ף֧:彡 !\n\n','Ʒ','1','','','1690','','','','jsddsj2@163.com','');
INSERT INTO `p8_fenlei_content_3` VALUES ('7','27','28','9','ͺţ17ƽ  17&quot;43cm)ƽ0.24 Ļ ˸ƽͷ䡣 ֱ:1280X102460Hz ѷֱʣ1024X76875Hz 125MHz Ƶ:30-70kHz Ƶ:50-120Hz ƣOSD ѹ:AC110V -240V 50/60Hz 1.7A :75W  곤ṩиߵּȫµ. ITƷ.ɽ.רҵоϵͳ. 칫,ѧ.ΪͻṩɫĲƷԻķ. нɹ. ӭ˾Ի,⵽Ϊֹ! þ ϵˣ ʵ꣺ʯ·ŵԳǶڶ¥2-105','̨ʽ','1','','','350','','13828417411','','','');
INSERT INTO `p8_fenlei_content_3` VALUES ('8','29','31','10','˾շΧ:\n\nְ칫Ʒ:̨Ρɳ칫Ρǰ̨硢չ\nּҾƷ:ʽƤɳ˫(ľ)˫˴桢¹񡢲ӡӹױ̨ȡ \nּõ:ӻ䡢ϴ»΢¯DVDԡʾӡӡ졢ŵȡ\nֿյϵ:ַϾôʽյʽյʽյյ\nֹҵ豸:,,ٴ,ĥ,괲,µƿ,綯,ҵ¯豸ȡ\nƵƷ:̨̨,,,,رʹ,ߡε\n :ֵͭȸֽܼѹʺ̷Ͼɵȡ\n\n\nַ:www.yueyes.com\nַ:ӹ԰Ŷ漴','칫 /','3','','潻','230','','020-85588898','85588898@163.com','','');
INSERT INTO `p8_fenlei_content_3` VALUES ('9','30','31','10','߼ֽչ۸ʣƷ\nֽչ۸Ʒ .ֵ˽豸,յ豸,豸,칫豸,Ƶ豸,ƹ豸,ȵȡ\nάĿ \nά޸ּõյװάάޡѩ֡ \nάһڡ \n깺ҵȫ¡ڹаŻݡ ','յ','2','','潻','','','13533992253','chenjinbing188@126.com','517995142','');
INSERT INTO `p8_fenlei_content_3` VALUES ('10','32','31','10','ѸƼרҵ:διǴճӡˢմݴޡĭࡢPEԷԵֽذ塢ݽ񵼵\nEVAƷϰװ,õĻ塢𡢸ȡѧʴŵ,޶޳ˮƷƿɼӹ,ھ۱ϩ(ĭ)ȴͳװ,ҷϻҪ,ǳڲƷѡ\nӦ÷Χ \nӲƷõ𹤾ߡߡƷƷĻƷױƷȡӭѯ۶','','1','','潻','0.01Ԫ','il','13902473519','rrfgvouf@owsfyrrm.com','635988818','');
INSERT INTO `p8_fenlei_content_4` VALUES ('1','36','43','11','˼\n :ľ  :\n : ״: \n:198309 Ŀ:йԱ \nר ҵ: רҵ(ѧ)  :175CM\nϵ绰:13580450544 ͨѶַ:خ·38ŽžѧԺۺϵ7 ʱ:510502\n\n  \nϲ˶,кܺõԡֱ渺,нǿĴŶӺ\nֹ,,רע,Ͻ,Ĭ\nзḻ֯߻,ϻܳԿ,нǿĺθ,ϸܵ,˽\nѾкǿӦѧϰоͽ\n  \n20039----20077:ͶнžѧԺרҵ ڼѧɱƿγ\n\n20009----20037:Ͷ㶫ʡ⴨еѧ\n רҵ \nһרҵ:\nͨרҵγ̵ѧϰ㱸ʵĿѧĻ֪ʶ,ǿֱ(ͨӢͨ׵ȿԲȡ֤)˶ʶۺ(ѻùﾶë֤鼰ɢ˶Ա֤);Ӧۺ;ʵķɻ֪ʶ͹רҵ\n\nڶרҵ: \nͨѧ,ڵڶרҵķɻ϶Է֪ʶ˸ϵͳ͸֪,һĴʶͶȡ֪ʶ,ܹѧ֪ʶԿ͹н͡Ԥ⡢\n&#61557;  \n 2007,ѧԺѧԱѧɲ\n 2006,θУ̹١ƺ\n 2006,ѧԺѧԱѧɲ\n 2005,ѧԺΡν\n 2005,ѧԺѧԱѧɲ\n 2004,ѧԺѧԱѧɲ\n 2003,ѧԺѧˡڶ\n 2003,ѧԺѧԱѧɲ Ա\n 20002003αΪѧ Ա Ÿɲ\nɲ\n\nʵ \n 200320077 ѧԺ߶һ,֯شȡһҵ\n 20071 һŹ˾ѧϰṤ\n 20069 ڹҽҩѧѵ\n 20066 εҵλչѵ\n 20066 ιԽѧй\n 20059 ڹ㶫ѧԺѵ\n 20058 ⴨нɳѧϰ \n 20054 μȫģ\n 20043 ѧԺѧ׷СԱ\n ޿γ \n1 γ\n˼Ʒ˼ѧԭСƽۡ˼ξѧѧۡѧġѧӢë˼Ȼγ̡\n2רҵγ\nѧѧ˶ҽѧ˶ѵѧ˶ѧԱʶۡдڲšѧ֯Ϊѧѧ̷ѧ˶ѧ鷨١񶷡Ӿսµѧרҵγ̡\n&#61557; ְ \n뱾ѧרҵصĽšѧУҵְλ,оѡнϺ÷չǰҵ˾սԡܲԼҵ\n\n\n˼ֵȡ\n޵Ͷ뵽޵Ĺȥ,ΪʵԼֵŬֻܶҪи,ͻջ!\nŬܶ---̬Ⱦ\nѧϰ---֪ʶı \n¸ȡ---жɾδ\n\n\n','','ľ','1','','1','','175','63','4','','','нžѧԺ','','','','2','','','','','','','13580450544','djk.xxx88@163.com','djk.xxx88@163.com','خ·38ŽžѧԺۺϵ7');
INSERT INTO `p8_fenlei_content_4` VALUES ('2','37','43','11','һ9,˳¡ǹ,Ϥ齭޵·ӭΰ͡˾˳ڰ,ػ,ǳʵáϵ:\n','','ggh','1','','1','','180','80','5','','','','','','','1','','','','','','76y','15817525724','laihongmao@yahoo.com.cn','123456789','');
INSERT INTO `p8_fenlei_content_4` VALUES ('3','38','43','11','ѧ/ר нҪ\n    ˻Ϣ   Ů £19851121  ס أ ޣ5  ڣ㶫 · ƣڹͨԱ  2007/04 ǧǧϹƷ޹˾ ӪԱ꾭ʦ 㱨ϼܼ 5 Ҫְ Э̽µ꿪ҵԱƸѵҵӪҵƹ㣻 ״Чĵڿ ЭԱƶĿ۷Ա뼤 ֵг ̻ռ뵵 Ͻڵάг Ͻڵֳָ۴Աѵ ϽڵҵĿɵĹ ϼŵ ҵ 120075£ڱʵʩ۴ҵ1.2Ԫ/1.8Ԫ/£ 2200767£ںԴϽʵʩ۴ҵ6ǧԪ/1.4Ԫ1.5Ԫ/£ 32007910£ڶݸ̩꣬ҵ1.3Ԫ/1.8Ԫ/£һ̵Ŷӣ꾭͵Աܼ4ˣ 4200712£ڽ򽭵µ꿪ҵԱƸѵ̿ҵһӪŶӣڿҵҵȫһ 5200712£ںʵʩµ꿪ҵ·ƹ㡢ԱƸѵڿҵҵȫڶ 2005/12--2006/12عؿƵ·ֹ˾ ҵ 㱨ϼ 3 Ҫְ ֯͵ѯ ռ˿ϼٷ ҵԱѵ ҵ ְһµʱڣһ̨11ԪƵݣعҵԱҪһʱſɵҵ 㱨ϼ 3ҵԱ 2003/02--2005/06ѧԺУ԰ Աܡ 㱨ϼϰ 16 Ҫְ  Ʒǰ̨̨ά ӪҵԱǡ۹ Э빩Ӧ̡ҵԱĹϵ дƹ㣻 Ĺ  2001ꡪ2003꣬·ڶѧ бҵ','','','2','','1','','163','53','3','','','','','','','','','gg','','','','','13249750395','','123456789','');
INSERT INTO `p8_fenlei_content_4` VALUES ('4','39','44','12','ƹѼ\n:ƹ Ա:\n:1987.6 ѧ:ڶ\nרҵ:ϢϢϵͳ \nϵʽ:13631479387 QQ:452337719\n:gengjiah@126.com\nַ:㶫ѧԺ338\n:2003.9-2006.7Ͷһѧ\n2006.9Ͷ㶫ѧԺ\n\nְ:ڲЭ ѧϰίԱ㲥̨ز,ϢѧԺɱಿ,ϢѧԺɱಿ,ѧԺѧϢԱ,\nüس:ƹ򡢵\n\n:2006.7-8 ɳϪƵƷǳͨ˾Ա\n2007.1 ɳϪƵƷǺǾƵƷ˾Ա\n2007.3-5 ڲʿ׼ְ\n2007.7-8 ƶҵԱ\n:־ѧ,ѧɲ,Ÿ\n\n:ʡšѧϰǿɡ̲,ϳԿ,õŶʶ빵ͨ,ϲս\n','ϢϢϵͳ','ƹ','1','','1','','163','53','4','','','һѧ','ϢϢϵͳ','','Ӣ','1','','ϢϢϵͳ','','','','ϢϢϵͳ','13631479387','gengjiah@126.com','452337719','㶫ѧԺ338');
INSERT INTO `p8_fenlei_content_4` VALUES ('5','40','44','12','𷿵ز޹˾˽30زʵսӪͼԴ,ԷزϢѯӪ߻ʡ\n\nƵΪҪչҵ,־ڷչΪйزҵרҵۺϷ̡,Ϊزҵҵ͸ṩʵս\n\nֵרҵ񡣹˾ܼͼ½˾վwww.eaky.com鿴\n\nҪ,Ƹְʵϰѧ,ͼ޶Ű湤,Ƹ2\n\n:Ѿдͼָȵ޶,Ҷͼд˳򡢱ּͼݽʵӻɾ,޶е\n\nWORDŰ档\nʱ:ÿܳϵʱܹ,١\n:\n110,ÿ45Ԫ;ںÿ55Ԫ,ʱ7.5Сʱڡ\n2ֱ༭ͼ齫ͼʱڡαԱд\n3ڼ佫ѧϰ㷺ķز֪ʶ\nַ:˾칫ҡ\n\n\nҪ\n1ĵĿרҵıƴѧ\n2ҪĹ,дǿ\n3г,վڶ߽Ƕ˼ⲢݶҪ޶д\n4WORDŰ,WORDͷͼͱ,ٶȿ,Ű\n5Ů,ʵ,Чʸߡ\n\nҹ˾˻,һƪд·͵eakykh@126.com,עӦƸӦƸͼ༭++ѧУ\n\n,ƸϢЧ,,֪ͨԡ\n칫ַ:б·62ײ(齭ӾվԱֱͤ60)\n绰:84049508\n\n','ͼ༭','','1','','1','','','','6','','','','ͼ༭','','','1','','ʵϰ','','','','ͼ༭','15812345678','yuyp@eaky.com','84049508','б·62ײ(齭ӾվԱֱͤ60)');
INSERT INTO `p8_fenlei_content_8` VALUES ('1','4','8','2','иԴδϸ¼,---ԭزⲿhttp://www.gzcentaline.com.cn/SecondHand/Sec_Area.aspx?&a=0&tx=15902047274&st=1&tt=t\n˲http://blog.soufun.com/phvincen','3','41Ԫ','4','2','810','ˮ','԰¥,','԰','3','88','','15902047274','phvincen@163.com','');
INSERT INTO `p8_fenlei_content_8` VALUES ('2','5','8','2','иԴδϸ¼,---ԭزⲿhttp://www.gzcentaline.com.cn/SecondHand/Sec_Area.aspx?&a=0&tx=15902047274&st=1&tt=t\n˲http://blog.soufun.com/phvincen','1','45Ԫ','4','2','265','ˮ','ݱ̹԰','ݱ̹԰','3','70','С','15902047274','phvincen@163.com','');
INSERT INTO `p8_fenlei_content_8` VALUES ('3','7','8','3',':::˺Ժڱ˳ȫװ޸ߵķ:\n\nһһĳ۸:600Ԫ/. ٰ\n\nһһĳۼ۸:11.5/.\n\nһĳ۸:800Ԫ/,ٰ\n\nһĳۼ۸:14.5/.\n\nҶĳۼ۸Ϊ:25/ס\n\n\ṉ߽¥һ9,2350ƽ,۸: ϵ绰02086459737 QQռ http://user.qzone.qq.com/965395438 ¥⾰ھ ,Ȥȥ\n\nqqռ http://user.qzone.qq.com/965395438 аӵʵͼƬ,2007׸ߵװ,ȫµĺˮ,ӻ,ɳ,,¹ȼҾ,ȤĿԽҿռῴ,֤,ѯ绰020-86459737 \nQQ:965395438 ϵ: \n\n·:510( ·糵վ) 259( ͬά )828( ̫) 840( ݻվ) га;ͤվ³,ע:ͤվھΪϳյվ,,\nʮ·ݴ˵ػͨ,ӭǰʵؿ.ϼ۸.\n\nش:зӾΪ,Ա֤н.\n\n','2','14.5Ԫ','4','2','259ͤվ³','ˮ','563268',' ˺ ','3','67','','02086459737','chushoufangzi@163.com','965395438');
INSERT INTO `p8_fenlei_content_8` VALUES ('4','11','8','4','','2','600Ԫ/','4','2','259ͤվ³','ˮ','1414','','3','45','','02086459737','','965395438');
INSERT INTO `p8_fenlei_content_9` VALUES ('1','8','12','3','԰λɳ̫·,λõ,ʮ·;Ŀ,5ֱӱ,ܶз,Ϊĸ¹ݾӢҵѡ,һ,Ӱ̷,粽;滮еĵ;\n๦ֲܾ,ø˶ʩ,滮Լ5000ƽ׵ٽ̡д¥ ܱҽԺСе;ĺСѧ75ѧѧƼ;\nȫ򱣰Ѳ,ṩάޡȷ','','ɳ̫· ԰','2','','2000Ԫ/105O/','4','4','','1','2','1','1','','13538971155','xiepenggo@163.com','');
INSERT INTO `p8_fenlei_content_9` VALUES ('2','9','12','3','ɴ¥,ڽϴҵȦ,2ߡվ;װ,칫ͨѶ豸ȫ,ɰ֤԰ʽİ칫,24Сʱ;жҴҵеССҵסڴһסĽ,Ϊǵ!иֿ⡢̳)н!','ggg','ڽϴ','2','300','45/300O','4','4','150','1','2','1','1','yju','15920398893','BT.84342832@163.com','');
INSERT INTO `p8_fenlei_content_9` VALUES ('3','10','12','4','ͣ \nλڱڴ齭ҽԺٽ·д½ɵС̳ (Լ40,4.1ס߶3.8) ,ǰдʱͣʳͰٻꡢݵꡢմɵꡢȵҵ,ͬʱ¥ⶨΪС;װд¥֮;ܱ߻ǻ԰齭ϾԷ̩г齭ҽԺн飬ӭµ̸','',' - 齭ҽԺԸ','2','50','1250','4','4','500','1','','1','0','rt','15920398893','','');
INSERT INTO `p8_fenlei_module` VALUES ('1','񷿳/','20','','a:7:{s:8:\"field_db\";a:16:{s:6:\"h_have\";a:17:{s:5:\"title\";s:8:\"ʩ\";s:10:\"field_name\";s:6:\"h_have\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:100;s:9:\"form_type\";s:8:\"checkbox\";s:8:\"form_set\";s:118:\"ˮ\r\n\r\nܵú\r\nߵ\r\n\r\n绰\r\n\r\nӻ\r\nϴ»\r\nˮ\r\nյ\r\nů\r\nú\r\n̻\r\n΢¯\r\n\r\n\";s:10:\"form_value\";s:9:\"ˮ/\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"1\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:7:\"content\";a:11:{s:5:\"title\";s:8:\"ע˵\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:7:\"b_money\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:7:\"b_money\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:8:\"h_height\";a:17:{s:5:\"title\";s:19:\"¥߼/ڵڼ\";s:10:\"field_name\";s:8:\"h_height\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:5:\"h_bus\";a:17:{s:5:\"title\";s:8:\"·\";s:10:\"field_name\";s:5:\"h_bus\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:9:\"h_address\";a:17:{s:5:\"title\";s:8:\"ϸַ\";s:10:\"field_name\";s:9:\"h_address\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:150;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:9:\"h_paytype\";a:17:{s:5:\"title\";s:8:\"ʽ\";s:10:\"field_name\";s:9:\"h_paytype\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:32:\"1|¸\r\n2|\r\n3|긶\r\n4|\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:9:\"h_acreage\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:9:\"h_acreage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:6:\"ƽ\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:10:\"h_username\";a:17:{s:5:\"title\";s:6:\"ϵ\";s:10:\"field_name\";s:10:\"h_username\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:7:\"h_email\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:7:\"h_email\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:7:\"h_owner\";a:17:{s:5:\"title\";s:13:\"С/ҵ\";s:10:\"field_name\";s:7:\"h_owner\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:4:\"h_qq\";a:17:{s:5:\"title\";s:6:\"QQ/MSN\";s:10:\"field_name\";s:4:\"h_qq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:10:\"my_mantype\";a:17:{s:5:\"title\";s:10:\"\";s:10:\"field_name\";s:10:\"my_mantype\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:5:\"radio\";s:8:\"form_set\";s:14:\"1|\r\n2|н\";s:10:\"form_value\";s:1:\"1\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:5:\"h_tel\";a:17:{s:5:\"title\";s:8:\"ϵֻ\";s:10:\"field_name\";s:5:\"h_tel\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:7:\"h_rooms\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:7:\"h_rooms\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:42:\"1|һ\r\n2|\r\n3|\r\n4|ľ\";s:10:\"form_value\";s:1:\"1\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:4:\"h_zs\";a:17:{s:5:\"title\";s:8:\"װ\";s:10:\"field_name\";s:4:\"h_zs\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:44:\"1|ͨװ\r\n2|װ\r\n3|װ\r\n4|ǳ\";s:10:\"form_value\";s:1:\"2\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}s:9:\"search_db\";a:3:{s:7:\"h_rooms\";s:4:\"\";s:4:\"h_zs\";s:8:\"װ\";s:10:\"my_mantype\";s:10:\"\";}s:10:\"imgShow_db\";a:3:{s:4:\"h_qq\";s:6:\"QQ/MSN\";s:5:\"h_tel\";s:8:\"ϵֻ\";s:7:\"h_email\";s:4:\"\";}s:13:\"IfMobPhone_db\";a:1:{s:5:\"h_tel\";s:8:\"ϵֻ\";}s:12:\"IfListSearch\";a:3:{s:10:\"my_mantype\";s:10:\"\";s:7:\"h_rooms\";s:4:\"\";s:4:\"h_zs\";s:8:\"װ\";}s:10:\"IfListShow\";a:1:{s:6:\"h_have\";s:8:\"ʩ\";}}','','0');
INSERT INTO `p8_fenlei_module` VALUES ('2','','0','','a:7:{s:8:\"field_db\";a:14:{s:5:\"m_age\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:5:\"m_age\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:3;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:4:\"()\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:7:\"m_money\";a:17:{s:5:\"title\";s:10:\"\";s:10:\"field_name\";s:7:\"m_money\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:82:\"1|\r\n2|1000\r\n3|1000-2000\r\n4|2000-3000\r\n5|3000-4000\r\n6|4000-5000\r\n7|5000\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:6:\"m_work\";a:17:{s:5:\"title\";s:8:\"ְҵ\";s:10:\"field_name\";s:6:\"m_work\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:8:\"m_school\";a:17:{s:5:\"title\";s:4:\"ѧ\";s:10:\"field_name\";s:8:\"m_school\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:64:\"1|Сѧ\r\n2|\r\n3|\r\n4|ר\r\n5|ר\r\n6|\r\n7|о\r\n8|ʿ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:7:\"m_email\";a:17:{s:5:\"title\";s:8:\"ϵ\";s:10:\"field_name\";s:7:\"m_email\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:40;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"m_mar\";a:17:{s:5:\"title\";s:8:\"״\";s:10:\"field_name\";s:5:\"m_mar\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:8:\"form_set\";s:30:\"1|δ\r\n2|ѻ\r\n3|\r\n4|\";s:10:\"form_value\";s:1:\"4\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:4:\"m_qq\";a:17:{s:5:\"title\";s:6:\"QQ/MSN\";s:10:\"field_name\";s:4:\"m_qq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"m_tel\";a:17:{s:5:\"title\";s:8:\"ϵֻ\";s:10:\"field_name\";s:5:\"m_tel\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:10:\"m_province\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:10:\"m_province\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:18;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:324:\"\r\n㽭ʡ\r\n\r\nʡ\r\nϺ\r\nʡ\r\n\r\nʡ\r\nر\r\nɽʡ\r\nر\r\nʡ\r\nɹ\r\nʡ\r\n½ά\r\nʡ\r\nĻ\r\n㶫ʡ\r\n\r\nʡ\r\n׳\r\nĴʡ\r\nӱʡ\r\nʡ\r\nɽʡ\r\nʡ\r\nʡ\r\nʡ\r\nʡ\r\nʡ\r\nʡ\r\nຣʡ\r\nʡ\r\n̨ʡ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:15:\"ĸʡ?\";s:10:\"IfListShow\";s:1:\"1\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:11:\"m_intersing\";a:17:{s:5:\"title\";s:12:\"Ȥ\";s:10:\"field_name\";s:11:\"m_intersing\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:8:\"m_height\";a:17:{s:5:\"title\";s:12:\"(CM)\";s:10:\"field_name\";s:8:\"m_height\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:6:\"m_star\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:6:\"m_star\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:121:\"1|\r\n2|ţ\r\n3|˫\r\n4|з\r\n5|ʨ\r\n6|Ů\r\n7|\r\n8|Ы\r\n9|\r\n10|Ħ\r\n11|ˮƿ\r\n12|˫\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"m_sex\";a:17:{s:5:\"title\";s:4:\"Ա\";s:10:\"field_name\";s:5:\"m_sex\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:8:\"form_set\";s:18:\"1|\r\n2|Ů\r\n3|\";s:10:\"form_value\";s:1:\"3\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:7:\"content\";a:17:{s:5:\"title\";s:8:\"ע˵\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}s:9:\"search_db\";a:7:{s:5:\"m_sex\";s:4:\"Ա\";s:7:\"h_money\";s:10:\"\";s:10:\"m_province\";s:4:\"\";s:8:\"m_school\";s:4:\"ѧ\";s:7:\"m_money\";s:10:\"\";s:5:\"m_mar\";s:8:\"״\";s:6:\"m_star\";s:4:\"\";}s:10:\"imgShow_db\";a:3:{s:5:\"m_tel\";s:8:\"ϵֻ\";s:4:\"m_qq\";s:6:\"QQ/MSN\";s:7:\"m_email\";s:8:\"ϵ\";}s:13:\"IfMobPhone_db\";a:1:{s:5:\"m_tel\";s:8:\"ϵֻ\";}s:12:\"IfListSearch\";a:5:{s:5:\"m_sex\";s:4:\"Ա\";s:7:\"m_money\";s:10:\"\";s:8:\"m_school\";s:4:\"ѧ\";s:5:\"m_mar\";s:8:\"״\";s:6:\"m_star\";s:4:\"\";}s:10:\"IfListShow\";a:1:{s:10:\"m_province\";s:4:\"\";}}','','0');
INSERT INTO `p8_fenlei_module` VALUES ('3','г','0','','a:7:{s:8:\"field_db\";a:11:{s:10:\"t_shopname\";a:17:{s:5:\"title\";s:8:\"Ʒ\";s:10:\"field_name\";s:10:\"t_shopname\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:8:\"t_hownew\";a:17:{s:5:\"title\";s:8:\"¾ɳ̶\";s:10:\"field_name\";s:8:\"t_hownew\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:88:\"1|ȫ\r\n2|9\r\n3|8\r\n4|7\r\n5|6\r\n6|5\r\n7|4\r\n8|3\r\n9|2\r\n10|1\";s:10:\"form_value\";s:1:\"5\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:9:\"t_buytime\";a:17:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:9:\"t_buytime\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"time\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:9:\"t_buytype\";a:17:{s:5:\"title\";s:8:\"׷ʽ\";s:10:\"field_name\";s:9:\"t_buytype\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:5:\"radio\";s:8:\"form_set\";s:18:\"潻\r\nϽ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:7:\"t_money\";a:17:{s:5:\"title\";s:4:\"۸\";s:10:\"field_name\";s:7:\"t_money\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"Ԫ\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:10:\"t_username\";a:17:{s:5:\"title\";s:6:\"ϵ\";s:10:\"field_name\";s:10:\"t_username\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:7:\"t_email\";a:17:{s:5:\"title\";s:8:\"ϵ\";s:10:\"field_name\";s:7:\"t_email\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:4:\"t_qq\";a:17:{s:5:\"title\";s:6:\"QQ/MSN\";s:10:\"field_name\";s:4:\"t_qq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"t_tel\";a:17:{s:5:\"title\";s:8:\"ϵֻ\";s:10:\"field_name\";s:5:\"t_tel\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:9:\"my_ifsell\";a:17:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:9:\"my_ifsell\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:4;s:9:\"form_type\";s:5:\"radio\";s:8:\"form_set\";s:10:\"\r\n\";s:10:\"form_value\";s:4:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"1\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:7:\"content\";a:17:{s:5:\"title\";s:8:\"ע˵\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}s:10:\"imgShow_db\";a:2:{s:5:\"t_tel\";s:8:\"ϵֻ\";s:7:\"t_email\";s:8:\"ϵ\";}s:13:\"IfMobPhone_db\";a:1:{s:5:\"t_tel\";s:8:\"ϵֻ\";}s:9:\"search_db\";a:2:{s:8:\"t_hownew\";s:8:\"¾ɳ̶\";s:9:\"my_ifsell\";s:8:\"\";}s:12:\"IfListSearch\";a:2:{s:8:\"t_hownew\";s:8:\"¾ɳ̶\";s:9:\"my_ifsell\";s:8:\"\";}s:10:\"IfListShow\";a:1:{s:9:\"my_ifsell\";s:8:\"\";}}','','0');
INSERT INTO `p8_fenlei_module` VALUES ('4','ְ','0','','a:7:{s:8:\"field_db\";a:27:{s:5:\"q_job\";a:17:{s:5:\"title\";s:8:\"ְλ\";s:10:\"field_name\";s:5:\"q_job\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:40;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:10:\"q_truename\";a:17:{s:5:\"title\";s:8:\"ʵ\";s:10:\"field_name\";s:10:\"q_truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:6:\"q_born\";a:17:{s:5:\"title\";s:10:\"\";s:10:\"field_name\";s:6:\"q_born\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"time\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"q_mzu\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:5:\"q_mzu\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:5:\"radio\";s:8:\"form_set\";s:14:\"\r\n\";s:10:\"form_value\";s:4:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:8:\"q_height\";a:17:{s:5:\"title\";s:8:\"(CM)\";s:10:\"field_name\";s:8:\"q_height\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:5;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:8:\"q_weight\";a:17:{s:5:\"title\";s:8:\"(KG)\";s:10:\"field_name\";s:8:\"q_weight\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:6;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:8:\"q_school\";a:17:{s:5:\"title\";s:8:\"ѧ\";s:10:\"field_name\";s:8:\"q_school\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:64:\"1|Сѧ\r\n2|\r\n3|ר\r\n4|\r\n5|ר\r\n6|\r\n7|о\r\n8|ʿ\r\n\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:10:\"q_province\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:10:\"q_province\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:324:\"\r\n㽭ʡ\r\n\r\nʡ\r\nϺ\r\nʡ\r\n\r\nʡ\r\nر\r\nɽʡ\r\nر\r\nʡ\r\nɹ\r\nʡ\r\n½ά\r\nʡ\r\nĻ\r\n㶫ʡ\r\n\r\nʡ\r\n׳\r\nĴʡ\r\nӱʡ\r\nʡ\r\nɽʡ\r\nʡ\r\nʡ\r\nʡ\r\nʡ\r\nʡ\r\nʡ\r\nຣʡ\r\nʡ\r\n̨ʡ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"1\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:10:\"q_computer\";a:17:{s:5:\"title\";s:10:\"\";s:10:\"field_name\";s:10:\"q_computer\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:4;s:9:\"form_type\";s:5:\"radio\";s:8:\"form_set\";s:16:\"һ\r\n\r\nͨ\";s:10:\"form_value\";s:4:\"һ\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:13:\"q_levevschool\";a:17:{s:5:\"title\";s:8:\"ҵѧУ\";s:10:\"field_name\";s:13:\"q_levevschool\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:12:\"q_speciality\";a:17:{s:5:\"title\";s:8:\"ѧרҵ\";s:10:\"field_name\";s:12:\"q_speciality\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:40;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:6:\"q_city\";a:17:{s:5:\"title\";s:12:\"Ŀǰڳ\";s:10:\"field_name\";s:6:\"q_city\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:6:\"q_lang\";a:17:{s:5:\"title\";s:8:\"Ƴ\";s:10:\"field_name\";s:6:\"q_lang\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:8;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:50:\"Ӣ\r\nӢļ\r\nӢ\r\n\r\n\r\n\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:10:\"q_workyear\";a:17:{s:5:\"title\";s:10:\"ѹ\";s:10:\"field_name\";s:10:\"q_workyear\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:6;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:10:\"q_workstar\";a:17:{s:5:\"title\";s:12:\"ʱμӹ\";s:10:\"field_name\";s:10:\"q_workstar\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"time\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:11:\"q_workwhere\";a:17:{s:5:\"title\";s:12:\"֮ǰλ\";s:10:\"field_name\";s:11:\"q_workwhere\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:10:\"q_wantwork\";a:17:{s:5:\"title\";s:12:\"\";s:10:\"field_name\";s:10:\"q_wantwork\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:14:\"q_worktimestar\";a:17:{s:5:\"title\";s:8:\"ʱ\";s:10:\"field_name\";s:14:\"q_worktimestar\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:4;s:9:\"form_type\";s:5:\"radio\";s:8:\"form_set\";s:10:\"\r\n\";s:10:\"form_value\";s:4:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:8:\"q_strong\";a:17:{s:5:\"title\";s:8:\"س\";s:10:\"field_name\";s:8:\"q_strong\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:6:\"q_mail\";a:17:{s:5:\"title\";s:8:\"ϵ\";s:10:\"field_name\";s:6:\"q_mail\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:9:\"q_address\";a:17:{s:5:\"title\";s:8:\"ϸַ\";s:10:\"field_name\";s:9:\"q_address\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:100;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:7:\"content\";a:17:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:7:\"q_money\";a:17:{s:5:\"title\";s:8:\"н\";s:10:\"field_name\";s:7:\"q_money\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:157:\"\r\n500-1000Ԫ/\r\n1000-2000Ԫ/\r\n2000-3000Ԫ/\r\n3000-4000Ԫ/\r\n4000-5000Ԫ/\r\n5000-6000Ԫ/\r\n6000-7000Ԫ/\r\n7000-8000Ԫ/\r\n8000-9000Ԫ/\r\nһ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"q_mar\";a:17:{s:5:\"title\";s:8:\"״\";s:10:\"field_name\";s:5:\"q_mar\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:22:\"1|δ\r\n2|ѻ\r\n3|\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:4:\"q_qq\";a:17:{s:5:\"title\";s:6:\"QQ/MSN\";s:10:\"field_name\";s:4:\"q_qq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"q_tel\";a:17:{s:5:\"title\";s:8:\"ϵֻ\";s:10:\"field_name\";s:5:\"q_tel\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"q_sex\";a:17:{s:5:\"title\";s:4:\"Ա\";s:10:\"field_name\";s:5:\"q_sex\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:8:\"form_set\";s:10:\"1|\r\n2|Ů\";s:10:\"form_value\";s:1:\"1\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:1:{s:4:\"q_jl\";s:8:\"\";}s:9:\"search_db\";a:4:{s:5:\"q_sex\";s:4:\"Ա\";s:8:\"q_school\";s:8:\"ѧ\";s:10:\"q_province\";s:4:\"\";s:5:\"q_mar\";s:8:\"״\";}s:10:\"imgShow_db\";a:3:{s:4:\"q_qq\";s:6:\"QQ/MSN\";s:5:\"q_tel\";s:8:\"ϵֻ\";s:6:\"q_mail\";s:8:\"ϵ\";}s:13:\"IfMobPhone_db\";a:1:{s:5:\"q_tel\";s:8:\"ϵֻ\";}s:12:\"IfListSearch\";a:3:{s:8:\"q_school\";s:8:\"ѧ\";s:5:\"q_mar\";s:8:\"״\";s:5:\"q_sex\";s:4:\"Ա\";}s:10:\"IfListShow\";a:1:{s:10:\"q_province\";s:4:\"\";}}','','0');
INSERT INTO `p8_fenlei_module` VALUES ('5','ҵƸ','0','','a:7:{s:8:\"field_db\";a:25:{s:13:\"z_companyname\";a:17:{s:5:\"title\";s:8:\"˾\";s:10:\"field_name\";s:13:\"z_companyname\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"z_job\";a:17:{s:5:\"title\";s:8:\"Ƹְλ\";s:10:\"field_name\";s:5:\"z_job\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:40;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"z_num\";a:17:{s:5:\"title\";s:8:\"Ƹ\";s:10:\"field_name\";s:5:\"z_num\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:3;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:11:\"z_workwhere\";a:17:{s:5:\"title\";s:8:\"ص\";s:10:\"field_name\";s:11:\"z_workwhere\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:8:\"z_zhushu\";a:17:{s:5:\"title\";s:8:\"ס\";s:10:\"field_name\";s:8:\"z_zhushu\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:8;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:30:\"ṩ\r\nס\r\n\r\nס\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"1\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:6:\"z_wage\";a:17:{s:5:\"title\";s:4:\"н\";s:10:\"field_name\";s:6:\"z_wage\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:181:\"1|\r\n2|500-1000Ԫ/\r\n3|1000-2000Ԫ/\r\n4|2000-3000Ԫ/\r\n5|3000-4000Ԫ/\r\n6|4000-5000Ԫ/\r\n7|5000-6000Ԫ/\r\n8|6000-7000Ԫ/\r\n9|7000-8000Ԫ/\r\n10|8000-9000Ԫ/\r\n11|һ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:10:\"z_workyear\";a:17:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:10:\"z_workyear\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:3;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:4:\"()\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:11:\"z_schoolage\";a:17:{s:5:\"title\";s:8:\"ѧҪ\";s:10:\"field_name\";s:11:\"z_schoolage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:48:\"Сѧ\r\n\r\nר\r\n\r\nר\r\n\r\nо\r\nʿ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:6:\"z_lang\";a:17:{s:5:\"title\";s:8:\"Ҫ\";s:10:\"field_name\";s:6:\"z_lang\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:15:\"z_computerlevel\";a:17:{s:5:\"title\";s:14:\"ˮƽҪ\";s:10:\"field_name\";s:15:\"z_computerlevel\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:8;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:24:\"Ҫ\r\nһ\r\n\r\nͨ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"z_sex\";a:17:{s:5:\"title\";s:8:\"ԱҪ\";s:10:\"field_name\";s:5:\"z_sex\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:20:\"1|Ҫ\r\n2|\r\n3|Ů\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:8:\"z_zuanye\";a:17:{s:5:\"title\";s:8:\"רҵҪ\";s:10:\"field_name\";s:8:\"z_zuanye\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"z_age\";a:17:{s:5:\"title\";s:8:\"Ҫ\";s:10:\"field_name\";s:5:\"z_age\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:8:\"z_height\";a:17:{s:5:\"title\";s:8:\"Ҫ\";s:10:\"field_name\";s:8:\"z_height\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:8:\"z_weight\";a:17:{s:5:\"title\";s:8:\"Ҫ\";s:10:\"field_name\";s:8:\"z_weight\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:8:\"z_health\";a:17:{s:5:\"title\";s:8:\"Ҫ\";s:10:\"field_name\";s:8:\"z_health\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:7:\"z_other\";a:17:{s:5:\"title\";s:4:\"ע\";s:10:\"field_name\";s:7:\"z_other\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:10:\"z_username\";a:17:{s:5:\"title\";s:6:\"ϵ\";s:10:\"field_name\";s:10:\"z_username\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:7:\"z_email\";a:17:{s:5:\"title\";s:8:\"ϵ\";s:10:\"field_name\";s:7:\"z_email\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:9:\"z_address\";a:17:{s:5:\"title\";s:12:\"˾ϸַ\";s:10:\"field_name\";s:9:\"z_address\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:100;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:10:\"z_postcode\";a:17:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:10:\"z_postcode\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:6;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"z_fax\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:5:\"z_fax\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:4:\"z_qq\";a:17:{s:5:\"title\";s:6:\"QQ/MSN\";s:10:\"field_name\";s:4:\"z_qq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"z_tel\";a:17:{s:5:\"title\";s:8:\"ϵ绰\";s:10:\"field_name\";s:5:\"z_tel\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:7:\"content\";a:17:{s:5:\"title\";s:8:\"˾\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:6:\"ieedit\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:1:{s:7:\"content\";s:8:\"˾\";}s:10:\"imgShow_db\";a:4:{s:4:\"z_qq\";s:6:\"QQ/MSN\";s:5:\"z_tel\";s:8:\"ϵ绰\";s:7:\"z_email\";s:8:\"ϵ\";s:5:\"z_fax\";s:4:\"\";}s:13:\"IfMobPhone_db\";a:1:{s:5:\"z_tel\";s:8:\"ϵ绰\";}s:10:\"IfListShow\";a:1:{s:8:\"z_zhushu\";s:8:\"ס\";}s:9:\"search_db\";a:2:{s:6:\"z_wage\";s:4:\"н\";s:5:\"z_sex\";s:8:\"ԱҪ\";}s:12:\"IfListSearch\";a:2:{s:6:\"z_wage\";s:4:\"н\";s:5:\"z_sex\";s:8:\"ԱҪ\";}}','','0');
INSERT INTO `p8_fenlei_module` VALUES ('8','񷿳/','19','','a:6:{s:8:\"field_db\";a:15:{s:8:\"h_height\";a:17:{s:5:\"title\";s:19:\"¥߼/ڵڼ\";s:10:\"field_name\";s:8:\"h_height\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:7:\"h_rooms\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:7:\"h_rooms\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:42:\"1|һ\r\n2|\r\n3|\r\n4|ľ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:7:\"h_owner\";a:17:{s:5:\"title\";s:13:\"С/ҵ\";s:10:\"field_name\";s:7:\"h_owner\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:5:\"h_bus\";a:17:{s:5:\"title\";s:12:\"·\";s:10:\"field_name\";s:5:\"h_bus\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:9:\"h_address\";a:17:{s:5:\"title\";s:8:\"ϸַ\";s:10:\"field_name\";s:9:\"h_address\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:150;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:9:\"h_acreage\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:9:\"h_acreage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:6:\"ƽ\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:10:\"h_username\";a:17:{s:5:\"title\";s:6:\"ϵ\";s:10:\"field_name\";s:10:\"h_username\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:7:\"h_email\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:7:\"h_email\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:9:\"h_paytype\";a:17:{s:5:\"title\";s:8:\"ʽ\";s:10:\"field_name\";s:9:\"h_paytype\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:32:\"1|һθ\r\n2|ڸ\r\n3|\";s:10:\"form_value\";s:1:\"3\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:6:\"h_have\";a:17:{s:5:\"title\";s:8:\"ʩ\";s:10:\"field_name\";s:6:\"h_have\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:100;s:9:\"form_type\";s:8:\"checkbox\";s:8:\"form_set\";s:20:\"ˮ\r\nܵú\r\n\";s:10:\"form_value\";s:4:\"ˮ\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:4:\"h_zs\";a:17:{s:5:\"title\";s:8:\"װ\";s:10:\"field_name\";s:4:\"h_zs\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:48:\"1|ͨװ\r\n2|װ\r\n3|װ\r\n4|ǳװ\";s:10:\"form_value\";s:1:\"2\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:7:\"b_money\";a:17:{s:5:\"title\";s:4:\"۸\";s:10:\"field_name\";s:7:\"b_money\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:4:\"h_qq\";a:17:{s:5:\"title\";s:6:\"QQ/MSN\";s:10:\"field_name\";s:4:\"h_qq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:5:\"h_tel\";a:17:{s:5:\"title\";s:8:\"ϵֻ\";s:10:\"field_name\";s:5:\"h_tel\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}s:7:\"content\";a:17:{s:5:\"title\";s:8:\"ע˵\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";i:0;s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}s:9:\"search_db\";a:3:{s:7:\"h_rooms\";s:4:\"\";s:9:\"h_paytype\";s:8:\"ʽ\";s:4:\"h_zs\";s:8:\"װ\";}s:10:\"imgShow_db\";a:3:{s:4:\"h_qq\";s:6:\"QQ/MSN\";s:5:\"h_tel\";s:8:\"ϵֻ\";s:7:\"h_email\";s:4:\"\";}s:13:\"IfMobPhone_db\";a:1:{s:5:\"h_tel\";s:8:\"ϵֻ\";}s:12:\"IfListSearch\";a:2:{s:7:\"h_rooms\";s:4:\"\";s:4:\"h_zs\";s:8:\"װ\";}}','','0');
INSERT INTO `p8_fenlei_module` VALUES ('9','д¥/','18','','a:6:{s:8:\"field_db\";a:17:{s:11:\"h_guanqiang\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:11:\"h_guanqiang\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:10:\"1|\r\n2|\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:5:\"h_bus\";a:17:{s:5:\"title\";s:8:\"λ\";s:10:\"field_name\";s:5:\"h_bus\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:8:\"form_set\";s:10:\"1|\r\n2|\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:5:\"h_tel\";a:17:{s:5:\"title\";s:8:\"ϵֻ\";s:10:\"field_name\";s:5:\"h_tel\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"1\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:7:\"b_money\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:7:\"b_money\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:10:\"(Ԫ/O/)\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:10:\"h_username\";a:17:{s:5:\"title\";s:6:\"ϵ\";s:10:\"field_name\";s:10:\"h_username\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:7:\"h_email\";a:17:{s:5:\"title\";s:8:\"ϵ\";s:10:\"field_name\";s:7:\"h_email\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:4:\"h_qq\";a:17:{s:5:\"title\";s:10:\"ϵQQ/MSN\";s:10:\"field_name\";s:4:\"h_qq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"1\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:7:\"content\";a:17:{s:5:\"title\";s:4:\"ע\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:7:\"h_owner\";a:17:{s:5:\"title\";s:8:\"ҵ\";s:10:\"field_name\";s:7:\"h_owner\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:9:\"h_address\";a:17:{s:5:\"title\";s:8:\"ϸַ\";s:10:\"field_name\";s:9:\"h_address\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:100;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:4:\"h_zs\";a:17:{s:5:\"title\";s:8:\"װ\";s:10:\"field_name\";s:4:\"h_zs\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:22:\"1|ͨ\r\n2|\r\n3|\";s:10:\"form_value\";s:1:\"2\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:9:\"h_acreage\";a:17:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:9:\"h_acreage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:6:\"ƽ\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:9:\"h_paytype\";a:17:{s:5:\"title\";s:8:\"ʽ\";s:10:\"field_name\";s:9:\"h_paytype\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:32:\"1|¸\r\n2|\r\n3|긶\r\n4|\";s:10:\"form_value\";s:1:\"4\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:8:\"h_height\";a:17:{s:5:\"title\";s:17:\"¥߼/λڼ\";s:10:\"field_name\";s:8:\"h_height\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:9:\"h_manager\";a:17:{s:5:\"title\";s:6:\"ҵ\";s:10:\"field_name\";s:9:\"h_manager\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:10:\"(Ԫ/O/)\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:6:\"h_kong\";a:17:{s:5:\"title\";s:4:\"յ\";s:10:\"field_name\";s:6:\"h_kong\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:28:\"1|յ\r\n2|յ\r\n3|\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"1\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"1\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}s:6:\"h_lift\";a:17:{s:5:\"title\";s:8:\"ݼ\";s:10:\"field_name\";s:6:\"h_lift\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:8;s:9:\"form_type\";s:5:\"radio\";s:8:\"form_set\";s:22:\"1\r\n2\r\n3\r\n4\r\n\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:10:\"IfListShow\";s:1:\"0\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:7:\"imgShow\";s:1:\"0\";s:10:\"IfMobPhone\";s:1:\"0\";s:12:\"IfListSearch\";s:1:\"0\";s:9:\"orderlist\";s:1:\"0\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}s:10:\"imgShow_db\";a:3:{s:7:\"h_email\";s:8:\"ϵ\";s:4:\"h_qq\";s:10:\"ϵQQ/MSN\";s:5:\"h_tel\";s:8:\"ϵֻ\";}s:13:\"IfMobPhone_db\";a:1:{s:5:\"h_tel\";s:8:\"ϵֻ\";}s:12:\"IfListSearch\";a:4:{s:11:\"h_guanqiang\";s:4:\"\";s:5:\"h_bus\";s:8:\"λ\";s:4:\"h_zs\";s:8:\"װ\";s:6:\"h_kong\";s:4:\"յ\";}s:9:\"search_db\";a:2:{s:4:\"h_zs\";s:8:\"װ\";s:6:\"h_kong\";s:4:\"յ\";}}','','0');
INSERT INTO `p8_fenlei_sellad` VALUES ('1','бҳλ','0','0','10','3','10','30');
INSERT INTO `p8_fenlei_sellad` VALUES ('2','ҳ۹','0','0','30','3','8','28');
INSERT INTO `p8_fenlei_sellad` VALUES ('3','ҳ','0','0','20','3','10','30');
INSERT INTO `p8_fenlei_sort` VALUES ('3','0','','0','2','0','1','','0','0','','','ɫʴܲһС⣬֡ڴλ׳һλģԾVIPԱУҾӰɺԣǱҸ׷','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','24','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('4','3','˳','1','3','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','1','0','15','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('8','3','˳','8','3','0','0','','0','0','','','','','','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','4','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('12','3','д¥/̳','9','3','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','1','0','5','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('16','0','','0','2','0','1','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','27','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('17','16','Ȥ','2','3','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','1','0','16','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('18','16','Ů','2','3','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','8','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('19','16','','2','3','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','3','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('25','0','г','0','2','0','1','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','16','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('26','25','/','3','3','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','10','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('28','25','Ʒ','3','3','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','3','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('31','25','õ','3','3','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0','0','3','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('42','0','ְ/Ƹ','0','2','0','1','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','6','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('43','42','ְ','4','3','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','4','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('44','42','ʵϰ/ְ','4','3','0','0','','0','0','','','','','','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','2','0','0','0','0');
INSERT INTO `p8_fenlei_sort` VALUES ('49','42','ҵƸ','5','3','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:2:{s:7:\"is_html\";N;s:11:\"field_value\";N;}','0','0','0','0','0','0','0');
INSERT INTO `p8_fenlei_street` VALUES ('1','11','ɽ߰·','0','0','0','','0','0','','','','','','','0','','','0','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('2','11','¾ŵ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('3','12','ɽж','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('4','12','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('9','3','йش','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('10','3','ѧ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('11','3','廪ѧ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('12','4','˴','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('13','4','Ԫ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('14','6','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('15','6','Ͼ·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('16','5','Ӱ·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('17','5','̲/ʮ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('18','7','Ȱҵ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('19','7','С¥','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('20','9','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('21','9','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('22','10','ɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('23','10','Ծ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('24','14','ϲ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('25','14','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('26','15','Χ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('27','15','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('28','17','·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('29','17','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('30','16','º','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('31','16','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('32','18','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('33','18','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('34','19','ɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('35','19','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('36','20','Ժ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('37','20','п','0','0','0','','88','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('38','21','·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('39','21','ɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('40','23','ɽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('41','23','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('42','22','һ·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('43','22','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('44','24','˴Ͽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('45','24','̨','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('46','25','·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('47','25','·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('48','27','·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('49','27','·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('50','26','½ֿ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('51','26','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('52','30','ٴ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('53','30','ң','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('54','31','վ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('55','31','ͭ·','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('56','33','ͤ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('57','33','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('58','32','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('59','32','Ķ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('60','34','ø','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('61','34','л','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('62','35','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('63','36','԰','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('64','36','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('65','37','ˮ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_street` VALUES ('66','37','Ȩ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('6','2','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('5','2','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('3','1','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('4','1','','0','0','0','','0','0','','','','','','','0','','','0','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('7','3','ƽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('8','3','Ӷ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('9','4','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('10','4','ɿ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('11','27','','0','0','0','','0','0','','','','','','','0','','','0','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('12','27','Խ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('14','28','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('15','28','޺','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('16','24','´','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('17','24','ܽ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('18','19','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('19','19','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('20','36','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('21','36','ţ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('22','9','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('23','9','ɳӿ','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('24','16','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('25','16','б','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('26','17','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('27','17','¥','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('28','18','԰','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('29','18','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('30','20','®','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('31','20','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('32','21','¥','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('33','21','̨','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('34','22','˼','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('35','22','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('36','23','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_fenlei_zone` VALUES ('37','23','','0','0','0','','0','0','','','','','','','0','','','1','','','','','0','','','0');
INSERT INTO `p8_flash_comments` VALUES ('1','0','2','5224','5','0','','1218687851','fdsafds','127.0.0.1','0','1');
INSERT INTO `p8_flash_config` VALUES ('Flash_MakeIndexHtmlTime','','');
INSERT INTO `p8_flash_config` VALUES ('Flash_style','35cn','');
INSERT INTO `p8_flash_config` VALUES ('Flash_list_filename2','list.php?fid-{$fid}-page-{$page}.htm','');
INSERT INTO `p8_flash_config` VALUES ('Flash_NewsMakeHtml','0','');
INSERT INTO `p8_flash_config` VALUES ('Flash_bencandy_filename2','bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm','');
INSERT INTO `p8_flash_config` VALUES ('Flash_closeWhy','ر','');
INSERT INTO `p8_flash_config` VALUES ('Flash_guide_word1','FLASHҳ|index.php\r\nÿ|../guestbook.php\r\n|../alonepage.php?id=6\r\n̳|http://bbs.php168.com|1','');
INSERT INTO `p8_flash_config` VALUES ('module_id','6','');
INSERT INTO `p8_flash_config` VALUES ('module_pre','flash_','');
INSERT INTO `p8_flash_config` VALUES ('Flash_webOpen','1','');
INSERT INTO `p8_flash_config` VALUES ('Flash_metakeywords','flash  ','');
INSERT INTO `p8_flash_config` VALUES ('Flash_webname','FlashƵ','');
INSERT INTO `p8_flash_config` VALUES ('postPassYz','3,4','');
INSERT INTO `p8_flash_config` VALUES ('memberPost','0','');
INSERT INTO `p8_flash_config` VALUES ('group_UpFlash','3,4','');
INSERT INTO `p8_flash_gather_rule` VALUES ('1','article','article','','7K7KСϷ->Flash->и','http://www.7k7k.com/flash_fl/217_[page].htm','','1','5','1','0','','','<','','','','','','','0','','','$flashurl=\"http://flash.7k7k.com/$flashurl\";','','','','','','0','1181708743','1181709019','0','0','','0','0','','','','0','','<a href=\"{url=NO\"}\" target=\"_blank\"><img src=\"{picurl=NO\"}\"/></a><div class=\"text\"><span class=\"bt\">{title=NO<}</span>','</a><a href=javascript:download(\'{flashurl=NO\'}\');>{*}С{flashsize=NO<}ʱ䣺{NO<}</div><div class=\"con\">{content=*}</div>','','','0');
INSERT INTO `p8_flash_gather_rule` VALUES ('2','article','article','','7K7KСϷ->FlashƬ>ЦĬ','http://www.7k7k.com/flash_fl/479_[page].htm','','1','5','1','0','','','<','','','','','','','0','','','$flashurl=\"http://flash.7k7k.com/$flashurl\";','','','','','','0','1181708743','1181709019','0','0','','0','0','','','','0','','<a href=\"{url=NO\"}\" target=\"_blank\"><img src=\"{picurl=NO\"}\"/></a><div class=\"text\"><span class=\"bt\">{title=NO<}</span>','</a><a href=javascript:download(\'{flashurl=NO\'}\');>{*}С{flashsize=NO<}ʱ䣺{NO<}</div><div class=\"con\">{content=*}</div>','','','0');
INSERT INTO `p8_flash_gather_rule` VALUES ('3','article','article','','7K7KСϷ->Flashר>ϵ','http://www.7k7k.com/flash_fl/439_[page].htm','','1','5','1','0','','','<','','','','','','','0','','','$flashurl=\"http://flash.7k7k.com/$flashurl\";','','','','','','0','1181708743','1181709019','0','0','','0','0','','','','0','','<a href=\"{url=NO\"}\" target=\"_blank\"><img src=\"{picurl=NO\"}\"/></a><div class=\"text\"><span class=\"bt\">{title=NO<}</span>','</a><a href=javascript:download(\'{flashurl=NO\'}\');>{*}С{flashsize=NO<}ʱ䣺{NO<}</div><div class=\"con\">{content=*}</div>','','','0');
INSERT INTO `p8_flash_gather_rule` VALUES ('4','article','article','','7K7KСϷ->FlashСϷ>','http://www.7k7k.com/flash_fl/456_[page].htm','','1','5','1','0','','','<','','','','','','','0','','','$flashurl=\"http://flash.7k7k.com/$flashurl\";','','','','','','0','1181708743','1181709019','0','0','','0','0','','','','0','','<a href=\"{url=NO\"}\" target=\"_blank\"><img src=\"{picurl=NO\"}\"/></a><div class=\"text\"><span class=\"bt\">{title=NO<}</span>','</a><a href=javascript:download(\'{flashurl=NO\'}\');>{*}С{flashsize=NO<}ʱ䣺{NO<}</div><div class=\"con\">{content=*}</div>','','','0');
INSERT INTO `p8_flash_sort` VALUES ('1','0','Flash','1','2','1','','0','0','10','','','','','a:4:{s:4:\"head\";s:23:\"template/flash/head.htm\";s:4:\"foot\";s:23:\"template/flash/foot.htm\";s:4:\"list\";s:28:\"template/flash/list_more.htm\";s:8:\"bencandy\";s:0:\"\";}','','0','','','','','0','a:1:{s:11:\"sonTitleRow\";s:2:\"10\";}','0','','');
INSERT INTO `p8_flash_sort` VALUES ('3','0','FlashƬ','1','2','1','','0','0','10','','','','','N;','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";s:2:\"10\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_flash_sort` VALUES ('4','3','ЦĬ','2','0','0','','0','0','10','','','','','N;','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";s:2:\"10\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','1','','');
INSERT INTO `p8_flash_sort` VALUES ('5','3','ͯ','2','0','0','','0','0','10','','','','','a:4:{s:4:\"head\";s:23:\"template/flash/head.htm\";s:4:\"foot\";s:23:\"template/flash/foot.htm\";s:4:\"list\";s:23:\"template/flash/list.htm\";s:8:\"bencandy\";s:27:\"template/flash/bencandy.htm\";}','','0','','','','','0','a:1:{s:11:\"sonTitleRow\";s:2:\"10\";}','0','','');
INSERT INTO `p8_flash_sort` VALUES ('10','1','и','2','0','0','','0','0','10','','','','','N;','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";s:2:\"10\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','1','','');
INSERT INTO `p8_flash_sort` VALUES ('11','1','Ů','2','0','0','','0','0','10','','','','','a:4:{s:4:\"head\";s:23:\"template/flash/head.htm\";s:4:\"foot\";s:23:\"template/flash/foot.htm\";s:4:\"list\";s:23:\"template/flash/list.htm\";s:8:\"bencandy\";s:27:\"template/flash/bencandy.htm\";}','','0','','','','','0','a:1:{s:11:\"sonTitleRow\";s:2:\"10\";}','0','','');
INSERT INTO `p8_flash_sort` VALUES ('12','0','Flashר','1','2','1','','0','0','10','','','','','N;','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";s:2:\"10\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_flash_sort` VALUES ('19','12','ϵ','2','0','0','','0','0','10','','','','','a:4:{s:4:\"head\";s:23:\"template/flash/head.htm\";s:4:\"foot\";s:23:\"template/flash/foot.htm\";s:4:\"list\";s:23:\"template/flash/list.htm\";s:8:\"bencandy\";s:27:\"template/flash/bencandy.htm\";}','','0','','','','','0','a:1:{s:11:\"sonTitleRow\";s:2:\"10\";}','0','','');
INSERT INTO `p8_flash_sort` VALUES ('20','12','ϵ','2','0','0','','0','0','10','','','','','N;','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";s:2:\"10\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','1','','');
INSERT INTO `p8_flash_swf` VALUES ('1081','4','Foolish man֮üǶ','ЦĬ','0','','0','9256','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic202.gif','1','1','','0','0','0','','','','','','','','0','0','','82','0','','','','0','0','0','1306','http://flash.7k7k.com/fl_3/47868210076.swf','()','yukai','','1174351887');
INSERT INTO `p8_flash_swf` VALUES ('1082','4','н II','ЦĬ','0','','0','5691','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic203.gif','1','1','','0','0','0','','','','','','','','0','0','','83','0','','','','0','0','0','1987','http://flash.7k7k.com/fl_3/73989915847.swf','()','redy','','1173975777');
INSERT INTO `p8_flash_swf` VALUES ('1089','5','񶯻','ͯ','0','','0','8804','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic210.gif','1','1','','0','0','0','','','','','','','','0','0','','90','0','','','','0','0','0','1831','http://flash.7k7k.com/fl_3/19666010141.swf','()','ĳ','','1174286787');
INSERT INTO `p8_flash_swf` VALUES ('1090','5','Ը','ͯ','0','','0','1655','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic211.gif','1','1','','0','0','0','','','','','','','','0','0','','91','0','','','','0','0','0','452','http://flash.7k7k.com/fl_3/79967975615.swf','()','cartoonfree.com.cn','','1174349443');
INSERT INTO `p8_flash_swf` VALUES ('1093','5','Ѫսᶯ','ͯ','0','','0','7498','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic214.gif','1','1','','0','0','0','','','','','','','','0','0','','94','0','','','','0','0','0','1631','http://flash.7k7k.com/fl_3/69418936967.swf','()','','','1173824373');
INSERT INTO `p8_flash_swf` VALUES ('1094','4','̾Ӣ','ЦĬ','0','','0','6471','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic215.gif','1','1','','0','0','0','','','','','','','','0','0','','95','0','','','','0','0','0','951','http://flash.7k7k.com/fl_3/83532071112.swf','()','ţСӢ','','1173975817');
INSERT INTO `p8_flash_swf` VALUES ('1099','5','Ժ궯','ͯ','0','','0','2619','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic220.gif','1','1','','0','0','0','','','','','','','','0','0','','100','0','','','','0','0','0','1034','http://flash.7k7k.com/fl_3/73558014630.swf','()','ɻ','','1174346970');
INSERT INTO `p8_flash_swf` VALUES ('1104','5','Ƭ','ͯ','0','','0','2959','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic225.gif','1','1','','0','0','0','','','','','','','','0','0','','105','0','','','','0','0','0','1747','http://flash.7k7k.com/fl_3/7376420497.swf','()','','','1173851013');
INSERT INTO `p8_flash_swf` VALUES ('1105','4','Ʒɺ趯','ЦĬ','0','','0','5454','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic226.gif','1','1','','0','0','0','','','','','','','','0','0','','106','0','','','','0','0','0','792','http://flash.7k7k.com/fl_3/6131178140.swf','()','ͯ','','1174350557');
INSERT INTO `p8_flash_swf` VALUES ('1106','4','·ƽ','ЦĬ','0','','0','9571','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic227.gif','1','1','','0','0','0','','','','','','','','0','0','','107','0','','','','0','0','0','1114','http://flash.7k7k.com/fl_3/81677818297.swf','()','Ϻ','','1173962219');
INSERT INTO `p8_flash_swf` VALUES ('1108','5','ʮ˶','ͯ','0','','0','4166','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic229.gif','1','1','','0','0','0','','','','','','','','0','0','','109','0','','','','0','0','0','702','http://flash.7k7k.com/fl_3/55283892154.swf','()','zoron','','1174197807');
INSERT INTO `p8_flash_swf` VALUES ('1110','4','','ЦĬ','0','','0','2437','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic231.gif','1','1','','0','0','0','','','','','','','','0','0','','111','0','','','','0','0','0','774','http://flash.7k7k.com/fl_3/32126069068.swf','()','coastv','','1173940824');
INSERT INTO `p8_flash_swf` VALUES ('1112','4','BIRDMAN','ЦĬ','0','','0','7369','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic233.gif','1','1','','0','0','0','','','','','','','','0','0','','113','0','','','','0','0','0','441','http://flash.7k7k.com/fl_3/9444797038.swf','()','ư','','1174393431');
INSERT INTO `p8_flash_swf` VALUES ('1114','4','ʮһ޺','ЦĬ','0','','0','6543','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic235.gif','1','1','','0','0','0','','','','','','','','0','0','','115','0','','','','0','0','0','614','http://flash.7k7k.com/fl_3/68501520156.swf','()','','','1173990138');
INSERT INTO `p8_flash_swf` VALUES ('1117','5','и ׶','ͯ','0','','0','991','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic238.gif','1','1','','0','0','0','','','','','','','','0','0','','118','0','','','','0','0','0','980','http://flash.7k7k.com/fl_3/38723927735.swf','()','','','1174174867');
INSERT INTO `p8_flash_swf` VALUES ('1118','4','QQʼǶ','ЦĬ','0','','0','6560','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic239.gif','1','1','','0','0','0','','','','','','','','0','0','','119','0','','','','0','0','0','980','http://flash.7k7k.com/fl_3/8493685722.swf','()','һ','','1174017844');
INSERT INTO `p8_flash_swf` VALUES ('1119','5','ν 1984','ͯ','0','','0','4513','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic240.gif','1','1','','0','0','0','','','','','','','','0','0','','120','0','','','','0','0','0','431','http://flash.7k7k.com/fl_3/30342859029.swf','()','Զ','','1173844115');
INSERT INTO `p8_flash_swf` VALUES ('1121','4','һһ','ЦĬ','0','','0','5545','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic242.gif','1','1','','0','0','0','','','','','','','','0','0','','122','0','','','','0','0','0','590','http://flash.7k7k.com/fl_3/89626985787.swf','()','깤','','1173792452');
INSERT INTO `p8_flash_swf` VALUES ('1122','4','Զ','ЦĬ','0','','0','2186','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic243.gif','1','1','','0','0','0','','','','','','','','0','0','','123','0','','','','0','0','0','488','http://flash.7k7k.com/fl_3/60092067717.swf','()','Ұ(̨)','','1174385249');
INSERT INTO `p8_flash_swf` VALUES ('1124','4','QQ˽ڶ','ЦĬ','0','','0','5945','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic245.gif','1','1','','0','0','0','','','','','','','','0','0','','125','0','','','','0','0','0','504','http://flash.7k7k.com/fl_3/70419180392.swf','()','ľ','','1174051721');
INSERT INTO `p8_flash_swf` VALUES ('1125','4','ؤ','ЦĬ','0','','0','4702','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic246.gif','1','1','','0','0','0','','','','','','','','0','0','','126','0','','','','0','0','0','303','http://flash.7k7k.com/fl_3/86264067887.swf','()','','','1173750548');
INSERT INTO `p8_flash_swf` VALUES ('1126','4','¶','ЦĬ','0','','0','8105','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic247.gif','1','1','','0','0','0','','','','','','','','0','0','','127','0','','','','0','0','0','496','http://flash.7k7k.com/fl_3/37098240851.swf','()','Ұ(̨)','','1174334020');
INSERT INTO `p8_flash_swf` VALUES ('1127','4','򶯻','ЦĬ','0','','0','3677','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic248.gif','1','1','','0','0','0','','','','','','','','0','0','','128','0','','','','0','0','0','542','http://flash.7k7k.com/fl_3/57578510045.swf','()','Ů洤','','1174220143');
INSERT INTO `p8_flash_swf` VALUES ('1129','5','һ컢Ļ䶯','ͯ','0','','0','6888','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic250.gif','1','1','','0','0','0','','','','','','','','0','0','','130','0','','','','0','0','0','1588','http://flash.7k7k.com/fl_3/89154583214.swf','()','֩','','1174052205');
INSERT INTO `p8_flash_swf` VALUES ('1130','4','ȹǶ','ЦĬ','0','','0','3998','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic251.gif','1','1','','0','0','0','','','','','','','','0','0','','131','0','','','','0','0','0','301','http://flash.7k7k.com/fl_3/73473691939.swf','()','','','1174280176');
INSERT INTO `p8_flash_swf` VALUES ('1132','4','˶','ЦĬ','0','','0','166','1','1058198400','1058198400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic253.gif','1','1','','0','0','0','','','','','','','','0','0','','133','0','','','','0','0','0','423','http://flash.7k7k.com/fl_3/62324440478.swf','()','zhangqing_haoren','','1173959707');
INSERT INTO `p8_flash_swf` VALUES ('1134','5','żȻɺ϶','ͯ','0','','0','4571','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic255.gif','1','1','','0','0','0','','','','','','','','0','0','','135','0','','','','0','0','0','280','http://flash.7k7k.com/fl_3/21328711509.swf','()','Alan','','1174238224');
INSERT INTO `p8_flash_swf` VALUES ('1135','5','Сӵζ','ͯ','0','','0','9339','1','1054310400','1054310400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic256.gif','1','1','','0','0','0','','','','','','','','0','0','','136','0','','','','0','0','0','1218','http://flash.7k7k.com/fl_3/11538404226.swf','()','','','1174278792');
INSERT INTO `p8_flash_swf` VALUES ('1159','11','ϲMTV','Ů','0','','0','186','1','1038931200','1038931200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic977.gif','1','1','','0','0','0','','','','','','','','0','0','','160','0','','','ܻ','0','0','0','675','http://flash.7k7k.com/fl_1/14197200536.swf','()','Ʈѩ','','1173811746');
INSERT INTO `p8_flash_swf` VALUES ('1160','11','MTV','Ů','0','','0','4076','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic978.gif','1','1','','0','0','0','','','','','','','','0','0','','161','0','','','ܻ','0','0','0','1385','http://flash.7k7k.com/fl_1/2194106578.swf','()','','','1174386687');
INSERT INTO `p8_flash_swf` VALUES ('1161','11','MTV','Ů','0','','0','5818','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic979.gif','1','1','','0','0','0','','','','','','','','0','0','','162','0','','','ܻ','0','0','0','1892','http://flash.7k7k.com/fl_1/83163410424.swf','()','ָ׸','','1173812435');
INSERT INTO `p8_flash_swf` VALUES ('1162','11','˼MTV','Ů','0','','0','2979','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic980.gif','1','1','','0','0','0','','','','','','','','0','0','','163','0','','','ܻ','0','0','0','655','http://flash.7k7k.com/fl_1/97512578963.swf','()','','','1173742198');
INSERT INTO `p8_flash_swf` VALUES ('1163','11','˲MTV','Ů','0','','0','5321','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic981.gif','1','1','','0','0','0','','','','','','','','0','0','','164','0','','','ܻ','0','0','0','1284','http://flash.7k7k.com/fl_1/45224350690.swf','()','ɻ','','1174090013');
INSERT INTO `p8_flash_swf` VALUES ('1164','11','ûMTV','Ů','0','','0','7495','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic982.gif','1','1','','0','0','0','','','','','','','','0','0','','165','0','','','ܻ','0','0','0','903','http://flash.7k7k.com/fl_1/19152939319.swf','()','Ӱ','','1174391385');
INSERT INTO `p8_flash_swf` VALUES ('1165','11','úðMTV','Ů','0','','0','9929','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic983.gif','1','1','','0','0','0','','','','','','','','0','0','','166','0','','','ܻ','0','0','0','795','http://flash.7k7k.com/fl_1/75409775971.swf','()','С','','1173747040');
INSERT INTO `p8_flash_swf` VALUES ('1166','11','̫MTV','Ů','0','','0','9636','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic984.gif','1','1','','0','0','0','','','','','','','','0','0','','167','0','','','ܻ','0','0','0','806','http://flash.7k7k.com/fl_1/50261092185.swf','()','','','1174052802');
INSERT INTO `p8_flash_swf` VALUES ('1167','11','̫ãMTV','Ů','0','','0','6779','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic985.gif','1','1','','0','0','0','','','','','','','','0','0','','168','0','','','ܻ','0','0','0','1285','http://flash.7k7k.com/fl_1/77191823720.swf','()','','','1173666984');
INSERT INTO `p8_flash_swf` VALUES ('1168','11','MTV','Ů','0','','0','8559','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic986.gif','1','1','','0','0','0','','','','','','','','0','0','','169','0','','','ܻ','0','0','0','1036','http://flash.7k7k.com/fl_1/1000154018.swf','()','С','','1173785884');
INSERT INTO `p8_flash_swf` VALUES ('1169','11','֪MTV','Ů','0','','0','6454','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic987.gif','1','1','','0','0','0','','','','','','','','0','0','','170','0','','','ܻ','0','0','0','1149','http://flash.7k7k.com/fl_1/18449980020.swf','()','','','1173825599');
INSERT INTO `p8_flash_swf` VALUES ('1170','11','ԼMTV','Ů','0','','0','8145','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic988.gif','1','1','','0','0','0','','','','','','','','0','0','','171','0','','','ܻ','0','0','0','815','http://flash.7k7k.com/fl_1/228309631.swf','()','Anal','','1173590437');
INSERT INTO `p8_flash_swf` VALUES ('1171','11','ɽMTV','Ů','0','','0','468','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic955.gif','1','1','','0','0','0','','','','','','','','0','0','','172','0','','','Ż','0','0','0','1642','http://flash.7k7k.com/fl_1/39167612790.swf','()','','','1173965624');
INSERT INTO `p8_flash_swf` VALUES ('1172','11','ÿ˶MTV','Ů','0','','0','4442','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic956.gif','1','1','','0','0','0','','','','','','','','0','0','','173','0','','','Ż','0','0','0','892','http://flash.7k7k.com/fl_1/45645296573.swf','()','weiping','','1173933536');
INSERT INTO `p8_flash_swf` VALUES ('1173','11','ԶĻMTV','Ů','0','','0','8810','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic957.gif','1','1','','0','0','0','','','','','','','','0','0','','174','0','','','Ż','0','0','0','1415','http://flash.7k7k.com/fl_1/66571742295.swf','()','Redmoon','','1173756023');
INSERT INTO `p8_flash_swf` VALUES ('1174','11','ҿԱMTV','Ů','0','','0','3211','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic958.gif','1','1','','0','0','0','','','','','','','','0','0','','175','0','','','Ż','0','0','0','2920','http://flash.7k7k.com/fl_1/81835007666.swf','()','ڷ','','1174039628');
INSERT INTO `p8_flash_swf` VALUES ('1175','11','MTV','Ů','0','','0','7350','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic959.gif','1','1','','0','0','0','','','','','','','','0','0','','176','0','','','Ż','0','0','0','874','http://flash.7k7k.com/fl_1/6224960088.swf','()','Juan27','','1173862848');
INSERT INTO `p8_flash_swf` VALUES ('1176','11','MTV','Ů','0','','0','7349','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic960.gif','1','1','','0','0','0','','','','','','','','0','0','','177','0','','','Ż','0','0','0','648','http://flash.7k7k.com/fl_1/11097705364.swf','()','jj-sonic','','1173891492');
INSERT INTO `p8_flash_swf` VALUES ('1177','11','ŮԵMTV','Ů','0','','0','5445','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic961.gif','1','1','','0','0','0','','','','','','','','0','0','','178','0','','','巼','0','0','0','930','http://flash.7k7k.com/fl_1/7311683893.swf','()','С','','1173676605');
INSERT INTO `p8_flash_swf` VALUES ('1178','11','MTV','Ů','0','','0','4488','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic962.gif','1','1','','0','0','0','','','','','','','','0','0','','179','0','','','巼','0','0','0','823','http://flash.7k7k.com/fl_1/46106576919.swf','()','','','1173398953');
INSERT INTO `p8_flash_swf` VALUES ('1179','11','ԼMTV','Ů','0','','0','3352','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic963.gif','1','1','','0','0','0','','','','','','','','0','0','','180','0','','','巼','0','0','0','875','http://flash.7k7k.com/fl_1/62178868054.swf','()','','','1174353356');
INSERT INTO `p8_flash_swf` VALUES ('1180','11','MTV','Ů','0','','0','4444','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic964.gif','1','1','','0','0','0','','','','','','','','0','0','','181','0','','','ӽ','0','0','0','1028','http://flash.7k7k.com/fl_1/84141743182.swf','()','','','1174069908');
INSERT INTO `p8_flash_swf` VALUES ('1181','11','MTV','Ů','0','','0','9795','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic965.gif','1','1','','0','0','0','','','','','','','','0','0','','182','0','','','֣','0','0','0','1616','http://flash.7k7k.com/fl_1/74338322877.swf','()','','','1173733548');
INSERT INTO `p8_flash_swf` VALUES ('1182','11','MTV','Ů','0','','0','6699','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic966.gif','1','1','','0','0','0','','','','','','','','0','0','','183','0','','','֣','0','0','0','641','http://flash.7k7k.com/fl_1/64434313773.swf','()','','','1173714953');
INSERT INTO `p8_flash_swf` VALUES ('1183','11','ARIGATOUMTV','Ů','0','','0','9400','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic967.gif','1','1','','0','0','0','','','','','','','','0','0','','184','0','','','֣','0','0','0','2112','http://flash.7k7k.com/fl_1/39399331807.swf','()','Ů֮','','1173399981');
INSERT INTO `p8_flash_swf` VALUES ('1184','11','ҶMTV','Ů','0','','0','7934','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic968.gif','1','1','','0','0','0','','','','','','','','0','0','','185','0','','','֣','0','0','0','2245','http://flash.7k7k.com/fl_1/25336492061.swf','()','','','1173990863');
INSERT INTO `p8_flash_swf` VALUES ('1185','11','MTV','Ů','0','','0','289','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic969.gif','1','1','','0','0','0','','','','','','','','0','0','','186','0','','','֣','0','0','0','1279','http://flash.7k7k.com/fl_1/45567613839.swf','()','ȹ','','1173815121');
INSERT INTO `p8_flash_swf` VALUES ('1186','11','MTV','Ů','0','','0','9508','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic970.gif','1','1','','0','0','0','','','','','','','','0','0','','187','0','','','֣','0','0','0','659','http://flash.7k7k.com/fl_1/42590618133.swf','()','ƻ','','1173929293');
INSERT INTO `p8_flash_swf` VALUES ('1187','11','ֲMTV','Ů','0','','0','1463','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic971.gif','1','1','','0','0','0','','','','','','','','0','0','','188','0','','','֣','0','0','0','621','http://flash.7k7k.com/fl_1/9237974882.swf','()','ŵ','','1173650267');
INSERT INTO `p8_flash_swf` VALUES ('1188','11','MTV','Ů','0','','0','4987','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic972.gif','1','1','','0','0','0','','','','','','','','0','0','','189','0','','','֣','0','0','0','780','http://flash.7k7k.com/fl_1/12265264987.swf','()','','','1173818237');
INSERT INTO `p8_flash_swf` VALUES ('1189','11','ԳMTV','Ů','0','','0','385','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic973.gif','1','1','','0','0','0','','','','','','','','0','0','','190','0','','','֣','0','0','0','504','http://flash.7k7k.com/fl_1/28110152482.swf','()','jocky2001','','1173735145');
INSERT INTO `p8_flash_swf` VALUES ('1190','11','üɫMTV','Ů','0','','0','7612','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic974.gif','1','1','','0','0','0','','','','','','','','0','0','','191','0','','','֣','0','0','0','1730','http://flash.7k7k.com/fl_1/5502247810.swf','()','ڷ','','1173648143');
INSERT INTO `p8_flash_swf` VALUES ('1191','11','MTV','Ů','0','','0','447','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic975.gif','1','1','','0','0','0','','','','','','','','0','0','','192','0','','','֣ѩ','0','0','0','589','http://flash.7k7k.com/fl_1/77926486729.swf','()','ѩ','','1174228362');
INSERT INTO `p8_flash_swf` VALUES ('1192','11','װɵMTV','Ů','0','','0','7816','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic976.gif','1','1','','0','0','0','','','','','','','','0','0','','193','0','','','֣ѩ','0','0','0','710','http://flash.7k7k.com/fl_1/98043906687.swf','()','','','1174392237');
INSERT INTO `p8_flash_swf` VALUES ('1193','11','MTV','Ů','0','','0','8502','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic933.gif','1','1','','0','0','0','','','','','','','','0','0','','194','0','','','','0','0','0','990','http://flash.7k7k.com/fl_1/90348201989.swf','()','','','1174385273');
INSERT INTO `p8_flash_swf` VALUES ('1194','11','һMTV','Ů','0','','0','692','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic934.gif','1','1','','0','0','0','','','','','','','','0','0','','195','0','','','','0','0','0','721','http://flash.7k7k.com/fl_1/1225233077.swf','()','','','1173457277');
INSERT INTO `p8_flash_swf` VALUES ('1195','11','ڷMTV','Ů','0','','0','2313','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic935.gif','1','1','','0','0','0','','','','','','','','0','0','','196','0','','','','0','0','0','1387','http://flash.7k7k.com/fl_1/59100121259.swf','()','','','1174228479');
INSERT INTO `p8_flash_swf` VALUES ('1196','11','MTV','Ů','0','','0','3583','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic936.gif','1','1','','0','0','0','','','','','','','','0','0','','197','0','','','','0','0','0','979','http://flash.7k7k.com/fl_1/71087944506.swf','()','ˮ','','1173766043');
INSERT INTO `p8_flash_swf` VALUES ('1197','11','ֻMTV','Ů','0','','0','8087','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic937.gif','1','1','','0','0','0','','','','','','','','0','0','','198','0','','','','0','0','0','1605','http://flash.7k7k.com/fl_1/17181664705.swf','()','','','1174209484');
INSERT INTO `p8_flash_swf` VALUES ('1198','11','¹MTV','Ů','0','','0','3449','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic938.gif','1','1','','0','0','0','','','','','','','','0','0','','199','0','','','','0','0','0','1496','http://flash.7k7k.com/fl_1/81869864462.swf','()','','','1174219378');
INSERT INTO `p8_flash_swf` VALUES ('1199','11','MTV','Ů','0','','0','7978','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic939.gif','1','1','','0','0','0','','','','','','','','0','0','','200','0','','','','0','0','0','1053','http://flash.7k7k.com/fl_1/72079557179.swf','()','ڷFLASHλ','','1174149305');
INSERT INTO `p8_flash_swf` VALUES ('1200','11','ảMTV','Ů','0','','0','4485','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic940.gif','1','1','','0','0','0','','','','','','','','0','0','','201','0','','','ܿ','0','0','0','1568','http://flash.7k7k.com/fl_1/79493081568.swf','()','','','1173902102');
INSERT INTO `p8_flash_swf` VALUES ('1201','11','ӰMTV','Ů','0','','0','7572','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic941.gif','1','1','','0','0','0','','','','','','','','0','0','','202','0','','','ܿ','0','0','0','1132','http://flash.7k7k.com/fl_1/53990179299.swf','()','Ԫ','','1174018011');
INSERT INTO `p8_flash_swf` VALUES ('1202','11','γMTV','Ů','0','','0','5590','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic942.gif','1','1','','0','0','0','','','','','','','','0','0','','203','0','','','ܿ','0','0','0','534','http://flash.7k7k.com/fl_1/72489547728.swf','()','','','1174399242');
INSERT INTO `p8_flash_swf` VALUES ('1203','11','ֻ˵MTV','Ů','0','','0','3387','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic943.gif','1','1','','0','0','0','','','','','','','','0','0','','204','0','','','ܿ','0','0','0','1156','http://flash.7k7k.com/fl_1/27823656797.swf','()','Ƿ','','1174149335');
INSERT INTO `p8_flash_swf` VALUES ('1204','11','ϷMTV','Ů','0','','0','7719','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic944.gif','1','1','','0','0','0','','','','','','','','0','0','','205','0','','','ܿ','0','0','0','1095','http://flash.7k7k.com/fl_1/99211466311.swf','()','ΩΩ','','1173552003');
INSERT INTO `p8_flash_swf` VALUES ('1205','11','MTV','Ů','0','','0','401','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic945.gif','1','1','','0','0','0','','','','','','','','0','0','','206','0','','','','0','0','0','1999','http://flash.7k7k.com/fl_1/50167971848.swf','()','','','1173817608');
INSERT INTO `p8_flash_swf` VALUES ('1206','11','ҸMTV','Ů','0','','0','1709','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic946.gif','1','1','','0','0','0','','','','','','','','0','0','','207','0','','','','0','0','0','518','http://flash.7k7k.com/fl_1/95920586585.swf','()','꺽','','1173959180');
INSERT INTO `p8_flash_swf` VALUES ('1207','11','ҵҸMTV','Ů','0','','0','9487','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic947.gif','1','1','','0','0','0','','','','','','','','0','0','','208','0','','','ܾ','0','0','0','908','http://flash.7k7k.com/fl_1/36705344915.swf','()','feltcooler','','1174096758');
INSERT INTO `p8_flash_swf` VALUES ('1208','11','MTV','Ů','0','','0','5461','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic948.gif','1','1','','0','0','0','','','','','','','','0','0','','209','0','','','ܾ','0','0','0','1894','http://flash.7k7k.com/fl_1/78299129008.swf','()','','','1174004210');
INSERT INTO `p8_flash_swf` VALUES ('1209','11','ĴMTV','Ů','0','','0','4999','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic949.gif','1','1','','0','0','0','','','','','','','','0','0','','210','0','','','Ű','0','0','0','1363','http://flash.7k7k.com/fl_1/11234146356.swf','()','','','1173560175');
INSERT INTO `p8_flash_swf` VALUES ('1210','11','һ˱˵ծMTV','Ů','0','','0','1586','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic950.gif','1','1','','0','0','0','','','','','','','','0','0','','211','0','','','Ű֥','0','0','0','1918','http://flash.7k7k.com/fl_1/37355852126.swf','()','ɫ','','1173927300');
INSERT INTO `p8_flash_swf` VALUES ('1211','11','MTV','Ů','0','','0','2196','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic951.gif','1','1','','0','0','0','','','','','','','','0','0','','212','0','','','Ż','0','0','0','1514','http://flash.7k7k.com/fl_1/63591259717.swf','()','СԸ','','1173432123');
INSERT INTO `p8_flash_swf` VALUES ('1212','11','ɳMTV','Ů','0','','0','4904','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic952.gif','1','1','','0','0','0','','','','','','','','0','0','','213','0','','','Ż','0','0','0','1296','http://flash.7k7k.com/fl_1/22275173663.swf','()','','','1174021377');
INSERT INTO `p8_flash_swf` VALUES ('1213','11','ҹMTV','Ů','0','','0','4818','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic953.gif','1','1','','0','0','0','','','','','','','','0','0','','214','0','','','Ż','0','0','0','731','http://flash.7k7k.com/fl_1/72488385438.swf','()','СԺ','','1174388160');
INSERT INTO `p8_flash_swf` VALUES ('1214','11','ˮɫMTV','Ů','0','','0','9886','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic954.gif','1','1','','0','0','0','','','','','','','','0','0','','215','0','','','Ż','0','0','0','508','http://flash.7k7k.com/fl_1/78979182242.swf','()','yy001','','1174219192');
INSERT INTO `p8_flash_swf` VALUES ('1215','11','MTV','Ů','0','','0','2485','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic876.gif','1','1','','0','0','0','','','','','','','','0','0','','216','0','','','','0','0','0','659','http://flash.7k7k.com/fl_1/37549394368.swf','()','','','1174113215');
INSERT INTO `p8_flash_swf` VALUES ('1216','11','someoneMTV','Ů','0','','0','8234','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic877.gif','1','1','','0','0','0','','','','','','','','0','0','','217','0','','','','0','0','0','1440','http://flash.7k7k.com/fl_1/44481885432.swf','()','','','1173887379');
INSERT INTO `p8_flash_swf` VALUES ('1217','11','ҪҸMTV','Ů','0','','0','8284','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic878.gif','1','1','','0','0','0','','','','','','','','0','0','','218','0','','','','0','0','0','1216','http://flash.7k7k.com/fl_1/41627222299.swf','()','','','1173478590');
INSERT INTO `p8_flash_swf` VALUES ('1218','11','㿪ʼMTV','Ů','0','','0','6291','1','1055260800','1055260800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic879.gif','1','1','','0','0','0','','','','','','','','0','0','','219','0','','','','0','0','0','764','http://flash.7k7k.com/fl_1/1929187774.swf','()','','','1173830368');
INSERT INTO `p8_flash_swf` VALUES ('1288','10','ʮָMTV','и','0','','0','1544','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1094.gif','1','1','','0','0','0','','','','','','','','0','0','','290','0','','','','0','0','0','','http://flash.7k7k.com/fl_1/83929580449.swf','','','','1174352196');
INSERT INTO `p8_flash_swf` VALUES ('1289','10','ұMTV','и','0','','0','9061','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1095.gif','1','1','','0','0','0','','','','','','','','0','0','','291','0','','','','0','0','0','','http://flash.7k7k.com/fl_1/56012713908.swf','','','','1173729647');
INSERT INTO `p8_flash_swf` VALUES ('1290','10','0204MTV','и','0','','0','6387','1','1038758400','1038758400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1096.gif','1','1','','0','0','0','','','','','','','','0','0','','292','0','','','','0','0','0','581','http://flash.7k7k.com/fl_1/52226692437.swf','˵ӭӣ','','','1173832168');
INSERT INTO `p8_flash_swf` VALUES ('1291','10','ƨMTV','и','0','','0','5758','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1097.gif','1','1','','0','0','0','','','','','','','','0','0','','293','0','','','','0','0','0','','http://flash.7k7k.com/fl_1/68185281752.swf','','','','1173735056');
INSERT INTO `p8_flash_swf` VALUES ('1292','10','Я˼MTV','и','0','','0','4331','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1098.gif','1','1','','0','0','0','','','','','','','','0','0','','294','0','','','','0','0','0','','http://flash.7k7k.com/fl_1/5755680799.swf','','','','1174038107');
INSERT INTO `p8_flash_swf` VALUES ('1293','10','MTV','и','0','','0','5052','1','1038758400','1038758400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1099.gif','1','1','','0','0','0','','','','','','','','0','0','','295','0','','','','0','0','0','787','http://flash.7k7k.com/fl_1/48044788836.swf','˵ӭӣ','κ','','1174381285');
INSERT INTO `p8_flash_swf` VALUES ('1294','10','MTV','и','0','','0','7405','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1100.gif','1','1','','0','0','0','','','','','','','','0','0','','296','0','','','','0','0','0','','http://flash.7k7k.com/fl_1/39872533082.swf','','','','1174167202');
INSERT INTO `p8_flash_swf` VALUES ('1295','10','ټŮMTV','и','0','','0','4081','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1101.gif','1','1','','0','0','0','','','','','','','','0','0','','297','0','','','','0','0','0','','http://flash.7k7k.com/fl_1/83084368704.swf','','','','1174069217');
INSERT INTO `p8_flash_swf` VALUES ('1296','10','͵MTV','и','0','','0','4767','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1102.gif','1','1','','0','0','0','','','','','','','','0','0','','298','0','','','ѧ','0','0','0','','http://flash.7k7k.com/fl_1/78375619649.swf','','','','1174269159');
INSERT INTO `p8_flash_swf` VALUES ('1297','10','ʱMTV','и','0','','0','3443','1','1065974400','1065974400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1330.gif','1','1','','0','0','0','','','','','','','','0','0','','299','0','','','Ρ','0','0','0','897','http://flash.7k7k.com/fl_1/51790487765.swf','˵ӭӣ','Ϸ','','1173922056');
INSERT INTO `p8_flash_swf` VALUES ('1298','10','MTV','и','0','','0','293','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1331.gif','1','1','','0','0','0','','','','','','','','0','0','','300','0','','','ų','0','0','0','','http://flash.7k7k.com/fl_1/67635375260.swf','','','','1173780504');
INSERT INTO `p8_flash_swf` VALUES ('1300','10','ţͰĹMTV','и','0','','0','10443','1','1065974400','1065974400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1333.gif','1','1','','0','0','0','','','','','','','','0','0','','302','0','','','ţ','0','0','0','873','http://flash.7k7k.com/fl_1/84662097691.swf','˵ӭӣ','¸ҵ','','1177211868');
INSERT INTO `p8_flash_swf` VALUES ('1303','10','껪ˮMTV','и','0','','0','8405','1','1065974400','1065974400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1336.gif','1','1','','0','0','0','','','','','','','','0','0','','305','0','','','','0','0','0','1217','http://flash.7k7k.com/fl_1/27115201949.swf','˵ӭӣ','п','','1174062262');
INSERT INTO `p8_flash_swf` VALUES ('1304','10','ͷMTV','и','0','','0','2307','1','1065974400','1065974400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1337.gif','1','1','','0','0','0','','','','','','','','0','0','','306','0','','','л','0','0','0','791','http://flash.7k7k.com/fl_1/5316323041.swf','˵ӭӣ','','','1174382840');
INSERT INTO `p8_flash_swf` VALUES ('1307','10','󰮸̰MTV','и','0','','0','1286','1','1066060800','1066060800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic1340.gif','1','1','','0','0','0','','','','','','','','0','0','','309','0','','','С','0','0','0','1974','http://flash.7k7k.com/fl_1/15456366538.swf','˵ӭӣ','the4world','','1174057594');
INSERT INTO `p8_flash_swf` VALUES ('1354','19','Ǹ1','ϵ','0','','0','631','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic045.gif','1','1','','0','0','0','','','','','','','','0','0','','356','0','','','','0','0','0','195','http://flash.7k7k.com/fl_3/52920067309.swf','()','ˮ','','1174351406');
INSERT INTO `p8_flash_swf` VALUES ('1355','19','','ϵ','0','','0','3524','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic046.gif','1','1','','0','0','0','','','','','','','','0','0','','357','0','','','','0','0','0','256','http://flash.7k7k.com/fl_3/66224175690.swf','()','ˮ','','1174352363');
INSERT INTO `p8_flash_swf` VALUES ('1356','19','2','ϵ','0','','0','5296','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic047.gif','1','1','','0','0','0','','','','','','','','0','0','','358','0','','','','0','0','0','309','http://flash.7k7k.com/fl_3/77796530722.swf','()','ˮ','','1174351557');
INSERT INTO `p8_flash_swf` VALUES ('1357','20','ݴ','ϵ','0','','0','5144','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic048.gif','1','1','','0','0','0','','','','','','','','0','0','','359','0','','','','0','0','0','1069','http://flash.7k7k.com/fl_3/68006223439.swf','()','showgood','','1174320327');
INSERT INTO `p8_flash_swf` VALUES ('1358','20','۶','ϵ','0','','0','3821','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic049.gif','1','1','','0','0','0','','','','','','','','0','0','','360','0','','','','0','0','0','1213','http://flash.7k7k.com/fl_3/73329293727.swf','()','showgood','','1174363538');
INSERT INTO `p8_flash_swf` VALUES ('1359','20','ɵ鶯','ϵ','0','','0','261','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic050.gif','1','1','','0','0','0','','','','','','','','0','0','','361','0','','','','0','0','0','1542','http://flash.7k7k.com/fl_3/8805090188.swf','()','showgood','','1174344891');
INSERT INTO `p8_flash_swf` VALUES ('1360','20','Ӣս','ϵ','0','','0','5397','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic051.gif','1','1','','0','0','0','','','','','','','','0','0','','362','0','','','','0','0','0','1591','http://flash.7k7k.com/fl_3/53862380980.swf','()','showgood','','1174219991');
INSERT INTO `p8_flash_swf` VALUES ('1361','20','԰嶯','ϵ','0','','0','9463','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic052.gif','1','1','','0','0','0','','','','','','','','0','0','','363','0','','','','0','0','0','1377','http://flash.7k7k.com/fl_3/29522722959.swf','()','showgood','','1174130458');
INSERT INTO `p8_flash_swf` VALUES ('1362','20','¾ն۶','ϵ','0','','0','3893','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic053.gif','1','1','','0','0','0','','','','','','','','0','0','','364','0','','','','0','0','0','1029','http://flash.7k7k.com/fl_3/910532474.swf','()','showgood','','1174154157');
INSERT INTO `p8_flash_swf` VALUES ('1363','20','۱','ϵ','0','','0','4263','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic054.gif','1','1','','0','0','0','','','','','','','','0','0','','365','0','','','','0','0','0','1030','http://flash.7k7k.com/fl_3/11673861741.swf','()','showgood','','1174376258');
INSERT INTO `p8_flash_swf` VALUES ('1364','20','ͤ','ϵ','0','','0','5356','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic055.gif','1','1','','0','0','0','','','','','','','','0','0','','366','0','','','','0','0','0','1884','http://flash.7k7k.com/fl_3/57426476478.swf','()','showgood','','1174346539');
INSERT INTO `p8_flash_swf` VALUES ('1365','20','˽ؼ','ϵ','0','','0','4627','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic057.gif','1','1','','0','0','0','','','','','','','','0','0','','367','0','','','','0','0','0','380','http://flash.7k7k.com/fl_3/18537467717.swf','()','showgood','','1173893472');
INSERT INTO `p8_flash_swf` VALUES ('1366','20','ͤ£','ϵ','0','','0','5515','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic061.gif','1','1','','0','0','0','','','','','','','','0','0','','368','0','','','','0','0','0','1249','http://flash.7k7k.com/fl_3/86689174174.swf','()','showgood','','1174339586');
INSERT INTO `p8_flash_swf` VALUES ('1367','20','ݣϣ','ϵ','0','','0','6449','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic062.gif','1','1','','0','0','0','','','','','','','','0','0','','369','0','','','','0','0','0','1329','http://flash.7k7k.com/fl_3/25855880975.swf','()','showgood','','1174175859');
INSERT INTO `p8_flash_swf` VALUES ('1368','20','֮','ϵ','0','','0','7310','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic063.gif','1','1','','0','0','0','','','','','','','','0','0','','370','0','','','','0','0','0','1019','http://flash.7k7k.com/fl_3/98861742018.swf','()','ľ','','1174387392');
INSERT INTO `p8_flash_swf` VALUES ('1369','20','ݣ£','ϵ','0','','0','9068','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic064.gif','1','1','','0','0','0','','','','','','','','0','0','','371','0','','','','0','0','0','994','http://flash.7k7k.com/fl_3/45423382520.swf','()','showgood','','1177931061');
INSERT INTO `p8_flash_swf` VALUES ('1374','19','֮','ϵ','0','','0','7160','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic069.gif','1','1','','0','0','0','','','','','','','','0','0','','376','0','','','','0','0','0','928','http://flash.7k7k.com/fl_3/93817365168.swf','()','ˮ','','1174252559');
INSERT INTO `p8_flash_swf` VALUES ('1757','19','ܽ^͵Ķ','ϵ','0','','0','4123','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic019.gif','1','1','','0','0','0','','','','','','','','0','0','','760','0','','','','0','0','0','779','http://flash.7k7k.com/fl_3/53119087218.swf','()','ˮ','','1174352345');
INSERT INTO `p8_flash_swf` VALUES ('1758','19','ǳԴǵĵ','ϵ','0','','0','2980','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic020.gif','1','1','','0','0','0','','','','','','','','0','0','','761','0','','','','0','0','0','542','http://flash.7k7k.com/fl_3/65500468015.swf','ղِеŮl隢¼Ĳصɷ⼮̫̫`㽶','ˮ','','1174352376');
INSERT INTO `p8_flash_swf` VALUES ('1759','19','_Ƥ','ϵ','0','','0','8579','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic021.gif','1','1','','0','0','0','','','','','','','','0','0','','762','0','','','','0','0','0','777','http://flash.7k7k.com/fl_3/167238712.swf','()','ˮ','','1174351588');
INSERT INTO `p8_flash_swf` VALUES ('1760','19','ɐ[','ϵ','0','','0','2183','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic022.gif','1','1','','0','0','0','','','','','','','','0','0','','763','0','','','','0','0','0','349','http://flash.7k7k.com/fl_3/47651606797.swf','()','ˮ','','1174396546');
INSERT INTO `p8_flash_swf` VALUES ('1761','19','ɨ','ϵ','0','','0','8050','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic023.gif','1','1','','0','0','0','','','','','','','','0','0','','764','0','','','','0','0','0','446','http://flash.7k7k.com/fl_3/56683182715.swf','()','ˮ','','1174192937');
INSERT INTO `p8_flash_swf` VALUES ('1762','19','ѧ񶯻','ϵ','0','','0','443','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic024.gif','1','1','','0','0','0','','','','','','','','0','0','','765','0','','','','0','0','0','859','http://flash.7k7k.com/fl_3/81073135136.swf','()','ˮ','','1174394536');
INSERT INTO `p8_flash_swf` VALUES ('1763','19','˭ƨ','ϵ','0','','0','1538','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic025.gif','1','1','','0','0','0','','','','','','','','0','0','','766','0','','','','0','0','0','775','http://flash.7k7k.com/fl_3/6272113323.swf','()','ˮ','','1174080910');
INSERT INTO `p8_flash_swf` VALUES ('1764','19','ֱ̰˶','ϵ','0','','0','1395','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic026.gif','1','1','','0','0','0','','','','','','','','0','0','','767','0','','','','0','0','0','657','http://flash.7k7k.com/fl_3/49370247125.swf','()','ˮ','','1173966646');
INSERT INTO `p8_flash_swf` VALUES ('1765','19','ѧϣ','ϵ','0','','0','6556','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic027.gif','1','1','','0','0','0','','','','','','','','0','0','','768','0','','','','0','0','0','934','http://flash.7k7k.com/fl_3/65328836440.swf','()','ˮ','','1174199422');
INSERT INTO `p8_flash_swf` VALUES ('1766','19','Ӷ','ϵ','0','','0','8244','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic028.gif','1','1','','0','0','0','','','','','','','','0','0','','769','0','','','','0','0','0','602','http://flash.7k7k.com/fl_3/1727360486.swf','()','ˮ','','1174364084');
INSERT INTO `p8_flash_swf` VALUES ('1767','19','Ƿ^궯','ϵ','0','','0','6461','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic029.gif','1','1','','0','0','0','','','','','','','','0','0','','770','0','','','','0','0','0','492','http://flash.7k7k.com/fl_3/44016468524.swf','()','ˮ','','1174394856');
INSERT INTO `p8_flash_swf` VALUES ('1768','19','Ոֶ','ϵ','0','','0','1398','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic030.gif','1','1','','0','0','0','','','','','','','','0','0','','771','0','','','','0','0','0','862','http://flash.7k7k.com/fl_3/88960057496.swf','()','ˮ','','1174395334');
INSERT INTO `p8_flash_swf` VALUES ('1769','19','ҹ','ϵ','0','','0','8108','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic031.gif','1','1','','0','0','0','','','','','','','','0','0','','772','0','','','','0','0','0','1145','http://flash.7k7k.com/fl_3/32171893119.swf','()','ˮ','','1174147755');
INSERT INTO `p8_flash_swf` VALUES ('1770','19','߼ɿ','ϵ','0','','0','5998','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic032.gif','1','1','','0','0','0','','','','','','','','0','0','','773','0','','','','0','0','0','657','http://flash.7k7k.com/fl_3/68994516133.swf','()','ˮ','','1173886748');
INSERT INTO `p8_flash_swf` VALUES ('1771','19','һö','ϵ','0','','0','9271','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic033.gif','1','1','','0','0','0','','','','','','','','0','0','','774','0','','','','0','0','0','829','http://flash.7k7k.com/fl_3/54931676387.swf','()','ˮ','','1174237841');
INSERT INTO `p8_flash_swf` VALUES ('1772','19','׃˶','ϵ','0','','0','9391','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic034.gif','1','1','','0','0','0','','','','','','','','0','0','','775','0','','','','0','0','0','474','http://flash.7k7k.com/fl_3/22046953439.swf','()','ˮ','','1174253826');
INSERT INTO `p8_flash_swf` VALUES ('1773','19','в𴲶','ϵ','0','','0','6130','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic035.gif','1','1','','0','0','0','','','','','','','','0','0','','776','0','','','','0','0','0','782','http://flash.7k7k.com/fl_3/92512035368.swf','()','ˮ','','1174253777');
INSERT INTO `p8_flash_swf` VALUES ('1774','19','|۱ɽ','ϵ','0','','0','8448','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic036.gif','1','1','','0','0','0','','','','','','','','0','0','','777','0','','','','0','0','0','559','http://flash.7k7k.com/fl_3/52927702664.swf','()','ˮ','','1174394280');
INSERT INTO `p8_flash_swf` VALUES ('1775','19','໰2','ϵ','0','','0','901','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic037.gif','1','1','','0','0','0','','','','','','','','0','0','','778','0','','','','0','0','0','582','http://flash.7k7k.com/fl_3/2839148044.swf','()','ˮ','','1174292754');
INSERT INTO `p8_flash_swf` VALUES ('1776','19','㶯','ϵ','0','','0','7455','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic038.gif','1','1','','0','0','0','','','','','','','','0','0','','779','0','','','','0','0','0','297','http://flash.7k7k.com/fl_3/18684035539.swf','()','ˮ','','1174392604');
INSERT INTO `p8_flash_swf` VALUES ('1777','19','˽2','ϵ','0','','0','9053','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic039.gif','1','1','','0','0','0','','','','','','','','0','0','','780','0','','','','0','0','0','342','http://flash.7k7k.com/fl_3/2307820320.swf','()','ˮ','','1174266157');
INSERT INTO `p8_flash_swf` VALUES ('1778','19','˽1','ϵ','0','','0','5247','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic040.gif','1','1','','0','0','0','','','','','','','','0','0','','781','0','','','','0','0','0','199','http://flash.7k7k.com/fl_3/95058292149.swf','()','ˮ','','1174340873');
INSERT INTO `p8_flash_swf` VALUES ('1779','19','տ옷','ϵ','0','','0','7220','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic041.gif','1','1','','0','0','0','','','','','','','','0','0','','782','0','','','','0','0','0','836','http://flash.7k7k.com/fl_3/15175712108.swf','()','ˮ','','1174393315');
INSERT INTO `p8_flash_swf` VALUES ('1780','19','Ǹ2','ϵ','0','','0','2883','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic042.gif','1','1','','0','0','0','','','','','','','','0','0','','783','0','','','','0','0','0','638','http://flash.7k7k.com/fl_3/79750210045.swf','()','ˮ','','1174320311');
INSERT INTO `p8_flash_swf` VALUES ('1781','19','˾߶','ϵ','0','','0','328','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic043.gif','1','1','','0','0','0','','','','','','','','0','0','','784','0','','','','0','0','0','1200','http://flash.7k7k.com/fl_3/10953474044.swf','()','ˮ','','1174181492');
INSERT INTO `p8_flash_swf` VALUES ('1782','19','֮һ','ϵ','0','','0','1085','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic044.gif','1','1','','0','0','0','','','','','','','','0','0','','785','0','','','','0','0','0','925','http://flash.7k7k.com/fl_3/15712517499.swf','()','ˮ','','1174365800');
INSERT INTO `p8_flash_swf` VALUES ('1789','19','֮ƪ','ϵ','0','','0','6613','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic016.gif','1','1','','0','0','0','','','','','','','','0','0','','792','0','','','','0','0','0','613','http://flash.7k7k.com/fl_2/75943273305.swf','()','ˮ','','1173888772');
INSERT INTO `p8_flash_swf` VALUES ('1790','19','⶯','ϵ','0','','0','3639','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic017.gif','1','1','','0','0','0','','','','','','','','0','0','','793','0','','','','0','0','0','903','http://flash.7k7k.com/fl_2/26309525966.swf','()','ˮ','','1174361152');
INSERT INTO `p8_flash_swf` VALUES ('1791','19','Ϸ鶯','ϵ','0','','0','9153','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic018.gif','1','1','','0','0','0','','','','','','','','0','0','','794','0','','','','0','0','0','1217','http://flash.7k7k.com/fl_2/37527662515.swf','()','ˮ','','1174254022');
INSERT INTO `p8_flash_swf` VALUES ('1792','19','ȯһ','ϵ','0','','0','9945','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic019.gif','1','1','','0','0','0','','','','','','','','0','0','','795','0','','','','0','0','0','752','http://flash.7k7k.com/fl_2/13074302673.swf','()','ˮ','','1174255232');
INSERT INTO `p8_flash_swf` VALUES ('1793','19','ȯ','ϵ','0','','0','3518','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic020.gif','1','1','','0','0','0','','','','','','','','0','0','','796','0','','','','0','0','0','748','http://flash.7k7k.com/fl_2/52013605832.swf','()','ˮ','','1174379918');
INSERT INTO `p8_flash_swf` VALUES ('1803','19','͸','ϵ','0','','0','7525','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic029.gif','1','1','','0','0','0','','','','','','','','0','0','','806','0','','','','0','0','0','978','http://flash.7k7k.com/fl_2/85846120118.swf','()','ˮ','','1174291308');
INSERT INTO `p8_flash_swf` VALUES ('1838','19','-2','ϵ','0','','0','7326','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic055.gif','1','1','','0','0','0','','','','','','','','0','0','','842','0','','','','0','0','0','660','http://flash.7k7k.com/fl_2/69320017098.swf','()','ˮ','','1174383799');
INSERT INTO `p8_flash_swf` VALUES ('1839','19','˶','ϵ','0','','0','9534','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic056.gif','1','1','','0','0','0','','','','','','','','0','0','','843','0','','','','0','0','0','770','http://flash.7k7k.com/fl_2/29621982574.swf','()','ˮ','','1174365612');
INSERT INTO `p8_flash_swf` VALUES ('1840','19','Ƥ䶯','ϵ','0','','0','554','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic057.gif','1','1','','0','0','0','','','','','','','','0','0','','844','0','','','','0','0','0','1450','http://flash.7k7k.com/fl_2/79874533414.swf','()','ˮ','','1174365721');
INSERT INTO `p8_flash_swf` VALUES ('1841','19','Ƭ','ϵ','0','','0','7554','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic058.gif','1','1','','0','0','0','','','','','','','','0','0','','845','0','','','','0','0','0','705','http://flash.7k7k.com/fl_2/99296629427.swf','()','ˮ','','1174299086');
INSERT INTO `p8_flash_swf` VALUES ('1842','19','Ƭ2','ϵ','0','','0','1313','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic059.gif','1','1','','0','0','0','','','','','','','','0','0','','846','0','','','','0','0','0','598','http://flash.7k7k.com/fl_2/51862555741.swf','()','ˮ','','1174360852');
INSERT INTO `p8_flash_swf` VALUES ('1843','19',' - վ','ϵ','0','','0','9313','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic060.gif','1','1','','0','0','0','','','','','','','','0','0','','847','0','','','','0','0','0','858','http://flash.7k7k.com/fl_2/92533612250.swf','()','ˮ','','1174003248');
INSERT INTO `p8_flash_swf` VALUES ('1844','19',' - ѧУ˵','ϵ','0','','0','671','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic061.gif','1','1','','0','0','0','','','','','','','','0','0','','848','0','','','','0','0','0','900','http://flash.7k7k.com/fl_2/1678889989.swf','()','ˮ','','1174185402');
INSERT INTO `p8_flash_swf` VALUES ('1845','19','ӡǶ','ϵ','0','','0','9757','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic062.gif','1','1','','0','0','0','','','','','','','','0','0','','849','0','','','','0','0','0','727','http://flash.7k7k.com/fl_2/58517348765.swf','()','ˮ','','1174379389');
INSERT INTO `p8_flash_swf` VALUES ('1846','19','һԴ','ϵ','0','','0','9343','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic063.gif','1','1','','0','0','0','','','','','','','','0','0','','850','0','','','','0','0','0','1747','http://flash.7k7k.com/fl_2/86370807885.swf','()','ˮ','','1174002466');
INSERT INTO `p8_flash_swf` VALUES ('1847','19','˧','ϵ','0','','0','9778','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic064.gif','1','1','','0','0','0','','','','','','','','0','0','','851','0','','','','0','0','0','540','http://flash.7k7k.com/fl_2/27737188338.swf','()','ˮ','','1174365507');
INSERT INTO `p8_flash_swf` VALUES ('1848','19','̵궯','ϵ','0','','0','5311','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic065.gif','1','1','','0','0','0','','','','','','','','0','0','','852','0','','','','0','0','0','782','http://flash.7k7k.com/fl_2/22333115339.swf','()','ˮ','','1174292720');
INSERT INTO `p8_flash_swf` VALUES ('1849','19','I speak english','ϵ','0','','0','3730','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic066.gif','1','1','','0','0','0','','','','','','','','0','0','','853','0','','','','0','0','0','470','http://flash.7k7k.com/fl_2/96261703967.swf','()','ˮ','','1174365438');
INSERT INTO `p8_flash_swf` VALUES ('1850','19',' - ٶ','ϵ','0','','0','1105','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic067.gif','1','1','','0','0','0','','','','','','','','0','0','','854','0','','','','0','0','0','853','http://flash.7k7k.com/fl_2/93171006440.swf','()','ˮ','','1174002633');
INSERT INTO `p8_flash_swf` VALUES ('1851','19','˹ﶯ','ϵ','0','','0','6873','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic068.gif','1','1','','0','0','0','','','','','','','','0','0','','855','0','','','','0','0','0','683','http://flash.7k7k.com/fl_2/21138167381.swf','()','ˮ','','1174041486');
INSERT INTO `p8_flash_swf` VALUES ('1852','19','','ϵ','0','','0','1599','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic069.gif','1','1','','0','0','0','','','','','','','','0','0','','856','0','','','','0','0','0','588','http://flash.7k7k.com/fl_2/89600270985.swf','()','ˮ','','1174353846');
INSERT INTO `p8_flash_swf` VALUES ('1853','19','øﶯ','ϵ','0','','0','2916','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic070.gif','1','1','','0','0','0','','','','','','','','0','0','','857','0','','','','0','0','0','1210','http://flash.7k7k.com/fl_2/7176911830.swf','()','ˮ','','1174053568');
INSERT INTO `p8_flash_swf` VALUES ('1854','19','Ĺ԰','ϵ','0','','0','1278','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic071.gif','1','1','','0','0','0','','','','','','','','0','0','','858','0','','','','0','0','0','734','http://flash.7k7k.com/fl_2/59047514199.swf','()','ˮ','','1174355245');
INSERT INTO `p8_flash_swf` VALUES ('1855','19','Сĸð','ϵ','0','','0','1532','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic072.gif','1','1','','0','0','0','','','','','','','','0','0','','859','0','','','','0','0','0','358','http://flash.7k7k.com/fl_2/34594154357.swf','()','ˮ','','1174355262');
INSERT INTO `p8_flash_swf` VALUES ('1856','19','˶','ϵ','0','','0','1808','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic073.gif','1','1','','0','0','0','','','','','','','','0','0','','860','0','','','','0','0','0','349','http://flash.7k7k.com/fl_2/26649302243.swf','()','ˮ','','1174348876');
INSERT INTO `p8_flash_swf` VALUES ('1857','19','F}͏d','ϵ','0','','0','5769','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic074.gif','1','1','','0','0','0','','','','','','','','0','0','','861','0','','','','0','0','0','1139','http://flash.7k7k.com/fl_2/61316072940.swf','()','ˮ','','1174355793');
INSERT INTO `p8_flash_swf` VALUES ('1858','19','ˮ1','ϵ','0','','0','9589','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic075.gif','1','1','','0','0','0','','','','','','','','0','0','','862','0','','','','0','0','0','899','http://flash.7k7k.com/fl_2/82242518662.swf','()','ˮ','','1174292720');
INSERT INTO `p8_flash_swf` VALUES ('1859','19','ˮ2','ϵ','0','','0','9680','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic076.gif','1','1','','0','0','0','','','','','','','','0','0','','863','0','','','','0','0','0','820','http://flash.7k7k.com/fl_2/38158249854.swf','()','ˮ','','1174386748');
INSERT INTO `p8_flash_swf` VALUES ('1860','19','⶯','ϵ','0','','0','3084','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic077.gif','1','1','','0','0','0','','','','','','','','0','0','','864','0','','','','0','0','0','900','http://flash.7k7k.com/fl_2/62548202275.swf','()','ˮ','','1174355239');
INSERT INTO `p8_flash_swf` VALUES ('1861','19','ĸ׽ڶ','ϵ','0','','0','5705','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic078.gif','1','1','','0','0','0','','','','','','','','0','0','','865','0','','','','0','0','0','883','http://flash.7k7k.com/fl_2/14305102825.swf','()','ˮ','','1174336442');
INSERT INTO `p8_flash_swf` VALUES ('1862','19','ĸ׶','ϵ','0','','0','687','1','1058112000','1058112000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic079.gif','1','1','','0','0','0','','','','','','','','0','0','','866','0','','','','0','0','0','573','http://flash.7k7k.com/fl_2/10519081354.swf','()','ˮ','','1174318793');
INSERT INTO `p8_flash_swf` VALUES ('1863','19','ԩ','ϵ','0','','0','2292','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic080.gif','1','1','','0','0','0','','','','','','','','0','0','','867','0','','','','0','0','0','564','http://flash.7k7k.com/fl_2/73361825942.swf','()','ˮ','','1174166584');
INSERT INTO `p8_flash_swf` VALUES ('1864','19','ƵҶ','ϵ','0','','0','7616','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic081.gif','1','1','','0','0','0','','','','','','','','0','0','','868','0','','','','0','0','0','599','http://flash.7k7k.com/fl_2/1897495985.swf','()','ˮ','','1174355185');
INSERT INTO `p8_flash_swf` VALUES ('1865','19','㵽','ϵ','0','','0','1165','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic082.gif','1','1','','0','0','0','','','','','','','','0','0','','869','0','','','','0','0','0','422','http://flash.7k7k.com/fl_2/70744526385.swf','()','ˮ','','1174361720');
INSERT INTO `p8_flash_swf` VALUES ('1866','19','Ĺӛ1','ϵ','0','','0','4191','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic083.gif','1','1','','0','0','0','','','','','','','','0','0','','870','0','','','','0','0','0','997','http://flash.7k7k.com/fl_2/89130192994.swf','()','ˮ','','1174482837');
INSERT INTO `p8_flash_swf` VALUES ('1867','19','Ĺӛ2','ϵ','0','','0','5209','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic084.gif','1','1','','0','0','0','','','','','','','','0','0','','871','0','','','','0','0','0','898','http://flash.7k7k.com/fl_2/33513903617.swf','()','ˮ','','1174355225');
INSERT INTO `p8_flash_swf` VALUES ('1868','19','rՌQ','ϵ','0','','0','2638','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic085.gif','1','1','','0','0','0','','','','','','','','0','0','','872','0','','','','0','0','0','629','http://flash.7k7k.com/fl_2/8478921651.swf','()','ˮ','','1174351275');
INSERT INTO `p8_flash_swf` VALUES ('1869','19','lӄwǶ','ϵ','0','','0','5591','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic086.gif','1','1','','0','0','0','','','','','','','','0','0','','873','0','','','','0','0','0','1082','http://flash.7k7k.com/fl_2/41300237178.swf','()','ˮ','','1174003174');
INSERT INTO `p8_flash_swf` VALUES ('1870','19','㶯','ϵ','0','','0','4907','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic087.gif','1','1','','0','0','0','','','','','','','','0','0','','874','0','','','','0','0','0','1176','http://flash.7k7k.com/fl_2/70732408761.swf','()','ˮ','','1174363420');
INSERT INTO `p8_flash_swf` VALUES ('1871','19','Т˳ƶ','ϵ','0','','0','9471','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic088.gif','1','1','','0','0','0','','','','','','','','0','0','','875','0','','','','0','0','0','766','http://flash.7k7k.com/fl_2/14639568328.swf','()','ˮ','','1174319114');
INSERT INTO `p8_flash_swf` VALUES ('1872','19','־ѪǶ','ϵ','0','','0','239','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic089.gif','1','1','','0','0','0','','','','','','','','0','0','','876','0','','','','0','0','0','1077','http://flash.7k7k.com/fl_2/28171080350.swf','()','ˮ','','1174337795');
INSERT INTO `p8_flash_swf` VALUES ('1873','19','ǻῨ궯','ϵ','0','','0','7453','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic090.gif','1','1','','0','0','0','','','','','','','','0','0','','877','0','','','','0','0','0','752','http://flash.7k7k.com/fl_2/78082525729.swf','()','ˮ','','1174326959');
INSERT INTO `p8_flash_swf` VALUES ('1874','19','ҰӶ','ϵ','0','','0','2494','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic091.gif','1','1','','0','0','0','','','','','','','','0','0','','878','0','','','','0','0','0','448','http://flash.7k7k.com/fl_2/93927413224.swf','()','ˮ','','1174354963');
INSERT INTO `p8_flash_swf` VALUES ('1875','19','͸˶','ϵ','0','','0','984','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic092.gif','1','1','','0','0','0','','','','','','','','0','0','','879','0','','','','0','0','0','771','http://flash.7k7k.com/fl_2/71319508551.swf','()','ˮ','','1174310848');
INSERT INTO `p8_flash_swf` VALUES ('1952','10','۾MTV','и','0','','0','199','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic748.gif','1','1','','0','0','0','','','','','','','','0','0','','956','0','','','ƽ','0','0','0','1291','http://flash.7k7k.com/fl_1/9927523136.swf','()','flysky','','1174379855');
INSERT INTO `p8_flash_swf` VALUES ('1953','10','˼޽MTV','и','0','','0','7246','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic749.gif','1','1','','0','0','0','','','','','','','','0','0','','957','0','','','ƽ','0','0','0','775','http://flash.7k7k.com/fl_1/43317347764.swf','()','','','1174269074');
INSERT INTO `p8_flash_swf` VALUES ('1954','10','ϬMTV','и','0','','0','7402','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic750.gif','1','1','','0','0','0','','','','','','','','0','0','','958','0','','','ƽ','0','0','0','1082','http://flash.7k7k.com/fl_1/52348923682.swf','()','','','1174084705');
INSERT INTO `p8_flash_swf` VALUES ('1955','10','׷ŮMTV','и','0','','0','1540','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic751.gif','1','1','','0','0','0','','','','','','','','0','0','','959','0','','','ڽ','0','0','0','552','http://flash.7k7k.com/fl_1/76738876103.swf','()','һ','','1173577367');
INSERT INTO `p8_flash_swf` VALUES ('1956','10','MTV','и','0','','0','3503','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic752.gif','1','1','','0','0','0','','','','','','','','0','0','','960','0','','','ڽ','0','0','0','1047','http://flash.7k7k.com/fl_1/28495776653.swf','()','ɵ','','1174288453');
INSERT INTO `p8_flash_swf` VALUES ('1957','10','ҲMTV','и','0','','0','8592','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic753.gif','1','1','','0','0','0','','','','','','','','0','0','','961','0','','','','0','0','0','489','http://flash.7k7k.com/fl_1/71593910454.swf','()','DZM','','1174218800');
INSERT INTO `p8_flash_swf` VALUES ('1958','10','MTV','и','0','','0','1759','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic754.gif','1','1','','0','0','0','','','','','','','','0','0','','962','0','','','','0','0','0','1173','http://flash.7k7k.com/fl_1/34436655044.swf','()','','','1174332915');
INSERT INTO `p8_flash_swf` VALUES ('1959','10','Ҹ˲MTV','и','0','','0','1783','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic755.gif','1','1','','0','0','0','','','','','','','','0','0','','963','0','','','','0','0','0','1250','http://flash.7k7k.com/fl_1/44277256726.swf','()','С','','1174269133');
INSERT INTO `p8_flash_swf` VALUES ('1960','10','Ϊʲô㱳ҰMTV','и','0','','0','2572','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic219.gif','1','1','','0','0','0','','','','','','','','0','0','','964','0','','','־','0','0','0','1271','http://flash.7k7k.com/fl_1/13124287128.swf','()','','','1174113769');
INSERT INTO `p8_flash_swf` VALUES ('1961','10','MTV','и','0','','0','7950','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic756.gif','1','1','','0','0','0','','','','','','','','0','0','','965','0','','','־','0','0','0','1171','http://flash.7k7k.com/fl_1/78394109009.swf','()','','','1174053050');
INSERT INTO `p8_flash_swf` VALUES ('1962','10','MTV','и','0','','0','1091','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic757.gif','1','1','','0','0','0','','','','','','','','0','0','','966','0','','','־','0','0','0','593','http://flash.7k7k.com/fl_1/21605944633.swf','()','','','1174269687');
INSERT INTO `p8_flash_swf` VALUES ('1963','10','ʧMTV','и','0','','0','4890','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic760.gif','1','1','','0','0','0','','','','','','','','0','0','','967','0','','','־','0','0','0','917','http://flash.7k7k.com/fl_1/43455117940.swf','()','','','1173830009');
INSERT INTO `p8_flash_swf` VALUES ('1964','10','ȥMTV','и','0','','0','4592','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic759.gif','1','1','','0','0','0','','','','','','','','0','0','','968','0','','','־','0','0','0','664','http://flash.7k7k.com/fl_1/29392278194.swf','()','2','','1174021837');
INSERT INTO `p8_flash_swf` VALUES ('1965','10','ƵMTV','и','0','','0','8794','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic758.gif','1','1','','0','0','0','','','','','','','','0','0','','969','0','','','־','0','0','0','643','http://flash.7k7k.com/fl_1/2739244699.swf','()','','','1174149517');
INSERT INTO `p8_flash_swf` VALUES ('1966','10','˶ǻ׷MTV','и','0','','0','94','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic047.gif','1','1','','0','0','0','','','','','','','','0','0','','970','0','','','ѩ','0','0','0','370','http://flash.7k7k.com/fl_1/5993938445.swf','()','Babylon','','1174053279');
INSERT INTO `p8_flash_swf` VALUES ('1967','10','ץMTV','и','0','','0','1807','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic050.gif','1','1','','0','0','0','','','','','','','','0','0','','971','0','','','ѩ','0','0','0','720','http://flash.7k7k.com/fl_1/85983580350.swf','()','Babylon','','1174172177');
INSERT INTO `p8_flash_swf` VALUES ('1968','10','MTV','и','0','','0','1749','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic148.gif','1','1','','0','0','0','','','','','','','','0','0','','972','0','','','ѩ','0','0','0','462','http://flash.7k7k.com/fl_1/35895025729.swf','()','wanderer','','1173884721');
INSERT INTO `p8_flash_swf` VALUES ('1969','10','MTV','и','0','','0','9529','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic161.gif','1','1','','0','0','0','','','','','','','','0','0','','973','0','','','ѩ','0','0','0','','http://flash.7k7k.com/fl_1/4855757951.swf','','','','1174134488');
INSERT INTO `p8_flash_swf` VALUES ('1970','10','MTV','и','0','','0','8446','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic163.gif','1','1','','0','0','0','','','','','','','','0','0','','974','0','','','ѩ','0','0','0','289','http://flash.7k7k.com/fl_1/82247853278.swf','()','Ұ','','1174349006');
INSERT INTO `p8_flash_swf` VALUES ('1971','10','˶ǻ׷MTV','и','0','','0','8468','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic171.gif','1','1','','0','0','0','','','','','','','','0','0','','975','0','','','ѩ','0','0','0','391','http://flash.7k7k.com/fl_1/1556247472.swf','()','dconan79','','1174381467');
INSERT INTO `p8_flash_swf` VALUES ('1972','10','MTV','и','0','','0','1234','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic182.gif','1','1','','0','0','0','','','','','','','','0','0','','976','0','','','ѩ','0','0','0','549','http://flash.7k7k.com/fl_1/21673667430.swf','()','HUHU','','1174177136');
INSERT INTO `p8_flash_swf` VALUES ('1973','10','лл㣬װϱMTV','и','0','','0','3598','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic237.gif','1','1','','0','0','0','','','','','','','','0','0','','977','0','','','ѩ','0','0','0','638','http://flash.7k7k.com/fl_1/59690243005.swf','()','è','','1174106146');
INSERT INTO `p8_flash_swf` VALUES ('1974','10','MTV','и','0','','0','848','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic269.gif','1','1','','0','0','0','','','','','','','','0','0','','978','0','','','ѩ','0','0','0','','http://flash.7k7k.com/fl_1/17451429366.swf','','','','1173976229');
INSERT INTO `p8_flash_swf` VALUES ('1975','10','MTV','и','0','','0','5818','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic283.gif','1','1','','0','0','0','','','','','','','','0','0','','979','0','','','ѩ','0','0','0','789','http://flash.7k7k.com/fl_1/22210472821.swf','()','֡','','1174093317');
INSERT INTO `p8_flash_swf` VALUES ('1976','10','һֻMTV','и','0','','0','5231','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic203.gif','1','1','','0','0','0','','','','','','','','0','0','','980','0','','','ѩ','0','0','0','1141','http://flash.7k7k.com/fl_1/6302177905.swf','()','E.I.','','1174346797');
INSERT INTO `p8_flash_swf` VALUES ('1977','10','MTV','и','0','','0','9451','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic369.gif','1','1','','0','0','0','','','','','','','','0','0','','981','0','','','ѩ','0','0','0','570','http://flash.7k7k.com/fl_1/93048363923.swf','()','ͺ','','1173493780');
INSERT INTO `p8_flash_swf` VALUES ('1978','10','÷ǷиMTV','и','0','','0','6982','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic370.gif','1','1','','0','0','0','','','','','','','','0','0','','982','0','','','ѩ','0','0','0','679','http://flash.7k7k.com/fl_1/57736563681.swf','()','֮','','1174352240');
INSERT INTO `p8_flash_swf` VALUES ('1979','10','maryMTV','и','0','','0','9782','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic371.gif','1','1','','0','0','0','','','','','','','','0','0','','983','0','','','ѩ','0','0','0','391','http://flash.7k7k.com/fl_1/7293790578.swf','()','dconan79','','1173513286');
INSERT INTO `p8_flash_swf` VALUES ('1980','10','СɵMTV','и','0','','0','918','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic372.gif','1','1','','0','0','0','','','','','','','','0','0','','984','0','','','ѩ','0','0','0','452','http://flash.7k7k.com/fl_1/61591470240.swf','()','','','1173474055');
INSERT INTO `p8_flash_swf` VALUES ('1981','10','ʾMTV','и','0','','0','520','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic373.gif','1','1','','0','0','0','','','','','','','','0','0','','985','0','','','ѩ','0','0','0','409','http://flash.7k7k.com/fl_1/23625189065.swf','()','è','','1173843013');
INSERT INTO `p8_flash_swf` VALUES ('1982','10','ĺܰMTV','и','0','','0','1525','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic761.gif','1','1','','0','0','0','','','','','','','','0','0','','986','0','','','Գ','0','0','0','676','http://flash.7k7k.com/fl_1/37064743041.swf','()','','','1173811345');
INSERT INTO `p8_flash_swf` VALUES ('1984','10','ɴMTV','и','0','','0','500','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic374.gif','1','1','','0','0','0','','','','','','','','0','0','','988','0','','','','0','0','0','1200','http://flash.7k7k.com/fl_1/47767984866.swf','()','ңԶ','','1174117229');
INSERT INTO `p8_flash_swf` VALUES ('1985','10','νMTV','и','0','','0','5244','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic375.gif','1','1','','0','0','0','','','','','','','','0','0','','989','0','','','','0','0','0','1199','http://flash.7k7k.com/fl_1/31973391770.swf','()','ϻ','','1174085030');
INSERT INTO `p8_flash_swf` VALUES ('1986','10','ƴŻӮMTV','и','0','','0','4204','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic762.gif','1','1','','0','0','0','','','','','','','','0','0','','990','0','','','Ҷ','0','0','0','1375','http://flash.7k7k.com/fl_1/77726006507.swf','()','','','1174318448');
INSERT INTO `p8_flash_swf` VALUES ('1987','10','MTV','и','0','','0','6344','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic033.gif','1','1','','0','0','0','','','','','','','','0','0','','991','0','','','κ','0','0','0','3882','http://flash.7k7k.com/fl_1/65394920110.swf','()','','','1174225885');
INSERT INTO `p8_flash_swf` VALUES ('1988','10','˹MTV','и','0','','0','1159','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic763.gif','1','1','','0','0','0','','','','','','','','0','0','','992','0','','','κ','0','0','0','831','http://flash.7k7k.com/fl_1/757014751.swf','()','С','','1174392281');
INSERT INTO `p8_flash_swf` VALUES ('1989','10','ɳMTV','и','0','','0','7057','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic764.gif','1','1','','0','0','0','','','','','','','','0','0','','993','0','','','κ','0','0','0','1102','http://flash.7k7k.com/fl_1/33692032098.swf','()','','','1174075384');
INSERT INTO `p8_flash_swf` VALUES ('1990','10','˼MTV','и','0','','0','9635','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic765.gif','1','1','','0','0','0','','','','','','','','0','0','','994','0','','','κ','0','0','0','675','http://flash.7k7k.com/fl_1/59813737868.swf','()','Water','','1174064318');
INSERT INTO `p8_flash_swf` VALUES ('1991','10','MTV','и','0','','0','5791','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic766.gif','1','1','','0','0','0','','','','','','','','0','0','','995','0','','','κ','0','0','0','1251','http://flash.7k7k.com/fl_1/32933300733.swf','()','Hilenx','','1173737618');
INSERT INTO `p8_flash_swf` VALUES ('1992','10','MTV','и','0','','0','5063','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic767.gif','1','1','','0','0','0','','','','','','','','0','0','','996','0','','','κ','0','0','0','688','http://flash.7k7k.com/fl_1/38501369952.swf','()','Water','','1174310805');
INSERT INTO `p8_flash_swf` VALUES ('1993','10','һһMTV','и','0','','0','4390','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic768.gif','1','1','','0','0','0','','','','','','','','0','0','','997','0','','','κ','0','0','0','1357','http://flash.7k7k.com/fl_1/21337872743.swf','()','޾','','1173650184');
INSERT INTO `p8_flash_swf` VALUES ('1994','10','MTV','и','0','','0','7568','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic769.gif','1','1','','0','0','0','','','','','','','','0','0','','998','0','','','κ','0','0','0','772','http://flash.7k7k.com/fl_1/27828669547.swf','()','Ц','','1174073108');
INSERT INTO `p8_flash_swf` VALUES ('1995','10','µѩMTV','и','0','','0','5620','1','1058112000','1058112000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic770.gif','1','1','','0','0','0','','','','','','','','0','0','','999','0','','','κ','0','0','0','765','http://flash.7k7k.com/fl_1/86398881672.swf','()','','','1173814196');
INSERT INTO `p8_flash_swf` VALUES ('1996','10','ҵ˺ҰMTV','и','0','','0','9438','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic772.gif','1','1','','0','0','0','','','','','','','','0','0','','1001','0','','','κ','0','0','0','1147','http://flash.7k7k.com/fl_1/39451318978.swf','()','Beachboy','','1174291274');
INSERT INTO `p8_flash_swf` VALUES ('1997','10','䵥ĺMTV','и','0','','0','698','1','1055520000','1055520000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_1.pic/7k7k_flash_pic773.gif','1','1','','0','0','0','','','','','','','','0','0','','1002','0','','','κ','0','0','0','871','http://flash.7k7k.com/fl_1/99753284453.swf','()','','','1173999267');
INSERT INTO `p8_flash_swf` VALUES ('2455','20','ٱ䡱=绨','ϵ','0','','0','7909','1','1057507200','1057507200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic121.gif','1','1','','0','0','0','','','','','','','','0','0','','1607','0','','','','0','0','0','862','http://flash.7k7k.com/fl_2/76501351594.swf','()','showgood','','1174003153');
INSERT INTO `p8_flash_swf` VALUES ('3598','20','籭1','ϵ','0','','0','7420','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic362.gif','1','1','','0','0','0','','','','','','','','0','0','','2753','0','','','','0','0','0','1093','http://flash.7k7k.com/fl_2/40232408046.swf','˵ӭӣ','ShowGood','','1174378227');
INSERT INTO `p8_flash_swf` VALUES ('3599','20','籭2','ϵ','0','','0','5636','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic363.gif','1','1','','0','0','0','','','','','','','','0','0','','2754','0','','','','0','0','0','2030','http://flash.7k7k.com/fl_2/17029768228.swf','˵ӭӣ','ShowGood','','1174351447');
INSERT INTO `p8_flash_swf` VALUES ('3600','20','籭3','ϵ','0','','0','6640','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic364.gif','1','1','','0','0','0','','','','','','','','0','0','','2755','0','','','','0','0','0','1190','http://flash.7k7k.com/fl_2/92576408385.swf','˵ӭӣ','ShowGood','','1174345355');
INSERT INTO `p8_flash_swf` VALUES ('3601','20','籭4','ϵ','0','','0','9361','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic365.gif','1','1','','0','0','0','','','','','','','','0','0','','2756','0','','','','0','0','0','699','http://flash.7k7k.com/fl_2/84631556271.swf','˵ӭӣ','ShowGood','','1174318662');
INSERT INTO `p8_flash_swf` VALUES ('3602','20','籭5','ϵ','0','','0','9030','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic366.gif','1','1','','0','0','0','','','','','','','','0','0','','2757','0','','','','0','0','0','883','http://flash.7k7k.com/fl_2/39624559878.swf','˵ӭӣ','ShowGood','','1174318668');
INSERT INTO `p8_flash_swf` VALUES ('3603','20','籭6','ϵ','0','','0','9958','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic367.gif','1','1','','0','0','0','','','','','','','','0','0','','2758','0','','','','0','0','0','835','http://flash.7k7k.com/fl_2/41396647691.swf','籭&lt;6&gt;,ʱȻ̫ա','ShowGood','','1174318666');
INSERT INTO `p8_flash_swf` VALUES ('3604','20','籭7','ϵ','0','','0','641','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic368.gif','1','1','','0','0','0','','','','','','','','0','0','','2759','0','','','','0','0','0','975','http://flash.7k7k.com/fl_2/50428223609.swf','˵ӭӣ','ShowGood','','1174351851');
INSERT INTO `p8_flash_swf` VALUES ('3605','20','̨綯','ϵ','0','','0','7334','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic369.gif','1','1','','0','0','0','','','','','','','','0','0','','2760','0','','','','0','0','0','310','http://flash.7k7k.com/fl_2/74818176030.swf','˵ӭӣ','ShowGood','','1174076109');
INSERT INTO `p8_flash_swf` VALUES ('3606','20','ʧ','ϵ','0','','0','7206','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic370.gif','1','1','','0','0','0','','','','','','','','0','0','','2761','0','','','','0','0','0','429','http://flash.7k7k.com/fl_2/26575076579.swf','˵ӭӣ','ShowGood','','1218695076');
INSERT INTO `p8_flash_swf` VALUES ('3607','20','ڿͶ','ϵ','0','','0','7445','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic371.gif','1','1','','0','0','0','','','','','','','','0','0','','2762','0','','','','0','0','0','803','http://flash.7k7k.com/fl_2/96231132744.swf','˵ӭӣ','ShowGood','','1174351144');
INSERT INTO `p8_flash_swf` VALUES ('3608','20','Էٶ','ϵ','0','','0','1632','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic372.gif','1','1','','0','0','0','','','','','','','','0','0','','2763','0','','','','0','0','0','361','http://flash.7k7k.com/fl_2/43348169326.swf','˵ӭӣ','ShowGood','','1177931613');
INSERT INTO `p8_flash_swf` VALUES ('3609','20','Σ','ϵ','0','','0','9563','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic373.gif','1','1','','0','0','0','','','','','','','','0','0','','2764','0','','','','0','0','0','284','http://flash.7k7k.com/fl_2/32862538098.swf','˵ӭӣ','ShowGood','','1174355145');
INSERT INTO `p8_flash_swf` VALUES ('3610','20','𶯻','ϵ','0','','0','1594','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic374.gif','1','1','','0','0','0','','','','','','','','0','0','','2765','0','','','','0','0','0','349','http://flash.7k7k.com/fl_2/54825413226.swf','˵ӭӣ','ShowGood','','1174355155');
INSERT INTO `p8_flash_swf` VALUES ('3611','20','Ӿ','ϵ','0','','0','4068','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic375.gif','1','1','','0','0','0','','','','','','','','0','0','','2766','0','','','','0','0','0','174','http://flash.7k7k.com/fl_2/73211079835.swf','˵ӭӣ','ShowGood','','1174367907');
INSERT INTO `p8_flash_swf` VALUES ('3612','20','ԼԴ','ϵ','0','','0','6858','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic376.gif','1','1','','0','0','0','','','','','','','','0','0','','2767','0','','','','0','0','0','364','http://flash.7k7k.com/fl_2/63307070731.swf','˵ӭӣ','ShowGood','','1174355149');
INSERT INTO `p8_flash_swf` VALUES ('3613','20','ζ','ϵ','0','','0','9568','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic377.gif','1','1','','0','0','0','','','','','','','','0','0','','2768','0','','','','0','0','0','420','http://flash.7k7k.com/fl_2/38272088765.swf','˵ӭӣ','ShowGood','','1174339550');
INSERT INTO `p8_flash_swf` VALUES ('3614','20','߶','ϵ','0','','0','6931','1','1065888000','1065888000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_2.pic/7k7k_flash_pic378.gif','1','1','','0','0','0','','','','','','','','0','0','','2769','0','','','','0','0','0','250','http://flash.7k7k.com/fl_2/71093404292.swf','˵ӭӣ','ShowGood','','1174292826');
INSERT INTO `p8_flash_swf` VALUES ('5162','4','3´Ѩ','ЦĬ','0','','0','1046','1','1085932800','1085932800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1075.gif','1','1','','0','0','0','','','','','','','','0','0','','4322','0','','','','0','0','0','1531','http://flash.7k7k.com/fl_3/7k7k_flash1075.swf','ŷһܳסȥһ·ϻʲô״أŷ˳ĻסŹۿ3´Ѩ','','','1173746123');
INSERT INTO `p8_flash_swf` VALUES ('5163','4','Ц˵̨ϵһ','ЦĬ','0','','0','629','1','1085932800','1085932800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1076.gif','1','1','','0','0','0','','','','','','','','0','0','','4323','0','','','','0','0','0','491','http://flash.7k7k.com/fl_3/7k7k_flash1076.swf','йֻһ','𶯻','','1173887822');
INSERT INTO `p8_flash_swf` VALUES ('5171','4','ȵ8֮²¼ ','ЦĬ','0','','0','7970','1','1086019200','1086019200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1080.gif','1','1','','0','0','0','','','','','','','','0','0','','4331','0','','','','0','0','0','1095','http://flash.7k7k.com/fl_3/7k7k_flash1080.swf','˵ӭӣ','TX','','1174175651');
INSERT INTO `p8_flash_swf` VALUES ('5172','4','FLASH̸2','ЦĬ','0','','0','5882','1','1086019200','1086019200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1081.gif','1','1','','0','0','0','','','','','','','','0','0','','4332','0','','','','0','0','0','5144','http://flash.7k7k.com/fl_3/7k7k_flash1081.swf','˵ӭӣ','TX','','1174360754');
INSERT INTO `p8_flash_swf` VALUES ('5173','4','ɳɮռNo.1','ЦĬ','0','','0','298','1','1086019200','1086019200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash1082.gif','1','1','','0','0','0','','','','','','','','0','0','','4333','0','','','','0','0','0','905','http://flash.7k7k.com/fl_3/7k7k_flash1082.swf','˵ӭӣ','','','1174104770');
INSERT INTO `p8_flash_swf` VALUES ('5178','4','Ц弯','ЦĬ','0','','0','4440','1','1086019200','1086019200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1084.gif','1','1','','0','0','0','','','','','','','','0','0','','4338','0','','','','0','0','0','3310','http://flash.7k7k.com/fl_3/7k7k_flash1084.swf','˵ӭӣ','Ӱ','','1173931736');
INSERT INTO `p8_flash_swf` VALUES ('5183','4','Цļ','ЦĬ','0','','0','6432','1','1086105600','1086105600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1085.gif','1','1','','0','0','0','','','','','','','','0','0','','4343','0','','','','0','0','0','6333','http://flash.7k7k.com/fl_3/7k7k_flash1085.swf','˵ӭӣ','Ӱ','','1174219466');
INSERT INTO `p8_flash_swf` VALUES ('5184','4','Ц','ЦĬ','0','','0','8268','1','1086105600','1086105600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1086.gif','1','1','','0','0','0','','','','','','','','0','0','','4344','0','','','','0','0','0','5904','http://flash.7k7k.com/fl_3/7k7k_flash1086.swf','˵ӭӣ','Ӱ','','1174118486');
INSERT INTO `p8_flash_swf` VALUES ('5185','4','Цڶ','ЦĬ','0','','0','2545','1','1086105600','1086105600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1087.gif','1','1','','0','0','0','','','','','','','','0','0','','4345','0','','','','0','0','0','7310','http://flash.7k7k.com/fl_3/7k7k_flash1087.swf','˵ӭӣ','Ӱ','','1173656155');
INSERT INTO `p8_flash_swf` VALUES ('5187','4','Цһ','ЦĬ','0','','0','3327','1','1086105600','1086105600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1088.gif','1','1','','0','0','0','','','','','','','','0','0','','4347','0','','','','0','0','0','7107','http://flash.7k7k.com/fl_3/7k7k_flash1088.swf','˵ӭӣ','Ӱ','','1173816094');
INSERT INTO `p8_flash_swf` VALUES ('5188','4','ˮ´--ڿ㶯','ЦĬ','0','','0','3306','1','1086105600','1086105600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1089.gif','1','1','','0','0','0','','','','','','','','0','0','','4348','0','','','','0','0','0','2759','http://flash.7k7k.com/fl_3/7k7k_flash1089.swf','˵ӭӣ','Ӱ','','1174149227');
INSERT INTO `p8_flash_swf` VALUES ('5190','4','ˮ´-˺޾ڶ','ЦĬ','0','','0','5223','1','1086105600','1086105600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1090.gif','1','1','','0','0','0','','','','','','','','0','0','','4350','0','','','','0','0','0','2781','http://flash.7k7k.com/fl_3/7k7k_flash1090.swf','˵ӭӣ','Ӱ','','1174269186');
INSERT INTO `p8_flash_swf` VALUES ('5191','4','ˮ´-νһ춯','ЦĬ','0','','0','4662','1','1086105600','1086105600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1091.gif','1','1','','0','0','0','','','','','','','','0','0','','4351','0','','','','0','0','0','2404','http://flash.7k7k.com/fl_3/7k7k_flash1091.swf','˵ӭӣ','Ӱ','','1174379991');
INSERT INTO `p8_flash_swf` VALUES ('5192','4','ˮ´-Ķ','ЦĬ','0','','0','1593','1','1086105600','1086105600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1092.gif','1','1','','0','0','0','','','','','','','','0','0','','4352','0','','','','0','0','0','3334','http://flash.7k7k.com/fl_3/7k7k_flash1092.swf','˵ӭӣ','Ӱ','','1174307154');
INSERT INTO `p8_flash_swf` VALUES ('5193','4','ˮ´-ͽͶ','ЦĬ','0','','0','5446','1','1086105600','1086105600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1093.gif','1','1','','0','0','0','','','','','','','','0','0','','4353','0','','','','0','0','0','2570','http://flash.7k7k.com/fl_3/7k7k_flash1093.swf','˵ӭӣ','Ӱ','','1174310770');
INSERT INTO `p8_flash_swf` VALUES ('5224','5','Ե','ͯ','0','','0','7846','2','1085932800','1085932800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1096.gif','1','1','','0','0','0','','','','','','','','0','0','','4384','0','','','','0','0','0','2546','http://flash.7k7k.com/fl_3/7k7k_flash1096.swf','ЦĻҹĹ','ɫ','','1218687842');
INSERT INTO `p8_flash_swf` VALUES ('5228','4','ҹ鶯','ЦĬ','0','','0','8916','1','1085932800','1085932800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1100.gif','1','1','','0','0','0','','','','','','','','0','0','','4388','0','','','','0','0','0','1354','http://flash.7k7k.com/fl_3/7k7k_flash1100.swf','ͨʱѣʱ̫򵥡','ʰ','','1173726778');
INSERT INTO `p8_flash_swf` VALUES ('5236','4','ֶ˵Ƭζ','ЦĬ','0','','0','8679','1','1085932800','1085932800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1108.gif','1','1','','0','0','0','','','','','','','','0','0','','4396','0','','','','0','0','0','1416','http://flash.7k7k.com/fl_3/7k7k_flash1108.swf','俨ͨжԱ͸','俨ͨ','','1174269093');
INSERT INTO `p8_flash_swf` VALUES ('5237','4','Ӣ۾','ЦĬ','0','','0','4714','1','1085932800','1085932800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1109.gif','1','1','','0','0','0','','','','','','','','0','0','','4397','0','','','','0','0','0','137','http://flash.7k7k.com/fl_3/7k7k_flash1109.swf','Ҷ','','','1174220468');
INSERT INTO `p8_flash_swf` VALUES ('5238','4','ʱȶ','ЦĬ','0','','0','2199','1','1085932800','1085932800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1110.gif','1','1','','0','0','0','','','','','','','','0','0','','4398','0','','','','0','0','0','1517','http://flash.7k7k.com/fl_3/7k7k_flash1110.swf','дַɲҪְʱŶ','Silbo','','1174020141');
INSERT INTO `p8_flash_swf` VALUES ('5240','4','Ŷ','ЦĬ','0','','0','6729','1','1085932800','1085932800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1112.gif','1','1','','0','0','0','','','','','','','','0','0','','4400','0','','','','0','0','0','1766','http://flash.7k7k.com/fl_3/7k7k_flash1112.swf','Ǻ~Ϊ263FLASH ~~Ҷָ̰~~','޵ɵŮ','','1173883215');
INSERT INTO `p8_flash_swf` VALUES ('5241','4','Ц˵̨ϵж֮','ЦĬ','0','','0','3384','1','1085932800','1085932800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1113.gif','1','1','','0','0','0','','','','','','','','0','0','','4401','0','','','','0','0','0','431','http://flash.7k7k.com/fl_3/7k7k_flash1113.swf','йֻһ','𶯻','','1174349265');
INSERT INTO `p8_flash_swf` VALUES ('5242','4','ڤƪ һ','ЦĬ','0','','0','4891','1','1085932800','1085932800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1114.gif','1','1','','0','0','0','','','','','','','','0','0','','4402','0','','','','0','0','0','4527','http://flash.7k7k.com/fl_3/7k7k_flash1114.swf','벻֪ڤƪࣿ˾֪','ŵ˹','','1174387057');
INSERT INTO `p8_flash_swf` VALUES ('5251','5','ҹ-ѾѾϵо֮ͯ','ͯ','0','','0','4184','1','1086969600','1086969600','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1115.gif','1','1','','0','0','0','','','','','','','','0','0','','4411','0','','','','0','0','0','3191','http://flash.7k7k.com/fl_3/7k7k_flash1115.swf','͸ǵƷҲϣϲ','ѾѾ','','1174225062');
INSERT INTO `p8_flash_swf` VALUES ('5253','4','šBaBy ','ЦĬ','0','','0','9416','1','0','0','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1117.gif','1','1','','0','0','0','','','','','','','','0','0','','4413','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1117.swf','','','','1173907450');
INSERT INTO `p8_flash_swf` VALUES ('5256','4','ңԤƬ','ЦĬ','0','','0','2819','1','0','0','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1120.gif','1','1','','0','0','0','','','','','','','','0','0','','4416','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1120.swf','','','','1174243015');
INSERT INTO `p8_flash_swf` VALUES ('5268','4','FLASH̸3','ЦĬ','0','','0','3196','1','1088438400','1088438400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1128.gif','1','1','','0','0','0','','','','','','','','0','0','','4428','0','','','','0','0','0','6541','http://flash.7k7k.com/fl_3/7k7k_flash1128.swf','!!!flash̸ʲôأ!263ľƷѽ֪еһЩ뿴BOBOķȤ!&nbsp;','TX19820722','','1174331893');
INSERT INTO `p8_flash_swf` VALUES ('5269','5','3','ͯ','0','','0','2573','1','1088438400','1088438400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1129.gif','1','1','','0','0','0','','','','','','','','0','0','','4429','0','','','','0','0','0','6480','http://flash.7k7k.com/fl_3/7k7k_flash1129.swf','ˣǺǣҸ................','X','','1174023959');
INSERT INTO `p8_flash_swf` VALUES ('5275','4','Сγ','ЦĬ','0','','0','7105','1','1070640000','1070640000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1202.gif','1','1','','0','0','0','','','','','','','','0','0','','4435','0','','','','0','0','0','7098','http://flash.7k7k.com/fl_3/7k7k_flash1202.swf','СγԭFlash,ǵڶƷ,1µŻѪ,СγڲǺ˳ˣҺÿƳ汾ϣһϲллСγ֧֣Ϲ!','KRYANT','','1174231556');
INSERT INTO `p8_flash_swf` VALUES ('5277','5','˽˵ڶ','ͯ','0','','0','3549','1','1070640000','1070640000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1204.gif','1','1','','0','0','0','','','','','','','','0','0','','4437','0','','','','0','0','0','7190','http://flash.7k7k.com/fl_3/7k7k_flash1204.swf','ڶ','Ӱ','','1174137091');
INSERT INTO `p8_flash_swf` VALUES ('5278','4','CS֮ն','ЦĬ','0','','0','5450','1','1070640000','1070640000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1205.gif','1','1','','0','0','0','','','','','','','','0','0','','4438','0','','','','0','0','0','1174','http://flash.7k7k.com/fl_3/7k7k_flash1205.swf','Ϊʲô˻ôأԻ벻','ϵ','','1173723561');
INSERT INTO `p8_flash_swf` VALUES ('5317','4','ħ޹£һ','ЦĬ','0','','0','2596','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1274.gif','1','1','','0','0','0','','','','','','','','0','0','','4477','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1274.swf','','','','1173652427');
INSERT INTO `p8_flash_swf` VALUES ('5324','4','εһƬ','ЦĬ','0','','0','7171','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1281.gif','1','1','','0','0','0','','','','','','','','0','0','','4484','0','','','','0','0','0','5618','http://flash.7k7k.com/fl_3/7k7k_flash1281.swf','һĩӿһػԹѩٶšϰĳ½ϣػᡣܿ죬ػ100򣬶ǵҲˡ','www.kootv.com','','1174331898');
INSERT INTO `p8_flash_swf` VALUES ('5337','5','ܴ','ͯ','0','','0','2073','1','1088784000','1088784000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1130.gif','1','1','','0','0','0','','','','','','','','0','0','','4497','0','','','','0','0','0','3426','http://flash.7k7k.com/fl_3/7k7k_flash1130.swf','ܴ署ľһ---- Լ˾֪','www.tantracn.com','','1174350794');
INSERT INTO `p8_flash_swf` VALUES ('5373','4','־֮ټն','ЦĬ','0','','0','9876','1','1089129600','1089129600','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1133.gif','1','1','','0','0','0','','','','','','','','0','0','','4533','0','','','','0','0','0','498','http://flash.7k7k.com/fl_3/7k7k_flash1133.swf','ЦЦ㣡','','','1174393592');
INSERT INTO `p8_flash_swf` VALUES ('5374','5','־','ͯ','0','','0','1291','1','1089129600','1089129600','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1134.gif','1','1','','0','0','0','','','','','','','','0','0','','4534','0','','','','0','0','0','2721','http://flash.7k7k.com/fl_3/7k7k_flash1134.swf','ؼʣס̽ա2004ŷޱ','ңգ','','1174269044');
INSERT INTO `p8_flash_swf` VALUES ('5376','4','ڤƪڶԤƬ','ЦĬ','0','','0','3840','1','1089129600','1089129600','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1136.gif','1','1','','0','0','0','','','','','','','','0','0','','4536','0','','','','0','0','0','792','http://flash.7k7k.com/fl_3/7k7k_flash1136.swf','¶ڤƪ','ŵ˹','','1174193024');
INSERT INTO `p8_flash_swf` VALUES ('5379','5','~memory򶯻','ͯ','0','','0','858','1','1089129600','1089129600','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1139.gif','1','1','','0','0','0','','','','','','','','0','0','','4539','0','','','','0','0','0','2996','http://flash.7k7k.com/fl_3/7k7k_flash1139.swf','ϣϲ','Ӱ','','1174191223');
INSERT INTO `p8_flash_swf` VALUES ('5380','4','¾Ŷ','ЦĬ','0','','0','2934','1','1089129600','1089129600','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1140.gif','1','1','','0','0','0','','','','','','','','0','0','','4540','0','','','','0','0','0','3460','http://flash.7k7k.com/fl_3/7k7k_flash1140.swf','¾Źڶһ','ΪΪ','','1174121919');
INSERT INTO `p8_flash_swf` VALUES ('5396','4','ȵ⴫֮ȳһ嶯','ЦĬ','0','','0','8787','1','1089648000','1089648000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1144.gif','1','1','','0','0','0','','','','','','','','0','0','','4556','0','','','','0','0','0','1403','http://flash.7k7k.com/fl_3/7k7k_flash1144.swf','ССǿոչ³ȴùBOBOССǿ³ǰδеΣأעȳһ塷','TX','','1173932925');
INSERT INTO `p8_flash_swf` VALUES ('5397','5','뾫鶯','ͯ','0','','0','1432','1','0','0','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1145.gif','1','1','','0','0','0','','','','','','','','0','0','','4557','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1145.swf','','','','1174310803');
INSERT INTO `p8_flash_swf` VALUES ('5399','4','cs˾ѵĹ¶','ЦĬ','0','','0','2160','1','1089648000','1089648000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1147.gif','1','1','','0','0','0','','','','','','','','0','0','','4559','0','','','','0','0','0','1505','http://flash.7k7k.com/fl_3/7k7k_flash1147.swf','ܲ˵ƷϣǱЦŶ','¶ĺ','','1174312560');
INSERT INTO `p8_flash_swf` VALUES ('5425','4','ڤƪڶ','ЦĬ','0','','0','3315','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1149.gif','1','1','','0','0','0','','','','','','','','0','0','','4585','0','','','','0','0','0','2878','http://flash.7k7k.com/fl_3/7k7k_flash1149.swf','¶ڤƪ','ŵ˹','','1174028975');
INSERT INTO `p8_flash_swf` VALUES ('5426','4','','ЦĬ','0','','0','1470','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1150.gif','1','1','','0','0','0','','','','','','','','0','0','','4586','0','','','','0','0','0','6283','http://flash.7k7k.com/fl_3/7k7k_flash1150.swf','ƬǡСƺϵжƪĵ,ܵʮӭһҪɫҹصӹһӰļȮͻաСѾջӭһңǻǸ','ʰ','','1174145500');
INSERT INTO `p8_flash_swf` VALUES ('5427','5','԰','ͯ','0','','0','6331','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1151.gif','1','1','','0','0','0','','','','','','','','0','0','','4587','0','','','','0','0','0','9166','http://flash.7k7k.com/fl_3/7k7k_flash1151.swf','һĳ٣˰СuuƤƤ׷ѰԾǻǱѰҵ˳ഺֵ԰','windway','','1173842353');
INSERT INTO `p8_flash_swf` VALUES ('5428','4','ҵĲ-ҵ˽1 ','ЦĬ','0','','0','7066','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1152.gif','1','1','','0','0','0','','','','','','','','0','0','','4588','0','','','','0','0','0','371','http://flash.7k7k.com/fl_3/7k7k_flash1152.swf','ҵĲϵУҵ˽ڣ1','douglas-lee','','1174386523');
INSERT INTO `p8_flash_swf` VALUES ('5429','4','ҵĲ-ҵ˽2','ЦĬ','0','','0','8019','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1153.gif','1','1','','0','0','0','','','','','','','','0','0','','4589','0','','','','0','0','0','387','http://flash.7k7k.com/fl_3/7k7k_flash1153.swf','ҵĲϵУҵ˽ڣ2','douglas-lee','','1174016928');
INSERT INTO `p8_flash_swf` VALUES ('5430','4','ҵĲ-ҵ˽3','ЦĬ','0','','0','1982','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1154.gif','1','1','','0','0','0','','','','','','','','0','0','','4590','0','','','','0','0','0','479','http://flash.7k7k.com/fl_3/7k7k_flash1154.swf','ҵĲϵУҵ˽ڣ3','douglas-lee','','1173748721');
INSERT INTO `p8_flash_swf` VALUES ('5431','4','-001ټƪСϷ','ЦĬ','0','','0','9295','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1155.gif','1','1','','0','0','0','','','','','','','','0','0','','4591','0','','','','0','0','0','429','http://flash.7k7k.com/fl_3/7k7k_flash1155.swf','½ϵж','׿','','1173720174');
INSERT INTO `p8_flash_swf` VALUES ('5432','4','ҵĲ-ҵĶͯ1','ЦĬ','0','','0','4174','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1156.gif','1','1','','0','0','0','','','','','','','','0','0','','4592','0','','','','0','0','0','440','http://flash.7k7k.com/fl_3/7k7k_flash1156.swf','ҵĲϵУҵĶͯڣ1','douglas-lee','','1174207525');
INSERT INTO `p8_flash_swf` VALUES ('5433','4','ҵĲ-ҵĶͯ2','ЦĬ','0','','0','4500','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1157.gif','1','1','','0','0','0','','','','','','','','0','0','','4593','0','','','','0','0','0','413','http://flash.7k7k.com/fl_3/7k7k_flash1157.swf','ҵĲϵУҵĶͯڣ2','douglas-lee','','1174242180');
INSERT INTO `p8_flash_swf` VALUES ('5434','4','ҵĲ-ҵCool Game1 ','ЦĬ','0','','0','6242','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1158.gif','1','1','','0','0','0','','','','','','','','0','0','','4594','0','','','','0','0','0','549','http://flash.7k7k.com/fl_3/7k7k_flash1158.swf','ҵĲϵУҵCool Game1','douglas-lee','','1174228451');
INSERT INTO `p8_flash_swf` VALUES ('5435','4','ҵĲ-ҵCool Game2','ЦĬ','0','','0','8888','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1159.gif','1','1','','0','0','0','','','','','','','','0','0','','4595','0','','','','0','0','0','543','http://flash.7k7k.com/fl_3/7k7k_flash1159.swf','ҵĲϵУҵCool Game2','douglas-lee','','1174352247');
INSERT INTO `p8_flash_swf` VALUES ('5436','4','ҵĲ-ҵCool Game3','ЦĬ','0','','0','2990','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1160.gif','1','1','','0','0','0','','','','','','','','0','0','','4596','0','','','','0','0','0','657','http://flash.7k7k.com/fl_3/7k7k_flash1160.swf','ҵĲϵУҵCool Game3','douglas-lee','','1174021198');
INSERT INTO `p8_flash_swf` VALUES ('5438','4','йС¶','ЦĬ','0','','0','8917','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1162.gif','1','1','','0','0','0','','','','','','','','0','0','','4598','0','','','','0','0','0','6529','http://flash.7k7k.com/fl_3/7k7k_flash1162.swf','Сй棡߸ͳͷʽЦף','wwwcdd','','1174207752');
INSERT INTO `p8_flash_swf` VALUES ('5439','4','-002ƺݳƪ','ЦĬ','0','','0','6047','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1163.gif','1','1','','0','0','0','','','','','','','','0','0','','4599','0','','','','0','0','0','368','http://flash.7k7k.com/fl_3/7k7k_flash1163.swf','&nbsp;ɰͣȤڣǺʱӰɡ','','','1174382664');
INSERT INTO `p8_flash_swf` VALUES ('5440','4','èGOGO(1)ҳ߶','ЦĬ','0','','0','5694','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1164.gif','1','1','','0','0','0','','','','','','','','0','0','','4600','0','','','','0','0','0','6665','http://flash.7k7k.com/fl_3/7k7k_flash1164.swf','˼Ļ붬ĵһƷèGOGO','˼Ļ','','1173808596');
INSERT INTO `p8_flash_swf` VALUES ('5441','4','ҡһ-I','ЦĬ','0','','0','1535','1','1090080000','1090080000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1165.gif','1','1','','0','0','0','','','','','','','','0','0','','4601','0','','','','0','0','0','6103','http://flash.7k7k.com/fl_3/7k7k_flash1165.swf','ǡҡһĵһ&nbsp;','칤','','1173484113');
INSERT INTO `p8_flash_swf` VALUES ('5478','4','-004ħһƪ','ЦĬ','0','','0','4898','1','1090684800','1090684800','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1170.gif','1','1','','0','0','0','','','','','','','','0','0','','4638','0','','','','0','0','0','859','http://flash.7k7k.com/fl_3/7k7k_flash1170.swf','ͷſɹ!','','','1173961064');
INSERT INTO `p8_flash_swf` VALUES ('5479','4','-005ƪ','ЦĬ','0','','0','4537','1','1090684800','1090684800','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1171.gif','1','1','','0','0','0','','','','','','','','0','0','','4639','0','','','','0','0','0','629','http://flash.7k7k.com/fl_3/7k7k_flash1171.swf','Ҫң࣬⣬','','','1174228289');
INSERT INTO `p8_flash_swf` VALUES ('5489','4','֮Ĺ','ЦĬ','0','','0','6817','1','1090771200','1090771200','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1176.gif','1','1','','0','0','0','','','','','','','','0','0','','4649','0','','','','0','0','0','678','http://flash.7k7k.com/fl_3/7k7k_flash1176.swf','֮Ĺÿܵ~~~~','ˬ','','1174379894');
INSERT INTO `p8_flash_swf` VALUES ('5527','4','(4)߰ʦ()','ЦĬ','0','','0','3208','1','1070294400','1070294400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1187.gif','1','1','','0','0','0','','','','','','','','0','0','','4687','0','','','','0','0','0','4047','http://flash.7k7k.com/fl_3/7k7k_flash1187.swf','ԼҲᱻɽ¡','˼','','1173672823');
INSERT INTO `p8_flash_swf` VALUES ('5528','4','-ػٶ','ЦĬ','0','','0','6013','1','0','0','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1188.gif','1','1','','0','0','0','','','','','','','','0','0','','4688','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1188.swf','','','','1174022855');
INSERT INTO `p8_flash_swf` VALUES ('5529','5','~memory󶯻','ͯ','0','','0','684','1','1070294400','1070294400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1189.gif','1','1','','0','0','0','','','','','','','','0','0','','4689','0','','','','0','0','0','2760','http://flash.7k7k.com/fl_3/7k7k_flash1189.swf','2Dȫƣвֻ֮ܶ','Ӱ','','1174230481');
INSERT INTO `p8_flash_swf` VALUES ('5532','4','-006Ϻڶ','ЦĬ','0','','0','1869','1','1070294400','1070294400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1181.gif','1','1','','0','0','0','','','','','','','','0','0','','4692','0','','','','0','0','0','1536','http://flash.7k7k.com/fl_3/7k7k_flash1181.swf','ǲMIB(Made in Black),ī,ԵǸ!','','','1173763581');
INSERT INTO `p8_flash_swf` VALUES ('5533','4','-޵ƪ','ЦĬ','0','','0','8773','1','1070294400','1070294400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1182.gif','1','1','','0','0','0','','','','','','','','0','0','','4693','0','','','','0','0','0','350','http://flash.7k7k.com/fl_3/7k7k_flash1182.swf','kakaˮȶˣһ֮һ£˭֪͵','','','1173644003');
INSERT INTO `p8_flash_swf` VALUES ('5535','4','涯','ЦĬ','0','','0','2762','1','1070294400','1070294400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1184.gif','1','1','','0','0','0','','','','','','','','0','0','','4695','0','','','','0','0','0','324','http://flash.7k7k.com/fl_3/7k7k_flash1184.swf','','hyuklove','','1173425948');
INSERT INTO `p8_flash_swf` VALUES ('5545','4','ҪӶ','ЦĬ','0','','0','8737','1','1070640000','1070640000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1190.gif','1','1','','0','0','0','','','','','','','','0','0','','4705','0','','','','0','0','0','261','http://flash.7k7k.com/fl_3/7k7k_flash1190.swf','ݼŵԭ','JPG','','1174352014');
INSERT INTO `p8_flash_swf` VALUES ('5547','5','ƽ','ͯ','0','','0','6934','1','1070640000','1070640000','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1192.gif','1','1','','0','0','0','','','','','','','','0','0','','4707','0','','','','0','0','0','5117','http://flash.7k7k.com/fl_3/7k7k_flash1192.swf','ν֮ƽ','','','1174149482');
INSERT INTO `p8_flash_swf` VALUES ('5585','4','ȵ̶','ЦĬ','0','','0','184','1','1071158400','1071158400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1207.gif','1','1','','0','0','0','','','','','','','','0','0','','4745','0','','','','0','0','0','881','http://flash.7k7k.com/fl_3/7k7k_flash1207.swf','ǧȫý飬ԱŮѧ̵ҪǷܹأ뿴һȵBOBO!&nbsp;','tx19820722','','1174380893');
INSERT INTO `p8_flash_swf` VALUES ('5586','4','粨','ЦĬ','0','','0','4763','1','0','0','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1208.gif','1','1','','0','0','0','','','','','','','','0','0','','4746','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1208.swf','','','','1173935060');
INSERT INTO `p8_flash_swf` VALUES ('5588','4','ʱ԰','ЦĬ','0','','0','9663','1','1071158400','1071158400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1210.gif','1','1','','0','0','0','','','','','','','','0','0','','4748','0','','','','0','0','0','3036','http://flash.7k7k.com/fl_3/7k7k_flash1210.swf','̩AD','whowho5','','1174278194');
INSERT INTO `p8_flash_swf` VALUES ('5589','4','˫(һ) ','ЦĬ','0','','0','7223','1','1071158400','1071158400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1211.gif','1','1','','0','0','0','','','','','','','','0','0','','4749','0','','','','0','0','0','7792','http://flash.7k7k.com/fl_3/7k7k_flash1211.swf','˫','e˶Ӱ','','1173723272');
INSERT INTO `p8_flash_swf` VALUES ('5590','4','ǽ','ЦĬ','0','','0','803','1','0','0','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1212.gif','1','1','','0','0','0','','','','','','','','0','0','','4750','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1212.swf','','','','1174219487');
INSERT INTO `p8_flash_swf` VALUES ('5595','4','-008ض','ЦĬ','0','','0','4428','1','1071158400','1071158400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1217.gif','1','1','','0','0','0','','','','','','','','0','0','','4755','0','','','','0','0','0','461','http://flash.7k7k.com/fl_3/7k7k_flash1217.swf','ɵҵ·','','','1173817174');
INSERT INTO `p8_flash_swf` VALUES ('5596','4','-009ʱƪ','ЦĬ','0','','0','1531','1','1071158400','1071158400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1218.gif','1','1','','0','0','0','','','','','','','','0','0','','4756','0','','','','0','0','0','755','http://flash.7k7k.com/fl_3/7k7k_flash1218.swf','LuluڷԾһɲǺ......','golden-octopus','','1174191191');
INSERT INTO `p8_flash_swf` VALUES ('5597','4','㶯','ЦĬ','0','','0','2587','1','1071158400','1071158400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1219.gif','1','1','','0','0','0','','','','','','','','0','0','','4757','0','','','','0','0','0','232','http://flash.7k7k.com/fl_3/7k7k_flash1219.swf','ԭ','JPG','','1173832880');
INSERT INTO `p8_flash_swf` VALUES ('5600','4','5Ƭ','ЦĬ','0','','0','3459','1','1071158400','1071158400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1222.gif','1','1','','0','0','0','','','','','','','','0','0','','4760','0','','','','0','0','0','354','http://flash.7k7k.com/fl_3/7k7k_flash1222.swf','5Ƭ','e-toon','','1174352041');
INSERT INTO `p8_flash_swf` VALUES ('5601','4','޹ɽ','ЦĬ','0','','0','2778','1','1071158400','1071158400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1223.gif','1','1','','0','0','0','','','','','','','','0','0','','4761','0','','','','0','0','0','614','http://flash.7k7k.com/fl_3/7k7k_flash1223.swf','޹ɽĹǲİ侫˸жⴴ','','','1174102249');
INSERT INTO `p8_flash_swf` VALUES ('5603','4','ߵ㹷','ЦĬ','0','','0','1914','1','1071158400','1071158400','0','','','0','http://www2.7k7k.net/7k7k2/fl_3.pic/7k7k_flash_pic1225.gif','1','1','','0','0','0','','','','','','','','0','0','','4763','0','','','','0','0','0','2027','http://flash.7k7k.com/fl_3/7k7k_flash1225.swf','СѶ!濴!!ƨƨ!!','˫˫','','1174350993');
INSERT INTO `p8_flash_swf` VALUES ('5680','4','ͷ֮Ƕ','ЦĬ','0','','0','6876','1','1071590400','1071590400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1237.gif','1','1','','0','0','0','','','','','','','','0','0','','4840','0','','','','0','0','0','514','http://flash.7k7k.com/fl_3/7k7k_flash1237.swf','˵ӭӣ','SAVE AS','','1173672646');
INSERT INTO `p8_flash_swf` VALUES ('5681','4','ˮȭ','ЦĬ','0','','0','7296','1','1071590400','1071590400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1238.gif','1','1','','0','0','0','','','','','','','','0','0','','4841','0','','','','0','0','0','6949','http://flash.7k7k.com/fl_3/7k7k_flash1238.swf','ˮںʹҼˣƷģѣѴˮ䰸ı֮࣬ϣܺԭȡϵˮ֮ȭ','','','1174354304');
INSERT INTO `p8_flash_swf` VALUES ('5682','4','÷ֹʶ','ЦĬ','0','','0','5760','1','1071590400','1071590400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1239.gif','1','1','','0','0','0','','','','','','','','0','0','','4842','0','','','','0','0','0','636','http://flash.7k7k.com/fl_3/7k7k_flash1239.swf','ϵ֮÷ֹʣppûʲô˵ģ','','','1174225325');
INSERT INTO `p8_flash_swf` VALUES ('5706','5','ףģ','ͯ','0','','0','6128','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1242.gif','1','1','','0','0','0','','','','','','','','0','0','','4866','0','','','','0','0','0','8400','http://flash.7k7k.com/fl_3/7k7k_flash1242.swf','׵ĻλֵܱŮ,ںĵ.裬ά ȥأ񻷺С׻ô','','','1174344302');
INSERT INTO `p8_flash_swf` VALUES ('5707','5','-ƪ','ͯ','0','','0','8094','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1243.gif','1','1','','0','0','0','','','','','','','','0','0','','4867','0','','','','0','0','0','570','http://flash.7k7k.com/fl_3/7k7k_flash1243.swf','࣭010ƪôõĳܿܣе⡣','','','1174275269');
INSERT INTO `p8_flash_swf` VALUES ('5708','5','-ƪ','ͯ','0','','0','7683','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1244.gif','1','1','','0','0','0','','','','','','','','0','0','','4868','0','','','','0','0','0','1011','http://flash.7k7k.com/fl_3/7k7k_flash1244.swf','-011ƪȭͷ˵С','','','1174167395');
INSERT INTO `p8_flash_swf` VALUES ('5709','5','궯','ͯ','0','','0','9103','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1245.gif','1','1','','0','0','0','','','','','','','','0','0','','4869','0','','','','0','0','0','1025','http://flash.7k7k.com/fl_3/7k7k_flash1245.swf','˵ӭӣ','','','1174208889');
INSERT INTO `p8_flash_swf` VALUES ('5710','4','Ů','ЦĬ','0','','0','8088','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1246.gif','1','1','','0','0','0','','','','','','','','0','0','','4870','0','','','','0','0','0','521','http://flash.7k7k.com/fl_3/7k7k_flash1246.swf','Ů(Ц)ĸ裬ܺһ׸裡','Ȼ','','1173812645');
INSERT INTO `p8_flash_swf` VALUES ('5711','4','ӯ¹Ǣ񶯻','ЦĬ','0','','0','8594','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1247.gif','1','1','','0','0','0','','','','','','','','0','0','','4871','0','','','','0','0','0','2624','http://flash.7k7k.com/fl_3/7k7k_flash1247.swf','·ڿ䣬λ˳λʵ֮ʱگĴ󳼸Ϊ׺ᣬеڣ͢Ȩһ֮֡״ͻΤС֮ϧһд۲','Ц','','1174192966');
INSERT INTO `p8_flash_swf` VALUES ('5712','4','','ЦĬ','0','','0','6548','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1248.gif','1','1','','0','0','0','','','','','','','','0','0','','4872','0','','','','0','0','0','599','http://flash.7k7k.com/fl_3/7k7k_flash1248.swf','͵̨Ʒʱ2','ɫ','','1173728775');
INSERT INTO `p8_flash_swf` VALUES ('5713','4','Ĺ¶','ЦĬ','0','','0','7168','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1249.gif','1','1','','0','0','0','','','','','','','','0','0','','4873','0','','','','0','0','0','603','http://flash.7k7k.com/fl_3/7k7k_flash1249.swf','ͬǺ͵̨ƷȡԱ ʱ2.5','ɫ','','1174202111');
INSERT INTO `p8_flash_swf` VALUES ('5714','5','-ֻƪ','ͯ','0','','0','6928','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1250.gif','1','1','','0','0','0','','','','','','','','0','0','','4874','0','','','','0','0','0','559','http://flash.7k7k.com/fl_3/7k7k_flash1250.swf','-012ֻƪǾĿ׷MM,ڳɹ.ֻʱϵ','','','1174204570');
INSERT INTO `p8_flash_swf` VALUES ('5743','5','ˮԤƬ','ͯ','0','','0','2307','1','1072627200','1072627200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1268.gif','1','1','','0','0','0','','','','','','','','0','0','','4903','0','','','','0','0','0','1559','http://flash.7k7k.com/fl_3/7k7k_flash1268.swf','񶯻Ʒ','񶯻','','1173757956');
INSERT INTO `p8_flash_swf` VALUES ('5763','4','Ц˵̨ϵж֮','ЦĬ','0','','0','886','1','1070380800','1070380800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1271.gif','1','1','','0','0','0','','','','','','','','0','0','','4925','0','','','','0','0','0','357','http://flash.7k7k.com/fl_3/7k7k_flash1271.swf','йֻһ','𶯻','','1174346076');
INSERT INTO `p8_flash_swf` VALUES ('5791','4','-014Ϳѻ','ЦĬ','0','','0','2378','1','1071590400','1071590400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1283.gif','1','1','','0','0','0','','','','','','','','0','0','','4953','0','','','','0','0','0','591','http://flash.7k7k.com/fl_3/7k7k_flash1283.swf','ǽļ׿˳һֻ󹷡ˣ','','','1173807272');
INSERT INTO `p8_flash_swf` VALUES ('5792','5','88·깫','ͯ','0','','0','1529','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1284.gif','1','1','','0','0','0','','','','','','','','0','0','','4954','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1284.swf','','','','1174336531');
INSERT INTO `p8_flash_swf` VALUES ('5794','4','϶Ҳ񶯻','ЦĬ','0','','0','6852','1','1071676800','1071676800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1286.gif','1','1','','0','0','0','','','','','','','','0','0','','4956','0','','','','0','0','0','458','http://flash.7k7k.com/fl_3/7k7k_flash1286.swf','ڿŶ϶żԲ㣬㻭̫ˡ','ţڼ','','1173828185');
INSERT INTO `p8_flash_swf` VALUES ('5795','4','̨̨¶','ЦĬ','0','','0','1927','1','1071676800','1071676800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1287.gif','1','1','','0','0','0','','','','','','','','0','0','','4957','0','','','','0','0','0','1083','http://flash.7k7k.com/fl_3/7k7k_flash1287.swf','Ʒ','','','1174190554');
INSERT INTO `p8_flash_swf` VALUES ('5796','4','2','ЦĬ','0','','0','6082','1','1071676800','1071676800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1288.gif','1','1','','0','0','0','','','','','','','','0','0','','4958','0','','','','0','0','0','556','http://flash.7k7k.com/fl_3/7k7k_flash1288.swf','ǰһɵܵشΣʱ................','Memphis','','1174037483');
INSERT INTO `p8_flash_swf` VALUES ('5798','5','Сƺδ','ͯ','0','','0','2466','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1290.gif','1','1','','0','0','0','','','','','','','','0','0','','4960','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1290.swf','','','','1174376585');
INSERT INTO `p8_flash_swf` VALUES ('5816','5','»ҹﶯ','ͯ','0','','0','4074','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1294.gif','1','1','','0','0','0','','','','','','','','0','0','','4978','0','','','','0','0','0','2311','http://flash.7k7k.com/fl_3/7k7k_flash1294.swf','ҹС֦Ĵ','ɫ','','1174281620');
INSERT INTO `p8_flash_swf` VALUES ('5817','4','ܣܣܣ','ЦĬ','0','','0','1718','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1295.gif','1','1','','0','0','0','','','','','','','','0','0','','4979','0','','','','0','0','0','767','http://flash.7k7k.com/fl_3/7k7k_flash1295.swf','voit飡󵨣󣡣voitԶȥӵߣϿʱ䲻û˺ܶݣϣӰӾ^~^','zzjxb','','1174140855');
INSERT INTO `p8_flash_swf` VALUES ('5820','4','ڤƪ  ԤƬ','ЦĬ','0','','0','1000','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1298.gif','1','1','','0','0','0','','','','','','','','0','0','','4982','0','','','','0','0','0','1195','http://flash.7k7k.com/fl_3/7k7k_flash1298.swf','˵ӭӣ','ŵ˹','','1173829180');
INSERT INTO `p8_flash_swf` VALUES ('5822','4','仨Ц','ЦĬ','0','','0','9739','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1300.gif','1','1','','0','0','0','','','','','','','','0','0','','4984','0','','','','0','0','0','908','http://flash.7k7k.com/fl_3/7k7k_flash1300.swf','Цȿ޺......','հ','','1173804345');
INSERT INTO `p8_flash_swf` VALUES ('5825','4','ɫʾδ','ЦĬ','0','','0','10052','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1303.gif','1','1','','0','0','0','','','','','','','','0','0','','4987','0','','','','0','0','0','321','http://flash.7k7k.com/fl_3/7k7k_flash1303.swf','˵ӭӣ','NIX','','1174399383');
INSERT INTO `p8_flash_swf` VALUES ('5827','5','󰮼һó̡','ͯ','0','','0','6742','1','1072108800','1072108800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1305.gif','1','1','','0','0','0','','','','','','','','0','0','','4989','0','','','','0','0','0','2264','http://flash.7k7k.com/fl_3/7k7k_flash1305.swf','DDKͿִͯ','KING','','1174202167');
INSERT INTO `p8_flash_swf` VALUES ('5887','4','Ʈѩ','ЦĬ','0','','0','2860','1','1097078400','1097078400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1308.gif','1','1','','0','0','0','','','','','','','','0','0','','5051','0','','','','0','0','0','3120','http://flash.7k7k.com/fl_3/7k7k_flash1308.swf','ɰҰŮ','Ф','','1173805550');
INSERT INTO `p8_flash_swf` VALUES ('5892','5','ѩ˶','ͯ','0','','0','5280','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1313.gif','1','1','','0','0','0','','','','','','','','0','0','','5056','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1313.swf','','','','1174352185');
INSERT INTO `p8_flash_swf` VALUES ('5894','5','涯','ͯ','0','','0','2362','1','1097078400','1097078400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1315.gif','1','1','','0','0','0','','','','','','','','0','0','','5058','0','','','','0','0','0','2684','http://flash.7k7k.com/fl_3/7k7k_flash1315.swf','µϵġܵػٷıһֱల£һ......ȴǵģʲôˣд꣩','ľľ','','1174353446');
INSERT INTO `p8_flash_swf` VALUES ('5895','4','ڿ֣','ЦĬ','0','','0','1716','1','1097078400','1097078400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1316.gif','1','1','','0','0','0','','','','','','','','0','0','','5059','0','','','','0','0','0','713','http://flash.7k7k.com/fl_3/7k7k_flash1316.swf','ûʲô˵ģף֣','windway','','1173828244');
INSERT INTO `p8_flash_swf` VALUES ('5896','4','','ЦĬ','0','','0','130','1','1097078400','1097078400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1317.gif','1','1','','0','0','0','','','','','','','','0','0','','5060','0','','','','0','0','0','733','http://flash.7k7k.com/fl_3/7k7k_flash1317.swf','ĬЦƷ','ҡݮ','','1174241590');
INSERT INTO `p8_flash_swf` VALUES ('5898','4','ֶ֮','ЦĬ','0','','0','8717','1','1097078400','1097078400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1319.gif','1','1','','0','0','0','','','','','','','','0','0','','5062','0','','','','0','0','0','505','http://flash.7k7k.com/fl_3/7k7k_flash1319.swf','ݷƼ/йרףҽտ֡Ĳûԭ','躺','','1174094112');
INSERT INTO `p8_flash_swf` VALUES ('5900','4','ɵɵĶ','ЦĬ','0','','0','424','1','1097078400','1097078400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1321.gif','1','1','','0','0','0','','','','','','','','0','0','','5064','0','','','','0','0','0','2464','http://flash.7k7k.com/fl_3/7k7k_flash1321.swf','ײʶڶ½ͨ76ܴ飬αͷԣŷɣϧ','Ф','','1174077743');
INSERT INTO `p8_flash_swf` VALUES ('5901','5','ˮһ','ͯ','0','','0','9281','1','1097078400','1097078400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1322.gif','1','1','','0','0','0','','','','','','','','0','0','','5065','0','','','','0','0','0','6790','http://flash.7k7k.com/fl_3/7k7k_flash1322.swf','񶯻Ʒ','񶯻','','1174034547');
INSERT INTO `p8_flash_swf` VALUES ('5903','4','ɶض','ЦĬ','0','','0','7057','1','1097078400','1097078400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1324.gif','1','1','','0','0','0','','','','','','','','0','0','','5067','0','','','','0','0','0','1099','http://flash.7k7k.com/fl_3/7k7k_flash1324.swf','ţϵжףҹ֣&nbsp;','','','1174384642');
INSERT INTO `p8_flash_swf` VALUES ('5904','4','ڤƪ ','ЦĬ','0','','0','8372','1','1097078400','1097078400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1325.gif','1','1','','0','0','0','','','','','','','','0','0','','5068','0','','','','0','0','0','2574','http://flash.7k7k.com/fl_3/7k7k_flash1325.swf','˵ӭӣ','ŵ˹','','1174201235');
INSERT INTO `p8_flash_swf` VALUES ('5905','4','Ħǰ춯','ЦĬ','0','','0','5160','1','1097078400','1097078400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1326.gif','1','1','','0','0','0','','','','','','','','0','0','','5069','0','','','','0','0','0','965','http://flash.7k7k.com/fl_3/7k7k_flash1326.swf','󰸣ллۿ','zzjxb','','1173805966');
INSERT INTO `p8_flash_swf` VALUES ('5930','4','Ӣְ','ЦĬ','0','','0','1447','1','1097596800','1097596800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1332.gif','1','1','','0','0','0','','','','','','','','0','0','','5094','0','','','','0','0','0','973','http://flash.7k7k.com/fl_3/7k7k_flash1332.swf','գʱþ£Ц̸--깷','','','1174247184');
INSERT INTO `p8_flash_swf` VALUES ('5931','4','б','ЦĬ','0','','0','3209','1','1097596800','1097596800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1333.gif','1','1','','0','0','0','','','','','','','','0','0','','5095','0','','','','0','0','0','925','http://flash.7k7k.com/fl_3/7k7k_flash1333.swf','ǰ...','׳','','1174244327');
INSERT INTO `p8_flash_swf` VALUES ('5932','4','happyɭֶ','ЦĬ','0','','0','1517','1','1097596800','1097596800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1334.gif','1','1','','0','0','0','','','','','','','','0','0','','5096','0','','','','0','0','0','2068','http://flash.7k7k.com/fl_3/7k7k_flash1334.swf','ǰ...','׳','','1174392348');
INSERT INTO `p8_flash_swf` VALUES ('5934','5','̫ƽ  Ҷ','ͯ','0','','0','6077','1','1097596800','1097596800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1336.gif','1','1','','0','0','0','','','','','','','','0','0','','5098','0','','','','0','0','0','895','http://flash.7k7k.com/fl_3/7k7k_flash1336.swf','ǳ!!!!!ԸͬǻMMһʼˣ¾չ','','','1174272832');
INSERT INTO `p8_flash_swf` VALUES ('5935','4','־֮ӿᶯ','ЦĬ','0','','0','3266','1','1097596800','1097596800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1337.gif','1','1','','0','0','0','','','','','','','','0','0','','5099','0','','','','0','0','0','2955','http://flash.7k7k.com/fl_3/7k7k_flash1337.swf','ԽԽЦԽԽЦޣ','','','1173981712');
INSERT INTO `p8_flash_swf` VALUES ('5971','4','Ƕ','ЦĬ','0','','0','4713','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1338.gif','1','1','','0','0','0','','','','','','','','0','0','','5135','0','','','','0','0','0','550','http://flash.7k7k.com/fl_3/7k7k_flash1338.swf','һҪҽԺ','file','','1174031302');
INSERT INTO `p8_flash_swf` VALUES ('5972','4','-ݶ','ЦĬ','0','','0','6429','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1339.gif','1','1','','0','0','0','','','','','','','','0','0','','5136','0','','','','0','0','0','7882','http://flash.7k7k.com/fl_3/7k7k_flash1339.swf','ڷ·յй&quot;&quot;ת,ҪȥԿ...','GoQoo.Tv','','1174365216');
INSERT INTO `p8_flash_swf` VALUES ('5973','4','׷','ЦĬ','0','','0','3824','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1340.gif','1','1','','0','0','0','','','','','','','','0','0','','5137','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1340.swf','','','','1174207482');
INSERT INTO `p8_flash_swf` VALUES ('5974','4','ץסӾģ','ЦĬ','0','','0','341','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1341.gif','1','1','','0','0','0','','','','','','','','0','0','','5138','0','','','','0','0','0','3062','http://flash.7k7k.com/fl_3/7k7k_flash1341.swf','ǰϴû֣ڼˡɾԭģлл','yezhicheng04','','1173770827');
INSERT INTO `p8_flash_swf` VALUES ('5976','4','ʮЦٲ','ЦĬ','0','','0','5892','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1343.gif','1','1','','0','0','0','','','','','','','','0','0','','5140','0','','','','0','0','0','881','http://flash.7k7k.com/fl_3/7k7k_flash1343.swf','˵Ĺ£ԭ֭ԭζӢ﷢Ũס','','','1174225903');
INSERT INTO `p8_flash_swf` VALUES ('5977','4','ʺʫ','ЦĬ','0','','0','5781','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1344.gif','1','1','','0','0','0','','','','','','','','0','0','','5141','0','','','','0','0','0','362','http://flash.7k7k.com/fl_3/7k7k_flash1344.swf','Цһ,һ,,Ǻ,˳Ϊĳ˾δǵʽȨ·ǷǵƷĲͶ֤,Ҳù˾ѸϵǺĽ.ǽʹ÷ıǵȨ','Ф','','1174135884');
INSERT INTO `p8_flash_swf` VALUES ('5978','4','־֮','ЦĬ','0','','0','698','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1345.gif','1','1','','0','0','0','','','','','','','','0','0','','5142','0','','','','0','0','0','847','http://flash.7k7k.com/fl_3/7k7k_flash1345.swf','߿˾֪','','','1174320323');
INSERT INTO `p8_flash_swf` VALUES ('5980','4','ද--ħʦ','ЦĬ','0','','0','4553','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1347.gif','1','1','','0','0','0','','','','','','','','0','0','','5144','0','','','','0','0','0','451','http://flash.7k7k.com/fl_3/7k7k_flash1347.swf','ĬϵС','','','1174253305');
INSERT INTO `p8_flash_swf` VALUES ('5987','5','һϲͨ','ͯ','0','','0','6962','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1354.gif','1','1','','0','0','0','','','','','','','','0','0','','5151','0','','','','0','0','0','722','http://flash.7k7k.com/fl_3/7k7k_flash1354.swf','ɱȸɵĹ£ȡʵʷ¼Ӣ﷢','','','1174172086');
INSERT INTO `p8_flash_swf` VALUES ('5991','5','ͷһ','ͯ','0','','0','8761','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1358.gif','1','1','','0','0','0','','','','','','','','0','0','','5155','0','','','','0','0','0','7741','http://flash.7k7k.com/fl_3/7k7k_flash1358.swf','񶯻Ʒͷϵ','񶯻','','1174282637');
INSERT INTO `p8_flash_swf` VALUES ('5992','5','ө֮ɭ3- Ƭ','ͯ','0','','0','2607','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1359.gif','1','1','','0','0','0','','','','','','','','0','0','','5156','0','','','','0','0','0','618','http://flash.7k7k.com/fl_3/7k7k_flash1359.swf','ө֮ɭ3-Ҫˣ1030սϾڶ춯ӳƷôʱ䣬kusanbaλ˵Բkusanbaڶ̨NJ9ҵĽĿŶ^_^жȤɡ','kusanba','','1174321995');
INSERT INTO `p8_flash_swf` VALUES ('5993','4','˶','ЦĬ','0','','0','85','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1360.gif','1','1','','0','0','0','','','','','','','','0','0','','5157','0','','','','0','0','0','218','http://flash.7k7k.com/fl_3/7k7k_flash1360.swf','ˣСǺ£ŶHOHO','Ӱ','','1174247040');
INSERT INTO `p8_flash_swf` VALUES ('5996','4','ţɫ(һ) ','ЦĬ','0','','0','9928','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1363.gif','1','1','','0','0','0','','','','','','','','0','0','','5160','0','','','','0','0','0','1055','http://flash.7k7k.com/fl_3/7k7k_flash1363.swf','ţӭ','xmltq','','1173896431');
INSERT INTO `p8_flash_swf` VALUES ('5998','4','-㳵Ů ','ЦĬ','0','','0','9961','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1365.gif','1','1','','0','0','0','','','','','','','','0','0','','5162','0','','','','0','0','0','471','http://flash.7k7k.com/fl_3/7k7k_flash1365.swf','㳵Ůֻ','','','1174275797');
INSERT INTO `p8_flash_swf` VALUES ('6000','4','ܶ','ЦĬ','0','','0','7418','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1367.gif','1','1','','0','0','0','','','','','','','','0','0','','5164','0','','','','0','0','0','1362','http://flash.7k7k.com/fl_3/7k7k_flash1367.swf','-----------㸶Խ,˵ҲԽ,, ,,ĵһƷ,,,ôҲλ,,ҽһ!Ǻ^','sicen','','1174351795');
INSERT INTO `p8_flash_swf` VALUES ('6002','4','ʩЧ򭶯','ЦĬ','0','','0','1131','1','1098547200','1098547200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1369.gif','1','1','','0','0','0','','','','','','','','0','0','','5166','0','','','','0','0','0','529','http://flash.7k7k.com/fl_3/7k7k_flash1369.swf','ªҪäĿģȴ޴ģɳƷӢķ','','','1174379829');
INSERT INTO `p8_flash_swf` VALUES ('6055','4','ͽıڶ','ЦĬ','0','','0','5530','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1372.gif','1','1','','0','0','0','','','','','','','','0','0','','5220','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1372.swf','','','','1173968204');
INSERT INTO `p8_flash_swf` VALUES ('6057','4','BOBO⴫--д','ЦĬ','0','','0','1717','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1374.gif','1','1','','0','0','0','','','','','','','','0','0','','5222','0','','','','0','0','0','2147','http://flash.7k7k.com/fl_3/7k7k_flash1374.swf','BOBOҪȥҪ׬ǮֵıǹѽѡָףʲôȤ»ᷢأ֪!^0^&nbsp;','εش','','1174379546');
INSERT INTO `p8_flash_swf` VALUES ('6058','4','f}ϹϟāԴ','ЦĬ','0','','0','9845','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1375.gif','1','1','','0','0','0','','','','','','','','0','0','','5223','0','','','','0','0','0','2468','http://flash.7k7k.com/fl_3/7k7k_flash1375.swf','f}ϹϟāԴ','aekids','','1173909109');
INSERT INTO `p8_flash_swf` VALUES ('6060','4','ְ֮-İɶ','ЦĬ','0','','0','3356','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1377.gif','1','1','','0','0','0','','','','','','','','0','0','','5225','0','','','','0','0','0','2208','http://flash.7k7k.com/fl_3/7k7k_flash1377.swf','ְ֮-İ','yesir','','1173930636');
INSERT INTO `p8_flash_swf` VALUES ('6062','4','ƽ һ  ','ЦĬ','0','','0','8847','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1379.gif','1','1','','0','0','0','','','','','','','','0','0','','5227','0','','','','0','0','0','1083','http://flash.7k7k.com/fl_3/7k7k_flash1379.swf','ǵ','','','1173926062');
INSERT INTO `p8_flash_swf` VALUES ('6063','5','˹','ͯ','0','','0','5569','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1380.gif','1','1','','0','0','0','','','','','','','','0','0','','5228','0','','','','0','0','0','2240','http://flash.7k7k.com/fl_3/7k7k_flash1380.swf','һ˹ŨĶʽ','yiwan','','1174228446');
INSERT INTO `p8_flash_swf` VALUES ('6066','4','Ǹͷ ','ЦĬ','0','','0','7207','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1383.gif','1','1','','0','0','0','','','','','','','','0','0','','5231','0','','','','0','0','0','655','http://flash.7k7k.com/fl_3/7k7k_flash1383.swf','CLEARBY-ǸͷߣCLEARBY&nbsp;','CLEARBY','','1174275044');
INSERT INTO `p8_flash_swf` VALUES ('6067','4','ְ֮-ɶ','ЦĬ','0','','0','2225','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1384.gif','1','1','','0','0','0','','','','','','','','0','0','','5232','0','','','','0','0','0','1347','http://flash.7k7k.com/fl_3/7k7k_flash1384.swf','ְ֮-ְ','yesir','','1173884781');
INSERT INTO `p8_flash_swf` VALUES ('6068','4','Ӷ','ЦĬ','0','','0','9999','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1385.gif','1','1','','0','0','0','','','','','','','','0','0','','5233','0','','','','0','0','0','606','http://flash.7k7k.com/fl_3/7k7k_flash1385.swf','bbqiӡ,ѡɽľӡʮӿʼ','bbqi','','1174090166');
INSERT INTO `p8_flash_swf` VALUES ('6070','5','춯','ͯ','0','','0','9609','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1387.gif','1','1','','0','0','0','','','','','','','','0','0','','5235','0','','','','0','0','0','6335','http://flash.7k7k.com/fl_3/7k7k_flash1387.swf','ƷǸݡɽߵĹ¸ıġŮ˺Ͳ׳٣Ϊġ֪䲻ɶΪ֮ľжϣͨƷ־Υ˵ִ','״֮ʬ','','1174380137');
INSERT INTO `p8_flash_swf` VALUES ('6071','5','漣','ͯ','0','','0','9585','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1388.gif','1','1','','0','0','0','','','','','','','','0','0','','5236','0','','','','0','0','0','2400','http://flash.7k7k.com/fl_3/7k7k_flash1388.swf','Ʒҵľ츸ʮꡣǶ㣬֪ǰϣǷѾ˰ɫģ֪Ƿȥҵʺ˼','','','1174290339');
INSERT INTO `p8_flash_swf` VALUES ('6072','5','ڤг(1)','ͯ','0','','0','3986','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1389.gif','1','1','','0','0','0','','','','','','','','0','0','','5237','0','','','','0','0','0','9270','http://flash.7k7k.com/fl_3/7k7k_flash1389.swf','Ʒˣ¸ 磺ع &nbsp;&nbsp;һϵİһص󡭡ֻǡ¼չ','ʳ','','1174177039');
INSERT INTO `p8_flash_swf` VALUES ('6073','4','-ٶ','ЦĬ','0','','0','3209','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1390.gif','1','1','','0','0','0','','','','','','','','0','0','','5238','0','','','','0','0','0','399','http://flash.7k7k.com/fl_3/7k7k_flash1390.swf','̰С˳Դ','','','1174066068');
INSERT INTO `p8_flash_swf` VALUES ('6076','4','ӦƸ1','ЦĬ','0','','0','9677','1','1099670400','1099670400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1393.gif','1','1','','0','0','0','','','','','','','','0','0','','5241','0','','','','0','0','0','2004','http://flash.7k7k.com/fl_3/7k7k_flash1393.swf','ϣϲ','yesir','','1174279201');
INSERT INTO `p8_flash_swf` VALUES ('6077','4','sars2004','ЦĬ','0','','0','4283','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1394.gif','1','1','','0','0','0','','','','','','','','0','0','','5242','0','','','','0','0','0','853','http://flash.7k7k.com/fl_3/7k7k_flash1394.swf','kill sars!!!','321run','','1174226080');
INSERT INTO `p8_flash_swf` VALUES ('6079','5','ĺ֮ڽֵܶ','ͯ','0','','0','5071','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1396.gif','1','1','','0','0','0','','','','','','','','0','0','','5244','0','','','','0','0','0','475','http://flash.7k7k.com/fl_3/7k7k_flash1396.swf','Ӽڹ;֮Ĺ£ѧйŵ䣬ѧӢŶ','','','1174039807');
INSERT INTO `p8_flash_swf` VALUES ('6080','4','Ҫ','ЦĬ','0','','0','9259','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1397.gif','1','1','','0','0','0','','','','','','','','0','0','','5245','0','','','','0','0','0','925','http://flash.7k7k.com/fl_3/7k7k_flash1397.swf','ǳЦĹFLASHƬ','bruno hamzagk','','1174226176');
INSERT INTO `p8_flash_swf` VALUES ('6081','4','СĹ¡򶯻','ЦĬ','0','','0','8999','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1398.gif','1','1','','0','0','0','','','','','','','','0','0','','5246','0','','','','0','0','0','523','http://flash.7k7k.com/fl_3/7k7k_flash1398.swf','һδFLASHƳָ','С','','1174247166');
INSERT INTO `p8_flash_swf` VALUES ('6082','4','͵ߵһ춯','ЦĬ','0','','0','2946','1','1099584000','1099584000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1399.gif','1','1','','0','0','0','','','','','','','','0','0','','5247','0','','','','0','0','0','859','http://flash.7k7k.com/fl_3/7k7k_flash1399.swf','ÿ˶ϲƯŮӣ֮һľͷ3+3+3̫ϴˮͷ˳ûͷƤΪ˵Ľ㣡Զϡ̫񡱺˱仯Ŷ˲ԼԻ䵱͵ߡҲɫŶ:PϲĹ𣿣ʲô֪','zzjxb','','1173775503');
INSERT INTO `p8_flash_swf` VALUES ('6117','5','춯','ͯ','0','','0','3026','1','1100707200','1100707200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1400.gif','1','1','','0','0','0','','','','','','','','0','0','','5282','0','','','','0','0','0','9040','http://flash.7k7k.com/fl_3/7k7k_flash1400.swf','˵죬˵ҹ˵Сǣ˵ҹ','b-t','','1173824518');
INSERT INTO `p8_flash_swf` VALUES ('6118','5','ө֮ɭ3-','ͯ','0','','0','5023','1','1100707200','1100707200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1401.gif','1','1','','0','0','0','','','','','','','','0','0','','5283','0','','','','0','0','0','5837','http://flash.7k7k.com/fl_3/7k7k_flash1401.swf','ө֮ɭ-ˣҾϸϸζİͼǵĸж˼~','kusanba','','1174259051');
INSERT INTO `p8_flash_swf` VALUES ('6123','4','pencilmation','ЦĬ','0','','0','3859','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1406.gif','1','1','','0','0','0','','','','','','','','0','0','','5288','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1406.swf','','','','1174149222');
INSERT INTO `p8_flash_swf` VALUES ('6125','4','У԰ϵУһ','ЦĬ','0','','0','105','1','1100707200','1100707200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1408.gif','1','1','','0','0','0','','','','','','','','0','0','','5290','0','','','','0','0','0','793','http://flash.7k7k.com/fl_3/7k7k_flash1408.swf','ƳУ԰Цϵж԰ºСУ԰ĻΪչĸЦǵһǺܾϸ½⡣ԺŬϣϲ֧֣ллŶ','egg','','1173859725');
INSERT INTO `p8_flash_swf` VALUES ('6126','5','ѰҸ-򶯻','ͯ','0','','0','2743','1','1100707200','1100707200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1409.gif','1','1','','0','0','0','','','','','','','','0','0','','5291','0','','','','0','0','0','2456','http://flash.7k7k.com/fl_3/7k7k_flash1409.swf','ϲ͵ڿС󶡶żȻʶľګèͬʱżȻҸ𽴵Ĵ˵Ƕڹ๾忪ʼΰðա','ͯ','','1174238835');
INSERT INTO `p8_flash_swf` VALUES ('6127','5','ڤг(2) ','ͯ','0','','0','9213','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1410.gif','1','1','','0','0','0','','','','','','','','0','0','','5292','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1410.swf','','','','1174296194');
INSERT INTO `p8_flash_swf` VALUES ('6130','5',';϶','ͯ','0','','0','8284','1','1100707200','1100707200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1413.gif','1','1','','0','0','0','','','','','','','','0','0','','5295','0','','','','0','0','0','701','http://flash.7k7k.com/fl_3/7k7k_flash1413.swf','У;ϣḥӡѧйŵ䣬ѧӢġ','','','1174117756');
INSERT INTO `p8_flash_swf` VALUES ('6131','4','ͷѵ¹ʶ','ЦĬ','0','','0','9308','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1414.gif','1','1','','0','0','0','','','','','','','','0','0','','5296','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1414.swf','','','','1173775557');
INSERT INTO `p8_flash_swf` VALUES ('6132','5','µͯ','ͯ','0','','0','2788','1','1100707200','1100707200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1415.gif','1','1','','0','0','0','','','','','','','','0','0','','5297','0','','','','0','0','0','4931','http://flash.7k7k.com/fl_3/7k7k_flash1415.swf','ҵĵڣȽƷɣϣϲ','','','1174184079');
INSERT INTO `p8_flash_swf` VALUES ('6186','4','ѧ԰֮ɶ','ЦĬ','0','','0','8264','1','1101830400','1101830400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1419.gif','1','1','','0','0','0','','','','','','','','0','0','','5352','0','','','','0','0','0','3634','http://flash.7k7k.com/fl_3/7k7k_flash1419.swf','ˣ˺ڵϷƦӶ۸ˣҿ취','TOT','','1174322755');
INSERT INTO `p8_flash_swf` VALUES ('6189','4','-019ѻعӶ','ЦĬ','0','','0','2661','1','1101830400','1101830400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1422.gif','1','1','','0','0','0','','','','','','','','0','0','','5355','0','','','','0','0','0','511','http://flash.7k7k.com/fl_3/7k7k_flash1422.swf','밮࣬вҪѻ:)&nbsp;','','','1174352079');
INSERT INTO `p8_flash_swf` VALUES ('6190','4','˵3( йƪ','ЦĬ','0','','0','1617','1','1101830400','1101830400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1423.gif','1','1','','0','0','0','','','','','','','','0','0','','5356','0','','','','0','0','0','172','http://flash.7k7k.com/fl_3/7k7k_flash1423.swf','ΪйӸеź','Ӱ','','1173859629');
INSERT INTO `p8_flash_swf` VALUES ('6196','4','ɫǿն','ЦĬ','0','','0','575','1','1101830400','1101830400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1429.gif','1','1','','0','0','0','','','','','','','','0','0','','5362','0','','','','0','0','0','1355','http://flash.7k7k.com/fl_3/7k7k_flash1429.swf','ɫǿ,ռɫ,ɫŻῴĺĶ!','ͷ','','1174176983');
INSERT INTO `p8_flash_swf` VALUES ('6199','4','ٰʱ챬Ц涯','ЦĬ','0','','0','5634','1','1101830400','1101830400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1432.gif','1','1','','0','0','0','','','','','','','','0','0','','5365','0','','','','0','0','0','1325','http://flash.7k7k.com/fl_3/7k7k_flash1432.swf','ЦFLASHȤĲ','WAR3','','1174280091');
INSERT INTO `p8_flash_swf` VALUES ('6201','4','󱿵','ЦĬ','0','','0','8953','1','1101830400','1101830400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1434.gif','1','1','','0','0','0','','','','','','','','0','0','','5367','0','','','','0','0','0','1990','http://flash.7k7k.com/fl_3/7k7k_flash1434.swf','ıԶƬ˰塷 Ϊ˼flash  Цɷݴ5','С','','1173930582');
INSERT INTO `p8_flash_swf` VALUES ('6203','4','ѧ԰֮','ЦĬ','0','','0','6472','1','1101830400','1101830400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1436.gif','1','1','','0','0','0','','','','','','','','0','0','','5369','0','','','','0','0','0','2924','http://flash.7k7k.com/fl_3/7k7k_flash1436.swf','ѧ԰~~~~~ TOT','TOT','','1174280238');
INSERT INTO `p8_flash_swf` VALUES ('6207','4','۶','ЦĬ','0','','0','4876','1','1101830400','1101830400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1440.gif','1','1','','0','0','0','','','','','','','','0','0','','5373','0','','','','0','0','0','695','http://flash.7k7k.com/fl_3/7k7k_flash1440.swf','2004ƴƷΧ','׽','','1174045795');
INSERT INTO `p8_flash_swf` VALUES ('6208','4','[عţţ]ǰ','ЦĬ','0','','0','7969','1','1101830400','1101830400','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1441.gif','1','1','','0','0','0','','','','','','','','0','0','','5374','0','','','','0','0','0','507','http://flash.7k7k.com/fl_3/7k7k_flash1441.swf','ϵ֮һعţţлע','','','1174149296');
INSERT INTO `p8_flash_swf` VALUES ('6264','4','help me','ЦĬ','0','','0','6425','1','1102953600','1102953600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1443.gif','1','1','','0','0','0','','','','','','','','0','0','','5430','0','','','','0','0','0','306','http://flash.7k7k.com/fl_3/7k7k_flash1443.swf','N˿N뷨ҿˡ','·','','1173824136');
INSERT INTO `p8_flash_swf` VALUES ('6267','5','ڼ','ͯ','0','','0','5439','1','1102953600','1102953600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1445.gif','1','1','','0','0','0','','','','','','','','0','0','','5433','0','','','','0','0','0','2465','http://flash.7k7k.com/fl_3/7k7k_flash1445.swf','żָдС˵мXIXI~~','YA','','1174335212');
INSERT INTO `p8_flash_swf` VALUES ('6268','5','ˮڶ','ͯ','0','','0','6180','1','1102953600','1102953600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1446.gif','1','1','','0','0','0','','','','','','','','0','0','','5434','0','','','','0','0','0','10599','http://flash.7k7k.com/fl_3/7k7k_flash1446.swf','񶯻ײ硶ˮ롷ϵС','񶯻','','1174137631');
INSERT INTO `p8_flash_swf` VALUES ('6269','4','֮һĶ','ЦĬ','0','','0','3217','1','1102953600','1102953600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1447.gif','1','1','','0','0','0','','','','','','','','0','0','','5435','0','','','','0','0','0','419','http://flash.7k7k.com/fl_3/7k7k_flash1447.swf','ϵеĵһƷҶ','','','1174320349');
INSERT INTO `p8_flash_swf` VALUES ('6270','4','ֻ֮С','ЦĬ','0','','0','3218','1','1102953600','1102953600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1448.gif','1','1','','0','0','0','','','','','','','','0','0','','5436','0','','','','0','0','0','919','http://flash.7k7k.com/fl_3/7k7k_flash1448.swf','ϵжƬĵڶƷӭҶ','','','1174119637');
INSERT INTO `p8_flash_swf` VALUES ('6276','4','ˮ֮ƪ','ЦĬ','0','','0','9545','1','1102953600','1102953600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1454.gif','1','1','','0','0','0','','','','','','','','0','0','','5442','0','','','','0','0','0','3888','http://flash.7k7k.com/fl_3/7k7k_flash1454.swf','&nbsp;һ죬ݮݮĹȥܴæӣݮݮСߡʱںһˡݮݮΪӴļһΪ˸ɳǱصģǳˡ&nbsp;&nbsp;&nbsp;&nbsp;ʵǡпᡱģԭԵĵ⣬ǻȴҪʺͲݮ,ðĵתΪ','ˮ','','1174320316');
INSERT INTO `p8_flash_swf` VALUES ('6277','4','Draw','ЦĬ','0','','0','368','1','1102953600','1102953600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1455.gif','1','1','','0','0','0','','','','','','','','0','0','','5443','0','','','','0','0','0','919','http://flash.7k7k.com/fl_3/7k7k_flash1455.swf','Draw,һƷúܺ,ģһ£Ǻǡ','chinesecabbage','','1174211753');
INSERT INTO `p8_flash_swf` VALUES ('6278','4','ɴ򻢣㣩','ЦĬ','0','','0','9428','1','1102953600','1102953600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1456.gif','1','1','','0','0','0','','','','','','','','0','0','','5444','0','','','','0','0','0','647','http://flash.7k7k.com/fl_3/7k7k_flash1456.swf','ҳСˣٺ.......','ͨ','','1174231182');
INSERT INTO `p8_flash_swf` VALUES ('6280','4','ѧ԰֮ѧУй','ЦĬ','0','','0','2522','1','1102953600','1102953600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1458.gif','1','1','','0','0','0','','','','','','','','0','0','','5446','0','','','','0','0','0','8179','http://flash.7k7k.com/fl_3/7k7k_flash1458.swf','ѧУйȥ TOTȫ','TOT','','1173926082');
INSERT INTO `p8_flash_swf` VALUES ('6281','5','ʶ','ͯ','0','','0','5513','1','1102953600','1102953600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1459.gif','1','1','','0','0','0','','','','','','','','0','0','','5447','0','','','','0','0','0','2738','http://flash.7k7k.com/fl_3/7k7k_flash1459.swf','ϵУ档','','','1173734892');
INSERT INTO `p8_flash_swf` VALUES ('6282','4','ʥﶯ','ЦĬ','0','','0','8923','1','1102953600','1102953600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1460.gif','1','1','','0','0','0','','','','','','','','0','0','','5448','0','','','','0','0','0','661','http://flash.7k7k.com/fl_3/7k7k_flash1460.swf','ŴСϣŴѪͣAŮһֻӵд߹ѪͳĹУߣ30cm أ40Եʳ˹裨ľԳģʳ⣨ô߹ôֶϲ£͵Ưmm ͷҪϲĸ裺ŮãЩDDϲسӿͳϣŹֵĶԣˬʱЩĬȵ˶ٻɢʱҲо֮Ը','','','1174233138');
INSERT INTO `p8_flash_swf` VALUES ('6285','5','鶯','ͯ','0','','0','4628','1','1102953600','1102953600','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1463.gif','1','1','','0','0','0','','','','','','','','0','0','','5451','0','','','','0','0','0','6101','http://flash.7k7k.com/fl_3/7k7k_flash1463.swf','һ֣ڴÿҹĻٵһ̣һ缴ԾһܴȻԭ','puffin','','1174190590');
INSERT INTO `p8_flash_swf` VALUES ('6341','4','5߰ʦж','ЦĬ','0','','0','3546','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1465.gif','1','1','','0','0','0','','','','','','','','0','0','','5507','0','','','','0','0','0','5262','http://flash.7k7k.com/fl_3/7k7k_flash1465.swf','ֻСܲܳɹʦأҼۿΡ֣߰ʦ','˼','','1173930379');
INSERT INTO `p8_flash_swf` VALUES ('6342','4','ǹ-ˮƪ ','ЦĬ','0','','0','6444','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1466.gif','1','1','','0','0','0','','','','','','','','0','0','','5508','0','','','','0','0','0','4033','http://flash.7k7k.com/fl_3/7k7k_flash1466.swf','ԷڻʱȤΪдĶ㶯','ɽ','','1174056574');
INSERT INTO `p8_flash_swf` VALUES ('6344','5','һҶĿ','ͯ','0','','0','8773','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1468.gif','1','1','','0','0','0','','','','','','','','0','0','','5510','0','','','','0','0','0','2511','http://flash.7k7k.com/fl_3/7k7k_flash1468.swf','ϵУѧϰο','','','1174350539');
INSERT INTO `p8_flash_swf` VALUES ('6345','5','Ŀ࿴','ͯ','0','','0','4660','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1469.gif','1','1','','0','0','0','','','','','','','','0','0','','5511','0','','','','0','0','0','2880','http://flash.7k7k.com/fl_3/7k7k_flash1469.swf','ϵУѧϰο','','','1174289134');
INSERT INTO `p8_flash_swf` VALUES ('6346','4','ˮ֮2005ʥ','ЦĬ','0','','0','3122','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1470.gif','1','1','','0','0','0','','','','','','','','0','0','','5512','0','','','','0','0','0','1486','http://flash.7k7k.com/fl_3/7k7k_flash1470.swf','ʷֵpacooˮ䡱ǳ','ˮ','','1173930293');
INSERT INTO `p8_flash_swf` VALUES ('6348','4','ʥ˵ʥ','ЦĬ','0','','0','1854','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1472.gif','1','1','','0','0','0','','','','','','','','0','0','','5514','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1472.swf','','','','1173820455');
INSERT INTO `p8_flash_swf` VALUES ('6349','4','ͷڶ','ЦĬ','0','','0','4715','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1473.gif','1','1','','0','0','0','','','','','','','','0','0','','5515','0','','','','0','0','0','5450','http://flash.7k7k.com/fl_3/7k7k_flash1473.swf','񶯻Ʒͷϵ','񶯻','','1174291981');
INSERT INTO `p8_flash_swf` VALUES ('6352','4','ҽԺ֮','ЦĬ','0','','0','7612','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1476.gif','1','1','','0','0','0','','','','','','','','0','0','','5518','0','','','','0','0','0','620','http://flash.7k7k.com/fl_3/7k7k_flash1476.swf','һЦףʥ֣Цڳ','','','1174203606');
INSERT INTO `p8_flash_swf` VALUES ('6353','5','ĳ','ͯ','0','','0','2140','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1477.gif','1','1','','0','0','0','','','','','','','','0','0','','5519','0','','','','0','0','0','795','http://flash.7k7k.com/fl_3/7k7k_flash1477.swf','ϵУѧʹá','','','1174381276');
INSERT INTO `p8_flash_swf` VALUES ('6356','5','ǳСѧ֮ʱ ','ͯ','0','','0','3187','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1480.gif','1','1','','0','0','0','','','','','','','','0','0','','5522','0','','','','0','0','0','2096','http://flash.7k7k.com/fl_3/7k7k_flash1480.swf','һ궯ĳһϺ̨ҪĽǺûбֳ-_-|||&nbsp;&nbsp;&nbsp;&nbsp;ҵQQ298827834','Ц','','1218687504');
INSERT INTO `p8_flash_swf` VALUES ('6365','4','ʥڴЦ','ЦĬ','0','','0','8295','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1488.gif','1','1','','0','0','0','','','','','','','','0','0','','5531','0','','','','0','0','0','2043','http://flash.7k7k.com/fl_3/7k7k_flash1488.swf','ʥڴЦ','superhhh','','1173930660');
INSERT INTO `p8_flash_swf` VALUES ('6370','5','赹  ','ͯ','0','','0','7827','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1493.gif','1','1','','0','0','0','','','','','','','','0','0','','5536','0','','','','0','0','0','1280','http://flash.7k7k.com/fl_3/7k7k_flash1493.swf','ϵУѧʹ~','','','1174381434');
INSERT INTO `p8_flash_swf` VALUES ('6371','5','̹Ƕ','ͯ','0','','0','2035','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1494.gif','1','1','','0','0','0','','','','','','','','0','0','','5537','0','','','','0','0','0','794','http://flash.7k7k.com/fl_3/7k7k_flash1494.swf','ϵУѧʹ~&nbsp;','','','1174383343');
INSERT INTO `p8_flash_swf` VALUES ('6372','4','дġЦ ','ЦĬ','0','','0','2482','1','1104508800','1104508800','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1495.gif','1','1','','0','0','0','','','','','','','','0','0','','5538','0','','','','0','0','0','654','http://flash.7k7k.com/fl_3/7k7k_flash1495.swf','ЦıģЦ~~','','','1173930668');
INSERT INTO `p8_flash_swf` VALUES ('6393','5','ˮQ','ͯ','0','','0','5103','1','1105027200','1105027200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1499.gif','1','1','','0','0','0','','','','','','','','0','0','','5560','0','','','','0','0','0','1882','http://flash.7k7k.com/fl_3/7k7k_flash1499.swf','ˮ䰣Ѵ','GoKu','','1174348832');
INSERT INTO `p8_flash_swf` VALUES ('6394','4','Ρرƪ2005()','ЦĬ','0','','0','7991','1','1105027200','1105027200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1500.gif','1','1','','0','0','0','','','','','','','','0','0','','5561','0','','','','0','0','0','5192','http://flash.7k7k.com/fl_3/7k7k_flash1500.swf','μӹ㻰޵ø...򣬅ֱͬ𰡣','˼','','1173930300');
INSERT INTO `p8_flash_swf` VALUES ('6475','4','꣬³!','ЦĬ','0','','0','665','1','1105632000','1105632000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1503.gif','1','1','','0','0','0','','','','','','','','0','0','','5644','0','','','','0','0','0','4896','http://flash.7k7k.com/fl_3/7k7k_flash1503.swf','꣬ף³ɣ⣡','èè','','1173930412');
INSERT INTO `p8_flash_swf` VALUES ('6477','4','ϵ-˲Ƹ ','ЦĬ','0','','0','9801','1','1105632000','1105632000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1505.gif','1','1','','0','0','0','','','','','','','','0','0','','5646','0','','','','0','0','0','507','http://flash.7k7k.com/fl_3/7k7k_flash1505.swf','ǸͰ!!','ghost-train','','1173928591');
INSERT INTO `p8_flash_swf` VALUES ('6478','4','ɰĵ','ЦĬ','0','','0','4730','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1506.gif','1','1','','0','0','0','','','','','','','','0','0','','5647','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1506.swf','','','','1173832070');
INSERT INTO `p8_flash_swf` VALUES ('6479','5','5','ͯ','0','','0','2465','1','1105632000','1105632000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1507.gif','1','1','','0','0','0','','','','','','','','0','0','','5648','0','','','','0','0','0','10744','http://flash.7k7k.com/fl_3/7k7k_flash1507.swf','񻷵ĵѰСףȴʹģС׻뿪ôѵСһôάȥôۿס֮֡һ','','','1174330272');
INSERT INTO `p8_flash_swf` VALUES ('6480','4','ѧ԰֮ͷ','ЦĬ','0','','0','3824','1','1105632000','1105632000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1508.gif','1','1','','0','0','0','','','','','','','','0','0','','5649','0','','','','0','0','0','4589','http://flash.7k7k.com/fl_3/7k7k_flash1508.swf','ɶƭӣ·ƭȡҵͬ顣ұ˺ôѵ TOT','TOT','','1174122784');
INSERT INTO `p8_flash_swf` VALUES ('6481','4','ͯ Ůһ','ЦĬ','0','','0','9121','1','0','0','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1509.gif','1','1','','0','0','0','','','','','','','','0','0','','5650','0','','','','0','0','0','','http://flash.7k7k.com/fl_3/7k7k_flash1509.swf','','','','1173817568');
INSERT INTO `p8_flash_swf` VALUES ('6482','4','ͯ Ůڶ','ЦĬ','0','','0','9817','1','1105632000','1105632000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1510.gif','1','1','','0','0','0','','','','','','','','0','0','','5651','0','','','','0','0','0','4182','http://flash.7k7k.com/fl_3/7k7k_flash1510.swf','һ˧ѵĹڿʼԼˡܲҵе˧أڱЦĵڶõ𰸡','lulalei','','1173824025');
INSERT INTO `p8_flash_swf` VALUES ('6484','5','Ӱ߶','ͯ','0','','0','8816','1','1105632000','1105632000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1512.gif','1','1','','0','0','0','','','','','','','','0','0','','5653','0','','','','0','0','0','4206','http://flash.7k7k.com/fl_3/7k7k_flash1512.swf','ͬѧһMV,Ҷָ^_^','콣ǳ','','1174342173');
INSERT INTO `p8_flash_swf` VALUES ('6487','5','ﶯ','ͯ','0','','0','8668','1','1105632000','1105632000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1515.gif','1','1','','0','0','0','','','','','','','','0','0','','5656','0','','','','0','0','0','2490','http://flash.7k7k.com/fl_3/7k7k_flash1515.swf','ǰѧFLASHʱĵһƷ','O','','1174321569');
INSERT INTO `p8_flash_swf` VALUES ('6488','5','Թºڶ','ͯ','0','','0','5775','1','1105632000','1105632000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1516.gif','1','1','','0','0','0','','','','','','','','0','0','','5657','0','','','','0','0','0','643','http://flash.7k7k.com/fl_3/7k7k_flash1516.swf','СǲҲԹһºأǿԹ˷ëİ.......&nbsp;','Բͨ','','1174375984');
INSERT INTO `p8_flash_swf` VALUES ('6489','4','ڤƪ ļ ԤƬ','ЦĬ','0','','0','8755','1','1105632000','1105632000','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1517.gif','1','1','','0','0','0','','','','','','','','0','0','','5658','0','','','','0','0','0','879','http://flash.7k7k.com/fl_3/7k7k_flash1517.swf','ڤƪ4¯','ŵ˹','','1174112595');
INSERT INTO `p8_flash_swf` VALUES ('6542','4','ף','ЦĬ','0','','0','6133','1','1106323200','1106323200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1519.gif','1','1','','0','0','0','','','','','','','','0','0','','5714','0','','','','0','0','0','222','http://flash.7k7k.com/fl_3/7k7k_flash1519.swf','Ѱʹ̳ףҼѰhttp://27006.net/bbs','','','1173723731');
INSERT INTO `p8_flash_swf` VALUES ('6545','5','իϵС½СԤƬ','ͯ','0','','0','166','1','1106323200','1106323200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1522.gif','1','1','','0','0','0','','','','','','','','0','0','','5717','0','','','','0','0','0','9068','http://flash.7k7k.com/fl_3/7k7k_flash1522.swf','իϵС½СԤƬ','eӰ','','1174352035');
INSERT INTO `p8_flash_swf` VALUES ('6546','4','˸Цһëë԰׶','ЦĬ','0','','0','8396','1','1106323200','1106323200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1523.gif','1','1','','0','0','0','','','','','','','','0','0','','5718','0','','','','0','0','0','211','http://flash.7k7k.com/fl_3/7k7k_flash1523.swf','ϵиЦĿǳ','g0c0','','1174352236');
INSERT INTO `p8_flash_swf` VALUES ('6547','4','','ЦĬ','0','','0','6030','1','1106323200','1106323200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1524.gif','1','1','','0','0','0','','','','','','','','0','0','','5719','0','','','','0','0','0','1524','http://flash.7k7k.com/fl_3/7k7k_flash1524.swf','ϣʶϲflashѣ','С','','1174190630');
INSERT INTO `p8_flash_swf` VALUES ('6548','4','ʱбֻ','ЦĬ','0','','0','9061','1','1106323200','1106323200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1525.gif','1','1','','0','0','0','','','','','','','','0','0','','5720','0','','','','0','0','0','1681','http://flash.7k7k.com/fl_3/7k7k_flash1525.swf','ֻ֮ıٺ٣','zzjxb','','1173733239');
INSERT INTO `p8_flash_swf` VALUES ('6550','4','Q桶󽣡','ЦĬ','0','','0','7195','1','1106323200','1106323200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1527.gif','1','1','','0','0','0','','','','','','','','0','0','','5722','0','','','','0','0','0','883','http://flash.7k7k.com/fl_3/7k7k_flash1527.swf','ź,FLASHҵ.Ҹоǰн.һγ,ЧԲ˵.','jackfun','','1174320356');
INSERT INTO `p8_flash_swf` VALUES ('6551','4','è󶯻','ЦĬ','0','','0','1657','1','1106323200','1106323200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1528.gif','1','1','','0','0','0','','','','','','','','0','0','','5723','0','','','','0','0','0','3700','http://flash.7k7k.com/fl_3/7k7k_flash1528.swf','֮Ӣ۰','wujin_11','','1174022973');
INSERT INTO `p8_flash_swf` VALUES ('6552','4','Draw-space','ЦĬ','0','','0','5714','1','1106323200','1106323200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1529.gif','1','1','','0','0','0','','','','','','','','0','0','','5724','0','','','','0','0','0','593','http://flash.7k7k.com/fl_3/7k7k_flash1529.swf','ǺǡDrawϵж','chinesecabbage','','1174337137');
INSERT INTO `p8_flash_swf` VALUES ('6553','4','ƪ','ЦĬ','0','','0','6625','1','1106323200','1106323200','0','','','0','http://img.7k7k.com/7k7knewyeah/fl_3.pic/7k7k_flash_pic1530.gif','1','1','','0','1','1218685750','','','','','','','','0','0','','5725','0','','','','0','0','0','918','http://flash.7k7k.com/fl_3/7k7k_flash1530.swf','ƪ','F-','','1174262009');
INSERT INTO `p8_form_module` VALUES ('1','','0','','a:2:{s:8:\"field_db\";a:3:{s:11:\"my_truename\";a:13:{s:5:\"title\";s:8:\"ʵ\";s:10:\"field_name\";s:11:\"my_truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:6:\"my_sex\";a:13:{s:5:\"title\";s:4:\"Ա\";s:10:\"field_name\";s:6:\"my_sex\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:4;s:9:\"form_type\";s:6:\"select\";s:8:\"form_set\";s:12:\"\r\nŮ\r\n\";s:10:\"form_value\";s:4:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:5:\"my_qq\";a:13:{s:5:\"title\";s:6:\"ϵQQ\";s:10:\"field_name\";s:5:\"my_qq\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:1:{s:7:\"content\";s:4:\"\";}}');
INSERT INTO `p8_form_module` VALUES ('3','','0','','a:2:{s:8:\"field_db\";a:2:{s:7:\"content\";a:13:{s:5:\"title\";s:8:\"λ\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}s:6:\"my_758\";a:13:{s:5:\"title\";s:8:\"ò\";s:10:\"field_name\";s:6:\"my_758\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:6;s:9:\"form_type\";s:5:\"radio\";s:8:\"form_set\";s:16:\"Ա\r\nԱ\r\n\";s:10:\"form_value\";s:4:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:0:\"\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}}');
INSERT INTO `p8_friendlink` VALUES ('6','0','ݼݼ̳','http://www.mmcbbs.com','../images/default/mmcbbs.gif','㶫ʡïѧԺѧ̳','1','0','0','0','0','0','','1');
INSERT INTO `p8_friendlink` VALUES ('5','0','php168վ','http://www.php168.com','../images/default/php168.gif','ṩվϵͳ','2','0','0','0','0','0','','1');
INSERT INTO `p8_friendlink_sort` VALUES ('1','','0');
INSERT INTO `p8_friendlink_sort` VALUES ('2','Ƽ','2');
INSERT INTO `p8_gather_rule` VALUES ('3','0','article','article','','phpe.net','http://phpe.net/?n=Articles&p=[page]&t=1','','1','3','1','0','','shtml','<','','','','','','','0','','','','','','','','','0','1172984270','0','0','0','','0','0','','','','0','','<tr><td width=\"100%\"><li class=\"fang\"><a href=\"{url=NO\"}\" title=\"{NO\"}\">{title=NO<}</a></li></td>','<td style=\"word-wrap:break-word; font-size: 14px; line-height: 160%\">{content=*}</td></tr>','','','0');
INSERT INTO `p8_gather_rule` VALUES ('26','0','article','article','','Ѷ˲ż','','','0','0','1','0','http://edu.qq.com/job/jlgc_more.htm\r\nhttp://edu.qq.com/job/jlgc_more1.htm\r\nhttp://edu.qq.com/job/jlgc_more2.htm','','','','','','','','','0','','','','','','<table|<table style=\"display:none;\"','','','0','1172984270','1172984423','0','0','','0','0','','','','0','','<tr><td height=\"24\" class=\"font14px\"><div align=\"left\"><a target=\"_blank\" class=\"blackul\" href=\"{url=NO\"}\">{title=NO<}</a> ','<div id=\"ArticleCnt\">{content=*}</div><div id=\"copyweb\">','','','0');
INSERT INTO `p8_gather_rule` VALUES ('10','0','file','photo','','www.6778.comŮ--->','http://www.6778.com/photo/A001/F001W/G0450/P001/index[page].html','http://www.6778.com/photo/A001/F001W/G0450/P001/index.html','1','3','1','0','','../lk_GG88','<','','','','','$htmlcode=preg_replace(\"/<div class=\\\"V04\\\"><table cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" border=\\\"0\\\"><tr align=\\\"center\\\"><td><a href=\\\"([^\\\"]+)\\\" target=\\\"_blank\\\"><img src=\\\"([^\\\"]+)\\\" title=\\\"\\\" border=\\\"0\\\" width=\\\"151\\\" height=\\\"151\\\" alt=\\\"([^\\\"]+)\\\" class=\\\"brd01\\\"><\\/a><\\/td><\\/tr><tr align=\\\"center\\\"><td><a href=\\\"([^\\\"]+)\\\" target=\\\"_blank\\\"><div class=\\\"BvB\\\"><b class=\\\"TXB\\\">([^<>]+)<\\/b><br>/is\",\"<a href=\\\\1>\\\\5@@http://www.6778.com/photo/A001/F001W/G0450/P001/\\\\2</a>\",$htmlcode);','','0','$c_url=preg_replace(\"/(.*)GG88=([^&]+)&(.*)/is\",\"\\\\2\",$curl);\r\n$htmlcode=preg_replace(\"/var GG88_al =\\\"([^\\\"]+)\\\";/is\",\"<a src=http://www.gg88.com/PIC_01/\\\\1/$c_url.jpg></a>\",$htmlcode);','','','','','','','','0','1163916964','1163917162','0','0','.jpg','0','0','','','src=','0','','','','','','0');
INSERT INTO `p8_gather_rule` VALUES ('20','0','article','article','','ԭѧռ----->ɢ >> ','http://wind.yinsha.com/ashow.php?sid=10&%20size=20&page=[page]','','1','3','1','0','','','','','','','','','','0','','','','<tr><td><p class=s11>','</td></tr>','','','','0','1165498531','1165498610','0','0','','0','0','','','','0','','<img src=images/{NO\"} border=0>\r\n                    \r\n            <a href=\"{url=NO\"}\" target=_blank>{title=NO<}</a> ','','','','0');
INSERT INTO `p8_gather_rule` VALUES ('24','0','article','article','','̺ɴ-> ɢ >> ','http://wind.yinsha.com/ashow.php?sid=5&%20size=20&page=[page]','','1','8','1','0','','','','','','','','','','0','','','','','','','','','0','1166582291','1166582456','0','0','','0','0','','','','0','','<img src=images/{NO\"} border=0>\r\n                    \r\n            <a href=\"{url=NO }\" target=_blank>{title=NO<}</a> ','<div align=\"center\" class=\"s3\">: {author=NO\"}</div>{*}<tr><td><p class=s11>&nbsp;&nbsp;{content=*}</td></tr>\r\n\r\n','','','0');
INSERT INTO `p8_gather_rule` VALUES ('19','0','article','article','','̫ƽ-Ŀ > Ӧ','','','0','0','1','0','http://www.pconline.com.cn/servers/skills/index.html\r\nhttp://www.pconline.com.cn/servers/skills/index_1.html\r\nhttp://www.pconline.com.cn/servers/skills/index_2.html\r\nhttp://www.pconline.com.cn/servers/skills/index_3.html\r\nhttp://www.pconline.com.cn/servers/skills/index_4.html\r\n','http://www.pconline.com.cn/servers/skills/','<\r\nindex.html','','','','','','','0','','','','<td width=\"100%\" height=\"62\" class=\"article\">','<table width=\"100%\"','<IFRAME SRC=\"http://ivy.pconline.com.cn/adpuba/show?id=pc.fuwuqi.neiye.hzh.&pid=cs.pconline.fuwuqi.wengzhanghzh.&media=html\"  align=left SCROLLING=\"no\" WIDTH=\"320\" HEIGHT=\"280\" MARGINWIDTH=\"0\" MARGINHEIGHT=\"0\" FRAMEBORDER=\"0\" ALIGN=\"default\">棺ad_top</IFRAME>|','_[page].html','.html','1','1165123388','1165123551','0','0','','0','0','','','','0','','','','','','0');
INSERT INTO `p8_gather_rule` VALUES ('28','0','article','article','',' >> 鼦','','','0','0','1','0','http://www.39.net/mentalworld/xlzl/index.htm\r\nhttp://www.39.net/mentalworld/xlzl/index_1.htm\r\nhttp://www.39.net/mentalworld/xlzl/index_2.htm','','<','','','','','','','0','','','','','','','','','0','1179849019','1179849189','0','0','','0','0','','','','0','','><Li><a href=\"{url=NO\"}\" Target=_blank>{title=NO<}</a>','<tr><td class=\"newscontent\"><digital39:Content  showtag=\"true\" ID=\"N10\" >{content=*}</digital39:Content></td></tr></table>','','','0');
INSERT INTO `p8_gather_rule` VALUES ('31','0','article','article','','phpe.net','http://phpe.net/?n=Articles&p=[page]&t=1','','1','3','1','0','','shtml','<','','','','','','','0','','','','','','','','','0','1172984270','0','0','0','','0','0','','','','0','','<tr><td width=\"100%\"><li class=\"fang\"><a href=\"{url=NO\"}\" title=\"{NO\"}\">{title=NO<}</a></li></td>','<td style=\"word-wrap:break-word; font-size: 14px; line-height: 160%\">{content=*}</td></tr>','','','0');
INSERT INTO `p8_gather_sort` VALUES ('2','553333333','0','1','1','3','','0');
INSERT INTO `p8_group` VALUES ('2','1','ο','0','0','0','a:29:{s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:14:\"PassContribute\";s:1:\"1\";s:17:\"SearchArticleType\";s:1:\"1\";s:16:\"PostArticleYzImg\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:17:\"SetSpecialArticle\";s:1:\"0\";s:17:\"SetArticleKeyword\";s:1:\"0\";s:20:\"AddArticleKeywordNum\";s:0:\"\";s:21:\"AddArticleCopyfromNum\";s:0:\"\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:13:\"SetSmallTitle\";s:1:\"0\";s:19:\"CommentArticleYzImg\";s:1:\"1\";s:17:\"CollectArticleNum\";s:0:\"\";s:15:\"CreatSpecialNum\";s:0:\"\";}','0','');
INSERT INTO `p8_group` VALUES ('3','1','Ա','0','0','2','a:4:{s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";}','1','a:72:{s:13:\"center_config\";s:1:\"1\";s:9:\"menu_list\";s:1:\"1\";s:11:\"label_index\";s:1:\"1\";s:17:\"set_comsort_index\";s:1:\"1\";s:15:\"center_setindex\";s:1:\"1\";s:14:\"alonepage_list\";s:1:\"1\";s:14:\"guestbook_list\";s:1:\"1\";s:11:\"cache_cache\";s:1:\"1\";s:12:\"channel_list\";s:1:\"1\";s:9:\"blend_set\";s:1:\"1\";s:11:\"module_list\";s:1:\"1\";s:13:\"sort_listsort\";s:1:\"1\";s:13:\"artic_postnew\";s:1:\"1\";s:12:\"artic_addpic\";s:1:\"1\";s:15:\"artic_myarticle\";s:1:\"1\";s:15:\"artic_listartic\";s:1:\"1\";s:12:\"comment_list\";s:1:\"1\";s:13:\"makehtml_make\";s:1:\"1\";s:16:\"channel_list_fid\";s:1:\"1\";s:19:\"article_more_config\";s:1:\"1\";s:20:\"article_group_config\";s:1:\"1\";s:14:\"article_module\";s:1:\"1\";s:12:\"special_list\";s:1:\"1\";s:15:\"spsort_listsort\";s:1:\"1\";s:15:\"getkeyword_list\";s:1:\"1\";s:13:\"getkeyword_do\";s:1:\"1\";s:17:\"article_more_show\";s:1:\"1\";s:24:\"article_more_avoidgather\";s:1:\"1\";s:11:\"report_list\";s:1:\"1\";s:17:\"limitword_replace\";s:1:\"1\";s:13:\"copyfrom_list\";s:1:\"1\";s:17:\"googlemap_makemap\";s:1:\"1\";s:11:\"member_list\";s:1:\"1\";s:16:\"member_addmember\";s:1:\"1\";s:10:\"group_list\";s:1:\"1\";s:16:\"group_list_admin\";s:1:\"1\";s:9:\"group_add\";s:1:\"1\";s:14:\"ad_listAdPlace\";s:1:\"1\";s:13:\"ad_listuserad\";s:1:\"1\";s:6:\"sellad\";s:1:\"1\";s:15:\"sellad_listuser\";s:1:\"1\";s:7:\"js_list\";s:1:\"1\";s:14:\"limitword_list\";s:1:\"1\";s:15:\"attachment_list\";s:1:\"1\";s:9:\"area_list\";s:1:\"1\";s:14:\"moneycard_make\";s:1:\"1\";s:10:\"alipay_set\";s:1:\"1\";s:9:\"mail_send\";s:1:\"1\";s:12:\"message_send\";s:1:\"1\";s:15:\"style_editstyle\";s:1:\"1\";s:13:\"template_list\";s:1:\"1\";s:15:\"gather_copysina\";s:1:\"1\";s:11:\"gather_list\";s:1:\"1\";s:16:\"gather_list_sort\";s:1:\"1\";s:14:\"friendlink_mod\";s:1:\"1\";s:9:\"vote_list\";s:1:\"1\";s:9:\"hack_oicq\";s:1:\"1\";s:10:\"hack_login\";s:1:\"1\";s:11:\"hack_search\";s:1:\"1\";s:11:\"hack_webmsg\";s:1:\"1\";s:10:\"hack_count\";s:1:\"1\";s:9:\"hack_list\";s:1:\"1\";s:9:\"mysql_out\";s:1:\"1\";s:10:\"mysql_into\";s:1:\"1\";s:9:\"mysql_del\";s:1:\"1\";s:9:\"mysql_sql\";s:1:\"1\";s:11:\"form_module\";s:1:\"1\";s:12:\"form_content\";s:1:\"1\";s:9:\"code_code\";s:1:\"1\";s:8:\"cnzz_set\";s:1:\"1\";s:15:\"logs_login_logs\";s:1:\"1\";s:18:\"logs_admin_do_logs\";s:1:\"1\";}');
INSERT INTO `p8_group` VALUES ('4','1','ǰ̨Ա','0','0','0','','0','N;');
INSERT INTO `p8_group` VALUES ('8','0','ͨԱ','0','50','0','a:28:{s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:17:\"SearchArticleType\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"1\";s:14:\"SetSellArticle\";s:1:\"1\";s:13:\"SetSmallTitle\";s:1:\"1\";s:17:\"SetSpecialArticle\";s:1:\"1\";s:17:\"SetArticleKeyword\";s:1:\"1\";s:20:\"AddArticleKeywordNum\";s:1:\"0\";s:16:\"PostArticleYzImg\";s:1:\"1\";s:21:\"AddArticleCopyfromNum\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"1\";s:13:\"SetArticleTpl\";s:1:\"1\";s:18:\"SelectArticleStyle\";s:1:\"1\";s:18:\"SetArticlePosttime\";s:1:\"1\";s:18:\"SetArticleViewtime\";s:1:\"1\";s:16:\"SetArticleHitNum\";s:1:\"1\";s:18:\"SetArticlePassword\";s:1:\"1\";s:19:\"SetArticleDownGroup\";s:1:\"1\";s:19:\"SetArticleViewGroup\";s:1:\"1\";s:17:\"SetArticleJumpurl\";s:1:\"1\";s:19:\"SetArticleIframeurl\";s:1:\"1\";s:21:\"SetArticleDescription\";s:1:\"1\";s:16:\"SetArticleTopCom\";s:1:\"1\";s:17:\"CollectArticleNum\";s:2:\"30\";s:15:\"CreatSpecialNum\";s:1:\"7\";}','0','');
INSERT INTO `p8_group` VALUES ('9','0','߼Ա','10000','0','0','a:24:{s:17:\"SearchArticleType\";s:1:\"0\";s:16:\"PostArticleYzImg\";s:1:\"0\";s:14:\"PassContribute\";s:1:\"0\";s:13:\"EditPassPower\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:17:\"SetSpecialArticle\";s:1:\"0\";s:17:\"SetArticleKeyword\";s:1:\"0\";s:20:\"AddArticleKeywordNum\";s:0:\"\";s:21:\"AddArticleCopyfromNum\";s:0:\"\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:13:\"SetSmallTitle\";s:1:\"0\";}','0','');
INSERT INTO `p8_group_area` VALUES ('1','0','','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('2','0','Ϻ','1','19','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('3','0','','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('4','0','','1','40','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('5','0','ӱʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('6','0','ɽʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('7','0','ɹ','1','12','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('8','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('9','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('10','0','ʡ','1','13','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('11','0','ʡ','1','13','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('12','0','㽭ʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('13','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('14','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('15','0','ʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('16','0','ɽʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('17','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('18','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('19','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('20','0','㶫ʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('21','0','׳','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('22','0','ʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('23','0','Ĵʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('24','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('25','0','ʡ','1','16','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('26','0','','1','7','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('27','0','ʡ','1','10','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('28','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('29','0','ຣʡ','1','8','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('30','0','Ļ','1','5','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('31','0','½ά','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('32','0','̨ʡ','1','25','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('33','0','ر','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('34','0','ر','1','5','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('35','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('36','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('37','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('38','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('39','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('40','1','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('41','1','ʯɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('42','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('43','1','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('44','1','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('45','1','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('46','1','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('47','1','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('48','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('49','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('50','1','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('51','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('52','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('53','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('54','2','¬','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('55','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('56','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('57','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('58','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('59','2','բ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('60','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('61','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('62','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('63','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('64','2','ζ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('65','2','ֶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('66','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('67','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('68','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('69','2','ϻ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('70','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('71','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('72','3','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('73','3','Ӷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('74','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('75','3','Ͽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('76','3','ӱ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('77','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('78','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('79','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('80','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('81','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('82','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('83','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('84','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('85','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('86','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('87','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('88','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('89','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('90','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('91','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('92','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('93','4','ɿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('94','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('95','4','ɳƺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('96','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('97','4','ϰ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('98','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('99','4','ʢ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('100','4','˫','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('101','4','山','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('102','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('103','4','ǭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('104','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('105','4','뽭','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('106','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('107','4','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('108','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('109','4','ٲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('110','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('111','4','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('112','4','ǿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('113','4','ᶼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('114','4','潭','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('115','4','¡','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('116','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('117','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('118','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('119','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('120','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('121','4','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('122','4','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('123','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('124','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('125','4','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('126','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('127','4','ϴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('128','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('129','4','ϴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('130','5','ʯׯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('131','5','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('132','5','ػʵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('133','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('134','5','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('135','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('136','5','żҿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('137','5','е','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('138','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('139','5','ȷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('140','5','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('141','6','̫ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('142','6','ͬ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('143','6','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('144','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('145','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('146','6','˷','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('147','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('148','6','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('149','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('150','6','ٷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('151','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('152','7','ͺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('153','7','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('154','7','ں','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('155','7','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('156','7','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('157','7','˹','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('158','7','ױ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('159','7','׶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('160','7','첼','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('161','7','˰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('162','7','ֹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('163','7','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('164','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('165','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('166','8','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('167','8','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('168','8','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('169','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('170','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('171','8','Ӫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('172','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('173','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('174','8','̽','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('175','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('176','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('177','8','«','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('178','9','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('179','9','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('180','9','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('181','9','Դ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('182','9','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('183','9','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('184','9','ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('185','9','׳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('186','9','ӱ߳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('187','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('188','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('189','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('190','10','׸','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('191','10','˫Ѽɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('192','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('193','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('194','10','ľ˹','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('195','10','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('196','10','ĵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('197','10','ں','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('198','10','绯','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('199','10','˰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('200','11','Ͼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('201','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('202','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('203','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('204','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('205','11','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('206','11','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('207','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('208','11','γ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('209','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('210','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('211','11','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('212','11','Ǩ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('213','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('214','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('215','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('216','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('217','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('218','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('219','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('220','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('221','12','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('222','12','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('223','12','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('224','13','Ϸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('225','13','ߺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('226','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('227','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('228','13','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('229','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('230','13','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('231','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('232','13','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('233','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('234','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('235','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('236','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('237','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('238','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('239','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('240','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('241','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('242','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('243','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('244','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('245','14','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('246','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('247','14','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('248','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('249','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('250','15','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('251','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('252','15','Ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('253','15','Ž','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('254','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('255','15','ӥ̶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('256','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('257','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('258','15','˴','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('259','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('260','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('261','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('262','16','ൺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('263','16','Ͳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('264','16','ׯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('265','16','Ӫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('266','16','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('267','16','Ϋ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('268','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('269','16','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('270','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('271','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('272','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('273','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('274','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('275','16','ĳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('276','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('277','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('278','17','֣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('279','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('280','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('281','17','ƽɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('282','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('283','17','ױ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('284','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('285','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('286','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('287','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('288','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('289','17','Ͽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('290','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('291','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('292','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('293','17','ܿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('294','17','פ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('295','18','人','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('296','18','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('297','18','ʮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('298','18','˲','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('299','18','差','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('300','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('301','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('302','18','Т','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('303','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('304','18','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('305','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('306','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('307','18','ʩ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('308','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('309','18','Ǳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('310','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('311','18','ũ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('312','19','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('313','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('314','19','̶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('315','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('316','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('317','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('318','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('319','19','żҽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('320','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('321','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('322','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('323','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('324','19','¦','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('325','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('326','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('327','20','ع','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('328','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('329','20','麣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('330','20','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('331','20','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('332','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('333','20','տ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('334','20','ï','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('335','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('336','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('337','20','÷','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('338','20','β','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('339','20','Դ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('340','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('341','20','Զ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('342','20','ݸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('343','20','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('344','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('345','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('346','20','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('347','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('348','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('349','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('350','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('351','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('352','21','Ǹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('353','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('354','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('355','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('356','21','ɫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('357','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('358','21','ӳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('359','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('360','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('361','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('362','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('363','22','ָɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('364','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('365','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('366','22','Ĳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('367','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('368','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('369','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('370','22','Ͳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('371','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('372','22','ٸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('373','22','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('374','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('375','22','ֶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('376','22','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('377','22','ͤ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('378','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('379','22','ɳȺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('380','22','ɳȺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('381','22','ɳȺĵ亣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('382','23','ɶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('383','23','Թ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('384','23','֦','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('385','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('386','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('387','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('388','23','Ԫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('389','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('390','23','ڽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('391','23','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('392','23','ϳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('393','23','üɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('394','23','˱','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('395','23','㰲','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('396','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('397','23','Ű','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('398','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('399','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('400','23','ӲǼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('401','23','β','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('402','23','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('403','24','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('404','24','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('405','24','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('406','24','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('407','24','ͭʵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('408','24','ǭϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('409','24','Ͻڵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('410','24','ǭ嶱','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('411','24','ǭϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('412','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('413','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('414','25','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('415','25','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('416','25','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('417','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('418','25','˼é','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('419','25','ٲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('420','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('421','25','ӹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('422','25','ɽ׳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('423','25','˫ɴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('424','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('425','25','º徰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('426','25','ŭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('427','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('428','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('429','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('430','26','ɽϵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('431','26','տ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('432','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('433','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('434','26','֥','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('435','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('436','27','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('437','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('438','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('439','27','μ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('440','27','Ӱ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('441','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('442','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('443','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('444','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('445','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('446','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('447','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('448','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('449','28','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('450','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('451','28','Ҵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('452','28','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('453','28','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('454','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('455','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('456','28','¤','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('457','28','Ļ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('458','28','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('459','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('460','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('461','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('462','29','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('463','29','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('464','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('465','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('466','29','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('467','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('468','30','ʯɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('469','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('470','30','ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('471','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('472','31','³ľ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('473','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('474','31','³','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('475','31','ܵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('476','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('477','31','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('478','31','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('479','31','յ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('480','31','տ¶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('481','31','ʲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('482','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('483','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('484','31','ǵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('485','31','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('486','31','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('487','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('488','31','ͼľ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('489','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('490','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('491','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('492','32','¡','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('493','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('494','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('495','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('496','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('497','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('498','32','԰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('499','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('500','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('501','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('502','32','û','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('503','32','Ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('504','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('505','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('506','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('507','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('508','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('509','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('510','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('511','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('512','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('513','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('514','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('515','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('516','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('517','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('518','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('519','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('520','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('521','33','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('522','33','ƴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('523','33','ͼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('524','33','뵺','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('525','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('526','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('527','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('528','33','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('529','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('530','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('531','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('532','33','Ԫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('533','34','л','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('534','34','ʥ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('535','34','д','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('536','34','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_area` VALUES ('537','34','з˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `p8_group_class` VALUES ('1','0','Ȧ','1','0','0','0','','','','','');
INSERT INTO `p8_group_class` VALUES ('2','0','˿Ȧ','1','0','0','0','','','','','');
INSERT INTO `p8_group_class` VALUES ('3','0','ȤȦ','1','0','0','0','','','','','');
INSERT INTO `p8_group_class` VALUES ('12','0','Ϸ','1','0','0','0','','','','','');
INSERT INTO `p8_group_config` VALUES ('module_pre','group_','');
INSERT INTO `p8_group_config` VALUES ('module_style','35cn','');
INSERT INTO `p8_group_config` VALUES ('moduleDomain','','');
INSERT INTO `p8_group_config` VALUES ('AllowUseUser','1','');
INSERT INTO `p8_group_config` VALUES ('group_UpPhoto','3,4,8','');
INSERT INTO `p8_group_config` VALUES ('upPicNeedMoney','1','');
INSERT INTO `p8_group_config` VALUES ('uploadPhotoNum','50','');
INSERT INTO `p8_group_config` VALUES ('JoinNum','4','');
INSERT INTO `p8_group_config` VALUES ('allowDisband','1','');
INSERT INTO `p8_group_config` VALUES ('createNum','3','');
INSERT INTO `p8_group_config` VALUES ('BBSforbidGroupUse','1,2,6,7','');
INSERT INTO `p8_group_config` VALUES ('allowCreate','1','');
INSERT INTO `p8_group_config` VALUES ('createMoney','0','');
INSERT INTO `p8_group_config` VALUES ('MoneyDW','','');
INSERT INTO `p8_group_config` VALUES ('MoneyName','վ','');
INSERT INTO `p8_group_config` VALUES ('UseMoneyType','cms','');
INSERT INTO `p8_group_config` VALUES ('forbidGroupUse','2','');
INSERT INTO `p8_group_config` VALUES ('module_id','8','');
INSERT INTO `p8_group_config` VALUES ('showToolbar','1','');
INSERT INTO `p8_group_config` VALUES ('close_module','0','');
INSERT INTO `p8_group_config` VALUES ('blogurl','../blog','');
INSERT INTO `p8_group_config` VALUES ('fname','Ȧ','');
INSERT INTO `p8_group_config` VALUES ('web_name','ȦƵ','');
INSERT INTO `p8_group_config` VALUES ('forbidDomain','admin\r\nbbs','');
INSERT INTO `p8_group_config` VALUES ('Module_rollmsg','ӭҽһԼȤȦ!!','');
INSERT INTO `p8_group_forum_reply` VALUES ('1','1','1','1','1218704914','1','php168','127.0.0.1','ʱ8141430֣29˻Сֱйӭս޹ھӡڴǰսԸⳡй˵һ֮սйֻ¶ֲܱסߵϣ \n\n\nȻûʤйڶӵдԼˮƽƣ״̬һһá󰲸ӣйӿִһ14-2׽ڹ13֡ڶڱйӵʧ࣬Ͷʼ½⿪ʼ׷ϱȷ֣ϰ볡󰲸2֡°볡ʼйӴһ12-2Ľ¶ƣйսʤⳡսԺΪϸ\n\n');
INSERT INTO `p8_group_forum_reply` VALUES ('2','1','2','1','1218705135','1','php168','127.0.0.1','ѶѶʱ88վݡdailybreezeıѾйԱþһΪĺͬһ¡ҲԴ֤ʵ֮ýΪ̴ۤ͡Ҧ׽󣬵λʽ½NBAйԱ\n\nӹٷԼ-˱ʾϣڽȥʱǩʽͬϣܺܿ㶨һС˵\n\n69磨205212߳Լ䲻쵼ܣñΪйħʦʵڵڶֵ40λѡУֻǵʱӲδǩԼĿǰ׷ҶΪսİ׼\n\nõǩԼҲй֮֮սһ㣺Ʊչһ˵±ȡʵϺǩԼ֮ףڽļѵӪʱܾп˾̬ƣǩԼӽļƻ֮һ\n\nں˵õļ˽ǿӵĺȡʲ油չȻߵԵʣҲԳε÷ֺ⣬ѾϿĶӿƱ-Լǻǩ·˹ǴѧԱά-жӴѡе-͸£ĿǰδǩԼ\n\nǿ⣬˻ϣС㰲³-ķڰķ8000ԪԼ5Ҫ󣬺ܾпδͷϣܹ۲һ°ķ˲ָ\n\n');
INSERT INTO `p8_group_forum_reply` VALUES ('3','1','3','1','1218705207','1','php168','127.0.0.1','ѶѶȻԶΪõʹۻ̩˹صĪ׸߳޸裬ǹȴΪǲʽ׵Ӯҡʱ85գ۷䱨ָܹð̩˹ػ-ܿѷ-Լ2009ֵѡȨһʻ \n\n\n̩˹2009ͽΪԱܹ뿪֮ǰ任һḻϽδ֮ǣֺĳ㣩һĽ \n\n\n̩˹صʵڷӹɣڼ˹ĵһɱ뼾ѾûʲôǱฺ۶ӵҲõӰ졣ۺϷ̩˹ܹΪӹ׵Ѿǳˡ \n\n\nȥӿԷֽؽԱõĶᣬλõĿȱʹǸҲԻ˵õһʮԱǸʸȥܹھʵϣһ֧Ҧٵ̩˹ؽһŸнĸԱֵĹԱΪ̩˹굽ڵĺͬˡǵԼҪô㰢̩˹صθڡ \n\n\nǣԹ˵ӵ״Ҫֹ۵Ķࡣ2010죬1225ԪĲ-ա855ԪĿ-˹Լ660Ԫİ-ϣķĺͬڡʱӳӵдʵнռ⣬ӵп--Ա⣬ԹĿǰݣӼϣѡ˳λ㡣Ƕ̩˹صĽ׶Թ˵ǳֵġƷɣ\n\n');
INSERT INTO `p8_group_forum_reply` VALUES ('4','1','4','1','1218705362','1','php168','127.0.0.1','ѶѶʱ83գݡ˹ؼ±ϢҦÿʱÿ̵ظͬѵ̤ոһյĽеϰӲذ긴һƲһйĵ˶Ա˵ѹһ١ \n\n\nѹڼ磬ҵұҦ˵˵һصݣǺܶԱûе顣NBAõӮܹھǾõ顣 \n\n\nҦ˵˻ᣬֵȴǹʱ룬ڼſΪЧҲҵְڡʱȫĿⶼڱıϣйһ˶ \n\n\nϾеʯıУҦʱܹ׵ͳνЩʱԵ㡣ҸеƣҦ˵ֻ˵ֻ60%-70%ҿ϶ܹμӰ˻ᣬҲᴦѾ״̬˸еź \n\n\nҦʾμӵһ˻ˡǵΣμӰ˻ᣩ˵2000Ϥ˻ϣһСŹҶӲμ˰˻ı2004ŵ˻ᣬҲμˡڣ˻ڼſڣ⽫һЩ㹻ˣΪʲôҪȥ׶زμ2012İ˻أ \n\n\n2000ϤᣬҦ״γڰ˻ϣ2004ŵ䣬ҦٵĳΪй˴ӵ֡һϵҫҦ˵ִʱоȫϣȻҲܵǵҼNBAڻعμӰ˻ᣬÿһ춼ܵѹһּȵĹע \n\n\nɻ\n\n');
INSERT INTO `p8_group_forum_reply` VALUES ('5','1','5','1','1218705425','1','php168','127.0.0.1','ѶѶ֮սʤ˹ıУȷɭ-°볡Ϲۣ油з沨ʲĳʱȻ»Ҫӵ춨ʤֵʱﳡнһʱ85գESPNȻ֮ڰ˻ڼݲʲô仯ͨĿ죬KѾԽڹؼʱȷ廢֮Ա \n\n\n֮ӽӭ˻ǰһ֡Ĵ½ȷУпܻһһڹؼʱ̱ѩء֮˹ ı֮мʼµĳʱ䣬K˼ҪһίĴʱƱȼ˵ػش𵽣ˡ \n\n\nƱȵĴȻֱףȴǳ͹ۡ˹-޺͵¡-ķ˹ʮͻƣȻܹΪЧƽŷӵǰKϰ߽ʹãһ У൥ݵʱ䣬¡˵ڶں͵Ľڣ°볡ʼƱȡղķ˹һͬ ڳϣȫ˶̶9ӵĳʱ䡣ܿʼİ˻ ޺͵¡ԽϷһλ󲿷ֵĳʱ䡣 \n\n\nзλϣ油ԱҲԽԽܵһK˲ʲı֣ʹ17ӵĳʱһ嶼ûץĿǰ״ ֮СǿĶ֡ʱҷȶĲʲڹؼĵĽڵԿ-Ρ \n\n\n̸油ԱͲܲ»-Τµı֮֮֡ǰĳУܹΪӹ17.0֡3.0塢2.5 Լ2.3ϣʸǴﵽ˾˵74.3%ٲȻѾΪ֮ϬĹƾı֣ΤҲѾΪKĩгԱƷɣ\n');
INSERT INTO `p8_group_forum_reply` VALUES ('6','1','6','1','1218705459','1','php168','127.0.0.1','ѶϺս84ղûиɻʱ䣬˹ۿͿˡĦԡ⣬ֱοϺͯҽԺסԺƵĴͯ·ļƵٰսƼβƻᡣЩжԱμӣǷֱɳ3-4ͷж\n\nڱʱ48㿪ʼĴƼβƻᣬϺдƻȫ֧֣طϣͨĴؽƻϺдƻרԳйѵĶͯϺ᳤ܻʾš͸ķʽЩʽ𡣳ϯļαϺ᳤nbaйִܲóܾ.ȡ\n\n.ʾĹһֱػĶӦþǹעͰҪĵĶ֪ĴӰ޴Ǳһ˵ĸϺڼ䣬һϵйжڵ֡\n\n8ʱΰ˶ӶԱǣΤ¡ʲ\n\nȽǿƱն˹ıսۺսѥ־ģձһλ65ǧԪҸ߼ĵá\n');
INSERT INTO `p8_group_forum_reply` VALUES ('7','1','7','1','1218705484','1','php168','127.0.0.1','»84հר磨޴ҦǸз棬йӺܴİǣ˭¸ռơ㣬ûд𰸣Ϊĸ˽ⲻࡣ¹з濨4յķѵ˵й¹ӵİ˻˭ƣǰͬûд𰸡 \n\n\n¹4ڱƥݽ˷ѵŵάĻͿΣ£ǳΪý۽¹Ľ㡣з濨ڣΣ£ɼ촬ӵıֲףڵ¹Ҳǹûļʹŵǿ֧֣ڰѡɱΧӡӡӡϣӺйʦ˻С \n\n\nǣİ֮·ƽ̹游ǵ¹ˣڵ¹߲Աİ£Դ¹ʸԴ½ϸۣ׼¹μӰ˻ᡣ \n\n\nҦǸܳɫԱܶвźǸ֮䲢Ϥû̫ĽӴ˽⣡˵Ҧ˲ûĶԿ˭¸ƣֻǸδ֪ǰУйֻսʤ͵¹СʵһĶֲܽǰˡڵ¹й֧ȡʤƸ󣬿˵κӶпܴ֣ܶûνľƣֻܽ \n\n\n¹Сս810ӭսӣ18սСһΰ˶ӡй816ӭս¹ӣҦ뿨ĶԿΪĽ㡣 \n\n');
INSERT INTO `p8_group_forum_reply` VALUES ('8','1','8','1','1218705528','1','php168','127.0.0.1','Ŀǰμ08˵Ѿȷ9֧ѡ12ǿҲˮʯĶ2008걱˻᳹ԵԵ˵аܶNBAǣ˵Ǹźھоٳеʮλ\n\n1.   Ч̶ ǳź08˵ĴѾλܾMVPرˣ޷ڱϼʶС˧ʵһ¡ŷ޸ǿӵΧ£ķõѡܲμӡȻŷϣų20.1ֵ֣ȴûܽĺź֡ \n\n');
INSERT INTO `p8_group_forum_reply` VALUES ('9','1','9','1','1218705598','1','php168','127.0.0.1','ѶʷϺ ʱ200884գϺս˻ʱȡ˹ѵNBAǲδϢƱ ءղ ղķ˹÷¡ ᡢ˹ λΰˡǳϯǴԵƷͿ˵ġĦԡ䣬Ʊ硰ͷ硱һˣ \n\n\nƱȣƱȡƱȣߵڹۿͿ2008ĦԡܾͬʱλǵӰȴһСʱ󣬿Ʊȡղķ˹ͱޡ˻شӶϽ䣬˫ֻǰ΢ЦؽԵļ \n\n\n˳ʱᰮͷĻղķ˹ͰᣬһͳĺһԵĿƱҲЦˡܵƱʱȫ뺰Ʊȵ֣ղķ˹ͰҲš塱ùſƱȵ֣ССıѹŻͲ͵͵šMVPΪһǰΰսʤ˹ʱƱȵѡóMVP󣬵ίȤǣμӿĵڶλԱһ˵ԼǿƱȺղķ˹ԣ׼ʱ˵ҪǩƱȻӦʡ˳ҡõھСնڵλСԱͳǩȴղķ˹Сʵ͸һ˫ԼǩЬ \n\n\nǹۿʱƱѹסͷղķ˹ᡢ޴ʱʼǵĬУ֧ӣҪղķ˹ְ֧׶ӣҪPKһ¡ǣԭǿ͵ˣڳȴƤӡ׶һֱȣղķ˹ʱʱطŷŷĹű򰲶ʩơһΣʾ׶ӻ߷棬ղķ˹ִУʾѾԷԱˣӦ㷸棬ߵղķ˹ߣ˵Ｘ󣬲ͬղķ˹Ĺ۵㣬׶Աųɶߵղķ˹лҲʾһ׶ӷ棬ֳƿ죬ӷ칥ʱҡָͷһЦղķ˹ơ \n\n\nҲʼį̫࣬顰ӵгȥͶͶо20֡нĽ飬ϧӵͶδСһֱڳ߿СֵˣĿƱȣʱҲ롰ҡУʾӦûˣÿ˶ϳ򣬹ȻȻˡһձˣ̨\n\n');
INSERT INTO `p8_group_forum_topic` VALUES ('1','Ҧȫͳ й𰲸ʤ','1','0','3','0','1218704914','1','php168','0','0','0','0','');
INSERT INTO `p8_group_forum_topic` VALUES ('2','ͬǩԼ йħʦ½NBA','1','0','1','0','1218705135','1','php168','0','0','0','0','');
INSERT INTO `p8_group_forum_topic` VALUES ('3','׳ ư̩׬','1','0','1','0','1218705207','1','php168','0','0','0','0','');
INSERT INTO `p8_group_forum_topic` VALUES ('4','Ҧѹ 08ֳ׸','1','0','1','0','1218705362','1','php168','0','0','0','0','');
INSERT INTO `p8_group_forum_topic` VALUES ('5','֮油 ĩݲǿ','1','0','1','0','1218705425','1','php168','0','0','0','0','');
INSERT INTO `p8_group_forum_topic` VALUES ('6','ΰϺٰ Ʊװĳ65ǧԪ','1','0','1','0','1218705459','1','php168','0','0','0','0','');
INSERT INTO `p8_group_forum_topic` VALUES ('7','ҦǸɫԱ ڴ״ζԿ','1','0','1','0','1218705484','1','php168','0','0','0','0','');
INSERT INTO `p8_group_forum_topic` VALUES ('8','ͼʮԵ˵NBA 4ͬѡ','1','0','1','0','1218705528','1','php168','0','0','0','0','');
INSERT INTO `p8_group_forum_topic` VALUES ('9','ΰľͷ Ħԡˣ','1','0','1','0','1218705598','1','php168','0','0','0','0','');
INSERT INTO `p8_group_group` VALUES ('1','php168','1','1','1218704834','1','','35','','NBA˿Ⱥ','','1','rollmsg,intro,visitor|bbs,photo','1','','ֻҪϲ򶼻ӭӽ!!','ϲ˶!!','','Ȧҳ	index.php		\r\n	listbbs		\r\nͼƬ	listphoto		\r\nԱͨ¼	listaddress		\r\n	trade		','','','','2','0','','','','','','','','','1','50','1218707892','1','1218706500','0','220','1	php168	1218707892','0','0','0','0','1','1','1','1','9','0','12');
INSERT INTO `p8_group_member` VALUES ('1','1','php168','1','3','1218704834','0','0');
INSERT INTO `p8_group_photo_pic` VALUES ('1','ʮ󽹵սۣս Ҧ׵±ѡ','0','','0','','0','3','0','1218705723','1218705723','1','1','php168','','0','http://img1.qq.com/sports/pics/12150/12150160.jpg','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://img1.qq.com/sports/pics/12150/12150160.jpg','1218705737','','0','');
INSERT INTO `p8_group_photo_pic` VALUES ('2','á澭ɵΰ ǲǲսʤ','0','','0','','0','1','0','1218705773','1218705773','1','1','php168','','0','http://img1.qq.com/2008/pics/12139/12139854.jpg','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://img1.qq.com/2008/pics/12139/12139854.jpg','1218705774','','0','');
INSERT INTO `p8_group_photo_pic` VALUES ('3','̵ʮ󱻡 ΪЧˣ','0','','0','','0','1','0','1218705821','1218705821','1','1','php168','','0','http://img1.qq.com/2008/pics/12139/12139732.jpg','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://img1.qq.com/2008/pics/12139/12139732.jpg','1218705822','','0','');
INSERT INTO `p8_group_photo_pic` VALUES ('4','ΰ˱ǰܶ μӱֻΪ','0','','0','','0','1','0','1218705885','1218705885','1','1','php168','','0','http://img1.qq.com/2008/pics/12088/12088167.jpg','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://img1.qq.com/2008/pics/12088/12088167.jpg','1218705886','','0','');
INSERT INTO `p8_group_photo_pic` VALUES ('5','̩˹ش仯 ڱòңԶ','0','','0','','0','2','0','1218705997','1218705997','1','1','php168','','0','http://img1.qq.com/sports/pics/12086/12086481.jpg','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://img1.qq.com/sports/pics/12086/12086481.jpg','1218705998','','0','');
INSERT INTO `p8_group_photo_pic` VALUES ('6','Ҧ¼ǲǸǹͱ(ͼ)','0','','0','','0','3','0','1218706023','1218706023','1','1','php168','','0','http://img1.qq.com/sports/pics/12086/12086347.jpg','1','','0','1','1218706587','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://img1.qq.com/sports/pics/12086/12086347.jpg','1218707381','','0','');
INSERT INTO `p8_group_photo_pic` VALUES ('7','AT̩˹ ǿԮҰ޳ƺ','0','','0','','0','3','0','1218706043','1218706043','1','1','php168','','0','http://img1.qq.com/sports/pics/12049/12049803.jpg','1','','0','1','1218706586','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://img1.qq.com/sports/pics/12049/12049803.jpg','1218707261','','0','');
INSERT INTO `p8_group_photo_pic` VALUES ('8','ʮͷ ʵ','0','','0','','0','3','0','1218706227','1218706227','1','1','php168','','0','http://img1.qq.com/sports/pics/12039/12039017.jpg','1','','0','1','1218706585','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://img1.qq.com/sports/pics/12039/12039017.jpg','1218707265','','0','');
INSERT INTO `p8_group_photo_pic` VALUES ('9','Ī׽̵㣺˹Ϊֵ ̩ƾ','0','','0','','0','1','0','1218706252','1218706252','1','1','php168','','0','http://img1.qq.com/sports/pics/11990/11990532.jpg','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://img1.qq.com/sports/pics/11990/11990532.jpg','1218706252','','0','');
INSERT INTO `p8_group_photo_pic` VALUES ('10','̵Ҧʮ ʲôֹΰ?','0','','0','','0','1','0','1218706276','1218706276','1','1','php168','','0','http://img1.qq.com/sports/pics/11963/11963600.jpg','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://img1.qq.com/sports/pics/11963/11963600.jpg','1218706277','','0','');
INSERT INTO `p8_group_photo_pic` VALUES ('11','ԱԼ۱ֵ ѹҦ','0','','0','','0','1','0','1218706411','1218706411','1','1','php168','','0','http://img1.qq.com/sports/pics/11937/11937458.jpg','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://img1.qq.com/sports/pics/11937/11937458.jpg','1218706411','','0','');
INSERT INTO `p8_group_photo_pic` VALUES ('12','˹ΰ˴׷ ͳ','0','','0','','0','1','0','1218706435','1218706435','1','1','php168','','0','http://img1.qq.com/sports/pics/11901/11901180.jpg','1','','0','0','0','','','','','','','','0','0','127.0.0.1','0','0','','','0','0','0','','http://img1.qq.com/sports/pics/11901/11901180.jpg','1218706436','','0','');
INSERT INTO `p8_group_photo_sort` VALUES ('1','0','ͨ','1','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;}','0');
INSERT INTO `p8_group_photo_sort` VALUES ('2','0','','1','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;}','0');
INSERT INTO `p8_group_photo_sort` VALUES ('3','0','仳','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_group_photo_sort` VALUES ('4','0','Ȼ羰','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_group_photo_sort` VALUES ('5','0','ż','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_group_photo_sort` VALUES ('6','0','ɸЦ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_group_photo_sort` VALUES ('7','0','ʵ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_group_photo_sort` VALUES ('8','0','ɫ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_group_photo_sort` VALUES ('9','0','ҵ','1','0','0','','0','0','','','','','','','0','','','1','','','','','0','','0');
INSERT INTO `p8_hack` VALUES ('oicq','QQ','0','','a:4:{s:8:\"qq_style\";s:2:\"11\";s:7:\"pic_alt\";s:10:\"µ\";s:6:\"qq_num\";s:19:\"121727818\r\n37352529\";s:8:\"web_name\";s:10:\"PHP168վ\";}','<a target=blank href=\'tencent://message/?uin=121727818&Site=PHP168վ&Menu=yes\'><img border=\'0\' SRC=\'http://wpa.qq.com/pa?p=1:121727818:11\' alt=\'µ\'></a><br><br><a target=blank href=\'tencent://message/?uin=37352529&Site=PHP168վ&Menu=yes\'><img border=\'0\' SRC=\'http://wpa.qq.com/pa?p=1:37352529:11\' alt=\'µ\'></a><br><br>','','','index.php?lfj=hack&hack=oicq&job=edit','');
INSERT INTO `p8_hack` VALUES ('login','û¼','0','','a:3:{s:10:\"systemType\";s:6:\"php168\";s:9:\"guestcode\";s:809:\"<table width=\\\"100%\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\"> <form name=\\\"form1\\\" method=\\\"post\\\" action=\\\"$webdb[www_url]/login.php\\\">        <tr>            <td><span class=\\\'L_passport\\\'>&nbsp;֤ͨ |</span><span class=\\\"L_name\\\"> ʺţ<input type=\\\"text\\\" name=\\\"username\\\" class=\\\"login_name\\\"></span><span class=\\\"L_pwd\\\"> 룺<input type=\\\"password\\\" name=\\\"password\\\" class=\\\"login_pwd\\\"></span><span class=\\\"L_sub\\\"> <input type=\\\"submit\\\" name=\\\"Submit\\\" value=\\\"¼\\\" class=\\\"login_sub\\\"></span><span class=\\\"L_reg\\\"> <a href=\\\"$webdb[www_url]/reg.php\\\">ע</a> | <a href=\\\"$webdb[www_url]/login.php\\\">¼</a></span></td><input type=\\\"hidden\\\" name=\\\"step\\\" value=\\\"2\\\"><input class=\\\"radio\\\" type=\\\"hidden\\\" name=\\\"cookietime\\\" value=\\\"86400\\\" >        </tr></form>      </table>\";s:10:\"membercode\";s:701:\"<table width=\\\"100%\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" height=\\\"20\\\">        <tr>           <td align=\\\"left\\\" style=\\\"padding-top:4px;\\\"><span class=\\\"L2_name\\\">&nbsp;ӭ:<a style=\\\"color:#FF0000;\\\">$lfjid</a></span><span class=\\\\\\\"L2_msg\\\\\\\"> $MSG </span><span class=\\\"L2_info\\\"> <a href=\\\"$webdb[www_url]/member/index.php?main=myarticle.php\\\" target=\\\"_blank\\\">ҵ</a> <a href=\\\"$webdb[www_url]/member/\\\" target=\\\"_blank\\\">Ϣ</a></span><span class=\\\"L2_out\\\"> <a href=\\\"$webdb[www_url]/member/index.php?main=userinfo.php?job=edit\\\" target=\\\"_blank\\\">޸</a> <a href=\\\"$webdb[www_url]/login.php?action=quit\\\">ȫ˳</a></span></td>        </tr>      </table>\";}','','','','index.php?lfj=hack&hack=login&job=list','');
INSERT INTO `p8_hack` VALUES ('search','','0','','a:2:{s:10:\"systemType\";s:6:\"web168\";s:10:\"searchcode\";s:456:\"<table width=\\\"100%\\\" cellpadding=\\\"0\\\" cellspacing=\\\"0\\\" border=\\\"0\\\">\r\n  <form name=\\\"formsearch\\\" method=\\\"post\\\" action=\\\"$webdb[www_url]/search.php\\\">\r\n    <tr> \r\n      <td height=\\\"14\\\"> ؼ:<input type=\\\"text\\\" name=\\\"keyword\\\" size=\\\"10\\\">\r\n        <input type=\\\"submit\\\" name=\\\"Submit32\\\" value=\\\"\\\">\r\n        <input type=\\\"hidden\\\" name=\\\"searchTable\\\" value=\\\"article\\\">\r\n      </td>\r\n    </tr>\r\n   \r\n  </form>\r\n</table>\r\n                \";}','','','','index.php?lfj=hack&hack=search&job=list','');
INSERT INTO `p8_hack` VALUES ('webmsg','վͳϢ','0','PHP168Ŷ','a:3:{s:7:\"tplcode\";s:491:\"<table width=\\\"100%\\\" cellpadding=\\\"0\\\" cellspacing=\\\"0\\\" border=\\\"0\\\" id=\\\"webmsg\\\">\r\n     <tr> \r\n      <td height=\\\"14\\\">: {$article_num} ƪ</td>\r\n    </tr>\r\n    <tr> \r\n      <td height=\\\"7\\\" >Ŀ: {$sort_num} </td>\r\n    </tr>\r\n    <tr> \r\n      <td height=\\\"7\\\" >: {$comment_num} </td>\r\n    </tr>\r\n	 <tr> \r\n      <td height=\\\"7\\\" >ÿ: {$guestbook_num} </td>\r\n    </tr>\r\n    <tr>\r\n      <td height=\\\"7\\\" >עԱ: {$member_num} λ</td>\r\n    </tr>\r\n</table>\";s:6:\"cktime\";s:2:\"60\";s:6:\"system\";a:3:{s:7:\"article\";s:1:\"1\";s:4:\"sort\";s:1:\"1\";s:10:\"memberdata\";s:1:\"1\";}}','','','','index.php?lfj=hack&hack=webmsg&job=list','');
INSERT INTO `p8_hack` VALUES ('count','ͳ','0','','','','','','index.php?lfj=hack&hack=count&job=list','');
INSERT INTO `p8_label` VALUES ('1','','1','0','rollpic','article','1','a:21:{s:3:\"SYS\";s:7:\"artcile\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"188\";s:6:\"DivTpl\";s:1:\"0\";s:5:\"fiddb\";N;s:5:\"stype\";s:7:\"rollpic\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";s:1:\"0\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:90:\" SELECT A.* FROM p8_article A  WHERE A.yz=1  AND A.ispic=1   ORDER BY A.list DESC LIMIT 5 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"248\";s:5:\"div_h\";s:3:\"187\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218537088','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('262','','1','0','list_pic','article','1','a:21:{s:9:\"tplpart_1\";s:401:\"<div  class=\"listpic\" style=\"margin-right:0px;margin-left:3px;padding-left:0px;padding-right:3px;\"> \r\n              <p class=img><a href=\"$url\" target=\"_blank\"><img width=\"120\" height=\"90\" onload=\"makesmallpic(this,120,90);\" src=\"$picurl\" border=\"0\"></a></p>\r\n              <p class=title style=\'text-align:center;\'><A HREF=\"$url\" title=\'$full_title\' target=\"_blank\">$title</A></p>\r\n            </div>\";s:13:\"tplpart_1code\";s:485:\"<div  class=\"listpic\" style=\"margin-right:0px;margin-left:3px;padding-left:0px;padding-right:3px;\"> \r\n              <p class=img><a href=\"$webdb[www_url]/bencandy.php?fid=$fid&aid=$aid\" target=\"_blank\"><img width=\"120\" height=\"90\" onload=\"makesmallpic(this,120,90);\" src=\"$picurl\" border=\"0\"></a></p>\r\n              <p class=title style=\'text-align:center;\'><A HREF=\"$webdb[www_url]/bencandy.php?fid=$fid&aid=$aid\" title=\'$full_title\' target=\"_blank\">$title</A></p>\r\n            </div>\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";s:46:\"$webdb[www_url]/bencandy.php?fid=$fid&aid=$aid\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:6:\"DivTpl\";s:1:\"1\";s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"6\";s:2:\"yz\";s:1:\"1\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:90:\" SELECT A.* FROM p8_article A  WHERE A.yz=1  AND A.ispic=1   ORDER BY A.list DESC LIMIT 7 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','111111','1182675757','0','0','0','0','');
INSERT INTO `p8_label` VALUES ('181','','1','0','topnews','Info_news_','1','a:22:{s:9:\"tplpart_1\";s:113:\"<A HREF=\"$url\" target=\'_blank\'  style=\'text-decoration: underline;color:$titlecolor\'>$title</a> ($posttime)<br>\";s:13:\"tplpart_1code\";s:113:\"<A HREF=\"$url\" target=\'_blank\'  style=\'text-decoration: underline;color:$titlecolor\'>$title</a> ($posttime)<br>\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:11:\"content_num\";s:2:\"80\";s:6:\"DivTpl\";s:1:\"1\";s:5:\"fiddb\";N;s:8:\"moduleid\";s:0:\"\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"11\";s:3:\"sql\";s:88:\" SELECT A.* FROM p8_news_content A   WHERE 1  AND A.yz=1  ORDER BY A.list DESC LIMIT 11 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"50\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"307\";s:5:\"div_h\";s:3:\"209\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218722154','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('151','','1','0','articlesort','code','0','<script src=\"jsarticle.php?fid=0&type=sonfid&rows=15\"></script>','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','111111','0','0','0','0','0','');
INSERT INTO `p8_label` VALUES ('152','','1','0','hotarticle','article','1','a:23:{s:9:\"tplpart_1\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:13:\"tplpart_1code\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:3:\"SYS\";s:7:\"artcile\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";N;s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:6:\"DivTpl\";s:1:\"1\";s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";s:1:\"0\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:7:\"default\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:49:\" SELECT A.* FROM p8_article A  WHERE 1   LIMIT 7 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:8:\"titlenum\";s:2:\"34\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218536835','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('163','','1','0','listpic','article','1','a:22:{s:9:\"tplpart_1\";s:357:\"<div  class=\"listpic\" style=\"padding:3px 2px 3px 4px;\"> \r\n              <p class=img><a href=\"$url\" target=\"_blank\"><img width=\"120\" height=\"90\" onload=\"makesmallpic(this,120,90);\" src=\"$picurl\" border=\"0\"></a></p>\r\n              <p class=title style=\'text-align:center;\'><A HREF=\"$url\" title=\'$full_title\' target=\"_blank\">$title</A></p>\r\n            </div>\";s:13:\"tplpart_1code\";s:441:\"<div  class=\"listpic\" style=\"padding:3px 2px 3px 4px;\"> \r\n              <p class=img><a href=\"$webdb[www_url]/bencandy.php?fid=$fid&aid=$aid\" target=\"_blank\"><img width=\"120\" height=\"90\" onload=\"makesmallpic(this,120,90);\" src=\"$picurl\" border=\"0\"></a></p>\r\n              <p class=title style=\'text-align:center;\'><A HREF=\"$webdb[www_url]/bencandy.php?fid=$fid&aid=$aid\" title=\'$full_title\' target=\"_blank\">$title</A></p>\r\n            </div>\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";s:46:\"$webdb[www_url]/bencandy.php?fid=$fid&aid=$aid\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:6:\"DivTpl\";s:1:\"0\";s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"6\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";s:1:\"0\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:90:\" SELECT A.* FROM p8_article A  WHERE A.yz=1  AND A.ispic=1   ORDER BY A.list DESC LIMIT 7 \";s:7:\"colspan\";s:1:\"7\";s:11:\"content_num\";s:2:\"80\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','111111','1204269788','0','0','0','0','');
INSERT INTO `p8_label` VALUES ('182','','1','0','Title1','code','0','Ϣ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218722123','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('183','','1','0','Title2','code','0','ͼ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218722071','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('184','','1','0','Title3','code','0','Ԥ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218722901','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('185','','1','0','Title4','code','0','','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218722216','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('186','','1','0','Title5','code','0','Ƶ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218722090','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('187','','1','0','Title6','code','0','Ʒ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218722260','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('188','','1','0','Title01','code','0','','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','111111','0','0','0','0','0','');
INSERT INTO `p8_label` VALUES ('189','','1','0','Title02','code','0','','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','111111','0','0','0','0','0','');
INSERT INTO `p8_label` VALUES ('261','','1','0','top_news','article','1','a:21:{s:9:\"tplpart_1\";s:77:\"&nbsp;<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:13:\"tplpart_1code\";s:119:\"&nbsp;<A HREF=\"$webdb[www_url]/bencandy.php?fid=$fid&aid=$aid\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";s:46:\"$webdb[www_url]/bencandy.php?fid=$fid&aid=$aid\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:6:\"DivTpl\";s:1:\"0\";s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"11\";s:3:\"sql\";s:75:\" SELECT A.* FROM p8_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 22 \";s:7:\"colspan\";s:1:\"2\";s:11:\"content_num\";s:2:\"80\";s:8:\"titlenum\";s:2:\"32\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','111111','1182839073','0','0','0','0','');
INSERT INTO `p8_label` VALUES ('263','','1','99','SP_adword','code','0','ȫһCMSϵͳ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','111111','0','0','0','0','0','');
INSERT INTO `p8_label` VALUES ('284','','1','0','Title_jinjaad','code','0','','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218722107','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('285','','1','0','jinjaad','down','1','a:21:{s:9:\"tplpart_1\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:13:\"tplpart_1code\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:3:\"SYS\";s:6:\"normal\";s:8:\"SYS_type\";s:4:\"down\";s:3:\"url\";N;s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:6:\"DivTpl\";s:1:\"1\";s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:8:\"posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:73:\" SELECT * FROM p8_down_software  WHERE 1  ORDER BY posttime DESC LIMIT 7 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218722842','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('286','','0','0','news_new','Info_news_','1','a:22:{s:9:\"tplpart_1\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:13:\"tplpart_1code\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:6:\"DivTpl\";s:1:\"0\";s:5:\"fiddb\";N;s:8:\"moduleid\";s:0:\"\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:79:\" SELECT A.* FROM p8_news_content A   WHERE 1  ORDER BY A.posttime DESC LIMIT 5 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','0','0','1','0','0','35cn');
INSERT INTO `p8_label` VALUES ('287','','0','0','news_hot','Info_news_','1','a:22:{s:9:\"tplpart_1\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:13:\"tplpart_1code\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:6:\"DivTpl\";s:1:\"0\";s:5:\"fiddb\";N;s:8:\"moduleid\";s:0:\"\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:75:\" SELECT A.* FROM p8_news_content A   WHERE 1  ORDER BY A.hits DESC LIMIT 5 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218597147','0','1','0','0','35cn');
INSERT INTO `p8_label` VALUES ('288','','0','0','news_last','Info_news_','1','a:22:{s:9:\"tplpart_1\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:13:\"tplpart_1code\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:5:\"news_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:6:\"DivTpl\";s:1:\"1\";s:5:\"fiddb\";N;s:8:\"moduleid\";s:0:\"\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.lastview\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:79:\" SELECT A.* FROM p8_news_content A   WHERE 1  ORDER BY A.lastview DESC LIMIT 5 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','0','0','1','0','0','35cn');
INSERT INTO `p8_label` VALUES ('289','','1','0','a1','Info_fenlei_','1','a:22:{s:9:\"tplpart_1\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:13:\"tplpart_1code\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:3:\"SYS\";s:2:\"wn\";s:6:\"wninfo\";s:7:\"fenlei_\";s:7:\"typefid\";N;s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:6:\"DivTpl\";s:1:\"0\";s:5:\"fiddb\";N;s:8:\"moduleid\";s:0:\"\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"9\";s:3:\"sql\";s:77:\" SELECT A.* FROM p8_fenlei_content A   WHERE 1  ORDER BY A.list DESC LIMIT 9 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"34\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218722711','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('290','','1','0','b1','photo','1','a:21:{s:9:\"tplpart_1\";s:293:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td align=\"center\"><a href=\"$url\" target=_blank><img src=\'$picurl\' border=0 width=\"100\" height=\"75\"></a></td>\r\n  </tr>\r\n  <tr>\r\n    <td align=\"center\"><a href=\"$url\" target=_blank>$title</a></td>\r\n  </tr>\r\n</table>\r\n\";s:13:\"tplpart_1code\";s:293:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td align=\"center\"><a href=\"$url\" target=_blank><img src=\'$picurl\' border=0 width=\"100\" height=\"75\"></a></td>\r\n  </tr>\r\n  <tr>\r\n    <td align=\"center\"><a href=\"$url\" target=_blank>$title</a></td>\r\n  </tr>\r\n</table>\r\n\";s:3:\"SYS\";s:6:\"normal\";s:8:\"SYS_type\";s:5:\"photo\";s:3:\"url\";N;s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:6:\"DivTpl\";s:1:\"0\";s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"6\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:8:\"posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:69:\" SELECT * FROM p8_photo_pic  WHERE 1  ORDER BY posttime DESC LIMIT 8 \";s:7:\"colspan\";s:1:\"4\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218723014','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('291','','1','0','b2','mv','1','a:21:{s:9:\"tplpart_1\";s:293:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td align=\"center\"><a href=\"$url\" target=_blank><img src=\'$picurl\' border=0 width=\"100\" height=\"75\"></a></td>\r\n  </tr>\r\n  <tr>\r\n    <td align=\"center\"><a href=\"$url\" target=_blank>$title</a></td>\r\n  </tr>\r\n</table>\r\n\";s:13:\"tplpart_1code\";s:293:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td align=\"center\"><a href=\"$url\" target=_blank><img src=\'$picurl\' border=0 width=\"100\" height=\"75\"></a></td>\r\n  </tr>\r\n  <tr>\r\n    <td align=\"center\"><a href=\"$url\" target=_blank>$title</a></td>\r\n  </tr>\r\n</table>\r\n\";s:3:\"SYS\";s:6:\"normal\";s:8:\"SYS_type\";s:2:\"mv\";s:3:\"url\";N;s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:6:\"DivTpl\";s:1:\"0\";s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"6\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:8:\"posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:74:\" SELECT * FROM p8_mv_video  WHERE ispic=1  ORDER BY posttime DESC LIMIT 4 \";s:7:\"colspan\";s:1:\"4\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218723023','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('292','','1','0','a2','blog_log','1','a:19:{s:9:\"tplpart_1\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:13:\"tplpart_1code\";s:128:\"<A HREF=\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:3:\"url\";s:59:\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:6:\"DivTpl\";s:1:\"1\";s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:8:\"posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:76:\" SELECT * FROM p8_blog_log_article  WHERE 1  ORDER BY posttime DESC LIMIT 8 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','0','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('293','','1','0','c2','shop','1','a:21:{s:9:\"tplpart_1\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:13:\"tplpart_1code\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:3:\"SYS\";s:6:\"normal\";s:8:\"SYS_type\";s:4:\"shop\";s:3:\"url\";N;s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:6:\"DivTpl\";s:1:\"1\";s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:8:\"posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"13\";s:3:\"sql\";s:73:\" SELECT * FROM p8_shop_product  WHERE 1  ORDER BY posttime DESC LIMIT 13 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','1218722948','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('294','','1','0','comarticle','article','1','a:23:{s:9:\"tplpart_1\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:13:\"tplpart_1code\";s:73:\"<A HREF=\"$url\" target=\'_blank\' style=\"color:$titlecolor\">$title</a><br>\";s:3:\"SYS\";s:7:\"artcile\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";N;s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:6:\"DivTpl\";s:1:\"1\";s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";s:1:\"0\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.lastview\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:79:\" SELECT A.* FROM p8_article A  WHERE A.yz=1   ORDER BY A.lastview DESC LIMIT 5 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','0','0','0','0','0','35cn');
INSERT INTO `p8_label` VALUES ('295','','1','0','c1','hack_weather','0','<iframe src=\'http://weather.265.com/weather.htm\' width=\'168\' height=\'54\' frameborder=\'no\' border=\'0\' marginwidth=\'0\' marginheight=\'0\' scrolling=\'no\'></iframe>','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','php168','0','0','0','0','0','35cn');
INSERT INTO `p8_limitword` VALUES ('1','췴','**');
INSERT INTO `p8_limitword` VALUES ('2','','**');
INSERT INTO `p8_memberdata` VALUES ('1','','3','','1','0','','-122','0','14676','121187','1218778161','127.0.0.1','1218513127','127.0.0.1','0','0000-00-00','vlog/0/1/1_20080814150845_WgYR6.jpg','','0','0','','','','','','','','','','','','','','0');
INSERT INTO `p8_members` VALUES ('1','php168','4d55f8db08f24419e1e91b45aa80ffcb');
INSERT INTO `p8_menu` VALUES ('1','0','վҳ','./','','0','0','0','0','0');
INSERT INTO `p8_menu` VALUES ('2','0','ҪͶ','post.php','','0','0','0','0','0');
INSERT INTO `p8_menu` VALUES ('3','0','ÿ','guestbook.php','','0','0','0','0','0');
INSERT INTO `p8_menu` VALUES ('4','0','','search.php','','0','0','0','0','0');
INSERT INTO `p8_menu` VALUES ('5','0','','alonepage.php?id=6','','0','0','0','0','0');
INSERT INTO `p8_menu` VALUES ('6','0','','digg.php','','0','0','0','0','0');
INSERT INTO `p8_module` VALUES ('1','1','ѶƵ','news_','news','','','1','a:7:{s:12:\"list_PhpName\";s:18:\"list.php?&fid=$fid\";s:12:\"show_PhpName\";s:29:\"bencandy.php?&fid=$fid&id=$id\";s:8:\"MakeHtml\";s:1:\"0\";s:14:\"list_HtmlName1\";s:23:\"html/{$fid}/{$page}.htm\";s:14:\"show_HtmlName1\";s:38:\"html/{$fid}/{$dirid}/{$id}/{$page}.htm\";s:14:\"list_HtmlName2\";s:36:\"list.php?fid-{$fid}-page-{$page}.htm\";s:14:\"show_HtmlName2\";s:49:\"bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm\";}','0','','','0');
INSERT INTO `p8_module` VALUES ('2','0','ͼƬƵ','photo','photo','','','1','a:7:{s:12:\"list_PhpName\";s:18:\"list.php?&fid=$fid\";s:12:\"show_PhpName\";s:29:\"bencandy.php?&fid=$fid&id=$id\";s:8:\"MakeHtml\";s:1:\"0\";s:14:\"list_HtmlName1\";s:0:\"\";s:14:\"show_HtmlName1\";s:0:\"\";s:14:\"list_HtmlName2\";s:36:\"list.php?fid-{$fid}-page-{$page}.htm\";s:14:\"show_HtmlName2\";s:49:\"bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm\";}','0','','','1');
INSERT INTO `p8_module` VALUES ('3','0','ƵƵ','mv','movie','','','1','a:7:{s:12:\"list_PhpName\";s:18:\"list.php?&fid=$fid\";s:12:\"show_PhpName\";s:29:\"bencandy.php?&fid=$fid&id=$id\";s:8:\"MakeHtml\";s:1:\"0\";s:14:\"list_HtmlName1\";s:0:\"\";s:14:\"show_HtmlName1\";s:0:\"\";s:14:\"list_HtmlName2\";s:36:\"list.php?fid-{$fid}-page-{$page}.htm\";s:14:\"show_HtmlName2\";s:49:\"bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm\";}','0','','','1');
INSERT INTO `p8_module` VALUES ('4','1','Ƶ','fenlei_','fenlei','','','1','a:7:{s:12:\"list_PhpName\";s:18:\"list.php?&fid=$fid\";s:12:\"show_PhpName\";s:29:\"bencandy.php?&fid=$fid&id=$id\";s:8:\"MakeHtml\";s:1:\"0\";s:14:\"list_HtmlName1\";s:0:\"\";s:14:\"show_HtmlName1\";s:0:\"\";s:14:\"list_HtmlName2\";s:36:\"list.php?fid-{$fid}-page-{$page}.htm\";s:14:\"show_HtmlName2\";s:49:\"bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm\";}','0','','','1');
INSERT INTO `p8_module` VALUES ('5','0','̳Ƶ','shop','shop','','','1','a:7:{s:12:\"list_PhpName\";s:18:\"list.php?&fid=$fid\";s:12:\"show_PhpName\";s:29:\"bencandy.php?&fid=$fid&id=$id\";s:8:\"MakeHtml\";s:1:\"2\";s:14:\"list_HtmlName1\";s:0:\"\";s:14:\"show_HtmlName1\";s:0:\"\";s:14:\"list_HtmlName2\";s:36:\"list.php?fid-{$fid}-page-{$page}.htm\";s:14:\"show_HtmlName2\";s:49:\"bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm\";}','0','','','1');
INSERT INTO `p8_module` VALUES ('6','0','FLASHƵ','flash','flash','','','1','','0','','','1');
INSERT INTO `p8_module` VALUES ('7','0','ϵͳ','blog','blog','','','1','','0','','','1');
INSERT INTO `p8_module` VALUES ('8','1','ȦƵ','group_','group','','','1','','0','','','0');
INSERT INTO `p8_module` VALUES ('9','0','Ƶ','down','download','','','1','a:7:{s:12:\"list_PhpName\";s:18:\"list.php?&fid=$fid\";s:12:\"show_PhpName\";s:29:\"bencandy.php?&fid=$fid&id=$id\";s:8:\"MakeHtml\";s:1:\"0\";s:14:\"list_HtmlName1\";s:23:\"html/{$fid}/{$page}.htm\";s:14:\"show_HtmlName1\";s:38:\"html/{$fid}/{$dirid}/{$id}/{$page}.htm\";s:14:\"list_HtmlName2\";s:36:\"list.php?fid-{$fid}-page-{$page}.htm\";s:14:\"show_HtmlName2\";s:49:\"bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm\";}','0','','','1');
INSERT INTO `p8_mv_config` VALUES ('postMvPassYz','3,4','');
INSERT INTO `p8_mv_config` VALUES ('Mv_MakeIndexHtmlTime','','');
INSERT INTO `p8_mv_config` VALUES ('Mv_style','35cn','');
INSERT INTO `p8_mv_config` VALUES ('Mv_list_filename2','list.php?fid-{$fid}-page-{$page}.htm','');
INSERT INTO `p8_mv_config` VALUES ('Mv_bencandy_filename','','');
INSERT INTO `p8_mv_config` VALUES ('Mv_NewsMakeHtml','0','');
INSERT INTO `p8_mv_config` VALUES ('Mv_list_filename','','');
INSERT INTO `p8_mv_config` VALUES ('Mv_closeWhy','ʱر','');
INSERT INTO `p8_mv_config` VALUES ('Mv_bencandy_filename2','bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm','');
INSERT INTO `p8_mv_config` VALUES ('Mv_webOpen','1','');
INSERT INTO `p8_mv_config` VALUES ('Mv_rollpic','|images/default/009.jpg|#\r\nɫ|images/default/010.jpg|#\r\nè|images/default/011.jpg|#','');
INSERT INTO `p8_mv_config` VALUES ('module_id','3','');
INSERT INTO `p8_mv_config` VALUES ('module_pre','mv_','');
INSERT INTO `p8_mv_config` VALUES ('Mv_metakeywords','Ƶ Ů ','');
INSERT INTO `p8_mv_config` VALUES ('Mv_webname','ƵƵ','');
INSERT INTO `p8_mv_config` VALUES ('memberPost','1','');
INSERT INTO `p8_mv_config` VALUES ('group_UpMv','3,4','');
INSERT INTO `p8_mv_config` VALUES ('Mv_guide_word1','Ƶҳ|index.php\r\nҪͶ|#\r\nÿ|#\r\n|#\r\n|#\r\n̳|#\r\nվҳ|../','');
INSERT INTO `p8_mv_gather_rule` VALUES ('48','article','article','','->Ƶ','http://music.tudou.com/ajax_channelItem.php?sort=view&page=[page]','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<a href=\"{url=NO\"}\" title=\"{title=NO\"}\" target=\"_blank\"><img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" /></a>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_gather_rule` VALUES ('47','article','article','','->Ƶ','http://ent.tudou.com/ajax_channelItem.php?sort=view&page=[page]','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<a href=\"{url=NO\"}\" title=\"{title=NO\"}\" target=\"_blank\"><img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" /></a>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_gather_rule` VALUES ('46','article','article','','->ԭƵ','http://imake.tudou.com/ajax_channelItem.php?sort=view&page=[page]','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<a href=\"{url=NO\"}\" title=\"{title=NO\"}\" target=\"_blank\"><img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" /></a>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_gather_rule` VALUES ('44','article','article','','->Ƶ','http://www.tudou.com/programs/?page=1','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<div class=\"in\">\r\n					<a href=\"{url=NO\"}\" title=\"{title=NO<}\" target=\"_blank\">\r\n						<img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" />\r\n					</a>\r\n				</div>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_gather_rule` VALUES ('49','article','article','','->Ƶ','http://life.tudou.com/ajax_channelItem.php?sort=view&page=[page]','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<a href=\"{url=NO\"}\" title=\"{title=NO\"}\" target=\"_blank\"><img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" /></a>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_gather_rule` VALUES ('45','article','article','','->ӰƵƵ','http://movie.tudou.com/ajax_channelItem.php?sort=view&page=[page]','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<a href=\"{url=NO\"}\" title=\"{title=NO\"}\" target=\"_blank\"><img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" /></a>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_gather_rule` VALUES ('50','article','article','','->Ƶ','http://cartoon.tudou.com/ajax_channelItem.php?sort=view&page=[page]','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<a href=\"{url=NO\"}\" title=\"{title=NO\"}\" target=\"_blank\"><img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" /></a>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_gather_rule` VALUES ('51','article','article','','->ϷƵ','http://game.tudou.com/ajax_channelItem.php?sort=view&page=[page]','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<a href=\"{url=NO\"}\" title=\"{title=NO\"}\" target=\"_blank\"><img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" /></a>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_gather_rule` VALUES ('52','article','article','','->Ƶ','http://sport.tudou.com/ajax_channelItem.php?sort=view&page=[page]','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<a href=\"{url=NO\"}\" title=\"{title=NO\"}\" target=\"_blank\"><img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" /></a>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_gather_rule` VALUES ('53','article','article','','->Ƶ','http://www.tudou.com/channels/view.php?id=23&page=[page]','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<div class=\"wide\"><div class=\"in\">\r\n					<a href=\"{url=NO\"}\" title=\"{title=NO\"}\" target=\"_blank\">\r\n						<img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" />\r\n					</a>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_gather_rule` VALUES ('54','article','article','','->ƼƵ','http://www.tudou.com/channels/view.php?id=21&page=[page]','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<div class=\"wide\"><div class=\"in\">\r\n					<a href=\"{url=NO\"}\" title=\"{title=NO\"}\" target=\"_blank\">\r\n						<img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" />\r\n					</a>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_gather_rule` VALUES ('55','article','article','','->Ƶ','http://www.tudou.com/channels/view.php?id=12&page=[page]','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<div class=\"wide\"><div class=\"in\">\r\n					<a href=\"{url=NO\"}\" title=\"{title=NO\"}\" target=\"_blank\">\r\n						<img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" />\r\n					</a>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_gather_rule` VALUES ('56','article','article','','->ЦƵ','http://www.tudou.com/channels/view.php?id=5&page=[page]','','1','8','1','0','','','<','','','','','','','0','$htmlcode=str_replace(\'<div id=\"memos\" style=\"background:#f9faf5;\"></div>\',\'<div id=\"memos\" style=\"background:#f9faf5;\">NO about</div>\',$htmlcode);\r\n\r\n$playtype=\'swf\';','','','','','','','','0','1181700833','1181700949','0','0','','0','0','','','','0','','<div class=\"wide\"><div class=\"in\">\r\n					<a href=\"{url=NO\"}\" title=\"{title=NO\"}\" target=\"_blank\">\r\n						<img src=\"{picurl=NO\"}\" alt=\"{NO\"}\" class=\"pack_clipImg\" />\r\n					</a>','<div class=\"memos\">\r\n						<div id=\"memos\">{content=*}</div>\r\n					</div>\r\n					<ul class=\"share\">\r\n						<li><label>Ƶַ(URL)</label><input id=\"clipURLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"{*}\" style=\"width:271px;\"/></li>\r\n												<li><label>ǶƵ(HTML)</label><input id=\"clipHTMLr\" onclick=\"copyText(this.id);alert(\'ѸƣʹCtrl+Vճ\')\" value=\"&lt;object width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;param name=&quot;movie&quot; value=&quot;{videourl=*}&quot;','','','0');
INSERT INTO `p8_mv_sort` VALUES ('1','0','','1','7','1','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_mv_sort` VALUES ('2','1','ЦƵ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','1','','');
INSERT INTO `p8_mv_sort` VALUES ('3','1','Ƶ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_mv_sort` VALUES ('4','15','ƼƵ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_mv_sort` VALUES ('5','15','Ƶ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_mv_sort` VALUES ('6','1','ϷƵ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_mv_sort` VALUES ('7','1','Ƶ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_mv_sort` VALUES ('8','15','Ƶ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_mv_sort` VALUES ('9','1','Ƶ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_mv_sort` VALUES ('10','1','Ƶ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','1','','');
INSERT INTO `p8_mv_sort` VALUES ('11','15','ԭƵ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_mv_sort` VALUES ('12','1','ӰƵƵ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','1','','');
INSERT INTO `p8_mv_sort` VALUES ('13','15','Ƶ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_mv_sort` VALUES ('14','15','Ƶ','2','0','0','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_mv_sort` VALUES ('15','0','ƽ','1','6','1','','0','0','','','','','N;','','0','','','0','3,4','','','','0','a:4:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";}','0','','');
INSERT INTO `p8_mv_video` VALUES ('1','Ц-Ц','0','','2','ЦƵ','0','344','0','1199936222','1199936222','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/346/182/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ц-Ц','http://www.tudou.com/v/QtYkjkPFU_c','0','','1218578779','0','swf');
INSERT INTO `p8_mv_video` VALUES ('2','ĵĶƬ','0','','2','ЦƵ','0','432','0','1199936223','1199936223','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/308/290/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','֮~','http://www.tudou.com/v/_naFQTlOfn0','0','','1218585684','0','swf');
INSERT INTO `p8_mv_video` VALUES ('3','ӡȮ--&gt;ϷԽĿСӰ-200708','0','','2','ЦƵ','0','616','0','1199936225','1199936225','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/625/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-ӡȮ-200708','http://www.tudou.com/v/Ch4rqrWeyGI','0','','1218405331','0','swf');
INSERT INTO `p8_mv_video` VALUES ('4','tbdr101a','0','','2','ЦƵ','0','501','0','1199936226','1199936226','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/297/958/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','tbdr101a','http://www.tudou.com/v/PGMjlF_MYQo','0','','1218578687','0','swf');
INSERT INTO `p8_mv_video` VALUES ('5','ֻ--&gt;ϷԽĿСӰ-200708','0','','2','ЦƵ','0','1027','0','1199936228','1199936228','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/724/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-ֻ-200708','http://www.tudou.com/v/wv0gceR1R5I','0','','1218578666','0','swf');
INSERT INTO `p8_mv_video` VALUES ('6','û---&gt;ϷԽĿСӰ200709','0','','2','ЦƵ','0','594','0','1199936230','1199936230','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/516/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-û-200709','http://www.tudou.com/v/pAhqdIa1L-A','0','','1218542252','0','swf');
INSERT INTO `p8_mv_video` VALUES ('7','Ұ--&gt;ϷԽĿСӰ-200709','0','','2','ЦƵ','0','478','0','1199936233','1199936233','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/292/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-Ұ-200709','http://www.tudou.com/v/1y6_7YwXasA','0','','1218598887','0','swf');
INSERT INTO `p8_mv_video` VALUES ('8','5','0','','2','ЦƵ','0','728','0','1199936236','1199936236','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/346/701/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ΪһλңȻҪǸǵǸȻȻö4λŮλ޸ǳֻϧͷһհ~~~','http://www.tudou.com/v/IyWPLaDEfEA','0','','1218513969','0','swf');
INSERT INTO `p8_mv_video` VALUES ('9','ʧ--&gt;ϷԽĿСӰ-200709','0','','2','ЦƵ','0','1353','0','1199936237','1199936237','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/116/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-ʧ-200709','http://www.tudou.com/v/SOPM6B0JnBo','0','','1218559161','0','swf');
INSERT INTO `p8_mv_video` VALUES ('10','ͯҥ','0','','2','ЦƵ','0','493','0','1199936239','1199936239','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/271/368/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˵','http://www.tudou.com/v/RBFwBQ3spzY','0','','1218594742','0','swf');
INSERT INTO `p8_mv_video` VALUES ('11','[gby] ꇃǄt-܇{Ӗ','0','','2','ЦƵ','0','1111','0','1199936240','1199936240','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/381/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','FROM YOUTUBE,Ͷ: gasgoose','http://www.tudou.com/v/CIFwX4e11Ek','0','','1218602424','0','swf');
INSERT INTO `p8_mv_video` VALUES ('12','','0','','2','ЦƵ','0','1194','0','1199936242','1199936242','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/164/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ϸ','http://www.tudou.com/v/notdYmIUQjg','0','','1218590945','0','swf');
INSERT INTO `p8_mv_video` VALUES ('13','ʨ-ʮ˵','0','','2','ЦƵ','0','636','0','1199936244','1199936244','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/868/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ϸ','http://www.tudou.com/v/kJeC8bVpfb0','0','','1218492415','0','swf');
INSERT INTO `p8_mv_video` VALUES ('14','Ÿϵ01','0','','2','ЦƵ','0','361','0','1199936245','1199936245','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/283/024/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ÿ','http://www.tudou.com/v/yZKOWgwd7c4','0','','1218583431','0','swf');
INSERT INTO `p8_mv_video` VALUES ('15','yahoo!R֮...','0','','2','ЦƵ','0','357','0','1199936247','1199936247','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/274/052/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','`¼','http://www.tudou.com/v/YxWtRVTEs3A','0','','1218533222','0','swf');
INSERT INTO `p8_mv_video` VALUES ('16','һ94','0','','2','ЦƵ','0','558','0','1199936248','1199936248','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/336/025/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','3gp','http://www.tudou.com/v/hWkVa-CuQ9k','0','','1218457629','0','swf');
INSERT INTO `p8_mv_video` VALUES ('17','ͱ5֮ʮ־113a','0','','2','ЦƵ','0','502','0','1199936250','1199936250','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/319/313/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','1','http://www.tudou.com/v/IkIPg64ooro','0','','1218576958','0','swf');
INSERT INTO `p8_mv_video` VALUES ('18','һ93','0','','2','ЦƵ','0','792','0','1199936251','1199936251','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/335/855/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','3gp','http://www.tudou.com/v/92ArxJjrhjk','0','','1218590364','0','swf');
INSERT INTO `p8_mv_video` VALUES ('19','[]ʵ5ë/2','0','','2','ЦƵ','0','443','0','1199936253','1199936253','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/291/925/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','.ܸЦ.&lt;br /&gt;&quot;1(13) ù.೤.Ʈ.','http://www.tudou.com/v/lVb0H5cLGss','0','','1218543132','0','swf');
INSERT INTO `p8_mv_video` VALUES ('20','С','0','','2','ЦƵ','0','388','0','1199936256','1199936256','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/298/248/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','С','http://www.tudou.com/v/RNaeIMyvyCg','0','','1218540264','0','swf');
INSERT INTO `p8_mv_video` VALUES ('21','޼1','0','','2','ЦƵ','0','1063','0','1199936264','1199936264','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/289/964/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Цеף.....','http://www.tudou.com/v/aYUv7q9xzpw','0','','1218582602','0','swf');
INSERT INTO `p8_mv_video` VALUES ('22','޼2','0','','2','ЦƵ','0','497','0','1199936269','1199936269','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/140/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǸЦ Ц˲','http://www.tudou.com/v/nI367ni0uHs','0','','1218360928','0','swf');
INSERT INTO `p8_mv_video` VALUES ('23','','0','','2','ЦƵ','0','307','0','1199936272','1199936272','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/288/817/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ѧ','http://www.tudou.com/v/-zPs1DbQgm4','0','','1218523545','0','swf');
INSERT INTO `p8_mv_video` VALUES ('24','A@~PЦƬ','0','','2','ЦƵ','0','311','0','1199936275','1199936275','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/915/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','A@~PЦƬ','http://www.tudou.com/v/PYQ7v4MfQ7g','0','','1218567078','0','swf');
INSERT INTO `p8_mv_video` VALUES ('25','龰Ŀ硶̨⴫','0','','2','ЦƵ','0','454','0','1199936279','1199936279','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/334/241/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','̨ Ѷ̨ Ӱֱ̨ҵҳ','http://www.tudou.com/v/VXawOTMRq30','0','','1218608601','0','swf');
INSERT INTO `p8_mv_video` VALUES ('26','112','0','','2','ЦƵ','0','415','0','1199936287','1199936287','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/282/319/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','sdfsdfsdfsd','http://www.tudou.com/v/cvTMRvTRraQ','0','','1218476504','0','swf');
INSERT INTO `p8_mv_video` VALUES ('27','ҵͷ','0','','2','ЦƵ','0','260','0','1199936292','1199936292','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/300/062/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ϳһʱ˶ͬѧĵġ','http://www.tudou.com/v/7ctLqGKtBS4','0','','1218583421','0','swf');
INSERT INTO `p8_mv_video` VALUES ('28','ϲ콵','0','','2','ЦƵ','0','329','0','1199936296','1199936296','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/036/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ɽʦѧѧԺѧϰٿ֪ʶĲ岥Ƶ&lt;br /&gt;ԼŶ','http://www.tudou.com/v/0jN5sEH1Mgw','0','','1218464525','0','swf');
INSERT INTO `p8_mv_video` VALUES ('29','սNGƬ','0','','2','ЦƵ','0','305','0','1199936300','1199936300','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/335/340/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սNGƬ','http://www.tudou.com/v/Y-01huj3bWU','0','','1218595780','0','swf');
INSERT INTO `p8_mv_video` VALUES ('30','žmy way(VIPƷ)','0','','2','ЦƵ','0','172','0','1199936303','1199936303','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/302/360/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ΪкڳԱԼmy way,ǮͶĲż֮ʲôϵء֣ɣгԱСڷѧ󣬵ø߳ĶӮСյĳɸҺСվȻܽ׹ݳļƱƭصǮСûеóأĿԴ','http://www.tudou.com/v/Lv6PvrnT754','0','','1218231664','0','swf');
INSERT INTO `p8_mv_video` VALUES ('31','ҵĵ---&gt;ϷԽĿСӰ200709','0','','2','ЦƵ','0','422','32','1199936306','1199936306','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/505/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-ҵĵ-200709','http://www.tudou.com/v/17X12_q3mto','0','','1218598761','0','swf');
INSERT INTO `p8_mv_video` VALUES ('32','ǷԱ--&gt;ӷԽĿСӰ-20080107','0','','2','ЦƵ','0','509','0','1199936310','1199936310','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/334/164/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ϷԽĿСӰ-ǷԱ-20080107','http://www.tudou.com/v/PE99eB_s1u8','0','','1218597062','0','swf');
INSERT INTO `p8_mv_video` VALUES ('33','aaa','0','','2','ЦƵ','0','311','0','1199936313','1199936313','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/010/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','aaaa','http://www.tudou.com/v/84kLLl3Vrb4','0','','1218598622','0','swf');
INSERT INTO `p8_mv_video` VALUES ('34','С-ѩ','0','','2','ЦƵ','0','454','0','1199936315','1199936315','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/336/089/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','һõкһ׷ѩĸԾ֮٣СԴ˸֮顣','http://www.tudou.com/v/K-LlD_KyjlU','0','','1218575607','0','swf');
INSERT INTO `p8_mv_video` VALUES ('35','Bһ5֮ƱԱ','0','','2','ЦƵ','0','1120','2','1199936317','1199936317','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/302/997/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','B統ƱԱˣ','http://www.tudou.com/v/op_sQY15rfk','0','','1218585734','0','swf');
INSERT INTO `p8_mv_video` VALUES ('36','Ӱ2.0 ĸɵB(C)','0','','2','ЦƵ','0','467','0','1199936320','1199936320','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/762/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Цģ','http://www.tudou.com/v/LF6FRSBT4rs','0','','1218591323','0','swf');
INSERT INTO `p8_mv_video` VALUES ('37','ѧĴ','0','','2','ЦƵ','0','525','0','1199936324','1199936324','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/299/453/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','еЦ','http://www.tudou.com/v/3lCuwjgWofI','0','','1218593089','0','swf');
INSERT INTO `p8_mv_video` VALUES ('38','ù()','0','','2','ЦƵ','0','307','0','1199936328','1199936328','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/312/474/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǳ3D,ɸЦ,һʹЦ!','http://www.tudou.com/v/MLB13ID3EP4','0','','1218344377','0','swf');
INSERT INTO `p8_mv_video` VALUES ('39','Ϲı֤','0','','2','ЦƵ','0','476','0','1199936332','1199936332','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/312/335/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ж','http://www.tudou.com/v/sNsWM7C4Wa8','0','','1218553854','0','swf');
INSERT INTO `p8_mv_video` VALUES ('40','Լ---&gt;ϷԽĿСӰ200710','0','','2','ЦƵ','0','347','0','1199936333','1199936333','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/174/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-Լ-200710','http://www.tudou.com/v/CMluwIiujVQ','0','','1218609212','0','swf');
INSERT INTO `p8_mv_video` VALUES ('41','᲻','0','','2','ЦƵ','0','693','0','1199936335','1199936335','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/302/354/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/y3fiZ1SytOw','0','','1218577321','0','swf');
INSERT INTO `p8_mv_video` VALUES ('42','»ָ С͵ ൺ','0','','2','ЦƵ','0','523','0','1199936336','1199936336','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/314/503/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','»ָϡ;С͵ƲȤൺԣӳ07׵ļɫƬ','http://www.tudou.com/v/TlCdzzENrnA','0','','1218154647','0','swf');
INSERT INTO `p8_mv_video` VALUES ('43','SMAPЦնn','0','','2','ЦƵ','0','470','0','1199936338','1199936338','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/338/374/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','SMAPЦնn','http://www.tudou.com/v/vOzKWG0BUeQ','0','','1218609242','0','swf');
INSERT INTO `p8_mv_video` VALUES ('44','','0','','2','ЦƵ','0','997','0','1199936339','1199936339','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/282/582/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ц','http://www.tudou.com/v/U5uepV8Y5z0','0','','1218174709','0','swf');
INSERT INTO `p8_mv_video` VALUES ('45','֤--&gt;ӷԽĿָ-20080108','0','','2','ЦƵ','0','724','0','1199936341','1199936341','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/334/192/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ϷԽĿָ-֤-20080108','http://www.tudou.com/v/ZCFzQ3Z2cn8','0','','1218605040','0','swf');
INSERT INTO `p8_mv_video` VALUES ('46','䷹--&gt;ϷԽĿСӰ-200709','0','','2','ЦƵ','0','583','0','1199936342','1199936342','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/288/303/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-䷹-200709','http://www.tudou.com/v/iFfmpDVxg4Y','0','','1218580156','0','swf');
INSERT INTO `p8_mv_video` VALUES ('47','˻ı','0','','2','ЦƵ','0','269','0','1199936344','1199936344','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/330/303/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˻ı,','http://www.tudou.com/v/C8Q9nASwXQQ','0','','1218360282','0','swf');
INSERT INTO `p8_mv_video` VALUES ('48','Բ---&gt;ϷԽĿСӰ200710','0','','2','ЦƵ','0','491','0','1199936346','1199936346','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/448/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-Բ-200710','http://www.tudou.com/v/m1brO_6uVkI','0','','1218498960','0','swf');
INSERT INTO `p8_mv_video` VALUES ('49','ٺ','0','','2','ЦƵ','0','1099','0','1199936347','1199936347','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/289/101/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/AQBSsK2TRf4','0','','1218608317','0','swf');
INSERT INTO `p8_mv_video` VALUES ('50','һ82','0','','2','ЦƵ','0','489','0','1199936349','1199936349','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/869/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','3gp','http://www.tudou.com/v/tGplJuim-uw','0','','1218542953','0','swf');
INSERT INTO `p8_mv_video` VALUES ('51','ɿ--&gt;ϷԽĿСӰ-200710','0','','2','ЦƵ','0','209','0','1199936350','1199936350','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/291/438/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-ɿ-200710','http://www.tudou.com/v/aRXv1hkNX50','0','','1218172439','0','swf');
INSERT INTO `p8_mv_video` VALUES ('52','Һ','0','','2','ЦƵ','0','279','0','1199936352','1199936352','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/278/911/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ӫ̻»·ϣұҵ','http://www.tudou.com/v/xYkqzxDGJXI','0','','1218455821','0','swf');
INSERT INTO `p8_mv_video` VALUES ('53','Ұ԰Ѫ','0','','2','ЦƵ','0','683','0','1199936353','1199936353','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/319/047/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ұ԰Ѫ','http://www.tudou.com/v/ZP_dJdSLj2w','0','','1218602952','0','swf');
INSERT INTO `p8_mv_video` VALUES ('54','鹤--&gt;ϷԽĿСӰ-200708','0','','2','ЦƵ','0','323','0','1199936355','1199936355','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/656/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-鹤-200708','http://www.tudou.com/v/eY133GpQvwg','0','','1218435807','0','swf');
INSERT INTO `p8_mv_video` VALUES ('55','--&gt;ϷԽĿСӰ-200710','0','','2','ЦƵ','0','292','0','1199936356','1199936356','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/291/520/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ--200710','http://www.tudou.com/v/ei7hnuBhJHo','0','','1218557507','0','swf');
INSERT INTO `p8_mv_video` VALUES ('56','һ81','0','','2','ЦƵ','0','479','0','1199936358','1199936358','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/910/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','3gp','http://www.tudou.com/v/FbZMZQvhznQ','0','','1218578212','0','swf');
INSERT INTO `p8_mv_video` VALUES ('57','','0','','2','ЦƵ','0','247','0','1199936360','1199936360','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/277/397/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/5NekqgqA_v0','0','','1218513166','0','swf');
INSERT INTO `p8_mv_video` VALUES ('58','613׼','0','','2','ЦƵ','0','400','0','1199936361','1199936361','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/326/480/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǿݣЦ','http://www.tudou.com/v/USNqXaFSJe0','0','','1218516960','0','swf');
INSERT INTO `p8_mv_video` VALUES ('59','','0','','2','ЦƵ','0','276','0','1199936363','1199936363','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/278/234/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ݣƲ Ҧ ־ΰ','http://www.tudou.com/v/dLGgVCvBBhE','0','','1218534953','0','swf');
INSERT INTO `p8_mv_video` VALUES ('60','JAMESӰ»Ļ','0','','2','ЦƵ','0','359','0','1199936364','1199936364','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/325/615/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˵еģʣͣţӵӰϵ','http://www.tudou.com/v/39XUZh0gN2k','0','','1218548080','0','swf');
INSERT INTO `p8_mv_video` VALUES ('61','med401','0','','2','ЦƵ','0','299','0','1199936366','1199936366','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/298/193/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','med401a','http://www.tudou.com/v/7_Xh88vBgUI','0','','1218457039','0','swf');
INSERT INTO `p8_mv_video` VALUES ('62','СCOS','0','','2','ЦƵ','0','231','0','1199936367','1199936367','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/274/489/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ڶƵ˳ֺܶ','http://www.tudou.com/v/bWhhmFAQY-c','0','','1218447658','0','swf');
INSERT INTO `p8_mv_video` VALUES ('63','','0','','2','ЦƵ','0','354','0','1199936368','1199936368','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/279/262/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','⣬Ƥing &nbsp; 5-3=','http://www.tudou.com/v/Z8XNkw_k-pE','0','','1218431082','0','swf');
INSERT INTO `p8_mv_video` VALUES ('64','Ԫ㣨ģѸ - 粻','0','','2','ЦƵ','0','201','0','1199936370','1199936370','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/995/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ԫ㣨ģѸ - 粻&lt;br /&gt;&lt;br /&gt;ǰꡡȫֺ塡ɳݸ&lt;br /&gt;ֽǧǧġϵɹ&lt;br /&gt;&lt;br /&gt;ؿۡؿءϳѽ&lt;br /&gt;ֽҹԭҡҲĸסʹ&lt;br /&gt;&lt;br /&gt;߼Ҷһһ&lt;br /&gt;ͨҡɿС߹˵&lt;br /&gt;&lt;br /&gt;ڸǮתӼ൱۶&lt;br /&gt;ǮX԰ԩ&lt;br /&gt;oԸѡԪ&lt;br /&gt;&lt;br /&gt;ؿۡؿءϳѽ&lt;br /&gt;ֽҹԭҡҲĸסʹ&lt;br /&gt;&lt;br /&gt;߼Ҷһһ&lt;br /&gt;ͨҡɿС&lt;br /&gt;&lt;br /&gt;ڸǮתȥչĴ&lt;br /&gt;ۡоƣ&lt;br /&gt;߹ʹšŵͶȦꡡ','http://www.tudou.com/v/YyboFVnqdhk','0','','1218435235','0','swf');
INSERT INTO `p8_mv_video` VALUES ('65','ƨ','0','','2','ЦƵ','0','768','0','1199936371','1199936371','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/288/956/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ϸſ ʵô','http://www.tudou.com/v/5h58-4ZUyVQ','0','','1218394453','0','swf');
INSERT INTO `p8_mv_video` VALUES ('66','һ95','0','','2','ЦƵ','0','275','0','1199936373','1199936373','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/336/830/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','3gp','http://www.tudou.com/v/T5vUG9kRR3o','0','','1218539233','0','swf');
INSERT INTO `p8_mv_video` VALUES ('67','--&gt;ϷԽĿСӰ-200710','0','','2','ЦƵ','0','303','0','1199936374','1199936374','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/291/643/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ--200710','http://www.tudou.com/v/TZ-PGsZb-V8','0','','1218591319','0','swf');
INSERT INTO `p8_mv_video` VALUES ('68','˭ôɫĹƤҲŹ','0','','2','ЦƵ','0','673','0','1199936376','1199936376','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/315/486/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˭ôɫĹƤҲŹ','http://www.tudou.com/v/npgRN7DmsKI','0','','1218610860','0','swf');
INSERT INTO `p8_mv_video` VALUES ('69','KAT-TUN - ЦС̄ - Ҳ + ','0','','2','ЦƵ','0','568','0','1199936378','1199936378','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/327/148/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','KAT-TUN - ЦС̄ - Ҳ + ','http://www.tudou.com/v/2dbmmPzvbnE','0','','1218541800','0','swf');
INSERT INTO `p8_mv_video` VALUES ('70','54456','0','','2','ЦƵ','0','295','0','1199936379','1199936379','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/315/090/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','5646','http://www.tudou.com/v/fCUs5DWvO5Y','0','','1218534189','0','swf');
INSERT INTO `p8_mv_video` VALUES ('71','ձ˶','0','','2','ЦƵ','0','393','0','1199936381','1199936381','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/272/764/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','2ﴫ档','http://www.tudou.com/v/bM3eNlOPWF8','0','','1218501613','0','swf');
INSERT INTO `p8_mv_video` VALUES ('72','ô˧Ĺ','0','','2','ЦƵ','0','287','0','1199936382','1199936382','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/295/202/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ô˧ ԽԽ ','http://www.tudou.com/v/may5S8TPIdw','0','','1218516881','0','swf');
INSERT INTO `p8_mv_video` VALUES ('73','¸١ҵһ','0','','2','ЦƵ','0','240','0','1199936384','1199936384','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/276/787/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ц~~','http://www.tudou.com/v/KezTBkC85pI','0','','1218590973','0','swf');
INSERT INTO `p8_mv_video` VALUES ('74','','0','','2','ЦƵ','0','367','0','1199936386','1199936386','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/273/583/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','൱ļ','http://www.tudou.com/v/KGmtkELpgGg','0','','1218527090','0','swf');
INSERT INTO `p8_mv_video` VALUES ('75','MAD[ޤˤʤ!][ޥΤʤ!]','0','','2','ЦƵ','0','287','0','1199936388','1199936388','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/324/270/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','...','http://www.tudou.com/v/8Wp0xeCgH7I','0','','1218508017','0','swf');
INSERT INTO `p8_mv_video` VALUES ('76','ŮҲD','0','','2','ЦƵ','0','359','0','1199936390','1199936390','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/322/211/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ŮҲD','http://www.tudou.com/v/Z7h68X0ZNpI','0','','1218585538','0','swf');
INSERT INTO `p8_mv_video` VALUES ('77','Ц','0','','2','ЦƵ','0','226','0','1199936392','1199936392','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/297/909/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǸЦ','http://www.tudou.com/v/XrK9cCNievU','0','','1218606530','0','swf');
INSERT INTO `p8_mv_video` VALUES ('78','ʿͻ','0','','2','ЦƵ','0','280','0','1199936394','1199936394','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/281/585/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ʷǿʿ','http://www.tudou.com/v/nuFg02jgSxU','0','','1218587923','0','swf');
INSERT INTO `p8_mv_video` VALUES ('79','DFSDFDF','0','','2','ЦƵ','0','583','0','1199936396','1199936396','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/042/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','DS','http://www.tudou.com/v/Z9nMweFS0mY','0','','1218608043','0','swf');
INSERT INTO `p8_mv_video` VALUES ('80','--&gt;ӷԽĿָ-20080107','0','','2','ЦƵ','0','582','1','1199936397','1199936397','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/333/896/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ϷԽĿСӰ--20080107','http://www.tudou.com/v/mdKO1EieQjw','0','','1218452197','0','swf');
INSERT INTO `p8_mv_video` VALUES ('81','ŮҲC','0','','2','ЦƵ','0','358','0','1199936399','1199936399','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/320/763/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ŮҲC','http://www.tudou.com/v/YYXY9-a5Us4','0','','1218446840','0','swf');
INSERT INTO `p8_mv_video` VALUES ('82','-','0','','2','ЦƵ','0','264','0','1199936401','1199936401','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/311/408/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ﱾ','http://www.tudou.com/v/638Ht8hvaFo','0','','1218526198','0','swf');
INSERT INTO `p8_mv_video` VALUES ('83','ĲӬ--&gt;ϷԽĿСӰ-200709','0','','2','ЦƵ','0','372','1','1199936402','1199936402','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/288/149/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-ĲӬ-200709','http://www.tudou.com/v/J0xIRFdNbso','0','','1218476308','0','swf');
INSERT INTO `p8_mv_video` VALUES ('84','90','0','','2','ЦƵ','0','1160','0','1199936404','1199936404','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/316/918/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ϺĹ֣ЦҪŶ','http://www.tudou.com/v/ly-sT6Tm984','0','','1218587479','0','swf');
INSERT INTO `p8_mv_video` VALUES ('85','ǧ߰ٹָЦˮ','0','','2','ЦƵ','0','713','0','1199936405','1199936405','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/336/944/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǧ߰ٹָЦˮ','http://www.tudou.com/v/Ohl3httVtzI','0','','1218607522','0','swf');
INSERT INTO `p8_mv_video` VALUES ('86','ǳ۸Ц','0','','2','ЦƵ','0','782','0','1199936407','1199936407','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/272/751/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','رЦ','http://www.tudou.com/v/ApvrJFZoJiY','0','','1218190589','0','swf');
INSERT INTO `p8_mv_video` VALUES ('87','ƽû(Цת)','0','','2','ЦƵ','0','792','0','1199936408','1199936408','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/293/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ц','http://www.tudou.com/v/EUWckeAfr7Q','0','','1218573226','0','swf');
INSERT INTO `p8_mv_video` VALUES ('88','ӡ--&gt;ϷԽĿСӰ-200710','0','','2','ЦƵ','0','425','32','1199936410','1199936410','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/291/583/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-ӡ-200710','http://www.tudou.com/v/UIQL6_z0pzg','0','','1218598750','0','swf');
INSERT INTO `p8_mv_video` VALUES ('89','','0','','2','ЦƵ','0','338','0','1199936411','1199936411','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/281/269/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǧ֮ı','http://www.tudou.com/v/CoXwHlgj7w4','0','','1218449783','0','swf');
INSERT INTO `p8_mv_video` VALUES ('90','Ĵ--&gt;ϷԽĿСӰ-200710','0','','2','ЦƵ','0','281','0','1199936413','1199936413','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/291/455/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-Ĵ-200710','http://www.tudou.com/v/u7YAu87ggIg','0','','1218558269','0','swf');
INSERT INTO `p8_mv_video` VALUES ('91','ƽû(Цת)','0','','2','ЦƵ','0','405','0','1199936414','1199936414','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/283/382/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ц','http://www.tudou.com/v/3HgAZJ_uFUs','0','','1218443968','0','swf');
INSERT INTO `p8_mv_video` VALUES ('92','¹ϣս(VIPƷ)','0','','2','ЦƵ','0','343','0','1199936416','1199936416','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/300/185/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ս','http://www.tudou.com/v/J-5-tgPOY2A','0','','1218508446','0','swf');
INSERT INTO `p8_mv_video` VALUES ('93','ǿ̫̫ĸС͵','0','','2','ЦƵ','0','241','0','1199936417','1199936417','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/307/673/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǿ̫̫ĸС͵','http://www.tudou.com/v/IJwB8Hsi-7U','0','','1218595239','0','swf');
INSERT INTO `p8_mv_video` VALUES ('94','һ80','0','','2','ЦƵ','0','277','0','1199936419','1199936419','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/840/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','3gp','http://www.tudou.com/v/fzqFOFTUjvI','0','','1218601496','0','swf');
INSERT INTO `p8_mv_video` VALUES ('95',';˵--&gt;ϷԽĿСӰ-200710','0','','2','ЦƵ','0','627','0','1199936421','1199936421','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/869/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-;˵-200710','http://www.tudou.com/v/fOOaLtHiNBc','0','','1218490119','0','swf');
INSERT INTO `p8_mv_video` VALUES ('96','ֻ齫--&gt;ϷԽĿСӰ-200709','0','','2','ЦƵ','0','408','0','1199936422','1199936422','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/286/635/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-ֻ齫-200709','http://www.tudou.com/v/ZmpWPo2VQrw','0','','1218504750','0','swf');
INSERT INTO `p8_mv_video` VALUES ('97','ڷ۽A GO GO','0','','2','ЦƵ','0','375','0','1199936424','1199936424','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/296/371/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ڷ۽A GO GO  www.manbf.com','http://www.tudou.com/v/39N0OIpcYxs','0','','1218504595','0','swf');
INSERT INTO `p8_mv_video` VALUES ('98','','0','','2','ЦƵ','0','286','0','1199936425','1199936425','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/944/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','һеģʹŮģ㿴˵ѣЦ','http://www.tudou.com/v/BEjzWEoNoko','0','','1218481699','0','swf');
INSERT INTO `p8_mv_video` VALUES ('99','ɰ','0','','2','ЦƵ','0','654','0','1199936427','1199936427','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/545/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ȴǡ','http://www.tudou.com/v/aik6AqGmkCU','0','','1218599010','0','swf');
INSERT INTO `p8_mv_video` VALUES ('100','Ц~~','0','','2','ЦƵ','0','748','0','1199936428','1199936428','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/317/621/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ц~~','http://www.tudou.com/v/NvgQHLAKLUc','0','','1218594112','0','swf');
INSERT INTO `p8_mv_video` VALUES ('101','ƽû(Цת)','0','','2','ЦƵ','0','476','0','1199936430','1199936430','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/283/844/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ц','http://www.tudou.com/v/pSy_kivdPnQ','0','','1218610659','0','swf');
INSERT INTO `p8_mv_video` VALUES ('102','ȹ--&gt;ϷԽĿСӰ-200710','0','','2','ЦƵ','0','401','0','1199936431','1199936431','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/289/386/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-ȹ-200710','http://www.tudou.com/v/4uSX9b5jrjA','0','','1218595750','0','swf');
INSERT INTO `p8_mv_video` VALUES ('103','ӵĽ','0','','2','ЦƵ','0','604','0','1199936433','1199936433','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/279/061/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ӵľƿ','http://www.tudou.com/v/eERTck05hT0','0','','1218223290','0','swf');
INSERT INTO `p8_mv_video` VALUES ('104','߳','0','','2','ЦƵ','0','348','0','1199936435','1199936435','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/311/413/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ŀֲ','http://www.tudou.com/v/Z6uTcqfzYWM','0','','1218460353','0','swf');
INSERT INTO `p8_mv_video` VALUES ('105','ǳϴｲ','0','','2','ЦƵ','0','374','0','1199936436','1199936436','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/307/634/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǳϴｲ','http://www.tudou.com/v/YFP2F5UARY8','0','','1218579668','0','swf');
INSERT INTO `p8_mv_video` VALUES ('106','ɾNGƬ','0','','2','ЦƵ','0','443','0','1199936438','1199936438','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/337/428/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ɾNGƬ','http://www.tudou.com/v/3fn6snKtEsg','0','','1218608576','0','swf');
INSERT INTO `p8_mv_video` VALUES ('107','ձǿ','0','','2','ЦƵ','0','733','0','1199936439','1199936439','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/311/482/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ձǿ','http://www.tudou.com/v/a9mrBR8BHJ0','0','','1218611230','0','swf');
INSERT INTO `p8_mv_video` VALUES ('108','10Ů˺1ˣ','0','','2','ЦƵ','0','426','0','1199936441','1199936441','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/332/669/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','10Ů˺1ˣ','http://www.tudou.com/v/_46Nw_qaq_w','0','','1218447422','0','swf');
INSERT INTO `p8_mv_video` VALUES ('109','ֲҹ','0','','2','ЦƵ','0','931','0','1199936443','1199936443','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/307/664/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ֲҹ','http://www.tudou.com/v/wDjCQx1dxss','0','','1218357213','0','swf');
INSERT INTO `p8_mv_video` VALUES ('110','վףԱɽ','0','','2','ЦƵ','0','1137','0','1199936444','1199936444','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/275/927/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','CCTV4վĿĽĿԭԱɽСƷסֶúܺãݷḻĬֵһ','http://www.tudou.com/v/VRHwW-Wl8sw','0','','1218520414','0','swf');
INSERT INTO `p8_mv_video` VALUES ('111','Ұ͵Ķ','0','','2','ЦƵ','0','699','0','1199936446','1199936446','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/283/426/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ͦЦ','http://www.tudou.com/v/JJlj9c540To','0','','1218577654','0','swf');
INSERT INTO `p8_mv_video` VALUES ('112','Ц-- ޹','0','','2','ЦƵ','0','373','0','1199936447','1199936447','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/302/299/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ϳ⡣','http://www.tudou.com/v/1FWITRbrRtE','0','','1218430375','0','swf');
INSERT INTO `p8_mv_video` VALUES ('113','_SEEDħF硷','0','','2','ЦƵ','0','314','0','1199936449','1199936449','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/331/444/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','_SEEDħF硷','http://www.tudou.com/v/GED-Ih_cLCQ','0','','1218610748','0','swf');
INSERT INTO `p8_mv_video` VALUES ('114','èè','0','','2','ЦƵ','0','446','0','1199936451','1199936451','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/672/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ϵͳ˵дϸЩϲˣ&lt;br /&gt;ҲŲҪϲء&lt;br /&gt;2008.01.08','http://www.tudou.com/v/qtlRNXtxtNY','0','','1218585835','0','swf');
INSERT INTO `p8_mv_video` VALUES ('115','ĲҪ̫','0','','2','ЦƵ','0','530','0','1199936453','1199936453','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/297/844/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ĲҪ̫!','http://www.tudou.com/v/3VH4TCQGcwY','0','','1218198647','0','swf');
INSERT INTO `p8_mv_video` VALUES ('116','Ӱ2.0 ĸɵB(B)','0','','2','ЦƵ','0','353','0','1199936454','1199936454','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/759/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Цģ','http://www.tudou.com/v/hRRJHZnuBDk','0','','1218268351','0','swf');
INSERT INTO `p8_mv_video` VALUES ('117','NGƬ','0','','2','ЦƵ','0','957','0','1199936456','1199936456','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/336/479/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','NGƬ','http://www.tudou.com/v/RyX02HZbEI0','0','','1218500331','0','swf');
INSERT INTO `p8_mv_video` VALUES ('118','ֲƬ--&gt;ϷԽĿСӰ-200710','0','','2','ЦƵ','0','565','0','1199936458','1199936458','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/843/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','YNTV2-ԽĿ-СӰ-ֲƬ-200710','http://www.tudou.com/v/zJsU4enE0Xw','0','','1218584895','0','swf');
INSERT INTO `p8_mv_video` VALUES ('119','2007˼ţxӰ','0','','2','ЦƵ','0','1344','1','1199936459','1199936459','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/283/563/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','2007˼ţxӰ','http://www.tudou.com/v/fmxrbXA7_oI','0','','1218611136','0','swf');
INSERT INTO `p8_mv_video` VALUES ('120','ԭ(ȫ21)','0','','2','ЦƵ','0','463','0','1199936461','1199936461','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/803/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ц,зʯͷɷ','http://www.tudou.com/v/lyIejr_jwRA','0','','1218591298','0','swf');
INSERT INTO `p8_mv_video` VALUES ('121','ߺ2','0','','2','ЦƵ','0','464','0','1199936462','1199936462','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/308/852/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ߺ桷ڶԤƬ','http://www.tudou.com/v/UD9ZORIuOFI','0','','1218603358','0','swf');
INSERT INTO `p8_mv_video` VALUES ('122','ƽû(Цת)','0','','2','ЦƵ','0','342','0','1199936464','1199936464','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/286/255/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ц','http://www.tudou.com/v/sZftvVfv3wc','0','','1218609301','0','swf');
INSERT INTO `p8_mv_video` VALUES ('123','NEWS-Ц!','0','','2','ЦƵ','0','380','0','1199936466','1199936466','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/297/642/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','NEWS-Ц!','http://www.tudou.com/v/1ZLaGl232mw','0','','1218603905','0','swf');
INSERT INTO `p8_mv_video` VALUES ('124','2007˼ţxӰ','0','','2','ЦƵ','0','361','0','1199936467','1199936467','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/980/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','2007˼ţxӰ','http://www.tudou.com/v/2cTvpXCwbfg','0','','1218380402','0','swf');
INSERT INTO `p8_mv_video` VALUES ('125',' vs ЦЦ  ʢ','0','','2','ЦƵ','0','427','0','1199936469','1199936469','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/969/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棨˵&lt;br /&gt;ѧԺ ַ&lt;br /&gt;&lt;br /&gt;www.xiaoxiaotuan.net','http://www.tudou.com/v/vzOjWnUItco','0','','1218607098','0','swf');
INSERT INTO `p8_mv_video` VALUES ('126','սӾƵ','0','','2','ЦƵ','0','741','0','1199936471','1199936471','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/307/668/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սӾƵ','http://www.tudou.com/v/u8dhqkjXwDc','0','','1218291754','0','swf');
INSERT INTO `p8_mv_video` VALUES ('127','ܽ(VIPƷ)','0','','2','ЦƵ','0','484','2','1199936472','1199936472','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/283/486/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','֣ɣеȥܽ׹ݳ&lt;br /&gt;Ʊͽ㹫лƵùôƯľ͵','http://www.tudou.com/v/ZCI-Uzg0uHo','0','','1218503619','0','swf');
INSERT INTO `p8_mv_video` VALUES ('128','ţ','0','','2','ЦƵ','0','713','0','1199936474','1199936474','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/080/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','GeekerVision.comϴ','http://www.tudou.com/v/0-1xzHIAIWw','0','','1218471442','0','swf');
INSERT INTO `p8_mv_video` VALUES ('129','ӵ˫ܵ','0','','2','ЦƵ','0','393','0','1199936475','1199936475','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/286/763/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ɽʦѧѧԺѧϰٿ֪ʶĲ岥Ƶ&lt;br /&gt;ԼŶ','http://www.tudou.com/v/zEDhSUXYtoA','0','','1218610799','0','swf');
INSERT INTO `p8_mv_video` VALUES ('130','','0','','2','ЦƵ','0','618','0','1199936477','1199936477','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/344/425/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','TDK','http://www.tudou.com/v/X-Dho0Mlhok','0','','1218550132','0','swf');
INSERT INTO `p8_mv_video` VALUES ('131','lonelyܻƺܱ','0','','2','ЦƵ','0','408','0','1199936478','1199936478','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/299/727/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','2008&lt;br /&gt;һ´һҹ֮&lt;br /&gt;˴ҵ&lt;br /&gt;ܻƺܱ&lt;br /&gt;ĿǰΪֹܶ&lt;br /&gt;Ըҳе棬&lt;br /&gt;⵽һҳ&lt;br /&gt;Ȼܹͬʱֱֻ&lt;br /&gt;ͬʱСĺܻƺܱ&lt;br /&gt;ʲô׼ںأ','http://www.tudou.com/v/GWFNyy9uoMU','0','','1218448605','0','swf');
INSERT INTO `p8_mv_video` VALUES ('132','','0','','2','ЦƵ','0','718','0','1199936480','1199936480','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/279/124/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Լͬڰ칫ĸЦ̾磬Ҳżһγ㼰ϣ֧֡','http://www.tudou.com/v/3V1bqiTAFU8','0','','1218610575','0','swf');
INSERT INTO `p8_mv_video` VALUES ('133','1Ц10ε¼','0','','2','ЦƵ','0','480','0','1199936482','1199936482','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/278/752/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','1Ц10ε¼','http://www.tudou.com/v/XiuzFfkDOn4','0','','1218576532','0','swf');
INSERT INTO `p8_mv_video` VALUES ('134','ܻƺܱ','0','','2','ЦƵ','0','450','0','1199936483','1199936483','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/846/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/yadjiRa5K-8','0','','1218592157','0','swf');
INSERT INTO `p8_mv_video` VALUES ('135','ٶ˵','0','','2','ЦƵ','0','574','0','1199936503','1199936503','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/330/440/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ٶ˵ ~~~','http://www.tudou.com/v/3sxkuKTJP9o','0','','1218590130','0','swf');
INSERT INTO `p8_mv_video` VALUES ('136','Ͻ˶','0','','2','ЦƵ','0','680','0','1199936505','1199936505','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/297/320/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ͻ˶','http://www.tudou.com/v/L-2PoU8Qe04','0','','1218610363','0','swf');
INSERT INTO `p8_mv_video` VALUES ('137','޵è','0','','2','ЦƵ','0','422','0','1199936507','1199936507','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/826/m0.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','޵è','http://www.tudou.com/v/m_MpASKBykY','0','','1218602519','0','swf');
INSERT INTO `p8_mv_video` VALUES ('138','ܻƣܱ~~~~','0','','2','ЦƵ','0','438','0','1199936508','1199936508','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/289/635/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ɣͯ˵ġ','http://www.tudou.com/v/NRm0sRcU408','0','','1218498720','0','swf');
INSERT INTO `p8_mv_video` VALUES ('139','ñк(޸Ц)','0','','2','ЦƵ','0','809','0','1199936510','1199936510','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/293/096/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','С','http://www.tudou.com/v/hvQkX4VQoVs','0','','1218464658','0','swf');
INSERT INTO `p8_mv_video` VALUES ('140','1','0','','2','ЦƵ','0','680','0','1199936511','1199936511','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/302/703/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ԭ!!!!ӫĻŮ!!!','http://www.tudou.com/v/NW0htofzHbw','0','','1218467463','0','swf');
INSERT INTO `p8_mv_video` VALUES ('141','ΣߵҪҪС!','0','','2','ЦƵ','0','335','0','1199936514','1199936514','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/318/729/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ΣߵҪҪС!','http://www.tudou.com/v/ehkhLnIzHYg','0','','1218543770','0','swf');
INSERT INTO `p8_mv_video` VALUES ('142','','0','','2','ЦƵ','0','470','0','1199936518','1199936518','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/585/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/kYovSo7d86s','0','','1218585573','0','swf');
INSERT INTO `p8_mv_video` VALUES ('143','ɰĸǴĴ','0','','2','ЦƵ','0','620','2','1199936520','1199936520','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/286/183/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','GeekerVision.comϴ','http://www.tudou.com/v/0P-7xi0Svsg','0','','1218594604','0','swf');
INSERT INTO `p8_mv_video` VALUES ('144','WӢZ','0','','2','ЦƵ','0','971','0','1199936522','1199936522','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/421/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','؈؈ҲҪС_ʼBZ','http://www.tudou.com/v/itxD01bDQ4E','0','','1218607886','0','swf');
INSERT INTO `p8_mv_video` VALUES ('145','ҹ׵','0','','2','ЦƵ','0','956','0','1199936524','1199936524','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/318/723/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ҹ׵','http://www.tudou.com/v/mp7XHvNe6dk','0','','1218584797','0','swf');
INSERT INTO `p8_mv_video` VALUES ('146','Ƶ---','0','','2','ЦƵ','0','1022','0','1199936525','1199936525','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/296/101/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ÿ춼ҪڱϣϹϲ̡','http://www.tudou.com/v/k0vRRdbJe74','0','','1218599344','0','swf');
INSERT INTO `p8_mv_video` VALUES ('147','ĵƪ','0','','2','ЦƵ','0','864','0','1199936527','1199936527','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/270/077/m15.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','...NGɤӶ','http://www.tudou.com/v/nEY5BZylbjA','0','','1218595672','0','swf');
INSERT INTO `p8_mv_video` VALUES ('148','ŮֽĿʱЦֹ','0','','2','ЦƵ','0','664','0','1199936529','1199936529','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/317/633/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','18յ ںMBCֱĿУ򲻵ЦŮǰĿ̨ݳձдƪ˾ܵ䶳ֿⷢըϢ˾ȻǵķŭMBC־ֳɾ8͸¶˵ʱŮǰԭǰе5ʱţɸոٵĺ־档&lt;br /&gt;&lt;br /&gt;ǰ176ʱ30ֲʱڽβͻȻЦ&lt;br /&gt;&lt;br /&gt;ǣдƪ˾ܵ䶳ֿⷢըϢڵĸоǡֻˣڶǰЦľٶС&lt;br /&gt;&lt;br /&gt;ɾʾΪŽгֵ¹ʣ˲ʽǸȴ໥Эһ־ٶȻ¹ʣΪ(Ϊ)̬ϴ⡣&lt;br /&gt;&lt;br /&gt;ǰ200612½MBC̨ĿǰMBCFM4U㲥Ŀֽ֡սĿ֪֪ˡս֮','http://www.tudou.com/v/QyZyrXCsr88','0','','1218460485','0','swf');
INSERT INTO `p8_mv_video` VALUES ('149','˹δ','0','','2','ЦƵ','0','1056','0','1199936530','1199936530','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/277/370/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ᳪ!','http://www.tudou.com/v/5mXY9v_64jk','0','','1218585173','0','swf');
INSERT INTO `p8_mv_video` VALUES ('150','Ц','0','','2','ЦƵ','0','1075','0','1199936532','1199936532','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/053/m35.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/PJa_wXmZ920','0','','1218597088','0','swf');
INSERT INTO `p8_mv_video` VALUES ('151','Ѿƽ֣΢Цף','0','','2','ЦƵ','0','858','0','1199936534','1199936534','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/297/872/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ѿƽ֣&lt;br /&gt;&lt;br /&gt;СâֳȻᶭŰŶ΢Цף','http://www.tudou.com/v/o_uGl_XJeMM','0','','1218602644','0','swf');
INSERT INTO `p8_mv_video` VALUES ('152','ѧУʵϰƬ1','0','','2','ЦƵ','0','912','1','1199936536','1199936536','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/286/343/m5.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','  ʽĴúٴ','http://www.tudou.com/v/x0Xf1CQSGJ8','0','','1218611076','0','swf');
INSERT INTO `p8_mv_video` VALUES ('153','ŮҲ³','0','','2','ЦƵ','0','1613','0','1199936537','1199936537','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/297/548/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ŮҲ³','http://www.tudou.com/v/4gvesiyggOw','0','','1218576916','0','swf');
INSERT INTO `p8_mv_video` VALUES ('154','Ůѹνֺּ','0','','2','ЦƵ','0','2742','5','1199936539','1199936539','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/321/980/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ůѹνֺּ','http://www.tudou.com/v/auyMheOyV8E','0','','1218610593','0','swf');
INSERT INTO `p8_mv_video` VALUES ('155','̵07ؼ(̵ִ)','0','','2','ЦƵ','0','1340','0','1199936540','1199936540','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/927/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','һ̵˸ոչȥ07֡¼ʲֱӰѵ»ʱлܹע¼&lt;br /&gt;ԭĲһǰӣɮ','http://www.tudou.com/v/VeYsRpluzx4','0','','1218589985','0','swf');
INSERT INTO `p8_mv_video` VALUES ('156','㡿07Ƭʾ¼','0','','2','ЦƵ','0','1914','3','1199936542','1199936542','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/907/m35.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','νգeBayɿ&lt;br /&gt;ɫ䣺Ů˲ɿ&lt;br /&gt;ƻ˲ɿ&lt;br /&gt;Ͷ״ֵܲɿ&lt;br /&gt;ţ֯ɿ&lt;br /&gt;˺תƣйƶɿ','http://www.tudou.com/v/x-FqPyLEpAw','0','','1218610548','0','swf');
INSERT INTO `p8_mv_video` VALUES ('157','䡿󷢵ţ','0','','2','ЦƵ','0','4697','5','1199936544','1199936544','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/098/m5.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ֹģ·ڡӢ۱ɫıݣţôûģʵıݵġ&lt;br /&gt;дϵΪȨУѧϰͽʹãδ߱ɣʹá','http://www.tudou.com/v/Fy1kiTNtnu0','0','','1218600705','0','swf');
INSERT INTO `p8_mv_video` VALUES ('158','Ŀ+è+Ӿװϼ','0','','3','Ƶ','0','4183','0','1199936889','1199936889','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/275/959/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ŀ+è+Ӿװϼ','http://www.tudou.com/v/QhmgbyncFpQ','0','','1218611707','0','swf');
INSERT INTO `p8_mv_video` VALUES ('159','03 ع һķŶ','0','','3','Ƶ','0','783','0','1199936890','1199936890','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/277/143/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˾ӵһ֧ḻտ۷Ƶ۷磬ڹݡ졢ɶϾСݵʮпͻ㣬ʽôͳ۷ʽ⣬ʵʩۣҵ񡣿ͻǰ˾ɹ̼ԱֳΪû滮أ̺ͷ󣬹˾ָרҵۺԱֳָͻװԺ͹滮豸','http://www.tudou.com/v/NGBGReJsEhs','0','','1218600301','0','swf');
INSERT INTO `p8_mv_video` VALUES ('160','Mariah Carey-Intel_Centrino(2006 Intel Centrino Commercial_Version2)','0','','3','Ƶ','0','697','0','1199936892','1199936892','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/333/289/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺&lt;br /&gt;2006 Intel_Centrino_Commercial_Version2','http://www.tudou.com/v/KjG3rVlGFI8','0','','1218610962','0','swf');
INSERT INTO `p8_mv_video` VALUES ('161','9 ع Ͽɰʯ','0','','3','Ƶ','0','328','0','1199936893','1199936893','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/277/017/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ѹ΢ĥҹ˾רҼȡȽ˳ϸ۷ּѹأ˹ڸϸƷ豸Ŀհףѹ΢ĥҪڳʯʯ̿ڵ500ϵĳϸۼӹϸ500-2500Ŀ֮ڡѹ΢ĥĥϵͳѹϵͳϵͳּϵͳɣѹ΢ĥĥ÷Χ㣬ĥۻȣѹ΢ĥߣܣȴѹǿһγϸȸߡ','http://www.tudou.com/v/RNE4iF6zBms','0','','1218600336','0','swf');
INSERT INTO `p8_mv_video` VALUES ('162','2 ع ʯ豸','0','','3','Ƶ','0','285','0','1199936895','1199936895','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/276/774/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˾ҪƷ񶯸ϻϵСʽϵСʽϵСֱͨʽɰϵСɸϵСϴɰϵСĥϵСѹĥۻϵСĥۻϵСֱͨʽĥۻϵУרƤͻ10ϵСʮֹƷѡ豸㷺Ӧڿҵұ𡢽ġú̿ͻϵҵ˾ӲƷΪҵƷϸIS09002֤ϵ׼ҪʵĥϺȽļӹգʹ豸ĥ⣬ԶӡᡢĴǡԽϡʡ˹˹̹޵ȹҺ͵','http://www.tudou.com/v/b1p6wmj9W-Y','0','','1218600340','0','swf');
INSERT INTO `p8_mv_video` VALUES ('163','','0','','3','Ƶ','0','398','0','1199936897','1199936897','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/315/459/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/na2kBVWWOxI','0','','1218600907','0','swf');
INSERT INTO `p8_mv_video` VALUES ('164','MAYA','0','','3','Ƶ','0','309','0','1199936898','1199936898','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/313/980/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ϺӰѧԺ06ѧҵڲ֣Ʒҹ','http://www.tudou.com/v/Or_uC81MH54','0','','1218600351','0','swf');
INSERT INTO `p8_mv_video` VALUES ('165','domestos','0','','3','Ƶ','0','512','0','1199936900','1199936900','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/308/384/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','domestos','http://www.tudou.com/v/54BtS2Y4uys','0','','1218611052','0','swf');
INSERT INTO `p8_mv_video` VALUES ('166',' ڴ֮ Ҳ ׶󴽸','0','','3','Ƶ','0','281','0','1199936901','1199936901','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/299/262/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ĺ~~~~','http://www.tudou.com/v/0i5y3UxEKcQ','0','','1218600362','0','swf');
INSERT INTO `p8_mv_video` VALUES ('167','ľ ɴ Mister Donut Chp3. ե졸дƪ','0','','3','Ƶ','0','231','17','1199936903','1199936903','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/330/318/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ľ ɴ Mister Donut Chp3. ե졸дƪ','http://www.tudou.com/v/BljNTk2kEOE','0','','1218598007','0','swf');
INSERT INTO `p8_mv_video` VALUES ('168','moto vfx','0','','3','Ƶ','0','221','0','1199936904','1199936904','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/309/142/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','moto v3','http://www.tudou.com/v/5vLFf4fPfZU','0','','1218610714','0','swf');
INSERT INTO `p8_mv_video` VALUES ('169','ս','0','','3','Ƶ','0','219','0','1199936906','1199936906','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/030/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','²Ʒ','http://www.tudou.com/v/lNWONRTfMB4','0','','1218460151','0','swf');
INSERT INTO `p8_mv_video` VALUES ('170','','0','','3','Ƶ','0','323','0','1199936907','1199936907','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/279/745/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/R-wQwXnAKWE','0','','1218566935','0','swf');
INSERT INTO `p8_mv_video` VALUES ('171','wo de ','0','','3','Ƶ','0','212','0','1199936909','1199936909','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/282/078/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ĺҵ','http://www.tudou.com/v/4ohWxqH-baE','0','','1218583535','0','swf');
INSERT INTO `p8_mv_video` VALUES ('172','5 ع ʮʯ','0','','3','Ƶ','0','151','0','1199936910','1199936910','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/276/886/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ѹ΢ĥҹ˾רҼȡȽ˳ϸ۷ּѹأ˹ڸϸƷ豸Ŀհףѹ΢ĥҪڳʯʯ̿ڵ500ϵĳϸۼӹϸ500-2500Ŀ֮ڡѹ΢ĥĥϵͳѹϵͳϵͳּϵͳɣѹ΢ĥĥ÷Χ㣬ĥۻȣѹ΢ĥߣܣȴѹǿһγϸȸߡ','http://www.tudou.com/v/5bDr8jK_iBA','0','','1218608833','0','swf');
INSERT INTO `p8_mv_video` VALUES ('173','[CM] honda amai wana δ','0','','3','Ƶ','0','665','0','1199936912','1199936912','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/331/282/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','[CM] honda amai wana δ','http://www.tudou.com/v/74IQ8ul93SA','0','','1218579748','0','swf');
INSERT INTO `p8_mv_video` VALUES ('174','Nikeǵʧƪ','0','','3','Ƶ','0','186','0','1199936913','1199936913','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/316/912/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Nikeǵʧƪ','http://www.tudou.com/v/wR6Le6l_9rk','0','','1218608408','0','swf');
INSERT INTO `p8_mv_video` VALUES ('175','޶KT  JIN','0','','3','Ƶ','0','286','0','1199936915','1199936915','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/304/864/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','޶KT  JIN','http://www.tudou.com/v/23zPeJnb6Os','0','','1218611089','0','swf');
INSERT INTO `p8_mv_video` VALUES ('176','SE7EN,(Сͯ)~~039ѩV','0','','3','Ƶ','0','285','0','1199936916','1199936916','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/313/672/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','SE7EN,(Сͯ)~~039ѩV','http://www.tudou.com/v/6gf4JQruItA','0','','1218610768','0','swf');
INSERT INTO `p8_mv_video` VALUES ('177','X VZX CVC','0','','3','Ƶ','0','210','0','1199936918','1199936918','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/345/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ASBD F  D NDFNGSNG','http://www.tudou.com/v/zCfVSvaDqA8','0','','1218366736','0','swf');
INSERT INTO `p8_mv_video` VALUES ('178','Ϳշбݶ','0','','3','Ƶ','0','418','0','1199936920','1199936920','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/271/654/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ṩ洬ɻԳˡԷɡϵ绰075581616781ƶ13544145685 ','http://www.tudou.com/v/ow7Q26QFa-8','0','','1218272980','0','swf');
INSERT INTO `p8_mv_video` VALUES ('179','ֳµĵ濩','0','','3','Ƶ','0','1061','31','1199936921','1199936921','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/303/780/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','³뵥A200ȶΪ졣','http://www.tudou.com/v/mbeCvSuTZFQ','0','','1218600652','0','swf');
INSERT INTO `p8_mv_video` VALUES ('180','桿Ůײ','0','','3','Ƶ','0','314','0','1199936923','1199936923','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/286/835/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','桿Ůײ','http://www.tudou.com/v/2gl7i76hg6o','0','','1218581700','0','swf');
INSERT INTO `p8_mv_video` VALUES ('181','̩','0','','3','Ƶ','0','498','0','1199936924','1199936924','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/293/279/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','̩йõķ','http://www.tudou.com/v/OaESjLyJWDU','0','','1218579618','0','swf');
INSERT INTO `p8_mv_video` VALUES ('182','¹','0','','3','Ƶ','0','503','0','1199936926','1199936926','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/312/462/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','óѧԺ  ','http://www.tudou.com/v/oPSfxe2EqSM','0','','1218600391','0','swf');
INSERT INTO `p8_mv_video` VALUES ('183','٥å`  ','0','','3','Ƶ','0','217','0','1199936927','1199936927','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/100/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/Qc8ckDMDP3U','0','','1218435109','0','swf');
INSERT INTO `p8_mv_video` VALUES ('184','Ϳ˹','0','','3','Ƶ','0','601','0','1199936929','1199936929','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/321/080/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ϳ˹','http://www.tudou.com/v/i_SdFsm7ozc','0','','1218526983','0','swf');
INSERT INTO `p8_mv_video` VALUES ('185','ţ','0','','3','Ƶ','0','451','0','1199936930','1199936930','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/344/779/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ţ̺ô','http://www.tudou.com/v/b4cZF1KHxmQ','0','','1218462216','0','swf');
INSERT INTO `p8_mv_video` VALUES ('186','ľ ɴ Mister Donut Chp5.֥ɡ_ƪ','0','','3','Ƶ','0','264','0','1199936932','1199936932','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/330/687/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ľ ɴ Mister Donut Chp5.֥ɡ_ƪ','http://www.tudou.com/v/-3uunrRr21k','0','','1218543534','0','swf');
INSERT INTO `p8_mv_video` VALUES ('187','8 ع 鱦ɰ','0','','3','Ƶ','0','160','0','1199936934','1199936934','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/276/980/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ʽҹ˾еоȡ˹˾Ƚзɹһָܵͺ豸&quot;ʯʯ&quot;ԭʹлײ飬Ʒͺã˻豸ĥ˳ƷĲȫϹҽɰʯ׼㷺Ӧڸٹ·򡣹ؼĥøӸĥϣʹڳڹڶʡݿṩ豸ʹֳûιۿ졣Ƶ豸ۺŶΪͻṩϵͳıϣӦ򵥣㡣','http://www.tudou.com/v/qVITsMjUWC8','0','','1218197120','0','swf');
INSERT INTO `p8_mv_video` VALUES ('188','̨δŵ¹','0','','3','Ƶ','0','298','0','1199936935','1199936935','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/312/095/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','¹棬δŵ','http://www.tudou.com/v/ji0djRmieSA','0','','1218606178','0','swf');
INSERT INTO `p8_mv_video` VALUES ('189','˹ٶ','0','','3','Ƶ','0','188','0','1199936937','1199936937','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/123/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˹ٶ','http://www.tudou.com/v/jBZPyDRgkQQ','0','','1218330380','0','swf');
INSERT INTO `p8_mv_video` VALUES ('190','stage6ƵƵ','0','','3','Ƶ','0','195','0','1199936938','1199936938','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/327/465/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','״̬','http://www.tudou.com/v/8TMxAor8T7g','0','','1218269311','0','swf');
INSERT INTO `p8_mv_video` VALUES ('191','RAĮ','0','','3','Ƶ','0','255','0','1199936940','1199936940','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/281/354/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','RAĮ','http://www.tudou.com/v/KzUyPyrUFpI','0','','1218579468','0','swf');
INSERT INTO `p8_mv_video` VALUES ('192','Matt&#39;s ()brother','0','','3','Ƶ','0','294','32','1199936942','1199936942','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/318/866/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','аĸĹ','http://www.tudou.com/v/hWkSjEfsLyU','0','','1218598008','0','swf');
INSERT INTO `p8_mv_video` VALUES ('193','ˮ峺ˮ','0','','3','Ƶ','0','260','0','1199936943','1199936943','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/023/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ˮ峺ˮ&lt;br /&gt;','http://www.tudou.com/v/Qty_WQmck0A','0','','1218579578','0','swf');
INSERT INTO `p8_mv_video` VALUES ('194','й','0','','3','Ƶ','0','828','0','1199936945','1199936945','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/289/728/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','йأ','http://www.tudou.com/v/KYvC6nzsdVs','0','','1218564015','0','swf');
INSERT INTO `p8_mv_video` VALUES ('195','10 ع ҪƷ','0','','3','Ƶ','0','187','31','1199936946','1199936946','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/277/748/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˾ҪƷ񶯸ϻϵСʽϵСʽϵСֱͨʽɰϵСɸϵСϴɰϵСĥϵСѹĥۻϵСĥۻϵСֱͨʽĥۻϵУרƤͻ10ϵСʮֹƷѡ豸㷺Ӧڿҵұ𡢽ġú̿ͻϵҵ˾ӲƷΪҵƷϸIS09002֤ϵ׼ҪʵĥϺȽļӹգʹ豸ĥ⣬ԶӡᡢĴǡԽϡʡ˹˹̹޵ȹҺ͵','http://www.tudou.com/v/eJLmPffCECA','0','','1218598008','0','swf');
INSERT INTO `p8_mv_video` VALUES ('196','º','0','','3','Ƶ','0','256','0','1199936948','1199936948','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/318/712/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/lR-QcO6Ku2k','0','','1218444121','0','swf');
INSERT INTO `p8_mv_video` VALUES ('197','adidas 2','0','','3','Ƶ','0','479','62','1199936949','1199936949','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/308/351/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','adidas&lt;br /&gt;ûв','http://www.tudou.com/v/zAYh9sJx2WU','0','','1218600654','0','swf');
INSERT INTO `p8_mv_video` VALUES ('198','¹','0','','3','Ƶ','0','413','0','1199936951','1199936951','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/286/234/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','¹~~~~','http://www.tudou.com/v/26_GojRMQuU','0','','1218597542','0','swf');
INSERT INTO `p8_mv_video` VALUES ('199','ٍX','0','','3','Ƶ','0','856','0','1199936952','1199936952','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/278/697/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','СٍX','http://www.tudou.com/v/MAnR1gYE5uc','0','','1218557120','0','swf');
INSERT INTO `p8_mv_video` VALUES ('200','bt Ӣ','0','','3','Ƶ','0','264','0','1199936954','1199936954','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/309/301/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','bt ӢŹ','http://www.tudou.com/v/7x7-tR5-gO0','0','','1218253733','0','swf');
INSERT INTO `p8_mv_video` VALUES ('201','whisen_ad','0','','3','Ƶ','0','188','0','1199936955','1199936955','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/347/904/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','whisen_ad','http://www.tudou.com/v/Ooqr25-cmM0','0','','1218547825','0','swf');
INSERT INTO `p8_mv_video` VALUES ('202','γ-CF-maxwellhouse(3)','0','','3','Ƶ','0','503','0','1199936957','1199936957','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/346/257/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ž..γܵ,ʮ֪ʶ..֮.','http://www.tudou.com/v/kBjkaQRVBPg','0','','1218443463','0','swf');
INSERT INTO `p8_mv_video` VALUES ('203','γ-CF-maxwellhouse(2)','0','','3','Ƶ','0','582','0','1199936959','1199936959','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/346/175/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ѧУ԰ƪ...','http://www.tudou.com/v/m3ptspGAw9g','0','','1218602391','0','swf');
INSERT INTO `p8_mv_video` VALUES ('204','[CM] kingdom 30Sδ','0','','3','Ƶ','0','341','0','1199936960','1199936960','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/341/053/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','[CM] kingdom 30Sδ','http://www.tudou.com/v/cMRDD6jRmOQ','0','','1218584806','0','swf');
INSERT INTO `p8_mv_video` VALUES ('205','527Ƭͷ','0','','3','Ƶ','0','207','0','1199936962','1199936962','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/282/662/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ҵ','http://www.tudou.com/v/kUtk077hXtU','0','','1218396219','0','swf');
INSERT INTO `p8_mv_video` VALUES ('206','MTV','0','','3','Ƶ','0','190','0','1199936963','1199936963','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/316/990/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','̨豸ƸMTVãҪЦ......','http://www.tudou.com/v/F2w9AMFtRVE','0','','1218546070','0','swf');
INSERT INTO `p8_mv_video` VALUES ('207','adidas','0','','3','Ƶ','0','350','0','1199936965','1199936965','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/307/717/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','adidas','http://www.tudou.com/v/yOcqBdSpZSw','0','','1218539890','0','swf');
INSERT INTO `p8_mv_video` VALUES ('208','Dior homme Autumn/Winter 2005/06','0','','3','Ƶ','0','209','0','1199936966','1199936966','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/307/627/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Hedi Slimane is a man who wears his passion for music on his sleeveand his trouser leg, his back, his head, and pretty much anywhere else. Any body part, in other words, that can bear an item of clothing that broadcasts its wearer&#39;s absolute surrender to rock&#39;s urgency and drive and drama.&lt;br /&gt;&lt;br /&gt;In translating all of that into a fashion context, Slimane has created his own distinct aesthetic: part David Bowie in his elegantly wasted mid-seventies incarnation as the Thin White Duke; part Bobby Gillespie of Primal Scream in his equally wasted mid-nineties phase; and, now, part Pete Doherty, ex-member of the London-based Libertines, who brings elegance, grunge, and conspicuous waste together in one tabloid-friendly package. With Gillespie, and Doherty&#39;s current squeeze, Kate Moss, in the front row, Slimane unleashed a collection that injected glam into last season&#39;s Seattle-based grunginess. Sequined jackets and jeans were the most obvious examples, but a black leather jacket decorated with leather rosettes, and a little jacket also embellished with rosettes, this time in tiny beads, suggested that early-seventies moment when Marc Bolan and Bowie would swap clothes with their wives. The back of a cropped black satin jacket featured a firework starburst of gold embroidery. A black ruffled cape over a flesh-toned ruffled shirt was a reminder of times when young rockers would scour secondhand shops for something flashyand, preferably, sexually ambiguous.&lt;br /&gt;&lt;br /&gt;Slimane is infatuated with the vulnerability and cockiness of those young men. He gave them a leather trench or gold Cuban-heeled boots for rock star swagger, but also shirts with big poet&#39;s bows or fragile transparent blouses for their softer side. And the long scarves and big fringed woolen capes? Clearly something a girlfriend would knit while the group was on tour.&lt;br /&gt;&lt;br /&gt; Tim Blanks','http://www.tudou.com/v/xg3pGfoY6m0','0','','1218559728','0','swf');
INSERT INTO `p8_mv_video` VALUES ('209','Ϳ˹','0','','3','Ƶ','0','976','0','1199936968','1199936968','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/320/975/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ϳ˹','http://www.tudou.com/v/ZGsY3m3VKS4','0','','1218609144','0','swf');
INSERT INTO `p8_mv_video` VALUES ('210','','0','','3','Ƶ','0','896','0','1199936972','1199936972','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/334/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/5f0vrN32Los','0','','1218603887','0','swf');
INSERT INTO `p8_mv_video` VALUES ('211','Amerie - 1 Thing Live','0','','3','Ƶ','0','410','0','1199936974','1199936974','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/302/872/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Amerie - 1 Thing','http://www.tudou.com/v/CrAosCIoLK0','0','','1218406184','0','swf');
INSERT INTO `p8_mv_video` VALUES ('212','Mariah Carey-VH1_Save The Music-Commercial-1998-Version2','0','','3','Ƶ','0','319','0','1199936976','1199936976','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/333/400/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺&lt;br /&gt;VH1_Save The Music-Commercial-1998-Version2','http://www.tudou.com/v/CInN8Bt-r58','0','','1218451931','0','swf');
INSERT INTO `p8_mv_video` VALUES ('213','','0','','3','Ƶ','0','589','0','1199936977','1199936977','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/286/412/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','with english subtitles&lt;br /&gt;ӢĻ&lt;br /&gt;&lt;br /&gt;Ʒ: &quot;Bonjour Paris&quot; l&#39;ecole.French school.','http://www.tudou.com/v/wqSJdqOFh5c','0','','1218607638','0','swf');
INSERT INTO `p8_mv_video` VALUES ('214','Mariah Carey-Sokenbicha(2004 Japan Hana_Version)','0','','3','Ƶ','0','642','0','1199936979','1199936979','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/333/003/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺&lt;br /&gt;Sokenbicha_Commercial_Hana_Version','http://www.tudou.com/v/2hRMfVDWlzE','0','','1218462303','0','swf');
INSERT INTO `p8_mv_video` VALUES ('215','ţ̰','0','','3','Ƶ','0','229','0','1199936980','1199936980','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/344/326/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ţ̺ô','http://www.tudou.com/v/AwRVeewhBQE','0','','1218576779','0','swf');
INSERT INTO `p8_mv_video` VALUES ('216','ȫ','0','','3','Ƶ','0','472','0','1199936982','1199936982','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/291/572/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ȫ','http://www.tudou.com/v/FNA804NsHwM','0','','1218610840','0','swf');
INSERT INTO `p8_mv_video` VALUES ('217','Mariah Carey-Sokenbicha(2004 Japan Orimono_Version)','0','','3','Ƶ','0','400','0','1199936983','1199936983','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/333/048/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺&lt;br /&gt;Sokenbicha_Commercial_Orimono_Version','http://www.tudou.com/v/RXPm5B1D-SI','0','','1218452762','0','swf');
INSERT INTO `p8_mv_video` VALUES ('218','Mariah Carey-Sony Minidisk Ad(Japan_1991)','0','','3','Ƶ','0','358','0','1199936985','1199936985','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/332/746/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺Sony Minidisk-Ad-Japan-1991','http://www.tudou.com/v/bCD635Is0Gc','0','','1218597290','0','swf');
INSERT INTO `p8_mv_video` VALUES ('219','ֹ','0','','3','Ƶ','0','332','0','1199936990','1199936990','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/302/498/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ֹ','http://www.tudou.com/v/eN65QEVo5vQ','0','','1218449030','0','swf');
INSERT INTO `p8_mv_video` VALUES ('220','ľ ɴ Mister Donut Chp1. Խƪ','0','','3','Ƶ','0','363','31','1199936992','1199936992','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/329/943/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ľ ɴ Mister Donut Chp1. Խƪ','http://www.tudou.com/v/dTu8oXXcU30','0','','1218597929','0','swf');
INSERT INTO `p8_mv_video` VALUES ('221','Mariah Carey-Nescaf(2000 Japan Ad_Ver1)','0','','3','Ƶ','0','296','0','1199936993','1199936993','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/333/149/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺Nescaf 2000_Japanese_Ad_Version 1','http://www.tudou.com/v/LZsekdWyxKY','0','','1218576736','0','swf');
INSERT INTO `p8_mv_video` VALUES ('222','MAZDA','0','','3','Ƶ','0','299','0','1199936995','1199936995','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/291/732/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','MAZDA','http://www.tudou.com/v/HucNRT2E7aA','0','','1218562175','0','swf');
INSERT INTO `p8_mv_video` VALUES ('223','ǣ','0','','3','Ƶ','0','504','0','1199936996','1199936996','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/228/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/i5cPGaIE3Kw','0','','1218595259','0','swf');
INSERT INTO `p8_mv_video` VALUES ('224','PS2','0','','3','Ƶ','0','340','0','1199936998','1199936998','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/289/081/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','PS2','http://www.tudou.com/v/tna7SUv2EM8','0','','1218282968','0','swf');
INSERT INTO `p8_mv_video` VALUES ('225','Mariah Carey-Nescaf(2000 Japan Ad_Ver2)','0','','3','Ƶ','0','303','0','1199936999','1199936999','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/332/933/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺Nescaf 2000_Japanese_Ad_Version 2','http://www.tudou.com/v/cLlkZFC4g90','0','','1218485825','0','swf');
INSERT INTO `p8_mv_video` VALUES ('226','','0','','3','Ƶ','0','339','0','1199937001','1199937001','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/959/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/ZdmmvKHtOfk','0','','1218486363','0','swf');
INSERT INTO `p8_mv_video` VALUES ('227','Mariah Carey-Lipstick(Commercial_1996)','0','','3','Ƶ','0','1357','0','1199937002','1199937002','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/332/861/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺Lipstick_Commercial_1996','http://www.tudou.com/v/PdzbRasm2IA','0','','1218599728','0','swf');
INSERT INTO `p8_mv_video` VALUES ('228','1 ع .WMV','0','','3','Ƶ','0','188','0','1199937004','1199937004','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/276/753/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˾ҪƷ񶯸ϻϵСʽϵСʽϵСֱͨʽɰϵСɸϵСϴɰϵСĥϵСѹĥۻϵСĥۻϵСֱͨʽĥۻϵУרƤͻ10ϵСʮֹƷѡ豸㷺Ӧڿҵұ𡢽ġú̿ͻϵҵ˾ӲƷΪҵƷϸIS09002֤ϵ׼ҪʵĥϺȽļӹգʹ豸ĥ⣬ԶӡᡢĴǡԽϡʡ˹˹̹޵ȹҺ͵','http://www.tudou.com/v/iJwCYR1udjo','0','','1218232227','0','swf');
INSERT INTO `p8_mv_video` VALUES ('229','Դ','0','','3','Ƶ','0','309','0','1199937005','1199937005','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/432/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Դ','http://www.tudou.com/v/7sDfjCOm9G0','0','','1218488075','0','swf');
INSERT INTO `p8_mv_video` VALUES ('230','׷Ϸ','0','','3','Ƶ','0','357','0','1199937007','1199937007','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/286/170/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','׷Ϸ','http://www.tudou.com/v/aqzg91b9E6Y','0','','1218589935','0','swf');
INSERT INTO `p8_mv_video` VALUES ('231','Ա','0','','3','Ƶ','0','510','0','1199937009','1199937009','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/279/909/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ա','http://www.tudou.com/v/PFP0RytIyBw','0','','1218597774','0','swf');
INSERT INTO `p8_mv_video` VALUES ('232','[]ʵ5ë/','0','','3','Ƶ','0','410','0','1199937010','1199937010','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/291/728/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','.ܸЦ.&lt;br /&gt;&quot;1(13) ù.೤.Ʈ..','http://www.tudou.com/v/bLH2FIkG3E8','0','','1218530037','0','swf');
INSERT INTO `p8_mv_video` VALUES ('233','','0','','3','Ƶ','0','231','0','1199937012','1199937012','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/317/279/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/uJignIWhL4w','0','','1218595300','0','swf');
INSERT INTO `p8_mv_video` VALUES ('234','Beyonc - True Star Commercial','0','','3','Ƶ','0','301','0','1199937014','1199937014','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/319/603/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Beyonc - True Star Commercial','http://www.tudou.com/v/gfutIpmmCA4','0','','1218596020','0','swf');
INSERT INTO `p8_mv_video` VALUES ('235','Mariah Carey-AEON(Commercial_1997)','0','','3','Ƶ','0','410','0','1199937015','1199937015','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/333/151/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺AEON_Commercial_Japan_1997','http://www.tudou.com/v/G9vVup_vD9o','0','','1218610870','0','swf');
INSERT INTO `p8_mv_video` VALUES ('236','ľ ɴ Mister Donut Chp2. Oסƪ','0','','3','Ƶ','0','375','0','1199937017','1199937017','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/330/113/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ľ ɴ Mister Donut Chp2. Oסƪ','http://www.tudou.com/v/yAakaWQ2cd0','0','','1218494639','0','swf');
INSERT INTO `p8_mv_video` VALUES ('237','Mariah Carey-2006 Intel Centrino Commercial_Version1','0','','3','Ƶ','0','451','0','1199937019','1199937019','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/335/570/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺&lt;br /&gt;2006 Intel_Centrino_Commercial_Version1','http://www.tudou.com/v/eHT-EPV6ThY','0','','1218562155','0','swf');
INSERT INTO `p8_mv_video` VALUES ('238',',Beauty Credit','0','','3','Ƶ','0','324','0','1199937021','1199937021','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/346/640/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0',',Beauty Credit','http://www.tudou.com/v/qA0Qb7tcztk','0','','1218458042','0','swf');
INSERT INTO `p8_mv_video` VALUES ('239','ԭĹ','0','','3','Ƶ','0','371','0','1199937023','1199937023','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/282/435/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ԭ','http://www.tudou.com/v/AivPNQXFFGE','0','','1218582383','0','swf');
INSERT INTO `p8_mv_video` VALUES ('240','','0','','3','Ƶ','0','666','0','1199937024','1199937024','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/281/529/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/1a-QRbJjKbA','0','','1218529973','0','swf');
INSERT INTO `p8_mv_video` VALUES ('241','Mariah Carey-Pepsi Commercial 2006','0','','3','Ƶ','0','334','0','1199937026','1199937026','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/337/770/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺&lt;br /&gt;Pepsi Commercial_05-06-DVD','http://www.tudou.com/v/uoVtOrONegc','0','','1218584212','0','swf');
INSERT INTO `p8_mv_video` VALUES ('242','ǿ ݰ','0','','3','Ƶ','0','243','0','1199937028','1199937028','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/289/557/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','babygala','http://www.tudou.com/v/s9uZS7XUpbQ','0','','1218610779','0','swf');
INSERT INTO `p8_mv_video` VALUES ('243','08','0','','3','Ƶ','0','327','0','1199937029','1199937029','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/334/738/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','sammi','http://www.tudou.com/v/wt7b7bOPLm8','0','','1218598247','0','swf');
INSERT INTO `p8_mv_video` VALUES ('244','Mariah Carey-Sony_MD Ad(Japan_1993)','0','','3','Ƶ','0','289','0','1199937031','1199937031','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/332/863/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺Sony_MD_Commercial_Japan_1993','http://www.tudou.com/v/sztpQ3iAHeg','0','','1218610655','0','swf');
INSERT INTO `p8_mv_video` VALUES ('245','2008ӸİƬ','0','','3','Ƶ','0','352','0','1199937032','1199937032','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/339/053/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ֱҵҳ','http://www.tudou.com/v/l4DhPGhCMjs','0','','1218586923','0','swf');
INSERT INTO `p8_mv_video` VALUES ('246','','0','','3','Ƶ','0','244','0','1199937034','1199937034','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/099/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','&lt;br /&gt;ʲô?','http://www.tudou.com/v/n4oYT0tjKjQ','0','','1218547622','0','swf');
INSERT INTO `p8_mv_video` VALUES ('247','ǿ 30','0','','3','Ƶ','0','354','0','1199937036','1199937036','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/288/738/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','babygala','http://www.tudou.com/v/XEQ-vG-gfbk','0','','1218580452','0','swf');
INSERT INTO `p8_mv_video` VALUES ('248','ľ ɴ Mister Donut Chp6.֥ɡɤƪ','0','','3','Ƶ','0','349','32','1199937038','1199937038','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/330/893/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ľ ɴ Mister Donut Chp6.֥ɡɤƪ','http://www.tudou.com/v/Jl0hXLW6ubM','0','','1218597928','0','swf');
INSERT INTO `p8_mv_video` VALUES ('249','SMAP CM NAKAI ɰϵ UNO֮µƪ','0','','3','Ƶ','0','630','0','1199937040','1199937040','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/333/516/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','SMAP CM NAKAI ɰϵ UNO֮µƪ&lt;br /&gt;⺢ۻûһ......','http://www.tudou.com/v/qdKbAPlfZ0c','0','','1218581596','0','swf');
INSERT INTO `p8_mv_video` VALUES ('250','Vitasoy S - Әƪ','0','','3','Ƶ','0','1177','0','1199937041','1199937041','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/284/210/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Vitasoy S - Әƪ','http://www.tudou.com/v/kCRG4UYGk0k','0','','1218611150','0','swf');
INSERT INTO `p8_mv_video` VALUES ('251','Becky ','0','','3','Ƶ','0','441','0','1199937043','1199937043','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/229/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Becky  ','http://www.tudou.com/v/sbTA2d84zhA','0','','1218585644','0','swf');
INSERT INTO `p8_mv_video` VALUES ('252','˾ͱ','0','','3','Ƶ','0','640','0','1199937044','1199937044','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/278/983/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˾ͱ','http://www.tudou.com/v/avaUy3ggiw0','0','','1218609649','0','swf');
INSERT INTO `p8_mv_video` VALUES ('253','EVAFLOR NESS ','0','','3','Ƶ','0','493','0','1199937046','1199937046','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/288/592/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ΪEVAFLOR NESSĹ棬ˮ','http://www.tudou.com/v/MZscEnoMSfQ','0','','1218547806','0','swf');
INSERT INTO `p8_mv_video` VALUES ('254','ТGIORDANO-CF','0','','3','Ƶ','0','412','0','1199937047','1199937047','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/312/006/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ТGIORDANO SOLO','http://www.tudou.com/v/jcQgmt3YKNg','0','','1218605429','0','swf');
INSERT INTO `p8_mv_video` VALUES ('255','̨.DAT','0','','3','Ƶ','0','269','0','1199937049','1199937049','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/277/408/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','̨.DAT','http://www.tudou.com/v/tAEXc9Ni4o0','0','','1218604015','0','swf');
INSERT INTO `p8_mv_video` VALUES ('256','ֵʿװ','0','','3','Ƶ','0','778','0','1199937050','1199937050','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/281/045/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ֵʿװ','http://www.tudou.com/v/elHPGeRiP8Y','0','','1218580998','0','swf');
INSERT INTO `p8_mv_video` VALUES ('257','Britney Spears - Toyota Comercial','0','','3','Ƶ','0','594','0','1199937052','1199937052','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/319/863/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Britney Spears - Toyota Comercial','http://www.tudou.com/v/kmREZGWGiEQ','0','','1218198486','0','swf');
INSERT INTO `p8_mv_video` VALUES ('258','Referee','0','','3','Ƶ','0','518','0','1199937053','1199937053','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/293/011/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Get a Mac','http://www.tudou.com/v/GpoE7A5zE2w','0','','1218600112','0','swf');
INSERT INTO `p8_mv_video` VALUES ('259','ľ ɴ Mister Donut Chp4. ֥ɡ䤫ʳƪ','0','','3','Ƶ','0','1327','0','1199937055','1199937055','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/330/470/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ľ ɴ Mister Donut Chp4. ֥ɡ䤫ʳƪ','http://www.tudou.com/v/GY4Vqa5jhR4','0','','1218599894','0','swf');
INSERT INTO `p8_mv_video` VALUES ('260','ơƹ','0','','3','Ƶ','0','665','0','1199937056','1199937056','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/278/629/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ơƹ&lt;br /&gt;','http://www.tudou.com/v/Bz2lQ_mLiWI','0','','1218600156','0','swf');
INSERT INTO `p8_mv_video` VALUES ('261','Ůҽ鲡','0','','3','Ƶ','0','603','0','1199937058','1199937058','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/348/278/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ǻ~~','http://www.tudou.com/v/dTFmeN5tBis','0','','1218597840','0','swf');
INSERT INTO `p8_mv_video` VALUES ('262','','0','','3','Ƶ','0','714','0','1199937063','1199937063','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/731/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/bwX0OiWQHk4','0','','1218506812','0','swf');
INSERT INTO `p8_mv_video` VALUES ('263','43ȫж','0','','3','Ƶ','0','312','0','1199937064','1199937064','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/316/821/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','43ȫж','http://www.tudou.com/v/6sMNozp5DSw','0','','1218539567','0','swf');
INSERT INTO `p8_mv_video` VALUES ('264','08CM_NTTxWii-a(30sec.)','0','','3','Ƶ','0','433','0','1199937066','1199937066','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/292/163/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','08Wii桭&lt;br /&gt;ikko shanĳѽ','http://www.tudou.com/v/bmgmJj7QAqo','0','','1218608459','0','swf');
INSERT INTO `p8_mv_video` VALUES ('265','˻','0','','3','Ƶ','0','416','0','1199937067','1199937067','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/278/555/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˻','http://www.tudou.com/v/g-NpQXip0Jk','0','','1218518761','0','swf');
INSERT INTO `p8_mv_video` VALUES ('266','Mariah Carey-Sokenbicha(2004 Japan Butterfly_Version)','0','','3','Ƶ','0','1129','0','1199937069','1199937069','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/333/007/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','棺Sokenbicha_Commercial_Butterfly_Version','http://www.tudou.com/v/S-dpMBb3LQc','0','','1218422304','0','swf');
INSERT INTO `p8_mv_video` VALUES ('267','3dƬͷ','0','','3','Ƶ','0','432','0','1199937070','1199937070','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/282/217/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','3Dҵ','http://www.tudou.com/v/VN4iOgoiGvs','0','','1218518655','0','swf');
INSERT INTO `p8_mv_video` VALUES ('268','-Цԡ','0','','3','Ƶ','0','347','0','1199937072','1199937072','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/331/375/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','-Цԡ','http://www.tudou.com/v/tWoQIdgbhM0','0','','1218561726','0','swf');
INSERT INTO `p8_mv_video` VALUES ('269','070109 Ϻӳ','0','','3','Ƶ','0','432','0','1199937073','1199937073','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/336/588/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','070109 Ϻӳ','http://www.tudou.com/v/k6DYlOMRBCY','0','','1218601737','0','swf');
INSERT INTO `p8_mv_video` VALUES ('270','桤Brad Pitt','0','','3','Ƶ','0','394','0','1199937075','1199937075','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/315/305/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','̨^ ^','http://www.tudou.com/v/PxrSXQFnndM','0','','1218271440','0','swf');
INSERT INTO `p8_mv_video` VALUES ('271','E:ŮԽΣ.DAT','0','','3','Ƶ','0','445','0','1199937076','1199937076','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/277/751/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','E:ŮԽΣ.DAT','http://www.tudou.com/v/TM8Tp0XRqMI','0','','1218598090','0','swf');
INSERT INTO `p8_mv_video` VALUES ('272','XBOX','0','','3','Ƶ','0','175','0','1199937078','1199937078','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/281/564/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','XBOX','http://www.tudou.com/v/omdKfUqLPLY','0','','1218135006','0','swf');
INSERT INTO `p8_mv_video` VALUES ('273','ԡ¶','0','','3','Ƶ','0','494','0','1199937080','1199937080','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/320/215/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ԡ¶','http://www.tudou.com/v/mmL0yi3xbkM','0','','1218526038','0','swf');
INSERT INTO `p8_mv_video` VALUES ('274','һز','0','','3','Ƶ','0','336','0','1199937081','1199937081','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/327/373/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ͺͷ','http://www.tudou.com/v/uRw34YL_woI','0','','1218464659','0','swf');
INSERT INTO `p8_mv_video` VALUES ('275','¿','0','','3','Ƶ','0','399','0','1199937083','1199937083','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/282/918/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','¿&lt;br /&gt;','http://www.tudou.com/v/OZ8EQJiYIWU','0','','1218454805','0','swf');
INSERT INTO `p8_mv_video` VALUES ('276','ȫ','0','','3','Ƶ','0','554','0','1199937084','1199937084','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/315/026/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ȫ','http://www.tudou.com/v/yNgQ5Y4uApA','0','','1218488692','0','swf');
INSERT INTO `p8_mv_video` VALUES ('277','ǵƷƵЬ','0','','3','Ƶ','0','997','0','1199937086','1199937086','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/273/060/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǵƷƵЬ','http://www.tudou.com/v/cVIjXOtchTc','0','','1218282797','0','swf');
INSERT INTO `p8_mv_video` VALUES ('278','̨漯','0','','3','Ƶ','0','434','0','1199937087','1199937087','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/278/788/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','120в  &lt;br /&gt;&lt;br /&gt; С&lt;br /&gt; ĸǷ ˮĳI','http://www.tudou.com/v/lqJK-u-xXsY','0','','1218596180','0','swf');
INSERT INTO `p8_mv_video` VALUES ('279','ТGIORDANO','0','','3','Ƶ','0','396','0','1199937090','1199937090','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/312/055/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Т  Ŷ GIORDANO㻨','http://www.tudou.com/v/2AGpYQNRatQ','0','','1218596162','0','swf');
INSERT INTO `p8_mv_video` VALUES ('280','Ǻţ̺','0','','3','Ƶ','0','452','0','1199937091','1199937091','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/344/460/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ţ̺ô','http://www.tudou.com/v/c38jTM7KDgk','0','','1218339662','0','swf');
INSERT INTO `p8_mv_video` VALUES ('281','˹ϲ','0','','3','Ƶ','0','851','0','1199937092','1199937092','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/297/421/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˹ϲ','http://www.tudou.com/v/AUNTLX6-sJc','0','','1218494929','0','swf');
INSERT INTO `p8_mv_video` VALUES ('282','ţ','0','','3','Ƶ','0','611','0','1199937094','1199937094','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/344/373/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ţ̺ô','http://www.tudou.com/v/RrxMW_YSmjM','0','','1218611085','0','swf');
INSERT INTO `p8_mv_video` VALUES ('283','cps','0','','3','Ƶ','0','260','0','1199937096','1199937096','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/329/426/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','cps','http://www.tudou.com/v/KcdDNfqIaaE','0','','1218543296','0','swf');
INSERT INTO `p8_mv_video` VALUES ('284','ТGiordano CF','0','','3','Ƶ','0','710','0','1199937097','1199937097','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/311/952/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Т Ŷ  GIORDANO','http://www.tudou.com/v/LUKX0teNVBc','0','','1218561563','0','swf');
INSERT INTO `p8_mv_video` VALUES ('285','Ļ񽱹','0','','3','Ƶ','0','357','0','1199937099','1199937099','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/271/002/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/hYczLk5F28c','0','','1218604059','0','swf');
INSERT INTO `p8_mv_video` VALUES ('286','֮׽췼汾','0','','3','Ƶ','0','659','0','1199937101','1199937101','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/650/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','׽췼ǹ','http://www.tudou.com/v/mMf1a5GXYpg','0','','1218431229','0','swf');
INSERT INTO `p8_mv_video` VALUES ('287','ډ*','0','','3','Ƶ','0','511','0','1199937104','1199937104','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/271/553/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','@ifąsһζΰlꖹɳ','http://www.tudou.com/v/Q5wTiNFRb6o','0','','1218596158','0','swf');
INSERT INTO `p8_mv_video` VALUES ('288','ТɳCFְ','0','','3','Ƶ','0','1139','0','1199937109','1199937109','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/312/114/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ТɳCFְ','http://www.tudou.com/v/TOJkQQPq7jU','0','','1218611515','0','swf');
INSERT INTO `p8_mv_video` VALUES ('289','ţ̰','0','','3','Ƶ','0','237','0','1199937116','1199937116','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/344/389/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ţ̺ô','http://www.tudou.com/v/lprktJaFX7M','0','','1218579428','0','swf');
INSERT INTO `p8_mv_video` VALUES ('290','cps','0','','3','Ƶ','0','294','0','1199937123','1199937123','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/295/771/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','cps','http://www.tudou.com/v/URYxKRPPHI4','0','','1218608327','0','swf');
INSERT INTO `p8_mv_video` VALUES ('291','Ұд','0','','3','Ƶ','0','410','0','1199937126','1199937126','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/307/626/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ұд','http://www.tudou.com/v/MF879a9Bcyw','0','','1218579438','0','swf');
INSERT INTO `p8_mv_video` VALUES ('292','˾ͱ','0','','3','Ƶ','0','774','0','1199937129','1199937129','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/279/216/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˾ͱ','http://www.tudou.com/v/nw2hVwyXrOE','0','','1218607808','0','swf');
INSERT INTO `p8_mv_video` VALUES ('293','Levi&#39;s','0','','3','Ƶ','0','417','0','1199937132','1199937132','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/281/932/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Levi&#39;s','http://www.tudou.com/v/G7Xf001dblI','0','','1218561676','0','swf');
INSERT INTO `p8_mv_video` VALUES ('294','','0','','3','Ƶ','0','441','2','1199937134','1199937134','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/281/038/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/hr20xdi20RA','0','','1218565139','0','swf');
INSERT INTO `p8_mv_video` VALUES ('295','ĸӢ---2%ˮϹ','0','','3','Ƶ','0','674','0','1199937136','1199937136','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/298/716/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','~~~&lt;br /&gt;ɰİ~~~ϲС~~~','http://www.tudou.com/v/60Cl5dtmP1w','0','','1218446929','0','swf');
INSERT INTO `p8_mv_video` VALUES ('296','˿','0','','3','Ƶ','0','1023','0','1199937137','1199937137','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/282/018/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˿','http://www.tudou.com/v/vGxVtdCrOx4','0','','1218600018','0','swf');
INSERT INTO `p8_mv_video` VALUES ('297','¿ֹ-ܽ۵ı.','0','','3','Ƶ','0','1484','0','1199937139','1199937139','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/091/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','........','http://www.tudou.com/v/83VDus_H8UU','0','','1218570017','0','swf');
INSERT INTO `p8_mv_video` VALUES ('298','̨','0','','3','Ƶ','0','514','0','1199937140','1199937140','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/327/478/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ʱ򲻿','http://www.tudou.com/v/-vogWLs476c','0','','1218553331','0','swf');
INSERT INTO `p8_mv_video` VALUES ('299','־Ƭ','0','','3','Ƶ','0','427','0','1199937142','1199937142','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/263/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','־Ƭ','http://www.tudou.com/v/4e4tgYzXKAw','0','','1218576726','0','swf');
INSERT INTO `p8_mv_video` VALUES ('300','־зι','0','','3','Ƶ','0','632','0','1199937143','1199937143','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/294/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','־зι','http://www.tudou.com/v/nsWSNE4ZFVo','0','','1218602593','0','swf');
INSERT INTO `p8_mv_video` VALUES ('301','һ','0','','3','Ƶ','0','864','0','1199937145','1199937145','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/294/400/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','һ֮ţͷ,ܺЦ~','http://www.tudou.com/v/rN7qxS9xSPs','0','','1218576746','0','swf');
INSERT INTO `p8_mv_video` VALUES ('302','sephora-ctvc-c12130722004','0','','3','Ƶ','0','664','0','1199937147','1199937147','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/283/436/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ctvc-c12130722004m','http://www.tudou.com/v/lrpCcxZj3FU','0','','1218563050','0','swf');
INSERT INTO `p8_mv_video` VALUES ('303','Aw݆20080111дN','0','','3','Ƶ','0','626','0','1199937148','1199937148','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/327/467/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ҲڴĹĿ...','http://www.tudou.com/v/W8ufrAjpXT4','0','','1218610213','0','swf');
INSERT INTO `p8_mv_video` VALUES ('304','°˵㵵[ϲ]ԤƬ2','0','','3','Ƶ','0','731','0','1199937150','1199937150','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/299/695/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','°˵㵵[ϲ]ԤƬ2','http://www.tudou.com/v/65qERlK4ZzE','0','','1218607207','0','swf');
INSERT INTO `p8_mv_video` VALUES ('305','ݡ̲棼superstar','0','','3','Ƶ','0','708','0','1199937152','1199937152','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/543/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ݡ̲桡&lt;Superstar&gt; &nbsp; ','http://www.tudou.com/v/thJtke1Avas','0','','1218597675','0','swf');
INSERT INTO `p8_mv_video` VALUES ('306','°˵㵵[ϲ]ԤƬ','0','','3','Ƶ','0','865','38','1199937156','1199937156','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/299/166/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','°˵㵵[ϲ]ԤƬ','http://www.tudou.com/v/lFGGJtDYDpI','0','','1218597921','0','swf');
INSERT INTO `p8_mv_video` VALUES ('307','־','0','','3','Ƶ','0','1319','0','1199937158','1199937158','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/495/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','־','http://www.tudou.com/v/aqsSkixrrL8','0','','1218603708','0','swf');
INSERT INTO `p8_mv_video` VALUES ('308','̫ƽι棨Աܣ','0','','3','Ƶ','0','1651','0','1199937159','1199937159','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/299/102/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','̫ƽԱˣ','http://www.tudou.com/v/LaVPJB23Bw8','0','','1218607153','0','swf');
INSERT INTO `p8_mv_video` VALUES ('309','־Ʈϴˮ湫ƪ','0','','3','Ƶ','0','1273','0','1199937161','1199937161','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/324/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','־Ʈϴˮ湫ƪ','http://www.tudou.com/v/AHMEaVXGqeM','0','','1218611118','0','swf');
INSERT INTO `p8_mv_video` VALUES ('310','Ļ񽱹','0','','3','Ƶ','0','2030','1','1199937162','1199937162','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/270/919/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/NKoTiBLtptk','0','','1218610992','0','swf');
INSERT INTO `p8_mv_video` VALUES ('311','pw݆׌㿴ҊənÑ(2+ζ)','0','','3','Ƶ','0','1358','0','1199937164','1199937164','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/337/860/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','궬׌҂һĸC!!!','http://www.tudou.com/v/yJtXwPEFexE','0','','1218608582','0','swf');
INSERT INTO `p8_mv_video` VALUES ('312','[2008.01.08]ʫ ¹(ױƪ)','0','','3','Ƶ','0','1254','0','1199937166','1199937166','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/317/225/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','[2008.01.08]ʫ ¹','http://www.tudou.com/v/fFZZs-Mg37c','0','','1218608593','0','swf');
INSERT INTO `p8_mv_video` VALUES ('313','Ķ-V31','0','','3','Ƶ','0','921','0','1199937167','1199937167','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/292/024/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','һE-inkĵĶ---V3Ľ','http://www.tudou.com/v/zf1CwrJWEis','0','','1218610659','0','swf');
INSERT INTO `p8_mv_video` VALUES ('314','','0','','3','Ƶ','0','1099','0','1199937169','1199937169','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/330/344/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ֹͣҽʳ','http://www.tudou.com/v/0ehBMJVhfPY','0','','1218608706','0','swf');
INSERT INTO `p8_mv_video` VALUES ('315','䛡2-ϵڐ(z͡׷&?)','0','','3','Ƶ','0','4348','0','1199937171','1199937171','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/277/093/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','DdՈ]&quot;С@Ψ|x-|ǃȵԮ&quot; &lt;br /&gt;ԭҕ˾Уٽ֮ãՈãxx!','http://www.tudou.com/v/cFnglKyNvOk','0','','1218611851','0','swf');
INSERT INTO `p8_mv_video` VALUES ('316','ڿͽ̳','0','','4','ƼƵ','0','263','0','1199937488','1199937488','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/324/164/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ڿͽ̳','http://www.tudou.com/v/35c-xKZatyQ','0','','1218601471','0','swf');
INSERT INTO `p8_mv_video` VALUES ('317','̽-ԭ֡ĹơB','0','','4','ƼƵ','0','289','0','1199937492','1199937492','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/324/861/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','̽','http://www.tudou.com/v/HRbdhL5zqEw','0','','1218499079','0','swf');
INSERT INTO `p8_mv_video` VALUES ('318','National.Geographic.100.Years.Vol39-b','0','','4','ƼƵ','0','234','0','1199937495','1199937495','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/645/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ҵ','http://www.tudou.com/v/C9KEkXgJN10','0','','1218606804','0','swf');
INSERT INTO `p8_mv_video` VALUES ('319','սձм53b','0','','4','ƼƵ','0','315','0','1199937497','1199937497','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/446/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/X2EL2V72njs','0','','1218527382','0','swf');
INSERT INTO `p8_mv_video` VALUES ('320','սձм29a','0','','4','ƼƵ','0','347','0','1199937502','1199937502','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/287/399/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/m4Uqxxzfa5k','0','','1218508545','0','swf');
INSERT INTO `p8_mv_video` VALUES ('321','սձм60a','0','','4','ƼƵ','0','509','0','1199937505','1199937505','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/306/987/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/mRpOtVbJE10','0','','1218603750','0','swf');
INSERT INTO `p8_mv_video` VALUES ('322','ֵӼ29a','0','','4','ƼƵ','0','525','0','1199937511','1199937511','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/340/353/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','[ͬôѧ]ֵӼ','http://www.tudou.com/v/fPhE-Ii27xs','0','','1218475627','0','swf');
INSERT INTO `p8_mv_video` VALUES ('323','δ˵Ҿ()ǰa','0','','4','ƼƵ','0','327','0','1199937514','1199937514','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/302/301/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ټҽ̳δ˵ղصһδ˵ҾղأʮѲΪ&lt;br /&gt;1 ʢղ&lt;br /&gt;2 ǰ&lt;br /&gt;3 һ&lt;br /&gt;4 Σ&lt;br /&gt;5 İ&lt;br /&gt;6 ','http://www.tudou.com/v/ALq92lduMpM','0','','1218561437','0','swf');
INSERT INTO `p8_mv_video` VALUES ('324','Science of Evil','0','','4','ƼƵ','0','619','0','1199937517','1199937517','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/301/151/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Science of Evil','http://www.tudou.com/v/1cOxDKL-gKU','0','','1218593155','0','swf');
INSERT INTO `p8_mv_video` VALUES ('325','ֵӼ29b','0','','4','ƼƵ','0','597','0','1199937523','1199937523','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/340/358/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','[ͬôѧ]ֵӼ','http://www.tudou.com/v/2NZramb4w8U','0','','1218543045','0','swf');
INSERT INTO `p8_mv_video` VALUES ('326','̽-ԭ֡ŵӰB','0','','4','ƼƵ','0','456','0','1199937526','1199937526','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/326/624/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','̽','http://www.tudou.com/v/BiS7tC6izWQ','0','','1218574174','0','swf');
INSERT INTO `p8_mv_video` VALUES ('327','Ȼ̽Ȼb','0','','4','ƼƵ','0','113','0','1199937529','1199937529','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/292/079/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ƭһ̽Ȼ˽⶯ĳйͷǷѧıԵһƵ棬Բͬʽڣǵֱţථʹóڵ̥ܺ߶ԡⶳӣпˮϼߵͰȻɹ꺵ɳĮࡣƬ˶ĴԼã˺ܶ೬Ȼ󣬱綯ԤЩ콵Ȼ&lt;br /&gt;&lt;br /&gt;  1-Ӧ֪(Extrasensory Perception) ĳЩܹ֪޷յõѶţƩܹӦĵųܹôصĲнһЩɱʹһЩصѶ໥϶Ŀй½ڽΪһһҿЩܡ&lt;br /&gt;&lt;br /&gt;  2-ⲿ(Outer Limits) ɳĮܱ֮ɴֲȻܷɵ׸ɻĸ߶ȣʿڵزƽЩ˼ɱ½Ϊһһ͡&lt;br /&gt;&lt;br /&gt;  3-Ǳص(Hidden Forces) źܹܶ˶ЩΪԼԤܹԤ&lt;br /&gt;&lt;br /&gt; &nbsp;  4-Ťʱ(Time Warp) ʱ佫ڶﲻͬĸӦչѵȫһ磬ڹȷʵһٶ磬˾ȸӦ˫۵㣬ȴһͬ硣&lt;br /&gt;&lt;br /&gt; &nbsp;  5-Ȼ(Paranormal) ЩųȻˮƮһˮߣԽӦ׳ȼеĶߣ⾿ôһأ&lt;br /&gt;&lt;br /&gt; &nbsp;  6-Ӵ(Close Encounters) ӴǳصĽţƤѢ߿Եõصġ㡱ҽƤɵɻʱĴʹڷԲ100ӢķΧڼǿǵķظ','http://www.tudou.com/v/QAowxowZDnA','0','','1218215709','0','swf');
INSERT INTO `p8_mv_video` VALUES ('328','սձм52b','0','','4','ƼƵ','0','794','0','1199937537','1199937537','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/157/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/LxN2oI8YosU','0','','1218601845','0','swf');
INSERT INTO `p8_mv_video` VALUES ('329','ټҽ̳꣩-01.ѡ빬A','0','','4','ƼƵ','0','378','0','1199937542','1199937542','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/288/428/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ټҽ̳꣩-01.ѡ빬A','http://www.tudou.com/v/b3Dm26vNQEk','0','','1218497035','0','swf');
INSERT INTO `p8_mv_video` VALUES ('330','Advanced20080111/12 topic talk','0','','4','ƼƵ','0','212','0','1199937546','1199937546','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/326/589/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','e','http://www.tudou.com/v/KURVpSPkLK0','0','','1218174249','0','swf');
INSERT INTO `p8_mv_video` VALUES ('331','սձм47a','0','','4','ƼƵ','0','656','0','1199937550','1199937550','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/302/616/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/mSFNnEAhnO4','0','','1218548126','0','swf');
INSERT INTO `p8_mv_video` VALUES ('332','ĩҵ','0','','4','ƼƵ','0','450','0','1199937554','1199937554','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/283/621/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ȴѧ2007Уֱֳ','http://www.tudou.com/v/bIg6YfcCTLY','0','','1218576988','0','swf');
INSERT INTO `p8_mv_video` VALUES ('333','ֵӼ28a','0','','4','ƼƵ','0','248','0','1199937556','1199937556','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/340/262/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','[ͬôѧ]ֵӼ','http://www.tudou.com/v/O8BlPlfl4hc','0','','1218239932','0','swf');
INSERT INTO `p8_mv_video` VALUES ('334','սձм47b','0','','4','ƼƵ','0','686','0','1199937559','1199937559','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/302/601/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/tEz3Br9iLBY','0','','1218446517','0','swf');
INSERT INTO `p8_mv_video` VALUES ('335','սձм51b','0','','4','ƼƵ','0','367','0','1199937564','1199937564','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/191/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/bdDal-uRnRE','0','','1218524095','0','swf');
INSERT INTO `p8_mv_video` VALUES ('336','δ˵Ҿ()İb','0','','4','ƼƵ','0','210','0','1199937567','1199937567','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/304/441/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ټҽ̳δ˵ղصһδ˵ҾղأʮѲΪ&lt;br /&gt;1 ʢղ&lt;br /&gt;2 ǰ&lt;br /&gt;3 һ&lt;br /&gt;4 Σ&lt;br /&gt;5 İ&lt;br /&gt;6 ','http://www.tudou.com/v/t1LF8nmy4Hg','0','','1218481565','0','swf');
INSERT INTO `p8_mv_video` VALUES ('337','սձм25b','0','','4','ƼƵ','0','306','0','1199937569','1199937569','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/426/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/mRnzBX-7v8k','0','','1218446520','0','swf');
INSERT INTO `p8_mv_video` VALUES ('338','Bottlenose Hunt on Sandy Shore','0','','4','ƼƵ','0','1263','0','1199937573','1199937573','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/301/346/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Bottlenose Hunt on Sandy Shore','http://www.tudou.com/v/Q0xEIMwrq9M','0','','1218603822','0','swf');
INSERT INTO `p8_mv_video` VALUES ('339','ԶҪԼ˵ܡ ʿҲ','0','','4','ƼƵ','0','248','0','1199937575','1199937575','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/279/292/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ʦԼ˹̱֫˽֫Ȼȴȡһϵ˾̾ĳɾͣðĴǲмھΪĴǰԱһֱֲζá֡·ȡ˼ա','http://www.tudou.com/v/aHa6Ad710nM','0','','1218430555','0','swf');
INSERT INTO `p8_mv_video` VALUES ('340','crazybaby(5)񱦱ٶӢĿ','0','','4','ƼƵ','0','282','0','1199937578','1199937578','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/279/893/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Crazy BabyȫͯƳһ ӱȤζӢѧĿɽӥͨƵӢʱÿ520֮֡һһˣһǳͬҲǷǳСCrazy Baby&lt;br /&gt;дŵӻǰСһӢ&lt;br /&gt;&lt;a target=&quot;_blank&quot; href=&quot;http://www.crazybaby.tv/index.asp&quot;&gt;http://www.crazybaby.tv/index.asp&lt;/a&gt;','http://www.tudou.com/v/IjfkO10FGkg','0','','1218491843','0','swf');
INSERT INTO `p8_mv_video` VALUES ('341','ڿͽ̳','0','','4','ƼƵ','0','272','0','1199937583','1199937583','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/324/349/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ڿͽ̳','http://www.tudou.com/v/oa-XmtQmrF0','0','','1218575978','0','swf');
INSERT INTO `p8_mv_video` VALUES ('342','սձм46b','0','','4','ƼƵ','0','228','0','1199937587','1199937587','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/301/788/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/QwaR8PdZS2I','0','','1218603457','0','swf');
INSERT INTO `p8_mv_video` VALUES ('343','Audi Voyage of Discovery','0','','4','ƼƵ','0','713','0','1199937590','1199937590','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/328/464/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ʣֵڴ','http://www.tudou.com/v/cOA-jKzkhgA','0','','1218458184','0','swf');
INSERT INTO `p8_mv_video` VALUES ('344','e2008010601','0','','4','ƼƵ','0','187','0','1199937592','1199937592','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/293/202/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','english news','http://www.tudou.com/v/U59_CM6zuKU','0','','1218610070','0','swf');
INSERT INTO `p8_mv_video` VALUES ('345','CNN sn 080108','0','','4','ƼƵ','0','222','0','1199937594','1199937594','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/281/008/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ӣѧϰ','http://www.tudou.com/v/Lfx_IWdTNG8','0','','1218503580','0','swf');
INSERT INTO `p8_mv_video` VALUES ('346','unixϵͳ20(2)','0','','4','ƼƵ','0','414','38','1199937596','1199937596','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/288/872/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','unixϵͳ','http://www.tudou.com/v/4Xd6UuWt2eQ','0','','1218597919','0','swf');
INSERT INTO `p8_mv_video` VALUES ('347','Ȼ̽Ȼe','0','','4','ƼƵ','0','92','0','1199937600','1199937600','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/294/563/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ƭһ̽Ȼ˽⶯ĳйͷǷѧıԵһƵ棬Բͬʽڣǵֱţථʹóڵ̥ܺ߶ԡⶳӣпˮϼߵͰȻɹ꺵ɳĮࡣƬ˶ĴԼã˺ܶ೬Ȼ󣬱綯ԤЩ콵Ȼ&lt;br /&gt;&lt;br /&gt;  1-Ӧ֪(Extrasensory Perception) ĳЩܹ֪޷յõѶţƩܹӦĵųܹôصĲнһЩɱʹһЩصѶ໥϶Ŀй½ڽΪһһҿЩܡ&lt;br /&gt;&lt;br /&gt;  2-ⲿ(Outer Limits) ɳĮܱ֮ɴֲȻܷɵ׸ɻĸ߶ȣʿڵزƽЩ˼ɱ½Ϊһһ͡&lt;br /&gt;&lt;br /&gt;  3-Ǳص(Hidden Forces) źܹܶ˶ЩΪԼԤܹԤ&lt;br /&gt;&lt;br /&gt; &nbsp;  4-Ťʱ(Time Warp) ʱ佫ڶﲻͬĸӦչѵȫһ磬ڹȷʵһٶ磬˾ȸӦ˫۵㣬ȴһͬ硣&lt;br /&gt;&lt;br /&gt; &nbsp;  5-Ȼ(Paranormal) ЩųȻˮƮһˮߣԽӦ׳ȼеĶߣ⾿ôһأ&lt;br /&gt;&lt;br /&gt; &nbsp;  6-Ӵ(Close Encounters) ӴǳصĽţƤѢ߿Եõصġ㡱ҽƤɵɻʱĴʹڷԲ100ӢķΧڼǿǵķظ','http://www.tudou.com/v/Fzpe8p-dWBU','0','','1218445016','0','swf');
INSERT INTO `p8_mv_video` VALUES ('348','05Խ̡mjm','0','','4','ƼƵ','0','330','0','1199937603','1199937603','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/269/320/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','05ֽרҵԽƵཻ','http://www.tudou.com/v/48VISsz9U98','0','','1218488098','0','swf');
INSERT INTO `p8_mv_video` VALUES ('349','crazybaby(6)񱦱ٶӢĿ','0','','4','ƼƵ','0','206','0','1199937607','1199937607','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/330/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Crazy BabyȫͯƳһ ӱȤζӢѧĿɽӥͨƵӢʱÿ520֮֡һһˣһǳͬҲǷǳСCrazy Baby&lt;br /&gt;дŵӻǰСһӢ&lt;br /&gt;&lt;a target=&quot;_blank&quot; href=&quot;http://www.crazybaby.tv/index.asp&quot;&gt;http://www.crazybaby.tv/index.asp&lt;/a&gt;','http://www.tudou.com/v/W4ECKEX3ZvI','0','','1218446523','0','swf');
INSERT INTO `p8_mv_video` VALUES ('350','[лѧ]һʵĦһ','0','','4','ƼƵ','0','410','0','1199937610','1199937610','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/640/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','[лѧ]һʵĦһ','http://www.tudou.com/v/-4LKNBKKi7w','0','','1218551903','0','swf');
INSERT INTO `p8_mv_video` VALUES ('351','National.Geographic.100.Years.Vol43-˹սb','0','','4','ƼƵ','0','243','0','1199937612','1199937612','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/298/700/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ҵ','http://www.tudou.com/v/RgCW4sccbLs','0','','1218510676','0','swf');
INSERT INTO `p8_mv_video` VALUES ('352','սձм41a','0','','4','ƼƵ','0','356','0','1199937615','1199937615','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/296/923/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/DyUvn8XMhL4','0','','1218576161','0','swf');
INSERT INTO `p8_mv_video` VALUES ('353','ϷУ泪','0','','4','ƼƵ','0','375','0','1199937618','1199937618','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/325/699/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','÷ɰϿ','http://www.tudou.com/v/A6INw8LL--o','0','','1218452707','0','swf');
INSERT INTO `p8_mv_video` VALUES ('354','־--Ī ','0','','4','ƼƵ','0','373','0','1199937620','1199937620','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/937/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ʷƵBiography','http://www.tudou.com/v/olhuKI8uGGc','0','','1218502701','0','swf');
INSERT INTO `p8_mv_video` VALUES ('355','δ˵Ҿ()İa','0','','4','ƼƵ','0','139','0','1199937623','1199937623','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/303/532/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ټҽ̳δ˵ղصһδ˵ҾղأʮѲΪ&lt;br /&gt;1 ʢղ&lt;br /&gt;2 ǰ&lt;br /&gt;3 һ&lt;br /&gt;4 Σ&lt;br /&gt;5 İ&lt;br /&gt;6 ','http://www.tudou.com/v/oYBglk04NXQ','0','','1218584100','0','swf');
INSERT INTO `p8_mv_video` VALUES ('356','սձм45a','0','','4','ƼƵ','0','385','0','1199937626','1199937626','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/301/402/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/KT5oh_Z5Fzk','0','','1218586601','0','swf');
INSERT INTO `p8_mv_video` VALUES ('357','Ӣ080111[Internet Social Networking 2-1]','0','','4','ƼƵ','0','1167','0','1199937628','1199937628','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/328/732/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ӢƵ˿(englishtv.edu.topzj.com)','http://www.tudou.com/v/U2cBOBrQLsY','0','','1218590271','0','swf');
INSERT INTO `p8_mv_video` VALUES ('358','սձм51a','0','','4','ƼƵ','0','252','0','1199937631','1199937631','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/304/589/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/vk588azUH1M','0','','1218541068','0','swf');
INSERT INTO `p8_mv_video` VALUES ('359','[]˶ĺϳɷֽ','0','','4','ƼƵ','0','521','0','1199937633','1199937633','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/288/861/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0',' &nbsp; &nbsp;  &nbsp;˶&lt;br /&gt;һƽ˶&lt;br /&gt;1. ˶ĺϳɷֽ &nbsp; &nbsp;  &nbsp;14:15&lt;br /&gt;2. ƽ˶ &nbsp; &nbsp;  &nbsp; &nbsp; &nbsp;  &nbsp;22:36','http://www.tudou.com/v/8xVSxuWS0zY','0','','1218543384','0','swf');
INSERT INTO `p8_mv_video` VALUES ('360','Ϊ','0','','4','ƼƵ','0','331','0','1199937635','1199937635','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/300/580/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˵','http://www.tudou.com/v/9Y16XBaN2AI','0','','1218449773','0','swf');
INSERT INTO `p8_mv_video` VALUES ('361','սձм35a','0','','4','ƼƵ','0','276','0','1199937638','1199937638','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/674/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/LudF6soFu4Q','0','','1218604183','0','swf');
INSERT INTO `p8_mv_video` VALUES ('362','.ҰؼA_ɽ','0','','4','ƼƵ','0','325','0','1199937640','1199937640','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/272/539/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','.ҰؼA_ɽ','http://www.tudou.com/v/vuHLiqMtnEk','0','','1218604506','0','swf');
INSERT INTO `p8_mv_video` VALUES ('363','ccnp eigrp 01','0','','4','ƼƵ','0','532','0','1199937643','1199937643','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/128/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ccnp','http://www.tudou.com/v/gvKlU3CtxzQ','0','','1218535303','0','swf');
INSERT INTO `p8_mv_video` VALUES ('364','̽֡ѰϽŮ ϡA','0','','4','ƼƵ','0','344','0','1199937646','1199937646','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/326/654/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','̽','http://www.tudou.com/v/tHjTerLjTqk','0','','1218558507','0','swf');
INSERT INTO `p8_mv_video` VALUES ('365','սձм31b','0','','4','ƼƵ','0','485','0','1199937648','1199937648','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/288/684/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/Pm95Ki6fHV8','0','','1218184538','0','swf');
INSERT INTO `p8_mv_video` VALUES ('366','2007мʦû֪ʶ̰Ƶ1501','0','','4','ƼƵ','0','715','0','1199937651','1199937651','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/316/786/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','2007мʦû֪ʶ̰Ƶ1501','http://www.tudou.com/v/5a1ZGgtwSxg','0','','1218598280','0','swf');
INSERT INTO `p8_mv_video` VALUES ('367','20045°ټҽ̳֮Ѱҵa','0','','4','ƼƵ','0','281','53','1199937653','1199937653','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/343/166/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','20045µĲְټҽ̳','http://www.tudou.com/v/W_vt1YugE2I','0','','1218597918','0','swf');
INSERT INTO `p8_mv_video` VALUES ('368','ŷ弼-C','0','','4','ƼƵ','0','506','0','1199937656','1199937656','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/313/544/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/oWJq0DYpq5I','0','','1218576766','0','swf');
INSERT INTO `p8_mv_video` VALUES ('369','־--Ī ','0','','4','ƼƵ','0','435','0','1199937659','1199937659','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/893/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ʷƵBiography','http://www.tudou.com/v/H4wtI9Ra66c','0','','1218468033','0','swf');
INSERT INTO `p8_mv_video` VALUES ('370','Ƕ060818ô@¡','0','','4','ƼƵ','0','168','0','1199937661','1199937661','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/308/244/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','СPS.060922Ƶиϴ&lt;a target=&quot;_blank&quot; href=&quot;http://www.56.com/u61/v_MjY5MTk4NjY.html&quot;&gt;http://www.56.com/u61/v_MjY5MTk4NjY.html&lt;/a&gt;','http://www.tudou.com/v/DIHFvmHcNGY','0','','1218434959','0','swf');
INSERT INTO `p8_mv_video` VALUES ('371','20045°ټҽ̳֮Ѱҵb','0','','4','ƼƵ','0','481','23','1199937664','1199937664','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/343/202/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','20045µĲְټҽ̳','http://www.tudou.com/v/-7E-LtAjTEE','0','','1218591466','0','swf');
INSERT INTO `p8_mv_video` VALUES ('372','2007мʦû֪ʶ̰Ƶ1301','0','','4','ƼƵ','0','345','0','1199937666','1199937666','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/316/788/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','2007мʦû֪ʶ̰Ƶ1301','http://www.tudou.com/v/AbbfxO1xn4k','0','','1218556948','0','swf');
INSERT INTO `p8_mv_video` VALUES ('373','Ƹ(QQ:403424392)','0','','4','ƼƵ','0','228','0','1199937668','1199937668','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/313/587/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','eʱҵʲô׬ǮҵѡʺԼĿΪʲôҪʲôøá&lt;br /&gt;&lt;a target=&quot;_blank&quot; href=&quot;http://www.kingbainao.cn&quot;&gt;http://www.kingbainao.cn&lt;/a&gt;','http://www.tudou.com/v/Mxjz5LLJMK4','0','','1218539663','0','swf');
INSERT INTO `p8_mv_video` VALUES ('374','ѧϰڶר02','0','','4','ƼƵ','0','317','0','1199937671','1199937671','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/285/328/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ѧϰڶר02','http://www.tudou.com/v/N87mFGFTmIc','0','','1218459609','0','swf');
INSERT INTO `p8_mv_video` VALUES ('375','Ƕ060714ô@¡','0','','4','ƼƵ','0','381','0','1199937674','1199937674','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/307/214/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','СPS.060922Ƶиϴ&lt;a target=&quot;_blank&quot; href=&quot;http://www.56.com/u61/v_MjY5MTk4NjY.html&quot;&gt;http://www.56.com/u61/v_MjY5MTk4NjY.html&lt;/a&gt;','http://www.tudou.com/v/IaMTvgZhkYI','0','','1218587725','0','swf');
INSERT INTO `p8_mv_video` VALUES ('376','ټҽ̳꣩-01.ѡ빬B','0','','4','ƼƵ','0','994','0','1199937678','1199937678','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/288/574/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ټҽ̳꣩-01.ѡ빬B','http://www.tudou.com/v/YAiPi3_vySY','0','','1218607089','0','swf');
INSERT INTO `p8_mv_video` VALUES ('377','սձм54a','0','','4','ƼƵ','0','339','0','1199937681','1199937681','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/601/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/DquLgv14i4k','0','','1218607779','0','swf');
INSERT INTO `p8_mv_video` VALUES ('378','ǵѧ-06.C','0','','4','ƼƵ','0','180','0','1199937684','1199937684','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/277/814/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǵѧ-06.','http://www.tudou.com/v/UPwnx55KqAM','0','','1218605858','0','swf');
INSERT INTO `p8_mv_video` VALUES ('379','Ʊ䣺Ͷβƽڻ','0','','4','ƼƵ','0','425','0','1199937686','1199937686','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/295/182/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/MNgVsRdoMzo','0','','1218605763','0','swf');
INSERT INTO `p8_mv_video` VALUES ('380','','0','','4','ƼƵ','0','212','0','1199937689','1199937689','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/329/195/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/G3p2xkwyWEk','0','','1218221371','0','swf');
INSERT INTO `p8_mv_video` VALUES ('381','National.Geographic.100.Years.Vol92-Խb','0','','4','ƼƵ','0','363','0','1199937693','1199937693','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/276/370/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ҵ','http://www.tudou.com/v/xiTpZ9REDHI','0','','1218461226','0','swf');
INSERT INTO `p8_mv_video` VALUES ('382','ɫ','0','','4','ƼƵ','0','339','0','1199937695','1199937695','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/299/074/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˵','http://www.tudou.com/v/I7fndyWcu2I','0','','1218604273','0','swf');
INSERT INTO `p8_mv_video` VALUES ('383','003.ԴĹɼѡ˲ŵĵʹһ','0','','4','ƼƵ','0','233','0','1199937698','1199937698','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/138/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ԴĹɼѡ˲ŵĵʹ','http://www.tudou.com/v/I5Icb3741iA','0','','1218578052','0','swf');
INSERT INTO `p8_mv_video` VALUES ('384','սձм46a','0','','4','ƼƵ','0','233','0','1199937702','1199937702','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/301/517/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/-L5iJtBsX2Y','0','','1218604427','0','swf');
INSERT INTO `p8_mv_video` VALUES ('385','澳Ӣļѩ11','0','','4','ƼƵ','0','239','0','1199937704','1199937704','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/637/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ѩ11','http://www.tudou.com/v/iy-xv9oJ4Ic','0','','1218542304','0','swf');
INSERT INTO `p8_mv_video` VALUES ('386','ɫӢ԰022','0','','4','ƼƵ','0','275','0','1199937707','1199937707','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/289/022/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ɫӢ԰022','http://www.tudou.com/v/1dNSALBFhsc','0','','1218607950','0','swf');
INSERT INTO `p8_mv_video` VALUES ('387','δ˵Ҿ()ǰb','0','','4','ƼƵ','0','171','0','1199937709','1199937709','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/301/273/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ټҽ̳δ˵ղصһδ˵ҾղأʮѲΪ&lt;br /&gt;1 ʢղ&lt;br /&gt;2 ǰ&lt;br /&gt;3 һ&lt;br /&gt;4 Σ&lt;br /&gt;5 İ&lt;br /&gt;6 ','http://www.tudou.com/v/NK1et_Cw0rU','0','','1218484147','0','swf');
INSERT INTO `p8_mv_video` VALUES ('388','澳Ӣļѩ10','0','','4','ƼƵ','0','546','0','1199937712','1199937712','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/592/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ѩ10','http://www.tudou.com/v/SCAu5PsiwWA','0','','1218427705','0','swf');
INSERT INTO `p8_mv_video` VALUES ('389','ǵѧ-05.B','0','','4','ƼƵ','0','371','0','1199937714','1199937714','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/277/010/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǵѧ-05.','http://www.tudou.com/v/jnaLJ8CgQkA','0','','1218478199','0','swf');
INSERT INTO `p8_mv_video` VALUES ('390','Ȼ̽Ȼf','0','','4','ƼƵ','0','139','0','1199937718','1199937718','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/294/832/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ƭһ̽Ȼ˽⶯ĳйͷǷѧıԵһƵ棬Բͬʽڣǵֱţථʹóڵ̥ܺ߶ԡⶳӣпˮϼߵͰȻɹ꺵ɳĮࡣƬ˶ĴԼã˺ܶ೬Ȼ󣬱綯ԤЩ콵Ȼ&lt;br /&gt;&lt;br /&gt;  1-Ӧ֪(Extrasensory Perception) ĳЩܹ֪޷յõѶţƩܹӦĵųܹôصĲнһЩɱʹһЩصѶ໥϶Ŀй½ڽΪһһҿЩܡ&lt;br /&gt;&lt;br /&gt;  2-ⲿ(Outer Limits) ɳĮܱ֮ɴֲȻܷɵ׸ɻĸ߶ȣʿڵزƽЩ˼ɱ½Ϊһһ͡&lt;br /&gt;&lt;br /&gt;  3-Ǳص(Hidden Forces) źܹܶ˶ЩΪԼԤܹԤ&lt;br /&gt;&lt;br /&gt; &nbsp;  4-Ťʱ(Time Warp) ʱ佫ڶﲻͬĸӦչѵȫһ磬ڹȷʵһٶ磬˾ȸӦ˫۵㣬ȴһͬ硣&lt;br /&gt;&lt;br /&gt; &nbsp;  5-Ȼ(Paranormal) ЩųȻˮƮһˮߣԽӦ׳ȼеĶߣ⾿ôһأ&lt;br /&gt;&lt;br /&gt; &nbsp;  6-Ӵ(Close Encounters) ӴǳصĽţƤѢ߿Եõصġ㡱ҽƤɵɻʱĴʹڷԲ100ӢķΧڼǿǵķظ','http://www.tudou.com/v/shkEQA4WGaw','0','','1218441622','0','swf');
INSERT INTO `p8_mv_video` VALUES ('391','Ȼ̽Ȼd','0','','4','ƼƵ','0','182','0','1199937720','1199937720','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/294/622/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ƭһ̽Ȼ˽⶯ĳйͷǷѧıԵһƵ棬Բͬʽڣǵֱţථʹóڵ̥ܺ߶ԡⶳӣпˮϼߵͰȻɹ꺵ɳĮࡣƬ˶ĴԼã˺ܶ೬Ȼ󣬱綯ԤЩ콵Ȼ&lt;br /&gt;&lt;br /&gt;  1-Ӧ֪(Extrasensory Perception) ĳЩܹ֪޷յõѶţƩܹӦĵųܹôصĲнһЩɱʹһЩصѶ໥϶Ŀй½ڽΪһһҿЩܡ&lt;br /&gt;&lt;br /&gt;  2-ⲿ(Outer Limits) ɳĮܱ֮ɴֲȻܷɵ׸ɻĸ߶ȣʿڵزƽЩ˼ɱ½Ϊһһ͡&lt;br /&gt;&lt;br /&gt;  3-Ǳص(Hidden Forces) źܹܶ˶ЩΪԼԤܹԤ&lt;br /&gt;&lt;br /&gt; &nbsp;  4-Ťʱ(Time Warp) ʱ佫ڶﲻͬĸӦչѵȫһ磬ڹȷʵһٶ磬˾ȸӦ˫۵㣬ȴһͬ硣&lt;br /&gt;&lt;br /&gt; &nbsp;  5-Ȼ(Paranormal) ЩųȻˮƮһˮߣԽӦ׳ȼеĶߣ⾿ôһأ&lt;br /&gt;&lt;br /&gt; &nbsp;  6-Ӵ(Close Encounters) ӴǳصĽţƤѢ߿Եõصġ㡱ҽƤɵɻʱĴʹڷԲ100ӢķΧڼǿǵķظ','http://www.tudou.com/v/OYpejuurM-U','0','','1218513455','0','swf');
INSERT INTO `p8_mv_video` VALUES ('392','սձм59b','0','','4','ƼƵ','0','524','0','1199937723','1199937723','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/306/920/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/s65FPUSF_pE','0','','1218603685','0','swf');
INSERT INTO `p8_mv_video` VALUES ('393','e2008010801','0','','4','ƼƵ','0','411','0','1199937727','1199937727','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/304/881/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','english news','http://www.tudou.com/v/Q5ZJaETB5Ak','0','','1218354040','0','swf');
INSERT INTO `p8_mv_video` VALUES ('394','˵Ӣ080108[How to order tea]','0','','4','ƼƵ','0','521','0','1199937729','1199937729','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/324/380/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ӢƵ˿(englishtv.edu.topzj.com)','http://www.tudou.com/v/YKK7HLrSSZA','0','','1218590546','0','swf');
INSERT INTO `p8_mv_video` VALUES ('395','ȫһ202','0','','4','ƼƵ','0','856','32','1199937732','1199937732','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/296/247/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ȫһ20','http://www.tudou.com/v/v3xo-q79JSE','0','','1218597924','0','swf');
INSERT INTO `p8_mv_video` VALUES ('396','δ˵Ҿ()ǰc','0','','4','ƼƵ','0','217','0','1199937734','1199937734','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/300/494/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ټҽ̳δ˵ղصһδ˵ҾղأʮѲΪ&lt;br /&gt;1 ʢղ&lt;br /&gt;2 ǰ&lt;br /&gt;3 һ&lt;br /&gt;4 Σ&lt;br /&gt;5 İ&lt;br /&gt;6 ','http://www.tudou.com/v/g2-KPITgGdU','0','','1218201637','0','swf');
INSERT INTO `p8_mv_video` VALUES ('397','澳Ӣļѩ12','0','','4','ƼƵ','0','257','0','1199937736','1199937736','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/654/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ѩ12','http://www.tudou.com/v/ouV_JCfVVlM','0','','1218205597','0','swf');
INSERT INTO `p8_mv_video` VALUES ('398','3 lovely wolf ','0','','4','ƼƵ','0','269','0','1199937738','1199937738','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/324/904/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','lovely wolf ','http://www.tudou.com/v/nPhV4D2YJic','0','','1218464600','0','swf');
INSERT INTO `p8_mv_video` VALUES ('399','Ƕ060721ô@ϡ','0','','4','ƼƵ','0','157','0','1199937740','1199937740','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/456/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','СPS.060922Ƶиϴ&lt;a target=&quot;_blank&quot; href=&quot;http://www.56.com/u61/v_MjY5MTk4NjY.html&quot;&gt;http://www.56.com/u61/v_MjY5MTk4NjY.html&lt;/a&gt;','http://www.tudou.com/v/reRYa657TKw','0','','1218447820','0','swf');
INSERT INTO `p8_mv_video` VALUES ('400','','0','','4','ƼƵ','0','484','0','1199937742','1199937742','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/343/939/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/K56WIM451zw','0','','1218466501','0','swf');
INSERT INTO `p8_mv_video` VALUES ('401','ټҽ̳꣩-02.ΪA','0','','4','ƼƵ','0','439','0','1199937744','1199937744','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/288/778/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ټҽ̳꣩-02.ΪA','http://www.tudou.com/v/pg2gMbKY070','0','','1218588017','0','swf');
INSERT INTO `p8_mv_video` VALUES ('402','սձм21a','0','','4','ƼƵ','0','306','0','1199937746','1199937746','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/270/508/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/7hv2MTjkimo','0','','1218602696','0','swf');
INSERT INTO `p8_mv_video` VALUES ('403','ټҽ̳꣩-02.ΪB','0','','4','ƼƵ','0','1218','0','1199937748','1199937748','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/289/760/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ټҽ̳꣩-02.ΪB','http://www.tudou.com/v/PNJvL5T8swU','0','','1218597974','0','swf');
INSERT INTO `p8_mv_video` VALUES ('404','սձм60b','0','','4','ƼƵ','0','378','0','1199937750','1199937750','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/307/026/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/0lj3yuljImg','0','','1218520414','0','swf');
INSERT INTO `p8_mv_video` VALUES ('405','Ƕ060721ô@¡','0','','4','ƼƵ','0','194','0','1199937755','1199937755','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/716/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','СPS.060922Ƶиϴ&lt;a target=&quot;_blank&quot; href=&quot;http://www.56.com/u61/v_MjY5MTk4NjY.html&quot;&gt;http://www.56.com/u61/v_MjY5MTk4NjY.html&lt;/a&gt;','http://www.tudou.com/v/I_X54IgVKoY','0','','1218603153','0','swf');
INSERT INTO `p8_mv_video` VALUES ('406','ǵѧ-06.A','0','','4','ƼƵ','0','292','0','1199937759','1199937759','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/277/260/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǵѧ-06.','http://www.tudou.com/v/0i8C7wqUqOE','0','','1218537699','0','swf');
INSERT INTO `p8_mv_video` VALUES ('407','˵Ӣ080107[Word Power][Different Types of Tea]','0','','4','ƼƵ','0','224','0','1199937761','1199937761','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/290/625/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ӢƵ˿(englishtv.edu.topzj.com)','http://www.tudou.com/v/2z1jxpQtqKc','0','','1218611421','0','swf');
INSERT INTO `p8_mv_video` VALUES ('408','սձм58b','0','','4','ƼƵ','0','327','0','1199937764','1199937764','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/306/909/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/N_FycBi8KUM','0','','1218340974','0','swf');
INSERT INTO `p8_mv_video` VALUES ('409','4 tiger ','0','','4','ƼƵ','0','676','31','1199937766','1199937766','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/279/072/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','tiger ','http://www.tudou.com/v/WKHf9pGrRwg','0','','1218600709','0','swf');
INSERT INTO `p8_mv_video` VALUES ('410','3 tiger ','0','','4','ƼƵ','0','498','0','1199937768','1199937768','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/278/801/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','tiger ','http://www.tudou.com/v/DFvHLAiK_tQ','0','','1218515933','0','swf');
INSERT INTO `p8_mv_video` VALUES ('411','ʱ±ۻ᡿20080107','0','','4','ƼƵ','0','339','0','1199937770','1199937770','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/270/379/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ʱ±ۻᡷ20080107ѡѡˮ⡱ʽ','http://www.tudou.com/v/JPLC28HThLw','0','','1218567016','0','swf');
INSERT INTO `p8_mv_video` VALUES ('412','ǵѧ-05.A','0','','4','ƼƵ','0','469','0','1199937773','1199937773','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/276/414/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǵѧ-05.','http://www.tudou.com/v/yABDlU-xpas','0','','1218577708','0','swf');
INSERT INTO `p8_mv_video` VALUES ('413','վů˼I1d','0','','4','ƼƵ','0','401','9','1199937776','1199937776','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/304/629/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','վů˼I1d','http://www.tudou.com/v/GGvJ4RjKnsE','0','','1218600711','0','swf');
INSERT INTO `p8_mv_video` VALUES ('414','սձм21b','0','','4','ƼƵ','0','247','0','1199937778','1199937778','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/270/821/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/WZ5-Nt8lXl0','0','','1218609425','0','swf');
INSERT INTO `p8_mv_video` VALUES ('415','[]','0','','4','ƼƵ','0','458','0','1199937781','1199937781','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/320/852/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Բ˶ &nbsp; &nbsp;  &nbsp;18:46&lt;br /&gt; &nbsp; &nbsp;  &nbsp;16:30&lt;br /&gt;ġ &nbsp; &nbsp;  &nbsp;20:36','http://www.tudou.com/v/58Jh0gyMDTU','0','','1218605888','0','swf');
INSERT INTO `p8_mv_video` VALUES ('416','ѭʯͷĹ켣£','0','','4','ƼƵ','0','407','0','1199937782','1199937782','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/272/836/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ѭʯͷĹ켣£','http://www.tudou.com/v/NIjeXdSCqPw','0','','1218487174','0','swf');
INSERT INTO `p8_mv_video` VALUES ('417','սձм23a','0','','4','ƼƵ','0','251','0','1199937787','1199937787','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/270/831/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/o7aMLi2Z5Bw','0','','1218564164','0','swf');
INSERT INTO `p8_mv_video` VALUES ('418','˵Ӣ080107[Welcome to Taiwan 5-1]TV','0','','4','ƼƵ','0','314','0','1199937789','1199937789','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/283/252/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ӢƵ˿(englishtv.edu.topzj.com)','http://www.tudou.com/v/O89rppf9Lkk','0','','1218604835','0','swf');
INSERT INTO `p8_mv_video` VALUES ('419','սձм45b','0','','4','ƼƵ','0','383','0','1199937791','1199937791','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/301/043/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/uFGRiIaRYIA','0','','1218265991','0','swf');
INSERT INTO `p8_mv_video` VALUES ('420','[]Բ˶','0','','4','ƼƵ','0','512','0','1199937793','1199937793','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/320/984/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Բ˶ &nbsp; &nbsp;  &nbsp;18:46&lt;br /&gt; &nbsp; &nbsp;  &nbsp;16:30&lt;br /&gt;ġ &nbsp; &nbsp;  &nbsp;20:36','http://www.tudou.com/v/4dw89C7GnfY','0','','1218548476','0','swf');
INSERT INTO `p8_mv_video` VALUES ('421','Ƕ060714ô@ϡ','0','','4','ƼƵ','0','257','0','1199937795','1199937795','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/226/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','СPS.060922Ƶиϴ&lt;a target=&quot;_blank&quot; href=&quot;http://www.56.com/u61/v_MjY5MTk4NjY.html&quot;&gt;http://www.56.com/u61/v_MjY5MTk4NjY.html&lt;/a&gt;','http://www.tudou.com/v/eHswY2wC2ZI','0','','1218265176','0','swf');
INSERT INTO `p8_mv_video` VALUES ('422','ҽѧ2a','0','','4','ƼƵ','0','568','0','1199937797','1199937797','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/344/400/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ҽѧ2a','http://www.tudou.com/v/6J9fwczb4Zc','0','','1218478863','0','swf');
INSERT INTO `p8_mv_video` VALUES ('423','Ȼ̽Ȼa','0','','4','ƼƵ','0','213','0','1199937800','1199937800','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/292/808/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','Ƭһ̽Ȼ˽⶯ĳйͷǷѧıԵһƵ棬Բͬʽڣǵֱţථʹóڵ̥ܺ߶ԡⶳӣпˮϼߵͰȻɹ꺵ɳĮࡣƬ˶ĴԼã˺ܶ೬Ȼ󣬱綯ԤЩ콵Ȼ&lt;br /&gt;&lt;br /&gt;  1-Ӧ֪(Extrasensory Perception) ĳЩܹ֪޷յõѶţƩܹӦĵųܹôصĲнһЩɱʹһЩصѶ໥϶Ŀй½ڽΪһһҿЩܡ&lt;br /&gt;&lt;br /&gt;  2-ⲿ(Outer Limits) ɳĮܱ֮ɴֲȻܷɵ׸ɻĸ߶ȣʿڵزƽЩ˼ɱ½Ϊһһ͡&lt;br /&gt;&lt;br /&gt;  3-Ǳص(Hidden Forces) źܹܶ˶ЩΪԼԤܹԤ&lt;br /&gt;&lt;br /&gt; &nbsp;  4-Ťʱ(Time Warp) ʱ佫ڶﲻͬĸӦչѵȫһ磬ڹȷʵһٶ磬˾ȸӦ˫۵㣬ȴһͬ硣&lt;br /&gt;&lt;br /&gt; &nbsp;  5-Ȼ(Paranormal) ЩųȻˮƮһˮߣԽӦ׳ȼеĶߣ⾿ôһأ&lt;br /&gt;&lt;br /&gt; &nbsp;  6-Ӵ(Close Encounters) ӴǳصĽţƤѢ߿Եõصġ㡱ҽƤɵɻʱĴʹڷԲ100ӢķΧڼǿǵķظ','http://www.tudou.com/v/EX_2Ab-S8Uk','0','','1218558045','0','swf');
INSERT INTO `p8_mv_video` VALUES ('424','20045°ټҽ̳֮ǧ-Ļƪa','0','','4','ƼƵ','0','424','9','1199937802','1199937802','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/344/348/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','20045µĲְټҽ̳','http://www.tudou.com/v/DiJZL33BZig','0','','1218604999','0','swf');
INSERT INTO `p8_mv_video` VALUES ('425','200817[ܾ]ߵϡ','0','','4','ƼƵ','0','330','0','1199937805','1199937805','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/834/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','200817[ܾ]ߵϡ','http://www.tudou.com/v/prC1ERh0v_k','0','','1218527625','0','swf');
INSERT INTO `p8_mv_video` VALUES ('426','200819[ܾ]¶Ժ¡','0','','4','ƼƵ','0','594','0','1199937807','1199937807','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/326/456/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','200819[ܾ]¶Ժ¡','http://www.tudou.com/v/0wop1L8Q17Y','0','','1218430616','0','swf');
INSERT INTO `p8_mv_video` VALUES ('427','ǵѧ-04.˰ഺ£C','0','','4','ƼƵ','0','362','0','1199937810','1199937810','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/276/173/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ǵѧ-04.˰ഺ£','http://www.tudou.com/v/ANFoNA0GFCo','0','','1218597607','0','swf');
INSERT INTO `p8_mv_video` VALUES ('428','20045°ټҽ̳֮ǧ-Ļƪb','0','','4','ƼƵ','0','404','0','1199937814','1199937814','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/344/372/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','20045µĲְټҽ̳','http://www.tudou.com/v/WbRcJLj-U5Y','0','','1218567266','0','swf');
INSERT INTO `p8_mv_video` VALUES ('429','˹֮ã£','0','','4','ƼƵ','0','497','0','1199937817','1199937817','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/311/161/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','˹֮ã£','http://www.tudou.com/v/BM0vOtlZ2VM','0','','1218498227','0','swf');
INSERT INTO `p8_mv_video` VALUES ('430','CCNACisco IOS2','0','','4','ƼƵ','0','391','0','1199937820','1199937820','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/344/352/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','CCNACisco IOS2','http://www.tudou.com/v/DT2NKDbG_eU','0','','1218460143','0','swf');
INSERT INTO `p8_mv_video` VALUES ('431','չ 2008 19£ һƾ ','0','','4','ƼƵ','0','256','0','1199937823','1199937823','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/331/146/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/ryqUmHca4oA','0','','1218459337','0','swf');
INSERT INTO `p8_mv_video` VALUES ('432','20;Ŀİ--첨ٺɯ̩','0','','4','ƼƵ','0','518','0','1199937825','1199937825','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/305/792/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','BBCƷ: 20;Ŀİ飨The Great Romances of the 20th Century&lt;br /&gt;֮졤ٺɯס̩ա&lt;br /&gt;Ǻľ䣬롣','http://www.tudou.com/v/bnuLkr5ul1k','0','','1218405636','0','swf');
INSERT INTO `p8_mv_video` VALUES ('433','ѭʯͷĹ켣ϣ','0','','4','ƼƵ','0','545','0','1199937828','1199937828','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/272/951/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ѭʯͷĹ켣ϣ','http://www.tudou.com/v/c5sPxpDyXYQ','0','','1218578718','0','swf');
INSERT INTO `p8_mv_video` VALUES ('434','20046°ټҽ̳֮ʮɰ04_˳Σ£a','0','','4','ƼƵ','0','324','0','1199937830','1199937830','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/344/448/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','20046µĲְټҽ̳','http://www.tudou.com/v/FheL0YuWuA8','0','','1218511107','0','swf');
INSERT INTO `p8_mv_video` VALUES ('435','չ 2008 17','0','','4','ƼƵ','0','419','51','1199937833','1199937833','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/280/728/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/Dck09mILPzM','0','','1218599731','0','swf');
INSERT INTO `p8_mv_video` VALUES ('436','սձм24a','0','','4','ƼƵ','0','393','0','1199937835','1199937835','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/271/121/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','սձм','http://www.tudou.com/v/6C6b1qUD1K8','0','','1218169919','0','swf');
INSERT INTO `p8_mv_video` VALUES ('437','ѧ4a','0','','4','ƼƵ','0','325','0','1199937839','1199937839','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/273/030/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','ɶҽҩѧĽѧ','http://www.tudou.com/v/aJww-lGpQjA','0','','1218605028','0','swf');
INSERT INTO `p8_mv_video` VALUES ('438','UFO Sighting (Part 3)','0','','4','ƼƵ','0','417','0','1199937842','1199937842','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/275/491/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','UFO Sighting','http://www.tudou.com/v/zXw8Ypom9-U','0','','1218577508','0','swf');
INSERT INTO `p8_mv_video` VALUES ('439','չ 2008 19ϣ һƾ ','0','','4','ƼƵ','0','968','0','1199937844','1199937844','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/331/359/p.jpg','1','1','','0','0','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','','http://www.tudou.com/v/ed1wT5mp6J4','0','','1218542040','0','swf');
INSERT INTO `p8_mv_video` VALUES ('440','20046°ټҽ̳֮ʮɰ04_˳Σ£b','0','','4','ƼƵ','0','381','0','1199937846','1199937846','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/344/477/p.jpg','1','1','','0','1','0','','','','','','','','0','1','127.0.0.1','0','0','','','','0','0','0','20046µĲְټҽ̳','http://www.tudou.com/v/uGPXNxTTlow','0','','1218540902','0','swf');
INSERT INTO `p8_mv_video` VALUES ('441','Ӣ080110[Be Social . . . Online]','0','','4','ƼƵ','0','374','0','1199937849','1199937849','1','111111','','','0','http://i01.img.tudou.com/data/imgs/i/013/291/491/p.jpg','1','1','','0','0