<?php
//Avoid useless notices
error_reporting(E_ERROR | E_WARNING | E_PARSE);

//Kernel Config
require 'dpconfig.php';

//Debug Output Switch
$DEBUG_MODE=0;

//For older PHP
if (PHP_VERSION<'4.1.0') {
	$_GET=&$HTTP_GET_VARS;
	$_POST=&$HTTP_POST_VARS;
	$_COOKIE=&$HTTP_COOKIE_VARS;
	$_SERVER=&$HTTP_SERVER_VARS;
	$_ENV=&$HTTP_ENV_VARS;
	$_FILES=&$HTTP_POST_FILES;
}

//Initiate kernel functions
if (!@include PATH_PRE.'dpmain/version.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to read version information.<br />File: ./dpmain/version.php');
if (!@include PATH_PRE.'dpmain/kernel/func.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate kernel functions.<br />File: ./dpmain/kernel/func.php');
if (!@include PATH_PRE.'dpmain/kernel/db.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate database functions.<br />File: ./dpmain/kernel/db.php');
if (!@include PATH_PRE.'dpmain/kernel/secure_getpost.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate security module.<br />File: ./dpmain/kernel/secure_getpost.php');
if (!@include PATH_PRE.'dpmain/kernel/pagecache.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate cache functions.<br />File: ./dpmain/kernel/pagecache.php');

//Fetch basic settings
if (!@include PATH_PRE.'dpdata/basicset.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to fetch basic settings.<br />File: ./dpdata/basicset.php');

//Cache Fetch
if ($_GET['jsmode']!='true') {
	$cachedir=PATH_PRE.'dpcache';
	$cacheid=$cachedir.'/'.md5($_SERVER['QUERY_STRING']).'.htm';
	if (cache_isvalid($cacheid,$d_basicset['cachevalidtime'])) {
		$totaloutput=cache_fetch($cacheid);
		if (trim($totaloutput)=='') dperror($l_error['cant_fetchdata'],$cacheid,true);
		if ($d_basicset['gzip']) @ob_start("ob_gzhandler");
		echo $totaloutput;
		exit();
	}
}

//==========================> Exit Here <==========================

//Process virtual static address
if (trim($_SERVER['QUERY_STRING'])!='') {
	$_SERVER['QUERY_STRING']=str_replace('.html','',$_SERVER['QUERY_STRING']);
	if (substr($_SERVER['QUERY_STRING'],0,9)=='pagetype-') {
		if (strstr($_SERVER['QUERY_STRING'],'-and-')) $_SERVER['QUERY_STRING']=str_replace('-and-','-a-',$_SERVER['QUERY_STRING']);
		$parts=explode('-a-',$_SERVER['QUERY_STRING']);
		foreach ($parts as $thispart) {
			$temp=explode('-',$thispart);
			$_GET[$temp[0]]=$temp[1];
		}
	}elseif (substr($_SERVER['QUERY_STRING'],0,3)=='dp-') {
		$_SERVER['QUERY_STRING']=str_replace('dp-','',$_SERVER['QUERY_STRING']);
		$parts=explode('-',$_SERVER['QUERY_STRING']);
		$_GET['pagetype']=$parts[0];
		@include PATH_PRE.'dpmain/pagetype/'.$_GET['pagetype'].'_url.php';
		for ($i=0;$i<count($urlvars);$i++) {
			$_GET[$urlvars[$i]]=$parts[$i+1];
		}
	}
}

//Initiate language characters : errors
if (!@include PATH_PRE.'dpmain/lang/'.$d_basicset['langpak'].'/error.php') exit('<b>DiY-Page Kernel Error:</b><br />Failed to initiate language characters of error messages.<br />File: ./dpmain/lang/'.$d_basicset['langpak'].'/error.php');

//Initiate language: charset
$incfile=PATH_PRE.'dpmain/lang/'.$d_basicset['langpak'].'/index.php';
if (!@include $incfile) dperror($l_error['adminlang'],$incfile,true);
$charset=$intro_lang['charset'];
if ($d_basicset['headercharset']) @header('Content-Type: text/html; charset='.$charset);

//Initiate language characters : fore
$incfile=PATH_PRE.'dpmain/lang/'.$d_basicset['langpak'].'/fore.php';
if (!@include $incfile) dperror($l_error['adminlang'],$incfile,true);

//Connect Database
if (db_connect(ur1decode($d_basicset['dbhost']),ur1decode($d_basicset['dbuser']),ur1decode($d_basicset['dbpassword']),$d_basicset['dbcharset'])==false) dperror($l_error['dbconnect'],db_errno().' '.db_error(),true);
if (db_selectdb(ur1decode($d_basicset['dbname']))==false) dperror($l_error['dbselect'],db_errno().' '.db_error(),true);

//Fetch data
$d_mainset=dpfetchdata('mainset');
if (trim($d_mainset)=='') dperror($l_error['cant_fetchdata'],'mainset',true);
$d_pagetype=dpfetchdata('pagetype');
if (trim($d_pagetype)=='') dperror($l_error['cant_fetchdata'],'pagetype',true);
$d_pageframe=dpfetchdata('pageframe');
if (trim($d_pageframe)=='') dperror($l_error['cant_fetchdata'],'pageframe',true);
$d_objects=dpfetchdata('objects');
if (trim($d_objects)=='') dperror($l_error['cant_fetchdata'],'objects',true);

//Set time zone
$timeoffset=intval($d_mainset['timezone']);
if (PHP_VERSION>'5.1') @date_default_timezone_set('Etc/GMT'.($timeoffset > 0 ? '-' : '+').(abs($timeoffset)));

//JS Mode
if ($_GET['jsmode']=='true') {
	define('JSMODE',true);
	$stime=microtime();
	$totaloutput=process_obj($_GET['objid']);
	$etime=microtime();
	echo $totaloutput.($_GET['debug'] ? '<br /><br />'.($etime-$stime).'<br /><br />'.($_SERVER['db_qnum']) : '');
	exit();
}

//CSS Mode
if ($_GET['cssmode']=='true') {
	@ob_start();
	@include PATH_PRE.'dpmain/style/'.$d_mainset['curstyle'].'/main.css.php';
	$totaloutput=@ob_get_contents();
	@ob_end_clean();
	echo $totaloutput;
	if (!cache_write($cacheid,$totaloutput)) dperror($l_error['cant_writedata'],$cacheid,true);
	@cache_clear_expired($cachedir,$d_basicset['cachevalidtime']);
	exit();
}

//==========================> Exit Here <==========================

//Process Page Type
$sessionarray=array();
$sessionarray['pagetypeid']=0;
foreach ($d_pagetype as $key => $val) {
	if ($_GET['pagetype']==$val['sysname']) {
		$sessionarray['pagetypeid']=$key;
		break;
	}
}

if (b64($d_mainset['sitename'])=='') $d_mainset['sitename']=b64($l_fore['default_sitename'],true);
if (b64($d_mainset['maintitle'])=='') $d_mainset['maintitle']=b64($l_fore['default_maintitle'],true);
if (b64($d_mainset['titleextra'])=='') $d_mainset['titleextra']=b64($l_fore['default_titleextra'],true);
if (b64($d_mainset['keywords'])=='') $d_mainset['keywords']=b64($l_fore['default_keywords'],true);
if (b64($d_mainset['description'])=='') $d_mainset['description']=b64($l_fore['default_description'],true);

$titlemain='';
@include PATH_PRE.'dpmain/pagetype/'.$_GET['pagetype'].'_title.php';
$pagetitle=$titlemain.b64($d_mainset['maintitle']).(trim(b64($d_mainset['titleextra']))!='' ? ' - '.b64($d_mainset['titleextra']) : '');
$sitename=b64($d_mainset['sitename']);
@include PATH_PRE.'dpmain/style/'.$d_mainset['curstyle'].'/index.php';
if ($intro_style['phpcss']) {
	$cssfile='dpindex.php?cssmode=true';
}else{
	$cssfile= file_exists(PATH_PRE.'dpmain/style/'.$d_mainset['curstyle'].'/main.css') ? 'dpmain/style/'.$d_mainset['curstyle'].'/main.css' : 'dpmain/style/default/main.css';
}

//Page Head
$pagehead='';
$pagehead.='<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">'."\r\n";
$pagehead.='<html xmlns="http://www.w3.org/1999/xhtml">'."\r\n";
$pagehead.='<head>'."\r\n";
$pagehead.='<title>'.$pagetitle.'</title>'."\r\n";
$pagehead.='<meta http-equiv="Content-Type" content="text/html; charset='.$charset.'" />'."\r\n";
$pagehead.='<meta name="Keywords" content="'.(trim($titlemain)!='' ? str_replace(' - ','' ,$titlemain) : b64($d_mainset['keywords'])).'" />'."\r\n";
$pagehead.='<meta name="Description" content="'.(trim($titlemain)!='' ? str_replace(' - ','. ',$pagetitle) : b64($d_mainset['description'])).'" />'."\r\n";
$pagehead.='<meta name="Generator" content="DiY-Page '.DP_VERSION.' RLC '.DP_RELEASE.'" />'."\r\n";
$pagehead.='<link rel="stylesheet" href="'.$cssfile.'" type="text/css" media="all" />'."\r\n";
$pagehead.='</head>'."\r\n";
$pagehead.='<body>'."\r\n";
$pagehead.='<script src="dpmain/common.js" type="text/javascript"></script>'."\r\n";
@ob_start();
@include PATH_PRE.'dpmain/style/'.$d_mainset['curstyle'].'/header.htm';
$pagehead.=@ob_get_contents();
@ob_end_clean();

//Page Body
$pagebody='';
if ($intro_style['tagged']) {
	$incfile=PATH_PRE.'dpmain/kernel/tpl.php';
	if (!@include $incfile) dperror($l_error['cant_include'],$incfile,true);

	@ob_start();
	if (!$_GET['pagetype']) $_GET['pagetype']='homepage';
	$incfile=dp_tpl(PATH_PRE.'dpmain/style/'.$d_mainset['curstyle'].'/'.$_GET['pagetype'].'.htm',$d_basicset['cachevalidtime']);
	if (!@include $incfile) dperror($l_error['cant_include'],$incfile,true);
	$pagebody.=@ob_get_contents();
	@ob_end_clean();
}else{
	for ($i=0;$i<count($d_pageframe);$i++) {
		if (is_array($d_pageframe[$i])) {
			$pagebody.=process_table($d_pageframe[$i],'['.$i.']');
		}else{
			$pagebody.=process_obj($d_pageframe[$i],'['.$i.']');
		}
	}
}

//Page Foot
$pagefoot='';
@ob_start();
@include PATH_PRE.'dpmain/style/'.$d_mainset['curstyle'].'/footer.htm';
$pagefoot.=@ob_get_contents();
@ob_end_clean();
$pagefoot.=dplicenser();
$pagefoot.="\r\n";
$pagefoot.='<img border="0" width="1" height="1" src="dpspider.php" />'."\r\n";
$pagefoot.='</body>'."\r\n";
$pagefoot.='</html>';

//Generate Page
$totaloutput=$pagehead.$pagebody.$pagefoot;
if (!$DEBUG_MODE) {
	$totaloutput=str_replace("\t",'',$totaloutput);
	$totaloutput=str_replace("\r",'',$totaloutput);
}

//Cache Write & Output
if (!cache_write($cacheid,$totaloutput)) dperror($l_error['cant_writedata'],$cacheid,true);
@cache_clear_expired($cachedir,$d_basicset['cachevalidtime']);
if ($d_basicset['gzip']) @ob_start("ob_gzhandler");
echo $totaloutput;

//==========================> Main End <==========================

function process_table($tablearray,$indexstr) {
	global $sessionarray,$l_error;
	if (!@in_array($sessionarray['pagetypeid'],$tablearray['pagetype']) and !$tablearray['allpagetype']) return '';

	$output='';

	$tablearray['tableid']=htmlspecialchars(stripslashes(b64($tablearray['tableid'])));
	if ($tablearray['tablemode']=='div' or $tablearray['tablemode']=='') {
		$output.='<div id="'.$tablearray['tableid'].'" style="margin:0;padding:0;'.($tablearray['width'] ? 'width:'.$tablearray['width'].';' : 'width:auto;').($tablearray['height'] ? 'height:'.$tablearray['height'].';' : 'height:auto;').($tablearray['align'] ? 'text-align:'.$tablearray['align'].';' : '').($tablearray['valign'] ? 'vertical-valign:'.$tablearray['valign'].';' : '').($tablearray['bgcolor'] ? 'background-color:'.$tablearray['bgcolor'].';' : '').($tablearray['background'] ? 'background:url(\''.$tablearray['background'].'\');' : '').($tablearray['style'] ? $tablearray['style'] : '').'"'.($tablearray['extraprop'] ? ' '.$tablearray['extraprop'] : '').'>';
	}elseif ($tablearray['tablemode']=='table') {
		$output.='<table id="'.$tablearray['tableid'].'"'.($tablearray['width'] ? ' width="'.$tablearray['width'].'"' : '').($tablearray['height'] ? ' height="'.$tablearray['height'].'"' : '').($tablearray['align'] ? ' align="'.$tablearray['align'].'"' : '').($tablearray['valign'] ? ' valign="'.$tablearray['valign'].'"' : '').($tablearray['bgcolor'] ? ' bgcolor="'.$tablearray['bgcolor'].'"' : '').($tablearray['background'] ? ' background="'.$tablearray['background'].'"' : '').($tablearray['style'] ? ' style="'.$tablearray['style'].'"' : '').($tablearray['extraprop'] ? ' '.$tablearray['extraprop'] : '').' border="0" cellspacing="0" cellpadding="0"><tr>';
	}

	for ($i=0;$i<count($tablearray['tds']);$i++) {

		if ($tablearray['tablemode']=='div' or $tablearray['tablemode']=='') {
			$output.='<div id="'.htmlspecialchars(stripslashes(b64($tablearray['tds'][$i]['tdid']))).'" style="float:left;margin:0;padding:0;'.($tablearray['tds'][$i]['width'] ? 'width:'.$tablearray['tds'][$i]['width'].';' : 'width:auto;').($tablearray['tds'][$i]['height'] ? 'height:'.$tablearray['tds'][$i]['height'].';' : 'height:auto;').($tablearray['tds'][$i]['align'] ? 'text-align:'.$tablearray['tds'][$i]['align'].';' : '').($tablearray['tds'][$i]['valign'] ? 'vertical-align:'.$tablearray['tds'][$i]['valign'].';' : '').($tablearray['tds'][$i]['bgcolor'] ? 'background-color:'.$tablearray['tds'][$i]['bgcolor'].';' : '').($tablearray['tds'][$i]['background'] ? 'background:url(\''.$tablearray['tds'][$i]['background'].'\');' : '').($tablearray['tds'][$i]['style'] ? $tablearray['tds'][$i]['style'] : '').'"'.($tablearray['tds'][$i]['extraprop'] ? ' '.$tablearray['tds'][$i]['extraprop'] : '').'>';
		}elseif ($tablearray['tablemode']=='table') {
			$output.='<td id="'.htmlspecialchars(stripslashes(b64($tablearray['tds'][$i]['tdid']))).'"'.($tablearray['tds'][$i]['width'] ? ' width="'.$tablearray['tds'][$i]['width'].'"' : ' width="150"').($tablearray['tds'][$i]['height'] ? ' height="'.$tablearray['tds'][$i]['height'].'"' : '').($tablearray['tds'][$i]['align'] ? ' align="'.$tablearray['tds'][$i]['align'].'"' : '').($tablearray['tds'][$i]['valign'] ? ' valign="'.$tablearray['tds'][$i]['valign'].'"' : '').($tablearray['tds'][$i]['bgcolor'] ? ' bgcolor="'.$tablearray['tds'][$i]['bgcolor'].'"' : '').($tablearray['tds'][$i]['background'] ? ' background="'.$tablearray['tds'][$i]['background'].'"' : '').($tablearray['tds'][$i]['style'] ? ' style="'.$tablearray['tds'][$i]['style'].'"' : '').($tablearray['tds'][$i]['extraprop'] ? ' '.$tablearray['tds'][$i]['extraprop'] : '').'>';
		}

		for ($j=0;$j<count($tablearray['tds'][$i]['items']);$j++) {
			$indexstrnow=$indexstr.'["tds"]['.$i.']["items"]['.$j.']';
			if (is_array($tablearray['tds'][$i]['items'][$j])) {
				//Process child table:
				$output.=process_table($tablearray['tds'][$i]['items'][$j],$indexstrnow);
			}else{
				//Process objects:
				$output.=process_obj(intval($tablearray['tds'][$i]['items'][$j]));
			}
		}

		if ($tablearray['tablemode']=='div' or $tablearray['tablemode']=='') {
			$output.='</div>';
		}elseif ($tablearray['tablemode']=='table') {
			$output.='</td>';
		}
	}

	if ($tablearray['tablemode']=='div' or $tablearray['tablemode']=='') {
		$output.='</div>';
	}elseif ($tablearray['tablemode']=='table') {
		$output.='</tr></table>';
	}

	return $output;
}

function process_obj($objid) {
	global $DEBUG_MODE,$sessionarray,$d_objects,$d_basicset,$d_mainset,$l_mod_fore,$l_error;
	$_SERVER['boxhtml']='';
	$_SERVER['objid']=$objid;
	$output='';
	$obj=$d_objects[$objid];
	if (@in_array($sessionarray['pagetypeid'],$obj['pagetype']) or $obj['allpagetype'] or defined('JSMODE')) {
		if (!@include_once PATH_PRE.'dpmain/module/'.$obj['module'].'/objfunc/'.$obj['type'].'.php') $objerr=true;
		$feedback='';
		if ($objerr) {
			$feedback=$l_error['objerr'];
		}else{
			$incfile=PATH_PRE.'dpmain/lang/'.$d_basicset['langpak'].'/'.$obj['module'].'_fore.php';
			if (!@include $incfile) dperror($l_error['adminlang'],$incfile,true);

			eval('$feedback='.$obj['module'].'_'.$obj['type'].'($obj["paras"]);');
		}
		if (defined('JSMODE')) {
			$output=$feedback;
		}else{
			if (trim(b64($obj['boxtitles']))=='') $obj['boxtitles']=b64($l_mod_fore['default_'.$obj['type']],true);
			$title=explode("\n",stripslashes(b64($obj['boxtitles'])));
			$boxbody=($DEBUG_MODE ? "\r\n".'<!--BEGIN FUNC '.$obj['module'].'_'.$obj['type'].'-->'."\r\n" : '').$feedback.($DEBUG_MODE ? "\r\n".'<!--END FUNC '.$obj['module'].'_'.$obj['type'].'-->'."\r\n" : '');
			@ob_start();
			if (!@include PATH_PRE.'dpmain/style/'.$d_mainset['curstyle'].'/box/'.$obj['box'].'.htm') {
				$incfile=PATH_PRE.'dpmain/style/default/box/'.$obj['box'].'.htm';
				if (!@include $incfile) dperror($l_error['cant_include'],$incfile,true);
			}
			$fullobj=@ob_get_contents();
			@ob_end_clean();
			$output.=($DEBUG_MODE ? "\r\n".'<!--BEGIN OBJ '.b64($obj['name']).'-->'."\r\n" : '').$fullobj.($DEBUG_MODE ? "\r\n".'<!--END OBJ '.b64($obj['name']).'-->'."\r\n" : '');
		}
	}
	return $output;
}

?>