<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Edwin404\Base\Support\ModelHelper;
use Edwin404\Shop\Jobs\OrderExpireCheckJob;
use Edwin404\Shop\Types\OrderStatus;
use EdwinFound\Utils\ArrayUtil;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;

class MaintainDumpDemo extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'MaintainDumpDemo';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'MaintainDumpDemo';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $dump = [];

        $dump['inserts'] = [];
        $dump['inserts']['config'] = array_filter(ModelHelper::find('config'), function ($item) {
            return !in_array($item['key'], [
                'systemCdnUrl',
                'uploadDriver',
                'uploadDriverDomain',
                'uploadDriverAliyunAccessKeyId',
                'uploadDriverAliyunAccessKeySecret',
                'uploadDriverAliyunEndpoint',
                'uploadDriverAliyunBucket',
            ]);
        });
        $dump['inserts']['product_category'] = ModelHelper::model('product_category')->orderBy('id', 'asc')->get()->toArray();
        $dump['inserts']['product'] = ModelHelper::find('product');
        $dump['inserts']['partner'] = ModelHelper::find('partner');
        $dump['inserts']['banner'] = ModelHelper::find('banner');
        $dump['inserts']['news'] = ModelHelper::find('news');
        $dump['inserts']['job'] = ModelHelper::find('job');
        $dump['inserts']['super_page'] = ModelHelper::find('super_page');
        $dump['inserts']['super_page_item'] = ModelHelper::find('super_page_item');

        $dump['updates'] = [];
        foreach (ModelHelper::find('background') as $item) {
            $dump['updates'][] = [
                'table' => 'background',
                'where' => ArrayUtil::filterSpecifiedKey($item, ['type']),
                'update' => ArrayUtil::filterSpecifiedKey($item, ['url']),
            ];
        }

        @mkdir(public_path('data_demo/'));
        file_put_contents(public_path('data_demo/data.php'), '<' . '?php return ' . var_export($dump, true) . ';');
    }
}
