<?php

namespace App\Http\Controllers\Admin;


use Edwin404\Admin\Cms\Field\FieldImage;
use Edwin404\Admin\Cms\Field\FieldRichtext;
use Edwin404\Admin\Cms\Field\FieldText;
use Edwin404\Admin\Cms\Field\FieldTextarea;
use Edwin404\Admin\Cms\Handle\BasicCms;
use Edwin404\Admin\Http\Controllers\Support\AdminCheckController;
use Edwin404\Base\Support\Response;
use Illuminate\Support\Facades\Request;

class BannerController extends AdminCheckController
{
    private $cmsConfigBasic = [
        'model' => 'banner',
        'pageTitle' => '轮播配置',
        'group' => 'data',
        'canAdd' => true,
        'canEdit' => true,
        'canDelete' => true,
        'fields' => [
            'image' => ['type' => FieldImage::class, 'title' => '图片', 'list' => true, 'edit' => true, 'add' => true,],
            'link' => ['type' => FieldText::class, 'title' => '链接', 'list' => true, 'edit' => true, 'add' => true, 'desc' => '链接为空将不会跳转'],
        ]
    ];

    public function dataList(BasicCms $basicCms)
    {
        return $basicCms->executeList($this, $this->cmsConfigBasic);;
    }

    public function dataDelete(BasicCms $basicCms)
    {
        if (Request::isMethod('post') && env('ADMIN_DEMO_USER_ID', 0) && $this->adminUserId() == env('ADMIN_DEMO_USER_ID', 0)) {
            return Response::send(-1, '演示账号禁止修改信息');
        }

        return $basicCms->executeDelete($this, $this->cmsConfigBasic);
    }

    public function dataEdit(BasicCms $basicCms)
    {
        if (Request::isMethod('post') && env('ADMIN_DEMO_USER_ID', 0) && $this->adminUserId() == env('ADMIN_DEMO_USER_ID', 0)) {
            return Response::send(-1, '演示账号禁止修改信息');
        }

        return $basicCms->executeEdit($this, $this->cmsConfigBasic);
    }

    public function dataAdd(BasicCms $basicCms)
    {
        if (Request::isMethod('post') && env('ADMIN_DEMO_USER_ID', 0) && $this->adminUserId() == env('ADMIN_DEMO_USER_ID', 0)) {
            return Response::send(-1, '演示账号禁止修改信息');
        }

        return $basicCms->executeAdd($this, $this->cmsConfigBasic);
    }


}