<?php

namespace App\Http\Controllers\Admin;


use Edwin404\Admin\Cms\Field\FieldImage;
use Edwin404\Admin\Cms\Field\FieldRichtext;
use Edwin404\Admin\Cms\Field\FieldSelect;
use Edwin404\Admin\Cms\Field\FieldText;
use Edwin404\Admin\Cms\Field\FieldTextarea;
use Edwin404\Admin\Cms\Handle\BasicCms;
use Edwin404\Admin\Http\Controllers\Support\AdminCheckController;
use Edwin404\Base\Support\Response;
use Illuminate\Support\Facades\Request;

class NavController extends AdminCheckController
{
    private $cmsConfigBasic = [
        'model' => 'nav',
        'pageTitle' => '导航设置',
        'group' => 'data',
        'canAdd' => true,
        'canEdit' => true,
        'canDelete' => true,
        'fields' => [
            'type' => ['type' => FieldSelect::class, 'title' => '类型', 'search' => true, 'list' => true, 'edit' => true, 'add' => true, 'options' => [
                'head' => '顶部导航',
                'foot' => '底部导航',
            ]],
            'sort' => ['type' => FieldText::class, 'title' => '位置', 'list' => true, 'edit' => true, 'add' => true,],
            'title' => ['type' => FieldText::class, 'title' => '标题', 'list' => true, 'edit' => true, 'add' => true,],
            'url' => ['type' => FieldText::class, 'title' => '链接', 'list' => true, 'edit' => true, 'add' => true, 'desc' => '
<table class="admin-view-table-line">
    <tr><td width="50">首页</td><td width="50"><code>/</code></td><td><a onclick="$(\'[name=url]\').val(\'/\')" href="javascript:;">[使用]</a></td></tr>
    <tr><td width="50">产品列表</td><td width="50"><code>/product</code></td><td><a onclick="$(\'[name=url]\').val(\'/product\')" href="javascript:;">[使用]</a></td></tr>
    <tr><td width="50">新闻列表</td><td width="50"><code>/news</code></td><td><a onclick="$(\'[name=url]\').val(\'/news\')" href="javascript:;">[使用]</a></td></tr>
    <tr><td width="50">联系我们</td><td width="50"><code>/contact</code></td><td><a onclick="$(\'[name=url]\').val(\'/contact\')" href="javascript:;">[使用]</a></td></tr>
    <tr><td width="50">关于我们</td><td width="50"><code>/about</code></td><td><a onclick="$(\'[name=url]\').val(\'/about\')" href="javascript:;">[使用]</a></td></tr>
    <tr><td width="50">招聘</td><td width="50"><code>/job</code></td><td><a onclick="$(\'[name=url]\').val(\'/job\')" href="javascript:;">[使用]</a></td></tr>
</table>
            '],
        ]
    ];

    public function dataList(BasicCms $basicCms)
    {
        return $basicCms->executeList($this, $this->cmsConfigBasic);;
    }

    public function dataDelete(BasicCms $basicCms)
    {
        return $basicCms->executeDelete($this, $this->cmsConfigBasic);
    }

    public function dataEdit(BasicCms $basicCms)
    {
        return $basicCms->executeEdit($this, $this->cmsConfigBasic);
    }

    public function dataAdd(BasicCms $basicCms)
    {
        return $basicCms->executeAdd($this, $this->cmsConfigBasic);
    }


}
