<?php

namespace App\Http\Controllers;

use Edwin404\Base\Support\ModelHelper;
use Edwin404\Common\Support\TemplateViewTrait;
use Edwin404\Config\Facades\ConfigFacade;
use Edwin404\Member\Support\MemberTrait;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\View;
use Jenssegers\Agent\Facades\Agent;

class BaseController extends Controller
{
    use MemberTrait;
    use TemplateViewTrait;

    public function __construct()
    {
        $this->memberUserSetup();
        $nav = ModelHelper::find('nav', ['type' => 'head'], ['sort', 'asc']);
        View::share('_navHead', $nav);
        $navFoot = ModelHelper::find('nav', ['type' => 'head'], ['sort', 'asc']);
        View::share('_navFoot', $navFoot);
    }

}
