<?php

namespace App\Http\Controllers;

use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Forum\Services\ForumService;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Str;

class IndexController extends BaseController
{
    public function index()
    {
        $superPage = ModelHelper::load('super_page', ['url' => '/']);
        $superPageItems = [];
        if ($superPage) {
            $superPageItems = ModelHelper::find('super_page_item', ['pageId' => $superPage['id']], ['sort', 'asc']);
            ModelHelper::decodeRecordsJson($superPageItems, 'content');
        }

        $viewData = [];
        $viewData['superPageItems'] = $superPageItems;
        return $this->_view('index', $viewData);
    }

}
