<?php

namespace App\Http\Controllers;

use Edwin404\Base\Support\ModelHelper;
use Edwin404\Base\Support\PageHelper;
use Edwin404\Base\Support\Response;
use Edwin404\Forum\Services\ForumService;
use Illuminate\Support\Facades\Input;

class JobController extends BaseController
{
    public function index()
    {
        $page = Input::get('page');
        $pageSize = 10;

        $option = [];
        $option['order'] = ['id', 'desc'];
        $productPaginate = ModelHelper::modelPaginate('job', $page, $pageSize, $option);

        $jobs = $productPaginate['records'];
        $pageHtml = PageHelper::render($productPaginate['total'], $pageSize, $page, '/job?page={page}');

        $viewData = [];
        $viewData['jobs'] = $jobs;
        $viewData['pageHtml'] = $pageHtml;
        $viewData['background'] = ModelHelper::load('background', ['type' => 'job_list']);
        return $this->_view('job', $viewData);
    }

    public function view($jobId)
    {
        $jobId = intval($jobId);
        $job = ModelHelper::load('job', ['id' => $jobId]);
        if (empty($job)) {
            return Response::send(-1, '未找到');
        }

        $viewData = [];
        $viewData['job'] = $job;
        $viewData['background'] = ModelHelper::load('background', ['type' => 'job_view']);
        return $this->_view('jobView', $viewData);
    }

}
