<?php

Route::group(
    [
        'prefix' => env('ADMIN_PATH', '/admin/'),
        'middleware' => [
            \Edwin404\Admin\Http\Middleware\AdminWebAuth::class,
        ]
    ], function () {

    // 公用
    include __DIR__ . '/../../vendor/edwin404/laravel-admin/src/Config/routes.php';
    Route::match(['get', 'post'], '', '\App\Http\Controllers\Admin\IndexController@index');
    // 公用
    Route::match(['get', 'post'], 'upgrade/{action}', '\Edwin404\Admin\Http\Controllers\UpgradeController@index');

    Route::match(['get', 'post'], 'widget/link_select_dialog', '\App\Http\Controllers\Admin\WidgetController@linkSelectDialog');

    Route::match(['get', 'post'], 'config/setting', '\App\Http\Controllers\Admin\ConfigController@setting');
    Route::match(['get', 'post'], 'config/contact_info', '\App\Http\Controllers\Admin\ConfigController@contactInfo');
    Route::match(['get', 'post'], 'config/about', '\App\Http\Controllers\Admin\ConfigController@about');
    Route::match(['get', 'post'], 'config/upload', '\App\Http\Controllers\Admin\ConfigController@upload');
    Route::match(['get', 'post'], 'config/contact', '\App\Http\Controllers\Admin\ConfigController@contact');
    Route::match(['get', 'post'], 'config/visit', '\App\Http\Controllers\Admin\ConfigController@visit');
    Route::match(['get', 'post'], 'config/template', '\App\Http\Controllers\Admin\ConfigController@template');
    Route::match(['get', 'post'], 'config/module', '\App\Http\Controllers\Admin\ConfigController@module');

    Route::match(['get', 'post'], 'news/list', '\App\Http\Controllers\Admin\NewsController@dataList');
    Route::match(['get', 'post'], 'news/view', '\App\Http\Controllers\Admin\NewsController@dataView');
    Route::match(['get', 'post'], 'news/edit', '\App\Http\Controllers\Admin\NewsController@dataEdit');
    Route::match(['get', 'post'], 'news/add', '\App\Http\Controllers\Admin\NewsController@dataAdd');
    Route::match(['get', 'post'], 'news/delete', '\App\Http\Controllers\Admin\NewsController@dataDelete');

    Route::match(['get', 'post'], 'job/list', '\App\Http\Controllers\Admin\JobController@dataList');
    Route::match(['get', 'post'], 'job/view', '\App\Http\Controllers\Admin\JobController@dataView');
    Route::match(['get', 'post'], 'job/edit', '\App\Http\Controllers\Admin\JobController@dataEdit');
    Route::match(['get', 'post'], 'job/add', '\App\Http\Controllers\Admin\JobController@dataAdd');
    Route::match(['get', 'post'], 'job/delete', '\App\Http\Controllers\Admin\JobController@dataDelete');

    Route::match(['get', 'post'], 'partner/list', '\App\Http\Controllers\Admin\PartnerController@dataList');
    Route::match(['get', 'post'], 'partner/view', '\App\Http\Controllers\Admin\PartnerController@dataView');
    Route::match(['get', 'post'], 'partner/edit', '\App\Http\Controllers\Admin\PartnerController@dataEdit');
    Route::match(['get', 'post'], 'partner/add', '\App\Http\Controllers\Admin\PartnerController@dataAdd');
    Route::match(['get', 'post'], 'partner/delete', '\App\Http\Controllers\Admin\PartnerController@dataDelete');

    Route::match(['get', 'post'], 'banner/list', '\App\Http\Controllers\Admin\BannerController@dataList');
    Route::match(['get', 'post'], 'banner/view', '\App\Http\Controllers\Admin\BannerController@dataView');
    Route::match(['get', 'post'], 'banner/edit', '\App\Http\Controllers\Admin\BannerController@dataEdit');
    Route::match(['get', 'post'], 'banner/add', '\App\Http\Controllers\Admin\BannerController@dataAdd');
    Route::match(['get', 'post'], 'banner/delete', '\App\Http\Controllers\Admin\BannerController@dataDelete');

    Route::match(['get', 'post'], 'product/category/list', '\App\Http\Controllers\Admin\ProductCategoryController@dataList');
    Route::match(['get', 'post'], 'product/category/view', '\App\Http\Controllers\Admin\ProductCategoryController@dataView');
    Route::match(['get', 'post'], 'product/category/edit', '\App\Http\Controllers\Admin\ProductCategoryController@dataEdit');
    Route::match(['get', 'post'], 'product/category/add', '\App\Http\Controllers\Admin\ProductCategoryController@dataAdd');
    Route::match(['get', 'post'], 'product/category/delete', '\App\Http\Controllers\Admin\ProductCategoryController@dataDelete');
    Route::match(['get', 'post'], 'product/category/sort', '\App\Http\Controllers\Admin\ProductCategoryController@dataSort');

    Route::match(['get', 'post'], 'product/list', '\App\Http\Controllers\Admin\ProductController@dataList');
    Route::match(['get', 'post'], 'product/view', '\App\Http\Controllers\Admin\ProductController@dataView');
    Route::match(['get', 'post'], 'product/edit', '\App\Http\Controllers\Admin\ProductController@dataEdit');
    Route::match(['get', 'post'], 'product/add', '\App\Http\Controllers\Admin\ProductController@dataAdd');
    Route::match(['get', 'post'], 'product/delete', '\App\Http\Controllers\Admin\ProductController@dataDelete');

    Route::match(['get', 'post'], 'nav/list', '\App\Http\Controllers\Admin\NavController@dataList');
    Route::match(['get', 'post'], 'nav/view', '\App\Http\Controllers\Admin\NavController@dataView');
    Route::match(['get', 'post'], 'nav/edit', '\App\Http\Controllers\Admin\NavController@dataEdit');
    Route::match(['get', 'post'], 'nav/add', '\App\Http\Controllers\Admin\NavController@dataAdd');
    Route::match(['get', 'post'], 'nav/delete', '\App\Http\Controllers\Admin\NavController@dataDelete');

    Route::match(['get', 'post'], 'book/list', '\App\Http\Controllers\Admin\BookController@dataList');
    Route::match(['get', 'post'], 'book/view', '\App\Http\Controllers\Admin\BookController@dataView');
    Route::match(['get', 'post'], 'book/edit', '\App\Http\Controllers\Admin\BookController@dataEdit');
    Route::match(['get', 'post'], 'book/add', '\App\Http\Controllers\Admin\BookController@dataAdd');
    Route::match(['get', 'post'], 'book/delete', '\App\Http\Controllers\Admin\BookController@dataDelete');

    Route::match(['get', 'post'], 'message/list', '\App\Http\Controllers\Admin\MessageController@dataList');
    Route::match(['get', 'post'], 'message/view', '\App\Http\Controllers\Admin\MessageController@dataView');
    Route::match(['get', 'post'], 'message/edit', '\App\Http\Controllers\Admin\MessageController@dataEdit');
    Route::match(['get', 'post'], 'message/add', '\App\Http\Controllers\Admin\MessageController@dataAdd');
    Route::match(['get', 'post'], 'message/delete', '\App\Http\Controllers\Admin\MessageController@dataDelete');

    Route::match(['get', 'post'], 'background/list', '\App\Http\Controllers\Admin\BackgroundController@dataList');
    Route::match(['get', 'post'], 'background/view', '\App\Http\Controllers\Admin\BackgroundController@dataView');
    Route::match(['get', 'post'], 'background/edit', '\App\Http\Controllers\Admin\BackgroundController@dataEdit');
    Route::match(['get', 'post'], 'background/add', '\App\Http\Controllers\Admin\BackgroundController@dataAdd');
    Route::match(['get', 'post'], 'background/delete', '\App\Http\Controllers\Admin\BackgroundController@dataDelete');

    Route::match(['get', 'post'], 'super_page/list', '\App\Http\Controllers\Admin\SuperPageController@dataList');
    Route::match(['get', 'post'], 'super_page/view', '\App\Http\Controllers\Admin\SuperPageController@dataView');
    Route::match(['get', 'post'], 'super_page/edit', '\App\Http\Controllers\Admin\SuperPageController@dataEdit');
    Route::match(['get', 'post'], 'super_page/add', '\App\Http\Controllers\Admin\SuperPageController@dataAdd');
    Route::match(['get', 'post'], 'super_page/delete', '\App\Http\Controllers\Admin\SuperPageController@dataDelete');
    Route::match(['get', 'post'], 'super_page/manage/{id}', '\App\Http\Controllers\Admin\SuperPageController@manage');
    Route::match(['get', 'post'], 'super_page/manage/{id}/edit/{itemType}/{itemId?}', '\App\Http\Controllers\Admin\SuperPageController@manageEdit');
    Route::match(['get', 'post'], 'super_page/manage/{id}/delete/{itemId}', '\App\Http\Controllers\Admin\SuperPageController@manageDelete');
    Route::match(['get', 'post'], 'super_page/manage/{id}/up/{itemId}', '\App\Http\Controllers\Admin\SuperPageController@manageUp');
    Route::match(['get', 'post'], 'super_page/manage/{id}/down/{itemId}', '\App\Http\Controllers\Admin\SuperPageController@manageDown');

});
