<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNews extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('news', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->string('title', 100)->nullable()->comment('标题');
            $table->string('keywords', 100)->nullable()->comment('关键词');
            $table->string('description', 100)->nullable()->comment('描述');
            $table->string('cover', 100)->nullable()->comment('封面');

            $table->integer('click')->nullable()->comment('点击数');

            $table->text('content')->nullable()->comment('内容');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
}
