@extends('admin::frame')

@section('pageTitle','模版设置')

@section('headAppend')
    @parent
    <link rel="stylesheet" href="@assets('assets/vue/iview/iview.css')">
    <script src="@assets('assets/vue/iview/iview.js')"></script>
    <style>
        .admin-content .admin-content-body{overflow:visible;}
    </style>
@endsection

@section('bodyAppend')
    @parent
    <script>
        var app = new Vue({
            el: '#app',
            data: {
                siteTemplates:[
                    {label:'默认模版',value:'default'},
                    {label:'模版2',value:'template2'},
                ],
                data:{
                    siteTemplate: {!! json_encode(\Edwin404\Config\Facades\ConfigFacade::get('siteTemplate', 'default')) !!},
                    siteTemplateColorPrimary: {!! json_encode(\Edwin404\Config\Facades\ConfigFacade::get('siteTemplateColorPrimary', '')) !!},
                    siteTemplateCustomHeadPrimary: {!! json_encode(\Edwin404\Config\Facades\ConfigFacade::get('siteTemplateCustomHeadPrimary', '')) !!},
                    siteTemplateCustomHeadSecondary: {!! json_encode(\Edwin404\Config\Facades\ConfigFacade::get('siteTemplateCustomHeadSecondary', '')) !!},
                }
            },
            methods: {
                init: function () {

                },
                doSubmit: function () {
                    window.api.dialog.loadingOn();
                    window.api.base.post('?',this.data,function (res) {
                        window.api.dialog.loadingOff();
                        window.api.base.defaultFormCallback(res);
                    })
                }
            },
            mounted: function () {
                var me = this;
                setTimeout(function () {
                    me.init();
                }, 100);
            }
        });
    </script>
@endsection

@section('bodyContent')


    <div id="app" v-cloak>
        <div class="block admin-form">
            <div class="body">
                <i-form :label-width="100" @submit.native.prevent>
                    <form-item label="网站模版">
                        <i-select v-model="data.siteTemplate" style="width:200px">
                            <i-option v-for="(item,itemIndex) in siteTemplates" :value="item.value" :key="item.value">@{{ item.label }}</i-option>
                        </i-select>
                    </form-item>
                    <form-item label="网站主色调">
                        <color-picker v-model="data.siteTemplateColorPrimary" />
                    </form-item>
                    <form-item v-if="data.siteTemplate=='default'" label="网站头部文字1">
                        <i-input v-model="data.siteTemplateCustomHeadPrimary" />
                    </form-item>
                    <form-item v-if="data.siteTemplate=='default'" label="网站头部文字2">
                        <i-input v-model="data.siteTemplateCustomHeadSecondary" />
                    </form-item>
                    <form-item>
                        <i-button type="primary" @click="doSubmit">保存</i-button>
                    </form-item>
                </i-form>
            </div>
        </div>
    </div>


@endsection
