@extends('admin::frame')

@section('pageTitle','后台首页')

@section('adminScript')
    @parent
    @include('admin.version')
@endsection

@section('bodyContent')

    @include('admin.demo')

    <div class="uk-grid">
        <div class="uk-width-1-5">
            <div class="admin-block-stat">
                <div class="icon green">
                    <i class="uk-icon-users"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\ProductController@dataList')}}">
                    {{number_format(\Edwin404\Base\Support\ModelHelper::count('product'))}}
                </a>
                <div class="name">
                    产品总数
                </div>
            </div>
        </div>
        <div class="uk-width-1-5">
            <div class="admin-block-stat">
                <div class="icon red">
                    <i class="uk-icon-list"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\ProductCategoryController@dataList')}}">
                    {{number_format(\Edwin404\Base\Support\ModelHelper::count('product_category'))}}
                </a>
                <div class="name">
                    产品分类
                </div>
            </div>
        </div>
        <div class="uk-width-1-5">
            <div class="admin-block-stat">
                <div class="icon dark">
                    <i class="uk-icon-th"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\NewsController@dataList')}}">
                    {{number_format(\Edwin404\Base\Support\ModelHelper::count('news'))}}
                </a>
                <div class="name">
                    新闻资讯
                </div>
            </div>
        </div>
        <div class="uk-width-1-5">
            <div class="admin-block-stat">
                <div class="icon green">
                    <i class="uk-icon-server"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\JobController@dataList')}}">
                    {{number_format(\Edwin404\Base\Support\ModelHelper::count('job'))}}
                </a>
                <div class="name">
                    招聘信息
                </div>
            </div>
        </div>
        <div class="uk-width-1-5">
            <div class="admin-block-stat">
                <div class="icon blue">
                    <i class="uk-icon-comment"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\PartnerController@dataList')}}">
                    {{number_format(\Edwin404\Base\Support\ModelHelper::count('partner'))}}
                </a>
                <div class="name">
                    友情链接
                </div>
            </div>
        </div>
        <div class="uk-width-1-5">
            <div class="admin-block-stat">
                <div class="icon blue">
                    <i class="uk-icon-list"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\BookController@dataList')}}">
                    {{number_format(\Edwin404\Base\Support\ModelHelper::count('book'))}}
                </a>
                <div class="name">
                    预约信息
                </div>
            </div>
        </div>
        <div class="uk-width-1-5">
            <div class="admin-block-stat">
                <div class="icon blue">
                    <i class="uk-icon-comments"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\MessageController@dataList')}}">
                    {{number_format(\Edwin404\Base\Support\ModelHelper::count('message'))}}
                </a>
                <div class="name">
                    留言信息
                </div>
            </div>
        </div>
    </div>

    @include('admin.copyright')

@endsection
