@extends('admin::frame')

@section('pageTitle','页面设置')

@section('headAppend')
    @parent
    <link rel="stylesheet" href="@assets('theme/default/css/style.css')">
    <style type="text/css">

    </style>
@endsection

@section('bodyContent')

    <div class="block">
        <div class="head">页面信息</div>
        <div class="body">
            <table>
                <tbody>
                <tr>
                    <td>名称：</td>
                    <td>{{$superPage['title']}}</td>
                </tr>
                <tr>
                    <td>链接：</td>
                    <td>
                        @if('/'==$superPage['url'])
                            <a href="{{$superPage['url']}}" target="_blank">{{$superPage['url']}}</a>
                        @else
                            <a href="/p{{$superPage['url']}}" target="_blank">/p{{$superPage['url']}}</a>
                        @endif
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div class="block">
        <div class="head">页面内容</div>
        <div class="body">
            <table style="width:100%;">
                <tbody>
                @foreach($superPageItems as $superPageItem)
                    <tr>
                        <td>
                            @include('theme.superPage.'.$superPageItem['type'].'.preview',['content'=>$superPageItem['content'],'id'=>$superPageItem['id']])
                        </td>
                        <td width="200" valign="top">
                            <div>
                                <a class="uk-button uk-button-small" href="{{action('\App\Http\Controllers\Admin\SuperPageController@manageEdit',['id'=>$superPage['id'],'itemType'=>$superPageItem['type'],'itemId'=>$superPageItem['id']])}}"><i class="uk-icon-edit"></i> 修改页面</a>
                                <a class="uk-button uk-button-small" href="javascript:;" data-confirm="确定删除？" data-href="{{action('\App\Http\Controllers\Admin\SuperPageController@manageDelete',['id'=>$superPage['id'],'itemId'=>$superPageItem['id']])}}"><i class="uk-icon-trash"></i> 删除</a>
                            </div>
                            <div class="uk-margin-top">
                                <a class="uk-button uk-button-small" href="{{action('\App\Http\Controllers\Admin\SuperPageController@manageUp',['id'=>$superPage['id'],'itemId'=>$superPageItem['id']])}}"><i class="uk-icon-angle-up"></i> 向上</a>
                                <a class="uk-button uk-button-small" href="{{action('\App\Http\Controllers\Admin\SuperPageController@manageDown',['id'=>$superPage['id'],'itemId'=>$superPageItem['id']])}}"><i class="uk-icon-angle-down"></i> 向下</a>
                            </div>
                        </td>
                    </tr>
                @endforeach
                    <tr>
                        <td colspan="2">
                            <a href="#add-dialog" data-uk-modal><i class="uk-icon-plus"></i> 增加页面</a>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div id="add-dialog" class="uk-modal">
        <div class="uk-modal-dialog">
            <a class="uk-modal-close uk-close"></a>
            <div style="padding-top:20px;">
                @foreach(\Edwin404\Base\Support\FileHelper::listFiles(base_path('resources/views/theme/superPage/')) as $file)
                    <div>
                        <a href="{{action('\App\Http\Controllers\Admin\SuperPageController@manageEdit',['id'=>$superPage['id'],'itemType'=>$file['filename']])}}">
                            @include('theme.superPage.'.$file['filename'].'.view')
                        </a>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

@endsection
