@extends('admin::frameDialog')

@section('pageTitle','选择链接')

@section('headAppend')
    @parent
    <style type="text/css">
        .link-item{cursor:pointer;border:1px solid #EEE;border-radius:3px;line-height:30px;padding:0 10px;margin:5px 0;}
        .link-item:hover{border-color:#EE6A2B;}
    </style>
@endsection

@section('bodyAppend')
    @parent
    <script>
        $(function () {
            var doConfirm = function(link){
                parent.__commonSelectDialogItems = [link];
                parent.__commonSelectDialogItems_ = [link];
                parent.__commonSelectDialog.close();
            };
            $(document).on('click','.link-item',function () {
                var link = $(this).attr('data-link');
                doConfirm(link)
                return false;
            })
            $('[data-link-comfirm]').on('click',function () {
                var link = $('[name="link"]').val()
                doConfirm(link)
                return false;
            })
        });
    </script>
@endsection

@section('dialogBody')

    <div style="padding:10px;">
        <div class="block">
            <div class="body">
                <ul class="uk-subnav uk-subnav-pill" data-uk-switcher="{connect:'#link-contents'}">
                    <li class="uk-active"><a href="javascript:;">系统链接</a></li>
                    <li><a href="javascript:;">超级页面</a></li>
                    <li><a href="javascript:;">自定义链接</a></li>
                </ul>

                <div id="link-contents" class="uk-switcher">
                    <div class="uk-active">
                        <div class="link-item" data-link="/">首页：<code>/</code></div>
                        <div class="link-item" data-link="/product">产品列表：<code>/product</code></div>
                        <div class="link-item" data-link="/news">新闻列表：<code>/news</code></div>
                        <div class="link-item" data-link="/contact">联系我们：<code>/contact</code></div>
                        <div class="link-item" data-link="/about">关于我们：<code>/about</code></div>
                        <div class="link-item" data-link="/job">招聘：<code>/job</code></div>
                        <div class="link-item" data-link="javascript:window.api.book.show()">预约弹窗：<code>javascript:window.api.book.show()</code></div>
                    </div>
                    <div>
                        <?php
                            $superPages = \Edwin404\Base\Support\ModelHelper::find('super_page');
                            foreach ($superPages as $i=>$superPage) {
                                $superPages[$i]['_items'] = \Edwin404\Base\Support\ModelHelper::find('super_page_item',['pageId'=>$superPage['id']],['sort','asc']);
                            }
                        ?>
                        @foreach($superPages as $superPage)
                            @if('/'!=$superPage['url'])
                                <div class="link-item" data-link="/p{{$superPage['url']}}">{{$superPage['title']}}：<code>/p{{$superPage['url']}}</code></div>
                            @endif
                        @endforeach
                    </div>
                    <div class="uk-form">
                        <div class="uk-grid">
                            <div class="uk-width-3-4">
                                <input type="text" name="link" class="uk-width-1-1" />
                            </div>
                            <div class="uk-width-1-4">
                                <button class="uk-button" data-link-comfirm>确认</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

@endsection
