@extends($_frameLayoutView)

@section('pageTitle','招聘中心 - '.\Edwin404\Config\Facades\ConfigFacade::get('siteName'))
@section('pageKeywords','招聘中心,'.\Edwin404\Config\Facades\ConfigFacade::get('siteKeywords'))
@section('pageDescription','招聘中心,'.\Edwin404\Config\Facades\ConfigFacade::get('siteDescription'))

@section('body')

    @include(\Edwin404\Tecmz\View\TemplateUtil::view('pc.header'),['mini'=>true])

    <div class="pb-page-background">
        <div class="background"
             style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($background['url'])}})">
            <div class="title">招聘中心</div>
        </div>
    </div>

    <div class="pb-job-list">
        <div class="pb-container">
            @if(count($jobs))
                @foreach($jobs as $job)
                    <a class="item" href="/job/{{$job['id']}}">
                        <div class="date">
                            {{\Carbon\Carbon::parse($job['created_at'])->toDateString()}}
                        </div>
                        <div class="title uk-text-truncate">
                            {{$job['title']}}
                        </div>
                    </a>
                @endforeach
                <div class="pb-page">
                    <div class="page-container">
                        {!! $pageHtml !!}
                    </div>
                </div>
            @else
                <div class="pb-empty">暂无内容</div>
            @endif
        </div>
    </div>

    @include('theme.default.pc.footer')

    @if(\Edwin404\Config\Facades\ConfigFacade::get('moduleBookEnable',false))
        @include('theme.default.pc.book')
    @endif

@endsection
