@extends($_frameLayoutView)

@section('pageTitle','新闻中心 - '.\Edwin404\Config\Facades\ConfigFacade::get('siteName'))
@section('pageKeywords','新闻中心,'.\Edwin404\Config\Facades\ConfigFacade::get('siteKeywords'))
@section('pageDescription','新闻中心,'.\Edwin404\Config\Facades\ConfigFacade::get('siteDescription'))

@section('body')

    @include(\Edwin404\Tecmz\View\TemplateUtil::view('pc.header'),['mini'=>true])

    <div class="pb-page-background">
        <div class="background"
             style="background-image:url({{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($background['url'])}})">
            <div class="title">新闻中心</div>
        </div>
    </div>

    <div class="pb-news-list">
        <div class="pb-container">
            @if(count($newses))
                <div class="uk-grid">
                    @foreach($newses as $news)
                        <div class="uk-width-medium-1-3">
                            <a class="item" href="/news/{{$news['id']}}">
                                <div class="cover t-item-ratio-5-3" data-src="{{\Edwin404\SmartAssets\Helper\AssetsHelper::fix($news['cover'])}}"></div>
                                <div class="info">
                                    <div class="title uk-text-truncate">
                                        {{$news['title']}}
                                    </div>
                                    <div class="desc">
                                        {{$news['description']}}
                                    </div>
                                </div>
                            </a>
                        </div>
                    @endforeach
                </div>
                <div class="pb-page">
                    <div class="page-container">
                        {!! $pageHtml !!}
                    </div>
                </div>
            @else
                <div class="pb-empty">暂无内容</div>
            @endif
        </div>
    </div>

    @include('theme.default.pc.footer')

    @if(\Edwin404\Config\Facades\ConfigFacade::get('moduleBookEnable',false))
        @include('theme.default.pc.book')
    @endif

@endsection
